/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive.authentication.crypto;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.security.KeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.interfaces.DHPublicKey;
import org.apache.commons.codec.binary.Base64;
import org.objectweb.proactive.annotation.PublicAPI;
import org.objectweb.proactive.core.util.converter.ByteToObjectConverter;
import org.objectweb.proactive.core.util.converter.ObjectToByteConverter;
import org.ow2.proactive.authentication.crypto.CredData;
import org.ow2.proactive.authentication.crypto.HybridEncryptionUtil;

@PublicAPI
public class Credentials
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String DEFAULT_CREDS = System.getProperty("user.home") + File.separator + ".proactive" + File.separator + "security" + File.separator + "creds.enc";
    public static final String credentialsPathProperty = "pa.common.auth.credentials";
    public static final String pubkeyPathProperty = "pa.common.auth.pubkey";
    private String algorithm;
    private int size;
    private String cipher;
    private byte[] data;
    private byte[] aes;

    private Credentials(String algo, int size, String cipher, byte[] aes, byte[] data) {
        this.algorithm = algo;
        this.size = size;
        this.cipher = cipher;
        this.aes = aes;
        this.data = data;
    }

    public void writeToDisk(String path) throws KeyException {
        File f = new File(path);
        try (FileOutputStream fs = new FileOutputStream(f);){
            fs.write(this.getBase64());
        }
        catch (Exception e) {
            throw new KeyException("Could not write credentials to " + path, e);
        }
    }

    public static PublicKey getPublicKey(String pubPath) throws KeyException {
        PublicKey pubKey;
        KeyFactory keyFactory;
        byte[] bytes;
        String algo = "";
        String tmp = "";
        File f = new File(pubPath);
        try (DataInputStream in = new DataInputStream(new FileInputStream(f));){
            int read;
            int tot = 0;
            while ((read = in.read()) != 10) {
                algo = algo + (char)read;
                ++tot;
            }
            ++tot;
            while ((read = in.read()) != 10) {
                tmp = tmp + (char)read;
                ++tot;
            }
            bytes = new byte[(int)f.length() - ++tot];
            in.readFully(bytes);
        }
        catch (Exception e) {
            throw new KeyException("Could not retrieve public key from " + pubPath, e);
        }
        X509EncodedKeySpec pubKeySpec = new X509EncodedKeySpec(bytes);
        try {
            keyFactory = KeyFactory.getInstance(algo);
        }
        catch (NoSuchAlgorithmException e) {
            throw new KeyException("Cannot initialize key factory", e);
        }
        try {
            pubKey = keyFactory.generatePublic(pubKeySpec);
        }
        catch (InvalidKeySpecException e) {
            throw new KeyException("Cannot re-generate public key", e);
        }
        return pubKey;
    }

    public static PrivateKey getPrivateKey(String privPath) throws KeyException {
        return Credentials.getPrivateKey(privPath, new String[]{"RSA", "DSA"});
    }

    public static PrivateKey getPrivateKey(String privPath, String[] algorithms) throws KeyException {
        PrivateKey privKey = null;
        for (String algo : algorithms) {
            try {
                byte[] bytes;
                KeyFactory keyFactory = KeyFactory.getInstance(algo);
                File pkFile = new File(privPath);
                try (DataInputStream pkStream = new DataInputStream(new FileInputStream(pkFile));){
                    bytes = new byte[(int)pkFile.length()];
                    pkStream.readFully(bytes);
                }
                catch (Exception e) {
                    throw new KeyException("Could not recover private key (algo=" + algo + ")", e);
                }
                PKCS8EncodedKeySpec privKeySpec = new PKCS8EncodedKeySpec(bytes);
                try {
                    privKey = keyFactory.generatePrivate(privKeySpec);
                }
                catch (InvalidKeySpecException e) {
                    throw new KeyException("Cannot re-generate private key  (algo=" + algo + ")", e);
                }
            }
            catch (Exception keyFactory) {
                // empty catch block
            }
        }
        if (privKey == null) {
            String str = "Could not generate Private Key (algorithms: ";
            for (String algo : algorithms) {
                str = str + algo + " ";
            }
            str = str + ")";
            throw new KeyException(str);
        }
        return privKey;
    }

    public static Credentials getCredentials() throws KeyException {
        return Credentials.getCredentials(Credentials.getCredentialsPath());
    }

    public static Credentials getCredentials(String path) throws KeyException {
        File f = new File(path);
        byte[] bytes = new byte[(int)f.length()];
        try (FileInputStream fin = new FileInputStream(f);){
            fin.read(bytes);
        }
        catch (Exception e) {
            throw new KeyException("Could not read credentials from " + path, e);
        }
        return Credentials.getCredentialsBase64(bytes);
    }

    public static Credentials getCredentials(InputStream is) throws KeyException, IOException {
        int len;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        while ((len = is.read(buf)) > 0) {
            out.write(buf, 0, len);
        }
        byte[] bytes = out.toByteArray();
        out.close();
        return Credentials.getCredentialsBase64(bytes);
    }

    public static Credentials getCredentialsBase64(byte[] base64enc) throws KeyException {
        byte[] data;
        byte[] aes;
        int size;
        byte[] asciiEnc;
        String algo = "";
        String cipher = "";
        String tmp = "";
        try {
            asciiEnc = Base64.decodeBase64((byte[])base64enc);
        }
        catch (Exception e) {
            throw new KeyException("Unable to decode base64 credentials", e);
        }
        try {
            int read;
            DataInputStream in = new DataInputStream(new ByteArrayInputStream(asciiEnc));
            int tot = 0;
            while ((read = in.read()) != 10) {
                if (read == -1) {
                    throw new KeyException("Failed to parse malformed credentials");
                }
                algo = algo + (char)read;
                ++tot;
            }
            ++tot;
            while ((read = in.read()) != 10) {
                if (read == -1) {
                    throw new KeyException("Failed to parse malformed credentials");
                }
                tmp = tmp + (char)read;
                ++tot;
            }
            ++tot;
            size = Integer.parseInt(tmp);
            while ((read = in.read()) != 10) {
                if (read == -1) {
                    throw new KeyException("Failed to parse malformed credentials");
                }
                cipher = cipher + (char)read;
                ++tot;
            }
            ++tot;
            aes = new byte[size / 8];
            for (int i = 0; i < size / 8; ++i) {
                aes[i] = (byte)in.read();
                ++tot;
            }
            data = new byte[asciiEnc.length - tot];
            in.readFully(data);
        }
        catch (Exception e) {
            throw new KeyException("Could not decode credentials", e);
        }
        return new Credentials(algo, size, cipher, aes, data);
    }

    public byte[] getBase64() throws KeyException {
        byte[] ret;
        ByteArrayOutputStream b = new ByteArrayOutputStream();
        try {
            b.write((this.algorithm + '\n').getBytes());
            b.write(("" + this.size + '\n').getBytes());
            b.write((this.cipher + '\n').getBytes());
            b.write(this.aes);
            b.write(this.data);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            ret = Base64.encodeBase64((byte[])b.toByteArray());
        }
        catch (Exception e) {
            throw new KeyException("Unable to encode credentials to base64", e);
        }
        return ret;
    }

    public static String getCredentialsPath() {
        String path = System.getProperty(credentialsPathProperty);
        if (path == null) {
            path = DEFAULT_CREDS;
        }
        return path;
    }

    public static String getPubKeyPath() {
        String path = System.getProperty(pubkeyPathProperty);
        if (path == null) {
            String DEFAULT_PUBKEY = System.getProperty("user.home") + File.separator + ".proactive" + File.separator + "security" + File.separator + "pub.key";
            File home = new File(DEFAULT_CREDS).getParentFile();
            if (!home.isDirectory()) {
                home.mkdirs();
            }
            if (!(home = new File(DEFAULT_PUBKEY).getParentFile()).isDirectory()) {
                home.mkdirs();
            }
            path = DEFAULT_PUBKEY;
        }
        return path;
    }

    public static Credentials createCredentials(CredData cc, String pubPath) throws KeyException {
        PublicKey pubKey = Credentials.getPublicKey(pubPath);
        return Credentials.createCredentials(cc, pubKey);
    }

    public static Credentials createCredentials(CredData cc, PublicKey pubKey) throws KeyException {
        return Credentials.createCredentials(cc, pubKey, "RSA/ECB/PKCS1Padding");
    }

    public static Credentials createCredentials(CredData cc, PublicKey pubKey, String cipher) throws KeyException {
        byte[] clearCred;
        try {
            clearCred = ObjectToByteConverter.ObjectStream.convert((Object)cc);
        }
        catch (IOException e1) {
            throw new KeyException(e1.getMessage());
        }
        HybridEncryptionUtil.HybridEncryptedData encryptedData = HybridEncryptionUtil.encrypt(pubKey, cipher, clearCred);
        byte[] encAes = encryptedData.getEncryptedSymmetricKey();
        byte[] encData = encryptedData.getEncryptedData();
        int size = Credentials.keySize(pubKey);
        return new Credentials(pubKey.getAlgorithm(), size, cipher, encAes, encData);
    }

    public CredData decrypt(String privPath) throws KeyException {
        PrivateKey privKey = Credentials.getPrivateKey(privPath, new String[]{this.algorithm});
        return this.decrypt(privKey);
    }

    public CredData decrypt(PrivateKey privKey) throws KeyException {
        byte[] decryptedData = HybridEncryptionUtil.decrypt(privKey, this.cipher, new HybridEncryptionUtil.HybridEncryptedData(this.aes, this.data));
        try {
            return (CredData)ByteToObjectConverter.ObjectStream.convert((byte[])decryptedData);
        }
        catch (Exception e) {
            throw new KeyException(e.getMessage());
        }
    }

    public String toString() {
        return "[" + this.algorithm + " " + this.size + "b " + this.cipher + "]";
    }

    @Deprecated
    public static Credentials createCredentials(String login, String password, String pubPath) throws KeyException {
        return Credentials.createCredentials(login, password, pubPath, "RSA/ECB/PKCS1Padding");
    }

    @Deprecated
    public static Credentials createCredentials(String login, String password, PublicKey pubKey) throws KeyException {
        return Credentials.createCredentials(login, password, null, pubKey, "RSA/ECB/PKCS1Padding");
    }

    @Deprecated
    public static Credentials createCredentials(String login, String password, String pubPath, String cipher) throws KeyException {
        PublicKey pubKey = Credentials.getPublicKey(pubPath);
        return Credentials.createCredentials(login, password, null, pubKey, cipher);
    }

    @Deprecated
    public static Credentials createCredentials(String login, String password, byte[] datakey, PublicKey pubKey, String cipher) throws KeyException {
        byte[] clearCred;
        CredData cc = new CredData();
        cc.setLogin(CredData.parseLogin(login));
        cc.setDomain(CredData.parseDomain(login));
        cc.setPassword(password);
        cc.setKey(datakey);
        try {
            clearCred = ObjectToByteConverter.ObjectStream.convert((Object)cc);
        }
        catch (IOException e1) {
            throw new KeyException(e1.getMessage());
        }
        int size = Credentials.keySize(pubKey);
        HybridEncryptionUtil.HybridEncryptedData encryptedData = HybridEncryptionUtil.encrypt(pubKey, cipher, clearCred);
        byte[] encAes = encryptedData.getEncryptedSymmetricKey();
        byte[] encData = encryptedData.getEncryptedData();
        return new Credentials(pubKey.getAlgorithm(), size, cipher, encAes, encData);
    }

    private static int keySize(PublicKey pubKey) {
        int size = -1;
        if (pubKey instanceof RSAPublicKey) {
            size = ((RSAPublicKey)pubKey).getModulus().bitLength();
        } else if (pubKey instanceof DSAPublicKey) {
            size = ((DSAPublicKey)pubKey).getParams().getP().bitLength();
        } else if (pubKey instanceof DHPublicKey) {
            size = ((DHPublicKey)pubKey).getParams().getP().bitLength();
        }
        return size;
    }
}

