/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.proactive.core;

import java.io.Serializable;
import java.rmi.dgc.VMID;
import java.rmi.server.UID;
import org.objectweb.proactive.annotation.PublicAPI;

@PublicAPI
public class UniqueID
implements Serializable,
Comparable<UniqueID> {
    private static final long serialVersionUID = 1L;
    private UID id = new UID();
    private VMID vmID = uniqueVMID;
    private String identifier;
    private static VMID uniqueVMID = new VMID();
    private transient String cachedShortString;
    private transient String cachedCanonString;

    public UniqueID(String identifier) {
        this();
        this.identifier = identifier;
    }

    public UniqueID() {
    }

    public static VMID getCurrentVMID() {
        return uniqueVMID;
    }

    public VMID getVMID() {
        return this.vmID;
    }

    public UID getUID() {
        return this.id;
    }

    public String toString() {
        return this.getCanonString();
    }

    public String shortString() {
        String s = this.cachedShortString;
        if (s == null) {
            this.cachedShortString = s = (this.identifier != null ? this.identifier : "") + Math.abs(this.getCanonString().hashCode() % 100000);
        }
        return s;
    }

    public String getCanonString() {
        String s = this.cachedCanonString;
        if (s == null) {
            this.cachedCanonString = s = ((this.identifier != null ? this.identifier : "") + this.id + "--" + this.vmID).replace(':', '-');
        }
        return s;
    }

    @Override
    public int compareTo(UniqueID u) {
        return this.getCanonString().compareTo(u.getCanonString());
    }

    public int hashCode() {
        return this.id.hashCode() + this.vmID.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof UniqueID) {
            return this.id.equals(((UniqueID)o).getUID()) && this.vmID.equals(((UniqueID)o).getVMID());
        }
        return false;
    }

    public void echo() {
        System.out.println("UniqueID The Id is " + this.id + " and the address is " + this.vmID);
    }
}

