import sys

class Tee(object):
	"""
	Copy the standard output to a file, but continue to write it to
	stdout.
	"""
	def __init__(self, name, mode):
		self.file = open(name, mode)
		self.stdout = sys.stdout
		sys.stdout = self
	def __del__(self):
		sys.stdout = self.stdout
		self.file.close()
	def write(self, data):
		self.file.write(data)
		self.stdout.write(data)

