# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Dict, List, Optional, Union

from azure.core.exceptions import HttpResponseError
import msrest.serialization

from ._monitor_client_enums import *


class AutoscaleNotification(msrest.serialization.Model):
    """Autoscale notification.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar operation: Required. the operation associated with the notification and its value must be
     "scale". Default value: "Scale".
    :vartype operation: str
    :param email: the email notification.
    :type email: ~$(python-base-namespace).v2015_04_01.models.EmailNotification
    :param webhooks: the collection of webhook notifications.
    :type webhooks: list[~$(python-base-namespace).v2015_04_01.models.WebhookNotification]
    """

    _validation = {
        'operation': {'required': True, 'constant': True},
    }

    _attribute_map = {
        'operation': {'key': 'operation', 'type': 'str'},
        'email': {'key': 'email', 'type': 'EmailNotification'},
        'webhooks': {'key': 'webhooks', 'type': '[WebhookNotification]'},
    }

    operation = "Scale"

    def __init__(
        self,
        *,
        email: Optional["EmailNotification"] = None,
        webhooks: Optional[List["WebhookNotification"]] = None,
        **kwargs
    ):
        super(AutoscaleNotification, self).__init__(**kwargs)
        self.email = email
        self.webhooks = webhooks


class AutoscaleProfile(msrest.serialization.Model):
    """Autoscale profile.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. the name of the profile.
    :type name: str
    :param capacity: Required. the number of instances that can be used during this profile.
    :type capacity: ~$(python-base-namespace).v2015_04_01.models.ScaleCapacity
    :param rules: Required. the collection of rules that provide the triggers and parameters for
     the scaling action. A maximum of 10 rules can be specified.
    :type rules: list[~$(python-base-namespace).v2015_04_01.models.ScaleRule]
    :param fixed_date: the specific date-time for the profile. This element is not used if the
     Recurrence element is used.
    :type fixed_date: ~$(python-base-namespace).v2015_04_01.models.TimeWindow
    :param recurrence: the repeating times at which this profile begins. This element is not used
     if the FixedDate element is used.
    :type recurrence: ~$(python-base-namespace).v2015_04_01.models.Recurrence
    """

    _validation = {
        'name': {'required': True},
        'capacity': {'required': True},
        'rules': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'capacity': {'key': 'capacity', 'type': 'ScaleCapacity'},
        'rules': {'key': 'rules', 'type': '[ScaleRule]'},
        'fixed_date': {'key': 'fixedDate', 'type': 'TimeWindow'},
        'recurrence': {'key': 'recurrence', 'type': 'Recurrence'},
    }

    def __init__(
        self,
        *,
        name: str,
        capacity: "ScaleCapacity",
        rules: List["ScaleRule"],
        fixed_date: Optional["TimeWindow"] = None,
        recurrence: Optional["Recurrence"] = None,
        **kwargs
    ):
        super(AutoscaleProfile, self).__init__(**kwargs)
        self.name = name
        self.capacity = capacity
        self.rules = rules
        self.fixed_date = fixed_date
        self.recurrence = recurrence


class Resource(msrest.serialization.Model):
    """An azure resource object.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Azure resource Id.
    :vartype id: str
    :ivar name: Azure resource name.
    :vartype name: str
    :ivar type: Azure resource type.
    :vartype type: str
    :param location: Required. Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = location
        self.tags = tags


class AutoscaleSettingResource(Resource):
    """The autoscale setting resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Azure resource Id.
    :vartype id: str
    :ivar name: Azure resource name.
    :vartype name: str
    :ivar type: Azure resource type.
    :vartype type: str
    :param location: Required. Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param profiles: Required. the collection of automatic scaling profiles that specify different
     scaling parameters for different time periods. A maximum of 20 profiles can be specified.
    :type profiles: list[~$(python-base-namespace).v2015_04_01.models.AutoscaleProfile]
    :param notifications: the collection of notifications.
    :type notifications: list[~$(python-base-namespace).v2015_04_01.models.AutoscaleNotification]
    :param enabled: the enabled flag. Specifies whether automatic scaling is enabled for the
     resource. The default value is 'true'.
    :type enabled: bool
    :param name_properties_name: the name of the autoscale setting.
    :type name_properties_name: str
    :param target_resource_uri: the resource identifier of the resource that the autoscale setting
     should be added to.
    :type target_resource_uri: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'profiles': {'required': True, 'max_items': 20, 'min_items': 0},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'profiles': {'key': 'properties.profiles', 'type': '[AutoscaleProfile]'},
        'notifications': {'key': 'properties.notifications', 'type': '[AutoscaleNotification]'},
        'enabled': {'key': 'properties.enabled', 'type': 'bool'},
        'name_properties_name': {'key': 'properties.name', 'type': 'str'},
        'target_resource_uri': {'key': 'properties.targetResourceUri', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: str,
        profiles: List["AutoscaleProfile"],
        tags: Optional[Dict[str, str]] = None,
        notifications: Optional[List["AutoscaleNotification"]] = None,
        enabled: Optional[bool] = True,
        name_properties_name: Optional[str] = None,
        target_resource_uri: Optional[str] = None,
        **kwargs
    ):
        super(AutoscaleSettingResource, self).__init__(location=location, tags=tags, **kwargs)
        self.profiles = profiles
        self.notifications = notifications
        self.enabled = enabled
        self.name_properties_name = name_properties_name
        self.target_resource_uri = target_resource_uri


class AutoscaleSettingResourceCollection(msrest.serialization.Model):
    """Represents a collection of autoscale setting resources.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. the values for the autoscale setting resources.
    :type value: list[~$(python-base-namespace).v2015_04_01.models.AutoscaleSettingResource]
    :param next_link: URL to get the next set of results.
    :type next_link: str
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[AutoscaleSettingResource]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["AutoscaleSettingResource"],
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(AutoscaleSettingResourceCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class AutoscaleSettingResourcePatch(msrest.serialization.Model):
    """The autoscale setting object for patch operations.

    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param profiles: the collection of automatic scaling profiles that specify different scaling
     parameters for different time periods. A maximum of 20 profiles can be specified.
    :type profiles: list[~$(python-base-namespace).v2015_04_01.models.AutoscaleProfile]
    :param notifications: the collection of notifications.
    :type notifications: list[~$(python-base-namespace).v2015_04_01.models.AutoscaleNotification]
    :param enabled: the enabled flag. Specifies whether automatic scaling is enabled for the
     resource. The default value is 'true'.
    :type enabled: bool
    :param name: the name of the autoscale setting.
    :type name: str
    :param target_resource_uri: the resource identifier of the resource that the autoscale setting
     should be added to.
    :type target_resource_uri: str
    """

    _validation = {
        'profiles': {'max_items': 20, 'min_items': 0},
    }

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'profiles': {'key': 'properties.profiles', 'type': '[AutoscaleProfile]'},
        'notifications': {'key': 'properties.notifications', 'type': '[AutoscaleNotification]'},
        'enabled': {'key': 'properties.enabled', 'type': 'bool'},
        'name': {'key': 'properties.name', 'type': 'str'},
        'target_resource_uri': {'key': 'properties.targetResourceUri', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        profiles: Optional[List["AutoscaleProfile"]] = None,
        notifications: Optional[List["AutoscaleNotification"]] = None,
        enabled: Optional[bool] = True,
        name: Optional[str] = None,
        target_resource_uri: Optional[str] = None,
        **kwargs
    ):
        super(AutoscaleSettingResourcePatch, self).__init__(**kwargs)
        self.tags = tags
        self.profiles = profiles
        self.notifications = notifications
        self.enabled = enabled
        self.name = name
        self.target_resource_uri = target_resource_uri


class EmailNotification(msrest.serialization.Model):
    """Email notification of an autoscale event.

    :param send_to_subscription_administrator: a value indicating whether to send email to
     subscription administrator.
    :type send_to_subscription_administrator: bool
    :param send_to_subscription_co_administrators: a value indicating whether to send email to
     subscription co-administrators.
    :type send_to_subscription_co_administrators: bool
    :param custom_emails: the custom e-mails list. This value can be null or empty, in which case
     this attribute will be ignored.
    :type custom_emails: list[str]
    """

    _attribute_map = {
        'send_to_subscription_administrator': {'key': 'sendToSubscriptionAdministrator', 'type': 'bool'},
        'send_to_subscription_co_administrators': {'key': 'sendToSubscriptionCoAdministrators', 'type': 'bool'},
        'custom_emails': {'key': 'customEmails', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        send_to_subscription_administrator: Optional[bool] = None,
        send_to_subscription_co_administrators: Optional[bool] = None,
        custom_emails: Optional[List[str]] = None,
        **kwargs
    ):
        super(EmailNotification, self).__init__(**kwargs)
        self.send_to_subscription_administrator = send_to_subscription_administrator
        self.send_to_subscription_co_administrators = send_to_subscription_co_administrators
        self.custom_emails = custom_emails


class ErrorResponse(msrest.serialization.Model):
    """Describes the format of Error response.

    :param code: Error code.
    :type code: str
    :param message: Error message indicating why the operation failed.
    :type message: str
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        code: Optional[str] = None,
        message: Optional[str] = None,
        **kwargs
    ):
        super(ErrorResponse, self).__init__(**kwargs)
        self.code = code
        self.message = message


class EventCategoryCollection(msrest.serialization.Model):
    """A collection of event categories. Currently possible values are: Administrative, Security, ServiceHealth, Alert, Recommendation, Policy.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. the list that includes the Azure event categories.
    :type value: list[~$(python-base-namespace).v2015_04_01.models.LocalizableString]
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[LocalizableString]'},
    }

    def __init__(
        self,
        *,
        value: List["LocalizableString"],
        **kwargs
    ):
        super(EventCategoryCollection, self).__init__(**kwargs)
        self.value = value


class EventData(msrest.serialization.Model):
    """The Azure event log entries are of type EventData.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar authorization: The sender authorization information.
    :vartype authorization: ~$(python-base-namespace).v2015_04_01.models.SenderAuthorization
    :ivar claims: key value pairs to identify ARM permissions.
    :vartype claims: dict[str, str]
    :ivar caller: the email address of the user who has performed the operation, the UPN claim or
     SPN claim based on availability.
    :vartype caller: str
    :ivar description: the description of the event.
    :vartype description: str
    :ivar id: the Id of this event as required by ARM for RBAC. It contains the EventDataID and a
     timestamp information.
    :vartype id: str
    :ivar event_data_id: the event data Id. This is a unique identifier for an event.
    :vartype event_data_id: str
    :ivar correlation_id: the correlation Id, usually a GUID in the string format. The correlation
     Id is shared among the events that belong to the same uber operation.
    :vartype correlation_id: str
    :ivar event_name: the event name. This value should not be confused with OperationName. For
     practical purposes, OperationName might be more appealing to end users.
    :vartype event_name: ~$(python-base-namespace).v2015_04_01.models.LocalizableString
    :ivar category: the event category.
    :vartype category: ~$(python-base-namespace).v2015_04_01.models.LocalizableString
    :ivar http_request: the HTTP request info. Usually includes the 'clientRequestId',
     'clientIpAddress' (IP address of the user who initiated the event) and 'method' (HTTP method
     e.g. PUT).
    :vartype http_request: ~$(python-base-namespace).v2015_04_01.models.HttpRequestInfo
    :ivar level: the event level. Possible values include: "Critical", "Error", "Warning",
     "Informational", "Verbose".
    :vartype level: str or ~$(python-base-namespace).v2015_04_01.models.EventLevel
    :ivar resource_group_name: the resource group name of the impacted resource.
    :vartype resource_group_name: str
    :ivar resource_provider_name: the resource provider name of the impacted resource.
    :vartype resource_provider_name: ~$(python-base-namespace).v2015_04_01.models.LocalizableString
    :ivar resource_id: the resource uri that uniquely identifies the resource that caused this
     event.
    :vartype resource_id: str
    :ivar resource_type: the resource type.
    :vartype resource_type: ~$(python-base-namespace).v2015_04_01.models.LocalizableString
    :ivar operation_id: It is usually a GUID shared among the events corresponding to single
     operation. This value should not be confused with EventName.
    :vartype operation_id: str
    :ivar operation_name: the operation name.
    :vartype operation_name: ~$(python-base-namespace).v2015_04_01.models.LocalizableString
    :ivar properties: the set of <Key, Value> pairs (usually a Dictionary<String, String>) that
     includes details about the event.
    :vartype properties: dict[str, str]
    :ivar status: a string describing the status of the operation. Some typical values are:
     Started, In progress, Succeeded, Failed, Resolved.
    :vartype status: ~$(python-base-namespace).v2015_04_01.models.LocalizableString
    :ivar sub_status: the event sub status. Most of the time, when included, this captures the HTTP
     status code of the REST call. Common values are: OK (HTTP Status Code: 200), Created (HTTP
     Status Code: 201), Accepted (HTTP Status Code: 202), No Content (HTTP Status Code: 204), Bad
     Request(HTTP Status Code: 400), Not Found (HTTP Status Code: 404), Conflict (HTTP Status Code:
     409), Internal Server Error (HTTP Status Code: 500), Service Unavailable (HTTP Status
     Code:503), Gateway Timeout (HTTP Status Code: 504).
    :vartype sub_status: ~$(python-base-namespace).v2015_04_01.models.LocalizableString
    :ivar event_timestamp: the timestamp of when the event was generated by the Azure service
     processing the request corresponding the event. It in ISO 8601 format.
    :vartype event_timestamp: ~datetime.datetime
    :ivar submission_timestamp: the timestamp of when the event became available for querying via
     this API. It is in ISO 8601 format. This value should not be confused eventTimestamp. As there
     might be a delay between the occurrence time of the event, and the time that the event is
     submitted to the Azure logging infrastructure.
    :vartype submission_timestamp: ~datetime.datetime
    :ivar subscription_id: the Azure subscription Id usually a GUID.
    :vartype subscription_id: str
    :ivar tenant_id: the Azure tenant Id.
    :vartype tenant_id: str
    """

    _validation = {
        'authorization': {'readonly': True},
        'claims': {'readonly': True},
        'caller': {'readonly': True},
        'description': {'readonly': True},
        'id': {'readonly': True},
        'event_data_id': {'readonly': True},
        'correlation_id': {'readonly': True},
        'event_name': {'readonly': True},
        'category': {'readonly': True},
        'http_request': {'readonly': True},
        'level': {'readonly': True},
        'resource_group_name': {'readonly': True},
        'resource_provider_name': {'readonly': True},
        'resource_id': {'readonly': True},
        'resource_type': {'readonly': True},
        'operation_id': {'readonly': True},
        'operation_name': {'readonly': True},
        'properties': {'readonly': True},
        'status': {'readonly': True},
        'sub_status': {'readonly': True},
        'event_timestamp': {'readonly': True},
        'submission_timestamp': {'readonly': True},
        'subscription_id': {'readonly': True},
        'tenant_id': {'readonly': True},
    }

    _attribute_map = {
        'authorization': {'key': 'authorization', 'type': 'SenderAuthorization'},
        'claims': {'key': 'claims', 'type': '{str}'},
        'caller': {'key': 'caller', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'event_data_id': {'key': 'eventDataId', 'type': 'str'},
        'correlation_id': {'key': 'correlationId', 'type': 'str'},
        'event_name': {'key': 'eventName', 'type': 'LocalizableString'},
        'category': {'key': 'category', 'type': 'LocalizableString'},
        'http_request': {'key': 'httpRequest', 'type': 'HttpRequestInfo'},
        'level': {'key': 'level', 'type': 'str'},
        'resource_group_name': {'key': 'resourceGroupName', 'type': 'str'},
        'resource_provider_name': {'key': 'resourceProviderName', 'type': 'LocalizableString'},
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'resource_type': {'key': 'resourceType', 'type': 'LocalizableString'},
        'operation_id': {'key': 'operationId', 'type': 'str'},
        'operation_name': {'key': 'operationName', 'type': 'LocalizableString'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'status': {'key': 'status', 'type': 'LocalizableString'},
        'sub_status': {'key': 'subStatus', 'type': 'LocalizableString'},
        'event_timestamp': {'key': 'eventTimestamp', 'type': 'iso-8601'},
        'submission_timestamp': {'key': 'submissionTimestamp', 'type': 'iso-8601'},
        'subscription_id': {'key': 'subscriptionId', 'type': 'str'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(EventData, self).__init__(**kwargs)
        self.authorization = None
        self.claims = None
        self.caller = None
        self.description = None
        self.id = None
        self.event_data_id = None
        self.correlation_id = None
        self.event_name = None
        self.category = None
        self.http_request = None
        self.level = None
        self.resource_group_name = None
        self.resource_provider_name = None
        self.resource_id = None
        self.resource_type = None
        self.operation_id = None
        self.operation_name = None
        self.properties = None
        self.status = None
        self.sub_status = None
        self.event_timestamp = None
        self.submission_timestamp = None
        self.subscription_id = None
        self.tenant_id = None


class EventDataCollection(msrest.serialization.Model):
    """Represents collection of events.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. this list that includes the Azure audit logs.
    :type value: list[~$(python-base-namespace).v2015_04_01.models.EventData]
    :param next_link: Provides the link to retrieve the next set of events.
    :type next_link: str
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[EventData]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["EventData"],
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(EventDataCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class HttpRequestInfo(msrest.serialization.Model):
    """The Http request info.

    :param client_request_id: the client request id.
    :type client_request_id: str
    :param client_ip_address: the client Ip Address.
    :type client_ip_address: str
    :param method: the Http request method.
    :type method: str
    :param uri: the Uri.
    :type uri: str
    """

    _attribute_map = {
        'client_request_id': {'key': 'clientRequestId', 'type': 'str'},
        'client_ip_address': {'key': 'clientIpAddress', 'type': 'str'},
        'method': {'key': 'method', 'type': 'str'},
        'uri': {'key': 'uri', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        client_request_id: Optional[str] = None,
        client_ip_address: Optional[str] = None,
        method: Optional[str] = None,
        uri: Optional[str] = None,
        **kwargs
    ):
        super(HttpRequestInfo, self).__init__(**kwargs)
        self.client_request_id = client_request_id
        self.client_ip_address = client_ip_address
        self.method = method
        self.uri = uri


class LocalizableString(msrest.serialization.Model):
    """The localizable string class.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. the invariant value.
    :type value: str
    :param localized_value: the locale specific value.
    :type localized_value: str
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': 'str'},
        'localized_value': {'key': 'localizedValue', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: str,
        localized_value: Optional[str] = None,
        **kwargs
    ):
        super(LocalizableString, self).__init__(**kwargs)
        self.value = value
        self.localized_value = localized_value


class MetricTrigger(msrest.serialization.Model):
    """The trigger that results in a scaling action.

    All required parameters must be populated in order to send to Azure.

    :param metric_name: Required. the name of the metric that defines what the rule monitors.
    :type metric_name: str
    :param metric_resource_uri: Required. the resource identifier of the resource the rule
     monitors.
    :type metric_resource_uri: str
    :param time_grain: Required. the granularity of metrics the rule monitors. Must be one of the
     predefined values returned from metric definitions for the metric. Must be between 12 hours and
     1 minute.
    :type time_grain: ~datetime.timedelta
    :param statistic: Required. the metric statistic type. How the metrics from multiple instances
     are combined. Possible values include: "Average", "Min", "Max", "Sum".
    :type statistic: str or ~$(python-base-namespace).v2015_04_01.models.MetricStatisticType
    :param time_window: Required. the range of time in which instance data is collected. This value
     must be greater than the delay in metric collection, which can vary from resource-to-resource.
     Must be between 12 hours and 5 minutes.
    :type time_window: ~datetime.timedelta
    :param time_aggregation: Required. time aggregation type. How the data that is collected should
     be combined over time. The default value is Average. Possible values include: "Average",
     "Minimum", "Maximum", "Total", "Count", "Last".
    :type time_aggregation: str or ~$(python-base-namespace).v2015_04_01.models.TimeAggregationType
    :param operator: Required. the operator that is used to compare the metric data and the
     threshold. Possible values include: "Equals", "NotEquals", "GreaterThan", "GreaterThanOrEqual",
     "LessThan", "LessThanOrEqual".
    :type operator: str or ~$(python-base-namespace).v2015_04_01.models.ComparisonOperationType
    :param threshold: Required. the threshold of the metric that triggers the scale action.
    :type threshold: float
    """

    _validation = {
        'metric_name': {'required': True},
        'metric_resource_uri': {'required': True},
        'time_grain': {'required': True},
        'statistic': {'required': True},
        'time_window': {'required': True},
        'time_aggregation': {'required': True},
        'operator': {'required': True},
        'threshold': {'required': True},
    }

    _attribute_map = {
        'metric_name': {'key': 'metricName', 'type': 'str'},
        'metric_resource_uri': {'key': 'metricResourceUri', 'type': 'str'},
        'time_grain': {'key': 'timeGrain', 'type': 'duration'},
        'statistic': {'key': 'statistic', 'type': 'str'},
        'time_window': {'key': 'timeWindow', 'type': 'duration'},
        'time_aggregation': {'key': 'timeAggregation', 'type': 'str'},
        'operator': {'key': 'operator', 'type': 'str'},
        'threshold': {'key': 'threshold', 'type': 'float'},
    }

    def __init__(
        self,
        *,
        metric_name: str,
        metric_resource_uri: str,
        time_grain: datetime.timedelta,
        statistic: Union[str, "MetricStatisticType"],
        time_window: datetime.timedelta,
        time_aggregation: Union[str, "TimeAggregationType"],
        operator: Union[str, "ComparisonOperationType"],
        threshold: float,
        **kwargs
    ):
        super(MetricTrigger, self).__init__(**kwargs)
        self.metric_name = metric_name
        self.metric_resource_uri = metric_resource_uri
        self.time_grain = time_grain
        self.statistic = statistic
        self.time_window = time_window
        self.time_aggregation = time_aggregation
        self.operator = operator
        self.threshold = threshold


class Operation(msrest.serialization.Model):
    """Microsoft Insights API operation definition.

    :param name: Operation name: {provider}/{resource}/{operation}.
    :type name: str
    :param display: Display metadata associated with the operation.
    :type display: ~$(python-base-namespace).v2015_04_01.models.OperationDisplay
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display': {'key': 'display', 'type': 'OperationDisplay'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display: Optional["OperationDisplay"] = None,
        **kwargs
    ):
        super(Operation, self).__init__(**kwargs)
        self.name = name
        self.display = display


class OperationDisplay(msrest.serialization.Model):
    """Display metadata associated with the operation.

    :param provider: Service provider: Microsoft.Insights.
    :type provider: str
    :param resource: Resource on which the operation is performed: AlertRules, Autoscale, etc.
    :type resource: str
    :param operation: Operation type: Read, write, delete, etc.
    :type operation: str
    """

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        provider: Optional[str] = None,
        resource: Optional[str] = None,
        operation: Optional[str] = None,
        **kwargs
    ):
        super(OperationDisplay, self).__init__(**kwargs)
        self.provider = provider
        self.resource = resource
        self.operation = operation


class OperationListResult(msrest.serialization.Model):
    """Result of the request to list Microsoft.Insights operations. It contains a list of operations and a URL link to get the next set of results.

    :param value: List of operations supported by the Microsoft.Insights provider.
    :type value: list[~$(python-base-namespace).v2015_04_01.models.Operation]
    :param next_link: URL to get the next set of operation list results if there are any.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Operation]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["Operation"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(OperationListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class Recurrence(msrest.serialization.Model):
    """The repeating times at which this profile begins. This element is not used if the FixedDate element is used.

    All required parameters must be populated in order to send to Azure.

    :param frequency: Required. the recurrence frequency. How often the schedule profile should
     take effect. This value must be Week, meaning each week will have the same set of profiles. For
     example, to set a daily schedule, set **schedule** to every day of the week. The frequency
     property specifies that the schedule is repeated weekly. Possible values include: "None",
     "Second", "Minute", "Hour", "Day", "Week", "Month", "Year".
    :type frequency: str or ~$(python-base-namespace).v2015_04_01.models.RecurrenceFrequency
    :param schedule: Required. the scheduling constraints for when the profile begins.
    :type schedule: ~$(python-base-namespace).v2015_04_01.models.RecurrentSchedule
    """

    _validation = {
        'frequency': {'required': True},
        'schedule': {'required': True},
    }

    _attribute_map = {
        'frequency': {'key': 'frequency', 'type': 'str'},
        'schedule': {'key': 'schedule', 'type': 'RecurrentSchedule'},
    }

    def __init__(
        self,
        *,
        frequency: Union[str, "RecurrenceFrequency"],
        schedule: "RecurrentSchedule",
        **kwargs
    ):
        super(Recurrence, self).__init__(**kwargs)
        self.frequency = frequency
        self.schedule = schedule


class RecurrentSchedule(msrest.serialization.Model):
    """The scheduling constraints for when the profile begins.

    All required parameters must be populated in order to send to Azure.

    :param time_zone: Required. the timezone for the hours of the profile. Some examples of valid
     time zones are: Dateline Standard Time, UTC-11, Hawaiian Standard Time, Alaskan Standard Time,
     Pacific Standard Time (Mexico), Pacific Standard Time, US Mountain Standard Time, Mountain
     Standard Time (Mexico), Mountain Standard Time, Central America Standard Time, Central Standard
     Time, Central Standard Time (Mexico), Canada Central Standard Time, SA Pacific Standard Time,
     Eastern Standard Time, US Eastern Standard Time, Venezuela Standard Time, Paraguay Standard
     Time, Atlantic Standard Time, Central Brazilian Standard Time, SA Western Standard Time,
     Pacific SA Standard Time, Newfoundland Standard Time, E. South America Standard Time, Argentina
     Standard Time, SA Eastern Standard Time, Greenland Standard Time, Montevideo Standard Time,
     Bahia Standard Time, UTC-02, Mid-Atlantic Standard Time, Azores Standard Time, Cape Verde
     Standard Time, Morocco Standard Time, UTC, GMT Standard Time, Greenwich Standard Time, W.
     Europe Standard Time, Central Europe Standard Time, Romance Standard Time, Central European
     Standard Time, W. Central Africa Standard Time, Namibia Standard Time, Jordan Standard Time,
     GTB Standard Time, Middle East Standard Time, Egypt Standard Time, Syria Standard Time, E.
     Europe Standard Time, South Africa Standard Time, FLE Standard Time, Turkey Standard Time,
     Israel Standard Time, Kaliningrad Standard Time, Libya Standard Time, Arabic Standard Time,
     Arab Standard Time, Belarus Standard Time, Russian Standard Time, E. Africa Standard Time, Iran
     Standard Time, Arabian Standard Time, Azerbaijan Standard Time, Russia Time Zone 3, Mauritius
     Standard Time, Georgian Standard Time, Caucasus Standard Time, Afghanistan Standard Time, West
     Asia Standard Time, Ekaterinburg Standard Time, Pakistan Standard Time, India Standard Time,
     Sri Lanka Standard Time, Nepal Standard Time, Central Asia Standard Time, Bangladesh Standard
     Time, N. Central Asia Standard Time, Myanmar Standard Time, SE Asia Standard Time, North Asia
     Standard Time, China Standard Time, North Asia East Standard Time, Singapore Standard Time, W.
     Australia Standard Time, Taipei Standard Time, Ulaanbaatar Standard Time, Tokyo Standard Time,
     Korea Standard Time, Yakutsk Standard Time, Cen. Australia Standard Time, AUS Central Standard
     Time, E. Australia Standard Time, AUS Eastern Standard Time, West Pacific Standard Time,
     Tasmania Standard Time, Magadan Standard Time, Vladivostok Standard Time, Russia Time Zone 10,
     Central Pacific Standard Time, Russia Time Zone 11, New Zealand Standard Time, UTC+12, Fiji
     Standard Time, Kamchatka Standard Time, Tonga Standard Time, Samoa Standard Time, Line Islands
     Standard Time.
    :type time_zone: str
    :param days: Required. the collection of days that the profile takes effect on. Possible values
     are Sunday through Saturday.
    :type days: list[str]
    :param hours: Required. A collection of hours that the profile takes effect on. Values
     supported are 0 to 23 on the 24-hour clock (AM/PM times are not supported).
    :type hours: list[int]
    :param minutes: Required. A collection of minutes at which the profile takes effect at.
    :type minutes: list[int]
    """

    _validation = {
        'time_zone': {'required': True},
        'days': {'required': True},
        'hours': {'required': True},
        'minutes': {'required': True},
    }

    _attribute_map = {
        'time_zone': {'key': 'timeZone', 'type': 'str'},
        'days': {'key': 'days', 'type': '[str]'},
        'hours': {'key': 'hours', 'type': '[int]'},
        'minutes': {'key': 'minutes', 'type': '[int]'},
    }

    def __init__(
        self,
        *,
        time_zone: str,
        days: List[str],
        hours: List[int],
        minutes: List[int],
        **kwargs
    ):
        super(RecurrentSchedule, self).__init__(**kwargs)
        self.time_zone = time_zone
        self.days = days
        self.hours = hours
        self.minutes = minutes


class ScaleAction(msrest.serialization.Model):
    """The parameters for the scaling action.

    All required parameters must be populated in order to send to Azure.

    :param direction: Required. the scale direction. Whether the scaling action increases or
     decreases the number of instances. Possible values include: "None", "Increase", "Decrease".
    :type direction: str or ~$(python-base-namespace).v2015_04_01.models.ScaleDirection
    :param type: Required. the type of action that should occur when the scale rule fires. Possible
     values include: "ChangeCount", "PercentChangeCount", "ExactCount".
    :type type: str or ~$(python-base-namespace).v2015_04_01.models.ScaleType
    :param value: the number of instances that are involved in the scaling action. This value must
     be 1 or greater. The default value is 1.
    :type value: str
    :param cooldown: Required. the amount of time to wait since the last scaling action before this
     action occurs. It must be between 1 week and 1 minute in ISO 8601 format.
    :type cooldown: ~datetime.timedelta
    """

    _validation = {
        'direction': {'required': True},
        'type': {'required': True},
        'cooldown': {'required': True},
    }

    _attribute_map = {
        'direction': {'key': 'direction', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
        'cooldown': {'key': 'cooldown', 'type': 'duration'},
    }

    def __init__(
        self,
        *,
        direction: Union[str, "ScaleDirection"],
        type: Union[str, "ScaleType"],
        cooldown: datetime.timedelta,
        value: Optional[str] = "1",
        **kwargs
    ):
        super(ScaleAction, self).__init__(**kwargs)
        self.direction = direction
        self.type = type
        self.value = value
        self.cooldown = cooldown


class ScaleCapacity(msrest.serialization.Model):
    """The number of instances that can be used during this profile.

    All required parameters must be populated in order to send to Azure.

    :param minimum: Required. the minimum number of instances for the resource.
    :type minimum: str
    :param maximum: Required. the maximum number of instances for the resource. The actual maximum
     number of instances is limited by the cores that are available in the subscription.
    :type maximum: str
    :param default: Required. the number of instances that will be set if metrics are not available
     for evaluation. The default is only used if the current instance count is lower than the
     default.
    :type default: str
    """

    _validation = {
        'minimum': {'required': True},
        'maximum': {'required': True},
        'default': {'required': True},
    }

    _attribute_map = {
        'minimum': {'key': 'minimum', 'type': 'str'},
        'maximum': {'key': 'maximum', 'type': 'str'},
        'default': {'key': 'default', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        minimum: str,
        maximum: str,
        default: str,
        **kwargs
    ):
        super(ScaleCapacity, self).__init__(**kwargs)
        self.minimum = minimum
        self.maximum = maximum
        self.default = default


class ScaleRule(msrest.serialization.Model):
    """A rule that provide the triggers and parameters for the scaling action.

    All required parameters must be populated in order to send to Azure.

    :param metric_trigger: Required. the trigger that results in a scaling action.
    :type metric_trigger: ~$(python-base-namespace).v2015_04_01.models.MetricTrigger
    :param scale_action: Required. the parameters for the scaling action.
    :type scale_action: ~$(python-base-namespace).v2015_04_01.models.ScaleAction
    """

    _validation = {
        'metric_trigger': {'required': True},
        'scale_action': {'required': True},
    }

    _attribute_map = {
        'metric_trigger': {'key': 'metricTrigger', 'type': 'MetricTrigger'},
        'scale_action': {'key': 'scaleAction', 'type': 'ScaleAction'},
    }

    def __init__(
        self,
        *,
        metric_trigger: "MetricTrigger",
        scale_action: "ScaleAction",
        **kwargs
    ):
        super(ScaleRule, self).__init__(**kwargs)
        self.metric_trigger = metric_trigger
        self.scale_action = scale_action


class SenderAuthorization(msrest.serialization.Model):
    """the authorization used by the user who has performed the operation that led to this event. This captures the RBAC properties of the event. These usually include the 'action', 'role' and the 'scope'.

    :param action: the permissible actions. For instance: microsoft.support/supporttickets/write.
    :type action: str
    :param role: the role of the user. For instance: Subscription Admin.
    :type role: str
    :param scope: the scope.
    :type scope: str
    """

    _attribute_map = {
        'action': {'key': 'action', 'type': 'str'},
        'role': {'key': 'role', 'type': 'str'},
        'scope': {'key': 'scope', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        action: Optional[str] = None,
        role: Optional[str] = None,
        scope: Optional[str] = None,
        **kwargs
    ):
        super(SenderAuthorization, self).__init__(**kwargs)
        self.action = action
        self.role = role
        self.scope = scope


class TimeWindow(msrest.serialization.Model):
    """A specific date-time for the profile.

    All required parameters must be populated in order to send to Azure.

    :param time_zone: the timezone of the start and end times for the profile. Some examples of
     valid time zones are: Dateline Standard Time, UTC-11, Hawaiian Standard Time, Alaskan Standard
     Time, Pacific Standard Time (Mexico), Pacific Standard Time, US Mountain Standard Time,
     Mountain Standard Time (Mexico), Mountain Standard Time, Central America Standard Time, Central
     Standard Time, Central Standard Time (Mexico), Canada Central Standard Time, SA Pacific
     Standard Time, Eastern Standard Time, US Eastern Standard Time, Venezuela Standard Time,
     Paraguay Standard Time, Atlantic Standard Time, Central Brazilian Standard Time, SA Western
     Standard Time, Pacific SA Standard Time, Newfoundland Standard Time, E. South America Standard
     Time, Argentina Standard Time, SA Eastern Standard Time, Greenland Standard Time, Montevideo
     Standard Time, Bahia Standard Time, UTC-02, Mid-Atlantic Standard Time, Azores Standard Time,
     Cape Verde Standard Time, Morocco Standard Time, UTC, GMT Standard Time, Greenwich Standard
     Time, W. Europe Standard Time, Central Europe Standard Time, Romance Standard Time, Central
     European Standard Time, W. Central Africa Standard Time, Namibia Standard Time, Jordan Standard
     Time, GTB Standard Time, Middle East Standard Time, Egypt Standard Time, Syria Standard Time,
     E. Europe Standard Time, South Africa Standard Time, FLE Standard Time, Turkey Standard Time,
     Israel Standard Time, Kaliningrad Standard Time, Libya Standard Time, Arabic Standard Time,
     Arab Standard Time, Belarus Standard Time, Russian Standard Time, E. Africa Standard Time, Iran
     Standard Time, Arabian Standard Time, Azerbaijan Standard Time, Russia Time Zone 3, Mauritius
     Standard Time, Georgian Standard Time, Caucasus Standard Time, Afghanistan Standard Time, West
     Asia Standard Time, Ekaterinburg Standard Time, Pakistan Standard Time, India Standard Time,
     Sri Lanka Standard Time, Nepal Standard Time, Central Asia Standard Time, Bangladesh Standard
     Time, N. Central Asia Standard Time, Myanmar Standard Time, SE Asia Standard Time, North Asia
     Standard Time, China Standard Time, North Asia East Standard Time, Singapore Standard Time, W.
     Australia Standard Time, Taipei Standard Time, Ulaanbaatar Standard Time, Tokyo Standard Time,
     Korea Standard Time, Yakutsk Standard Time, Cen. Australia Standard Time, AUS Central Standard
     Time, E. Australia Standard Time, AUS Eastern Standard Time, West Pacific Standard Time,
     Tasmania Standard Time, Magadan Standard Time, Vladivostok Standard Time, Russia Time Zone 10,
     Central Pacific Standard Time, Russia Time Zone 11, New Zealand Standard Time, UTC+12, Fiji
     Standard Time, Kamchatka Standard Time, Tonga Standard Time, Samoa Standard Time, Line Islands
     Standard Time.
    :type time_zone: str
    :param start: Required. the start time for the profile in ISO 8601 format.
    :type start: ~datetime.datetime
    :param end: Required. the end time for the profile in ISO 8601 format.
    :type end: ~datetime.datetime
    """

    _validation = {
        'start': {'required': True},
        'end': {'required': True},
    }

    _attribute_map = {
        'time_zone': {'key': 'timeZone', 'type': 'str'},
        'start': {'key': 'start', 'type': 'iso-8601'},
        'end': {'key': 'end', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        start: datetime.datetime,
        end: datetime.datetime,
        time_zone: Optional[str] = None,
        **kwargs
    ):
        super(TimeWindow, self).__init__(**kwargs)
        self.time_zone = time_zone
        self.start = start
        self.end = end


class WebhookNotification(msrest.serialization.Model):
    """Webhook notification of an autoscale event.

    :param service_uri: the service address to receive the notification.
    :type service_uri: str
    :param properties: a property bag of settings. This value can be empty.
    :type properties: dict[str, str]
    """

    _attribute_map = {
        'service_uri': {'key': 'serviceUri', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        service_uri: Optional[str] = None,
        properties: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(WebhookNotification, self).__init__(**kwargs)
        self.service_uri = service_uri
        self.properties = properties
