# -*- coding: utf-8 -*-


"""setup.py: setuptools control."""

import codecs
import os
import re
import platform
from setuptools import setup


def read(*parts):
    here = os.path.abspath(os.path.dirname(__file__))
    return codecs.open(os.path.join(here, *parts)).read()


def find_version(*file_paths):
    version_file = read(*file_paths)
    version_match = re.search(r"^__version__ = ['\"]([^'\"]*)['\"]",
                              version_file, re.M)
    if version_match:
        return version_match.group(1)
    raise RuntimeError("Unable to find version string.")


try:
    import pypandoc
    md2rst = lambda f: pypandoc.convert(f, 'rst')
except ImportError:
    print("warning: pypandoc module not found, could not "
          "convert Markdown to RST")
    md2rst = lambda f: read(f)

required = ['colorlog', 'pyyaml']
if platform.system() == 'Windows':
    required.extend(['colorama'])


setup(
    name='awesomelog',
    packages=['awesomelog'],
    version=find_version('awesomelog', 'awesomelog.py'),
    description='Bootstrap for console and file logging configuration',
    install_requires=required,
    long_description=md2rst('README.md'),
    author='Rafael Santos',
    author_email='rstogo@outlook.com',
    url='https://github.com/rtogo/awesomelog',
    classifiers=[
        'Development Status :: 5 - Production/Stable',
        'Environment :: Console',
        'Environment :: Web Environment',
        'Intended Audience :: Developers',
        'Intended Audience :: System Administrators',
        'License :: OSI Approved :: MIT License',
        'Operating System :: OS Independent',
        'Programming Language :: Python :: 3',
        'Programming Language :: Python :: 3.4',
        'Programming Language :: Python :: 3.5',
        'Topic :: Terminals',
        'Topic :: Utilities'
    ],
)
