import re


SERVERS = {
    'RU': 'whois.ripn.net',
    'SU': 'whois.ripn.net',
    'XN--P1AI': 'whois.ripn.net',
    'XN--D1ACJ3B': 'whois.ripn.net',
    'XN--80ASWG': 'whois.site.rs.corenic.net',
    'XN--80ASEHDB': 'whois.online.rs.corenic.net',
    'XN--80ADXHKS': 'whois.nic.xn--80adxhks',
    'XN--P1ACF': 'whois.nic.xn--p1acf',
    'NET.RU': 'whois.nic.ru',
    'ORG.RU': 'whois.nic.ru',
    'PP.RU': 'whois.nic.ru',
    'INT.RU': 'whois.int.ru',
    'RU.NET': 'whois.flexireg.net',
    'COM.RU': 'whois.flexireg.net',
    'EXNET.SU': 'whois.flexireg.net',
    'ABKHAZIA.SU': 'whois.flexireg.net',
    'ADYGEYA.RU': 'whois.flexireg.net',
    'ADYGEYA.SU': 'whois.flexireg.net',
    'AKTYUBINSK.SU': 'whois.flexireg.net',
    'AMURSK.RU': 'whois.nic.ru',
    'ARKHANGELSK.SU': 'whois.flexireg.net',
    'ARMENIA.SU': 'whois.flexireg.net',
    'ASHGABAD.SU': 'whois.flexireg.net',
    'AZERBAIJAN.SU': 'whois.flexireg.net',
    'BALASHOV.SU': 'whois.flexireg.net',
    'BASHKIRIA.RU': 'whois.flexireg.net',
    'BASHKIRIA.SU': 'whois.flexireg.net',
    'BELGOROD.RU': 'whois.nic.ru',
    'BELGOROD.SU': 'whois.nic.ru',
    'BIR.RU': 'whois.flexireg.net',
    'BRYANSK.SU': 'whois.flexireg.net',
    'BUKHARA.SU': 'whois.flexireg.net',
    'CBG.RU': 'whois.flexireg.net',
    'CHELYABINSK.RU': 'whois.nic.ru',
    'CHIMKENT.SU': 'whois.flexireg.net',
    'CMW.RU': 'whois.nic.ru',
    'DAGESTAN.RU': 'whois.flexireg.net',
    'DAGESTAN.SU': 'whois.flexireg.net',
    'DUDINKA.RU': 'whois.nic.ru',
    'EAST-KAZAKHSTAN.SU': 'whois.flexireg.net',
    'FAREAST.RU': 'whois.nic.ru',
    'GEORGIA.SU': 'whois.flexireg.net',
    'GROZNY.RU': 'whois.flexireg.net',
    'GROZNY.SU': 'whois.flexireg.net',
    'IVANOVO.SU': 'whois.flexireg.net',
    'JAMBYL.SU': 'whois.flexireg.net',
    'JAR.RU': 'whois.nic.ru',
    'JOSHKAR-OLA.RU': 'whois.nic.ru',
    'KALMYKIA.RU': 'whois.flexireg.net',
    'KALMYKIA.SU': 'whois.flexireg.net',
    'KALUGA.SU': 'whois.flexireg.net',
    'KARACOL.SU': 'whois.flexireg.net',
    'KARAGANDA.SU': 'whois.flexireg.net',
    'KARELIA.SU': 'whois.flexireg.net',
    'KCHR.RU': 'whois.nic.ru',
    'KHAKASSIA.SU': 'whois.flexireg.net',
    'KOMI.SU': 'whois.nic.ru',
    'KRASNODAR.SU': 'whois.flexireg.net',
    'KURGAN.SU': 'whois.flexireg.net',
    'KUSTANAI.RU': 'whois.flexireg.net',
    'KUSTANAI.SU': 'whois.flexireg.net',
    'LENUG.SU': 'whois.flexireg.net',
    'MANGYSHLAK.SU': 'whois.flexireg.net',
    'MARINE.RU': 'whois.flexireg.net',
    'MORDOVIA.RU': 'whois.flexireg.net',
    'MORDOVIA.SU': 'whois.flexireg.net',
    'MSK.RU': 'whois.flexireg.net',
    'MSK.SU': 'whois.flexireg.net',
    'MURMANSK.SU': 'whois.flexireg.net',
    'MYTIS.RU': 'whois.flexireg.net',
    'NALCHIK.RU': 'whois.flexireg.net',
    'NALCHIK.SU': 'whois.flexireg.net',
    'NAVOI.SU': 'whois.flexireg.net',
    'NNOV.RU': 'whois.nnov.ru',
    'NORILSK.RU': 'whois.nic.ru',
    'NORTH-KAZAKHSTAN.SU': 'whois.flexireg.net',
    'NOV.RU': 'whois.flexireg.net',
    'NOV.SU': 'whois.flexireg.net',
    'OBNINSK.SU': 'whois.flexireg.net',
    'PALANA.RU': 'whois.nic.ru',
    'PENZA.SU': 'whois.flexireg.net',
    'POKROVSK.SU': 'whois.flexireg.net',
    'PYATIGORSK.RU': 'whois.flexireg.net',
    'SIMBIRSK.RU': 'whois.nic.ru',
    'SOCHI.SU': 'whois.flexireg.net',
    'SPB.RU': 'whois.flexireg.net',
    'SPB.SU': 'whois.flexireg.net',
    'TASHKENT.SU': 'whois.flexireg.net',
    'TERMEZ.SU': 'whois.flexireg.net',
    'TOGLIATTI.SU': 'whois.flexireg.net',
    'TROITSK.SU': 'whois.flexireg.net',
    'TSARITSYN.RU': 'whois.nic.ru',
    'TSELINOGRAD.SU': 'whois.flexireg.net',
    'TULA.SU': 'whois.flexireg.net',
    'TUVA.SU': 'whois.flexireg.net',
    'VLADIKAVKAZ.RU': 'whois.flexireg.net',
    'VLADIKAVKAZ.SU': 'whois.flexireg.net',
    'VLADIMIR.RU': 'whois.flexireg.net',
    'VLADIMIR.SU': 'whois.flexireg.net',
    'VOLOGDA.SU': 'whois.flexireg.net',
    'YAKUTIA.SU': 'whois.nic.ru',
    'YEKATERINBURG.RU': 'whois.nic.ru',
    'BY': 'whois.cctld.by',
    'NS': 'whois.nsiregistry.net',
    'RIPE': 'whois.ripe.net',
    'IP': 'whois.arin.net',
    'AERO': 'whois.aero',
    'ARPA': 'whois.iana.org',
    'ASIA': 'whois.nic.asia',
    'BIZ': 'whois.biz',
    'CAT': 'whois.cat',
    'CC': 'whois.nic.cc',
    'COM': 'whois.crsnic.net',
    'COOP': 'whois.nic.coop',
    'EDU': 'whois.educause.edu',
    'GOV': 'whois.dotgov.gov',
    'INFO': 'whois.afilias.net',
    'INT': 'whois.iana.org',
    'JOBS': 'jobswhois.verisign-grs.com',
    'MIL': 'whois.nic.mil',
    'MOBI': 'whois.dotmobiregistry.net',
    'MUSEUM': 'whois.museum',
    'NAME': 'whois.nic.name',
    'NET': 'whois.crsnic.net',
    'ORG': 'whois.pir.org',
    'PRO': 'whois.nic.pro',
    'TEL': 'whois-tel.neustar.biz',
    'TRAVEL': 'whois.nic.travel',
    'ACADEMY': 'whois.donuts.co',
    'ACCOUNTANTS': 'whois.donuts.co',
    'AGENCY': 'whois.donuts.co',
    'ASSOCIATES': 'whois.donuts.co',
    'BARGAINS': 'whois.donuts.co',
    'BIKE': 'whois.donuts.co',
    'BOUTIQUE': 'whois.donuts.co',
    'BUILDERS': 'whois.donuts.co',
    'CAB': 'whois.donuts.co',
    'CAMERA': 'whois.donuts.co',
    'CAMP': 'whois.donuts.co',
    'CAPITAL': 'whois.donuts.co',
    'CARDS': 'whois.donuts.co',
    'CARE': 'whois.donuts.co',
    'CAFE': 'whois.donuts.co',
    'CAREERS': 'whois.donuts.co',
    'CASH': 'whois.donuts.co',
    'CATERING': 'whois.donuts.co',
    'CENTER': 'whois.donuts.co',
    'CHEAP': 'whois.donuts.co',
    'CHURCH': 'whois.donuts.co',
    'CLAIMS': 'whois.donuts.co',
    'CLEANING': 'whois.donuts.co',
    'CLINIC': 'whois.donuts.co',
    'CLOTHING': 'whois.donuts.co',
    'CODES': 'whois.donuts.co',
    'COFFEE': 'whois.donuts.co',
    'COMMUNITY': 'whois.donuts.co',
    'COMPANY': 'whois.donuts.co',
    'COMPUTER': 'whois.donuts.co',
    'CONDOS': 'whois.donuts.co',
    'CONSTRUCTION': 'whois.donuts.co',
    'CONTRACTORS': 'whois.donuts.co',
    'COOL': 'whois.donuts.co',
    'CREDIT': 'whois.donuts.co',
    'CREDITCARD': 'whois.donuts.co',
    'CRUISES': 'whois.donuts.co',
    'DATING': 'whois.donuts.co',
    'DENTAL': 'whois.donuts.co',
    'DIAMONDS': 'whois.donuts.co',
    'DIGITAL': 'whois.donuts.co',
    'DIRECTORY': 'whois.donuts.co',
    'DISCOUNT': 'whois.donuts.co',
    'DOMAINS': 'whois.donuts.co',
    'EDUCATION': 'whois.donuts.co',
    'EMAIL': 'whois.donuts.co',
    'ENGINEERING': 'whois.donuts.co',
    'ENTERPRISES': 'whois.donuts.co',
    'EQUIPMENT': 'whois.donuts.co',
    'ESTATE': 'whois.donuts.co',
    'EVENTS': 'whois.donuts.co',
    'EXCHANGE': 'whois.donuts.co',
    'EXPERT': 'whois.donuts.co',
    'EXPOSED': 'whois.donuts.co',
    'FAIL': 'whois.donuts.co',
    'FARM': 'whois.donuts.co',
    'FINANCE': 'whois.donuts.co',
    'FINANCIAL': 'whois.donuts.co',
    'FISH': 'whois.donuts.co',
    'FITNESS': 'whois.donuts.co',
    'FLIGHTS': 'whois.donuts.co',
    'FLORIST': 'whois.donuts.co',
    'FOUNDATION': 'whois.donuts.co',
    'FUND': 'whois.donuts.co',
    'FURNITURE': 'whois.donuts.co',
    'GALLERY': 'whois.donuts.co',
    'GLASS': 'whois.donuts.co',
    'GRAPHICS': 'whois.donuts.co',
    'GRATIS': 'whois.donuts.co',
    'GRIPE': 'whois.donuts.co',
    'GUIDE': 'whois.donuts.co',
    'GURU': 'whois.donuts.co',
    'HOLDINGS': 'whois.donuts.co',
    'HOLIDAY': 'whois.donuts.co',
    'HOUSE': 'whois.donuts.co',
    'INDUSTRIES': 'whois.donuts.co',
    'INSTITUTE': 'whois.donuts.co',
    'INSURE': 'whois.donuts.co',
    'INTERNATIONAL': 'whois.donuts.co',
    'INVESTMENTS': 'whois.donuts.co',
    'KITCHEN': 'whois.donuts.co',
    'LAND': 'whois.donuts.co',
    'LEASE': 'whois.donuts.co',
    'LIFE': 'whois.donuts.co',
    'LIGHTING': 'whois.donuts.co',
    'LIMITED': 'whois.donuts.co',
    'LIMO': 'whois.donuts.co',
    'LOANS': 'whois.donuts.co',
    'MAISON': 'whois.donuts.co',
    'MANAGEMENT': 'whois.donuts.co',
    'MARKETING': 'whois.donuts.co',
    'MEDIA': 'whois.donuts.co',
    'PARTNERS': 'whois.donuts.co',
    'PARTS': 'whois.donuts.co',
    'PHOTOGRAPHY': 'whois.donuts.co',
    'PHOTOS': 'whois.donuts.co',
    'PICTURES': 'whois.donuts.co',
    'PLUMBING': 'whois.donuts.co',
    'PRODUCTIONS': 'whois.donuts.co',
    'PROPERTIES': 'whois.donuts.co',
    'RECIPES': 'whois.donuts.co',
    'REISEN': 'whois.donuts.co',
    'RENTALS': 'whois.donuts.co',
    'REPAIR': 'whois.donuts.co',
    'REPORT': 'whois.donuts.co',
    'SCHULE': 'whois.donuts.co',
    'SERVICES': 'whois.donuts.co',
    'SHOES': 'whois.donuts.co',
    'SINGLES': 'whois.donuts.co',
    'SOLAR': 'whois.donuts.co',
    'SOLUTIONS': 'whois.donuts.co',
    'SUPPLIES': 'whois.donuts.co',
    'SUPPLY': 'whois.donuts.co',
    'SUPPORT': 'whois.donuts.co',
    'SURGERY': 'whois.donuts.co',
    'SYSTEMS': 'whois.donuts.co',
    'TAX': 'whois.donuts.co',
    'TECHNOLOGY': 'whois.donuts.co',
    'TIENDA': 'whois.donuts.co',
    'TIPS': 'whois.donuts.co',
    'TODAY': 'whois.donuts.co',
    'TOOLS': 'whois.donuts.co',
    'TOWN': 'whois.donuts.co',
    'TOYS': 'whois.donuts.co',
    'TRAINING': 'whois.donuts.co',
    'UNIVERSITY': 'whois.donuts.co',
    'VACATIONS': 'whois.donuts.co',
    'VENTURES': 'whois.donuts.co',
    'VIAJES': 'whois.donuts.co',
    'VILLAS': 'whois.donuts.co',
    'VIN': 'whois.donuts.co',
    'VISION': 'whois.donuts.co',
    'VOYAGE': 'whois.donuts.co',
    'WATCH': 'whois.donuts.co',
    'WINE': 'whois.donuts.co',
    'WORKS': 'whois.donuts.co',
    'WTF': 'whois.donuts.co',
    'ZONE': 'whois.donuts.co',
    'AUDIO': 'whois.uniregistry.net',
    'AUTO': 'whois.uniregistry.net',
    'BLACKFRIDAY': 'whois.uniregistry.net',
    'CAR': 'whois.uniregistry.net',
    'CARS': 'whois.uniregistry.net',
    'CHRISTMAS': 'whois.uniregistry.net',
    'GIFT': 'whois.uniregistry.net',
    'GUITARS': 'whois.uniregistry.net',
    'HIPHOP': 'whois.uniregistry.net',
    'JUEGOS': 'whois.uniregistry.net',
    'LINK': 'whois.uniregistry.net',
    'PHOTO': 'whois.uniregistry.net',
    'PICS': 'whois.uniregistry.net',
    'SEXY': 'whois.uniregistry.net',
    'TATTOO': 'whois.uniregistry.net',
    'BERLIN': 'whois.nic.berlin',
    'BEST': 'whois.nic.best',
    'BROKER': 'whois.nic.broker',
    'BUILD': 'whois.nic.build',
    'CAREER': 'whois.nic.career',
    'COURSES': 'whois.nic.courses',
    'CLOUD': 'whois.nic.cloud',
    'CLUB': 'whois.nic.club',
    'EARTH': 'whois.nic.earth',
    'FILM': 'whois.nic.film',
    'FOREX': 'whois.nic.forex',
    'KIWI': 'whois.dot-kiwi.com',
    'LUXURY': 'whois.nic.luxury',
    'MEN': 'whois.nic.men',
    'MENU': 'whois.nic.menu',
    'MOSCOW': 'whois.nic.moscow',
    'ONE': 'whois.nic.one',
    'OOO': 'whois.nic.ooo',
    'SRL': 'whois.nic.srl',
    'STUDY': 'whois.nic.study',
    'TATAR': 'whois.nic.tatar',
    'TOP': 'whois.nic.top',
    'TRADING': 'whois.nic.trading',
    'WIEN': 'whois.nic.wien',
    'UNO': 'whois.nic.uno',
    'XXX': 'whois.nic.xxx',
    'PINK': 'whois.afilias.net',
    'RED': 'whois.afilias.net',
    'SHIKSHA': 'whois.afilias.net',
    'KIM': 'whois.afilias.net',
    'BLUE': 'whois.afilias.net',
    'PET': 'whois.afilias.net',
    'BET': 'whois.afilias.net',
    'ACTOR': 'whois.unitedtld.com',
    'AIRFORCE': 'whois.unitedtld.com',
    'ARMY': 'whois.unitedtld.com',
    'ATTORNEY': 'whois.unitedtld.com',
    'CONSULTING': 'whois.unitedtld.com',
    'DEGREE': 'whois.unitedtld.com',
    'DANCE': 'whois.unitedtld.com',
    'DEMOCRAT': 'whois.unitedtld.com',
    'DENTIST': 'whois.unitedtld.com',
    'ENGINEER': 'whois.unitedtld.com',
    'FUTBOL': 'whois.unitedtld.com',
    'GIVES': 'whois.unitedtld.com',
    'HAUS': 'whois.unitedtld.com',
    'IMMOBILIEN': 'whois.unitedtld.com',
    'KAUFEN': 'whois.unitedtld.com',
    'LAWYER': 'whois.unitedtld.com',
    'MARKET': 'whois.unitedtld.com',
    'MODA': 'whois.unitedtld.com',
    'MORTGAGE': 'whois.unitedtld.com',
    'NAVY': 'whois.unitedtld.com',
    'NINJA': 'whois.unitedtld.com',
    'PUB': 'whois.unitedtld.com',
    'REHAB': 'whois.unitedtld.com',
    'REPUBLICAN': 'whois.unitedtld.com',
    'REVIEWS': 'whois.unitedtld.com',
    'ROCKS': 'whois.unitedtld.com',
    'SOCIAL': 'whois.unitedtld.com',
    'SOFTWARE': 'whois.unitedtld.com',
    'VET': 'whois.unitedtld.com',
    'COOKING': 'whois-dub.mm-registry.com',
    'COUNTRY': 'whois-dub.mm-registry.com',
    'FISHING': 'whois-dub.mm-registry.com',
    'HORSE': 'whois-dub.mm-registry.com',
    'RODEO': 'whois-dub.mm-registry.com',
    'VODKA': 'whois-dub.mm-registry.com',
    'LONDON': 'whois-dub.mm-registry.com',
    'BAYERN': 'whois-dub.mm-registry.com',
    'MIAMI': 'whois-dub.mm-registry.com',
    'ABOGADO': 'whois-dub.mm-registry.com',
    'BEER': 'whois-dub.mm-registry.com',
    'BUDAPEST': 'whois-dub.mm-registry.com',
    'FIT': 'whois-dub.mm-registry.com',
    'GARDEN': 'whois-dub.mm-registry.com',
    'LUXE': 'whois-dub.mm-registry.com',
    'NRW': 'whois-dub.mm-registry.com',
    'SURF': 'whois-dub.mm-registry.com',
    'WEDDING': 'whois-dub.mm-registry.com',
    'WORK': 'whois-dub.mm-registry.com',
    'YOGA': 'whois-dub.mm-registry.com',
    'FAMILY': 'whois.rightside.co',
    'LIVE': 'whois.rightside.co',
    'STUDIO': 'whois.rightside.co',
    'AC': 'whois.nic.ac',
    'AG': 'whois.nic.ag',
    'AM': 'whois.amnic.net',
    'AS': 'whois.nic.as',
    'AT': 'whois.nic.at',
    'AU': 'whois.aunic.net',
    'BE': 'whois.dns.be',
    'BG': 'whois.register.bg',
    'BJ': 'whois.nic.bj',
    'BR': 'whois.registro.br',
    'BZ': 'whois2.afilias-grs.net',
    'CA': 'whois.cira.ca',
    'CD': 'whois.nic.cd',
    'CH': 'whois.nic.ch',
    'CI': 'whois.nic.ci',
    'CL': 'whois.nic.cl',
    'CM': 'whois.netcom.cm',
    'CN': 'whois.cnnic.net.cn',
    'CO': 'whois.nic.co',
    'CX': 'whois.nic.cx',
    'CZ': 'whois.nic.cz',
    'DE': 'whois.denic.de',
    'DK': 'whois.dk-hostmaster.dk',
    'DM': 'whois.nic.dm',
    'EE': 'whois.eenet.ee',
    'EU': 'whois.eu',
    'FI': 'whois.ficora.fi',
    'FM': 'whois.nic.fm',
    'FO': 'whois.ripe.net',
    'FR': 'whois.nic.fr',
    'GD': 'whois.adamsnames.tc',
    'GG': 'whois.channelisles.net',
    'GI': 'whois2.afilias-grs.net',
    'GS': 'whois.nic.gs',
    'GY': 'whois.registry.gy',
    'HU': 'whois.nic.hu',
    'HK': 'whois.hkirc.hk',
    'HM': 'whois.registry.hm',
    'HN': 'whois2.afilias-grs.net',
    'HR': 'whois.dns.hr',
    'HT': 'whois.nic.ht',
    'IE': 'whois.domainregistry.ie',
    'IL': 'whois.isoc.org.il',
    'IM': 'whois.nic.im',
    'IN': 'whois.inregistry.net',
    'IO': 'whois.nic.io',
    'IR': 'whois.nic.ir',
    'IS': 'whois.isnic.is',
    'IT': 'whois.nic.it',
    'JE': 'whois.channelisles.net',
    'JP': 'whois.jprs.jp',
    'KE': 'whois.kenic.or.ke',
    'KG': 'whois.domain.kg',
    'KI': 'whois.nic.ki',
    'KR': 'whois.nic.or.kr',
    'KZ': 'whois.nic.kz',
    'LA': 'whois.centralnic.com',
    'LC': 'whois2.afilias-grs.net',
    'LI': 'whois.nic.li',
    'LT': 'whois.domreg.lt',
    'LU': 'whois.dns.lu',
    'LV': 'whois.nic.lv',
    'LY': 'whois.nic.ly',
    'MA': 'whois.iam.net.ma',
    'MC': 'whois.ripe.net',
    'MD': 'whois.nic.md',
    'ME': 'whois.nic.me',
    'MG': 'whois.nic.mg',
    'MN': 'whois2.afilias-grs.net',
    'MS': 'whois.nic.ms',
    'MU': 'whois.nic.mu',
    'MX': 'whois.nic.mx',
    'MY': 'whois.mynic.net.my',
    'NA': 'whois.na-nic.com.na',
    'NF': 'whois.nic.cx',
    'NL': 'whois.domain-registry.nl',
    'NO': 'whois.norid.no',
    'NU': 'whois.nic.nu',
    'NZ': 'whois.srs.net.nz',
    'PL': 'whois.dns.pl',
    'PM': 'whois.nic.pm',
    'PR': 'whois.nic.pr',
    'PT': 'whois.dns.pt',
    'PW': 'whois.centralnic.com',
    'PY': 'whois.i-dns.net',
    'QA': 'whois.registry.qa',
    'RE': 'whois.nic.re',
    'RO': 'whois.rotld.ro',
    'RS': 'whois.rnids.rs',
    'SA': 'whois.saudinic.net.sa',
    'SB': 'whois.nic.sb',
    'SC': 'whois2.afilias-grs.net',
    'SE': 'whois.iis.se',
    'SG': 'whois.nic.net.sg',
    'SH': 'whois.nic.sh',
    'SI': 'whois.arnes.si',
    'SK': 'whois.sk-nic.sk',
    'SM': 'whois.ripe.net',
    'SO': 'whois.nic.so',
    'ST': 'whois.nic.st',
    'TC': 'whois.adamsnames.tc',
    'TF': 'whois.nic.tf',
    'TH': 'whois.nic.uk',
    'TK': 'whois.dot.tk',
    'TL': 'whois.nic.tl',
    'TM': 'whois.nic.tm',
    'TO': 'whois.tonic.to',
    'TR': 'whois.nic.tr',
    'TV': 'whois.nic.tv',
    'TW': 'whois.twnic.net.tw',
    'UA': 'whois.com.ua',
    'UK': 'whois.nic.uk',
    'US': 'whois.nic.us',
    'UZ': 'whois.cctld.uz',
    'VC': 'whois2.afilias-grs.net',
    'VE': 'whois.nic.ve',
    'VG': 'whois.adamsnames.tc',
    'WF': 'whois.nic.wf',
    'WS': 'whois.worldsite.ws',
    'YT': 'whois.nic.yt',
    'PRIV.AT': 'whois.nic.priv.at',
    'ASN.AU': 'whois.aunic.net',
    'COM.AU': 'whois.aunic.net',
    'CONF.AU': 'whois.aunic.net',
    'CSIRO.AU': 'whois.aunic.net',
    'EDU.AU': 'whois.aunic.net',
    'GOV.AU': 'whois.aunic.net',
    'ID.AU': 'whois.aunic.net',
    'INFO.AU': 'whois.aunic.net',
    'NET.AU': 'whois.aunic.net',
    'ORG.AU': 'whois.aunic.net',
    'EMU.ID.AU': 'whois.aunic.net',
    'WATTLE.ID.AU': 'whois.aunic.net',
    'ADM.BR': 'whois.nic.br',
    'ADV.BR': 'whois.nic.br',
    'AGR.BR': 'whois.nic.br',
    'AM.BR': 'whois.nic.br',
    'ARQ.BR': 'whois.nic.br',
    'ART.BR': 'whois.nic.br',
    'ATO.BR': 'whois.nic.br',
    'BIO.BR': 'whois.nic.br',
    'BMD.BR': 'whois.nic.br',
    'CIM.BR': 'whois.nic.br',
    'CNG.BR': 'whois.nic.br',
    'CNT.BR': 'whois.nic.br',
    'COM.BR': 'whois.nic.br',
    'ECN.BR': 'whois.nic.br',
    'EDU.BR': 'whois.nic.br',
    'ENG.BR': 'whois.nic.br',
    'ESP.BR': 'whois.nic.br',
    'ETC.BR': 'whois.nic.br',
    'ETI.BR': 'whois.nic.br',
    'FAR.BR': 'whois.nic.br',
    'FM.BR': 'whois.nic.br',
    'FND.BR': 'whois.nic.br',
    'FOT.BR': 'whois.nic.br',
    'FST.BR': 'whois.nic.br',
    'G12.BR': 'whois.nic.br',
    'GGF.BR': 'whois.nic.br',
    'GOV.BR': 'whois.nic.br',
    'IMB.BR': 'whois.nic.br',
    'IND.BR': 'whois.nic.br',
    'INF.BR': 'whois.nic.br',
    'JOR.BR': 'whois.nic.br',
    'LEL.BR': 'whois.nic.br',
    'MAT.BR': 'whois.nic.br',
    'MED.BR': 'whois.nic.br',
    'MIL.BR': 'whois.nic.br',
    'MUS.BR': 'whois.nic.br',
    'NET.BR': 'whois.nic.br',
    'NOM.BR': 'whois.nic.br',
    'NOT.BR': 'whois.nic.br',
    'NTR.BR': 'whois.nic.br',
    'ODO.BR': 'whois.nic.br',
    'OOP.BR': 'whois.nic.br',
    'ORG.BR': 'whois.nic.br',
    'PPG.BR': 'whois.nic.br',
    'PRO.BR': 'whois.nic.br',
    'PSC.BR': 'whois.nic.br',
    'PSI.BR': 'whois.nic.br',
    'QSL.BR': 'whois.nic.br',
    'REC.BR': 'whois.nic.br',
    'SLG.BR': 'whois.nic.br',
    'SRV.BR': 'whois.nic.br',
    'TMP.BR': 'whois.nic.br',
    'TRD.BR': 'whois.nic.br',
    'TUR.BR': 'whois.nic.br',
    'TV.BR': 'whois.nic.br',
    'VET.BR': 'whois.nic.br',
    'ZLG.BR': 'whois.nic.br',
    'AC.CN': 'whois.cnnic.net.cn',
    'AH.CN': 'whois.cnnic.net.cn',
    'BJ.CN': 'whois.cnnic.net.cn',
    'COM.CN': 'whois.cnnic.net.cn',
    'CQ.CN': 'whois.cnnic.net.cn',
    'FJ.CN': 'whois.cnnic.net.cn',
    'GD.CN': 'whois.cnnic.net.cn',
    'GOV.CN': 'whois.cnnic.net.cn',
    'GS.CN': 'whois.cnnic.net.cn',
    'GX.CN': 'whois.cnnic.net.cn',
    'GZ.CN': 'whois.cnnic.net.cn',
    'HA.CN': 'whois.cnnic.net.cn',
    'HB.CN': 'whois.cnnic.net.cn',
    'HE.CN': 'whois.cnnic.net.cn',
    'HI.CN': 'whois.cnnic.net.cn',
    'HK.CN': 'whois.cnnic.net.cn',
    'HL.CN': 'whois.cnnic.net.cn',
    'HN.CN': 'whois.cnnic.net.cn',
    'JL.CN': 'whois.cnnic.net.cn',
    'JS.CN': 'whois.cnnic.net.cn',
    'JX.CN': 'whois.cnnic.net.cn',
    'LN.CN': 'whois.cnnic.net.cn',
    'MO.CN': 'whois.cnnic.net.cn',
    'NET.CN': 'whois.cnnic.net.cn',
    'NM.CN': 'whois.cnnic.net.cn',
    'NX.CN': 'whois.cnnic.net.cn',
    'ORG.CN': 'whois.cnnic.net.cn',
    'QH.CN': 'whois.cnnic.net.cn',
    'SC.CN': 'whois.cnnic.net.cn',
    'SD.CN': 'whois.cnnic.net.cn',
    'SH.CN': 'whois.cnnic.net.cn',
    'SN.CN': 'whois.cnnic.net.cn',
    'SX.CN': 'whois.cnnic.net.cn',
    'TJ.CN': 'whois.cnnic.net.cn',
    'TW.CN': 'whois.cnnic.net.cn',
    'XJ.CN': 'whois.cnnic.net.cn',
    'XZ.CN': 'whois.cnnic.net.cn',
    'YN.CN': 'whois.cnnic.net.cn',
    'ZJ.CN': 'whois.cnnic.net.cn',
    'AC.FJ': 'whois.domains.fj',
    'BIZ.FJ': 'whois.domains.fj',
    'COM.FJ': 'whois.domains.fj',
    'INFO.FJ': 'whois.domains.fj',
    'MIL.FJ': 'whois.domains.fj',
    'NAME.FJ': 'whois.domains.fj',
    'NET.FJ': 'whois.domains.fj',
    'ORG.FJ': 'whois.domains.fj',
    'PRO.FJ': 'whois.domains.fj',
    'CO.GY': 'whois.registry.gy',
    'COM.GY': 'whois.registry.gy',
    'NET.GY': 'whois.registry.gy',
    'COM.HK': 'whois.hknic.net.hk',
    'GOV.HK': 'whois.hknic.net.hk',
    'NET.HK': 'whois.hknic.net.hk',
    'ORG.HK': 'whois.hknic.net.hk',
    'AC.JP': 'whois.jprs.jp',
    'AD.JP': 'whois.jprs.jp',
    'CO.JP': 'whois.jprs.jp',
    'GR.JP': 'whois.jprs.jp',
    'NE.JP': 'whois.jprs.jp',
    'OR.JP': 'whois.jprs.jp',
    'AC.MA': 'whois.iam.net.ma',
    'CO.MA': 'whois.iam.net.ma',
    'GOV.MA': 'whois.iam.net.ma',
    'NET.MA': 'whois.iam.net.ma',
    'ORG.MA': 'whois.iam.net.ma',
    'PRESS.MA': 'whois.iam.net.ma',
    'COM.MX': 'whois.nic.mx',
    'GOB.MX': 'whois.nic.mx',
    'NET.MX': 'whois.nic.mx',
    'COM.MT': 'whois.nic.mt',
    'ORG.MT': 'whois.nic.mt',
    'NET.MT': 'whois.nic.mt',
    'EDU.MT': 'whois.nic.mt',
    'CO.RS': 'whois.rnids.rs',
    'ORG.RS': 'whois.rnids.rs',
    'IN.RS': 'whois.rnids.rs',
    'EDU.RS': 'whois.rnids.rs',
    'COM.TW': 'whois.twnic.net',
    'IDV.TW': 'whois.twnic.net',
    'NET.TW': 'whois.twnic.net',
    'ORG.TW': 'whois.twnic.net',
    'COM.UA': 'whois.com.ua',
    'NET.UA': 'whois.net.ua',
    'ORG.UA': 'whois.com.ua',
    'BIZ.UA': 'whois.biz.ua',
    'CO.UA': 'whois.co.ua',
    'PP.UA': 'whois.pp.ua',
    'KIEV.UA': 'whois.com.ua',
    'DN.UA': 'whois.dn.ua',
    'LG.UA': 'whois.lg.ua',
    'OD.UA': 'whois.od.ua',
    'IN.UA': 'whois.in.ua',
    'AC.UK': 'whois.ja.net',
    'CO.UK': 'whois.nic.uk',
    'GOV.UK': 'whois.ja.net',
    'LTD.UK': 'whois.nic.uk',
    'NET.UK': 'whois.nic.uk',
    'ORG.UK': 'whois.nic.uk',
    'PLC.UK': 'whois.nic.uk',
    'CO.ZA': 'whois.registry.net.za',
    'NET.ZA': 'net-whois.registry.net.za',
    'ORG.ZA': 'org-whois.registry.net.za',
    'WEB.ZA': 'web-whois.registry.net.za',
    'XN--P1AG': 'ru.whois.i-dns.net',
    'XN--J1AEF': 'whois.i-dns.net',
    'XN--E1APQ': 'whois.i-dns.net',
    'XN--C1AVG': 'whois.publicinterestregistry.net',
    'AE.ORG': 'whois.centralnic.com',
    'AFRICA.COM': 'whois.centralnic.com',
    'AR.COM': 'whois.centralnic.com',
    'BR.COM': 'whois.centralnic.com',
    'CN.COM': 'whois.centralnic.com',
    'CO.COM': 'whois.centralnic.com',
    'DE.COM': 'whois.centralnic.com',
    'COM.DE': 'whois.centralnic.com',
    'EU.COM': 'whois.centralnic.com',
    'GB.COM': 'whois.centralnic.com',
    'GB.NET': 'whois.centralnic.com',
    'GR.COM': 'whois.centralnic.com',
    'HU.COM': 'whois.centralnic.com',
    'HU.NET': 'whois.centralnic.com',
    'IN.NET': 'whois.centralnic.com',
    'JP.NET': 'whois.centralnic.com',
    'JPN.COM': 'whois.centralnic.com',
    'KR.COM': 'whois.centralnic.com',
    'MEX.COM': 'whois.centralnic.com',
    'NO.COM': 'whois.centralnic.com',
    'QC.COM': 'whois.centralnic.com',
    'RU.COM': 'whois.centralnic.com',
    'SA.COM': 'whois.centralnic.com',
    'SE.COM': 'whois.centralnic.com',
    'COM.SE': 'whois.centralnic.com',
    'SE.NET': 'whois.centralnic.com',
    'UK.COM': 'whois.centralnic.com',
    'UK.NET': 'whois.centralnic.com',
    'US.COM': 'whois.centralnic.com',
    'UY.COM': 'whois.centralnic.com',
    'ZA.COM': 'whois.centralnic.com',
    'BAR': 'whois.centralnic.com',
    'COLLEGE': 'whois.centralnic.com',
    'CONTACT': 'whois.centralnic.com',
    'DESIGN': 'whois.centralnic.com',
    'FAN': 'whois.centralnic.com',
    'FANS': 'whois.centralnic.com',
    'FEEDBACK': 'whois.centralnic.com',
    'HOST': 'whois.centralnic.com',
    'INK': 'whois.centralnic.com',
    'LOVE': 'whois.centralnic.com',
    'ONLINE': 'whois.centralnic.com',
    'PID': 'whois.centralnic.com',
    'PRESS': 'whois.centralnic.com',
    'PROTECTION': 'whois.centralnic.com',
    'REALTY': 'whois.centralnic.com',
    'REIT': 'whois.centralnic.com',
    'RENT': 'whois.centralnic.com',
    'REST': 'whois.centralnic.com',
    'SECURITY': 'whois.centralnic.com',
    'SITE': 'whois.centralnic.com',
    'SPACE': 'whois.centralnic.com',
    'TECH': 'whois.centralnic.com',
    'THEATRE': 'whois.centralnic.com',
    'TICKETS': 'whois.centralnic.com',
    'WEBSITE': 'whois.centralnic.com',
    'WIKI': 'whois.centralnic.com',
    'XYZ': 'whois.centralnic.com',
    'ORG.NS': 'whois.pir.org',
    'BIZ.NS': 'whois.biz',
    'NAME.NS': 'whois.nic.name',
    'VIP': 'whois.nic.vip',
    'GAME': 'whois.nic.game',
    'PROMO': 'whois.nic.promo'
}

CODE_PAGES = {
    'whois.nic.cl': 'iso-8859-1',
    'whois.ttpia.com': 'iso-8859-1',
    'whois.registro.br': 'iso-8859-1',
    'whois.cira.ca': 'iso-8859-1',
    'whois.denic.de': 'iso-8859-1',
    'whois.eenet.ee': 'iso-8859-1',
    'whois.ficora.fi': 'iso-8859-1',
    'whois.isnic.is': 'iso-8859-1',
    'whois.nic.hu': 'iso-8859-1',
    'whois.dns.pt': 'iso-8859-1',
    'whois.net.ua': 'koi8-u',
    'whois.biz.ua': 'koi8-u',
    'whois.co.ua': 'koi8-u',
    'whois.dn.ua': 'koi8-u',
    'whois.lg.ua': 'koi8-u',
    'whois.od.ua': 'koi8-u',
    'whois.in.ua': 'koi8-u',
    'whois.nic.or.kr': 'euc-kr',
    'whois.domain.kg': 'cp-1251'
}

CREATION_DATE_REX = [
    '\[Created on\]\s*(?P<val>.+)',
    'Created on[.]*: [a-zA-Z]+, (?P<val>.+)',
    'Creation Date:\s?(?P<val>.+)',
    'Creation date\s*:\s?(?P<val>.+)',
    'Registration Date:\s?(?P<val>.+)',
    'Created Date:\s?(?P<val>.+)',
    'Created on:\s?(?P<val>.+)',
    'Created on\s?[.]*:\s?(?P<val>.+)\.',
    'Date Registered\s?[.]*:\s?(?P<val>.+)',
    'Domain Created\s?[.]*:\s?(?P<val>.+)',
    'Domain registered\s?[.]*:\s?(?P<val>.+)',
    'Domain record activated\s?[.]*:\s*?(?P<val>.+)',
    'Record created on\s?[.]*:?\s*?(?P<val>.+)',
    'Record created\s?[.]*:?\s*?(?P<val>.+)',
    'Created\s?[.]*:?\s*?(?P<val>.+)',
    'Registered on\s?[.]*:?\s*?(?P<val>.+)',
    'Registered\s?[.]*:?\s*?(?P<val>.+)',
    'Domain Create Date\s?[.]*:?\s*?(?P<val>.+)',
    'Domain Registration Date\s?[.]*:?\s*?(?P<val>.+)',
    'created:\s*(?P<val>.+)',
    '\[Registered Date\]\s*(?P<val>.+)',
    'created-date:\s*(?P<val>.+)',
    'Domain Name Commencement Date: (?P<val>.+)',
    'registered:\s*(?P<val>.+)',
    'registration:\s*(?P<val>.+)'
]

CREATION_DATE_REX = [re.compile(l, re.IGNORECASE) for l in CREATION_DATE_REX]
