'use strict';

goog.provide('grrUi.appController.module');

goog.require('grrUi.acl.module');
goog.require('grrUi.artifact.module');
goog.require('grrUi.client.module');
goog.require('grrUi.config.module');
goog.require('grrUi.core.module');
goog.require('grrUi.cron.module');
goog.require('grrUi.docs.module');
goog.require('grrUi.flow.module');
goog.require('grrUi.forms.module');
goog.require('grrUi.hunt.module');
/**
 * grrUi.local module is empty by default and can be used for
 * deployment-specific plugins implementation.
 */
goog.require('grrUi.local.module');
goog.require('grrUi.outputPlugins.module');
goog.require('grrUi.routing.module');
goog.require('grrUi.semantic.module');
goog.require('grrUi.sidebar.module');
goog.require('grrUi.stats.module');
/**
 * If GRR is running with AdminUI.use_precompiled_js = True, then
 * grrUi.templates is a special autogenerated module containing all the
 * directives templates. If GRR is running with
 * AdminUI.use_precompiled_js = False, then this module is empty.
 */
goog.require('grrUi.templates.module');
goog.require('grrUi.user.module');


/**
 * Main GRR UI application module.
 */
grrUi.appController.module = angular.module('grrUi.appController',
                                            [grrUi.acl.module.name,
                                             grrUi.artifact.module.name,
                                             grrUi.client.module.name,
                                             grrUi.config.module.name,
                                             grrUi.core.module.name,
                                             grrUi.cron.module.name,
                                             grrUi.docs.module.name,
                                             grrUi.flow.module.name,
                                             grrUi.forms.module.name,
                                             grrUi.hunt.module.name,
                                             grrUi.local.module.name,
                                             grrUi.outputPlugins.module.name,
                                             grrUi.routing.module.name,
                                             grrUi.semantic.module.name,
                                             grrUi.stats.module.name,
                                             grrUi.sidebar.module.name,
                                             grrUi.templates.module.name,
                                             grrUi.user.module.name]);

grrUi.appController.module.config(function($httpProvider, $interpolateProvider,
                                           $qProvider, $locationProvider,
                                           $rootScopeProvider) {
  // Set templating braces to be '{$' and '$}' to avoid conflicts with Django
  // templates.
  $interpolateProvider.startSymbol('{$');
  $interpolateProvider.endSymbol('$}');

  // Ensuring that Django plays nicely with Angular-initiated requests
  // (see http://www.daveoncode.com/2013/10/17/how-to-
  // make-angularjs-and-django-play-nice-together/).
  $httpProvider.defaults.headers.post[
    'Content-Type'] = 'application/x-www-form-urlencoded';

  // Erroring on unhandled rejection is a behavior added in Angular 1.6, our
  // code is written without this check in mind.
  $qProvider.errorOnUnhandledRejections(false);

  // Setting this explicitly due to Angular's behavior change between
  // versions 1.5 and 1.6.
  $locationProvider.hashPrefix('');

  // We use recursive data model generation when rendering forms. Therefore
  // have to increase the digestTtl limit to 50.
  $rootScopeProvider.digestTtl(50);
});

grrUi.appController.module.run(function($injector, $http, $cookies,
                                        grrFirebaseService,
                                        grrReflectionService) {
  // Ensure CSRF token is in place for Angular-initiated HTTP requests.
  $http.defaults.headers.post['X-CSRFToken'] = $cookies.get('csrftoken');
  $http.defaults.headers.delete = $http.defaults.headers.patch = {
    'X-CSRFToken': $cookies.get('csrftoken')
  };

  grrFirebaseService.setupIfNeeded();

  // Call reflection service as soon as possible in the app lifetime to cache
  // the values. "ACLToken" is picked up here as an arbitrary name.
  // grrReflectionService loads all RDFValues definitions on first request
  // and then caches them.
  grrReflectionService.getRDFValueDescriptor('ACLToken');
});


/**
 * Hardcoding jsTree themes folder so that it works correctly when used
 * from a JS bundle file.
 */
$['jstree']['_themes'] = '/static/third-party/jstree/themes/';


/**
 * TODO(user): Remove when dependency on jQuery-migrate is removed.
 */
jQuery['migrateMute'] = true;


grrUi.appController.module.controller('GrrUiAppController', function() {});
