# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from typing import TYPE_CHECKING

from azure.mgmt.core import ARMPipelineClient
from msrest import Deserializer, Serializer

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from typing import Any, Optional

    from azure.core.credentials import TokenCredential

from ._configuration import MicrosoftDatadogClientConfiguration
from .operations import MarketplaceAgreementsOperations
from .operations import MonitorsOperations
from .operations import Operations
from .operations import TagRulesOperations
from .operations import SingleSignOnConfigurationsOperations
from . import models


class MicrosoftDatadogClient(object):
    """MicrosoftDatadogClient.

    :ivar marketplace_agreements: MarketplaceAgreementsOperations operations
    :vartype marketplace_agreements: microsoft_datadog_client.operations.MarketplaceAgreementsOperations
    :ivar monitors: MonitorsOperations operations
    :vartype monitors: microsoft_datadog_client.operations.MonitorsOperations
    :ivar operations: Operations operations
    :vartype operations: microsoft_datadog_client.operations.Operations
    :ivar tag_rules: TagRulesOperations operations
    :vartype tag_rules: microsoft_datadog_client.operations.TagRulesOperations
    :ivar single_sign_on_configurations: SingleSignOnConfigurationsOperations operations
    :vartype single_sign_on_configurations: microsoft_datadog_client.operations.SingleSignOnConfigurationsOperations
    :param credential: Credential needed for the client to connect to Azure.
    :type credential: ~azure.core.credentials.TokenCredential
    :param subscription_id: The ID of the target subscription.
    :type subscription_id: str
    :param str base_url: Service URL
    :keyword int polling_interval: Default waiting time between two polls for LRO operations if no Retry-After header is present.
    """

    def __init__(
        self,
        credential,  # type: "TokenCredential"
        subscription_id,  # type: str
        base_url=None,  # type: Optional[str]
        **kwargs  # type: Any
    ):
        # type: (...) -> None
        if not base_url:
            base_url = 'https://management.azure.com'
        self._config = MicrosoftDatadogClientConfiguration(credential, subscription_id, **kwargs)
        self._client = ARMPipelineClient(base_url=base_url, config=self._config, **kwargs)

        client_models = {k: v for k, v in models.__dict__.items() if isinstance(v, type)}
        self._serialize = Serializer(client_models)
        self._deserialize = Deserializer(client_models)

        self.marketplace_agreements = MarketplaceAgreementsOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.monitors = MonitorsOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.operations = Operations(
            self._client, self._config, self._serialize, self._deserialize)
        self.tag_rules = TagRulesOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.single_sign_on_configurations = SingleSignOnConfigurationsOperations(
            self._client, self._config, self._serialize, self._deserialize)

    def close(self):
        # type: () -> None
        self._client.close()

    def __enter__(self):
        # type: () -> MicrosoftDatadogClient
        self._client.__enter__()
        return self

    def __exit__(self, *exc_details):
        # type: (Any) -> None
        self._client.__exit__(*exc_details)
