INSERT INTO "{{table}}" ({{columns | map('autoquote') | join(', ') }})
VALUES (
  {% for col in columns -%}
  {{ "%s," if not loop.last else "%s" }}
  {%- endfor %}
)

ON CONFLICT (
 {{conflict_key | map('autoquote') | join(', ') }}
)
{% if do_update %}
DO UPDATE SET
  {% for col in columns if col not in conflict_key-%}
  "{{col}}" = EXCLUDED."{{col}}" {{", " if not loop.last}}
  {%- endfor %}
{% else %}
DO NOTHING
{% endif %}
RETURNING {{pk}}
