/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive.scheduler.common.job.factories.spi.model.factory;

import java.util.regex.PatternSyntaxException;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.converter.Converter;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.converter.IdentityConverter;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.exceptions.ModelSyntaxException;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.factory.BaseParserValidator;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.factory.ModelType;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.validator.RegexpValidator;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.validator.Validator;

public class RegexpParserValidator
extends BaseParserValidator<String> {
    public static final String LEFT_DELIMITER = "(";
    public static final String RIGHT_DELIMITER = ")";
    protected static final String REGEXP_REGEXP = "^" + RegexpParserValidator.ignoreCaseRegexp(ModelType.REGEXP.name()) + "\\" + "(" + "(.+)\\" + ")" + "$";

    public RegexpParserValidator(String model) throws ModelSyntaxException {
        super(model, ModelType.REGEXP, REGEXP_REGEXP);
    }

    @Override
    protected Converter<String> createConverter(String model) throws ModelSyntaxException {
        return new IdentityConverter();
    }

    @Override
    protected Validator<String> createValidator(String model, Converter<String> converter) throws ModelSyntaxException {
        String regexpString = this.parseAndGetOneGroup(model, REGEXP_REGEXP);
        try {
            return new RegexpValidator(regexpString);
        }
        catch (PatternSyntaxException e) {
            throw new ModelSyntaxException(e.getMessage(), e);
        }
    }
}

