/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ome.xml.model.OMEModel;
import ome.xml.model.OMEModelObject;
import ome.xml.model.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OMEModelImpl
implements OMEModel {
    private Map<String, OMEModelObject> modelObjects = new HashMap<String, OMEModelObject>();
    private Map<OMEModelObject, List<Reference>> references = new HashMap<OMEModelObject, List<Reference>>();
    private static final Logger LOGGER = LoggerFactory.getLogger(OMEModelImpl.class);

    @Override
    public OMEModelObject removeModelObject(String id) {
        return this.modelObjects.remove(id);
    }

    @Override
    public OMEModelObject addModelObject(String id, OMEModelObject object) {
        if (Reference.class.isAssignableFrom(object.getClass())) {
            return object;
        }
        return this.modelObjects.put(id, object);
    }

    @Override
    public OMEModelObject getModelObject(String id) {
        return this.modelObjects.get(id);
    }

    @Override
    public Map<String, OMEModelObject> getModelObjects() {
        return this.modelObjects;
    }

    @Override
    public boolean addReference(OMEModelObject a, Reference b) {
        List<Reference> bList = this.references.get(a);
        if (bList == null) {
            bList = new ArrayList<Reference>();
            this.references.put(a, bList);
        }
        return bList.add(b);
    }

    @Override
    public Map<OMEModelObject, List<Reference>> getReferences() {
        return this.references;
    }

    @Override
    public int resolveReferences() {
        int unhandledReferences = 0;
        for (Map.Entry<OMEModelObject, List<Reference>> entry : this.references.entrySet()) {
            OMEModelObject a = entry.getKey();
            if (a == null) {
                List<Reference> references = entry.getValue();
                if (references == null) {
                    LOGGER.error("Null reference to null object, continuing.");
                    continue;
                }
                LOGGER.error("Null reference to {} objects, continuing.", references.size());
                unhandledReferences += references.size();
                continue;
            }
            for (Reference reference : entry.getValue()) {
                String referenceID = reference.getID();
                OMEModelObject b = this.getModelObject(referenceID);
                if (b == null) {
                    LOGGER.warn("{} reference to {} missing from object hierarchy.", a, (Object)referenceID);
                    ++unhandledReferences;
                    continue;
                }
                a.link(reference, b);
            }
        }
        return unhandledReferences;
    }
}

