/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model;

import java.util.ArrayList;
import java.util.List;
import ome.xml.model.AbstractOMEModelObject;
import ome.xml.model.Dichroic;
import ome.xml.model.DichroicRef;
import ome.xml.model.EmissionFilterRef;
import ome.xml.model.ExcitationFilterRef;
import ome.xml.model.Filter;
import ome.xml.model.FilterRef;
import ome.xml.model.OMEModel;
import ome.xml.model.OMEModelObject;
import ome.xml.model.Reference;
import ome.xml.model.enums.EnumerationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LightPath
extends AbstractOMEModelObject {
    public static final String NAMESPACE = "http://www.openmicroscopy.org/Schemas/OME/2011-06";
    private static final Logger LOGGER = LoggerFactory.getLogger(LightPath.class);
    private List<Filter> excitationFilterList = new ArrayList<Filter>();
    private Dichroic dichroic;
    private List<Filter> emissionFilterList = new ArrayList<Filter>();

    public LightPath() {
    }

    public LightPath(Element element, OMEModel model) throws EnumerationException {
        this.update(element, model);
    }

    @Override
    public void update(Element element, OMEModel model) throws EnumerationException {
        super.update(element, model);
        String tagName = element.getTagName();
        if (!"LightPath".equals(tagName)) {
            LOGGER.debug("Expecting node name of LightPath got {}", (Object)tagName);
        }
        List<Element> ExcitationFilterRef_nodeList = LightPath.getChildrenByTagName(element, "ExcitationFilterRef");
        for (Element ExcitationFilterRef_element : ExcitationFilterRef_nodeList) {
            ExcitationFilterRef excitationFilterList_reference = new ExcitationFilterRef();
            excitationFilterList_reference.setID(ExcitationFilterRef_element.getAttribute("ID"));
            model.addReference(this, excitationFilterList_reference);
        }
        List<Element> DichroicRef_nodeList = LightPath.getChildrenByTagName(element, "DichroicRef");
        for (Element DichroicRef_element : DichroicRef_nodeList) {
            DichroicRef dichroic_reference = new DichroicRef();
            dichroic_reference.setID(DichroicRef_element.getAttribute("ID"));
            model.addReference(this, dichroic_reference);
        }
        List<Element> EmissionFilterRef_nodeList = LightPath.getChildrenByTagName(element, "EmissionFilterRef");
        for (Element EmissionFilterRef_element : EmissionFilterRef_nodeList) {
            EmissionFilterRef emissionFilterList_reference = new EmissionFilterRef();
            emissionFilterList_reference.setID(EmissionFilterRef_element.getAttribute("ID"));
            model.addReference(this, emissionFilterList_reference);
        }
    }

    @Override
    public boolean link(Reference reference, OMEModelObject o) {
        boolean wasHandledBySuperClass = super.link(reference, o);
        if (wasHandledBySuperClass) {
            return true;
        }
        if (reference instanceof ExcitationFilterRef) {
            Filter o_casted = (Filter)o;
            o_casted.linkLightPath(this);
            this.excitationFilterList.add(o_casted);
            return true;
        }
        if (reference instanceof DichroicRef) {
            Dichroic o_casted = (Dichroic)o;
            o_casted.linkLightPath(this);
            this.dichroic = o_casted;
            return true;
        }
        if (reference instanceof EmissionFilterRef) {
            Filter o_casted = (Filter)o;
            o_casted.linkLightPath(this);
            this.emissionFilterList.add(o_casted);
            return true;
        }
        LOGGER.debug("Unable to handle reference of type: {}", reference.getClass());
        return false;
    }

    public int sizeOfLinkedExcitationFilterList() {
        return this.excitationFilterList.size();
    }

    public List<Filter> copyLinkedExcitationFilterList() {
        return new ArrayList<Filter>(this.excitationFilterList);
    }

    public Filter getLinkedExcitationFilter(int index) {
        return this.excitationFilterList.get(index);
    }

    public Filter setLinkedExcitationFilter(int index, Filter o) {
        return this.excitationFilterList.set(index, o);
    }

    public boolean linkExcitationFilter(Filter o) {
        o.linkLightPath(this);
        return this.excitationFilterList.add(o);
    }

    public boolean unlinkExcitationFilter(Filter o) {
        o.unlinkLightPath(this);
        return this.excitationFilterList.remove(o);
    }

    public Dichroic getLinkedDichroic() {
        return this.dichroic;
    }

    public void linkDichroic(Dichroic o) {
        this.dichroic = o;
    }

    public void unlinkDichroic(Dichroic o) {
        if (this.dichroic == o) {
            this.dichroic = null;
        }
    }

    public int sizeOfLinkedEmissionFilterList() {
        return this.emissionFilterList.size();
    }

    public List<Filter> copyLinkedEmissionFilterList() {
        return new ArrayList<Filter>(this.emissionFilterList);
    }

    public Filter getLinkedEmissionFilter(int index) {
        return this.emissionFilterList.get(index);
    }

    public Filter setLinkedEmissionFilter(int index, Filter o) {
        return this.emissionFilterList.set(index, o);
    }

    public boolean linkEmissionFilter(Filter o) {
        o.linkLightPath(this);
        return this.emissionFilterList.add(o);
    }

    public boolean unlinkEmissionFilter(Filter o) {
        o.unlinkLightPath(this);
        return this.emissionFilterList.remove(o);
    }

    @Override
    public Element asXMLElement(Document document) {
        return this.asXMLElement(document, null);
    }

    @Override
    protected Element asXMLElement(Document document, Element LightPath_element) {
        FilterRef o;
        if (LightPath_element == null) {
            LightPath_element = document.createElementNS(NAMESPACE, "LightPath");
        }
        if (this.excitationFilterList != null) {
            for (Filter excitationFilterList_value : this.excitationFilterList) {
                o = new ExcitationFilterRef();
                o.setID(excitationFilterList_value.getID());
                LightPath_element.appendChild(((ExcitationFilterRef)o).asXMLElement(document));
            }
        }
        if (this.dichroic != null) {
            DichroicRef o2 = new DichroicRef();
            o2.setID(this.dichroic.getID());
            LightPath_element.appendChild(o2.asXMLElement(document));
        }
        if (this.emissionFilterList != null) {
            for (Filter emissionFilterList_value : this.emissionFilterList) {
                o = new EmissionFilterRef();
                o.setID(emissionFilterList_value.getID());
                LightPath_element.appendChild(((EmissionFilterRef)o).asXMLElement(document));
            }
        }
        return super.asXMLElement(document, LightPath_element);
    }
}

