/*
 * Decompiled with CFR 0.152.
 */
package mdbtools.dbengine.tasks;

import java.sql.SQLException;
import mdbtools.dbengine.Data;
import mdbtools.dbengine.MemoryData;
import mdbtools.dbengine.functions.Function;
import mdbtools.dbengine.sql.Condition;
import mdbtools.dbengine.sql.Equation;
import mdbtools.dbengine.sql.FQColumn;
import mdbtools.dbengine.sql.FunctionDef;
import mdbtools.dbengine.tasks.Task;

public class FilterData
implements Task {
    private MemoryData result;
    private Object where;
    private Task task;
    private int[] tableMap;

    public FilterData(Task task, Object where, int[] tableMap) {
        this.task = task;
        this.where = where;
        this.tableMap = tableMap;
    }

    public void run() throws SQLException {
        MemoryData data = (MemoryData)this.task.getResult();
        this.result = new MemoryData();
        int i = 0;
        while (data.next()) {
            if (this.whereCheckRow(data, this.where)) {
                this.result.addRow(data.getRow(i));
            }
            ++i;
        }
    }

    public Object getResult() {
        return this.result;
    }

    private boolean whereCheckRow(Data data, Object where) throws SQLException {
        if (where instanceof Equation) {
            return this.whereCheckRowEquation(data, (Equation)where);
        }
        if (where instanceof Condition) {
            return this.whereCheckRowConditon(data, (Condition)where);
        }
        throw new RuntimeException("uknown where type: " + where.getClass().getName());
    }

    private boolean whereCheckRowEquation(Data data, Equation eq) throws SQLException {
        Object left = this.resolveColumn(data, eq.getLeft());
        Object right = this.resolveColumn(data, eq.getRight());
        switch (eq.getOperator()) {
            case 0: {
                return left.equals(right);
            }
            case 3: {
                return !left.equals(right);
            }
            case 1: {
                return ((Comparable)left).compareTo((Comparable)right) < 0;
            }
            case 2: {
                return ((Comparable)left).compareTo((Comparable)right) > 0;
            }
        }
        throw new RuntimeException("unknown equation operator: " + eq.getOperator());
    }

    private boolean whereCheckRowConditon(Data data, Condition condition) throws SQLException {
        Object left = condition.getLeft();
        Object right = condition.getRight();
        switch (condition.getOperator()) {
            case 0: {
                return this.whereCheckRow(data, left) && this.whereCheckRow(data, right);
            }
            case 1: {
                return this.whereCheckRow(data, left) || this.whereCheckRow(data, right);
            }
        }
        throw new RuntimeException("unknown condition operator: " + condition.getOperator());
    }

    private Object resolveColumn(Data data, Object column) throws SQLException {
        if (column instanceof FQColumn) {
            FQColumn c = (FQColumn)column;
            return data.get(this.tableMap[c.getTable()] + c.getColumn());
        }
        if (column instanceof FunctionDef) {
            FunctionDef fdef = (FunctionDef)column;
            Function f = (Function)fdef.getFunction();
            Object argument = fdef.getArgument();
            return f.execute(this.resolveColumn(data, argument));
        }
        return column;
    }
}

