/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.tools;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.TreeMap;
import loci.common.RandomAccessInputStream;
import loci.formats.ClassList;
import loci.formats.FormatReader;
import loci.formats.IFormatReader;
import loci.formats.ImageReader;

public class FindReader {
    public static IFormatReader find(String filename) throws IOException {
        ClassList<IFormatReader> classList = new ClassList<IFormatReader>("readers.txt", IFormatReader.class, ImageReader.class);
        RandomAccessInputStream s = new RandomAccessInputStream(filename);
        File f = new File(filename);
        String name = f.getName();
        for (Class<IFormatReader> rdrClass : classList.getClasses()) {
            try {
                IFormatReader instance = rdrClass.newInstance();
                if (!FormatReader.checkSuffix(name, instance.getSuffixes())) continue;
                instance.setGroupFiles(false);
                if (instance.isThisType(s)) {
                    return instance;
                }
                if (!instance.isThisType(filename, false)) continue;
                return instance;
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.err.println("Adrian: ya need a filename for this crud.");
        }
        System.out.println("Did you know that Bio-Formats can read files with all these suffixes?");
        TreeMap suffixMap = new TreeMap();
        try {
            for (Class<IFormatReader> rdrClass : new ClassList<IFormatReader>("readers.txt", IFormatReader.class, ImageReader.class).getClasses()) {
                IFormatReader instance = rdrClass.newInstance();
                for (String suffix : instance.getSuffixes()) {
                    if (!suffixMap.containsKey(suffix)) {
                        suffixMap.put(suffix, new LinkedList());
                    }
                    ((Collection)suffixMap.get(suffix)).add(instance);
                }
            }
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        for (String x : suffixMap.keySet()) {
            System.out.format("%s:", x);
            String sep = "";
            for (IFormatReader r : (Collection)suffixMap.get(x)) {
                System.out.format("%s %s", sep, r.getClass().getName());
                sep = ",";
            }
            System.out.println();
        }
        try {
            IFormatReader rdr = FindReader.find(args[0]);
            System.out.format("Looks like we use %s to read %s\n", rdr.getClass().getName(), args[0]);
        }
        catch (IOException e) {
            System.err.format("Dufus, you fat-fingered it. %s doesnt exist\n", args[0]);
            e.printStackTrace();
        }
    }
}

