/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import loci.common.DateTools;
import loci.common.RandomAccessInputStream;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.meta.MetadataStore;

public class OpenlabRawReader
extends FormatReader {
    public static final String OPENLAB_RAW_MAGIC_STRING = "OLRW";
    private static final int HEADER_SIZE = 288;
    protected int[] offsets;
    private int bytesPerPixel;

    public OpenlabRawReader() {
        super("Openlab RAW", "raw");
        this.suffixSufficient = false;
        this.domains = new String[]{"Unknown"};
    }

    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        int blockLen = OPENLAB_RAW_MAGIC_STRING.length();
        if (!FormatTools.validStream(stream, blockLen, false)) {
            return false;
        }
        return stream.readString(blockLen).startsWith(OPENLAB_RAW_MAGIC_STRING);
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        this.in.seek(this.offsets[no / this.getSizeC()] + 288);
        this.readPlane(this.in, x, y, w, h, buf);
        if (FormatTools.getBytesPerPixel(this.getPixelType()) == 1) {
            for (int i = 0; i < buf.length; ++i) {
                buf[i] = (byte)(255 - buf[i]);
            }
        }
        return buf;
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.offsets = null;
            this.bytesPerPixel = 0;
        }
    }

    protected void initFile(String id) throws FormatException, IOException {
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        LOGGER.info("Verifying Openlab RAW format");
        if (!this.in.readString(4).equals(OPENLAB_RAW_MAGIC_STRING)) {
            throw new FormatException("Openlab RAW magic string not found.");
        }
        LOGGER.info("Populating metadata");
        int version = this.in.readInt();
        this.core[0].imageCount = this.in.readInt();
        this.offsets = new int[this.getImageCount()];
        this.offsets[0] = 12;
        this.in.skipBytes(8);
        this.core[0].sizeX = this.in.readInt();
        this.core[0].sizeY = this.in.readInt();
        this.in.skipBytes(1);
        this.core[0].sizeC = this.in.read();
        this.bytesPerPixel = this.in.read();
        this.in.skipBytes(1);
        long stampMs = this.in.readLong();
        if (stampMs > 0L) {
            stampMs /= 1000000L;
            stampMs = (long)((double)stampMs - 2.1143592E9);
        } else {
            stampMs = System.currentTimeMillis();
        }
        String stamp = DateTools.convertDate(stampMs, 0);
        this.in.skipBytes(4);
        int len = this.in.read() & 0xFF;
        String imageName = this.in.readString(len - 1).trim();
        this.core[0].sizeC = this.getSizeC() <= 1 ? 1 : 3;
        int plane = this.getSizeX() * this.getSizeY() * this.bytesPerPixel;
        for (int i = 1; i < this.getImageCount(); ++i) {
            this.offsets[i] = this.offsets[i - 1] + 288 + plane;
        }
        this.core[0].sizeZ = this.getImageCount();
        this.core[0].sizeT = 1;
        this.core[0].rgb = this.getSizeC() > 1;
        this.core[0].dimensionOrder = this.isRGB() ? "XYCZT" : "XYZTC";
        this.core[0].interleaved = false;
        this.core[0].littleEndian = false;
        this.core[0].metadataComplete = true;
        this.core[0].indexed = false;
        this.core[0].falseColor = false;
        switch (this.bytesPerPixel) {
            case 1: 
            case 3: {
                this.core[0].pixelType = 1;
                break;
            }
            case 2: {
                this.core[0].pixelType = 3;
                break;
            }
            default: {
                this.core[0].pixelType = 6;
            }
        }
        this.addGlobalMeta("Width", this.getSizeX());
        this.addGlobalMeta("Height", this.getSizeY());
        this.addGlobalMeta("Bytes per pixel", this.bytesPerPixel);
        this.addGlobalMeta("Image name", imageName);
        this.addGlobalMeta("Timestamp", stamp);
        this.addGlobalMeta("Version", version);
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this);
        store.setImageAcquiredDate(stamp, 0);
        store.setImageName(imageName, 0);
    }
}

