/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import loci.common.DataTools;
import loci.common.RandomAccessInputStream;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.codec.JPEG2000CodecOptions;
import loci.formats.in.JPEG2000MetadataParser;
import loci.formats.tiff.IFD;
import loci.formats.tiff.IFDList;
import loci.formats.tiff.PhotoInterp;
import loci.formats.tiff.TiffCompression;
import loci.formats.tiff.TiffParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MinimalTiffReader
extends FormatReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(MinimalTiffReader.class);
    protected IFDList ifds;
    protected IFDList thumbnailIFDs;
    protected List<IFDList> subResolutionIFDs;
    protected TiffParser tiffParser;
    private int lastPlane;
    private Integer resolutionLevels;
    private JPEG2000CodecOptions j2kCodecOptions;

    public MinimalTiffReader() {
        this("Minimal TIFF", new String[]{"tif", "tiff"});
    }

    public MinimalTiffReader(String name, String suffix) {
        this(name, new String[]{suffix});
    }

    public MinimalTiffReader(String name, String[] suffixes) {
        super(name, suffixes);
        this.domains = new String[]{"Graphics"};
        this.suffixNecessary = false;
    }

    public IFDList getIFDs() {
        return this.ifds;
    }

    public IFDList getThumbnailIFDs() {
        return this.thumbnailIFDs;
    }

    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        return new TiffParser(stream).isValidHeader();
    }

    public byte[][] get8BitLookupTable() throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        if (this.ifds == null || this.lastPlane < 0 || this.lastPlane > this.ifds.size()) {
            return null;
        }
        IFD lastIFD = (IFD)this.ifds.get(this.lastPlane);
        int[] bits = lastIFD.getBitsPerSample();
        if (bits[0] <= 8) {
            int[] colorMap = lastIFD.getIFDIntArray(320);
            if (colorMap == null) {
                if (this.lastPlane != 0) {
                    lastIFD = (IFD)this.ifds.get(0);
                    colorMap = lastIFD.getIFDIntArray(320);
                    if (colorMap == null) {
                        return null;
                    }
                } else {
                    return null;
                }
            }
            byte[][] table = new byte[3][colorMap.length / 3];
            int next = 0;
            for (int j = 0; j < table.length; ++j) {
                for (int i = 0; i < table[0].length; ++i) {
                    table[j][i] = (byte)(colorMap[next++] >> 8 & 0xFF);
                }
            }
            return table;
        }
        return null;
    }

    public short[][] get16BitLookupTable() throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        if (this.ifds == null || this.lastPlane < 0 || this.lastPlane > this.ifds.size()) {
            return null;
        }
        IFD lastIFD = (IFD)this.ifds.get(this.lastPlane);
        int[] bits = lastIFD.getBitsPerSample();
        if (bits[0] <= 16 && bits[0] > 8) {
            int[] colorMap = lastIFD.getIFDIntArray(320);
            if (colorMap == null || colorMap.length < 196608) {
                if (this.lastPlane != 0) {
                    lastIFD = (IFD)this.ifds.get(0);
                    colorMap = lastIFD.getIFDIntArray(320);
                    if (colorMap == null || colorMap.length < 196608) {
                        return null;
                    }
                } else {
                    return null;
                }
            }
            short[][] table = new short[3][colorMap.length / 3];
            int next = 0;
            for (int i = 0; i < table.length; ++i) {
                for (int j = 0; j < table[0].length; ++j) {
                    table[i][j] = (short)(colorMap[next++] & 0xFFFF);
                }
            }
            return table;
        }
        return null;
    }

    public int getThumbSizeX() {
        if (this.thumbnailIFDs != null && this.thumbnailIFDs.size() > 0) {
            try {
                return (int)((IFD)this.thumbnailIFDs.get(0)).getImageWidth();
            }
            catch (FormatException e) {
                LOGGER.debug("Could not retrieve thumbnail width", e);
            }
        }
        return super.getThumbSizeX();
    }

    public int getThumbSizeY() {
        if (this.thumbnailIFDs != null && this.thumbnailIFDs.size() > 0) {
            try {
                return (int)((IFD)this.thumbnailIFDs.get(0)).getImageLength();
            }
            catch (FormatException e) {
                LOGGER.debug("Could not retrieve thumbnail height", e);
            }
        }
        return super.getThumbSizeY();
    }

    public byte[] openThumbBytes(int no) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        if (this.thumbnailIFDs == null || this.thumbnailIFDs.size() <= no) {
            return super.openThumbBytes(no);
        }
        int[] bps = null;
        try {
            bps = ((IFD)this.thumbnailIFDs.get(no)).getBitsPerSample();
        }
        catch (FormatException e) {
            // empty catch block
        }
        if (bps == null) {
            return super.openThumbBytes(no);
        }
        int b = bps[0];
        while (b % 8 != 0) {
            ++b;
        }
        if ((b /= 8) != FormatTools.getBytesPerPixel(this.getPixelType()) || bps.length != this.getRGBChannelCount()) {
            return super.openThumbBytes(no);
        }
        byte[] buf = new byte[this.getThumbSizeX() * this.getThumbSizeY() * this.getRGBChannelCount() * FormatTools.getBytesPerPixel(this.getPixelType())];
        return this.tiffParser.getSamples((IFD)this.thumbnailIFDs.get(no), buf);
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        boolean float24;
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        IFD firstIFD = (IFD)this.ifds.get(0);
        this.lastPlane = no;
        IFD ifd = (IFD)this.ifds.get(no);
        if ((firstIFD.getCompression() == TiffCompression.JPEG_2000 || firstIFD.getCompression() == TiffCompression.JPEG_2000_LOSSY) && this.resolutionLevels != null) {
            if (this.series > 0) {
                ifd = (IFD)this.subResolutionIFDs.get(no).get(this.series - 1);
            }
            this.setResolutionLevel(ifd);
        }
        this.tiffParser.getSamples(ifd, buf, x, y, w, h);
        boolean float16 = this.getPixelType() == 6 && firstIFD.getBitsPerSample()[0] == 16;
        boolean bl = float24 = this.getPixelType() == 6 && firstIFD.getBitsPerSample()[0] == 24;
        if (float16 || float24) {
            int nPixels = w * h * this.getRGBChannelCount();
            int nBytes = float16 ? 2 : 3;
            int mantissaBits = float16 ? 10 : 16;
            int exponentBits = float16 ? 5 : 7;
            int maxExponent = (int)Math.pow(2.0, exponentBits) - 1;
            int bits = nBytes * 8 - 1;
            byte[] newBuf = new byte[buf.length];
            for (int i = 0; i < nPixels; ++i) {
                int v = DataTools.bytesToInt(buf, i * nBytes, nBytes, this.isLittleEndian());
                int sign = v >> bits;
                int exponent = v >> mantissaBits & (int)(Math.pow(2.0, exponentBits) - 1.0);
                int mantissa = v & (int)(Math.pow(2.0, mantissaBits) - 1.0);
                if (exponent == 0) {
                    if (mantissa != 0) {
                        while ((mantissa & (int)Math.pow(2.0, mantissaBits)) == 0) {
                            mantissa <<= 1;
                            --exponent;
                        }
                        ++exponent;
                        mantissa &= (int)(Math.pow(2.0, mantissaBits) - 1.0);
                        exponent = (int)((double)exponent + (127.0 - (Math.pow(2.0, exponentBits - 1) - 1.0)));
                    }
                } else {
                    exponent = exponent == maxExponent ? 255 : (int)((double)exponent + (127.0 - (Math.pow(2.0, exponentBits - 1) - 1.0)));
                }
                int value = sign << 31 | exponent << 23 | (mantissa <<= 23 - mantissaBits);
                DataTools.unpackBytes(value, newBuf, i * 4, 4, this.isLittleEndian());
            }
            System.arraycopy(newBuf, 0, buf, 0, newBuf.length);
        }
        return buf;
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.ifds = null;
            this.thumbnailIFDs = null;
            this.subResolutionIFDs = new ArrayList<IFDList>();
            this.lastPlane = 0;
            this.tiffParser = null;
            this.resolutionLevels = null;
            this.j2kCodecOptions = JPEG2000CodecOptions.getDefaultOptions();
        }
    }

    public int getOptimalTileWidth() {
        FormatTools.assertId(this.currentId, true, 1);
        try {
            return (int)((IFD)this.ifds.get(0)).getTileWidth();
        }
        catch (FormatException e) {
            LOGGER.debug("Could not retrieve tile width", e);
            return super.getOptimalTileWidth();
        }
    }

    public int getOptimalTileHeight() {
        FormatTools.assertId(this.currentId, true, 1);
        try {
            return (int)((IFD)this.ifds.get(0)).getTileLength();
        }
        catch (FormatException e) {
            LOGGER.debug("Could not retrieve tile height", e);
            return super.getOptimalTileHeight();
        }
    }

    protected void initFile(String id) throws FormatException, IOException {
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        this.tiffParser = new TiffParser(this.in);
        this.tiffParser.setDoCaching(false);
        Boolean littleEndian = this.tiffParser.checkHeader();
        if (littleEndian == null) {
            throw new FormatException("Invalid TIFF file");
        }
        boolean little = littleEndian;
        this.in.order(little);
        LOGGER.info("Reading IFDs");
        this.ifds = this.tiffParser.getNonThumbnailIFDs();
        if (this.ifds == null || this.ifds.size() == 0) {
            throw new FormatException("No IFDs found");
        }
        this.thumbnailIFDs = this.tiffParser.getThumbnailIFDs();
        LOGGER.info("Populating metadata");
        this.core[0].imageCount = this.ifds.size();
        for (IFD ifd : this.ifds) {
            this.tiffParser.fillInIFD(ifd);
            if (ifd.getCompression() != TiffCompression.JPEG_2000 && ifd.getCompression() != TiffCompression.JPEG_2000_LOSSY) continue;
            LOGGER.debug("Found IFD with JPEG 2000 compression");
            long[] stripOffsets = ifd.getStripOffsets();
            long[] stripByteCounts = ifd.getStripByteCounts();
            if (stripOffsets.length > 0) {
                long stripOffset = stripOffsets[0];
                this.in.seek(stripOffset);
                JPEG2000MetadataParser metadataParser = new JPEG2000MetadataParser(this.in, stripOffset + stripByteCounts[0]);
                this.resolutionLevels = metadataParser.getResolutionLevels();
                if (this.resolutionLevels == null) continue;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug(String.format("Original resolution IFD Levels %d %dx%d Tile %dx%d", this.resolutionLevels, ifd.getImageWidth(), ifd.getImageLength(), ifd.getTileWidth(), ifd.getTileLength()));
                }
                IFDList theseSubResolutionIFDs = new IFDList();
                this.subResolutionIFDs.add(theseSubResolutionIFDs);
                for (int level = 1; level <= this.resolutionLevels; ++level) {
                    IFD newIFD = new IFD(ifd);
                    long imageWidth = ifd.getImageWidth();
                    long imageLength = ifd.getImageLength();
                    long tileWidth = ifd.getTileWidth();
                    long tileLength = ifd.getTileLength();
                    long factor = (long)Math.pow(2.0, level);
                    long newTileWidth = Math.round((double)tileWidth / (double)factor);
                    newTileWidth = newTileWidth < 1L ? 1L : newTileWidth;
                    long newTileLength = Math.round((double)tileLength / (double)factor);
                    newTileLength = newTileLength < 1L ? 1L : newTileLength;
                    long evenTilesPerRow = imageWidth / tileWidth;
                    long evenTilesPerColumn = imageLength / tileLength;
                    double remainingWidth = (double)(imageWidth - evenTilesPerRow * tileWidth) / (double)factor;
                    remainingWidth = remainingWidth < 1.0 ? Math.ceil(remainingWidth) : (double)Math.round(remainingWidth);
                    double remainingLength = (double)(imageLength - evenTilesPerColumn * tileLength) / (double)factor;
                    remainingLength = remainingLength < 1.0 ? Math.ceil(remainingLength) : (double)Math.round(remainingLength);
                    long newImageWidth = (long)((double)(evenTilesPerRow * newTileWidth) + remainingWidth);
                    long newImageLength = (long)((double)(evenTilesPerColumn * newTileLength) + remainingLength);
                    int resolutionLevel = Math.abs(level - this.resolutionLevels);
                    newIFD.put(256, newImageWidth);
                    newIFD.put(257, newImageLength);
                    newIFD.put(322, newTileWidth);
                    newIFD.put(323, newTileLength);
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug(String.format("Added JPEG 2000 sub-resolution IFD Level %d %dx%d Tile %dx%d", resolutionLevel, newImageWidth, newImageLength, newTileWidth, newTileLength));
                    }
                    theseSubResolutionIFDs.add(newIFD);
                }
                continue;
            }
            LOGGER.warn("IFD has no strip offsets!");
        }
        IFD firstIFD = (IFD)this.ifds.get(0);
        PhotoInterp photo = firstIFD.getPhotometricInterpretation();
        int samples = firstIFD.getSamplesPerPixel();
        this.core[0].rgb = samples > 1 || photo == PhotoInterp.RGB;
        this.core[0].interleaved = false;
        this.core[0].littleEndian = firstIFD.isLittleEndian();
        this.core[0].sizeX = (int)firstIFD.getImageWidth();
        this.core[0].sizeY = (int)firstIFD.getImageLength();
        this.core[0].sizeZ = 1;
        this.core[0].sizeC = this.isRGB() ? samples : 1;
        this.core[0].sizeT = this.ifds.size();
        this.core[0].pixelType = firstIFD.getPixelType();
        this.core[0].metadataComplete = true;
        boolean bl = this.core[0].indexed = photo == PhotoInterp.RGB_PALETTE && (this.get8BitLookupTable() != null || this.get16BitLookupTable() != null);
        if (this.isIndexed()) {
            this.core[0].sizeC = 1;
            this.core[0].rgb = false;
            for (IFD ifd : this.ifds) {
                ifd.putIFDValue(262, PhotoInterp.RGB_PALETTE);
            }
        }
        if (this.getSizeC() == 1 && !this.isIndexed()) {
            this.core[0].rgb = false;
        }
        this.core[0].dimensionOrder = "XYCZT";
        this.core[0].bitsPerPixel = firstIFD.getBitsPerSample()[0];
        if (this.resolutionLevels != null && this.subResolutionIFDs.size() > 0) {
            IFDList ifds = this.subResolutionIFDs.get(0);
            CoreMetadata[] newCore = new CoreMetadata[ifds.size() + 1];
            newCore[0] = this.core[0];
            int i = 1;
            for (IFD ifd : ifds) {
                newCore[i] = new CoreMetadata(this, 0);
                newCore[i].sizeX = (int)ifd.getImageWidth();
                newCore[i].sizeY = (int)ifd.getImageLength();
                newCore[i].thumbnail = true;
                ++i;
            }
            this.core = newCore;
        }
    }

    protected void setResolutionLevel(IFD ifd) {
        this.j2kCodecOptions.resolution = Math.abs(this.series - this.resolutionLevels);
        LOGGER.debug("Using JPEG 2000 resolution level {}", this.j2kCodecOptions.resolution);
        this.tiffParser.setCodecOptions(this.j2kCodecOptions);
    }
}

