/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import loci.common.Location;
import loci.common.RandomAccessInputStream;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.codec.ZlibCodec;
import loci.formats.in.MetadataLevel;
import loci.formats.meta.MetadataStore;
import ome.xml.model.enums.NamingConvention;
import ome.xml.model.primitives.NonNegativeInteger;
import ome.xml.model.primitives.PositiveFloat;

public class CellomicsReader
extends FormatReader {
    public static final int C01_MAGIC_BYTES = 16;
    private String[] files;

    public CellomicsReader() {
        super("Cellomics C01", new String[]{"c01", "dib"});
        this.domains = new String[]{"Light Microscopy", "High-Content Screening (HCS)"};
    }

    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        int blockLen = 4;
        if (!FormatTools.validStream(stream, 4, false)) {
            return false;
        }
        return stream.readInt() == 16;
    }

    public String[] getDomains() {
        FormatTools.assertId(this.currentId, true, 1);
        return new String[]{"High-Content Screening (HCS)"};
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        String file2 = this.files[this.getSeries()];
        RandomAccessInputStream s = this.getDecompressedStream(file2);
        int planeSize = FormatTools.getPlaneSize(this);
        s.seek(52 + no * planeSize);
        this.readPlane(s, x, y, w, h, buf);
        s.close();
        return buf;
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.files = null;
        }
    }

    protected void initFile(String id) throws FormatException, IOException {
        super.initFile(id);
        Location baseFile = new Location(id).getAbsoluteFile();
        Location parent = baseFile.getParentFile();
        String plateName = this.getPlateName(baseFile.getName());
        int wellRows = 0;
        int wellColumns = 0;
        int fields = 0;
        if (this.group) {
            String[] list = parent.list(true);
            ArrayList<String> pixelFiles = new ArrayList<String>();
            if (plateName != null) {
                for (String f : list) {
                    if (!plateName.equals(this.getPlateName(f)) || !CellomicsReader.checkSuffix(f, "c01") && !CellomicsReader.checkSuffix(f, "dib")) continue;
                    pixelFiles.add(new Location(parent, f).getAbsolutePath());
                }
            } else {
                pixelFiles.add(id);
            }
            this.files = pixelFiles.toArray(new String[pixelFiles.size()]);
            Arrays.sort(this.files);
            ArrayList<String> uniqueRows = new ArrayList<String>();
            ArrayList<String> uniqueCols = new ArrayList<String>();
            ArrayList<String> uniqueFields = new ArrayList<String>();
            for (String f : this.files) {
                String wellRow = this.getWellRow(f);
                String wellCol = this.getWellColumn(f);
                String field = this.getField(f);
                if (!uniqueRows.contains(wellRow)) {
                    uniqueRows.add(wellRow);
                }
                if (!uniqueCols.contains(wellCol)) {
                    uniqueCols.add(wellCol);
                }
                if (uniqueFields.contains(field)) continue;
                uniqueFields.add(field);
            }
            fields = uniqueFields.size();
            if (fields * (wellRows = uniqueRows.size()) * (wellColumns = uniqueCols.size()) > this.files.length) {
                this.files = new String[]{id};
            }
        } else {
            this.files = new String[]{id};
        }
        this.core = new CoreMetadata[this.files.length];
        for (int i = 0; i < this.core.length; ++i) {
            this.core[i] = new CoreMetadata();
        }
        this.in = this.getDecompressedStream(id);
        LOGGER.info("Reading header data");
        this.in.order(true);
        this.in.skipBytes(4);
        int x = this.in.readInt();
        int y = this.in.readInt();
        short nPlanes = this.in.readShort();
        short nBits = this.in.readShort();
        int compression = this.in.readInt();
        if ((long)(x * y * nPlanes * (nBits / 8) + 52) > this.in.length()) {
            throw new FormatException("Compressed pixel data is not yet supported.");
        }
        this.in.skipBytes(4);
        int pixelWidth = 0;
        int pixelHeight = 0;
        if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
            pixelWidth = this.in.readInt();
            pixelHeight = this.in.readInt();
            int colorUsed = this.in.readInt();
            int colorImportant = this.in.readInt();
            LOGGER.info("Populating metadata hashtable");
            this.addGlobalMeta("Image width", x);
            this.addGlobalMeta("Image height", y);
            this.addGlobalMeta("Number of planes", (int)nPlanes);
            this.addGlobalMeta("Bits per pixel", (int)nBits);
            this.addGlobalMeta("Compression", compression);
            this.addGlobalMeta("Pixels per meter (X)", pixelWidth);
            this.addGlobalMeta("Pixels per meter (Y)", pixelHeight);
            this.addGlobalMeta("Color used", colorUsed);
            this.addGlobalMeta("Color important", colorImportant);
        }
        LOGGER.info("Populating core metadata");
        for (int i = 0; i < this.getSeriesCount(); ++i) {
            this.core[i].sizeX = x;
            this.core[i].sizeY = y;
            this.core[i].sizeZ = nPlanes;
            this.core[i].sizeT = 1;
            this.core[i].sizeC = 1;
            this.core[i].imageCount = this.getSizeZ();
            this.core[i].littleEndian = true;
            this.core[i].dimensionOrder = "XYCZT";
            this.core[i].pixelType = FormatTools.pixelTypeFromBytes(nBits / 8, false, false);
        }
        LOGGER.info("Populating metadata store");
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this);
        MetadataTools.setDefaultCreationDate(store, id, 0);
        store.setPlateID(MetadataTools.createLSID("Plate", 0), 0);
        store.setPlateName(plateName, 0);
        store.setPlateRowNamingConvention(NamingConvention.LETTER, 0);
        store.setPlateColumnNamingConvention(NamingConvention.NUMBER, 0);
        if (this.group) {
            int realRows = wellRows;
            int realCols = wellColumns;
            if (realRows <= 8 && realCols <= 12) {
                realRows = 8;
                realCols = 12;
            } else {
                realRows = 16;
                realCols = 24;
            }
            for (int row = 0; row < realRows; ++row) {
                for (int col = 0; col < realCols; ++col) {
                    int well = row * realCols + col;
                    store.setWellID(MetadataTools.createLSID("Well", 0, well), 0, well);
                    store.setWellRow(new NonNegativeInteger(row), 0, well);
                    store.setWellColumn(new NonNegativeInteger(col), 0, well);
                }
            }
            for (int i = 0; i < this.getSeriesCount(); ++i) {
                String file2 = this.files[i];
                String field = this.getField(file2);
                String wellRow = this.getWellRow(file2);
                String wellColumn = this.getWellColumn(file2);
                int row = wellRow.toUpperCase().charAt(0) - 65;
                int col = Integer.parseInt(wellColumn) - 1;
                String imageID = MetadataTools.createLSID("Image", i);
                store.setImageID(imageID, i);
                if (row < realRows && col < realCols) {
                    int wellIndex = row * realCols + col;
                    int fieldIndex = i % fields;
                    String wellSampleID = MetadataTools.createLSID("WellSample", 0, wellIndex, fieldIndex);
                    store.setWellSampleID(wellSampleID, 0, wellIndex, fieldIndex);
                    store.setWellSampleIndex(new NonNegativeInteger(fieldIndex), 0, wellIndex, fieldIndex);
                    store.setWellSampleImageRef(imageID, 0, wellIndex, fieldIndex);
                }
                store.setImageName("Well " + wellRow + wellColumn + ", Field #" + field, i);
            }
        }
        if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
            double width = pixelWidth == 0 ? 0.0 : 1000000.0 / (double)pixelWidth;
            double height = pixelHeight == 0 ? 0.0 : 1000000.0 / (double)pixelHeight;
            for (int i = 0; i < this.getSeriesCount(); ++i) {
                if (width > 0.0) {
                    store.setPixelsPhysicalSizeX(new PositiveFloat(width), 0);
                }
                if (!(height > 0.0)) continue;
                store.setPixelsPhysicalSizeY(new PositiveFloat(height), 0);
            }
        }
    }

    private String getPlateName(String filename) {
        int underscore = filename.lastIndexOf("_");
        if (underscore < 0) {
            return null;
        }
        return filename.substring(0, underscore);
    }

    private String getWellName(String filename) {
        String wellName = filename.substring(filename.lastIndexOf("_") + 1);
        while (!Character.isLetter(wellName.charAt(0)) || !Character.isDigit(wellName.charAt(1))) {
            wellName = wellName.substring(1, wellName.length());
        }
        return wellName;
    }

    private String getWellRow(String filename) {
        return this.getWellName(filename).substring(0, 1);
    }

    private String getWellColumn(String filename) {
        return this.getWellName(filename).substring(1, 3);
    }

    private String getField(String filename) {
        String well = this.getWellName(filename);
        int start = well.indexOf("f") + 1;
        int end = start + 2;
        return well.substring(start, end);
    }

    private RandomAccessInputStream getDecompressedStream(String filename) throws FormatException, IOException {
        RandomAccessInputStream s = new RandomAccessInputStream(filename);
        if (CellomicsReader.checkSuffix(filename, "c01")) {
            LOGGER.info("Decompressing file");
            s.seek(4L);
            ZlibCodec codec = new ZlibCodec();
            byte[] file2 = codec.decompress(s, null);
            s.close();
            return new RandomAccessInputStream(file2);
        }
        return s;
    }
}

