/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Vector;
import loci.common.DataTools;
import loci.common.DateTools;
import loci.common.IniList;
import loci.common.IniParser;
import loci.common.IniTable;
import loci.common.Location;
import loci.common.RandomAccessInputStream;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.in.BaseTiffReader;
import loci.formats.in.MetadataLevel;
import loci.formats.in.MinimalTiffReader;
import loci.formats.meta.MetadataStore;
import loci.formats.tiff.IFD;
import loci.formats.tiff.TiffIFDEntry;
import loci.formats.tiff.TiffParser;
import ome.xml.model.primitives.NonNegativeInteger;
import ome.xml.model.primitives.PositiveInteger;

public class BDReader
extends FormatReader {
    private static final String EXPERIMENT_FILE = "Experiment.exp";
    private static final String[] META_EXT = new String[]{"drt", "dye", "exp", "plt", "txt"};
    private Vector<String> metadataFiles = new Vector();
    private Vector<String> channelNames = new Vector();
    private Vector<String> wellLabels = new Vector();
    private String plateName;
    private String plateDescription;
    private String[][] tiffs;
    private MinimalTiffReader reader;
    private String roiFile;
    private int[] emWave;
    private int[] exWave;
    private double[] gain;
    private double[] offset;
    private double[] exposure;
    private String binning;
    private String objective;
    private int wellRows;
    private int wellCols;
    private int fieldRows;
    private int fieldCols;

    public BDReader() {
        super("BD Pathway", new String[]{"exp", "tif"});
        this.domains = new String[]{"High-Content Screening (HCS)"};
        this.suffixSufficient = false;
        this.suffixNecessary = false;
    }

    public boolean isThisType(String name, boolean open) {
        if (name.endsWith(EXPERIMENT_FILE)) {
            return true;
        }
        if (!open) {
            return false;
        }
        String id = new Location(name).getAbsolutePath();
        try {
            id = this.locateExperimentFile(id);
        }
        catch (FormatException f) {
            return false;
        }
        catch (IOException f) {
            return false;
        }
        if (id.endsWith(EXPERIMENT_FILE)) {
            return true;
        }
        return super.isThisType(name, open);
    }

    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        TiffParser p = new TiffParser(stream);
        IFD ifd = p.getFirstIFD();
        if (ifd == null) {
            return false;
        }
        String software = ifd.getIFDTextValue(305);
        if (software == null) {
            return false;
        }
        return software.trim().startsWith("MATROX Imaging Library");
    }

    public String[] getSeriesUsedFiles(boolean noPixels) {
        FormatTools.assertId(this.currentId, true, 1);
        Vector<String> files = new Vector<String>();
        for (String file2 : this.metadataFiles) {
            if (file2 == null) continue;
            files.add(file2);
        }
        if (!noPixels && this.tiffs != null) {
            int well = this.getSeries() / (this.fieldRows * this.fieldCols);
            for (int i = 0; i < this.tiffs[well].length; ++i) {
                files.add(this.tiffs[well][i]);
            }
        }
        return files.toArray(new String[files.size()]);
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            if (this.reader != null) {
                this.reader.close();
            }
            this.reader = null;
            this.tiffs = null;
            this.plateName = null;
            this.plateDescription = null;
            this.channelNames.clear();
            this.metadataFiles.clear();
            this.wellLabels.clear();
            this.wellRows = 0;
            this.wellCols = 0;
            this.fieldRows = 0;
            this.fieldCols = 0;
        }
    }

    public int fileGroupOption(String id) throws FormatException, IOException {
        return 0;
    }

    public boolean isSingleFile(String id) throws FormatException, IOException {
        return false;
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        String file2 = this.getFilename(this.getSeries(), no);
        int field = this.getSeries() % (this.fieldRows * this.fieldCols);
        int fieldRow = field / this.fieldCols;
        int fieldCol = field % this.fieldCols;
        if (file2 != null) {
            this.reader.setId(file2);
            if (this.fieldRows * this.fieldCols == 1) {
                this.reader.openBytes(0, buf, x, y, w, h);
            } else {
                int fx = x + fieldCol * this.getSizeX();
                int fy = y + fieldRow * this.getSizeY();
                this.reader.openBytes(0, buf, fx, fy, w, h);
            }
        }
        return buf;
    }

    public int getOptimalTileWidth() {
        FormatTools.assertId(this.currentId, true, 1);
        return this.reader.getOptimalTileWidth();
    }

    public int getOptimalTileHeight() {
        FormatTools.assertId(this.currentId, true, 1);
        return this.reader.getOptimalTileHeight();
    }

    protected void initFile(String id) throws FormatException, IOException {
        int nChannels;
        id = this.locateExperimentFile(id);
        super.initFile(id);
        Location dir = new Location(id).getAbsoluteFile().getParentFile();
        for (String file2 : dir.list(true)) {
            Location f = new Location(dir, file2);
            if (f.isDirectory() || !BDReader.checkSuffix(file2, META_EXT)) continue;
            this.metadataFiles.add(f.getAbsolutePath());
        }
        IniList experiment = this.readMetaData(id);
        if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
            this.objective = (String)experiment.getTable("Geometry").get("Name");
            IniTable camera = experiment.getTable("Camera");
            this.binning = (String)camera.get("BinX") + "x" + (String)camera.get("BinY");
            this.parseChannelData(dir);
            this.addGlobalMeta("Objective", this.objective);
            this.addGlobalMeta("Camera binning", this.binning);
        }
        Vector<String> uniqueRows = new Vector<String>();
        Vector<String> uniqueColumns = new Vector<String>();
        for (String well : this.wellLabels) {
            String row = well.substring(0, 1).trim();
            String column = well.substring(1).trim();
            if (!uniqueRows.contains(row) && row.length() > 0) {
                uniqueRows.add(row);
            }
            if (uniqueColumns.contains(column) || column.length() <= 0) continue;
            uniqueColumns.add(column);
        }
        int nSlices = this.getSizeZ() == 0 ? 1 : this.getSizeZ();
        int nTimepoints = this.getSizeT();
        int nWells = this.wellLabels.size();
        int n = nChannels = this.getSizeC() == 0 ? this.channelNames.size() : this.getSizeC();
        if (nChannels == 0) {
            nChannels = 1;
        }
        this.tiffs = this.getTiffs(dir.getAbsolutePath());
        this.reader = new MinimalTiffReader();
        this.reader.setId(this.tiffs[0][0]);
        int sizeX = this.reader.getSizeX();
        int sizeY = this.reader.getSizeY();
        int pixelType = this.reader.getPixelType();
        boolean rgb = this.reader.isRGB();
        boolean interleaved = this.reader.isInterleaved();
        boolean indexed = this.reader.isIndexed();
        boolean littleEndian = this.reader.isLittleEndian();
        if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
            IniParser parser = new IniParser();
            for (String metadataFile : this.metadataFiles) {
                String filename = new Location(metadataFile).getName();
                if (BDReader.checkSuffix(metadataFile, "txt")) continue;
                String data = DataTools.readFile(metadataFile);
                IniList ini = parser.parseINI(new BufferedReader(new StringReader(data)));
                HashMap<String, String> h = ini.flattenIntoHashMap();
                for (String key : h.keySet()) {
                    this.addGlobalMeta(filename + " " + key, h.get(key));
                }
            }
        }
        for (int i = 0; i < this.getSeriesCount(); ++i) {
            this.core[i] = new CoreMetadata();
            this.core[i].sizeC = nChannels;
            this.core[i].sizeZ = nSlices;
            this.core[i].sizeT = nTimepoints;
            this.core[i].sizeX = sizeX / this.fieldCols;
            this.core[i].sizeY = sizeY / this.fieldRows;
            this.core[i].pixelType = pixelType;
            this.core[i].rgb = rgb;
            this.core[i].interleaved = interleaved;
            this.core[i].indexed = indexed;
            this.core[i].littleEndian = littleEndian;
            this.core[i].dimensionOrder = "XYZTC";
            this.core[i].imageCount = nSlices * nTimepoints * nChannels;
        }
        MetadataStore store = this.makeFilterMetadata();
        boolean populatePlanes = this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM;
        MetadataTools.populatePixels(store, this, populatePlanes);
        String plateAcqID = MetadataTools.createLSID("PlateAcquisition", 0, 0);
        store.setPlateAcquisitionID(plateAcqID, 0, 0);
        store.setPlateAcquisitionMaximumFieldCount(new PositiveInteger(this.fieldRows * this.fieldCols), 0, 0);
        for (int row = 0; row < this.wellRows; ++row) {
            for (int col = 0; col < this.wellCols; ++col) {
                int index = row * this.wellCols + col;
                store.setWellID(MetadataTools.createLSID("Well", 0, index), 0, index);
                store.setWellRow(new NonNegativeInteger(row), 0, index);
                store.setWellColumn(new NonNegativeInteger(col), 0, index);
            }
        }
        for (int i = 0; i < this.getSeriesCount(); ++i) {
            int well = i / (this.fieldRows * this.fieldCols);
            int field = i % (this.fieldRows * this.fieldCols);
            MetadataTools.setDefaultCreationDate(store, this.tiffs[well][0], i);
            String name = this.wellLabels.get(well);
            String row = name.substring(0, 1);
            Integer col = Integer.parseInt(name.substring(1));
            int index = (row.charAt(0) - 65) * this.wellCols + col - 1;
            String wellSampleID = MetadataTools.createLSID("WellSample", 0, index, field);
            store.setWellSampleID(wellSampleID, 0, index, field);
            store.setWellSampleIndex(new NonNegativeInteger(i), 0, index, field);
            String imageID = MetadataTools.createLSID("Image", i);
            store.setWellSampleImageRef(imageID, 0, index, field);
            store.setImageID(imageID, i);
            store.setImageName(name + " Field #" + (field + 1), i);
            store.setPlateAcquisitionWellSampleRef(wellSampleID, 0, 0, i);
        }
        MetadataLevel level = this.getMetadataOptions().getMetadataLevel();
        if (level != MetadataLevel.MINIMUM) {
            String instrumentID = MetadataTools.createLSID("Instrument", 0);
            store.setInstrumentID(instrumentID, 0);
            String objectiveID = MetadataTools.createLSID("Objective", 0, 0);
            store.setObjectiveID(objectiveID, 0, 0);
            if (this.objective != null) {
                String[] tokens = this.objective.split(" ");
                String mag = tokens[0].replaceAll("[xX]", "");
                String na = null;
                int naIndex = 0;
                for (int i = 0; i < tokens.length; ++i) {
                    if (!tokens[i].equals("NA")) continue;
                    naIndex = i + 1;
                    na = tokens[naIndex];
                    break;
                }
                store.setObjectiveNominalMagnification(PositiveInteger.valueOf(mag), 0, 0);
                if (na != null) {
                    na = na.substring(0, 1) + "." + na.substring(1);
                    store.setObjectiveLensNA(new Double(na), 0, 0);
                }
                if (naIndex + 1 < tokens.length) {
                    store.setObjectiveManufacturer(tokens[naIndex + 1], 0, 0);
                }
            }
            for (int i = 0; i < this.getSeriesCount(); ++i) {
                store.setImageInstrumentRef(instrumentID, i);
                store.setImageObjectiveSettingsID(objectiveID, i);
                for (int c = 0; c < this.getSizeC(); ++c) {
                    store.setChannelName(this.channelNames.get(c), i, c);
                    store.setChannelEmissionWavelength(new PositiveInteger(this.emWave[c]), i, c);
                    store.setChannelExcitationWavelength(new PositiveInteger(this.exWave[c]), i, c);
                    String detectorID = MetadataTools.createLSID("Detector", 0, c);
                    store.setDetectorID(detectorID, 0, c);
                    store.setDetectorSettingsID(detectorID, i, c);
                    store.setDetectorSettingsGain(this.gain[c], i, c);
                    store.setDetectorSettingsOffset(this.offset[c], i, c);
                    store.setDetectorSettingsBinning(this.getBinning(this.binning), i, c);
                }
                long firstPlane = 0L;
                for (int p = 0; p < this.getImageCount(); ++p) {
                    int[] zct = this.getZCTCoords(p);
                    store.setPlaneExposureTime(this.exposure[zct[1]], i, p);
                    String file3 = this.getFilename(i, p);
                    if (file3 == null) continue;
                    long plane = this.getTimestamp(file3);
                    if (p == 0) {
                        firstPlane = plane;
                    }
                    double timestamp = (double)(plane - firstPlane) / 1000.0;
                    store.setPlaneDeltaT(timestamp, i, p);
                }
            }
            store.setPlateID(MetadataTools.createLSID("Plate", 0), 0);
            store.setPlateRowNamingConvention(this.getNamingConvention("Letter"), 0);
            store.setPlateColumnNamingConvention(this.getNamingConvention("Number"), 0);
            store.setPlateName(this.plateName, 0);
            store.setPlateDescription(this.plateDescription, 0);
            if (level != MetadataLevel.NO_OVERLAYS) {
                this.parseROIs(store);
            }
        }
    }

    private String locateExperimentFile(String id) throws FormatException, IOException {
        if (!BDReader.checkSuffix(id, "exp")) {
            Location parent = new Location(id).getAbsoluteFile().getParentFile();
            if (BDReader.checkSuffix(id, "tif")) {
                parent = parent.getParentFile();
            }
            for (String file2 : parent.list()) {
                if (!file2.equals(EXPERIMENT_FILE)) continue;
                return new Location(parent, file2).getAbsolutePath();
            }
            throw new FormatException("Could not find Experiment.exp in " + parent.getAbsolutePath());
        }
        return id;
    }

    private IniList readMetaData(String id) throws IOException {
        IniParser parser = new IniParser();
        IniList exp = parser.parseINI(new BufferedReader(new FileReader(id)));
        IniList plate = null;
        for (String filename : this.metadataFiles) {
            if (BDReader.checkSuffix(filename, "plt")) {
                plate = parser.parseINI(new BufferedReader(new FileReader(filename)));
                continue;
            }
            if (!filename.endsWith("RoiSummary.txt")) continue;
            this.roiFile = filename;
            if (this.getMetadataOptions().getMetadataLevel() == MetadataLevel.MINIMUM) continue;
            RandomAccessInputStream s = new RandomAccessInputStream(filename);
            String line = s.readLine().trim();
            while (!line.endsWith(".adf\"")) {
                line = s.readLine().trim();
            }
            this.plateName = line.substring(line.indexOf(":")).trim();
            this.plateName = this.plateName.replace('/', File.separatorChar);
            this.plateName = this.plateName.replace('\\', File.separatorChar);
            for (int i = 0; i < 3; ++i) {
                this.plateName = this.plateName.substring(0, this.plateName.lastIndexOf(File.separator));
            }
            this.plateName = this.plateName.substring(this.plateName.lastIndexOf(File.separator) + 1);
            s.close();
        }
        if (plate == null) {
            throw new IOException("No Plate File");
        }
        IniTable plateType = plate.getTable("PlateType");
        if (this.plateName == null) {
            this.plateName = (String)plateType.get("Brand");
        }
        this.plateDescription = (String)plateType.get("Brand") + " " + (String)plateType.get("Description");
        int nWells = Integer.parseInt((String)plateType.get("Wells"));
        if (nWells == 96) {
            this.wellRows = 8;
            this.wellCols = 12;
        } else if (nWells == 384) {
            this.wellRows = 16;
            this.wellCols = 24;
        }
        Location dir = new Location(id).getAbsoluteFile().getParentFile();
        Object[] wellList = dir.list();
        Arrays.sort(wellList);
        for (Object filename : wellList) {
            if (!((String)filename).startsWith("Well ")) continue;
            this.wellLabels.add(((String)filename).split("\\s|\\.")[1]);
        }
        IniTable imageTable = exp.getTable("Image");
        boolean montage = ((String)imageTable.get("Montaged")).equals("1");
        if (montage) {
            this.fieldRows = Integer.parseInt((String)imageTable.get("TilesY"));
            this.fieldCols = Integer.parseInt((String)imageTable.get("TilesX"));
        } else {
            this.fieldRows = 1;
            this.fieldCols = 1;
        }
        this.core = new CoreMetadata[this.wellLabels.size() * this.fieldRows * this.fieldCols];
        this.core[0] = new CoreMetadata();
        this.core[0].sizeZ = 1;
        this.core[0].sizeC = Integer.parseInt((String)exp.getTable("General").get("Dyes"));
        this.core[0].bitsPerPixel = Integer.parseInt((String)exp.getTable("Camera").get("BitdepthUsed"));
        IniTable dyeTable = exp.getTable("Dyes");
        for (int i = 1; i <= this.getSizeC(); ++i) {
            this.channelNames.add((String)dyeTable.get(Integer.toString(i)));
        }
        this.core[0].sizeT = 0;
        Location well = new Location(dir.getAbsolutePath(), "Well " + this.wellLabels.get(1));
        for (String channelName : this.channelNames) {
            int timepoints = 0;
            for (String filename : well.list()) {
                if (!filename.startsWith(channelName) || !filename.endsWith(".tif")) continue;
                ++timepoints;
            }
            if (timepoints <= this.getSizeT()) continue;
            this.core[0].sizeT = timepoints;
        }
        return exp;
    }

    private void parseChannelData(Location dir) throws IOException {
        this.emWave = new int[this.channelNames.size()];
        this.exWave = new int[this.channelNames.size()];
        this.exposure = new double[this.channelNames.size()];
        this.gain = new double[this.channelNames.size()];
        this.offset = new double[this.channelNames.size()];
        for (int c = 0; c < this.channelNames.size(); ++c) {
            Location dyeFile = new Location(dir, this.channelNames.get(c) + ".dye");
            IniList dye = new IniParser().parseINI(new BufferedReader(new FileReader(dyeFile.getAbsolutePath())));
            IniTable numerator = dye.getTable("Numerator");
            String em = (String)numerator.get("Emission");
            em = em.substring(0, em.indexOf(" "));
            this.emWave[c] = Integer.parseInt(em);
            String ex = (String)numerator.get("Excitation");
            if ((ex = ex.substring(0, ex.lastIndexOf(" "))).indexOf(" ") != -1) {
                ex = ex.substring(ex.lastIndexOf(" ") + 1);
            }
            this.exWave[c] = Integer.parseInt(ex);
            this.exposure[c] = Double.parseDouble((String)numerator.get("Exposure"));
            this.gain[c] = Double.parseDouble((String)numerator.get("Gain"));
            this.offset[c] = Double.parseDouble((String)numerator.get("Offset"));
        }
    }

    private String[][] getTiffs(String dir) {
        Location f = new Location(dir);
        Vector files = new Vector();
        Object[] wells = f.list(true);
        Arrays.sort(wells);
        for (Object filename : wells) {
            Location file2 = new Location(f, (String)filename).getAbsoluteFile();
            if (!file2.isDirectory() || !((String)filename).startsWith("Well ")) continue;
            Object[] list = file2.list(true);
            Vector<String> tiffList = new Vector<String>();
            Arrays.sort(list);
            for (Object tiff : list) {
                if (!((String)tiff).matches(".* - n\\d\\d\\d\\d\\d\\d\\.tif")) continue;
                tiffList.add(new Location(file2, (String)tiff).getAbsolutePath());
            }
            files.add(tiffList);
        }
        String[][] tiffFiles = new String[files.size()][];
        for (int i = 0; i < tiffFiles.length; ++i) {
            tiffFiles[i] = ((Vector)files.get(i)).toArray(new String[0]);
        }
        return tiffFiles;
    }

    private void parseROIs(MetadataStore store) throws IOException {
        String[] cols;
        int firstRow;
        if (this.roiFile == null) {
            return;
        }
        String roiData = DataTools.readFile(this.roiFile);
        String[] lines = roiData.split("\r\n");
        for (firstRow = 0; firstRow < lines.length && !lines[firstRow].startsWith("ROI"); ++firstRow) {
        }
        if ((firstRow += 2) >= lines.length) {
            return;
        }
        for (int i = firstRow; i < lines.length && (cols = lines[i].split("\t")).length >= 6; ++i) {
            if (cols[2].trim().length() <= 0) continue;
            String rectangleID = MetadataTools.createLSID("Shape", i - firstRow, 0);
            store.setRectangleID(rectangleID, i - firstRow, 0);
            store.setRectangleX(new Double(cols[2]), i - firstRow, 0);
            store.setRectangleY(new Double(cols[3]), i - firstRow, 0);
            store.setRectangleWidth(new Double(cols[4]), i - firstRow, 0);
            store.setRectangleHeight(new Double(cols[5]), i - firstRow, 0);
            String roiID = MetadataTools.createLSID("ROI", i - firstRow);
            store.setROIID(roiID, i - firstRow);
            store.setImageROIRef(roiID, 0, i - firstRow);
        }
    }

    private String getFilename(int series, int no) {
        int[] zct = this.getZCTCoords(no);
        String channel = this.channelNames.get(zct[1]);
        int well = series / (this.fieldRows * this.fieldCols);
        for (int i = 0; i < this.tiffs[well].length; ++i) {
            String name = this.tiffs[well][i];
            name = name.substring(name.lastIndexOf(File.separator) + 1);
            name = name.substring(0, name.lastIndexOf("."));
            String index = name.substring(name.lastIndexOf("n") + 1);
            if (!name.startsWith(channel) || Integer.parseInt(index) != zct[2]) continue;
            return this.tiffs[well][i];
        }
        return null;
    }

    private long getTimestamp(String file2) throws FormatException, IOException {
        TiffIFDEntry timestamp;
        RandomAccessInputStream s = new RandomAccessInputStream(file2);
        TiffParser parser = new TiffParser(s);
        parser.setDoCaching(false);
        IFD firstIFD = parser.getFirstIFD();
        if (firstIFD != null && (timestamp = (TiffIFDEntry)firstIFD.get(306)) != null) {
            String stamp = parser.getIFDValue(timestamp).toString();
            s.close();
            stamp = DateTools.formatDate(stamp, BaseTiffReader.DATE_FORMATS);
            return DateTools.getTime(stamp, "yyyy-MM-dd'T'HH:mm:ss");
        }
        s.close();
        return new Location(file2).lastModified();
    }
}

