/*
 Copyright 2009-2012 Luc Saffre
 This file is part of the Lino project.
 Lino is free software; you can redistribute it and/or modify 
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 3 of the License, or
 (at your option) any later version.
 Lino is distributed in the hope that it will be useful, 
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
 GNU General Public License for more details.
 You should have received a copy of the GNU General Public License
 along with Lino; if not, see <http://www.gnu.org/licenses/>.
*/

// lino.js --- generated Mon Nov 12 18:22:24 2012 by Lino version 1.5.1.
Ext.BLANK_IMAGE_URL = '/media/extjs/resources/images/default/s.gif';
LANGUAGE_CHOICES = [ [ "de", "Deutsch" ], [ "fr", "Franz\u00f6sisch" ], [ "en", "Englisch" ] ];
MEDIA_URL = '/media';
ADMIN_URL = '';

/* MonthPickerPlugin: thanks to keypoint @ sencha forum
   http://www.sencha.com/forum/showthread.php?74002-3.x-Ext.ux.MonthMenu&p=356860#post356860
*/
Ext.namespace('Ext.ux'); 

Ext.ux.MonthPickerPlugin = function() { 
    var picker; 
    var oldDateDefaults; 

    this.init = function(pk) { 
        picker = pk; 
        picker.onTriggerClick = picker.onTriggerClick.createSequence(onClick); 
        picker.getValue = picker.getValue.createInterceptor(setDefaultMonthDay).createSequence(restoreDefaultMonthDay); 
        picker.beforeBlur = picker.beforeBlur.createInterceptor(setDefaultMonthDay).createSequence(restoreDefaultMonthDay); 
    }; 

    function setDefaultMonthDay() { 
        oldDateDefaults = Date.defaults.d; 
        Date.defaults.d = 1; 
        return true; 
    } 

    function restoreDefaultMonthDay(ret) { 
        Date.defaults.d = oldDateDefaults; 
        return ret; 
    } 

    function onClick(e, el, opt) { 
        var p = picker.menu.picker; 
        p.activeDate = p.activeDate.getFirstDateOfMonth(); 
        if (p.value) { 
            p.value = p.value.getFirstDateOfMonth(); 
        } 

        p.showMonthPicker(); 
         
        if (!p.disabled) { 
            p.monthPicker.stopFx(); 
            p.monthPicker.show(); 

            p.mun(p.monthPicker, 'click', p.onMonthClick, p); 
            p.mun(p.monthPicker, 'dblclick', p.onMonthDblClick, p); 
            p.onMonthClick = p.onMonthClick.createSequence(pickerClick); 
            p.onMonthDblClick = p.onMonthDblClick.createSequence(pickerDblclick); 
            p.mon(p.monthPicker, 'click', p.onMonthClick, p); 
            p.mon(p.monthPicker, 'dblclick', p.onMonthDblClick, p); 
        } 
    } 

    function pickerClick(e, t) { 
        var el = new Ext.Element(t); 
        if (el.is('button.x-date-mp-cancel')) { 
            picker.menu.hide(); 
        } else if(el.is('button.x-date-mp-ok')) { 
            var p = picker.menu.picker; 
            p.setValue(p.activeDate); 
            p.fireEvent('select', p, p.value); 
        } 
    } 

    function pickerDblclick(e, t) { 
        var el = new Ext.Element(t); 
        if (el.parent() 
            && (el.parent().is('td.x-date-mp-month') 
            || el.parent().is('td.x-date-mp-year'))) { 

            var p = picker.menu.picker; 
            p.setValue(p.activeDate); 
            p.fireEvent('select', p, p.value); 
        } 
    } 
}; 

Ext.preg('monthPickerPlugin', Ext.ux.MonthPickerPlugin);  

//~ /* 
  //~ http://www.diloc.de/blog/2008/03/05/how-to-submit-ext-forms-the-right-way/
//~ */
//~ /**
 //~ * This submit action is basically the same as the normal submit action,
 //~ * only that it uses the fields getSubmitValue() to compose the values to submit,
 //~ * instead of looping over the input-tags in the form-tag of the form.
 //~ *
 //~ * To use it, just use the OOSubmit-plugin on either a FormPanel or a BasicForm,
 //~ * or explicitly call form.doAction('oosubmit');
 //~ *
 //~ * @param {Object} form
 //~ * @param {Object} options
 //~ */
//~ Ext.ux.OOSubmitAction = function(form, options){
    //~ Ext.ux.OOSubmitAction.superclass.constructor.call(this, form, options);
//~ };

//~ Ext.extend(Ext.ux.OOSubmitAction, Ext.form.Action.Submit, {
    //~ /**
    //~ * @cfg {boolean} clientValidation Determines whether a Form's fields are validated
    //~ * in a final call to {@link Ext.form.BasicForm#isValid isValid} prior to submission.
    //~ * Pass <tt>false</tt> in the Form's submit options to prevent this. If not defined, pre-submission field validation
    //~ * is performed.
    //~ */
    //~ type : 'oosubmit',

    //~ // private
    //~ /**
     //~ * This is nearly a copy of the original submit action run method
     //~ */
    //~ run : function(){
        //~ var o = this.options;
        //~ var method = this.getMethod();
        //~ var isPost = method == 'POST';

        //~ var params = this.options.params || {};
        //~ if (isPost) Ext.applyIf(params, this.form.baseParams);

        //~ //now add the form parameters
        //~ this.form.items.each(function(field)
        //~ {
            //~ if (!field.disabled)
            //~ {
                //~ //check if the form item provides a specialized getSubmitValue() and use that if available
                //~ if (typeof field.getSubmitValue == "function")
                    //~ params[field.getName()] = field.getSubmitValue();
                //~ else
                    //~ params[field.getName()] = field.getValue();
            //~ }
        //~ });

        //~ //convert params to get style if we are not post
        //~ if (!isPost) params=Ext.urlEncode(params);

        //~ if(o.clientValidation === false || this.form.isValid()){
            //~ Ext.Ajax.request(Ext.apply(this.createCallback(o), {
                //~ url:this.getUrl(!isPost),
                //~ method: method,
                //~ params:params, //add our values
                //~ isUpload: this.form.fileUpload
            //~ }));

        //~ }else if (o.clientValidation !== false){ // client validation failed
            //~ this.failureType = Ext.form.Action.CLIENT_INVALID;
            //~ this.form.afterAction(this, false);
        //~ }
    //~ },

//~ });
//~ //add our action to the registry of known actions
//~ Ext.form.Action.ACTION_TYPES['oosubmit'] = Ext.ux.OOSubmitAction;




/**
JC Watsons solution (adapted to ExtJS 3.3.1 by LS) is elegant and simple:
`A "fix" for unchecked checkbox submission  behaviour
<http://www.sencha.com/forum/showthread.php?28449>`_

Added special handling for checkbox inputs. 
ExtJS defines disabled checkboxes `readonly`, not `disabled` as for other inputs.

*/
Ext.lib.Ajax.serializeForm = function(form) {
    //~ console.log('20120203 linolib.js serializeForm',form);
    var fElements = form.elements || (document.forms[form] || Ext.getDom(form)).elements, 
        hasSubmit = false, 
        encoder = encodeURIComponent, 
        name, 
        data = '', 
        type, 
        hasValue;

    Ext.each(fElements, function(element){
        name = element.name;
        type = element.type;

        if (!element.disabled && name && !(type == 'checkbox' && element.readonly)) {
            if (/select-(one|multiple)/i.test(type)) {
                Ext.each(element.options, function(opt){
                    if (opt.selected) {
                        hasValue = opt.hasAttribute ? opt.hasAttribute('value') : opt.getAttributeNode('value').specified;
                        data += String.format("{0}={1}&", encoder(name), encoder(hasValue ? opt.value : opt.text));
                    }
                });
            } else if (!(/file|undefined|reset|button/i.test(type))) {
                //~ if (!(/radio|checkbox/i.test(type) && !element.checked) && !(type == 'submit' && hasSubmit)) {
                if (!(type == 'submit' && hasSubmit)) {
                    if (type == 'checkbox') {
                        //~ console.log('20111001',element,'data += ',encoder(name) + '=' + (element.checked ? 'on' : 'off') + '&');
                        data += encoder(name) + '=' + (element.checked ? 'on' : 'off') + '&';
                    } else {
                        //~ console.log('20111001',element,'data += ',encoder(name) + '=' + encoder(element.value) + '&');
                        data += encoder(name) + '=' + encoder(element.value) + '&';
                    }
                    hasSubmit = /submit/i.test(type);
                }
            }
        //~ } else {
            //~ console.log(name,type,element.readonly);
        }
    });
    return data.substr(0, data.length - 1);
};



/*
Set a long timeout of fifteen minutes. 
See http://lino.saffre-rumma.net/blog/2012/0307.html
*/
Ext.Ajax.timeout = 15 * 60 * 1000; 


/*
My fix for the "Cannot set QuickTips dismissDelay to 0" bug,
see http://www.sencha.com/forum/showthread.php?183515 
*/
Ext.override(Ext.QuickTip,{
  showAt : function(xy){
        var t = this.activeTarget;
        //~ console.log("20120224 QuickTip.showAt",this.title,this.dismissDelay,t.dismissDelay);
        if(t){
            if(!this.rendered){
                this.render(Ext.getBody());
                this.activeTarget = t;
            }
            if(t.width){
                this.setWidth(t.width);
                this.body.setWidth(this.adjustBodyWidth(t.width - this.getFrameWidth()));
                this.measureWidth = false;
            } else{
                this.measureWidth = true;
            }
            this.setTitle(t.title || '');
            this.body.update(t.text);
            this.autoHide = t.autoHide;
            // bugfix by Luc 20120226
            if (t.dismissDelay != undefined) this.dismissDelay = t.dismissDelay;
            //~ this.dismissDelay = t.dismissDelay || this.dismissDelay;
            if(this.lastCls){
                this.el.removeClass(this.lastCls);
                delete this.lastCls;
            }
            if(t.cls){
                this.el.addClass(t.cls);
                this.lastCls = t.cls;
            }
            if(this.anchor){
                this.constrainPosition = false;
            }else if(t.align){ 
                xy = this.el.getAlignToXY(t.el, t.align);
                this.constrainPosition = false;
            }else{
                this.constrainPosition = true;
            }
        }
        Ext.QuickTip.superclass.showAt.call(this, xy);
    }
});

/*
Another hack. See /docs/blog/2012/0228
*/
Ext.Element.addMethods(
    function() {
        var VISIBILITY      = "visibility",
            DISPLAY         = "display",
            HIDDEN          = "hidden",
            NONE            = "none",
            XMASKED         = "x-masked",
            XMASKEDRELATIVE = "x-masked-relative",
            data            = Ext.Element.data;

        return {
            
            mask : function(msg, msgCls) {
                var me  = this,
                    dom = me.dom,
                    dh  = Ext.DomHelper,
                    EXTELMASKMSG = "ext-el-mask-msg",
                    el,
                    mask;
                // removed the following lines. See /docs/blog/2012/0228
                //~ if (!(/^body/i.test(dom.tagName) && me.getStyle('position') == 'static')) {
                    //~ console.log(20120228,dom.tagName,me);
                    //~ me.addClass(XMASKEDRELATIVE); 
                //~ }
                if (el = data(dom, 'maskMsg')) {
                    el.remove();
                }
                if (el = data(dom, 'mask')) {
                    el.remove();
                }

                mask = dh.append(dom, {cls : "ext-el-mask"}, true);
                data(dom, 'mask', mask);

                me.addClass(XMASKED);
                mask.setDisplayed(true);
                
                if (typeof msg == 'string') {
                    var mm = dh.append(dom, {cls : EXTELMASKMSG, cn:{tag:'div'}}, true);
                    data(dom, 'maskMsg', mm);
                    mm.dom.className = msgCls ? EXTELMASKMSG + " " + msgCls : EXTELMASKMSG;
                    mm.dom.firstChild.innerHTML = msg;
                    mm.setDisplayed(true);
                    mm.center(me);
                }
                
                
                if (Ext.isIE && !(Ext.isIE7 && Ext.isStrict) && me.getStyle('height') == 'auto') {
                    mask.setSize(undefined, me.getHeight());
                }
                
                return mask;
            }

            
        };
    }()
);



Ext.namespace('Lino');
    
    

//~ Lino.subst_user_field = new Ext.form.ComboBox({});
//~ Lino.subst_user = null;
Lino.insert_subst_user = function(p){
    //~ console.log('20120714 insert_subst_user',Lino.subst_user,p);
    //~ if (Lino.subst_user_field.getValue()) {
    if (p.su) return;
    if (Lino.subst_user) {
        //~ p.su = Lino.subst_user_field.getValue();
        p.su = Lino.subst_user;
    //~ } else {
        //~ delete p.su;
    }
    //~ console.log('20120714 insert_subst_user -->',Lino.subst_user,p);
}

Lino.login_window = null;


Lino.show_login_window = function() {
  //~ console.log('20121103 show_login_window',arguments);
  if (Lino.login_window == null) {
    
      function do_login() { 
            login_panel.getForm().submit({ 
                method:'POST', 
                waitTitle:'Connecting', 
                waitMsg:'Sending data...',
                success:function(){ 
                  //~ console.log('20121104 logged in',arguments);
                  Lino.login_window.hide();
                  Lino.close_all_windows();
                },
                failure: function(form,action) { 
                  //~ this.loadMask.hide();
                  Lino.on_submit_failure(form,action);
                }
                //~ failure:function(form, action){ 
                    //~ alert_msg
                    //~ if(action.failureType == 'server'){ 
                        //~ obj = Ext.util.JSON.decode(action.response.responseText); 
                        //~ Ext.Msg.alert('Login Failed!', obj.errors.reason); 
                    //~ }else{ 
                        //~ Ext.Msg.alert('Warning!', 'Authentication server is unreachable : ' + action.response.responseText); 
                    //~ } 
                    //~ Lino.login_panel.getForm().reset(); 
                //~ } 
            }); 
      };
    
      var login_button = new Ext.Button({ 
        text:'Login',
        formBind: true,	 
        // Function that fires when user clicks the button 
        handler: do_login});
    
      var login_panel = new Ext.FormPanel({ 
        //~ inspired by http://www.sencha.com/learn/a-basic-login/
        autoHeight:true,
        labelWidth:80,
        url:ADMIN_URL+'/auth', 
        frame:true, 
        defaultType:'textfield',
        monitorValid:true,
        items:[{ 
            fieldLabel:'Username', 
            name:'username', 
            autoHeight:true,
            allowBlank:false 
        },{ 
            fieldLabel:'Password', 
            name:'password', 
            inputType:'password', 
            autoHeight:true,
            allowBlank:false 
        }],        
        buttons:[ login_button ]});
        
      var enter_key_binding = {
          key: Ext.EventObject.ENTER,
          //~ fn: function() { console.log("20121104 click!"); login_button.fireEvent('click',login_button)}
          fn: function() { console.log("20121104 click!"); do_login()}
          //~ scope: login_button
      };        
        
      Lino.login_window = new Ext.Window({
          layout:'fit',
          width:300,
          title:'Please Login', 
          autoHeight:true,
          modal: true,
          closeAction: "hide",
          keys: enter_key_binding,
          //~ defaultButton: login_button,
          //~ height:'auto',
          //~ closable: false,
          //~ resizable: false,
          //~ plain: true,
          //~ border: false,
          items: [login_panel] });
  };
  Lino.login_window.show();
};

Lino.logout = function(id,name) {
    //~ console.log('20121104 gonna log out',arguments);
    //~ Lino.do_action
    Lino.call_row_action(Lino.viewport,'GET',ADMIN_URL+'/auth',{},'logout',undefined,undefined,function(){
        //~ console.log('20121104 logged out',arguments);
        //~ Lino.login_window.hide();
        Lino.close_all_windows();
    })
}

Lino.set_subst_user = function(id,name) {
    //~ console.log(20120714,'Lino.set_subst_user',id,name);
    Lino.subst_user = id;
    Lino.eventStore.setBaseParam("su",id);
    if (Lino.current_window) 
        Lino.current_window.main_item.set_base_param("su",id);
    if (Lino.viewport) Lino.permalink_handler(Lino.current_window)();
}


//~ Lino.select_subst_user = function(cmp,rec,value){
    //~ Lino.subst_user=value;
    //~ console.log(20120713,rec);
//~ }
    
Lino.current_window = null;
Lino.window_history = Array();
    
Lino.chars2width = function(cols) {  return cols * 9; }
Lino.rows2height = function(cols) {  return cols * 20; }



Lino.Viewport = Ext.extend(Ext.Viewport,{
  layout:"fit"
  ,initComponent : function(){
    Lino.Viewport.superclass.initComponent.call(this);
    this.on('render',function(){
      this.loadMask = new Ext.LoadMask(this.el,{msg:"Bitte warten..."});
    },this);
  }
  ,get_base_params : function() { 
    var p = {};
    Lino.insert_subst_user(p);
    return p;
  }
  ,refresh : function() {
      var caller = this;
      var success = function(response) {
        if (caller.loadMask) caller.loadMask.hide();
        if (response.responseText) {
          var result = Ext.decode(response.responseText);
          //~ console.log('Lino.do_action()',action.name,'result is',result);
          if (result.html) {
              Ext.getCmp('main_area').update(result.html);
          }
          if (result.message) {
              if (result.alert) {
                  //~ Ext.MessageBox.alert('Alert',result.alert_msg);
                  Ext.MessageBox.alert('Alert',result.message);
              } else {
                  Lino.notify(result.message);
              }
          }
          
          if (result.notify_msg) Lino.notify(result.notify_msg);
          if (result.js_code) { 
            var jsr = result.js_code(caller);
            //~ console.log('Lino.do_action()',action,'returned from js_code in',result);
          };
        }
      };
      var action = {
        url : ADMIN_URL + '/api/main_html',
        waitMsg: "Bitte warten...",
        failure: Lino.ajax_error_handler(caller),
        success: success,
        method: 'GET',
        params: {}
      };
      Lino.insert_subst_user(action.params);
      Ext.Ajax.request(action);
    
  }
});



Lino.open_window = function(win,st,requesting_panel) {
  //~ console.log("20120918 Lino.open_window()",win,st);
  var cw = Lino.current_window;
  if (cw) {
    //~ console.log("20120918 Lino.open_window() save current status",cw.main_item.get_status());
    Lino.window_history.push({
      window:cw,
      status:cw.main_item.get_status()
    });
  }
  Lino.current_window = win;
  //~ if (st.su) 
      //~ Lino.subst_user_field.setValue(st.su);
  win.main_item.set_status(st,requesting_panel);
  win.show();
};

Lino.close_window = function(status_update) {
  var cw = Lino.current_window;
  var ww = Lino.window_history.pop();
  if (ww) {
    //~ if (status_update) Ext.apply(ww.status,status_update);
    if (status_update) status_update(ww);
    ww.window.main_item.set_status(ww.status);
    Lino.current_window = ww.window;
  } else {
    Lino.current_window = null;
  }
  if (cw) cw.hide_really();
};

Lino.close_all_windows = function() {
  if (Lino.window_history.length == 0) {
      //~ Lino.viewport.refresh();
      var url = ADMIN_URL + "/"
      //~ console.log("20120222 Lino.close_all_windows() : location.replace(",ADMIN_URL,")");
      //~ if (ADMIN_URL) 
      var p = {};
      Lino.insert_subst_user(p)
      if (Ext.urlEncode(p)) url = url + "?" + Ext.urlEncode(p);
      location.replace(url);
  } else {
    //~ console.log("20120222 Lino.close_all_windows()",Lino.window_history);
    while (Lino.window_history.length > 0) {
      Lino.close_window();
      //~ Lino.window_history.pop().hide_really();
    }
  }
  //~ Lino.current_window = null;
  //~ Lino.close_window();
  //~ var ww = 
}

Lino.kill_current_window = function() {
  var cw = Lino.current_window;
  Lino.current_window = null;
  if (cw) cw.hide_really();
};

Lino.calling_window = function() {
    if (Lino.window_history.length) return Lino.window_history[Lino.window_history.length-1];
}

//~ Lino.WindowAction = function(mainItemClass,windowConfig,mainConfig,ppf) {
Lino.WindowAction = function(windowConfig,main_item_fn) {
    //~ if(!mainConfig) mainConfig = {};
    //~ mainConfig.is_main_window = true;
    this.windowConfig = windowConfig;
    this.main_item_fn = main_item_fn;
    //~ if (ppf) mainConfig.params_panel.fields = ppf;
    //~ this.mainConfig = mainConfig;
    //~ this.mainItemClass = mainItemClass;
};

Lino.WindowAction = Ext.extend(Lino.WindowAction,{
    window : null,
    //~ mainItemClass: null,
    get_window : function() {
      //~ if(mainConfig) Ext.apply(this.mainConfig,mainConfig);
      if (this.window == null)  {
          //~ this.windowConfig.main_item = new this.mainItemClass(this.mainConfig);
          this.windowConfig.main_item = this.main_item_fn();
          this.window = new Lino.Window(this.windowConfig);
      }
      return this.window;
    },
    run : function(requesting_panel,status) {
      //~ console.log('20120625 window_action.run()',this)
      Lino.open_window(this.get_window(),status,requesting_panel);
    }
  
});


Lino.PanelMixin = {
  get_containing_window : function (){
      if (this.containing_window) return this.containing_window;
      return this.containing_panel.get_containing_window();
  }
  ,set_window_title : function(title) {
    //~ this.setTitle(title);
    var cw = this.get_containing_window();

    //~ if (cw) {
    //~ if (cw && cw.closable) {
    if (cw && !cw.main_item.hide_window_title) {
      //~ console.log('20111202 set_window_title(',title,') for',this.containing_window);
      //~ if (! this.containing_window.rendered) console.log("WARNING: not rendered!");
      cw.setTitle(title);
    //~ } else {
      //~ document.title = title;
    }
    //~ else console.log('20111202 not set_window_title(',title,') for',this);
  }
  
};


Lino.status_bar = new Ext.ux.StatusBar({defaultText:'Lino version 1.5.1.'});


Lino.edit_tinymce_text = function(panel,options) {
  // `panel` is the RichTextPanel
  //~ console.log(20111220,panel);
  //~ var rec = panel.get_current_record();
  var rec = panel.containing_panel.get_current_record();
  var value = rec ? rec.data[panel.editor.name] : '';
  var saving = false;
  var todo_after_save = false;
  var discard_changes = false;
  
  
  function save() {
    //~ if (todo_after_save) {alert('tried to save again'); return; }
    if (saving) {alert('tried to save again'); return; }
    //~ var url = panel.containing_window.main_item.get_record_url(rec.id);
    var url = panel.containing_panel.get_record_url(rec.id);
    var params = Ext.apply({},panel.containing_panel.get_base_params());
    params[panel.editor.name] = editor.getValue();
    //~ params.su = Lino.subst_user;
    //~ Lino.insert_subst_user(params);
    var a = { 
      params: params, 
      method: 'PUT',
      url: url,
      failure: function() {
          //~ if (editor.ed.getContainer()) 
          editor.ed.setProgressState(0);
          todo_after_save = false;
          saving = false;
          console.log('tinymce.save() failed. sorry.',arguments);
        },
      success: function() {
        saving = false;
        //~ if (editor.ed.getContainer()) 
        editor.ed.setProgressState(0);
        rec.data[panel.editor.name] = editor.getValue();
        if(todo_after_save) {
            var fn = todo_after_save;
            todo_after_save = false;
            fn();
        }
        //~ panel.containing_window.set_current_record(rec);
        panel.refresh();
      }
    };
    //~ if (editor.ed.getContainer()) 
    editor.ed.setProgressState(1); // Show progress
    saving = true;
    //~ console.log(a);
    Ext.Ajax.request(a);
  };
  function save_callback() {
      save();
      //~ save(function(){editor.ed.setDirty(false);})
      /* return true have the save button disabled.  
      That's not perfect because the PUT is asynchronous 
      and the response is not yet known.
      */
      return true;
  }
  //~ var actions = [
    //~ {text:"Save",handler:save}
  //~ ]; 
  //~ console.log(20110610,panel.editor.disabled);
  var settings = {};
  Ext.apply(settings,{
        readonly: panel.editor.disabled,
        //~ language: "de",
        plugins : "save,emotions,spellchecker,advhr,insertdatetime,preview,table,searchreplace,template", 
        // Theme options - button# indicated the row# only
        theme_advanced_buttons1 : "save,cancel,|,bold,italic,underline,|,justifyleft,justifycenter,justifyright,fontselect,fontsizeselect,formatselect,|,search,replace",
        theme_advanced_buttons2 : "cut,copy,paste,template,|,bullist,numlist,|,outdent,indent,|,undo,redo,|,link,unlink,anchor,image,|,code,preview,|,forecolor,backcolor",
        theme_advanced_buttons3 : "insertdate,inserttime,|,spellchecker,advhr,,removeformat,|,sub,sup,|,charmap,emotions,|,tablecontrols",      
        theme_advanced_resizing : false,
        save_onsavecallback : save_callback,
        save_enablewhendirty : true
        //~ save_oncancelcallback: on_cancel
  });
  Ext.apply(settings,options);
  var editor = new Ext.ux.TinyMCE({
      value : value,
      tinymceSettings: settings
    });
  var win = new Ext.Window({
    title: rec.title, 
    //~ bbar: actions,
    layout: 'fit',
    items: editor,
    width: 600, 
    height:500,
    minWidth: 100,
		minHeight: 100,
    modal: true,
    resizable: true,
    maximizable: true,
    //~ maximized: true,
    //~ closeAction: "close"
    closeAction: "hide"
    //~ hideMode: "offsets",
    //~ constrainHeader: true,
    //~ bodyStyle: 'padding: 10px'
  });

  //~ win.on('beforeclose',function() {
  win.on('beforehide',function() {
    if (todo_after_save) return false;
    if (discard_changes) return true;
    if (editor.isDirty()) {
        //~ var ok = false;
        //~ var allowClose = true;
        var config = {title:"Bestätigung"};
        config.buttons = Ext.MessageBox.YESNOCANCEL;
        config.msg = "Änderungen im Text speichern?";
        config.modal = true;
        config.fn = function(buttonId,text,opt) {
          //~ console.log('do_when_clean',buttonId)
          if (buttonId == "yes") {
              /* we cancel this close, but save()'s onSuccess will call again.*/
              //~ allowClose = false;
              todo_after_save = function(){win.hide();}
              editor.ed.execCommand('mceSave');
              //~ editor.ed.save(function(){win.close();});
          } else if (buttonId == "no") { 
              discard_changes = true;
              win.hide()
          //~ } else if (buttonId == "cancel") { 
            //~ ok = true;
              //~ allowClose = false;
          //~ } else { 
            //~ console.log('unknwon buttonId:',buttonId);
          }
        }
        Ext.MessageBox.show(config);
        return false;
        //~ return allowClose;
    }
  });
  win.show();
}





/* 
  Originally copied from Ext JS Library 3.3.1
  Modifications by Luc Saffre : 
  - rendering of phantom records
  - fire afteredit event
  - react on dblclcik, not on single click

 */
Lino.CheckColumn = Ext.extend(Ext.grid.Column, {

    processEvent : function(name, e, grid, rowIndex, colIndex){
        //~ console.log('20110713 Lino.CheckColumn.processEvent',name)
        if (name == 'click') {
        //~ if (name == 'mousedown') {
        //~ if (name == 'dblclick') {
            return this.toggleValue(grid, rowIndex, colIndex);
        } else {
            return Ext.grid.ActionColumn.superclass.processEvent.apply(this, arguments);
        }
    },
    
    toggleValue : function (grid,rowIndex,colIndex) {
        var record = grid.store.getAt(rowIndex);
        var dataIndex = grid.colModel.getDataIndex(colIndex);
        // 20120514
        //~ if(record.data.disabled_fields && record.data.disabled_fields[dataIndex]) {
          //~ Lino.notify("Dieses Feld ist deaktiviert");
          //~ return false;
        //~ }
      
        //~ if (dataIndex in record.data['disabled_fields']) {
            //~ Lino.notify("This field is disabled.");
            //~ return false;
        //~ }
        var startValue = record.data[dataIndex];
        var value = !startValue;
        //~ record.set(this.dataIndex, value);
        var e = {
            grid: grid,
            record: record,
            field: dataIndex,
            originalValue: startValue,
            value: value,
            row: rowIndex,
            column: colIndex,
            cancel: false
        };
        if(grid.fireEvent("beforeedit", e) !== false && !e.cancel){
        //~ if(grid.fireEvent("validateedit", e) !== false && !e.cancel){
            record.set(dataIndex, value);
            delete e.cancel;
            grid.fireEvent("afteredit", e);
        }
        return false; // Cancel event propagation
    },

    renderer : function(v, p, record){
        if (record.phantom) return '';
        p.css += ' x-grid3-check-col-td'; 
        return String.format('<div class="x-grid3-check-col{0}">&#160;</div>', v ? '-on' : '');
    }

    // Deprecate use as a plugin. Remove in 4.0
    // init: Ext.emptyFn
});

// register ptype. Deprecate. Remove in 4.0
// Ext.preg('checkcolumn', Lino.CheckColumn);

// backwards compat. Remove in 4.0
// Ext.grid.CheckColumn = Lino.CheckColumn;

// register Column xtype
Ext.grid.Column.types.checkcolumn = Lino.CheckColumn;


/* 20110725 : 
Lino.on_tab_activate is necessary 
in contacts.Person.2.dtl 
(but don't ask me why...)
*/
Lino.on_tab_activate = function(item) {
  //~ console.log('activate',item); 
  if (item.rendered && item.doLayout) item.doLayout();
  //~ if (item.rendered) item.doLayout();
}

Lino.TimeField = Ext.extend(Ext.form.TimeField,{
  format: 'H:i',
  increment: 15
  });
Lino.DateField = Ext.extend(Ext.form.DateField,{
  boxMinWidth: Lino.chars2width(11),
  format: 'd.m.Y',
  altFormats: 'd/m/Y|Y-m-d'
  });
Lino.DateTimeField = Ext.extend(Ext.ux.form.DateTime,{
  dateFormat: 'd.m.Y',
  timeFormat: 'H:i',
  //~ hiddenFormat: 'd.m.Y H:i'
  });
Lino.URLField = Ext.extend(Ext.form.TriggerField,{
  triggerClass : 'x-form-search-trigger',
  //~ triggerClass : 'x-form-world-trigger',
  vtype: 'url',
  onTriggerClick : function() {
    //~ console.log('Lino.URLField.onTriggerClick',this.value)
    //~ document.location = this.value;
    window.open(this.getValue(),'_blank');
  }
});
Lino.IncompleteDateField = Ext.extend(Ext.form.TextField,{
  //~ regex: /^-?\d+-[01]\d-[0123]\d$/,
  //~ regex: /^[0123]\d\.[01]\d\.-?\d+$/,
  maxLength: 10,
  boxMinWidth: Lino.chars2width(10),
  regex: /^[0123]?\d\.[01]?\d\.-?\d+$/,
  regexText: 'Bitte ein Datum im Format YYYY-MM-DD eingeben (0 für unbekannte Teile).'
  });


//~ Lino.make_dropzone = function(cmp) {
    //~ cmp.on('render', function(ct, position){
      //~ ct.el.on({
        //~ dragenter:function(event){
          //~ event.browserEvent.dataTransfer.dropEffect = 'move';
          //~ return true;
        //~ }
        //~ ,dragover:function(event){
          //~ event.browserEvent.dataTransfer.dropEffect = 'move';
          //~ event.stopEvent();
          //~ return true;
        //~ }
        //~ ,drop:{
          //~ scope:this
          //~ ,fn:function(event){
            //~ event.stopEvent();
            //~ console.log(20110516);
            //~ var files = event.browserEvent.dataTransfer.files;
            //~ if(files === undefined){
              //~ return true;
            //~ }
            //~ var len = files.length;
            //~ while(--len >= 0){
              //~ console.log(files[len]);
              //~ // this.processDragAndDropFileUpload(files[len]);
            //~ }
          //~ }
        //~ }
      //~ });
    //~ });
//~ };

//~ Lino.FileUploadField = Ext.ux.form.FileUploadField;

Lino.FileUploadField = Ext.extend(Ext.ux.form.FileUploadField,{
    onRender : function(ct, position){
      Lino.FileUploadField.superclass.onRender.call(this, ct, position);
      this.el.on({
        dragenter:function(event){
          event.browserEvent.dataTransfer.dropEffect = 'move';
          return true;
        }
        ,dragover:function(event){
          event.browserEvent.dataTransfer.dropEffect = 'move';
          event.stopEvent();
          return true;
        }
        ,drop:{
          scope:this
          ,fn:function(event){
            event.stopEvent();
            //~ console.log(20110516);
            var files = event.browserEvent.dataTransfer.files;
            if(files === undefined){
              return true;
            }
            var len = files.length;
            while(--len >= 0){
              console.log(files[len]);
              //~ this.processDragAndDropFileUpload(files[len]);
            }
          }
        }
      });
    }
});

Lino.FileField = Ext.extend(Ext.form.TriggerField,{
  triggerClass : 'x-form-search-trigger',
  editable: false,
  onTriggerClick : function() {
    //~ console.log('Lino.URLField.onTriggerClick',this.value)
    //~ document.location = this.value;
    if (this.getValue()) window.open(MEDIA_URL + '/'+this.getValue(),'_blank');
  }
});

Lino.file_field_handler = function(panel,config) {
  //~ if (instanceof Lino.DetailWrapper) {
  if (panel.action_name == 'insert') {
  //~ if (panel.get_current_record().phantom) {
      panel.has_file_upload = true;
      var f = new Lino.FileUploadField(config);
      //~ Lino.make_dropzone(f);
      return f;
      //~ return new Ext.ux.form.FileUploadField(config);
      //~ return new Lino.FileField(config);
  } else {
      //~ return new Lino.URLField(config);
      return new Lino.FileField(config);
  }
}

Lino.VBorderPanel = Ext.extend(Ext.Panel,{
    constructor : function(config) {
      config.layout = 'border';
      delete config.layoutConfig;
      Lino.VBorderPanel.superclass.constructor.call(this,config);
      for(var i=0; i < this.items.length;i++) {
        var item = this.items.get(i);
        if (this.isVertical(item) && item.collapsible) {
          item.on('collapse',this.onBodyResize,this);
          item.on('expand',this.onBodyResize,this);
        }
      }
    },
    isVertical : function(item) {
       return (item.region == 'north' || item.region == 'south' || item.region == 'center');
    },
    onBodyResize: function(w, h){
        //~ console.log('VBorderPanel.onBodyResize',this.title)
      if (this.isVisible()) { // to avoid "Uncaught TypeError: Cannot call method 'getHeight' of undefined."
        var sumflex = 0;
        var availableHeight = this.getInnerHeight();
        var me = this;
        this.items.each(function(item){
          if (me.isVertical(item)) {
              if (item.collapsed || item.flex == 0 || item.flex === undefined) {
                  if (item.rendered) availableHeight -= item.getHeight();
              } else {
                  sumflex += item.flex;
              }
          } 
          
        });
        //~ for(var i=0; i < this.items.length;i++) {
          //~ var item = this.items.get(i);
          //~ // if (this.isVertical(item) && item.getResizeEl()) {
          //~ if (this.isVertical(item)) {
              //~ if (item.collapsed || item.flex == 0 || item.flex === undefined) {
                  //~ // item.syncSize()
                  //~ // item.doLayout()
                  //~ // if (item.region == "north") console.log('region north',item.getHeight(),item.id, item);
                  //~ // if (item.getHeight() == 0) console.log(20100921,'both flex and getHeight() are 0!');
                  //~ availableHeight -= item.getHeight();
              //~ } else {
                  //~ sumflex += item.flex;
                  //~ // console.log(item.flex);
              //~ }
          //~ } 
          //~ // else console.log('non-vertical item in VBoderPanel:',item)
        //~ }
        var hunit = availableHeight / sumflex;
        //~ console.log('sumflex=',sumflex,'hunit=',hunit, 'availableHeight=',availableHeight);
        for(var i=0; i < this.items.length;i++) {
          var item = this.items.get(i);
          if (this.isVertical(item)) {
              if (item.flex != 0 && ! item.collapsed) {
                  item.setHeight(hunit * item.flex);
                  //~ console.log(item.region,' : height set to',item.getHeight());
              }
          }
          //~ else console.log('non-vertical item in VBoderPanel:',item)
        }
      }
      Lino.VBorderPanel.superclass.onBodyResize.call(this, w, h);
    }
});


/*
  modifications to the standard behaviour of a CellSelectionModel:
  
*/
Ext.override(Ext.grid.CellSelectionModel, {
//~ var dummy = {

    handleKeyDown : function(e){
        /* removed because F2 wouldn't pass
        if(!e.isNavKeyPress()){
            return;
        }
        */
        //~ console.log('handleKeyDown',e)
        var k = e.getKey(),
            g = this.grid,
            s = this.selection,
            sm = this,
            walk = function(row, col, step){
                return g.walkCells(
                    row,
                    col,
                    step,
                    g.isEditor && g.editing ? sm.acceptsNav : sm.isSelectable, 
                    sm
                );
            },
            cell, newCell, r, c, ae;

        switch(k){
            case e.ESC:
            case e.PAGE_UP:
            case e.PAGE_DOWN:
                break;
            default:
                // e.stopEvent(); // removed because Browser keys like Alt-Home, Ctrl-R wouldn't work
                break;
        }

        if(!s){
            cell = walk(0, 0, 1); 
            if(cell){
                this.select(cell[0], cell[1]);
            }
            return;
        }

        cell = s.cell;  
        r = cell[0];    
        c = cell[1];    
        
        switch(k){
            case e.TAB:
                if(e.shiftKey){
                    newCell = walk(r, c - 1, -1);
                }else{
                    newCell = walk(r, c + 1, 1);
                }
                break;
            case e.HOME:
                if (! (g.isEditor && g.editing)) {
                  if (!e.hasModifier()){
                      newCell = [r, 0];
                      //~ console.log('home',newCell);
                      break;
                  }else if(e.ctrlKey){
                      var t = g.getTopToolbar();
                      var activePage = Math.ceil((t.cursor + t.pageSize) / t.pageSize);
                      if (activePage > 1) {
                          e.stopEvent();
                          t.moveFirst();
                          return;
                      }
                      newCell = [0, c];
                      break;
                  }
                }
            case e.END:
                if (! (g.isEditor && g.editing)) {
                  c = g.colModel.getColumnCount()-1;
                  if (!e.hasModifier()) {
                      newCell = [r, c];
                      //~ console.log('end',newCell);
                      break;
                  }else if(e.ctrlKey){
                      var t = g.getTopToolbar();
                      var d = t.getPageData();
                      if (d.activePage < d.pages) {
                          e.stopEvent();
                          var self = this;
                          t.on('change',function(tb,pageData) {
                              var r = g.store.getCount()-2;
                              self.select(r, c);
                              //~ console.log('change',r,c);
                          },this,{single:true});
                          t.moveLast();
                          return;
                      } else {
                          newCell = [g.store.getCount()-1, c];
                          //~ console.log('ctrl-end',newCell);
                          break;
                      }
                  }
                }
            case e.DOWN:
                newCell = walk(r + 1, c, 1);
                break;
            case e.UP:
                newCell = walk(r - 1, c, -1);
                break;
            case e.RIGHT:
                newCell = walk(r, c + 1, 1);
                break;
            case e.LEFT:
                newCell = walk(r, c - 1, -1);
                break;
            case e.F2:
                if (!e.hasModifier()) {
                    if (g.isEditor && !g.editing) {
                        g.startEditing(r, c);
                        e.stopEvent();
                        return;
                    }
                    break;
                }
            case e.INSERT:
                if (!e.hasModifier()) {
                    if (g.ls_insert_handler && !g.editing) {
                        e.stopEvent();
                        Lino.show_insert(g);
                        return;
                    }
                    break;
                }
            case e.DELETE:
                if (!e.hasModifier()) {
                    if (!g.editing) {
                        e.stopEvent();
                        Lino.delete_selected(g);
                        return;
                    }
                    break;
                }
            case e.ENTER:
                e.stopEvent();
                g.onCellDblClick(r,c);
                break;
                
        }
        

        if(newCell){
          e.stopEvent();
          r = newCell[0];
          c = newCell[1];
          this.select(r, c); 
          if(g.isEditor && g.editing){ 
            ae = g.activeEditor;
            if(ae && ae.field.triggerBlur){
                ae.field.triggerBlur();
            }
            g.startEditing(r, c);
          }
        //~ } else if (g.isEditor && !g.editing && e.charCode) {
        //~ // } else if (!e.isSpecialKey() && g.isEditor && !g.editing) {
            //~ g.set_start_value(String.fromCharCode(e.charCode));
            //~ // g.set_start_value(String.fromCharCode(k));
            //~ // g.set_start_value(e.charCode);
            //~ g.startEditing(r, c);
            //~ // e.stopEvent();
            //~ return;
        // } else {
          // console.log('20120513',e,g);
        }
        
    }


//~ };
});

 

function PseudoConsole() {
    this.log = function() {};
};
if (typeof(console) == 'undefined') console = new PseudoConsole();

Lino.notify = function(msg) {
  if (msg == undefined) msg = ''; else console.log(msg);
  //~ Ext.getCmp('konsole').update(msg);
  Lino.status_bar.setStatus({
    text: msg,
    iconCls: 'ok-icon',
    clear: true // auto-clear after a set interval
  });
  //~ Ext.getCmp('konsole').setTitle(msg.replace(/\n/g,'<br/>'));
  //~ Ext.getCmp('konsole').update(msg.replace(/\n/g,'<br/>'));
};
Lino.alert = function(msg) {
  //~ if (msg == undefined) msg = ''; else console.log(msg);
  Ext.MessageBox.alert('Notify',msg);
};


//~ Lino.show_about = function() {
  //~ new Ext.Window({
    //~ width: 400, height: 400,
    //~ title: "About",
    //~ html: '<a href="http://www.extjs.com" target="_blank">ExtJS</a> version ' + Ext.version
  //~ }).show();
//~ };

function obj2str(o) {
  if (typeof o != 'object') return String(o);
  var s = '';
  for (var p in o) {
    s += p + ': ' + obj2str(o[p]) + '\n';
  }
  return s;
}

Lino.on_store_exception = function (store,type,action,options,response,arg) {
  //~ throw response;
  console.log("on_store_exception: store=",store,
    "type=",type,
    "action=",action,
    "options=",options,
    "response=",response,
    "arg=",arg);
  if (arg) { console.log(arg.stack)};
};

//~ Lino.on_submit_success = function(form, action) {
   //~ Lino.notify(action.result.message);
   //~ this.close();
//~ };

Lino.on_submit_failure = function(form, action) {
    //~ Lino.notify();
  // action may be undefined
    switch (action.failureType) {
        case Ext.form.Action.CLIENT_INVALID:
            Ext.Msg.alert('Client-side failure', 'Form fields may not be submitted with invalid values');
            break;
        case Ext.form.Action.CONNECT_FAILURE:
            Ext.Msg.alert('Connection failure', 'Ajax communication failed');
            break;
        case Ext.form.Action.SERVER_INVALID:
            Ext.Msg.alert('Server-side failure', action.result.message);
   }
};



/*
Lino.save_wc_handler = function(ww) {
  return function(event,toolEl,panel,tc) {
    var pos = panel.getPosition();
    var size = panel.getSize();
    wc = ww.get_window_config();
    Ext.applyIf(wc,{ 
      x:pos[0],y:pos[1],height:size.height,width:size.width,
      maximized:panel.maximized});
    Lino.do_action(ww,{url:'/window_configs/'+ww.config.permalink_name,params:wc,method:'POST'});
  }
};

*/

Lino.show_in_own_window_button = function(handler) {
  return {
    qtip: "Tabelle in eigenem Fenster bearbeiten.", 
    id: "up",
    handler: function(event,toolEl,panel, tc) {
      //~ console.log('20111206 report_window_button',panel,handler);
      //~ var bp = ww.get_master_params();
      //~ panel.containing_window = ww; // for HtmlBox. see blog/2010/1022
      //~ handler(panel,{base_params:bp});
      //~ handler(panel,{base_params:panel.get_master_params()});
      handler.run(null,{base_params:panel.containing_panel.get_master_params()});
      //~ handler(panel,{master_panel:panel.containing_window.main_item});
    }
  }
}




Lino.delete_selected = function(panel) {
  //~ console.log("Lino.delete_selected",panel);
  var recs1 = panel.get_selected();
  var recs = [];
  for ( var i=0; i < recs1.length; i++ ) { if (! recs1[i].phantom) recs.push(recs1[i]); }
  if (recs.length == 0) {
    Lino.notify("Please select at least one record.");
    return;
  };
  if (recs.length == 1) {
      if (recs[0].disable_delete) {
        Lino.alert(recs[0].disable_delete);
        return;
      }
  };
  //~ console.log(recs);
  Ext.MessageBox.show({
    title: "Bestätigung",
    msg: String.format("Es werden {0} Datensätze gelöscht. Sind Sie sicher?",String(recs.length)),
    //~ msg: "Delete " + String(recs.length) + " rows. Are you sure?",
    //~ buttons: Ext.MessageBox.YESNOCANCEL,
    buttons: Ext.MessageBox.YESNO,
    fn: function(btn) {
      if (btn == 'yes') {
        for ( var i=0; i < recs.length; i++ ) {
          Lino.do_action(panel,{
              method:'DELETE',
              url: ADMIN_URL + '/api' + panel.ls_url + '/' + recs[i].id,
              after_success: panel.after_delete.createDelegate(panel)
          })
        }
        //~ caller.after_delete();
      }
      else Lino.notify("Dann eben nicht.");
    }
  });
};

Lino.action_handler = function (panel,on_success,on_confirm) {
  return function (response) {
    //~ console.log(20120608,panel);
    if (panel instanceof Lino.GridPanel) {
        //~ gridmode = false;
        gridmode = true;
        //~ console.log('20120608 yes');
    } else {
        gridmode = false;
        //~ console.log('20120608 no');
    }
    panel.loadMask.hide(); // 20120211
    if (response.responseText) {
      var result = Ext.decode(response.responseText);
      //~ console.log('Lino.action_handler()','result is',result,'on_confirm is',on_confirm);
      if (on_success && result.success) on_success(result);
      if (on_confirm && result.confirm_message) {
          var config = {title:"Bestätigung"};
          config.buttons = Ext.MessageBox.YESNOCANCEL;
          config.msg = result.confirm_message;
          config.fn = function(buttonId,text,opt) {
            if (buttonId == "yes") {
                on_confirm(panel,undefined,result.step);
            }
          }
          Ext.MessageBox.show(config);
          return;
      }
      if (result.dialog_fn) {
          console.log('20120928 TODO',result.dialog_fn);
      }
      if (result.message) {
          //~ if (result.alert && ! gridmode) {
          if (result.alert) { // 20120628b 
              //~ Ext.MessageBox.alert('Alert',result.alert_msg);
              if (result.alert === true) result.alert = "Warnung";
              Ext.MessageBox.alert(result.alert,result.message);
          } else {
              Lino.notify(result.message);
          }
      }
      // 
      if (result.data_record && ! gridmode) {
          //~ not used
          panel.set_status({data_record:result.data_record});
      }
      else if (result.new_status && ! gridmode) {
          //~ not used
          //~ console.log('20120607 new_status');
          panel.set_status(result.new_status);
      }
      else if (result.goto_record_id != undefined && ! gridmode) {
          //~ console.log('20120607 new_status');
          panel.load_record_id(result.goto_record_id);
      }
      else if (result.refresh_all) {
          var cw = panel.get_containing_window();
          //~ console.log("20120123 refresh_all");
          if (cw) {
            cw.main_item.refresh();
          }
          else console.log("20120123 cannot refresh_all",panel);
      } else {
          if (result.refresh) panel.refresh();
      }
      if (result.open_url) {
          //~ console.log(20111126,result.open_url);
          //~ if (!result.message)
              //~ Lino.notify('Open new window <a href="'+result.open_url+'" target="_blank">'+result.open_url+'</a>');
          window.open(result.open_url,'foo',"");
          //~ document.location = result.open_url;
      }
      if (result.eval_js) {
          //~ console.log(20120618,result.eval_js);
          eval(result.eval_js);
      }
    }
  }
};

Lino.do_action = function(caller,action) {
  action.success = function(response) {
    if (caller.loadMask) caller.loadMask.hide();
    //~ console.log('Lino.do_action()',action,'action success',response);
    if (action.after_success) {
        //~ console.log('Lino.do_action() calling after_success');
        action.after_success();
    }
    if (response.responseText) {
      var result = Ext.decode(response.responseText);
      //~ console.log('Lino.do_action()',action.name,'result is',result);
      if (result.message) {
          if (result.alert) {
              //~ Ext.MessageBox.alert('Alert',result.alert_msg);
              Ext.MessageBox.alert('Alert',result.message);
          } else {
              Lino.notify(result.message);
          }
      }
      
      //~ if (result.alert_msg) Ext.MessageBox.alert('Alert',result.alert_msg);
      //~ if (result.message) Lino.notify(result.message);
      if (result.notify_msg) Lino.notify(result.notify_msg);
      if (result.js_code) { 
        //~ console.log('Lino.do_action()',action,'gonna call js_code in',result);
        var jsr = result.js_code(caller);
        //~ console.log('Lino.do_action()',action,'returned from js_code in',result);
        if (action.after_js_code) {
          //~ console.log('Lino.do_action()',action,'gonna call after_js_code');
          action.after_js_code(jsr);
          //~ console.log('Lino.do_action()',action,'returned from after_js_code');
        //~ } else {
          //~ console.log('Lino.do_action()',action,' : after_js_code is false');
        }
      };
    }
  };
  Ext.applyIf(action,{
    waitMsg: "Bitte warten...",
    failure: Lino.ajax_error_handler(caller),
    params: {}
  });
  //~ action.params.su = Lino.subst_user;
  Lino.insert_subst_user(action.params);
  
  Ext.Ajax.request(action);
};

//~ Lino.gup = function( name )
//~ {
  //~ // Thanks to http://www.netlobo.com/url_query_string_javascript.html
  //~ name = name.replace(/[\[]/,"\\\[").replace(/[\]]/,"\\\]");
  //~ var regexS = "[\\?&]"+name+"=([^&#]*)";
  //~ var regex = new RegExp( regexS );
  //~ var results = regex.exec( window.location.href );
  //~ if( results == null )
    //~ return "";
  //~ else
    //~ return results[1];
//~ };

//~ Lino.refresh_handler = function (ww) {
  //~ return function() { 
      //~ console.log('refresh',ww);
      //~ ww.main_item.doLayout(false,true);
      //~ ww.main_item.syncSize();
  //~ }
//~ };

//~ Lino.tools_close_handler = function (ww) {
  //~ return function() { 
      //~ ww.close();
  //~ }
//~ };
Lino.permalink_handler = function (ww) {
  return function() { 
    //~ console.log(20100923,ww.get_permalink());
    //~ document.location = ww.main_item.get_permalink();
    location.replace(ww.main_item.get_permalink());
    //~ console.log(20120715, ww.main_item.get_permalink());
    //~ document.location = "?permalink=" + ww.get_permalink();
    //~ document.location = "?permalink=" + ww.config.permalink_name +'()';
  }
};
//~ Lino.run_permalink = function() {
  //~ var plink = Lino.gup('permalink');
  //~ if(plink) { eval('Lino.'+plink); }
//~ }

Lino.MainPanel = {
  is_home_page : false,
  setting_param_values : false,
  config_containing_window : function(wincfg) { }
  ,init_containing_window : function(win) { }
  ,is_loading : function() { return true; } // overridden by subclasses
  ,do_when_clean : function(auto_save,todo) { todo() }
  ,get_master_params : function() {
    var p = {}
    p['mt'] = this.content_type; 
    rec = this.get_current_record()
    if (rec) {
      if (rec.phantom) {
          p['mk'] = undefined; 
      }else{
          p['mk'] = rec.id; 
      }
    } else {
      p['mk'] = undefined;
    }
    //~ console.log('get_master_params returns',p,'using record',rec);
    return p;
  }
  ,get_permalink : function() {
    //~ var p = this.main_item.get_base_params() || {};
    var p = Ext.apply({},this.get_base_params());
    delete p.fmt;
    //~ if (p.fmt) delete p.fmt;
    Ext.apply(p,this.get_permalink_params());
    //~ Lino.insert_subst_user(p);
     //~ p.fmt = 'html';
    //~ console.log('get_permalink',p,this.get_permalink_params());
    if (this.is_home_page)
        //~ var url = '';
        var url = ADMIN_URL + '/';
    else 
        var url = this.get_permalink_url();
    if (p.su == null) 
        delete p.su;
    if (Ext.urlEncode(p)) url = url + "?" + Ext.urlEncode(p);
    return url;
  }
  ,get_record_url : function(record_id) {
      var url = ADMIN_URL + '/api' + this.ls_url
      //~ var url = this.containing_window.config.url_data; // ls_url;
      url += '/' + (record_id === undefined ? '-99999' : String(record_id));
      //~ if (record_id !== undefined) url += '/' + String(record_id);
      //~ url += '/' + String(record_id);
      return url;
  }
  ,get_permalink_url : function() {
      return ADMIN_URL+'/api' + this.ls_url;
  }
  ,get_permalink_params : function() {
      //~ return {an:'grid'};
      var p = {};
      if (this.action_name)
          p['an'] = this.action_name;
      this.add_param_values(p)
      return p;
  }
  ,set_status : function(status) {}
  ,get_status : function() { return {}}
  ,refresh : function() {}
  ,get_base_params : function() { 
    var p = {};
    Lino.insert_subst_user(p);
    return p;
  }
  ,add_params_panel : function (tbar) {
      if (this.params_panel) {
        tbar = tbar.concat([{ scope:this, 
          //~ text: "[Parameter]", // gear
          iconCls: 'x-tbar-parameters',
          tooltip:"Parameter-Panel ein- bzw. ausblenden",
          enableToggle: true,
          //~ pressed: ! this.params_panel.hidden,
          pressed: ! this.params_panel_hidden,
          toggleHandler: function(btn,state) { 
            //~ if (this.params_panel.isVisible()) 
                //~ this.params_panel.hide();
            //~ else
                //~ this.params_panel.show();
            //~ console.log("20120210 add_params_panel",state,this.params_panel);
            if (state) {
              this.params_panel.show();
              this.params_panel.doLayout();
            } else this.params_panel.hide();
            this.get_containing_window().doLayout();
          }
        }]);
        var t = this;
        var refresh = function() {if (!t.setting_param_values) t.refresh();}
        Ext.each(this.params_panel.fields,function(f) {
          //~ f.on('valid',function() {t.refresh()});
          if (f instanceof Ext.form.Checkbox)
              f.on('check',refresh);
          else if (f instanceof Ext.form.TriggerField)
              f.on('select',refresh);
          else {
              if (! f.on) 
                  console.log("20121010 no method 'on'",f);
              else
                  f.on('change',refresh);
            }
          });
      }
      return tbar;
  }
  ,add_param_values : function (p) {
    if (this.params_panel) {
      /* 
      20120918 add param_values to the request string 
      *only if the params_form is dirty*.
      Otherwise Actor.default_params() would never be used.
      
      20121023 But IntegClients.params_default has non-empty default values. 
      Users must have the possibility to make them empty.
      */
      if (this.params_panel.form.isDirty()) {
        p.pv = this.get_param_values();
      }else{
        if (this.status_param_values) 
          p.pv = Lino.fields2array(
            this.params_panel.fields,this.status_param_values);
      }
      //~ if (!this.params_panel.form.isDirty()) return;
      //~ p.pv = this.get_param_values();
      //~ console.log("20120203 add_param_values added pv",pv,"to",p);
    }
  },
  get_param_values : function() { // similar to get_field_values()
      return Lino.fields2array(this.params_panel.fields);
  },
  set_param_values : function(pv) {
    if (this.params_panel) {
      //~ console.log('20120203 MainPanel.set_param_values', pv);
      this.status_param_values = pv;
      //~ this.params_panel.form.suspendEvents(false);
      this.setting_param_values = true;
      if (pv) { 
          this.params_panel.form.my_loadRecord(pv);
      } else { 
        this.params_panel.form.reset(); 
      }
      this.setting_param_values = false;
      //~ this.params_panel.form.resumeEvents();
    }
  }
};


Lino.ajax_error_handler = function(panel) {
  return function(response,options) {
    console.log('Ajax failure:',response,options);
    if (panel.loadMask) panel.loadMask.hide();
    if (response.responseText) {
      var lines = response.responseText.split('\n');
      if (lines.length > 10) {
          line = lines.splice(5,lines.length-10,"(...)");
      }
      Ext.MessageBox.alert(
        response.statusText,
        lines.join('<br/>')
        //~ response.responseText.replace(/\n/g,'<br/>'))
      )
    } else {
      Ext.MessageBox.alert('Action failed',
        'Lino server did not respond to Ajax request');
    }
  }
}
// Ext.Ajax.on('requestexception',Lino.ajax_error_handler)
 

Ext.QuickTips.init();

/* setting QuickTips dismissDelay to 0 */
// Apply a set of config properties to the singleton
//~ Ext.apply(Ext.QuickTips.getQuickTip(), {
//~ Ext.apply(Ext.ToolTip, {
    //~ dismissDelay: 0
    //~ autoHide: false,
    //~ closable: true,
    //~ maxWidth: 200,
    //~ minWidth: 100,
    //~ showDelay: 50      // Show 50ms after entering target
    //~ ,trackMouse: true
//~ });


//~ Ext.apply(Ext.QuickTip, {
    //~ dismissDelay: 0,
//~ });
  
Lino.quicktip_renderer = function(title,body) {
  return function(c) {
    var t = c.getEl();
    //~ t.dismissDelay = 0;
    Ext.QuickTips.register({
      target: t,
      //~ cls: 'lino-quicktip-classical',
      dismissDelay: 0,
      //~ autoHide: false,
      showDelay: 50,      // Show 50ms after entering target
      //~ title: title,
      text: body
    });
  }
};

  
Lino.help_text_editor = function() {
  //~ var bp = {
      //~ mk:this.content_type,
      //~ mt:1
    //~ };
    //~ console.log(20120202,bp);
  //~ Lino.lino.ContentTypes.detail({},{base_params:bp});
  //~ Lino.lino.ContentTypes.detail.run(null,{record_id:this.content_type});
  Lino.lino.ContentTypes.detail.run(null,{record_id:this.content_type});
}

// Path to the blank image should point to a valid location on your server
//~ Ext.BLANK_IMAGE_URL = MEDIA_URL + '/extjs/resources/images/default/s.gif'; 


// used as Ext.grid.Column.renderer for id columns in order to hide the special id value -99999
Lino.id_renderer = function(value, metaData, record, rowIndex, colIndex, store) {
  //~ if (record.phantom) return '';
  return value;
}

Lino.raw_renderer = function(value, metaData, record, rowIndex, colIndex, store) {
  return value;
}

Lino.text_renderer = function(value, metaData, record, rowIndex, colIndex, store) {
  //~ return "not implemented"; 
  return value;
}

//~ Lino.hide_zero_renderer = function(value, metaData, record, rowIndex, colIndex, store) {
  //~ console.log("20120510");
  //~ if (value == 0) return ''
  //~ return value;
//~ }

//~ Lino.cell_button_renderer = function(value, metaData, record, rowIndex, colIndex, store) {
  //~ return '<input type="button" onclick="alert(value)" value=" ? ">' ;
//~ }


//~ Lino.default_renderer = function(value, metaData, record, rowIndex, colIndex, store) {
  //~ if (record.phantom) return '';
  //~ return value;
//~ }

Lino.fk_renderer = function(fkname,handlername) {
  //~ console.log('Lino.fk_renderer handler=',handler);
  return function(value, metaData, record, rowIndex, colIndex, store) {
    //~ console.log('Lino.fk_renderer',fkname,rowIndex,colIndex,record,metaData,store);
    //~ if (record.phantom) return '';
    if (value) {
        var s = '<a href="javascript:' ;
        s += handlername + '.run(null,{record_id:\'' + String(record.data[fkname]) + '\'})">';
        s += value + '</a>';
        //~ console.log('Lino.fk_renderer',value,'-->',s);
        return s
    }
    return '';
  }
};

Lino.lfk_renderer = function(panel,fkname) {
  //~ console.log('Lino.fk_renderer handler=',handler);
  var handlername = 'console.log';
  return function(value, metaData, record, rowIndex, colIndex, store) {
    //~ console.log('Lino.fk_renderer',fkname,rowIndex,colIndex,record,metaData,store);
    if (record.phantom) return '';
    if (value) {
        var s = '<a href="javascript:' ;
        s += handlername + '({},{record_id:\'' + String(record.data[fkname]) + '\'})">';
        s += value + '</a>';
        //~ console.log('Lino.fk_renderer',value,'-->',s);
        return s
    }
    return '';
  }
};

//~ Lino.gfk_renderer = function() {
  //~ return function(value, metaData, record, rowIndex, colIndex, store) {
    //~ if (record.phantom) return '';
    //~ console.log('Lino.gfk_renderer',value,colIndex,record,metaData,store);
    //~ return value;
  //~ }
//~ };


Lino.build_buttons = function(panel,actions) {
  //~ console.log("20121006 Lino.build_buttons",actions);
  if (actions) {
    var buttons = Array(actions.length);
    var cmenu = Array(actions.length);
    for (var i=0; i < actions.length; i++) { 
      buttons[i] = new Ext.Toolbar.Button(actions[i]);
      cmenu[i] = actions[i]
      cmenu[i].text = actions[i].menu_item_text;
      if (actions[i].panel_btn_handler) {
          var h = actions[i].panel_btn_handler.createCallback(panel,buttons[i]);
          //~ if (actions[i].must_save) {
          if (actions[i].auto_save == true) {
              buttons[i].on('click',panel.do_when_clean.createDelegate(panel,[true,h]));
          } else if (actions[i].auto_save == null) {
              buttons[i].on('click',panel.do_when_clean.createDelegate(panel,[false,h]));
          } else if (actions[i].auto_save == false) {
              buttons[i].on('click',h);
          } else {
              console.log("20120703 unhandled auto_save value",actions[i])
          }
          cmenu[i].handler = actions[i].panel_btn_handler.createCallback(panel,cmenu[i]);
      }
    }
    return {bbar:buttons, cmenu:new Ext.menu.Menu(cmenu)};
  }
}

Lino.do_when_visible = function(cmp,todo) {
  //~ if (cmp.el && cmp.el.dom) 
  if (cmp.isVisible()) { 
    // 'visible' means 'rendered and not hidden'
    //~ console.log(cmp.title,'-> cmp is visible now');
    todo(); 
  //~ } else {
      //~ cmp.on('resize',todo,cmp,{single:true});
  //~ }
  //~ if (false) { // 20120213
  } else { 
    //~ console.log('Lino.do_when_visible() must defer because not isVisible()',todo,cmp);
    if (cmp.rendered) {
      //~ console.log(cmp,'-> cmp is rendered but not visible: and now?');
      //~ console.log(cmp.title,'-> cmp is rendered but not visible: try again in a moment...');
      //~ var fn = function() {Lino.do_when_visible(cmp,todo)};
      //~ fn.defer(100);
      
      Lino.do_when_visible.defer(50,this,[cmp,todo]);
      //~ Lino.do_when_visible.defer(100,this,[cmp,todo]);
      
    } else {
      //~ console.log(cmp.title,'-> after render');
      cmp.on('afterrender',todo,cmp,{single:true});
    }
  }
  
};    

/*
*/
Lino.do_on_current_record = function(panel,fn,phantom_fn) {
  var rec = panel.get_current_record();
  if (rec == undefined) {
    Lino.notify("There's no selected record.");
    return;
  }
  // 20120307 A VirtualTable with a Detail (lino.Models) has only "phantom" records.
  if (rec.phantom) {
    //~ if (!panel.editable) { console.log("20120312 not editable:",panel)}
    if (phantom_fn) {
      phantom_fn(panel);
    } else {
      Lino.notify("Aktion nicht verfügbar auf dem Phantom-Record.");
    }
    return;
  }
  return fn(rec);
};


Lino.call_row_action = function(panel,method,url,p,actionName,step,on_confirm,on_success) {
  p.an = actionName;
  if (!panel) panel = Lino.viewport;
  Ext.apply(p,panel.get_base_params());
  panel.loadMask.show(); 
  //~ p.su = Lino.subst_user;
  //~ Lino.insert_subst_user(p);
    
  if (step) p['as'] = step;
  Ext.Ajax.request({
    method: method,
    url: url,
    params: p,
    success: Lino.action_handler(panel,on_success,on_confirm)
  });
};

Lino.row_action_handler = function(actionName) {
  var fn = function(panel,btn,step) {
    Lino.do_on_current_record(panel,function(rec) {
      //~ console.log(panel);
      //~ 20120723 Lino.call_row_action(panel,rec.id,actionName,step,fn);
      Lino.call_row_action(panel,'GET',panel.get_record_url(rec.id),{},actionName,step,fn);
    });
  };
  return fn;
};

Lino.param_action_handler = function(window_action) { // 20121012
  var fn = function(panel,btn,step) {
    Lino.do_on_current_record(panel,function(rec) {
      //~ console.log(panel);
      //~ 20120723 Lino.call_row_action(panel,rec.id,actionName,step,fn);
      window_action.run(panel.getId(),{}); 
    });
  };
  return fn;
};


Lino.run_row_action = function(requesting_panel,url,pk,actionName) {
  //~ var panel = action.get_window().main_item;
  url = ADMIN_URL + '/api' + url  + '/' + pk;
  var panel = Ext.getCmp(requesting_panel);
  var fn = function(panel,btn,step) {
    //~ 20120723 Lino.call_row_action(panel,pk,actionName,step,fn);
    Lino.call_row_action(panel,'GET',url,{},actionName,step,fn);
  }
  fn(panel,null,null);
}


Lino.unused_list_action_handler = function(actionName,gridmode) {
  var fn = function(panel,btn,step) {
    //~ console.log(panel);
    var url = ADMIN_URL + '/api' + panel.ls_url ;
    var p = Ext.apply({},panel.get_base_params());
    p.an = actionName;
    //~ p.su = Lino.subst_user;
    //~ Lino.insert_subst_user(p);
    if (step) p['as'] = step;
    panel.loadMask.show(); // 20120211
    Ext.Ajax.request({
      method: 'GET',
      url: url,
      params: p,
      success: Lino.action_handler(panel,undefined,fn)
    });
  };
  return fn;
};

Lino.show_detail = function(panel,btn) {
  Lino.do_on_current_record(panel, 
    function(rec) {
      //~ panel.loadMask.show();
      var bp = panel.get_base_params();
      //~ var bp = {};
      panel.add_param_values(bp); // 20120918
      var status = {
        record_id:rec.id,
        base_params:bp
        //~ param_values: pv.pv
      }
      //~ console.log("20120918 Lino.show_detail",status);
      panel.ls_detail_handler.run(null,status);
      //~ panel.loadMask.hide();
      //~ panel.containing_window.window.hideMask();
      //~ panel.el.unmask();
    },
    Lino.show_insert
  );
};

Lino.show_fk_detail = function(combo,detail_action) {
    //~ console.log("Lino.show_fk_detail",combo,handler);
    pk = combo.getValue();
    if (pk) {
        detail_action.run(null,{record_id: pk})
      } else {
        Lino.notify("Cannot show detail for empty foreign key.");
      }
};

Lino.show_insert = function(panel,btn) {
  var bp = panel.get_base_params();
  //~ console.log('20120125 Lino.show_insert',bp)
  //~ panel.ls_insert_handler.run(null,{record_id:-99999,base_params:bp});
  panel.ls_insert_handler.run(panel.getId(),{record_id:-99999,base_params:bp});
};

Lino.show_insert_duplicate = function(panel,btn) {
  Lino.do_on_current_record(panel,
    function(rec) {
      var newRec = {};
      Ext.apply(newRec,rec);
      newRec.id = -99999;
      panel.ls_insert_handler.run(null,{data_record:rec});
    });
};

//~ Lino.update_row_handler = function(action_name) {
  //~ return function(panel,btn) {
    //~ Lino.notify("Sorry, " + action_name + " is not implemented.");
  //~ }
//~ };



if (Ext.ux.grid !== undefined) {
    Lino.GridFilters = Ext.extend(Ext.ux.grid.GridFilters,{
      encode:true,
      local:false
    });
} else {
    Lino.GridFilters = function() {}; // dummy
    Ext.override(Lino.GridFilters,{
      init : function() {}
    });
};


//~ Lino.ButtonField = Ext.extend(Ext.form.TextField,{
//~ Lino.ButtonField = Ext.extend(Ext.form.Field,{
    //~ editable : false,
    //~ constructor : function(ww,config,params){
      //~ this.containing_window = ww;
      //~ if (params) Ext.apply(config,params);
      //~ Lino.ButtonField.superclass.constructor.call(this, config);
    //~ },
    //~ setButtons : function(buttons){
      //~ console.log('setButtons',buttons);
    //~ },
    //~ onRender : function(ct, position){
        //~ if(!this.el){
            //~ this.panel = new Ext.Container({items:[
              //~ {xtype:'button',text:'upload'},
              //~ {xtype:'button',text:'show'},
              //~ {xtype:'button',text:'edit'}
            //~ ]});
            //~ this.panel.ownerCt = this;
            //~ this.el = this.panel.getEl();

        //~ }
        //~ Lino.ButtonField.superclass.onRender.call(this, ct, position);
    //~ },

  
//~ });

Lino.FieldBoxMixin = {
  before_init : function(config,params) {
    if (params) Ext.apply(config,params);
    var actions = Lino.build_buttons(this,config.ls_bbar_actions);
    if (actions) config.bbar = actions.bbar;
  },
  //~ constructor : function(ww,config,params){
    //~ this.containing_window = ww;
    //~ if (params) Ext.apply(config,params);
    //~ var actions = Lino.build_buttons(this,config.ls_bbar_actions);
    //~ if (actions) config.bbar = actions.bbar;
    //~ Lino.FieldBoxMixin.superclass.constructor.call(this, config);
  //~ },
  do_when_clean : function(auto_save,todo) { todo() },
  //~ format_data : function(html) { return '<div class="htmlText">' + html + '</div>' },
  format_data : function(html) { return html },
  get_base_params : function() {
    // needed for insert action
    var p = Ext.apply({},this.base_params);
    Lino.insert_subst_user(p);
    return p;
  },
  set_base_params : function(p) {
    this.base_params = Ext.apply({},p);
    //~ if (p.param_values) this.set_param_values(p.param_values);  
  },
  clear_base_params : function() {
      this.base_params = {};
      Lino.insert_subst_user(this.base_params);
  },
  set_base_param : function(k,v) {
    this.base_params[k] = v;
  }
};



Lino.HtmlBoxPanel = Ext.extend(Ext.Panel,Lino.PanelMixin);
Lino.HtmlBoxPanel = Ext.extend(Lino.HtmlBoxPanel,Lino.FieldBoxMixin);
Lino.HtmlBoxPanel = Ext.extend(Lino.HtmlBoxPanel,{
  disabled_in_insert_window : true,
  constructor : function(config,params) {
    this.before_init(config,params);
    Lino.HtmlBoxPanel.superclass.constructor.call(this, config);
  },
  //~ constructor : function(ww,config,params){
    //~ this.ww = ww;
    //~ if (params) Ext.apply(config,params);
    //~ var actions = Lino.build_buttons(this,config.ls_bbar_actions);
    //~ if (actions) config.bbar = actions.bbar;
    //~ Lino.FieldBoxMixin.constructor.call(this, ww,config,params);
  //~ },
  //~ constructor : function(ww,config,params){
    //~ this.ww = ww;
    //~ if (params) Ext.apply(config,params);
    //~ var actions = Lino.build_buttons(this,config.ls_bbar_actions);
    //~ if (actions) config.bbar = actions.bbar;
    //~ Lino.FieldBoxMixin.superclass.constructor.call(this, config);
  //~ },
  //~ disable : function() { var tb = this.getBottomToolbar(); if(tb) tb.disable()},
  //~ enable : function() { var tb = this.getBottomToolbar(); if(tb) tb.enable()},
  onRender : function(ct, position){
    Lino.HtmlBoxPanel.superclass.onRender.call(this, ct, position);
    //~ console.log(20111125,this.containing_window);
    if (this.containing_panel) {
      this.containing_panel.on('enable',this.enable,this);
      this.containing_panel.on('disable',this.disable,this);
    }
    this.el.on({
      dragenter:function(event){
        event.browserEvent.dataTransfer.dropEffect = 'move';
        return true;
      }
      ,dragover:function(event){
        event.browserEvent.dataTransfer.dropEffect = 'move';
        event.stopEvent();
        return true;
      }
      ,drop:{
        scope:this
        ,fn:function(event){
          event.stopEvent();
          //~ console.log(20110516);
          var files = event.browserEvent.dataTransfer.files;
          if(files === undefined){
            return true;
          }
          var len = files.length;
          while(--len >= 0){
            console.log(files[len]);
            //~ this.processDragAndDropFileUpload(files[len]);
          }
          Lino.show_insert(this);
        }
      }
    });
  },
  refresh : function(unused) { 
      this.refresh_with_after();
  },
  refresh_with_after : function(after) {
    //~ if (this.master_panel) {
      var record = this.containing_panel.get_current_record();
      //~ console.log('HtmlBox.refresh()',this.title,record,record.title);
      var box = this.items.get(0);
      var todo = function() {
        if (this.disabled) return;
        //~ this.set_base_params(this.containing_window.get_base_params());
        this.set_base_params(this.containing_panel.get_master_params());
        var el = box.getEl();
        if (el) {
          el.update(record ? this.format_data(record.data[this.name]) : '');
          //~ console.log('HtmlBox.refresh()',this.name);
        //~ } else {
          //~ console.log('HtmlBox.refresh() failed for',this.name);
        }
      };
      //~ Lino.do_when_visible(this,todo.createDelegate(this));
      Lino.do_when_visible(box,todo.createDelegate(this));
    //~ }
  }
});
//~ Ext.override(Lino.HtmlBoxPanel,Lino.FieldBoxMixin);


Lino.RichTextPanel = Ext.extend(Ext.Panel,Lino.PanelMixin);
Lino.RichTextPanel = Ext.extend(Lino.RichTextPanel,Lino.FieldBoxMixin);
Lino.RichTextPanel = Ext.extend(Lino.RichTextPanel,{
    
  //~ initComponent : function(){
    //~ Lino.RichTextPanel.superclass.initComponent.call(this);
  //~ },
  constructor : function(config,params) {
    //~ console.log('Lino.RichTextPanel.initComponent',this);
    //~ var url = TEMPLATES_URL + config.ls_url + "/" + String(rec.id) + "/" + config.name;
    //~ var url = TEMPLATES_URL + config.ls_url + "/" + config.name;
    var t = this;
    var tinymce_options = {
        theme : "advanced",
        content_css: ADMIN_URL + '/media/lino/extjs/lino.css',
        language: 'de',
        //~ template_external_list_url : url,
        theme_advanced_toolbar_location : "top",
        theme_advanced_toolbar_align : "left",
        theme_advanced_statusbar_location : "bottom",
        template_popup_width : 700,
        template_popup_height : 500,
        template_replace_values : { 
            data_field : function(element){ 
                //~ console.log(20110722,fieldName,t.containing_window.get_current_record()); 
                var fieldName = element.innerHTML;
                element.innerHTML = t.containing_panel.get_current_record().data[fieldName];
            } 
        }
      };
      
    var editorConfig = {
      tinymceSettings: {
        plugins : "noneditable,template", 
        // Theme options - button# indicated the row# only
        theme_advanced_buttons1 : "bold,italic,underline,|,justifyleft,justifycenter,justifyright,|,bullist,numlist,|,outdent,indent,|,undo,redo,|,removeformat,template",
        theme_advanced_buttons2 : "",
        theme_advanced_buttons3 : "", // ,|,sub,sup,|,charmap",      
        theme_advanced_resizing : false
        //~ save_onsavecallback : save_callback,
        //~ save_enablewhendirty : true
        //~ save_oncancelcallback: on_cancel
        
    }};
    Ext.apply(editorConfig.tinymceSettings,tinymce_options);
    //~ editorConfig.name = config.action_name;
    editorConfig.name = config.name;
    delete config.name;
    //~ config.title = config.label;
    //~ delete config.label;
    this.before_init(config,params);
    
    this.editor = new Ext.ux.TinyMCE(editorConfig);
    var t = this;
    config.tools = [{
                      qtip: "Text in eigenem Fenster bearbeiten.", 
                      id: "up",
                      handler: function(){
                        if(t.editor.isDirty()) {
                            var record = t.containing_panel.get_current_record();
                            record.data[t.editor.name] = t.editor.getValue();
                        }
                        Lino.edit_tinymce_text(t,tinymce_options)
                      }
                    }];
    
    config.items = this.editor;
    config.layout = "fit";
    Lino.RichTextPanel.superclass.constructor.call(this, config);
  },
  refresh : function(unused) { 
      this.refresh_with_after();
  },
  refresh_with_after : function(after) {
    var record = this.containing_panel.get_current_record();
    //~ console.log('RichTextPanel.refresh()',this.title,record.title,record);
    var todo = function() {
      //~ this.set_base_params(this.containing_window.get_base_params());
      if (record) {
        var url = ADMIN_URL + '/templates' + this.containing_panel.ls_url + "/" 
            + String(record.id) + "/" + this.editor.name;
        //~ console.log('RichTextPanel.refresh()',url);
        if (this.editor.ed) this.editor.ed.settings.template_external_list_url = url;
        this.set_base_params(this.containing_panel.get_master_params());
        //~ var v = record ? this.format_data(record.data[this.editor.name]) : ''
        var v = this.format_data(record.data[this.editor.name])
        this.editor.setValue(v);
      } else {
        this.editor.setValue('(no data)');
      }
    };
    Lino.do_when_visible(this,todo.createDelegate(this));
  }
});
//~ Ext.override(Lino.RichTextPanel,Lino.FieldBoxMixin);


Lino.ActionFormPanel = Ext.extend(Ext.form.FormPanel,Lino.MainPanel);
Lino.ActionFormPanel = Ext.extend(Lino.ActionFormPanel,Lino.PanelMixin);
Lino.ActionFormPanel = Ext.extend(Lino.ActionFormPanel,Lino.FieldBoxMixin);
Lino.ActionFormPanel = Ext.extend(Lino.ActionFormPanel,{
  //~ layout:'fit'
  //~ ,autoHeight: true
  //~ ,frame: true
  window_title: "Action Parameters",
  constructor : function(config){
    config.bbar = [
        {text:'OK',handler:this.on_ok,scope:this},
        {text:'Cancel',handler:this.on_cancel,scope:this}
    ];
    //~ config.items = config.params_panel;
    Lino.ActionFormPanel.superclass.constructor.call(this, config);
  }
  //~ ,initComponent : function(){
    //~ Lino.ActionFormPanel.superclass.initComponent.call(this);
  //~ }
  ,on_cancel : function() { 
    this.get_containing_window().close();
  }
  ,on_ok : function() { 
    //~ var rp = this.requesting_panel;
    //~ console.log("on_ok",this.requesting_panel,arguments);
    //~ Lino.row_action_handler()
    var panel = this.requesting_panel;
    var actionName = this.action_name;
    var rec = panel.get_current_record();
    var self = this;
    function on_success() { self.get_containing_window().close(); };
    var fn = function(panel,btn,step) {
      var p = {};
      self.add_field_values(p)
      Lino.call_row_action(panel,'GET',panel.get_record_url(rec.id),p,actionName,step,fn,on_success);
    }
    fn(panel,null,null);
    
    
  }
  ,set_status : function(status,rp){
    this.requesting_panel = Ext.getCmp(rp);
    //~ console.log('20120918 ActionFormPanel.set_status()',status,rp,this.requesting_panel);
    this.clear_base_params();
    if (status == undefined) status = {};
    //~ if (status.param_values) 
    this.set_field_values(status.field_values);
    if (status.base_params) this.set_base_params(status.base_params);
  }
  
  ,add_field_values : function (p) { // similar to add_param_values()
      //~ 20121023 
      if (this.form.isDirty()) {
        p.fv = this.get_field_values();
      }else{
        if (this.status_field_values) 
          p.fv = Lino.fields2array(this.fields,this.status_field_values);
      }
      //~ if (!this.form.isDirty()) return;
      //~ p.fv = this.get_field_values();
      //~ console.log("20120203 add_param_values added pv",pv,"to",p);
  }
  ,get_field_values : function() {
      return Lino.fields2array(this.fields);
  }
  ,set_field_values : function(pv) {
      //~ console.log('20120203 MainPanel.set_param_values', pv);
      this.status_field_values = pv;
      if (pv) this.form.my_loadRecord(pv);
      else this.form.reset(); 
  }
  ,config_containing_window : function(wincfg) { 
      wincfg.title = this.window_title;
  }
});

Lino.fields2array = function(fields,values) {
    //~ console.log('20120116 gonna loop on', fields);
    var pv = Array(fields.length);
    for(var i=0; i < fields.length;i++) {
        var f = fields[i]
        if (values) 
          var v = values[f.name];
        else 
          var v = f.getValue();
        if (f.formatDate) {
            pv[i] = f.formatDate(v); 
        } else {
            pv[i] = f.getValue(); 
        }
    }
    return pv;
}


Lino.FormPanel = Ext.extend(Ext.form.FormPanel,Lino.MainPanel);
Lino.FormPanel = Ext.extend(Lino.FormPanel,Lino.PanelMixin);
Lino.FormPanel = Ext.extend(Lino.FormPanel,{
  params_panel_hidden : false,
  //~ base_params : {},
  //~ trackResetOnLoad : true,
  //~ query_params : {},
  //~ 20110119b quick_search_text : '',
  constructor : function(config,params){
    if (params) Ext.apply(config,params);
    this.base_params = {};
    //~ ww.config.base_params.query = ''; // 20111018
    //~ console.log(config);
    //~ console.log('FormPanel.constructor() 1',config)
    //~ Ext.applyIf(config,{base_params:{}});
    //~ console.log('FormPanel.constructor() 2',config)
      
    config.trackResetOnLoad = true;
    
    Lino.FormPanel.superclass.constructor.call(this, config);
      
    //~ this.set_base_param('query',null); // 20111018
    //~ this.set_base_param('query',''); // 20111018
      
  },
  initComponent : function(){
    
    //~ console.log("20111201 containing_window",this.containing_window,this);
    
    var actions = Lino.build_buttons(this,this.ls_bbar_actions);
    if (actions) {
        this.bbar = actions.bbar;
    //~ } else {
        //~ this.bbar = [];
    }
    //~ Ext.apply(config,Lino.build_buttons(this,config.ls_bbar_actions));
    //~ config.bbar = Lino.build_buttons(this,config.ls_bbar_actions);
    //~ var config = this;
    
    //~ if (this.containing_window instanceof Lino.DetailWrapper) {
    
    //~ console.log('20120121 initComponent', this.action_name);
    //~ if (this.action_name == 'detail' | this.action_name == 'show') {
    //~ if (this.action_name != 'insert') {
    if (! this.hide_top_toolbar) {
      this.tbar = [];
      // 20111015    
      if (! this.hide_navigator) {
        this.record_selector = new Lino.RemoteComboFieldElement({
          store: new Lino.ComplexRemoteComboStore({
            //~ baseParams: this.containing_window.config.base_params,
            baseParams: this.get_base_params(),
            //~ value: this.containing_window.config.base_params.query,
            proxy: new Ext.data.HttpProxy({
              url: ADMIN_URL + '/choices' + this.ls_url,
              method:'GET'
            })
          }),
          pageSize:25,
          listeners: { 
            scope:this, 
            select:function(combo,record,index) {
              //~ console.log('jumpto_select',arguments);
              this.goto_record_id(record.id);
            }
          },
          emptyText: "Gehe zu Datensatz"
        })
        this.tbar = this.tbar.concat([this.record_selector]);
        
        this.tbar = this.tbar.concat([
          this.first = new Ext.Toolbar.Button({
            tooltip:"Erste",disabled:true,handler:this.moveFirst,scope:this,iconCls:'x-tbar-page-first'}),
          this.prev = new Ext.Toolbar.Button({
            tooltip:"Vorige",disabled:true,handler:this.movePrev,scope:this,iconCls:'x-tbar-page-prev'}),
          this.next = new Ext.Toolbar.Button({
            tooltip:"Nächster",disabled:true,handler:this.moveNext,scope:this,iconCls:'x-tbar-page-next'}),
          this.last = new Ext.Toolbar.Button({
            tooltip:"Letzte",disabled:true,handler:this.moveLast,scope:this,iconCls:'x-tbar-page-last'})
        ]);
      }
      this.tbar = this.add_params_panel(this.tbar);
      
      //~ console.log(20101117,this.containing_window.refresh);
      this.tbar = this.tbar.concat([
        {
          //~ text:'Refresh',
          handler:function(){ this.do_when_clean(true,this.refresh.createDelegate(this)) },
          iconCls: 'x-tbar-loading',
          tooltip:"Aktuellen Record neu laden",
          scope:this}
      ]);
          
      if (this.bbar) { // since 20121016
        if (this.tbar) {
            this.tbar = this.tbar.concat(['-']) ;
        } else {
          this.tbar = [];
        }
        this.tbar = this.tbar.concat(this.bbar) ;
        this.bbar = undefined;
      }
    
      this.tbar = this.tbar.concat([
          '->',
          this.displayItem = new Ext.Toolbar.TextItem({})
      ]);
          
    }
    //~ if (this.content_type && this.action_name != 'insert') {
      //~ this.bbar = this.bbar.concat([
        //~ '->',
        //~ { text: "[Hilfetexte bearbeiten]",
          //~ handler: Lino.help_text_editor,
          //~ qtip: "Hilfetexte der Eingabefelder dieser Tabelle bearbeiten",
          //~ scope: this}
      //~ ])
    //~ }
    //~ this.before_row_edit = config.before_row_edit.createDelegate(this);
      
    //~ if (this.master_panel) {
        //~ this.set_base_params(this.master_panel.get_master_params());
    //~ }
      
    Lino.FormPanel.superclass.initComponent.call(this);
    
    this.on('render',function(){
      this.loadMask = new Ext.LoadMask(this.bwrap,{msg:"Bitte warten..."});
    },this);
    
    
    //~ var this_ = this;
    //~ this.cascade(function(cmp){
      //~ // var active_field = false;
      //~ for (i = 0; i < this_.active_fields.length; i++) {
        //~ if (cmp.name == this_.active_fields[i]) {
            //~ // active_field = true; break;
            //~ cmp.on("change",function() {this_.save()});
        //~ }
      //~ };
      //~ if (active_field) {
      // if (cmp instanceof Lino.GridPanel) {
          //~ cmp.on("change",function() {this_.save()});
      //~ }
    //~ });
    
    if (this.action_name == 'insert') {
      this.cascade(function(cmp){
        // console.log('20110613 cascade',cmp);
        if (cmp.disabled_in_insert_window) {
            //~ cmp.disable();
            cmp.hide();
        }
      });
      
    }
    
  },
  
  is_loading : function() { 
    if (this.current_record == null) return true; 
    var loading = false;
    this.cascade(function(cmp){
        if (cmp instanceof Lino.GridPanel && cmp.is_loading()) {
            //~ console.log(cmp.title,'is loading');
            loading = true;
            return false;
        }
      });
    return loading;
    //~ var a = this.findByType(Lino.GridPanel);
    //~ for (i=0;i<a.length;i++) {
        //~ if (a[i].is_loading()) return true;
    //~ }
    //~ return false;
  },
  
  get_status : function(){
      var st = {
        base_params: this.get_base_params(),
        data_record : this.get_current_record()
        }
      var tp = this.items.get(0);
      if (tp instanceof Ext.TabPanel) {
        st.active_tab = tp.getActiveTab();
      }
      st.param_values = this.status_param_values;
      return st;
  },
  set_status : function(status,rp){
    this.requesting_panel = Ext.getCmp(rp);
    //~ console.log('20120918 FormPanel.set_status()',status);
    this.clear_base_params();
    if (status == undefined) status = {};
    //~ if (status.param_values) 
    this.set_param_values(status.param_values);
    if (status.base_params) this.set_base_params(status.base_params);
    var tp = this.items.get(0);
    if (tp instanceof Ext.TabPanel) {
      if (status.active_tab) {
        //~ console.log('20111201 active_tab',this.active_tab,this.items.get(0));
        //~ tp.activeTab = status.active_tab;
        tp.setActiveTab(status.active_tab);
        //~ this.main_item.items.get(0).activate(status.active_tab);
      } else {
        tp.setActiveTab(0);
      }
      }
    
    if (status.data_record) {
      //~ console.log('20111201 Lino.FormPanel with data_record',this.data_record.title,this.containing_window);
      //~ this.main_item.on_master_changed.defer(2000,this.main_item,[status.data_record]);
      //~ Lino.do_when_visible(this.main_item,function(){this.on_master_changed(status.data_record)});
      //~ this.main_item.on('afterrender',function(){
      //~   this.main_item.on_master_changed(status.data_record)},this,{single:true});
      /* must defer because because set_window_title() didn't work otherwise */
      this.set_current_record.createDelegate(this,[status.data_record]).defer(100);
      //~ this.set_current_record(this.data_record);
      //~ return;
    } else if (status.record_id != undefined) { 
      /* possible values include 0 and null, 0 being a valid record id, 
      null the equivalent of undefined
      */
      //~ this.main_item.goto_record_id(this.status.record_id);
      this.load_record_id(status.record_id);
    } else {
      this.set_current_record(undefined);
    }
  },
    
  get_base_params : function() {
    // needed for insert_action
    var p = Ext.apply({},this.base_params);
    Lino.insert_subst_user(p);
    return p;
    //~ return this.base_params;
  },
  set_base_params : function(p) {
    //~ this.base_params = Ext.apply({},this.base_params); // make sure it is an instance variable
    delete p['query'] // 20120725
    Ext.apply(this.base_params,p);
    if (this.record_selector) {
        var store = this.record_selector.getStore();
        for (k in p) store.setBaseParam(k,p[k]);
        delete this.record_selector.lastQuery;
        //~ console.log("20120725 record_selector.setBaseParam",p)
    }
  },
  clear_base_params : function() {
      this.base_params = {};
      Lino.insert_subst_user(this.base_params);
        
      //~ if (this.record_selector) {
          //~ var store = this.record_selector.getStore();
          //~ for (k in store.baseParams) store.setBaseParam(k,undefined);
          //~ delete this.record_selector.lastQuery;
          //~ console.log("20120725 record_selector.getBaseParams() -->",store.baseParams)
      //~ }
  },
  set_base_param : function(k,v) {
    //~ this.base_params = Ext.apply({},this.base_params); // make sure it is an instance variable
    this.base_params[k] = v;
    //~ if (this.record_selector) {
        //~ this.record_selector.getStore().setBaseParam(k,v);
        //~ delete this.record_selector.lastQuery;
    //~ }
  },
  
  after_delete : function() {
    if (this.current_record.navinfo.next)
      this.moveNext();
    else if (this.current_record.navinfo.prev)
      this.movePrev();
    else 
      this.abandon();
  },
  moveFirst : function() {this.goto_record_id(this.current_record.navinfo.first)},
  movePrev : function() {this.goto_record_id(this.current_record.navinfo.prev)},
  moveNext : function() {this.goto_record_id(this.current_record.navinfo.next)},
  moveLast : function() {this.goto_record_id(this.current_record.navinfo.last)},
  
  
  refresh : function(unused) { 
      this.refresh_with_after();
  },
  refresh_with_after : function(after) { 
    //~ console.log('20120121 Lino.FormPanel.refresh()',this);
    if (this.current_record) {
        this.load_record_id(this.current_record.id,after);
    } else {
        this.set_current_record(undefined,after);
    }
  },
  
  do_when_clean : function(auto_save,todo) {
    var this_ = this;
    if (this.form.isDirty()) {
        if (auto_save) {
            this_.save(todo);
        } else {
          //~ console.log('20111217 do_when_clean() form is dirty',this.form);
          var config = {title:"Bestätigung"};
          config.buttons = Ext.MessageBox.YESNOCANCEL;
          config.msg = "Änderungen in diesem Formular speichern?";
          config.fn = function(buttonId,text,opt) {
            //~ console.log('do_when_clean',buttonId)
            if (buttonId == "yes") {
                //~ Lino.submit_detail(this_,undefined,todo);
                //~ this_.containing_window.save(todo);
                this_.save(todo);
            } else if (buttonId == "no") { 
              todo();
            }
          }
        }
        Ext.MessageBox.show(config);
    }else{
      //~ console.log('do_when_clean : now!')
      todo();
    }
  },
  
  goto_record_id : function(record_id) {
    //~ console.log('20110701 Lino.FormPanel.goto_record_id()',record_id);
    //~ var this_ = this;
    //~ this.do_when_clean(function() { this_.load_record_id(record_id) }
    this.do_when_clean(true,this.load_record_id.createDelegate(this,[record_id]));
  },
  
  load_record_id : function(record_id,after) {
    var this_ = this;
    //~ var p = { fmt: this.containing_window.config.action_name};
    //~ var p = Ext.apply({},this.containing_window.config.base_params);
    var p = Ext.apply({},this.get_base_params());
    //~ Lino.insert_subst_user(p);
    //~ console.log('20110713 action_name=',this.containing_window.config.action_name,
      //~ 'base_params=',this.containing_window.config.base_params);
    if (this.action_name)
        p.an = this.action_name;
    //~ p.an = this.action_name;
    //~ p.an = this.containing_window.config.action_name;
    //~ p.fmt = 'json';
    //~ p.fmt = 'json';
    p.rp = this.getId();
    //~ p.su = Lino.subst_user;
    p.fmt = 'json';
    //~ 20110119b p['query'] = this.quick_search_text;
    //~ Ext.apply(p,this.query_params);
    this.add_param_values(p);
    //~ console.log('20120622 load_record_id',record_id,p);
    if (this.loadMask) this.loadMask.show();
    Ext.Ajax.request({ 
      waitMsg: 'Loading record...',
      method: 'GET',
      params: p,
      scope: this,
      url: this.get_record_url(record_id),
      success: function(response) {   
        // todo: convert to Lino.action_handler.... but result 
        if (this.loadMask) this.loadMask.hide();
        if (response.responseText) {
          var rec = Ext.decode(response.responseText);
          //~ console.log('20120918 goto_record_id success',rec);
          this.set_param_values(rec.param_values);
          this.set_current_record(rec,after);
        }
      },
      failure: Lino.ajax_error_handler(this)
    });
  },

  abandon : function () {
    Ext.MessageBox.alert('Note',
      "Keine weiteren Records vorhanden. Detail-Fenster wird geschlossen.");
    Lino.close_window();
    //~ if (this.containing_window) {
        //~ this.containing_window.hide();
    //~ }
  },
  
  set_current_record : function(record,after) {
    //~ console.log('20120722 Lino.FormPanel.set_current_record',record.title,record);
    if (this.record_selector) {
        this.record_selector.clearValue();
        // e.g. InsertWrapper FormPanel doesn't have a record_selector
    }
    this.current_record = record;
    //~ if (record) 
        //~ console.log('Lino.FormPanel.set_current_record',record.title,record);
    //~ else
        //~ console.log('Lino.FormPanel.set_current_record',record);
    //~ this.config.main_panel.form.load(record);    
    if (record) {
      this.enable();
      this.form.my_loadRecord(record.data);
      this.set_window_title(record.title);
      //~ this.getBottomToolbar().enable();
      var da = record.data.disabled_actions;
      if (da) {
          //~ console.log('20120528 disabled_actions =',da,this.getBottomToolbar());
          //~ 20121016 this.getBottomToolbar().items.each(function(item,index,length){
          var tb = this.getTopToolbar();
          if (tb) tb.items.each(function(item,index,length){
              //~ console.log('20120528 ',item.itemId,'-->',da[item.itemId]);
              if (da[item.itemId]) item.disable(); else item.enable();
          });
      };
      if (this.disable_editing | record.data.disable_editing) {
          //~ console.log("20120202 disable_editing",record.title);
          this.form.items.each(function(cmp){
            if (!cmp.always_enabled) cmp.disable();
          },this);
      } else {
          this.form.items.each(function(cmp){
            //~ console.log("20120202",cmp);
            if (record.data.disabled_fields[cmp.name]) cmp.disable();
            else cmp.enable();
          },this);
        
          //~ if (record.data.disabled_fields) {
              //~ for (i = 0; i < record.data.disabled_fields.length; i++) {
                  //~ var flds = this.find('name',record.data.disabled_fields[i]);
                  //~ if (flds.length == 1) { 
                    //~ flds[0].disable(); 
                  //~ }
              //~ }
          //~ }
      };
      
      if (record.navinfo && ! this.hide_top_toolbar && ! this.hide_navigator) {
        //~ if (record.navinfo.recno == 0) {
            //~ this.first.setDisabled(true);
            //~ this.prev.setDisabled(true);
            //~ this.next.setDisabled(true);
            //~ this.last.setDisabled(true);
        //~ } else {
            this.first.setDisabled(!record.navinfo.first);
            this.prev.setDisabled(!record.navinfo.prev);
            this.next.setDisabled(!record.navinfo.next);
            this.last.setDisabled(!record.navinfo.last);
        //~ }
        this.displayItem.setText(record.navinfo.message);
      }
    } else {
      if (this.form.rendered) 
        this.form.reset(); /* FileUploadField would fail when resetting a non-rendered form */
      //~ this.disable();
      //~ this.getBottomToolbar().disable();
      this.form.items.each(function(cmp){
        cmp.disable();
      },this);
      this.set_window_title(this.empty_title);
      //~ this.containing_window.window.setTitle(this.empty_title);
      if (!this.hide_navigator) {
        this.first.disable();
        this.prev.disable();
        this.next.disable();
        this.last.disable();
      }
    }
    //~ console.log('20100531 Lino.DetailMixin.on_load_master_record',this.main_form);
    this.before_row_edit(record);
    if (after) after();
  },
  
  before_row_edit : function(record) {},
  search_change : function(field,oldValue,newValue) {
    //~ console.log('search_change',field.getValue(),oldValue,newValue)
    this.set_base_param('query',field.getValue()); 
    this.refresh();
  },
  
  get_selected : function() { return [ this.current_record ] },
  get_current_record : function() {  
    //~ console.log(20100714,this.current_record);
    return this.current_record 
  },
  
  get_permalink_url : function() {
      var rec = this.get_current_record();
      if (rec && ! rec.phantom && rec.id != -99998)
          return ADMIN_URL + '/api' + this.ls_url + '/' + rec.id;
      return ADMIN_URL + '/api' + this.ls_url;
    
  },
  get_permalink_params : function() {
    var p = {};
    //~ var p = {an:'detail'};
    if (this.action_name)
        p.an = this.action_name;
    //~ var p = {an:this.action_name};
    var main = this.items.get(0);
    if (main.activeTab) {
      var tab = main.items.indexOf(main.activeTab);
      //~ console.log('main.activeTab',tab,main.activeTab);
      if (tab) p.tab = tab;
    }
    this.add_param_values(p)
    return p;
  },
  
  /* 
  Lino.FormPanel.save() 
  */
  save : function(after,switch_to_detail,action_name) {
    //~ var panel = this;
    this.loadMask.show();
    var rec = this.get_current_record();
    if (this.has_file_upload) this.form.fileUpload = true;
    //~ console.log('FormPanel.save()',rec);
    if (!action_name) action_name = this.action_name;
    if (rec) {
      var p = {};
      Ext.apply(p,this.get_base_params());
      p.rp = this.getId();
      //~ if (this.action_name) 
          //~ p.an = this.action_name;
      p.an = action_name;
      if (rec.phantom) {
        //~ if (this.action_name != 'insert') 
            //~ console.log("Warning: phantom record, but action_name is",this.action_name)
        this.form.submit({
          url: ADMIN_URL + '/api' + this.ls_url,
          method: 'POST',
          params: p, 
          scope: this,
          success: function(form, action) {
            this.loadMask.hide();
            Lino.notify(action.result.message);
            /***
            Close this window, but update the status of the 
            calling window.
            If the calling window is a detail on the same table,
            then it should skip to the new record. But only then.
            A successful response usually has a data_record,
            except if it is a fileupload form where some mysterious 
            decoding problems (20120209) force us to return a record_id 
            which will lead to an additional GET.
            ***/
            var url = this.ls_url;
            var ww = Lino.calling_window();
            if (ww && ww.window.main_item instanceof Lino.FormPanel 
                   && ww.window.main_item.ls_url == this.ls_url) {
                //~ console.log("20120217 case 1");
                ww.status.record_id = action.result.record_id;
                ww.status.data_record = action.result.data_record;
                Lino.close_window();
            } else if (this.ls_detail_handler && switch_to_detail) {
                //~ console.log("20120217 case 2");
                Lino.kill_current_window();
                this.ls_detail_handler.run(null,{
                    record_id:action.result.record_id,
                    data_record: action.result.data_record,
                    base_params:this.get_base_params()
                });
            } else {
                //~ console.log("20120217 case 3");
                Lino.close_window();
            }
            //~ Lino.close_window(function(ww){
                //~ if (ww.window.main_item instanceof Lino.FormPanel 
                    //~ && ww.window.main_item.ls_url == url) {
                  //~ ww.status.record_id = action.result.record_id,
                  //~ ww.status.data_record = action.result.data_record
                //~ }
            //~ });
          },
          failure: function(form,action) { 
            this.loadMask.hide();
            Lino.on_submit_failure(form,action);
          },
          clientValidation: true
        })
      } else {
        //~ if (this.action_name != 'detail') 
            //~ console.log("Warning: non-phantom record, but action_name is",this.action_name)
        this.form.submit({
          url: ADMIN_URL + '/api' + this.ls_url + '/' + rec.id,
          method: 'PUT',
          //~ headers: { 'HTTP_X_REQUESTED_WITH' : 'XMLHttpRequest'},
          scope: this,
          params: p, 
          success: function(form, action) {
            //~ panel.form.setValues(rec.data);
            //~ 20110701 panel.form.my_loadRecord(rec);
            this.loadMask.hide();
            Lino.notify(action.result.message);
            if (action.result.data_record)
                this.set_current_record(action.result.data_record,after);
            else
                console.log("Warning: no data_record in response to FormPanel.PUT")
            //~ this.refresh_with_after(after);
            //~ if (after) after(); else panel.refresh();
          },
          failure: function(form,action) { 
            this.loadMask.hide();
            Lino.on_submit_failure(form,action)},
          clientValidation: true
        })
      }
    } else Lino.notify("Sorry, no current record.");
  }
  
  /* not used (no longer possible without .dtl files)
  , edit_detail_config : function () {
    var active_tab = {};
    var main = this.items.get(0);
    if (main.getActiveTab !== undefined) {
      var tabitem = main.getActiveTab();
      Ext.apply(active_tab,{tab : main.items.indexOf(tabitem)});
    }
    var editor = new Ext.form.TextArea();
    var close = function() { win.close(); }
    var _this = this;
    var save = function() { 
      //~ console.log(20110609,arguments); 
      var params = {desc: editor.getValue()};
      Ext.apply(params,active_tab);
      var a = { 
        params: params, 
        method: 'PUT',
        url: ADMIN_URL + '/detail_config' + _this.ls_url,
        failure : Lino.ajax_error_handler(this),
        success: Lino.action_handler( _this, function(result) {
          //~ console.log('detail_config/save success',result);
          win.close();
          document.location = _this.get_permalink();
        })
      };
      //~ console.log('detail_config/save sent',a);
      _this.loadMask.show(); // 20120211
      Ext.Ajax.request(a);
    }
    var save_btn = new Ext.Button({text:'Save',handler:save,disabled:true});
    var win = new Ext.Window({title:'Detail Layout',
      items:editor, layout:'fit',
      width:500,height:500,
      bbar:[{text:'Cancel',handler:close},save_btn]});
    var a = { 
      params:active_tab, 
      method:'GET',
      url:ADMIN_URL+'/detail_config'+_this.ls_url,
      success : function(response) {
        if (response.responseText) {
          var result = Ext.decode(response.responseText);
          if (result.success) {
            editor.setValue(result.desc);
            save_btn.enable();
          }
        }
      }
    };
    Ext.Ajax.request(a);
    win.show();
  }
  */
});


Lino.getRowClass = function(record, rowIndex, rowParams, store) {
  if (record.phantom) {
    //~ console.log(20101009,record);
    //~ rowParams.bodyStyle = "color:red;background-color:blue";
    return 'lino-phantom-row';
    }
  //~ console.log('20101009 not a phantom:',record);
  return '';
}

//~ FOO = 0;



Lino.GridStore = Ext.extend(Ext.data.ArrayStore,{ 
  autoLoad: false
  ,load: function(options) {
    //~ foo.bar = baz; // 20120213
    if (!options) options = {};
    if (!options.params) options.params = {};
    options.params.fmt = 'json';
    options.params.rp = this.grid_panel.getId();
    Lino.insert_subst_user(options.params); // since 20121016
      
    var ps = this.grid_panel.calculatePageSize();
    
    if (!ps) {
        //~ this.gridpanel.on('render',this.load())
      //~ console.log("20120814 GridStore.load() failed to calculate pagesize");
      return false;
        //~ params.limit = 1;
        //~ this.grid_panel.on('render',this.load.createDelegate(this,options))
        //~ return;
    } 
    
    options.params.limit = ps;
      
    if (this.grid_panel.hide_top_toolbar) {
        //~ console.log("20120206 GridStore.load() toolbar is hidden");
        options.params.start = 0;
    } else {
        //~ options.params.start = this.grid_panel.getTopToolbar().cursor;
        //~ if (this.grid_panel.getTopToolbar().pageSize !=  ps) {
          //~ console.log("20120206 abort load because toolbar says pagesize",
            //~ this.grid_panel.getTopToolbar().pageSize,
            //~ "while actual pagesize is",ps);
            //~ return;
        //~ }
        
        this.grid_panel.getTopToolbar().pageSize =  ps;
        if (options.params.start == undefined)
            options.params.start = this.grid_panel.getTopToolbar().cursor;
      
    }
      
    this.grid_panel.add_param_values(options.params);
    //~ Lino.insert_subst_user(options.params);
    //~ console.log("20120814 GridStore.load()",options.params,this.baseParams);
    //~ if (FOO > 0) {
        //~ foo.bar = baz;
    //~ } else FOO += 1;
    return Lino.GridStore.superclass.load.call(this,options);
  }
});

    
Lino.GridPanel = Ext.extend(Ext.grid.EditorGridPanel,Lino.MainPanel);
Lino.GridPanel = Ext.extend(Lino.GridPanel,Lino.PanelMixin);
Lino.GridPanel = Ext.extend(Lino.GridPanel,{
  quick_search_text : '',
  is_searching : false,
  disabled_in_insert_window : true,
  clicksToEdit:2,
  enableColLock: false,
  autoHeight: false,
  params_panel_hidden : false,
  //~ loadMask: true,
  //~ viewConfig: {
          //~ getRowClass: Lino.getRowClass,
          //~ emptyText:"Keine Daten anzuzeigen."
        //~ },
  loadMask: {msg:"Bitte warten..."},
  
  constructor : function(config){
    config.plugins = [new Lino.GridFilters()];
    Lino.GridPanel.superclass.constructor.call(this,config);
    
    //~ if (this.containing_window) {
        //~ console.log("20111206 install refresh");
        //~ this.containing_window.on('show',this.refresh,this);
    //~ }
    
  },
  
  is_loading : function() { 
    //~ return this.store.getCount() > 0; 
    return !this.loadMask.disabled; 
  },
  
  unused_config_containing_window : function(wincfg) { 
      //~ temporarily remove save_grid_config button (see /blog(2012/1107)
      if (wincfg.tools != undefined) 
        wincfg.tools = [
          //~ {handler:this.save_grid_data,
            //~ qtip:"Save Grid Data",
            //~ scope:this, id:"save_data"}, // 20120814
          {handler:this.save_grid_config,
            qtip:"Tabellenkonfiguration speichern",
            scope:this, id:"save"}
        ].concat(wincfg.tools);
      //~ wincfg.listeners = { show: ... };
  },
  init_containing_window : function(win) { 
    //~ console.log("20111206 install refresh");
    //~ win.on('show',this.refresh,this);
  },
  
  initComponent : function(){
    
    /* 
    Problem 20111206:
    When a GridPanel is the main item of the window, then it doesn't 
    have it's own header but uses the window's header bar.
    We must do this in initComponent because e.g. in beforerender 
    it's already to late: a header element has been created because 
    there was a title.
    But Lino.Window adds itself as `this.containing_window` 
    only after the GridPanel has been initialized.
    Workaround is to generate a line "params.containing_window = true;" 
    in the handler function.
    */ 
    //~ if (this.containing_window) {
    if (this.is_main_window) {
        //~ console.log(20111206, 'delete title',this.title,'from',this);
        //~ delete this.title;
        this.tools = undefined;  
        this.title = undefined;  /* simply deleting it 
          isn't enough because that would only 
          unhide the title defined in some base class. */
    } 
    //~ else console.log(20111206, 'dont delete title',this.title,'from',this);
    
    /* e.g. when slave gridwindow called from a permalink */
    //~ if (this.base_params) Ext.apply(bp,this.base_params);  
    //~ bp['fmt'] = 'json';
    
    //~ function on_proxy_write( proxy, action,data, response,rs,options) {
      //~ console.log('20120814 on_proxy_write',action,data,response)
      //~ this.getStore().doUpdate();
      //~ this.getStore().loadData(data);
    //~ }
    //~ function on_proxy_load( proxy, transactionObject, callbackOptions ) {
      //~ console.log('on_proxy_load',transactionObject)
    //~ }
    var proxy = new Ext.data.HttpProxy({ 
      // 20120814 
      url: ADMIN_URL + '/api' + this.ls_url
      ,method: "GET"
      //~ ,url: ADMIN_URL + '/restful' + this.ls_url
      //~ ,restful: true 
      //~ ,listeners: {load:on_proxy_load} 
      //~ ,listeners: {write:on_proxy_write} 
    });
    //~ config.store = new Ext.data.JsonStore({ 
    //~ this.store = new Ext.data.ArrayStore({ 
    this.store = new Lino.GridStore({ 
      grid_panel: this
      ,listeners: { exception: Lino.on_store_exception }
      ,remoteSort: true
      ,totalProperty: "count"
      ,root: "rows"
      //~ ,id: "id" 
      ,proxy: proxy
      //~ autoLoad: this.containing_window ? true : false
      ,idIndex: this.pk_index
      //~ ,baseParams: bp
      ,fields: this.ls_store_fields
      ,idProperty: this.ls_id_property 
      // 20120814
      //~ ,writer : new Ext.data.JsonWriter({
        //~ writeAllFields: false
        //~ ,listful: true
      //~ })
      //~ ,restful : true
    });
      
    //~ console.log('config.pk_index',config.pk_index,config.store),
    delete this.ls_store_fields;
      
    var this_ = this;
    //~ var grid = this;
    this.store.on('load', function() {
        //~ console.log('20120814 GridStore.on(load)',this_.store);
        //~ var da = this_.store.reader.arrayData.disabled_actions;
        //~ if (da) {
            //~ this.cmenu.cascade(function(item){ 
              //~ console.log(20120531, item.itemId, da[item.itemId]);
              //~ if (da[item.itemId]) item.disable(); else item.enable();
            //~ });
        //~ };
        this_.set_param_values(this_.store.reader.arrayData.param_values);
        //~ this_.set_status(this_.store.reader.arrayData.status);
        //~ 20120918
        if (this_.store.reader.arrayData.no_data_text) {
            //~ this.viewConfig.emptyText = this_.store.reader.arrayData.no_data_text;
            this.getView().emptyText = this_.store.reader.arrayData.no_data_text;
            this.getView().refresh();
        }
        if (this_.containing_window)
            this_.set_window_title(this_.store.reader.arrayData.title);
            //~ this_.containing_window.setTitle(this_.store.reader.arrayData.title);
        if (!this.is_searching) { // disabled 20121025: quick_search_field may not los focus
          this.is_searching = false;
          if (this_.selModel.getSelectedCell){
              if (this_.getStore().getCount()) // there may be no data
                  this_.selModel.select(0,0); 
          } else {
              this_.selModel.selectFirstRow();
              this_.getView().focusEl.focus();
          }
        } 
        //~ else console.log("is_searching -> no focussing");
        //~ var t = this.getTopToolbar();
        //~ var activePage = Math.ceil((t.cursor + t.pageSize) / t.pageSize);
        //~ this.quick_search_field.focus(); // 20121024
      }, this
    );
    var actions = Lino.build_buttons(this,this.ls_bbar_actions);
    //~ Ext.apply(config,Lino.build_buttons(this,config.ls_bbar_actions));
    //~ config.bbar, this.cmenu = Lino.build_buttons(this,config.ls_bbar_actions);
    //~ this.cmenu = new Ext.menu.Menu({items: config.bbar});
    delete this.ls_bbar_actions
    if (actions) {
        this.cmenu = actions.cmenu;
    }
    
    if (!this.hide_top_toolbar) {  
      var tbar = [ 
        this.quick_search_field = new Ext.form.TextField({ 
          //~ fieldLabel: "Search"
          listeners: { 
            scope:this_
            //~ ,change:this_.search_change
            ,render: Lino.quicktip_renderer("Schnellsuche","Hier Text eingeben für Schnellsuche.")
            //~ ,keypress: this.search_keypress 
            ,blur: function() { this.is_searching = false}
          }
          ,validator:function(value) { return this_.search_validate(value) }
          //~ ,tooltip: "Enter a quick search text, then press TAB"
          //~ value: text
          //~ scope:this, 
          //~ ,enableKeyEvents: true
          //~ listeners: { keypress: this.search_keypress }, 
          //~ id: "seachString" 
      })];
      tbar = this.add_params_panel(tbar);
      tbar = tbar.concat([
        { scope:this, 
          //~ text: "[csv]", 
          tooltip: "Diese Tabelle in eine .csv-Datei exportieren", 
          iconCls: 'x-tbar-csv',
          handler: function() { 
            var p = Ext.apply({},this.get_base_params());
            p.fmt = 'csv';
            //~ url += "?" + Ext.urlEncode(p);
            window.open(ADMIN_URL+'/api'+this.ls_url + "?" + Ext.urlEncode(p)) 
          } },
        //~ { scope:this, 
          //~ text: "[html]", 
          //~ handler: function() { 
            //~ var p = this.get_current_grid_config();
            //~ Ext.apply(p,this.get_base_params());
            //~ p.fmt = "printer";
            //~ this.add_param_values(p);
            //~ window.open(ADMIN_URL+'/api'+this.ls_url + "?" + Ext.urlEncode(p)) 
          //~ } },
        { scope:this, 
          //~ text: "[html]", 
          tooltip: "Tabelle als HTML anzeigen", 
          iconCls: 'x-tbar-html',
          handler: function() { 
            var p = this.get_current_grid_config();
            Ext.apply(p,this.get_base_params());
            p.fmt = "plain";
            this.add_param_values(p);
            window.open(ADMIN_URL+'/api'+this.ls_url + "?" + Ext.urlEncode(p)) 
          } },
        { scope:this, 
          //~ text: "[pdf]", 
          tooltip: "Diese Tabelle in eine .pdf-Datei exportieren", 
          iconCls: 'x-tbar-pdf',
          handler: function() { 
            var p = this.get_current_grid_config();
            Ext.apply(p,this.get_base_params());
            p.fmt = "pdf";
            this.add_param_values(p);
            window.open(ADMIN_URL+'/api'+this.ls_url + "?" + Ext.urlEncode(p)) 
          } }
      ]);
    
    
      var menu = [];
      var set_gc = function(index) {
        return function() {
          //~ console.log('set_gc() 20100812');
          this.getColumnModel().setConfig(
              this.apply_grid_config(index,this.ls_grid_configs,this.ls_columns));
        }
      }
      for (var i = 0; i < this.ls_grid_configs.length;i++) {
        var gc = this.ls_grid_configs[i];
        menu.push({text:gc.label,handler:set_gc(i),scope:this})
      }
      if(menu.length > 1) {
        tbar = tbar.concat([
          { text:"Ansicht",
            menu: menu,
            tooltip:"Andere Ansicht auswählen"
          }
        ]);
      }
      
      if (actions) {
        tbar = tbar.concat(actions.bbar);
          //~ this.bbar = actions.bbar;
      }
      
      this.tbar = new Ext.PagingToolbar({ 
        store: this.store, 
        prependButtons: true, 
        //~ pageSize: this.page_length, 
        pageSize: 1, 
        displayInfo: true, 
        beforePageText: "Seite",
        afterPageText: "von {0}",
        displayMsg: "Zeilen {0} bis {1} von {2}",
        firstText: "Erste Seite",
        lastText: "Letzte Seite",
        prevText: "Vorige Seite",
        nextText: "Nächste Seite",
        items: tbar
      });
      //~ this.on('resize', function(cmp,aw,ah,rw,rh) {
          //~ var ps = this.calculatePageSize();
          //~ if (ps && ps != this.getTopToolbar().pageSize) {
              //~ // console.log('20120203 resize : pageSize',this.getTopToolbar().pageSize,'->',ps);
              //~ // this.getTopToolbar().pageSize =  ps;
              //~ cmp.refresh();
              //~ // this.getTopToolbar().doRefresh();
          //~ }
        //~ }, this);
      //~ this.on('resize', function(cmp,aw,ah,rw,rh) {
          //~ cmp.getTopToolbar().pageSize = this.calculatePageSize(aw,ah,rw,rh) || 10;
          //~ cmp.refresh();
        //~ }, this, {delay:500});
    }
    
    delete this.page_length
    
    
      
    if (this.ls_quick_edit) {
      this.selModel = new Ext.grid.CellSelectionModel()
      this.get_selected = function() {
        //~ console.log(this.getSelectionModel().selection);
        if (this.selModel.selection)
            return [ this.selModel.selection.record ];
        return [this.store.getAt(0)];
      };
      this.get_current_record = function() { 
        if (this.getSelectionModel().selection) 
          return this.selModel.selection.record;
        return this.store.getAt(0);
      };
    } else { 
      this.selModel = new Ext.grid.RowSelectionModel() 
      this.get_selected = function() {
        var sels = this.selModel.getSelections();
        if (sels.length == 0) sels = [this.store.getAt(0)];
        return sels
        //~ var sels = this.getSelectionModel().getSelections();
        //~ return Ext.pluck(sels,'id');
      };
      this.get_current_record = function() { 
        var rec = this.selModel.getSelected();
        if (rec == undefined) rec = this.store.getAt(0);
        return rec
      };
    };
    delete this.ls_quick_edit;
    
    this.columns  = this.apply_grid_config(this.gc_name,this.ls_grid_configs,this.ls_columns);
    
    //~ var grid = this;
    //~ this.colModel = new Ext.grid.ColumnModel({
      //~ columns: this.apply_grid_config(this.gc_name,this.ls_grid_configs,this.ls_columns),
      //~ isCellEditable: function(col, row) {
        //~ var record = grid.store.getAt(row);
        //~ console.log('20120514',col,record); // dataIndex
        //~ var dataIndex = grid.colModel.getDataIndex(col);
        //~ if (dataIndex in record.data['disabled_fields']) {
            //~ Lino.notify("Dieses Feld ist deaktiviert");
            //~ return false;
        //~ }
        //~ return Ext.grid.ColumnModel.prototype.isCellEditable.call(this, col, row);
      //~ }
    //~ });    
    
    
    Lino.GridPanel.superclass.initComponent.call(this);
    
    //~ if (this.containing_window) 
        //~ this.on('afterlayout', this.refresh, this);
        //~ this.on('afterrender', this.refresh,this);
    //~ else
        //~ this.on('show', this.refresh,this);
    //~ this.on('afterlayout', function() {
      //~ if (this.id == "ext-comp-1157") 
        //~ console.log("20120213 afterlayout",this); 
      //~ // this.refresh();
      //~ },this);
    //~ this.on('afterrender', this.refresh);
    //~ this.on('resize', this.refresh,this,{delay:500});
    //~ this.on('resize', function(){console.log("20120213 resize",arguments)},this);
    this.on('resize', function(){
      //~ console.log("20120213 resize",arguments)
      this.refresh();
      },this);
    this.on('viewready', function(){
      //~ console.log("20120213 resize",arguments);
      this.view_is_ready = true;
      this.refresh();
      },this);
    this.on('afteredit', this.on_afteredit); // 20120814
    //~ this.on('afteredit', this.new_on_afteredit);
    this.on('beforeedit', this.on_beforeedit);
    this.on('beforeedit',function(e) { this.before_row_edit(e.record)},this);
    this.on('cellcontextmenu', Lino.cell_context_menu, this);
    //~ this.on('contextmenu', Lino.grid_context_menu, this);
    
    
    //~ if (this.id == "ext-comp-1157") captureEvents(this);    
    
  },
  
  //~ onResize : function(){
      //~ console.log("20120206 GridPanel.onResize",arguments);
      //~ Lino.GridPanel.superclass.onResize.apply(this, arguments);
      //~ this.refresh();
  //~ },
  
  
  get_status : function(){
    var st = { base_params : this.get_base_params()};
    if (!this.hide_top_toolbar) {
        st.current_page = this.getTopToolbar().current;
    }
    st.param_values = this.status_param_values;
    //~ console.log("20120213 GridPanel.get_status",st);
    return st;
  },
  
  /* 
  Lino.GridPanel.set_status() 
  */
  set_status : function(status){
    //~ console.log("20120918 GridPanel.set_status",status);
    this.clear_base_params();
    if (status == undefined) status = {};
    this.set_param_values(status.param_values);
    if (status.base_params) { 
      this.set_base_params(status.base_params);
    }
    if (!this.hide_top_toolbar) {
      //~ console.log("20120213 GridPanel.getTopToolbar().changePage",
          //~ status.current_page || 1);
      this.getTopToolbar().changePage(status.current_page || 1);
    }
    //~ this.fireEvent('resize');
    //~ this.refresh.defer(100,this); 
    //~ this.onResize.defer(100,this); 
    //~ this.refresh(); 
    //~ this.doLayout(); 
    //~ this.onResize(); 
    //~ this.store.load();
  },
  
  refresh : function(unused) { 
    this.refresh_with_after();
  },
  refresh_with_after : function(after) { 
    //~ Lino.notify('20120204 Lino.GridPanel.refresh');
    //~ Lino.notify('Lino.GridPanel.refresh '+this.store.proxy.url);
    //~ var bp = { fmt:'json' }
    if (this.containing_panel) {
        //~ Ext.apply(p,this.master_panel.get_master_params());
        //~ Ext.apply(options.params,this.containing_panel.get_master_params());
        this.set_base_params(this.containing_panel.get_master_params());
    }
    
    if (! this.view_is_ready) return;
    
    var options = {};
    if (after) {
        options.callback = function(r,options,success) {if(success) after()}
    }
    
      
    //~ if (!this.rendered) {
        //~ console.log("20120206 GridPanel.refresh() must wait until rendered",options);
        //~ this.grid_panel.on('render',this.load.createDelegate(this,options))
        //~ return;
    //~ }
    
    this.store.load(options);
  },
  
  /* pageSize depends on grid height (Trying to remove scrollbar)
  Thanks to 
  - Christophe Badoit on http://www.sencha.com/forum/showthread.php?82647
  - http://www.sencha.com/forum/archive/index.php/t-37231.html
  */
  calculatePageSize : function(second_attempt) {
    //~ if (!this.rendered) { 
    if (!this.view_is_ready) { 
      //~ console.log('Cannot calculatePageSize() : not rendered');
      return false; }
    //~ if (!this.isVisible()) { 
      //~ console.log('calculatePageSize : not visible');
      //~ return false; }
      
    //~ console.log('getFrameHeight() is',this.getFrameHeight());
    //~ console.log('getView().scroller.getHeight() is',this.getView().scroller.getHeight());
    //~ console.log('mainBody.getHeight() is',this.getView().mainBody.getHeight());
    //~ console.log('getInnerHeight() is',this.getInnerHeight());
    //~ console.log('getHeight() is',this.getHeight());
    //~ console.log('el.getHeight() is',this.getEl().getHeight());
    //~ console.log('getGridEl().getHeight() is',this.getGridEl().getHeight());
    //~ console.log('getOuterSize().height is',this.getOuterSize().height);
    //~ console.log('getBox().height is',this.getBox().height);
    //~ console.log('getResizeEl.getHeight() is',this.getResizeEl().getHeight());
    //~ console.log('getLayoutTarget().getHeight() is',this.getLayoutTarget().getHeight());
      
    var rowHeight = this.getFrameHeight();
    //~ var rowHeight = 52; // experimental value
    var row = this.view.getRow(0);
    if (row) {
      //~ console.log('20120213 yes');
      rowHeight = Ext.get(row).getHeight();
    }
    //~ console.log('rowHeight is ',rowHeight,this,caller);
    //~ this.getView().syncScroll();
    //~ this.getView().initTemplates();
    var height = this.getView().scroller.getHeight();
    //~ console.log('getView().scroller.getHeight() is',this.getView().scroller.getHeight());
    //~ console.log('getInnerHeight() - getFrameHeight() is',
      //~ this.getInnerHeight(), '-',
      //~ this.getFrameHeight(), '=',
      //~ this.getInnerHeight() - this.getFrameHeight());
    //~ var height = this.getView().mainBody.getHeight();
    //~ var height = this.getView().mainWrap.getHeight();
    //~ var height = this.getView().resizeMarker.getHeight();
    //~ this.syncSize();
    //~ var height = this.getInnerHeight() - this.getFrameHeight();
    //~ var height = this.getHeight() - this.getFrameHeight();
    height -= Ext.getScrollBarWidth(); // leave room for a possible horizontal scrollbar... 
    //~ height -= this.getView().scrollOffset;
    var ps = Math.floor(height / rowHeight);
    //~ console.log('20120203 calculatePageSize():',height,'/',rowHeight,'->',ps);
    ps -= 1; // leave room for a possible phantom row
    //~ return (ps > 1 ? ps : false);
    if (ps > 1) return ps;
    //~ console.log('calculatePageSize() found less than 1 row:',height,'/',rowHeight,'->',ps);
    //~ foo.bar = baz; // 20120213
    return 5;
    //~ if (second_attempt) {
        //~ console.log('calculatePageSize() abandons after second attempt:',
          //~ height,'/',rowHeight,'->',ps);
      //~ return 5;
    //~ }
    //~ return this.calculatePageSize.defer(500,this,[true]);
  },
  
  onCellDblClick : function(grid, row, col){
      //~ console.log("20120307 onCellDblClick",this,grid, row, col);
      if (this.ls_detail_handler) {
          //~ Lino.notify('show detail');
          Lino.show_detail(this);
          return false;
      }else{
        //~ console.log('startEditing');
        this.startEditing(row,col);
      }
  },
  
  get_base_params : function() {
    //~ return this.containing_window.config.base_params;
    //~ console.log(20120717,this.store.baseParams);
    var p = Ext.apply({},this.store.baseParams);
    Lino.insert_subst_user(p);
    //~ console.log("20120717 GRidPanel.get_base_params() returns",p);
    return p;
    //~ return this.store.baseParams;
  },
  set_base_params : function(p) {
    //~ console.log('GridPanel.set_base_params',p)
    for (k in p) this.store.setBaseParam(k,p[k]);
    //~ this.store.baseParams = p;
    if (p.query) 
        this.quick_search_field.setValue(p.query);
    //~ if (p.param_values) 
        //~ this.set_param_values(p.param_values);  
  },
  clear_base_params : function() {
      this.store.baseParams = {};
      Lino.insert_subst_user(this.store.baseParams);
  },
  set_base_param : function(k,v) {
    this.store.setBaseParam(k,v);
  },
  
  //~ get_permalink_params : function() {
    //~ var p = {};
    //~ return p;
  //~ },
  
  before_row_edit : function(record) {},
    
  //~ search_keypress : function(){
    //~ console.log("2012124 search_keypress",arguments);
  //~ },
  search_validate : function(value) {
    if (value == this.quick_search_text) return true;
    this.is_searching = true;
    //~ console.log('search_validate',value)
    this.quick_search_text = value;
    this.set_base_param('query',value); 
    //~ this.getTopToolbar().changePage(1);
    this.getTopToolbar().moveFirst();
    //~ this.refresh();
    return true;
  },
  
  search_change : function(field,oldValue,newValue) {
    //~ console.log('search_change',field.getValue(),oldValue,newValue)
    this.set_base_param('query',field.getValue()); 
    this.getTopToolbar().moveFirst();
    //~ this.refresh();
  },
  
  apply_grid_config : function(index,grid_configs,rpt_columns) {
    //~ var rpt_columns = this.ls_columns;
    var gc = grid_configs[index];    
    //~ console.log('apply_grid_config() 20100812',name,gc);
    this.gc_name = index;
    if (gc == undefined) {
      return rpt_columns;
      //~ config.columns = config.ls_columns;
      //~ return;
    } 
    //~ delete config.ls_filters
    
    //~ console.log(20100805,config.ls_columns);
    var columns = Array(gc.columns.length);
    for (var j = 0; j < rpt_columns.length;j++) {
      var col = rpt_columns[j];
      for (var i = 0; i < gc.columns.length; i++) {
        if (col.dataIndex == gc.ci[i]) {
          col.width = gc.cw[i];
          col.hidden = gc.ch[i];
          columns[i] = col;
          break;
        }
      }
    }
    
    //~ var columns = Array(rpt_columns.length);
    //~ for (var i = 0; i < rpt_columns.length; i++) {
      //~ columns[i] = rpt_columns[gc.columns[i]];
      //~ columns[i].width = gc.widths[i];
    //~ }
    
    //~ if (gc.hidden_cols) {
      //~ for (var i = 0; i < gc.hidden_cols.length; i++) {
        //~ var hc = gc.hidden_cols[i];
        //~ for (var j = 0; j < columns.length;j++) {
          //~ var col = columns[j];
          //~ if (col.dataIndex == hc) {
            //~ col.hidden = true;
            //~ break
          //~ }
        //~ }
      //~ }
    //~ }
    if (gc.filters) {
      //~ console.log(20100811,'config.ls_filters',config.ls_filters);
      //~ console.log(20100811,'config.ls_grid_config.filters',config.ls_grid_config.filters);
      for (var i = 0; i < gc.filters.length; i++) {
        var fv = gc.filters[i];
        for (var j = 0; j < columns.length;j++) {
          var col = columns[j];
          if (col.dataIndex == fv.field) {
            //~ console.log(20100811, f,' == ',fv);
            if (fv.type == 'string') {
              col.filter.value = fv.value;
              //~ if (fv.comparison !== undefined) f.comparison = fv.comparison;
            } else {
              //~ console.log(20100811, fv);
              col.filter.value = {};
              col.filter.value[fv.comparison] = fv.value;
            }
            break;
          }
        };
      }
    }
    
    return columns;
    //~ config.columns = cols;
    //~ delete config.ls_columns
  },
  
  get_current_grid_config : function () {
    var cm = this.getColumnModel();
    var widths = Array(cm.config.length);
    var hiddens = Array(cm.config.length);
    //~ var hiddens = Array(cm.config.length);
    var columns = Array(cm.config.length);
    //~ var columns = Array(cm.config.length);
    //~ var hidden_cols = [];
    //~ var filters = this.filters.getFilterValues();
    var p = this.filters.buildQuery(this.filters.getFilterData())
    for (var i = 0; i < cm.config.length; i++) {
      var col = cm.config[i];
      columns[i] = col.dataIndex;
      //~ hiddens[i] = col.hidden;
      widths[i] = col.width;
      hiddens[i] = col.hidden;
      //~ if (col.hidden) hidden_cols.push(col.dataIndex);
    }
    //~ p['hidden_cols'] = hidden_cols;
    p.cw = widths;
    p.ch = hiddens;
    p.ci = columns;
    //~ p['widths'] = widths;
    //~ p['hiddens'] = hiddens;
    //~ p['columns'] = columns;
    p['name'] = this.gc_name;
    //~ var gc = this.ls_grid_configs[this.gc_name];
    //~ if (gc !== undefined) 
        //~ p['label'] = gc.label
    //~ console.log('20100810 save_grid_config',p);
    return p;
  },
  
  unused_manage_grid_configs : function() {
    var data = [];
    for (k in this.ls_grid_configs) {
      var v = this.ls_grid_configs[k];
      var i = [k,String(v.columns),String(v.hidden_cols),String(v.filters)];
      data.push(i)
    }
    if (this.ls_grid_configs[this.gc_name] == undefined) {
      var v = this.get_current_grid_config();
      var i = [k,String(v.columns),String(v.hidden_cols),String(v.filters)];
      data.push(i);
    }
    //~ console.log(20100811, data);
    var main = new Ext.grid.GridPanel({
      store: new Ext.data.ArrayStore({
        idIndex:0,
        fields:['name','columns','hidden_cols','filters'],
        autoDestroy:true,
        data: data}),
      //~ autoHeight:true,
      selModel: new Ext.grid.RowSelectionModel(),
      listeners: { 
        rowdblclick: function(grid,rowIndex,e) {
          console.log('row doubleclicked',grid, rowIndex,e);
        },
        rowclick: function(grid,rowIndex,e) {
          console.log('row clicked',grid, rowIndex,e);
        }
      },
      columns: [ 
        {dataIndex:'name',header:'Name'}, 
        {dataIndex:'columns',header:'columns'}, 
        {dataIndex:'hidden_cols',header:'hidden columns'}, 
        {dataIndex:'filters',header:'filters'} 
      ]
    });
    var win = new Ext.Window({title:'GridConfigs Manager',layout:'fit',items:main,height:200});
    win.show();
  },
  
  unused_edit_grid_config : function(name) {
    gc = this.ls_grid_configs[name];
    var win = new Ext.Window({
      title:'Edit Grid Config',layout:'vbox', 
      //~ layoutConfig:'stretch'
      items:[
        {xtype:'text', value: gc.name},
        {xtype:'text', value: gc.columns},
        {xtype:'text', value: gc.hidden_cols},
        {xtype:'text', value: gc.filters}
      ]
    });
    win.show();
  },
  
  save_grid_config : function () {
    //~ console.log('TODO: save_grid_config',this);
    //~ p.column_widths = Ext.pluck(this.colModel.columns,'width');
    var a = { 
      params:this.get_current_grid_config(), 
      method:'PUT',
      url:ADMIN_URL + '/grid_config' + this.ls_url,
      success: Lino.action_handler(this),
      scope: this,
      failure: Lino.ajax_error_handler(this)
    };
    this.loadMask.show(); // 20120211
    Ext.Ajax.request(a);
    //~ Lino.do_action(this,a);
  },
  
  on_beforeedit : function(e) {
    //~ console.log('20120514 GridPanel.on_beforeedit()',e,e.record.data.disabled_fields);
    if(this.disable_editing | e.record.data.disable_editing) {
      e.cancel = true;
      Lino.notify("Dieser Datensatz ist deaktiviert");
      return;
    }
    if(e.record.data.disabled_fields && e.record.data.disabled_fields[e.field]) {
      e.cancel = true;
      Lino.notify("Dieses Feld ist deaktiviert");
      //~ Lino.notify(String.format("Feld '{0}' ist deaktiviert",e.field));
      return;
    }
    //~ if (e.record.data.disabled_fields) {
      //~ for (i in e.record.data.disabled_fields) {
        //~ if(e.record.data.disabled_fields[i] == e.field) {
          //~ e.cancel = true;
          //~ Lino.notify(String.format('Field "{0}" is disabled for this record',e.field));
          //~ return
        //~ }
      //~ }
    //~ }
  },
  save_grid_data : function() {
      //~ console.log("20120814 save_grid_data");
      this.getStore().commitChanges();
  },
  new_on_afteredit : function(e) {
      //~ this.getStore().commitChanges();
      //~ this.getStore().doUpdate();
      //~ this.getStore().loadData(data);
      console.log("20120814 new_on_afteredit",e);
  },
  on_afteredit : function(e) {
    /*
    e.grid - The grid that fired the event
    e.record - The record being edited
    e.field - The field name being edited
    e.value - The value being set
    e.originalValue - The original value for the field, before the edit.
    e.row - The grid row index
    e.column - The grid column index
    */
    var p = {};
    //~ console.log('20101130 modified: ',e.record.modified);
    //~ console.log('20101130 value: ',e.value);
    //~ var p = e.record.getChanges();
    //~ console.log('20101130 getChanges: ',e.record.getChanges());
    //~ this.before_row_edit(e.record);
    for(k in e.record.getChanges()) {
        var v = e.record.get(k);
    //~ for(k in e.record.modified) {
        //~ console.log('20101130',k,'=',v);
        //~ var cm = e.grid.getColumnModel();
        //~ var di = cm.getDataIndex(k);
        var f = e.record.fields.get(k);
        //~ console.log('20101130 f = ',f);
        //~ var v = e.record.get(di);
        if (f.type.type == 'date') {
            p[k] = Ext.util.Format.date(v, f.dateFormat);
        }else{
            p[k] = v;
            var v = e.record.get(k+'Hidden');
            if (v !== undefined) {
              p[k+'Hidden'] = v;
            }
        }
        //~ var i = cm.findColumnIndex(k);
        //~ var r = cm.getRenderer(i);
        //~ var editor = cm.getCellEditor(i,e.row);
        //~ var col = e.grid.getColumnModel().getColumnById(k);
        //~ console.log('20101130 r = ',r(v));
        //~ var f = e.record.fields[k];
        //~ console.log('20101130 f = ',f);
        //~ console.log('20101130 editor = ',editor);
        //~ p[k] = f.getValue();
        //~ p[k] = r(v);
    }
    //~ console.log('20101130 p:',p);
    //~ var cm = e.grid.getColumnModel();
    //~ var di = cm.getDataIndex(e.column);
    //~ var f = e.record.fields.get(di);
    //~ console.log('20101130 f = ',f);
    //~ if (f.type.type == 'date') e.record.set(di,Ext.util.Format.date(e.value, f.dateFormat));
    
    
    //~ var p = e.record.data;
    
    // var p = {};
    //~ p['grid_afteredit_colname'] = e.field;
    //~ p[e.field] = e.value;
    //~ console.log('20100723 GridPanel.on_afteredit()',e);
    // add value used by ForeignKeyStoreField CHOICES_HIDDEN_SUFFIX
    // not sure whether this is still needed:
    p[e.field+'Hidden'] = e.value;
    //~ p.su = Lino.subst_user;
    Lino.insert_subst_user(p);
    // this one is needed so that this field can serve as choice context:
    e.record.data[e.field+'Hidden'] = e.value;
    // p[pk] = e.record.data[pk];
    // console.log("grid_afteredit:",e.field,'=',e.value);
    Ext.apply(p,this.get_base_params()); // needed for POST, ignored for PUT
    //~ Ext.apply(p,this.containing_window.config.base_params);
    //~ 20121109 p['an'] = 'grid';
    var self = this;
    var req = {
        params:p,
        waitMsg: 'Saving your data...',
        success: Lino.action_handler( this, function(result) {
          //~ if (result.data_record) {
          if (result.rows) {
              //~ self.getStore().loadData(result,true);
              var r = self.getStore().reader.readRecords(result);
              if (e.record.phantom) {
                  //~ console.log("20120816 afteredit.success POST",r);
                  self.getStore().insert(e.row,r.records);
              }else{
                  //~ console.log("20120816 afteredit.success PUT",r);
                  self.getStore().doUpdate(r.records[0]);
              }
              self.getStore().rejectChanges(); /* 
              get rid of the red triangles without saving the record again
              */
              //~ self.getStore().commitChanges(); // get rid of the red triangles
          } else {
              self.getStore().commitChanges(); // get rid of the red triangles
              self.getStore().reload();        // reload our datastore.
          }
          }),
        scope: this,
        failure: Lino.ajax_error_handler(this)
    };
    if (e.record.phantom) {
      p['an'] = 'post'; // SubmitInsert.action_name
      Ext.apply(req,{
        method: 'POST',
        url: ADMIN_URL + '/api' + this.ls_url
      });
    } else {
      p['an'] = 'put'; // SubmitDetail.action_name
      Ext.apply(req,{
        method: 'PUT',
        url: ADMIN_URL + '/api' + this.ls_url + '/' + e.record.id
      });
    }
    //~ console.log('20110406 on_afteredit',req);
    this.loadMask.show(); // 20120211
    Ext.Ajax.request(req);
  },

  afterRender : function() {
    Lino.GridPanel.superclass.afterRender.call(this);
    // this.getView().mainBody.focus();
    // console.log(20100114,this.getView().getRows());
    // if (this.getView().getRows().length > 0) {
    //  this.getView().focusRow(1);
    // }
    //~ this.my_load_mask = new Ext.LoadMask(this.getEl(), {
        //~ msg:'Bitte warten...',
        //~ store:this.store});
      
    var tbar = this.getTopToolbar();
    // tbar.on('change',function() {this.getView().focusRow(1);},this);
    // tbar.on('change',function() {this.getSelectionModel().selectFirstRow();this.getView().mainBody.focus();},this);
    // tbar.on('change',function() {this.getView().mainBody.focus();},this);
    // tbar.on('change',function() {this.getView().focusRow(1);},this);
    this.nav = new Ext.KeyNav(this.getEl(),{
      pageUp: function() {tbar.movePrevious(); },
      pageDown: function() {tbar.moveNext(); },
      home: function() {tbar.moveFirst(); },
      end: function() {tbar.moveLast(); },
      scope: this
    });
  },
  after_delete : function() {
    //~ console.log('Lino.GridPanel.after_delete');
    this.refresh();
  },
  add_row_listener : function(fn,scope) {
    this.getSelectionModel().addListener('rowselect',fn,scope);
  },
  postEditValue : function(value, originalValue, r, field){
    value = Lino.GridPanel.superclass.postEditValue.call(this,value,originalValue,r,field);
    //~ console.log('GridPanel.postEdit()',value, originalValue, r, field);
    return value;
  },
  
  set_start_value : function(v) {
      this.start_value = v;
  },
  preEditValue : function(r, field){
      if (this.start_value) {
        var v = this.start_value;
        delete this.start_value;
        this.activeEditor.selectOnFocus = false;
        return v;
      }
      var value = r.data[field];
      return this.autoEncode && Ext.isString(value) ? Ext.util.Format.htmlDecode(value) : value;
  },
  
  on_master_changed : function() {
    //~ if (! this.enabled) return;
    //~ cmp = this;
    //~ console.log('Lino.GridPanel.on_master_changed()',this.title);
    if (! this.rendered) return; // 20120213
    var todo = function() {
      if (this.disabled) return;
      //~ if (this.disabled) return;
      //~ if (this.enabled) {
          //~ var src = caller.config.url_data + "/" + record.id + ".jpg"
          //~ console.log(20111125, this.containing_window);
          //~ for (k in p) this.getStore().setBaseParam(k,p[k]);
          //~ console.log('Lino.GridPanel.on_master_changed()',this.title,p);
          this.refresh();
          //~ this.set_base_params(this.master_panel.get_master_params());
          //~ this.getStore().load(); 
      //~ }
    };
    Lino.do_when_visible(this,todo.createDelegate(this));
  }
});
  

//~ Lino.MainPanelMixin = {
  //~ tbar_items : function() {
      //~ return ;
  //~ }
//~ };

//~ Ext.override(Lino.GridPanel,Lino.MainPanelMixin);
//~ Ext.override(Lino.FormPanel,Lino.MainPanelMixin);

//~ Lino.grid_context_menu = function(e) {
  //~ console.log('contextmenu',arguments);
//~ }

Lino.cell_context_menu = function(grid,row,col,e) {
  //~ console.log('20120531 cellcontextmenu',grid,row,col,e,grid.store.reader.arrayData.rows[row]);
  e.stopEvent();
  //~ grid.getView().focusCell(row,col);
  grid.getSelectionModel().select(row,col);
  //~ console.log(grid.store.getAt(row));
  //~ grid.getView().focusRow(row);
  //~ return;
  if(!grid.cmenu.el){grid.cmenu.render(); }
  //~ if(e.record.data.disabled_fields) {
  
  var da = grid.store.reader.arrayData.rows[row][grid.disabled_actions_index];
  if (da) {
      this.cmenu.cascade(function(item){ 
        //~ console.log(20120531, item.itemId, da[item.itemId]);
        if (da[item.itemId]) item.disable(); else item.enable();
      });
  };
  
  var xy = e.getXY();
  xy[1] -= grid.cmenu.el.getHeight();
  grid.cmenu.showAt(xy);
}


//~ Lino.load_main_menu = function() {
  //~ Ext.Ajax.request({
    //~ waitMsg: 'Loading main menu...',
    //~ method: 'GET',
    //~ url: '/menu',
    //~ success: Lino.on_load_menu,
    //~ failure: Lino.ajax_error_handler
  //~ });
//~ };



//~ Lino.SlavePlugin = function(caller) {
  //~ this.caller = caller;
//~ };

Lino.chooser_handler = function(combo,name) {
  return function(cmp,newValue,oldValue) {
    //~ console.log('Lino.chooser_handler()',cmp,oldValue,newValue);
    combo.setContextValue(name,newValue);
  }
};



Lino.ComboBox = Ext.extend(Ext.form.ComboBox,{
  forceSelection: true,
  triggerAction: 'all',
  minListWidth:230,
  autoSelect: false,
  submitValue: true,
  displayField: 'text', // 'text', 
  valueField: 'value', // 'value',
  
  //~ initComponent : Ext.form.ComboBox.prototype.initComponent.createSequence(function() {
  initComponent : function(){
      this.contextParams = {};
      //~ Ext.form.ComboBox.initComponent(this);
      Lino.ComboBox.superclass.initComponent.call(this);
  },
  setValue : function(v,record_data){
      /*
      Based on feature request developed in http://extjs.net/forum/showthread.php?t=75751
      */
      /* `record_data` is used to get the text corresponding to this value */
      //~ if(this.name == 'city') 
      //~ console.log('20120203', this.name,'.setValue(', v ,') this=', this,'record_data=',record_data);
      var text = v;
      if(this.valueField){
        if(v == null || v == '') { 
            //~ if (this.name == 'birth_country') 
                //~ console.log(this.name,'.setValue',v,'no lookup needed, value is empty');
            //~ v = undefined;
            v = '';
            //~ text = '';
        } else if (Ext.isDefined(record_data)) {
          text = record_data[this.name];
          //~ if (this.name == 'birth_country') 
            //~ console.log(this.name,'.setValue',v,'got text ',text,' from record ',record);
        } else {
          // if(this.mode == 'remote' && !Ext.isDefined(this.store.totalLength)){
          if(this.mode == 'remote' && ( this.lastQuery === null || (!Ext.isDefined(this.store.totalLength)))){
              //~ if (this.name == 'birth_country') console.log(this.name,'.setValue',v,'store not yet loaded');
              this.store.on('load', this.setValue.createDelegate(this, arguments), null, {single: true});
              if(this.store.lastOptions === null || this.lastQuery === null){
                  var params;
                  if(this.valueParam){
                      params = {};
                      params[this.valueParam] = v;
                  }else{
                      var q = this.allQuery;
                      this.lastQuery = q;
                      this.store.setBaseParam(this.queryParam, q);
                      params = this.getParams(q);
                  }
                  //~ if (this.name == 'birth_country') 
                    //~ console.log(this.name,'.setValue',v,' : call load() with params ',params);
                  this.store.load({params: params});
              //~ }else{
                  //~ if (this.name == 'birth_country') 
                    //~ console.log(this.name,'.setValue',v,' : but store is loading',this.store.lastOptions);
              }
              return;
          //~ }else{
              //~ if (this.name == 'birth_country') 
                //~ console.log(this.name,'.setValue',v,' : store is loaded, lastQuery is "',this.lastQuery,'"');
          }
          var r = this.findRecord(this.valueField, v);
          if(r){
              text = r.data[this.displayField];
          }else if(this.valueNotFoundText !== undefined){
              text = this.valueNotFoundText;
          }
        }
      }
      this.lastSelectionText = text;
      //~ this.lastSelectionText = v;
      if(this.hiddenField){
          //~ this.hiddenField.originalValue = v;
          this.hiddenField.value = v;
      }
      Ext.form.ComboBox.superclass.setValue.call(this, text);
      this.value = v; // needed for grid.afteredit
  },
  
  getParams : function(q){
    // p = Ext.form.ComboBox.superclass.getParams.call(this, q);
    // causes "Ext.form.ComboBox.superclass.getParams is undefined"
    var p = {};
    //p[this.queryParam] = q;
    if(this.pageSize){
        //~ p.start = 0;
        //~ p.limit = this.pageSize;
        p['start'] = 0;
        p['limit'] = this.pageSize;
    }
    // now my code:
    if(this.contextParams) Ext.apply(p,this.contextParams);
    //~ if(this.contextParams && this.contextValues) {
      //~ for(i = 0; i <= this.contextParams.length; i++)
        //~ p[this.contextParams[i]] = this.contextValues[i];
    //~ }
    return p;
  },
  setContextValue : function(name,value) {
    //~ console.log('setContextValue',this,this.name,':',name,'=',value);
    //~ if (this.contextValues === undefined) {
        //~ this.contextValues = Array(); // this.contextParams.length);
    //~ }
    if (this.contextParams[name] != value) {
      //~ console.log('setContextValue 1',this.contextParams);
      this.contextParams[name] = value;
      this.lastQuery = null;
      //~ console.log('setContextValue 2',this.contextParams);
    }
  }
});

Lino.ChoicesFieldElement = Ext.extend(Lino.ComboBox,{
  mode: 'local'
});


Lino.SimpleRemoteComboStore = Ext.extend(Ext.data.JsonStore,{
  forceSelection: true,
  constructor: function(config){
      Lino.SimpleRemoteComboStore.superclass.constructor.call(this, Ext.apply(config, {
          totalProperty: 'count',
          root: 'rows',
          id: 'value', // ext_requests.CHOICES_VALUE_FIELD
          fields: ['value' ], // ext_requests.CHOICES_VALUE_FIELD, // ext_requests.CHOICES_TEXT_FIELD
          listeners: { exception: Lino.on_store_exception }
      }));
  }
});

Lino.ComplexRemoteComboStore = Ext.extend(Ext.data.JsonStore,{
  constructor: function(config){
      Lino.ComplexRemoteComboStore.superclass.constructor.call(this, Ext.apply(config, {
          totalProperty: 'count',
          root: 'rows',
          id: 'value', // ext_requests.CHOICES_VALUE_FIELD
          fields: ['value','text'], // ext_requests.CHOICES_VALUE_FIELD, // ext_requests.CHOICES_TEXT_FIELD
          listeners: { exception: Lino.on_store_exception }
      }));
  }
});

Lino.RemoteComboFieldElement = Ext.extend(Lino.ComboBox,{
  mode: 'remote',
  //~ forceSelection:false,
  minChars: 2, // default 4 is too much
  queryDelay: 300, // default 500 is maybe slow
  queryParam: 'query', 
  //~ typeAhead: true,
  selectOnFocus: true, // select any existing text in the field immediately on focus.
  resizable: true
});

/*
Thanks to Animal for posting the basic idea:
http://www.sencha.com/forum/showthread.php?15842-2.0-SOLVED-Combobox-twintrigger-clear&p=76130&viewfull=1#post76130

*/
Lino.TwinCombo = Ext.extend(Lino.RemoteComboFieldElement,{
    trigger2Class : 'x-form-search-trigger',
    //~ trigger2Class : 'x-tbar-detail',
    initComponent : function() {
        //~ Lino.TwinCombo.superclass.initComponent.call(this);
        Lino.ComboBox.prototype.initComponent.call(this);
        Ext.form.TwinTriggerField.prototype.initComponent.call(this);
    },
    onTrigger2Click : function() {
        //~ console.log('onTrigger2Click',this,arguments);
    }
  });
//~ Lino.TwinCombo.prototype.initComponent = Ext.form.TwinTriggerField.prototype.initComponent;
Lino.TwinCombo.prototype.getTrigger = Ext.form.TwinTriggerField.prototype.getTrigger;
Lino.TwinCombo.prototype.getOuterSize = Ext.form.TwinTriggerField.prototype.getOuterSize;
Lino.TwinCombo.prototype.initTrigger = Ext.form.TwinTriggerField.prototype.initTrigger;
Lino.TwinCombo.prototype.onTrigger1Click = Ext.form.ComboBox.prototype.onTriggerClick;
//~ Lino.TwinCombo.prototype.onTrigger2Click = function() {
    //~ console.log('onTrigger2Click',arguments);
//~ };



Lino.SimpleRemoteComboFieldElement = Ext.extend(Lino.RemoteComboFieldElement,{
  displayField: 'value', 
  valueField: null,
  forceSelection: false
});




Lino.Window = Ext.extend(Ext.Window,{
  //~ layout: "fit", 
  closeAction : 'hide',
  renderTo: 'main_area', 
  constrain: true,
  maximized: true,
  draggable: false,
  width: 700,
  height: 500,
  maximizable: false,
  constructor : function (config) {
    if (config.main_item.params_panel) {
        config.layout = 'border';
        config.main_item.region = 'center';
        config.main_item.params_panel.region = 'north';
        config.main_item.params_panel.hidden = config.main_item.params_panel_hidden;
        config.items = [config.main_item.params_panel, config.main_item];
    } else {
        config.layout = 'fit';
        config.items = config.main_item;
    }
    this.main_item = config.main_item; 
    
    delete config.main_item;
    //~ delete config.params_item;
    
    //~ this.main_item = config.items.get(0);
    this.main_item.containing_window = this;
    
    //~ console.log('20120110 Lino.Window.constructor() 1');
    //~ if (Lino.current_window) { // all windows except the top are closable
    if (this.main_item.hide_window_title) { 
      config.closable = false;
      config.frame = false;
      config.shadow = false;
      //~ config.border = true;
      //~ config.title = undefined;
      //~ config.tools = null;
      delete config.title;
      delete config.tools;
    } else {
      config.title = this.main_item.empty_title;
      config.closable = true;
      config.tools = [ 
        { qtip: 'permalink', handler: Lino.permalink_handler(this), id: "pin" }
      ];
      if (this.main_item.content_type && this.main_item.action_name != 'insert') {
        config.tools = [ {
          handler: Lino.help_text_editor,
          qtip: "Hilfetexte der Eingabefelder dieser Tabelle bearbeiten",
          scope: this.main_item,
          id: "gear"
        }].concat(config.tools);
      }
        
    //~ { qtip: '', handler: Lino.save_wc_handler(this), id: "save" }, 
    //~ { qtip: this.config.qtip, handler: Lino.save_wc_handler(this), id: "save" }, 
    //~ { qtip: 'Call doLayout() on main Container.', handler: Lino.refresh_handler(this), id: "refresh" },
    //~ if (this.main_item.params_panel) {
        //~ config.tools = config.tools.concat([ 
          //~ { qtip: 'Show/hide parameter panel', handler: this.toggle_params_panel, id: "gear", scope:this } 
        //~ ]);
    //~ }
    //~ if (config.closable !== false) {
      // if undefined, will take default behaviour
      //~ config.tools = config.tools.concat([ 
        //~ { qtip: 'close', handler: this.hide, id: "close", scope:this } 
      //~ ]);
    }
    
    this.main_item.config_containing_window(config);
    
    //~ console.log('20120110 Lino.Window.constructor() 2');
    Lino.Window.superclass.constructor.call(this,config);
    
    //~ console.log('20120110 Lino.Window.constructor() 3');
    
  },
  initComponent : function() {
    this.main_item.init_containing_window(this);
    Lino.Window.superclass.initComponent.call(this);
  
  },
  hide : function() { 
      this.main_item.do_when_clean(false,function() { 
        Lino.close_window(); });
  },
  hide_really : function() { 
    Lino.Window.superclass.hide.call(this);
  },
  onRender : function(ct, position){
    //~ console.log('20120110 Lino.Window.onRender() 1');
    Lino.Window.superclass.onRender.call(this, ct, position);
    var main_area = Ext.getCmp('main_area')
    //~ console.log('20120110 Lino.Window.onRender() 2');
  
    this.on('show', function(win) {
        //~ console.log('20120110 Lino.Window.on show 1');
        main_area.on('resize', win.onWindowResize, win);
    });
    this.on('hide', function(win) {
        main_area.un('resize', win.onWindowResize, win);
    });
    //~ console.log('20120110 Lino.Window.onRender() 3');
  }
});


Lino.unused_ParamWindow = Ext.extend(Lino.Window,{
  //~ layout: "border", 
  constructor : function (config) {
    Lino.ParamWindow.superclass.constructor.call(this,config);
    this.main_item = config.items; // `items` must be a single component
    config.layout = 'border';
    this.main_item.region = 'center';
    config.params.region = 'north';
    config.items = [config.params, config.items];
    //~ delete config.params;
  }
});




(function(){
    var ns = Ext.ns('Ext.ux.plugins');

    /**
     * @class Ext.ux.plugins.DefaultButton
     * @extends Object
     *
     * Plugin for Button that will click() the button if the user presses ENTER while
     * a component in the button's form has focus.
     *
     * @author Stephen Friedrich
     * @date 09-DEC-2009
     * @version 0.1
     *
     */
    ns.DefaultButton =  Ext.extend(Object, {
        init: function(button) {
            button.on('afterRender', setupKeyListener, button);
        }
    });

    function setupKeyListener() {
        var formPanel = this.findParentByType('form');
        new Ext.KeyMap(formPanel.el, {
            key: Ext.EventObject.ENTER,
            shift: false,
            alt: false,
            fn: function(keyCode, e){
                if(e.target.type === 'textarea' && !e.ctrlKey) {
                    return true;
                }

                this.el.select('button').item(0).dom.click();
                return false;
            },
            scope: this
        });
    }

    Ext.ComponentMgr.registerPlugin('defaultButton', ns.DefaultButton);

})(); 

Ext.override(Ext.form.BasicForm,{
    my_loadRecord : function(values){
    //~ loadRecord : function(record){
        /* Same as ExtJS's loadRecord() (setValues()), except that we 
        forward also the record to field.setValue() so that Lino.Combobox 
        can use it. 
        */
        //~ console.log('20120918 my_loadRecord',values)
        if(Ext.isArray(values)){ 
            for(var i = 0, len = values.length; i < len; i++){
                var v = values[i];
                var f = this.findField(v.id);
                if(f){
                    f.setValue(v.value,values);
                    if(this.trackResetOnLoad){
                        f.originalValue = f.getValue();
                    }
                }
            }
        }else{ 
            var field, id;
            for(id in values){
                if(!Ext.isFunction(values[id]) && (field = this.findField(id))){
                    field.setValue(values[id],values);
                    if(this.trackResetOnLoad){
                        field.originalValue = field.getValue();
                        //~ if (field.hiddenField) {
                          //~ field.hiddenField.originalValue = field.hiddenField.value;
                        //~ }
                    }
                }
            }
        }
        return this;
    }
});




function initializeFooBarDropZone(cmp) {
    //~ console.log('initializeFooBarDropZone',cmp);
    cmp.dropTarget = new Ext.dd.DropTarget(cmp.bwrap, {
      //~ ddGroup     : 'gridDDGroup',
      notifyEnter : function(ddSource, e, data) {
        console.log('notifyEnter',ddSource,e,data);
        //Add some flare to invite drop.
        cmp.body.stopFx();
        cmp.body.highlight();
      },
      notifyDrop  : function(ddSource, e, data){
        console.log('notifyDrop',ddSource,e,data);
        // Reference the record (single selection) for readability
        //~ var selectedRecord = ddSource.dragData.selections[0];


        // Load the record into the form
        //~ formPanel.getForm().my_loadRecord(selectedRecord);


        // Delete record from the grid.  not really required.
        //~ ddSource.grid.store.remove(selectedRecord);

        return(true);
      }
    })
}


Lino.show_mti_child = function(fieldname,detail_handler) {
  //~ console.log('show_mti_child',this);
  //~ console.log('show_mti_child',panel.find("main_area"));
  rec = Lino.current_window.main_item.get_current_record();
  //~ rec = panel.get_current_record();
  if (rec) {
    //~ console.log('show_mti_child',Lino.current_window,rec);
    if (rec.phantom) {
      Lino.notify('Not allowed on phantom record.');
    }else if (rec.data[fieldname]) {
      //~ console.log('show_mti_child',rec.id);
      //~ detail_handler(Lino.current_window.main_item,{},{record_id:rec.id});
      detail_handler.run(null,{record_id:rec.id});
      //~ window.open(urlroot + '/' + rec.id);
      //~ document.location = urlroot + '/' + rec.id;
      //~ window.open(urlroot + '/' + rec.id,'_blank');
    } else {
      Lino.alert('Kann MTI-Kind nicht anzeigen wenn Checkbox abgeschlatet ist.');
    }
  } else {
    Lino.notify('No current record.');
  }
};




/*
Mappings towards lino.modlib.cal.models.PanelCalendars
*/
// Sset SS = Ssite.modules.cal.PanelCalendars.get_handle(Sui).store
Ext.ensible.cal.CalendarMappings = {
    CalendarId:   {name:'ID',       mapping: 'id', type: 'int'},
    Title:        {name:'CalTitle', mapping: 'babel_name', type: 'string'},
    Description:  {name:'Desc',     mapping: 'description', type: 'string'},
    ColorId:      {name:'Color',    mapping: 'color', type: 'int'},
    IsHidden:     {name:'Hidden',   mapping: 'is_hidden', type: 'boolean'},    
};
Ext.ensible.cal.CalendarRecord.reconfigure();  


/*
Mappings towards lino.modlib.cal.models.PanelEvents 
*/
// Sset SS = Ssite.modules.cal.PanelEvents.get_handle(Sui).store
Ext.ensible.cal.EventMappings = {
    EventId:     {name: 'ID',        mapping: 'id', type:'int'},
    CalendarId:  {name: 'CalID',     mapping: 'calendarHidden', type: 'int'},
    Title:       {name: 'EvtTitle',  mapping: 'summary'},
    StartDate:   {name: 'StartDt',   mapping: 'start_dt', 
      type: 'date', 
      dateFormat: "Y-m-d\TH:i:s" },
    EndDate:     {name: 'EndDt',     mapping: 'end_dt', 
      type: 'date', 
      dateFormat: "Y-m-d\TH:i:s"},
    RRule:       {name: 'RecurRule', mapping: 'rsetHidden'},
    Location:    {name: 'Location',  mapping: 'placeHidden'},
    Notes:       {name: 'Desc',      mapping: 'description'},
    Url:         {name: 'LinkUrl',   mapping: 'url'},
    IsAllDay:    {name: 'AllDay',    mapping: 'all_day', type: 'boolean'},
    Reminder:    {name: 'Reminder',  mapping: 'reminder'}
    
};
Ext.ensible.cal.EventRecord.reconfigure();


Lino.on_eventclick = function(cp,rec,el) {
  //~ console.log("Lino.on_eventclick",arguments);
  //~ Lino.cal.Events.detail_action.run({record_id:rec.data.ID});
  Lino.cal.PanelEvents.detail.run(null,{record_id:rec.data.ID,base_params:Lino.eventStore.baseParams});
  return false;
}
    
Lino.on_editdetails = function(cp,rec,el) {
  //~ console.log("Lino.on_editdetails",arguments);
  if (rec.data.ID)
      //~ Lino.cal.Events.detail_action.run({record_id:rec.data.ID});
      Lino.cal.PanelEvents.detail.run(null,{record_id:rec.data.ID,base_params:Lino.eventStore.baseParams});
  return false;
}

Lino.format_time = function(dt) {
    return dt.getHours() + ':' + dt.getMinutes();
}
    
Lino.on_eventdelete = function() {
  //~ console.log("Lino.on_eventdelete",arguments);
};

Lino.on_eventadd  = function(cp,rec,el) {
  //~ console.log("Lino.on_eventadd ",arguments);
  return false;
}
    
Lino.on_eventresize  = function(cp,rec,el) {
  //~ console.log("Lino.on_eventresize ",arguments);
  //~ Lino.cal.Events.insert(cp);
  //~ return false;
}
    
Lino.on_eventupdate  = function(cp,rec,el) {
  //~ console.log("Lino.on_eventupdate",arguments);
  //~ Lino.cal.Events.insert(cp);
  //~ return false;
}
    

//~ Lino.eventStore = new Ext.ensible.cal.EventStore({ 
//~ Lino.eventStore = new Ext.data.ArrayStore({ 
Lino.eventStore = new Ext.data.JsonStore({ 
  listeners: { exception: Lino.on_store_exception }
  ,url: ADMIN_URL + '/restful/cal/PanelEvents'
  ,restful : true
  ,proxy: new Ext.data.HttpProxy({ 
      url: ADMIN_URL + '/restful/cal/PanelEvents', 
      disableCaching: false // no need for cache busting when loading via Ajax
      //~ disableCaching:true,
  })
  ,fields: Ext.ensible.cal.EventRecord.prototype.fields.getRange()
  ,totalProperty: "count"
  ,root: "rows"
  ,idProperty: Ext.ensible.cal.EventMappings.EventId.mapping
  ,writer : new Ext.data.JsonWriter({
    writeAllFields: false
  })
  ,load: function(options) {
    //~ foo.bar = baz; // 20120213
      if (!options) options = {};
      if (!options.params) options.params = {};
      //~ options.params.tv = Lino.calendar_app.team_view_button.pressed;
      
      var view = this.cal_panel.getActiveView();
      var bounds = view.getViewBounds();
      //~ var p = {sd:'05.02.2012',ed:'11.02.2012'};
      //~ var p = {};
      options.params[view.dateParamStart] = bounds.start.format(view.dateParamFormat);
      options.params[view.dateParamEnd] = bounds.end.format(view.dateParamFormat);
      Lino.insert_subst_user(options.params);
      //~ Ext.apply(options.params,p)
      //~ console.log('20120710 eventStore.load()',this.baseParams,options);
    
    return Ext.data.JsonStore.prototype.load.call(this,options);
  }
});

//~ Lino.calendarStore = new Ext.data.ArrayStore({ 
Lino.calendarStore = new Ext.data.JsonStore({ 
      listeners: { exception: Lino.on_store_exception }
      ,restful : true
      ,proxy: new Ext.data.HttpProxy({ 
          url: ADMIN_URL + '/restful/cal/PanelCalendars?fmt=json', 
          disableCaching: false // no need for cache busting when loading via Ajax
          //~ restful : true
          //~ method: "GET"
      })
      //~ ,autoLoad: true
      //~ ,remoteSort: true
      //~ ,baseParams: bp
      ,totalProperty: "count"
      ,root: "rows"
      ,fields: Ext.ensible.cal.CalendarRecord.prototype.fields.getRange()
      ,idProperty: Ext.ensible.cal.CalendarMappings.CalendarId.mapping
      //~ ,idIndex: Ext.ensible.cal.CalendarMappings.CalendarId.mapping
    });


Lino.CalendarCfg = {
    dateParamFormat: 'd.m.Y',
    dateParamStart:'sd',
    dateParamEnd:'ed'
};
//~ 20120704 Lino.CalendarPanel = Ext.extend(Ext.ensible.cal.CalendarPanel,Lino.MainPanel);
//~ Lino.CalendarPanel = Ext.extend(Lino.CalendarPanel,{
Ext.override(Ext.ensible.cal.CalendarPanel,Lino.MainPanel);
Ext.override(Ext.ensible.cal.CalendarPanel,{
  //~ empty_title : "$ui.get_actor('cal.Panel').report.label",
  empty_title : "Kalender"
  ,activeItem: 1 // 0: day, 1: week
  ,ls_url: '/cal/CalendarPanel'
  //~ ,disableCaching:true
  ,eventStore: Lino.eventStore
  ,calendarStore: Lino.calendarStore
  ,listeners: { 
    editdetails: Lino.on_editdetails
    ,eventclick: Lino.on_eventclick
    //~ ,eventadd: Lino.on_eventadd
    //~ ,eventdelete: Lino.on_eventdelete
    //~ ,eventresize: Lino.on_eventresize
    ,afterrender : function(config) {
      //~ console.log("20120704 afterrender");
      Lino.calendarStore.load();
      //~ console.log("20120704 afterrender calls eventStore.load()",p);
      Lino.eventStore.cal_panel = this;
      //~ Lino.eventStore.load({params:p});
      Lino.eventStore.load();
      //~ Lino.CalendarPanel.superclass.constructor.call(this, config);
      //~ console.log(20120118, config,this);
    }
    }
  ,enableEditDetails: false
  //~ ,monthViewCfg: Lino.CalendarCfg
  //~ ,weekViewCfg: Lino.CalendarCfg
  //~ ,multiDayViewCfg: Lino.CalendarCfg
  //~ ,multiWeekViewCfg: Lino.CalendarCfg
  //~ ,dayViewCfg: Lino.CalendarCfg
  //~ ,initComponent : function() {
    //~ // this.on('eventadd',Lino.on_eventadd);
    //~ Lino.CalendarPanel.superclass.initComponent.call(this);
  //~ }
});




Lino.CalendarAppPanel = Ext.extend(Ext.Panel,Lino.MainPanel);
Lino.CalendarAppPanel = Ext.extend(Lino.CalendarAppPanel,{
  //~ empty_title : "$ui.get_actor('cal.Panel').report.label",
  empty_title : "Kalender"
  ,ls_url: '/cal/CalendarPanel'
  ,set_status : function(status) { this.refresh();}
  ,refresh : function() {Lino.eventStore.reload();}
  ,layout: 'fit'
  ,is_loading : function() { 
      var loading = Lino.calendarStore.getCount() == 0 | Lino.eventStore.getCount() == 0
      //~ console.log("CalendarPanel loading:",loading);
      return loading; 
  }
  ,get_base_params : function() {
    var p = Ext.apply({},this.base_params);
    Lino.insert_subst_user(p);
    return p;
  }
  ,set_base_params : function(p) {
    this.base_params = Ext.apply({},p);
  }
  ,clear_base_params : function() {
      this.base_params = {};
      Lino.insert_subst_user(this.base_params);
  }
  ,set_base_param : function(k,v) {
      if (!this.base_params) this.base_params = {};
      this.base_params[k] = v;
  }
});

Lino.calendar_app = function() { return {
  get_main_panel : function() {
      return new Lino.CalendarAppPanel({ items : 
        //~ [{
          //~ id: 'app-header',
          //~ region: 'north',
          //~ height: 35,
          //~ border: false,
          // contentEl: 'app-header-content'
        //~ },
      {
          id: 'app-center',
          title: '...', // will be updated to the current view's date range
          region: 'center',
          layout: 'border',
          listeners: {
              'afterrender': function(){
                  Ext.getCmp('app-center').header.addClass('app-center-header');
              }
          },
          items: [{
              id:'app-west',
              region: 'west',
              width: 176,
              border: false,
              items: [{
                  xtype: 'datepicker',
                  id: 'app-nav-picker',
                  cls: 'ext-cal-nav-picker',
                  listeners: {
                      'select': {
                          fn: function(dp, dt){
                              Lino.calendarPanel.setStartDate(dt);
                          },
                          scope: this
                      }
                  }
              //~ },{ 
                //~ layout:'fit',
                //~ items: [
                  //~ new Ext.form.Checkbox({
                    //~ boxLabel:"Team-Ansicht",
                    //~ hideLabel:true
                    //~ listeners: { click: }
                  //~ })
                //~ ]
              },{ 
                layout:'form',
                items: [
                  this.team_view_button = new Ext.Button({
                    text:"Team-Ansicht",
                    enableToggle:true,
                    pressed:false,
                    toggleHandler: function(btn,state) { 
                      //~ console.log('20120716 teamView.toggle()');
                      Lino.eventStore.setBaseParam('tv',state);
                      Lino.eventStore.load();
                      //~ Lino.eventStore.load({params:{tv:state}});
                      //~ console.log("team view",state);
                    }
                  })
                ]
              },{
                  xtype: 'extensible.calendarlist',
                  store: Lino.calendarStore,
                  border: false,
                  width: 175
              }]
          },{
              xtype: 'extensible.calendarpanel',
              eventStore: Lino.eventStore,
              calendarStore: Lino.calendarStore,
              border: false,
              id:'app-calendar',
              region: 'center',
              //~ activeItem: 3, // month view
              
              // Any generic view options that should be applied to all sub views:
              viewConfig: {
                  // Lino.CalendarCfg
                  dateParamFormat: 'd.m.Y',
                  dateParamStart:'sd',
                  dateParamEnd:'ed',
                
                  //enableFx: false,
                  //ddIncrement: 10, //only applies to DayView and subclasses, but convenient to put it here
                  viewStartHour: 8,
                  viewEndHour: 18
                  //minEventDisplayMinutes: 15
              },
              
              // View options specific to a certain view (if the same options exist in viewConfig
              // they will be overridden by the view-specific config):
              monthViewCfg: {
                  showHeader: true,
                  showWeekLinks: true,
                  showWeekNumbers: true,
                  eventBodyMarkup: ['{Title}',
                    //~ '<tpl if="url">',
                        //~ '<a href="{url}">XX</a>',
                    //~ '</tpl>',
                    '<tpl if="_isReminder">',
                        '<i class="ext-cal-ic ext-cal-ic-rem">&#160;</i>',
                    '</tpl>',
                    '<tpl if="_isRecurring">',
                        '<i class="ext-cal-ic ext-cal-ic-rcr">&#160;</i>',
                    '</tpl>',
                    '<tpl if="spanLeft">',
                        '<i class="ext-cal-spl">&#160;</i>',
                    '</tpl>',
                    '<tpl if="spanRight">',
                        '<i class="ext-cal-spr">&#160;</i>',
                    '</tpl>'
                ].join('')
              },
              
              multiWeekViewCfg: {
                  //weekCount: 3
              },
              
              // Some optional CalendarPanel configs to experiment with:
              //readOnly: true,
              //showDayView: false,
              //showMultiDayView: true,
              //showWeekView: false,
              //showMultiWeekView: false,
              //showMonthView: false,
              //showNavBar: false,
              //showTodayText: false,
              //showTime: false,
              //editModal: true,
              //enableEditDetails: false,
              //title: 'My Calendar', // the header of the calendar, could be a subtitle for the app
              
              // Once this component inits it will set a reference to itself as an application
              // member property for easy reference in other functions within App.
              initComponent: function() {
                  Lino.calendarPanel = this;
                  this.constructor.prototype.initComponent.apply(this, arguments);
              },
              
              listeners: {
                  //~ 'eventclick': {
                      //~ fn: function(vw, rec, el){
                          //~ this.clearMsg();
                      //~ },
                      //~ scope: this
                  //~ },
                  'eventover': function(vw, rec, el){
                      //console.log('Entered evt rec='+rec.data[Ext.ensible.cal.EventMappings.Title.name]', view='+ vw.id +', el='+el.id);
                  },
                  'eventout': function(vw, rec, el){
                      //console.log('Leaving evt rec='+rec.data[Ext.ensible.cal.EventMappings.Title.name]+', view='+ vw.id +', el='+el.id);
                  },
                  'eventadd': {
                      fn: function(cp, rec){
                          this.showMsg('Event '+ rec.data[Ext.ensible.cal.EventMappings.Title.name] +' was added');
                      },
                      scope: this
                  },
                  'eventupdate': {
                      fn: function(cp, rec){
                          this.showMsg('Event '+ rec.data[Ext.ensible.cal.EventMappings.Title.name] +' was updated');
                      },
                      scope: this
                  },
                  'eventdelete': {
                      fn: function(cp, rec){
                          //this.eventStore.remove(rec);
                          this.showMsg('Event '+ rec.data[Ext.ensible.cal.EventMappings.Title.name] +' was deleted');
                      },
                      scope: this
                  },
                  'eventcancel': {
                      fn: function(cp, rec){
                          // edit canceled
                      },
                      scope: this
                  },
                  'viewchange': {
                      fn: function(p, vw, dateInfo){
                          if(this.editWin){
                              this.editWin.hide();
                          };
                          if(dateInfo !== null){
                              // will be null when switching to the event edit form so ignore
                              Ext.getCmp('app-nav-picker').setValue(dateInfo.activeDate);
                              this.updateTitle(dateInfo.viewStart, dateInfo.viewEnd);
                          }
                      },
                      scope: this
                  },
                  'dayclick': {
                      fn: function(vw, dt, ad, el){
                          this.clearMsg();
                      },
                      scope: this
                  },
                  'rangeselect': {
                      fn: function(vw, dates, onComplete){
                          this.clearMsg();
                      },
                      scope: this
                  },
                  'eventmove': {
                      fn: function(vw, rec){
                          rec.commit();
                          var time = rec.data[Ext.ensible.cal.EventMappings.IsAllDay.name] ? '' : ' \\a\\t g:i a';
                          this.showMsg('Event '+ rec.data[Ext.ensible.cal.EventMappings.Title.name] +' was moved to '+
                              rec.data[Ext.ensible.cal.EventMappings.StartDate.name].format('F jS'+time));
                      },
                      scope: this
                  },
                  'eventresize': {
                      fn: function(vw, rec){
                          rec.commit();
                          this.showMsg('Event '+ rec.data[Ext.ensible.cal.EventMappings.Title.name] +' was updated');
                      },
                      scope: this
                  },
                  'eventdelete': {
                      fn: function(win, rec){
                          Lino.eventStore.remove(rec);
                          this.showMsg('Event '+ rec.data[Ext.ensible.cal.EventMappings.Title.name] +' was deleted');
                      },
                      scope: this
                  },
                  'initdrag': {
                      fn: function(vw){
                          if(this.editWin && this.editWin.isVisible()){
                              this.editWin.hide();
                          }
                      },
                      scope: this
                  }
              }
          }]
        }
        //~ ]
        
      });
      
  }
  ,updateTitle: function(startDt, endDt){
      var p = Ext.getCmp('app-center');
      
      if(startDt.clearTime().getTime() == endDt.clearTime().getTime()){
          p.setTitle(startDt.format('F j, Y'));
      }
      else if(startDt.getFullYear() == endDt.getFullYear()){
          if(startDt.getMonth() == endDt.getMonth()){
              p.setTitle(startDt.format('F j') + ' - ' + endDt.format('j, Y'));
          }
          else{
              p.setTitle(startDt.format('F j') + ' - ' + endDt.format('F j, Y'));
          }
      }
      else{
          p.setTitle(startDt.format('F j, Y') + ' - ' + endDt.format('F j, Y'));
      }
  }
  // This is an application-specific way to communicate CalendarPanel event messages back to the user.
  // This could be replaced with a function to do "toast" style messages, growl messages, etc. This will
  // vary based on application requirements, which is why it's not baked into the CalendarPanel.
  ,showMsg: function(msg){
      Lino.notify(msg);
      //~ Ext.fly('app-msg').update(msg).removeClass('x-hidden');
  }
  
  ,clearMsg: function(){
      Lino.notify('');
      //~ Ext.fly('app-msg').update('').addClass('x-hidden');
  }
}
}();



/*
captureEvents utility by Aaron Conran
<http://www.sencha.com/learn/grid-faq/>

Ext.onReady(function(){
    var grid = new Ext.grid.GridPanel({
        ... 
    });
    captureEvents(grid);
});
*/
function captureEvents(observable) {
    Ext.util.Observable.capture(
        observable,
        function(eventName) {
            console.info(eventName);
        },
        this
    );		
}
 



Lino.main_menu = [ { "menu": { "items": [ { "text": "Info", "listeners": { "render": Lino.quicktip_renderer("Foo","Detail-Fenster auf diesem Datensatz \u00f6ffnen") }, "handler": function(){Lino.about.About.show.run(null,{ "record_id": -99998 })} }, { "text": "Modelle", "handler": function(){Lino.about.Models.grid.run(null)} }, { "text": "Source files", "handler": function(){Lino.about.SourceFiles.grid.run(null)} } ] }, "text": "Site" }, { "text": "Startseite", "handler": function() { location.replace('javascript:Lino.close_all_windows()'); }, "xtype": "button" } ];
Ext.namespace('Lino.lino.SiteConfigs')
Ext.namespace('Lino.lino.ContentTypes')
Ext.namespace('Lino.lino.HelpTexts')
Ext.namespace('Lino.lino.TextFieldTemplates')
Ext.namespace('Lino.lino.Changes')
Ext.namespace('Lino.users.Users')
Ext.namespace('Lino.users.MySettings')
Ext.namespace('Lino.users.UsersOverview')
Ext.namespace('Lino.users.Authorities')
Ext.namespace('Lino.countries.Languages')
Ext.namespace('Lino.countries.Countries')
Ext.namespace('Lino.countries.Cities')
Ext.namespace('Lino.properties.PropGroups')
Ext.namespace('Lino.properties.PropTypes')
Ext.namespace('Lino.properties.Properties')
Ext.namespace('Lino.properties.PropChoices')
Ext.namespace('Lino.contacts.CompanyTypes')
Ext.namespace('Lino.contacts.Partners')
Ext.namespace('Lino.contacts.Companies')
Ext.namespace('Lino.contacts.RoleTypes')
Ext.namespace('Lino.contacts.Roles')
Ext.namespace('Lino.postings.Postings')
Ext.namespace('Lino.postings.PostingsByState')
Ext.namespace('Lino.postings.PostingsReady')
Ext.namespace('Lino.postings.PostingsPrinted')
Ext.namespace('Lino.postings.PostingsSent')
Ext.namespace('Lino.outbox.Recipients')
Ext.namespace('Lino.outbox.Mails')
Ext.namespace('Lino.outbox.Attachments')
Ext.namespace('Lino.cal.Calendars')
Ext.namespace('Lino.cal.Subscriptions')
Ext.namespace('Lino.cal.Memberships')
Ext.namespace('Lino.cal.Places')
Ext.namespace('Lino.cal.Priorities')
Ext.namespace('Lino.cal.Events')
Ext.namespace('Lino.cal.EventsSuggested')
Ext.namespace('Lino.cal.EventsNotified')
Ext.namespace('Lino.cal.Tasks')
Ext.namespace('Lino.cal.GuestRoles')
Ext.namespace('Lino.cal.Guests')
Ext.namespace('Lino.cal.PanelCalendars')
Ext.namespace('Lino.cal.PanelEvents')
Ext.namespace('Lino.uploads.UploadTypes')
Ext.namespace('Lino.uploads.Uploads')
Ext.namespace('Lino.households.Types')
Ext.namespace('Lino.households.Households')
Ext.namespace('Lino.households.Roles')
Ext.namespace('Lino.households.Members')
Ext.namespace('Lino.accounts.Charts')
Ext.namespace('Lino.accounts.Groups')
Ext.namespace('Lino.accounts.Accounts')
Ext.namespace('Lino.notes.NoteTypes')
Ext.namespace('Lino.notes.EventTypes')
Ext.namespace('Lino.notes.Notes')
Ext.namespace('Lino.cv.LanguageKnowledges')
Ext.namespace('Lino.cv.PersonProperties')
Ext.namespace('Lino.contacts.Persons')
Ext.namespace('Lino.pcsw.Clients')
Ext.namespace('Lino.pcsw.DebtsClients')
Ext.namespace('Lino.pcsw.IntegClients')
Ext.namespace('Lino.pcsw.ClientsTest')
Ext.namespace('Lino.pcsw.PersonGroups')
Ext.namespace('Lino.pcsw.Activities')
Ext.namespace('Lino.pcsw.ExclusionTypes')
Ext.namespace('Lino.pcsw.Exclusions')
Ext.namespace('Lino.pcsw.AidTypes')
Ext.namespace('Lino.pcsw.PersonSearches')
Ext.namespace('Lino.pcsw.OverlappingContracts')
Ext.namespace('Lino.pcsw.ClientContactTypes')
Ext.namespace('Lino.pcsw.ClientContacts')
Ext.namespace('Lino.pcsw.CoachingTypes')
Ext.namespace('Lino.pcsw.Coachings')
Ext.namespace('Lino.isip.ContractTypes')
Ext.namespace('Lino.isip.ExamPolicies')
Ext.namespace('Lino.isip.ContractEndings')
Ext.namespace('Lino.isip.Contracts')
Ext.namespace('Lino.isip.MyContracts')
Ext.namespace('Lino.jobs.Schedules')
Ext.namespace('Lino.jobs.Regimes')
Ext.namespace('Lino.jobs.JobProviders')
Ext.namespace('Lino.jobs.ContractTypes')
Ext.namespace('Lino.jobs.Sectors')
Ext.namespace('Lino.jobs.Functions')
Ext.namespace('Lino.jobs.Contracts')
Ext.namespace('Lino.jobs.MyContracts')
Ext.namespace('Lino.jobs.Offers')
Ext.namespace('Lino.jobs.StudyTypes')
Ext.namespace('Lino.jobs.Studies')
Ext.namespace('Lino.jobs.Experiences')
Ext.namespace('Lino.jobs.Candidatures')
Ext.namespace('Lino.jobs.Jobs')
Ext.namespace('Lino.jobs.JobTypes')
Ext.namespace('Lino.jobs.ContractsSearch')
Ext.namespace('Lino.newcomers.Brokers')
Ext.namespace('Lino.newcomers.Faculties')
Ext.namespace('Lino.newcomers.Competences')
Ext.namespace('Lino.newcomers.NewClients')
Ext.namespace('Lino.newcomers.AvailableCoaches')
Ext.namespace('Lino.debts.Budgets')
Ext.namespace('Lino.debts.Actors')
Ext.namespace('Lino.debts.Entries')
Ext.namespace('Lino.debts.EntriesByType')
Ext.namespace('Lino.cbss.Sectors')
Ext.namespace('Lino.cbss.Purposes')
Ext.namespace('Lino.cbss.IdentifyPersonRequests')
Ext.namespace('Lino.cbss.ManageAccessRequests')
Ext.namespace('Lino.cbss.RetrieveTIGroupsRequests')
Ext.namespace('Lino.courses.CourseProviders')
Ext.namespace('Lino.courses.Courses')
Ext.namespace('Lino.courses.CourseContents')
Ext.namespace('Lino.courses.CourseOffers')
Ext.namespace('Lino.courses.CourseRequests')
Ext.namespace('Lino.courses.PendingCourseRequests')
Ext.namespace('Lino.pcsw.WantedLanguageKnowledgeTable')
Ext.namespace('Lino.sessions.SessionTable')
Ext.namespace('Lino.properties.WantedSkillTable')
Ext.namespace('Lino.properties.UnwantedSkillTable')
Ext.namespace('Lino.lino.MyTextFieldTemplates')
Ext.namespace('Lino.users.AuthoritiesGiven')
Ext.namespace('Lino.users.AuthoritiesTaken')
Ext.namespace('Lino.countries.CitiesByCity')
Ext.namespace('Lino.countries.CitiesByCountry')
Ext.namespace('Lino.properties.PropsByGroup')
Ext.namespace('Lino.properties.PropsByType')
Ext.namespace('Lino.properties.ChoicesByType')
Ext.namespace('Lino.contacts.PartnersByCity')
Ext.namespace('Lino.contacts.PartnersByCountry')
Ext.namespace('Lino.contacts.RolesByCompany')
Ext.namespace('Lino.contacts.RolesByPerson')
Ext.namespace('Lino.postings.MyPostings')
Ext.namespace('Lino.postings.PostingsByPartner')
Ext.namespace('Lino.postings.PostingsByProject')
Ext.namespace('Lino.outbox.RecipientsByMail')
Ext.namespace('Lino.outbox.MyOutbox')
Ext.namespace('Lino.outbox.MailsByUser')
Ext.namespace('Lino.outbox.MailsByProject')
Ext.namespace('Lino.outbox.SentByPartner')
Ext.namespace('Lino.outbox.AttachmentsByMail')
Ext.namespace('Lino.cal.SubscriptionsByCalendar')
Ext.namespace('Lino.cal.SubscriptionsByUser')
Ext.namespace('Lino.cal.MembershipsByUser')
Ext.namespace('Lino.cal.EventsByCalendar')
Ext.namespace('Lino.cal.EventsByPartner')
Ext.namespace('Lino.cal.EventsByPlace')
Ext.namespace('Lino.cal.EventsByProject')
Ext.namespace('Lino.cal.MyEvents')
Ext.namespace('Lino.cal.MyEventsSuggested')
Ext.namespace('Lino.cal.MyEventsNotified')
Ext.namespace('Lino.cal.MyEventsToday')
Ext.namespace('Lino.cal.TasksByUser')
Ext.namespace('Lino.cal.MyTasks')
Ext.namespace('Lino.cal.MyTasksToDo')
Ext.namespace('Lino.cal.TasksByProject')
Ext.namespace('Lino.cal.GuestsByEvent')
Ext.namespace('Lino.cal.GuestsByRole')
Ext.namespace('Lino.cal.GuestsByPartner')
Ext.namespace('Lino.cal.MyPresences')
Ext.namespace('Lino.cal.MyPendingInvitations')
Ext.namespace('Lino.uploads.MyUploads')
Ext.namespace('Lino.households.HouseholdsByType')
Ext.namespace('Lino.households.MembersByHousehold')
Ext.namespace('Lino.households.MembersByPerson')
Ext.namespace('Lino.households.MembersByRole')
Ext.namespace('Lino.accounts.GroupsByChart')
Ext.namespace('Lino.accounts.AccountsByGroup')
Ext.namespace('Lino.notes.MyNotes')
Ext.namespace('Lino.notes.NotesByType')
Ext.namespace('Lino.notes.NotesByEventType')
Ext.namespace('Lino.notes.NotesByProject')
Ext.namespace('Lino.cv.LanguageKnowledgesByPerson')
Ext.namespace('Lino.cv.KnowledgesByLanguage')
Ext.namespace('Lino.cv.PropsByPerson')
Ext.namespace('Lino.cv.PersonPropsByProp')
Ext.namespace('Lino.cv.ConfiguredPropsByPerson')
Ext.namespace('Lino.cv.SkillsByPerson')
Ext.namespace('Lino.cv.SoftSkillsByPerson')
Ext.namespace('Lino.cv.ObstaclesByPerson')
Ext.namespace('Lino.pcsw.ClientsByNationality')
Ext.namespace('Lino.pcsw.ExclusionsByPerson')
Ext.namespace('Lino.pcsw.MyPersonSearches')
Ext.namespace('Lino.pcsw.LanguageKnowledgesBySearch')
Ext.namespace('Lino.pcsw.WantedPropsBySearch')
Ext.namespace('Lino.pcsw.UnwantedPropsBySearch')
Ext.namespace('Lino.pcsw.ClientsBySearch')
Ext.namespace('Lino.pcsw.ContactsByClient')
Ext.namespace('Lino.pcsw.CoachingsByClient')
Ext.namespace('Lino.pcsw.CoachingsByUser')
Ext.namespace('Lino.pcsw.MyCoachings')
Ext.namespace('Lino.pcsw.NotesByPerson')
Ext.namespace('Lino.pcsw.NotesByCompany')
Ext.namespace('Lino.isip.ContractsByPerson')
Ext.namespace('Lino.isip.ContractsByType')
Ext.namespace('Lino.jobs.FunctionsBySector')
Ext.namespace('Lino.jobs.ContractsByPerson')
Ext.namespace('Lino.jobs.ContractsByProvider')
Ext.namespace('Lino.jobs.ContractsByJob')
Ext.namespace('Lino.jobs.ContractsByRegime')
Ext.namespace('Lino.jobs.ContractsBySchedule')
Ext.namespace('Lino.jobs.StudiesByCountry')
Ext.namespace('Lino.jobs.StudiesByCity')
Ext.namespace('Lino.jobs.StudiesByPerson')
Ext.namespace('Lino.jobs.ExperiencesByFunction')
Ext.namespace('Lino.jobs.ExperiencesByPerson')
Ext.namespace('Lino.jobs.CandidaturesByPerson')
Ext.namespace('Lino.jobs.CandidaturesBySector')
Ext.namespace('Lino.jobs.CandidaturesByFunction')
Ext.namespace('Lino.jobs.CandidaturesByJob')
Ext.namespace('Lino.jobs.CandidaturesByOffer')
Ext.namespace('Lino.jobs.ExperiencesByOffer')
Ext.namespace('Lino.jobs.JobsByProvider')
Ext.namespace('Lino.jobs.JobsByType')
Ext.namespace('Lino.jobs.ContractsByType')
Ext.namespace('Lino.newcomers.CompetencesByUser')
Ext.namespace('Lino.newcomers.CompetencesByFaculty')
Ext.namespace('Lino.newcomers.MyCompetences')
Ext.namespace('Lino.newcomers.ClientsByFaculty')
Ext.namespace('Lino.newcomers.AvailableCoachesByClient')
Ext.namespace('Lino.debts.MyBudgets')
Ext.namespace('Lino.debts.BudgetsByPartner')
Ext.namespace('Lino.debts.ActorsByBudget')
Ext.namespace('Lino.debts.ActorsByPartner')
Ext.namespace('Lino.debts.EntriesByBudget')
Ext.namespace('Lino.debts.ExpensesByBudget')
Ext.namespace('Lino.debts.IncomesByBudget')
Ext.namespace('Lino.debts.LiabilitiesByBudget')
Ext.namespace('Lino.debts.AssetsByBudget')
Ext.namespace('Lino.debts.DistByBudget')
Ext.namespace('Lino.cbss.MyIdentifyPersonRequests')
Ext.namespace('Lino.cbss.IdentifyRequestsByPerson')
Ext.namespace('Lino.cbss.ManageAccessRequestsByPerson')
Ext.namespace('Lino.cbss.MyManageAccessRequests')
Ext.namespace('Lino.cbss.RetrieveTIGroupsRequestsByPerson')
Ext.namespace('Lino.cbss.MyRetrieveTIGroupsRequests')
Ext.namespace('Lino.courses.CoursesByOffer')
Ext.namespace('Lino.courses.CourseOffersByProvider')
Ext.namespace('Lino.courses.CourseRequestsByPerson')
Ext.namespace('Lino.courses.RequestsByCourse')
Ext.namespace('Lino.courses.ParticipantsByCourse')
Ext.namespace('Lino.courses.CandidatesByCourse')
Ext.namespace('Lino.uploads.UploadsByController')
Ext.namespace('Lino.lino.HelpTextsByModel')
Ext.namespace('Lino.postings.PostingsByController')
Ext.namespace('Lino.lino.ChangesByMaster')
Ext.namespace('Lino.cal.TasksByController')
Ext.namespace('Lino.outbox.MailsByController')
Ext.namespace('Lino.outbox.AttachmentsByController')
Ext.namespace('Lino.cal.EventsByController')
Ext.namespace('Lino.about.Models')
Ext.namespace('Lino.about.FieldsByModel')
Ext.namespace('Lino.about.Inspector')
Ext.namespace('Lino.about.SourceFiles')
Ext.namespace('Lino.pcsw.UsersWithClients')
Ext.namespace('Lino.debts.PrintEntriesByBudget')
Ext.namespace('Lino.debts.PrintExpensesByBudget')
Ext.namespace('Lino.debts.PrintIncomesByBudget')
Ext.namespace('Lino.debts.PrintLiabilitiesByBudget')
Ext.namespace('Lino.debts.PrintAssetsByBudget')
Ext.namespace('Lino.debts.BudgetSummary')
Ext.namespace('Lino.cbss.IdentifyPersonResult')
Ext.namespace('Lino.cbss.RetrieveTIGroupsResult')
Ext.namespace('Lino.about.About')
Ext.namespace('Lino.cal.CalendarPanel')
Ext.namespace('Lino.lino.Home')
Ext.namespace('Lino.jobs.JobsOverview')

// ChoiceLists: 
Lino.courses.CourseRequestStates = [ [ "10", "Kandidat" ], [ "20", "Eingetragen" ], [ "30", "Bestanden" ], [ "40", "Gut bestanden" ], [ "50", "Nicht bestanden" ], [ "60", "Abgebrochen" ] ];
Lino.postings.PostingStates = [ [ "10", "In Bearbeitung" ], [ "20", "Bereit f\u00fcr Ausdruck" ], [ "30", "Ausgedruckt" ], [ "40", "Versendet" ], [ "50", "Retour" ] ];
Lino.cbss.QueryRegister = [ [ "1", "Prim\u00e4r" ], [ "2", "Sekund\u00e4r" ], [ "3", "Alle" ] ];
Lino.cal.DurationUnits = [ [ "s", "Sekunden" ], [ "m", "Minuten" ], [ "h", "Stunden" ], [ "D", "Tage" ], [ "W", "Wochen" ], [ "M", "Monate" ], [ "Y", "Jahre" ] ];
Lino.cal.TaskStates = [ [ "10", "Zu tun" ], [ "20", "Begonnen" ], [ "30", "Erledigt" ], [ "50", "Storniert" ] ];
Lino.lino.UserLevels = [ [ "10", "Gast" ], [ "20", "Sekret\u00e4r" ], [ "30", "Benutzer" ], [ "40", "Manager" ], [ "50", "Verwalter" ], [ "90", "Experte" ] ];
Lino.lino.UserProfiles = [ [ "100", "100 (Begleiter im DSBE)" ], [ "110", "110 (Integrations-Assistent (Dienstleiter))" ], [ "200", "200 (Berater Neuantr\u00e4ge)" ], [ "300", "300 (Schuldenberater)" ], [ "400", "400 (Anonymous)" ], [ "500", "500 (nur KBSS)" ], [ "900", "900 (Verwalter)" ] ];
Lino.cal.EventStates = [ [ "10", "Neu" ], [ "15", "Vorgeschlagen" ], [ "20", "Entwurf" ], [ "30", "Mitgeteilt" ], [ "40", "Geplant" ], [ "50", "Stattgefunden" ], [ "60", "Verschoben" ], [ "70", "Storniert" ], [ "80", "Abwesend" ] ];
Lino.accounts.AccountTypes = [ [ "A", "Verm\u00f6gen" ], [ "L", "Verpflichtungen" ], [ "I", "Eink\u00fcnfte" ], [ "E", "Ausgaben" ], [ "C", "Kapital" ] ];
Lino.cv.CefLevel = [ [ "A1", "A1 (Elementare Sprachverwendung)" ], [ "A2", "A2 (Elementare Sprachverwendung)" ], [ "A2+", "A2+ (Elementare Sprachverwendung)" ], [ "B1", "B1 (Selbstst\u00e4ndige Sprachverwendung)" ], [ "B2", "B2 (Selbstst\u00e4ndige Sprachverwendung)" ], [ "B2+", "B2+ (Selbstst\u00e4ndige Sprachverwendung)" ], [ "C1", "C1 (Exzellente Sprachverwendung)" ], [ "C2", "C2 (Exzellente Sprachverwendung)" ], [ "C2+", "C2+ (Exzellente Sprachverwendung)" ] ];
Lino.properties.HowWell = [ [ "0", "gar nicht" ], [ "1", "ein bisschen" ], [ "2", "mittelm\u00e4\u00dfig" ], [ "3", "gut" ], [ "4", "sehr gut" ] ];
Lino.outbox.RecipientType = [ [ "to", "Empf\u00e4nger" ], [ "cc", "Kopie an" ], [ "bcc", "Blindkopie an" ] ];
Lino.cal.GuestStates = [ [ "10", "Eingeladen" ], [ "20", "Zugesagt" ], [ "30", "Abgesagt" ], [ "40", "Anwesend" ], [ "50", "Abwesend" ] ];
Lino.pcsw.CivilState = [ [ "10", "Ledig" ], [ "13", "Ledig zusammenwohnend" ], [ "18", "Ledig mit Kind" ], [ "20", "Verheiratet" ], [ "21", "Verheirated (allein lebend)" ], [ "22", "Verheirated (mit anderem Partner lebend)" ], [ "30", "Verwitwet" ], [ "33", "Verwitwet (zusammenwohnend)" ], [ "40", "Geschieden" ], [ "50", "Getrennt von Tisch und Bett" ] ];
Lino.pcsw.ClientStates = [ [ "10", "Neuantrag" ], [ "20", "Abgelehnt" ], [ "30", "Begleitet" ], [ "50", "Ehemalig" ], [ "60", "Ung\u00fcltig" ] ];
Lino.countries.CityTypes = [ [ "10", "Bundesland" ], [ "11", "Division" ], [ "12", "Region" ], [ "13", "Gemeinschaft" ], [ "14", "Territorium" ], [ "20", "Regierungsbezirk" ], [ "21", "Provinz" ], [ "22", "Shire" ], [ "23", "Unterregion" ], [ "24", "Departement" ], [ "25", "Arrondissement" ], [ "26", "Pr\u00e4fektur" ], [ "27", "Distrikt" ], [ "28", "Sektor" ], [ "50", "Stadt" ], [ "51", "Kleinstadt" ], [ "52", "Gemeinde" ], [ "54", "Pfarre" ], [ "55", "Township" ], [ "56", "Viertel" ], [ "61", "Ortschaft" ], [ "62", "Kleine Ortschaft" ], [ "70", "Dorf" ] ];
Lino.properties.DoYouLike = [ [ "0", "blo\u00df nicht" ], [ "1", "eher nicht" ], [ "2", "normal" ], [ "3", "gerne" ], [ "4", "sehr gerne" ] ];
Lino.cbss.RequestLanguages = [ [ "nl", "Niederl\u00e4ndisch" ], [ "fr", "Franz\u00f6sisch" ], [ "de", "Deutsch" ] ];
Lino.cbss.ManageAction = [ [ "1", "Eintragen" ], [ "2", "Austragen" ], [ "3", "Auflisten" ] ];
Lino.lino.UserGroups = [ [ "office", "office (Office)" ], [ "integ", "integ (DSBE)" ], [ "newcomers", "newcomers (Neuantr\u00e4ge)" ], [ "debts", "debts (Schuldnerberatung)" ], [ "cbss", "cbss (KBSS)" ] ];
Lino.cbss.RequestStates = [ [ "10", "Versendet" ], [ "20", "Fehlgeschlagen" ], [ "25", "Validiert" ], [ "30", "OK" ], [ "40", "Warnungen" ], [ "50", "Fehlermeldungen" ] ];
Lino.lino.ChangeTypes = [ [ "C", "Erstellen" ], [ "U", "Aktualisierung" ], [ "D", "L\u00f6schen" ], [ "R", "Remove child" ], [ "A", "Add child" ] ];
Lino.cal.AccessClasses = [ [ "10", "Privat" ], [ "20", "halb \u00f6ffentlich (\"Besch\u00e4ftigt\")" ], [ "30", "\u00d6ffentlich" ] ];
Lino.pcsw.BeIdCardType = [ [ "1", "Belgischer Staatsb\u00fcrger" ], [ "6", "Kind unter 12 Jahren" ], [ "8", "Habilitierung" ], [ "11", "A (Bescheinigung der Eintragung im Ausl\u00e4nderregister - Vor\u00fcbergehender Aufenthalt)" ], [ "12", "B (Bescheinigung der Eintragung im Ausl\u00e4nderregister)" ], [ "13", "C (Personalausweis f\u00fcr Ausl\u00e4nder)" ], [ "14", "D (Daueraufenthalt - EG)" ], [ "15", "E (Anmeldebescheinigung)" ], [ "16", "E+" ], [ "17", "F (Aufenthaltskarte f\u00fcr Familienangeh\u00f6rige eines Unionsb\u00fcrgers)" ], [ "18", "F+" ] ];
Lino.cal.Weekday = [ [ "1", "Montag" ], [ "2", "Dienstag" ], [ "3", "Mittwoch" ], [ "4", "Donnerstag" ], [ "5", "Freitag" ], [ "6", "Samstag" ], [ "7", "Sonntag" ] ];
Lino.pcsw.ResidenceType = [ [ "1", "Bev\u00f6lkerungsregister" ], [ "2", "Fremdenregister" ], [ "3", "Warteregister" ] ];
Lino.contacts.Gender = [ [ "M", "M\u00e4nnlich" ], [ "F", "Weiblich" ] ];

Lino.outbox.MailsByUser.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 28,
  initComponent : function() {
    var containing_panel = this;
    var project29 = new Lino.TwinCombo({ "fieldLabel": "Klient", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail)}, "emptyText": "Klient ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "projectHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/Mails/project", "method": "GET" }) }) });
    var subject30 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Thema", "anchor": "-20", "name": "subject" });
    var body31 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 71, "containing_panel": this, "name": "body", "title": "Inhalt" });
    var main_panel32 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "labelWidth": 72, "hideCheckBoxLabels": true, "items": [ { "items": project29, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" }, { "items": subject30, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" }, body31 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel32;
    this.before_row_edit = function(record) {
      body31.refresh();
    }
    Lino.outbox.MailsByUser.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cbss.RetrieveTIGroupsRequests.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 88,
  initComponent : function() {
    var containing_panel = this;
    var id35 = new Ext.form.NumberField({ "selectOnFocus": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var person36 = new Lino.TwinCombo({ "fieldLabel": "Klient", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail)}, "emptyText": "Klient ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "personHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cbss/RetrieveTIGroupsRequests/person", "method": "GET" }) }), "name": "person" });
    var user37 = new Lino.TwinCombo({ "fieldLabel": "Autor", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "emptyText": "Benutzer ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "userHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cbss/RetrieveTIGroupsRequests/user", "method": "GET" }) }), "name": "user" });
    var environment38 = new Ext.form.TextField({ "disabled": true, "fieldLabel": "T/A/B", "name": "environment", "maxLength": 4, "boxMinWidth": Lino.chars2width(4), "anchor": "-20" });
    var sent39 = new Ext.form.DisplayField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Sent","The date and time when this request has been executed. \nThis is empty for requests than haven't been sent.\nRead-only.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Versendet</span>", "name": "sent", "anchor": "-20", "value": "<br>" });
    var status40 = new Lino.ChoicesFieldElement({ "disabled": true, "forceSelection": true, "fieldLabel": "Zustand", "name": "status", "anchor": "-20", "store": Lino.cbss.RequestStates, "hiddenName": "statusHidden" });
    var ticket41 = new Ext.form.TextField({ "disabled": true, "maxLength": 36, "fieldLabel": "Ticket", "anchor": "-20", "name": "ticket" });
    var info_1_panel42 = new Ext.form.FieldSet({ "autoHeight": true, "layout": "hbox", "title": "Info zur Anfrage", "layoutConfig": { "align": "stretchmax" }, "frame": false, "bodyBorder": true, "autoScroll": false, "items": [ { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id35, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": person36, "labelAlign": "top" }, { "flex": 15, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user37, "labelAlign": "top" }, { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": environment38, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": sent39, "labelAlign": "top" }, { "flex": 15, "autoHeight": true, "layout": "form", "xtype": "panel", "items": status40, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": ticket41, "labelAlign": "top" } ], "hideCheckBoxLabels": true, "labelWidth": 63, "border": false, "labelAlign": "top" });
    var national_id50 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "NR-Nummer", "anchor": "-20", "name": "national_id" });
    var language51 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Sprache", "name": "language", "selectOnFocus": true, "anchor": "-20", "store": Lino.cbss.RequestLanguages, "hiddenName": "languageHidden" });
    var history52 = new Ext.form.Checkbox({ "boxLabel": "Chronik", "listeners": { "render": Lino.quicktip_renderer("History","Whatever this means.") }, "hideLabel": true, "checked": false, "name": "history", "selectOnFocus": true, "anchor": "-20" });
    var parameters_panel53 = new Ext.form.FieldSet({ "autoHeight": true, "layout": "hbox", "title": "Parameter", "layoutConfig": { "align": "stretchmax" }, "frame": false, "bodyBorder": true, "autoScroll": false, "items": [ { "flex": 46, "autoHeight": true, "layout": "form", "xtype": "panel", "items": national_id50, "labelAlign": "top" }, { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language51, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": history52, "labelAlign": "top" } ], "hideCheckBoxLabels": true, "labelWidth": 108, "border": false, "labelAlign": "top" });
    var cbss_RetrieveTIGroupsResult_grid62 = new Lino.cbss.RetrieveTIGroupsResult.GridPanel({ "flex": 71, "hide_top_toolbar": true, "containing_panel": this, "viewConfig": { "emptyText": "No data to display." }, "tools": [ Lino.show_in_own_window_button(Lino.cbss.RetrieveTIGroupsResult.grid) ], "master_panel": this });
    var request_panel63 = new Ext.Panel({ "layout": "vbox", "title": "Abfrage", "items": [ info_1_panel42, parameters_panel53, cbss_RetrieveTIGroupsResult_grid62 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var main_panel71 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ request_panel63 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel71;
    this.before_row_edit = function(record) {
      cbss_RetrieveTIGroupsResult_grid62.on_master_changed();
    }
    Lino.cbss.RetrieveTIGroupsRequests.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cbss.RetrieveTIGroupsRequests.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 88,
  initComponent : function() {
    var containing_panel = this;
    var person72 = new Lino.TwinCombo({ "fieldLabel": "Klient", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail)}, "emptyText": "Klient ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "personHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cbss/RetrieveTIGroupsRequests/person", "method": "GET" }) }), "name": "person" });
    var national_id73 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "NR-Nummer", "anchor": "-20", "name": "national_id" });
    var language74 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Sprache", "name": "language", "selectOnFocus": true, "anchor": "-20", "store": Lino.cbss.RequestLanguages, "hiddenName": "languageHidden" });
    var main_2_panel75 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 60, "autoHeight": true, "layout": "form", "xtype": "panel", "items": national_id73, "labelAlign": "top" }, { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language74, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 108, "border": false, "anchor": "-20", "labelAlign": "top" });
    var history78 = new Ext.form.Checkbox({ "boxLabel": "Chronik", "listeners": { "render": Lino.quicktip_renderer("History","Whatever this means.") }, "hideLabel": true, "checked": false, "name": "history", "selectOnFocus": true, "anchor": "-20" });
    var main_panel79 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 72, "autoScroll": false, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": person72, "anchor": "-20", "labelAlign": "top" }, main_2_panel75, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": history78, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel79;
    this.before_row_edit = function(record) {
    }
    Lino.cbss.RetrieveTIGroupsRequests.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.about.About.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  disable_editing: true,
  initComponent : function() {
    var containing_panel = this;
    var main_panel83 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "fit", "hideCheckBoxLabels": true, "items": [ { "html": "<div class=\"htmlText\"><p><a href=\"http://code.google.com/p/lino-welfare/\" target=\"_blank\">Lino/Welfare</a> 1.0.1, <a href=\"http://lino.saffre-rumma.net\" target=\"_blank\">Lino</a> 1.5.1, <a href=\"http://www.djangoproject.com\" target=\"_blank\">Django</a> 1.5.dev17942, <a href=\"http://labix.org/python-dateutil\" target=\"_blank\">python-dateutil</a> 1.5, <a href=\"http://cheetahtemplate.org/\" target=\"_blank\">Cheetah</a> 2.4.4, <a href=\"http://pypi.python.org/pypi/odfpy\" target=\"_blank\">OdfPy</a> ODFPY/0.9.4, <a href=\"http://docutils.sourceforge.net/\" target=\"_blank\">docutils</a> 0.7, <a href=\"https://fedorahosted.org/suds/\" target=\"_blank\">suds</a> 0.4.1, <a href=\"http://pyyaml.org/\" target=\"_blank\">PyYaml</a> 3.08, <a href=\"http://appyframework.org/pod.html\" target=\"_blank\">Appy</a> 0.8.0 (2011/12/15 22:41), <a href=\"http://www.python.org/\" target=\"_blank\">Python</a> 2.7.1, <a href=\"http://www.famfamfam.com/lab/icons/silk/\" target=\"_blank\">Silk Icons</a> 1.3, <a href=\"http://www.sencha.com\" target=\"_blank\">ExtJS</a> <a href=\"#\" onclick=\"alert('ExtJS client version is ' + Ext.version);\" title=\"Click to see ExtJS client version\">(version)</a>, <a href=\"http://ext.ensible.com/products/calendar/\" target=\"_blank\">Extensible</a> <a href=\"#\" onclick=\"alert('Extensible Calendar version is ' + Ext.ensible.version);\" title=\"Click to see Extensible Calendar version\">(version)</a></p><ul><li>Server uptime : <b>Monday, November 12, 2012 at 18:05:53.703000</b></li><li>Source timestamp (lino) : <b>Monday, November 12, 2012 at 18:03:52</b></li><li>Source timestamp (lino_welfare) : <b>Monday, November 12, 2012 at 18:05:54</b></li></ul></div>", "xtype": "label" } ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel83;
    this.before_row_edit = function(record) {
    }
    Lino.about.About.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.lino.ContentTypes.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 1,
  initComponent : function() {
    var containing_panel = this;
    var id84 = new Ext.form.NumberField({ "selectOnFocus": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var name85 = new Ext.form.TextField({ "fieldLabel": "name", "name": "name", "maxLength": 100, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var app_label86 = new Ext.form.TextField({ "fieldLabel": "app label", "name": "app_label", "maxLength": 100, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var model87 = new Ext.form.TextField({ "fieldLabel": "Python Modell-Klassenname", "name": "model", "maxLength": 100, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var base_classes_disp88 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Base classes", "name": "base_classes", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var main_1_panel89 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 216, "hideCheckBoxLabels": true, "items": [ { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id84, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name85, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": app_label86, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": model87, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": base_classes_disp88, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var lino_HelpTextsByModel_grid101 = new Lino.lino.HelpTextsByModel.GridPanel({ "flex": 62, "hide_top_toolbar": true, "containing_panel": this, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." }, "tools": [ Lino.show_in_own_window_button(Lino.lino.HelpTextsByModel.grid) ], "master_panel": this });
    var main_panel102 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel89, lino_HelpTextsByModel_grid101 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel102;
    this.before_row_edit = function(record) {
      lino_HelpTextsByModel_grid101.on_master_changed();
    }
    Lino.lino.ContentTypes.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.properties.PropGroups.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 15,
  initComponent : function() {
    var containing_panel = this;
    var id103 = new Ext.form.NumberField({ "selectOnFocus": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var name104 = new Ext.form.TextField({ "fieldLabel": "Bezeichnung", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr105 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Bezeichnung (fr)", "anchor": "-20", "name": "name_fr" });
    var name_en106 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Bezeichnung (en)", "anchor": "-20", "name": "name_en" });
    var main_1_panel107 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 7, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id103, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name104, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr105, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_en106, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var PropsByGroup_grid140 = new Lino.properties.PropsByGroup.GridPanel({ "flex": 83, "hide_top_toolbar": true, "containing_panel": this, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." }, "tools": [ Lino.show_in_own_window_button(Lino.properties.PropsByGroup.grid) ], "master_panel": this });
    var main_panel141 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel107, PropsByGroup_grid140 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel141;
    this.before_row_edit = function(record) {
      PropsByGroup_grid140.on_master_changed();
    }
    Lino.properties.PropGroups.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.uploads.Uploads.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 25,
  initComponent : function() {
    var containing_panel = this;
    var file142 = Lino.file_field_handler(this,{ "fieldLabel": "Datei", "name": "file", "maxLength": 100, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var user143 = new Lino.TwinCombo({ "fieldLabel": "Autor", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "emptyText": "Benutzer ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "userHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/Uploads/user", "method": "GET" }) }) });
    var main_1_panel144 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 63, "hideCheckBoxLabels": true, "items": [ { "flex": 58, "autoHeight": true, "layout": "form", "xtype": "panel", "items": file142, "labelAlign": "top" }, { "flex": 41, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user143, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var type147 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Upload-Art", "name": "type", "pageSize": 20, "emptyText": "Upload-Art ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/Uploads/type", "method": "GET" }) }) });
    var description148 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Beschreibung", "anchor": "-20", "name": "description" });
    var valid_until149 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "g\u00fcltig bis", "anchor": "-20", "name": "valid_until" });
    var main_2_panel150 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 108, "hideCheckBoxLabels": true, "items": [ { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type147, "labelAlign": "top" }, { "flex": 42, "autoHeight": true, "layout": "form", "xtype": "panel", "items": description148, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": valid_until149, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var modified154 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Bearbeitet", "anchor": "-20", "value": "<br>", "name": "modified" });
    var created155 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Erstellt", "anchor": "-20", "value": "<br>", "name": "created" });
    var owner_disp156 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Verkn\u00fcpft mit", "anchor": "-20", "name": "owner" });
    var main_3_panel157 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 126, "hideCheckBoxLabels": true, "items": [ { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": modified154, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": created155, "labelAlign": "top" }, { "flex": 48, "autoHeight": true, "layout": "form", "xtype": "panel", "items": owner_disp156, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var main_panel202 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel144, main_2_panel150, main_3_panel157 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel202;
    this.before_row_edit = function(record) {
    }
    Lino.uploads.Uploads.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.countries.Languages.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 10,
  initComponent : function() {
    var containing_panel = this;
    var id203 = new Ext.form.TextField({ "fieldLabel": "id", "name": "id", "maxLength": 3, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(3), "anchor": "-20", "allowBlank": false });
    var iso2204 = new Ext.form.TextField({ "fieldLabel": "iso2", "name": "iso2", "maxLength": 2, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(2), "anchor": "-20" });
    var name205 = new Ext.form.TextField({ "fieldLabel": "Bezeichnung", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr206 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Bezeichnung (fr)", "anchor": "-20", "name": "name_fr" });
    var name_en207 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Bezeichnung (en)", "anchor": "-20", "name": "name_en" });
    var main_1_panel208 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id203, "labelAlign": "top" }, { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": iso2204, "labelAlign": "top" }, { "flex": 29, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name205, "labelAlign": "top" }, { "flex": 29, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr206, "labelAlign": "top" }, { "flex": 29, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_en207, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var main_panel221 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel208 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel221;
    this.before_row_edit = function(record) {
    }
    Lino.countries.Languages.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.users.MySettings.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 8,
  initComponent : function() {
    var containing_panel = this;
    var username222 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Username","\n        Required. Must be unique. \n        ") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Benutzername</span>", "name": "username", "maxLength": 30, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var id223 = new Ext.form.NumberField({ "selectOnFocus": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var profile224 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Benutzerprofil", "name": "profile", "selectOnFocus": true, "anchor": "-20", "store": Lino.lino.UserProfiles, "hiddenName": "profileHidden" });
    var box1_1_panel225 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": username222, "labelAlign": "top" }, { "flex": 7, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id223, "labelAlign": "top" }, { "flex": 62, "autoHeight": true, "layout": "form", "xtype": "panel", "items": profile224, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var first_name229 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 30, "fieldLabel": "Vorname", "anchor": "-20", "name": "first_name" });
    var last_name230 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 30, "fieldLabel": "Familienname", "anchor": "-20", "name": "last_name" });
    var partner231 = new Lino.TwinCombo({ "fieldLabel": "Partner", "name": "partner", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Partners.detail)}, "emptyText": "Partner ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "partnerHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/Users/partner", "method": "GET" }) }) });
    var box1_2_panel232 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": first_name229, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": last_name230, "labelAlign": "top" }, { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": partner231, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 99, "border": false, "anchor": "-20", "labelAlign": "top" });
    var email236 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75, "fieldLabel": "e-mail address", "anchor": "-20", "name": "email" });
    var language237 = new Lino.ChoicesFieldElement({ "fieldLabel": "Sprache", "allowBlank": false, "selectOnFocus": true, "hiddenName": "languageHidden", "anchor": "-20", "store": [ [ "de", "Deutsch" ], [ "fr", "Franz\u00f6sisch" ], [ "en", "Englisch" ] ], "name": "language" });
    var box1_3_panel238 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 51, "autoHeight": true, "layout": "form", "xtype": "panel", "items": email236, "labelAlign": "top" }, { "flex": 48, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language237, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 135, "border": false, "anchor": "-20", "labelAlign": "top" });
    var created241 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Erstellt", "anchor": "-20", "value": "<br>", "name": "created" });
    var modified242 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Bearbeitet", "anchor": "-20", "value": "<br>", "name": "modified" });
    var box1_4_panel243 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": created241, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": modified242, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 81, "border": false, "anchor": "-20", "labelAlign": "top" });
    var box1_panel246 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "form", "hideCheckBoxLabels": true, "items": [ box1_1_panel225, box1_2_panel232, box1_3_panel238, box1_4_panel243 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    var remarks247 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Bemerkungen", "anchor": "-20 -10", "growMax": 2000, "name": "remarks" });
    var AuthoritiesGiven_grid250 = new Lino.users.AuthoritiesGiven.GridPanel({ "flex": 20, "hide_top_toolbar": true, "containing_panel": this, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." }, "tools": [ Lino.show_in_own_window_button(Lino.users.AuthoritiesGiven.grid) ], "master_panel": this });
    var general_2_panel251 = new Ext.Panel({ "flex": 55, "border": false, "layout": "hbox", "labelWidth": 72, "hideCheckBoxLabels": true, "items": [ { "items": remarks247, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 80 }, AuthoritiesGiven_grid250 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var general_panel253 = new Ext.Panel({ "layout": "vbox", "title": "Allgemein", "items": [ box1_panel246, general_2_panel251 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var calendar254 = new Lino.TwinCombo({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Standard-Kalender</span>", "name": "calendar", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.Calendars.detail)}, "emptyText": "Kalender ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Default calendar","The default calendar for your events and tasks.") }, "selectOnFocus": true, "hiddenName": "calendarHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/Users/calendar", "method": "GET" }) }) });
    var access_class255 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Standardm\u00e4\u00dfige Zugriffsklasse</span>", "allowBlank": false, "hiddenName": "access_classHidden", "listeners": { "render": Lino.quicktip_renderer("Default access class","The default access class for your calendar events and tasks.") }, "selectOnFocus": true, "anchor": "-20", "store": Lino.cal.AccessClasses, "name": "access_class" });
    var cal_left_1_panel256 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 39, "autoHeight": true, "layout": "form", "xtype": "panel", "items": calendar254, "labelAlign": "top" }, { "flex": 60, "autoHeight": true, "layout": "form", "xtype": "panel", "items": access_class255, "labelAlign": "top" } ], "region": "north", "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "split": true, "autoScroll": false, "labelWidth": 189, "border": false, "frame": false, "labelAlign": "top" });
    var cal_left_panel268 = new Lino.VBorderPanel({ "flex": 33, "border": false, "hideCheckBoxLabels": true, "items": [ cal_left_1_panel256 ], "frame": true, "autoScroll": false, "bodyBorder": false, "labelAlign": "top" });
    var cal_1_panel292 = new Ext.Panel({ "autoScroll": false, "listeners": { "activate": Lino.on_tab_activate }, "border": false, "layout": "hbox", "title": "Kalender", "hideCheckBoxLabels": true, "items": [ cal_left_panel268 ], "frame": false, "layoutConfig": { "align": "stretch" }, "labelAlign": "top" });
    var newcomer_quota293 = new Ext.form.NumberField({ "listeners": { "render": Lino.quicktip_renderer("Newcomers Quota","Wieviele Neuantr\u00e4ge dieser Benutzer pro Monat verkraften kann.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Quote NZ</span>", "name": "newcomer_quota", "selectOnFocus": true, "anchor": "-20", "value": 0, "allowBlank": false });
    var coaching_type294 = new Lino.RemoteComboFieldElement({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Dienst</span>", "name": "coaching_type", "pageSize": 20, "emptyText": "Dienst ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Coaching type","The default CoachingType used when creating Coachings.") }, "selectOnFocus": true, "hiddenName": "coaching_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/Users/coaching_type", "method": "GET" }) }) });
    var coaching_supervisor295 = new Ext.form.Checkbox({ "boxLabel": "Benachrichtigung wenn ein Begleiter zugewiesen wird", "listeners": { "render": Lino.quicktip_renderer("Notify me when a coach has been assigned","Wenn ein Neuantrag einem Begleiter zugewiesen wurde, wird au\u00dfer dem Begleiter auch dieser Benutzer benachrichtigt.") }, "hideLabel": true, "checked": false, "name": "coaching_supervisor", "selectOnFocus": true, "anchor": "-20" });
    var newcomers_CompetencesByUser_grid300 = new Lino.newcomers.CompetencesByUser.GridPanel({ "flex": 62, "hide_top_toolbar": true, "containing_panel": this, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." }, "tools": [ Lino.show_in_own_window_button(Lino.newcomers.CompetencesByUser.grid) ], "master_panel": this });
    var coaching_a_panel301 = new Ext.Panel({ "flex": 33, "layout": "vbox", "items": [ { "items": newcomer_quota293, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" }, { "items": coaching_type294, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" }, { "items": coaching_supervisor295, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" }, newcomers_CompetencesByUser_grid300 ], "frame": true, "layoutConfig": { "align": "stretch" }, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 369, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var pcsw_CoachingsByUser_grid312 = new Lino.pcsw.CoachingsByUser.GridPanel({ "flex": 66, "hide_top_toolbar": true, "containing_panel": this, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." }, "tools": [ Lino.show_in_own_window_button(Lino.pcsw.CoachingsByUser.grid) ], "master_panel": this });
    var coaching_1_panel313 = new Ext.Panel({ "autoScroll": false, "listeners": { "activate": Lino.on_tab_activate }, "border": false, "layout": "hbox", "title": "Begleitung", "hideCheckBoxLabels": true, "items": [ coaching_a_panel301, pcsw_CoachingsByUser_grid312 ], "frame": false, "layoutConfig": { "align": "stretch" }, "labelAlign": "top" });
    var main_panel314 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ general_panel253, cal_1_panel292, coaching_1_panel313 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel314;
    this.before_row_edit = function(record) {
      AuthoritiesGiven_grid250.on_master_changed();
      newcomers_CompetencesByUser_grid300.on_master_changed();
      pcsw_CoachingsByUser_grid312.on_master_changed();
    }
    Lino.users.MySettings.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.notes.Notes.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 90,
  initComponent : function() {
    var containing_panel = this;
    var event_type315 = new Lino.TwinCombo({ "fieldLabel": "Ereignisart (Form)", "name": "event_type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.notes.EventTypes.detail)}, "emptyText": "Ereignisart ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "event_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/Notes/event_type", "method": "GET" }) }) });
    var type316 = new Lino.TwinCombo({ "fieldLabel": "Notizart (Inhalt)", "name": "type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.notes.NoteTypes.detail)}, "emptyText": "Notizart ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/Notes/type", "method": "GET" }) }) });
    var main_1_panel317 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": event_type315, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type316, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 180, "border": false, "anchor": "-20", "labelAlign": "top" });
    var subject320 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Thema", "anchor": "-20", "name": "subject" });
    var project321 = new Lino.TwinCombo({ "fieldLabel": "Klient", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail)}, "emptyText": "Klient ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "projectHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/Notes/project", "method": "GET" }) }) });
    var company322 = new Lino.TwinCombo({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Organisation</span>", "name": "company", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Companies.detail)}, "emptyText": "Organisation ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Company","    An optional third-party Organization that is related to this Note.\n    The note will then be visible in that company's history panel.\n    ") }, "selectOnFocus": true, "hiddenName": "companyHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/Notes/company", "method": "GET" }) }) });
    var main_3_panel323 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": project321, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": company322, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 72, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel326 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 72, "autoScroll": false, "items": [ main_1_panel317, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": subject320, "anchor": "-20", "labelAlign": "top" }, main_3_panel323 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel326;
    this.before_row_edit = function(record) {
    }
    Lino.notes.Notes.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.households.Types.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 43,
  initComponent : function() {
    var containing_panel = this;
    var name328 = new Ext.form.TextField({ "fieldLabel": "Bezeichnung", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr329 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Bezeichnung (fr)", "anchor": "-20", "name": "name_fr" });
    var name_en330 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Bezeichnung (en)", "anchor": "-20", "name": "name_en" });
    var main_1_panel331 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name328, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr329, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_en330, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var main_panel541 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel331 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel541;
    this.before_row_edit = function(record) {
    }
    Lino.households.Types.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.accounts.Groups.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 46,
  initComponent : function() {
    var containing_panel = this;
    var ref542 = new Ext.form.TextField({ "fieldLabel": "ref", "name": "ref", "maxLength": 100, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name543 = new Ext.form.TextField({ "fieldLabel": "Bezeichnung", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr544 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Bezeichnung (fr)", "anchor": "-20", "name": "name_fr" });
    var name_en545 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Bezeichnung (en)", "anchor": "-20", "name": "name_en" });
    var main_1_panel546 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": ref542, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name543, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr544, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_en545, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var account_type551 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Kontenart", "name": "account_type", "selectOnFocus": true, "anchor": "-20", "store": Lino.accounts.AccountTypes, "hiddenName": "account_typeHidden" });
    var id552 = new Ext.form.NumberField({ "selectOnFocus": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var main_2_panel553 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 117, "hideCheckBoxLabels": true, "items": [ { "flex": 75, "autoHeight": true, "layout": "form", "xtype": "panel", "items": account_type551, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id552, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var help_text556 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 41, "containing_panel": this, "name": "help_text", "title": "Einleitung" });
    var AccountsByGroup_grid570 = new Lino.accounts.AccountsByGroup.GridPanel({ "flex": 41, "hide_top_toolbar": true, "containing_panel": this, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." }, "tools": [ Lino.show_in_own_window_button(Lino.accounts.AccountsByGroup.grid) ], "master_panel": this });
    var main_panel571 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "labelWidth": 0, "hideCheckBoxLabels": true, "items": [ main_1_panel546, main_2_panel553, help_text556, AccountsByGroup_grid570 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel571;
    this.before_row_edit = function(record) {
      help_text556.refresh();
      AccountsByGroup_grid570.on_master_changed();
    }
    Lino.accounts.Groups.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.courses.CourseOffers.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 94,
  initComponent : function() {
    var containing_panel = this;
    var id572 = new Ext.form.NumberField({ "selectOnFocus": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var title573 = new Ext.form.TextField({ "fieldLabel": "Name", "name": "title", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var content574 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Kursinhalt", "allowBlank": false, "pageSize": 20, "emptyText": "Kursinhalt ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "contentHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/courses/CourseOffers/content", "method": "GET" }) }), "name": "content" });
    var provider575 = new Lino.TwinCombo({ "fieldLabel": "Kursanbieter", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.courses.CourseProviders.detail)}, "emptyText": "Kursanbieter ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "providerHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/courses/CourseOffers/provider", "method": "GET" }) }), "name": "provider" });
    var main_1_panel576 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 11, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id572, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": title573, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": content574, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": provider575, "labelAlign": "top" } ], "region": "north", "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "split": true, "autoScroll": false, "labelWidth": 144, "border": false, "frame": false, "labelAlign": "top" });
    var description581 = new Lino.RichTextPanel({ "flex": 5, "split": true, "containing_panel": this, "selectOnFocus": true, "region": "center", "title": "Beschreibung", "name": "description" });
    var CoursesByOffer_grid639 = new Lino.courses.CoursesByOffer.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "south", "master_panel": this, "split": true, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." }, "tools": [ Lino.show_in_own_window_button(Lino.courses.CoursesByOffer.grid) ] });
    var main_panel640 = new Lino.VBorderPanel({ "autoScroll": false, "border": false, "labelWidth": 0, "hideCheckBoxLabels": true, "items": [ main_1_panel576, description581, CoursesByOffer_grid639 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel640;
    this.before_row_edit = function(record) {
      description581.refresh();
      CoursesByOffer_grid639.on_master_changed();
    }
    Lino.courses.CourseOffers.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.countries.Cities.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 11,
  initComponent : function() {
    var containing_panel = this;
    var name641 = new Ext.form.TextField({ "fieldLabel": "name", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var country642 = new Lino.TwinCombo({ "fieldLabel": "Land", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail)}, "emptyText": "Land ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "countryHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/countries/Cities/country", "method": "GET" }) }), "name": "country" });
    var inscode643 = new Ext.form.TextField({ "fieldLabel": "INS-Code", "name": "inscode", "maxLength": 5, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(5), "anchor": "-20" });
    var main_1_panel644 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 81, "hideCheckBoxLabels": true, "items": [ { "flex": 44, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name641, "labelAlign": "top" }, { "flex": 42, "autoHeight": true, "layout": "form", "xtype": "panel", "items": country642, "labelAlign": "top" }, { "flex": 12, "autoHeight": true, "layout": "form", "xtype": "panel", "items": inscode643, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var parent648 = new Lino.TwinCombo({ "fieldLabel": "Teil von", "name": "parent", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Cities.detail)}, "emptyText": "Ort ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "parentHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/countries/Cities/parent", "method": "GET" }) }) });
    var type649 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Ortsart", "name": "type", "selectOnFocus": true, "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/countries/Cities/type", "method": "GET" }) }), "hiddenName": "typeHidden" });
    var id650 = new Ext.form.NumberField({ "selectOnFocus": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var main_2_panel651 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 99, "hideCheckBoxLabels": true, "items": [ { "flex": 57, "autoHeight": true, "layout": "form", "xtype": "panel", "items": parent648, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type649, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id650, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var CitiesByCity_grid814 = new Lino.countries.CitiesByCity.GridPanel({ "flex": 41, "hide_top_toolbar": true, "containing_panel": this, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." }, "tools": [ Lino.show_in_own_window_button(Lino.countries.CitiesByCity.grid) ], "master_panel": this });
    var main_panel818 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel644, main_2_panel651, CitiesByCity_grid814 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel818;
    this.before_row_edit = function(record) {
      type649.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      CitiesByCity_grid814.on_master_changed();
    }
    this.onRender = function(ct, position) {
      country642.on('change',Lino.chooser_handler(type649,'country'));
      Lino.countries.Cities.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.countries.Cities.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.about.Models.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  disable_editing: true,
  initComponent : function() {
    var containing_panel = this;
    var app_disp819 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "app_label", "name": "app", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var name_disp820 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Name", "name": "name", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var docstring_disp821 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "docstring", "name": "docstring", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var rows_disp822 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Zeilen", "name": "rows", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var main_1_panel823 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 90, "hideCheckBoxLabels": true, "items": [ { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": app_disp819, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_disp820, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": docstring_disp821, "labelAlign": "top" }, { "flex": 8, "autoHeight": true, "layout": "form", "xtype": "panel", "items": rows_disp822, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var about_FieldsByModel_grid832 = new Lino.about.FieldsByModel.GridPanel({ "flex": 62, "hide_top_toolbar": true, "containing_panel": this, "viewConfig": { "emptyText": "No data to display." }, "tools": [ Lino.show_in_own_window_button(Lino.about.FieldsByModel.grid) ], "master_panel": this });
    var main_panel833 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel823, about_FieldsByModel_grid832 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel833;
    this.before_row_edit = function(record) {
      about_FieldsByModel_grid832.on_master_changed();
    }
    Lino.about.Models.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.users.MySettings.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 8,
  initComponent : function() {
    var containing_panel = this;
    var username834 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Username","\n        Required. Must be unique. \n        ") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Benutzername</span>", "name": "username", "maxLength": 30, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var email835 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75, "fieldLabel": "e-mail address", "anchor": "-20", "name": "email" });
    var main_1_panel836 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": username834, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": email835, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 135, "border": false, "anchor": "-20", "labelAlign": "top" });
    var first_name839 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 30, "fieldLabel": "Vorname", "anchor": "-20", "name": "first_name" });
    var last_name840 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 30, "fieldLabel": "Familienname", "anchor": "-20", "name": "last_name" });
    var main_2_panel841 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": first_name839, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": last_name840, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 99, "border": false, "anchor": "-20", "labelAlign": "top" });
    var partner844 = new Lino.TwinCombo({ "fieldLabel": "Partner", "name": "partner", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Partners.detail)}, "emptyText": "Partner ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "partnerHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/Users/partner", "method": "GET" }) }) });
    var language845 = new Lino.ChoicesFieldElement({ "fieldLabel": "Sprache", "allowBlank": false, "selectOnFocus": true, "hiddenName": "languageHidden", "anchor": "-20", "store": [ [ "de", "Deutsch" ], [ "fr", "Franz\u00f6sisch" ], [ "en", "Englisch" ] ], "name": "language" });
    var profile846 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Benutzerprofil", "name": "profile", "selectOnFocus": true, "anchor": "-20", "store": Lino.lino.UserProfiles, "hiddenName": "profileHidden" });
    var main_4_panel847 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language845, "labelAlign": "top" }, { "flex": 68, "autoHeight": true, "layout": "form", "xtype": "panel", "items": profile846, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel850 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 72, "autoScroll": false, "items": [ main_1_panel836, main_2_panel841, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": partner844, "anchor": "-20", "labelAlign": "top" }, main_4_panel847 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel850;
    this.before_row_edit = function(record) {
    }
    Lino.users.MySettings.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.households.Roles.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 42,
  initComponent : function() {
    var containing_panel = this;
    var name852 = new Ext.form.TextField({ "fieldLabel": "Bezeichnung", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr853 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Bezeichnung (fr)", "anchor": "-20", "name": "name_fr" });
    var name_en854 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Bezeichnung (en)", "anchor": "-20", "name": "name_en" });
    var name_giving855 = new Ext.form.Checkbox({ "boxLabel": "namensgebend", "listeners": { "render": Lino.quicktip_renderer("name-giving","When the `name` field of a Household is empty, \nits value is computed by joining the `Last Name` \nof all name-giving members with a dash (\"-\").\n      ") }, "hideLabel": true, "checked": false, "name": "name_giving", "selectOnFocus": true, "anchor": "-20" });
    var main_1_panel856 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name852, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr853, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_en854, "labelAlign": "top" }, { "flex": 13, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_giving855, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var MembersByRole_grid867 = new Lino.households.MembersByRole.GridPanel({ "flex": 83, "hide_top_toolbar": true, "containing_panel": this, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." }, "tools": [ Lino.show_in_own_window_button(Lino.households.MembersByRole.grid) ], "master_panel": this });
    var main_panel868 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel856, MembersByRole_grid867 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel868;
    this.before_row_edit = function(record) {
      MembersByRole_grid867.on_master_changed();
    }
    Lino.households.Roles.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.notes.EventTypes.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 89,
  initComponent : function() {
    var containing_panel = this;
    var id869 = new Ext.form.NumberField({ "selectOnFocus": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var name870 = new Ext.form.TextField({ "fieldLabel": "Bezeichnung", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr871 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Bezeichnung (fr)", "anchor": "-20", "name": "name_fr" });
    var name_en872 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Bezeichnung (en)", "anchor": "-20", "name": "name_en" });
    var main_1_panel873 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 7, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id869, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name870, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr871, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_en872, "labelAlign": "top" } ], "region": "north", "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "split": true, "autoScroll": false, "labelWidth": 153, "border": false, "frame": false, "labelAlign": "top" });
    var remark878 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Bemerkungen", "anchor": "-20 -10", "growMax": 2000, "name": "remark" });
    var notes_NotesByEventType_grid974 = new Lino.notes.NotesByEventType.GridPanel({ "flex": 6, "hide_top_toolbar": true, "containing_panel": this, "region": "south", "master_panel": this, "split": true, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." }, "tools": [ Lino.show_in_own_window_button(Lino.notes.NotesByEventType.grid) ] });
    var main_panel975 = new Lino.VBorderPanel({ "autoScroll": false, "border": false, "labelWidth": 63, "hideCheckBoxLabels": true, "items": [ main_1_panel873, { "flex": 3, "layout": "form", "xtype": "panel", "items": remark878, "region": "center", "labelAlign": "top", "split": true }, notes_NotesByEventType_grid974 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel975;
    this.before_row_edit = function(record) {
      notes_NotesByEventType_grid974.on_master_changed();
    }
    Lino.notes.EventTypes.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.accounts.Charts.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 45,
  initComponent : function() {
    var containing_panel = this;
    var id977 = new Ext.form.NumberField({ "selectOnFocus": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var name978 = new Ext.form.TextField({ "fieldLabel": "Bezeichnung", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr979 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Bezeichnung (fr)", "anchor": "-20", "name": "name_fr" });
    var name_en980 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Bezeichnung (en)", "anchor": "-20", "name": "name_en" });
    var main_1_panel981 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 7, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id977, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name978, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr979, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_en980, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var GroupsByChart_grid994 = new Lino.accounts.GroupsByChart.GridPanel({ "flex": 83, "hide_top_toolbar": true, "containing_panel": this, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." }, "tools": [ Lino.show_in_own_window_button(Lino.accounts.GroupsByChart.grid) ], "master_panel": this });
    var main_panel995 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel981, GroupsByChart_grid994 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel995;
    this.before_row_edit = function(record) {
      GroupsByChart_grid994.on_master_changed();
    }
    Lino.accounts.Charts.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.uploads.Uploads.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 25,
  initComponent : function() {
    var containing_panel = this;
    var file996 = Lino.file_field_handler(this,{ "fieldLabel": "Datei", "name": "file", "maxLength": 100, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var user997 = new Lino.TwinCombo({ "fieldLabel": "Autor", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "emptyText": "Benutzer ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "userHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/Uploads/user", "method": "GET" }) }) });
    var main_1_panel998 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 58, "autoHeight": true, "layout": "form", "xtype": "panel", "items": file996, "labelAlign": "top" }, { "flex": 41, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user997, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 63, "border": false, "anchor": "-20", "labelAlign": "top" });
    var type1001 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Upload-Art", "name": "type", "pageSize": 20, "emptyText": "Upload-Art ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/Uploads/type", "method": "GET" }) }) });
    var valid_until1002 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "g\u00fcltig bis", "anchor": "-20", "name": "valid_until" });
    var main_2_panel1003 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 71, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type1001, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": valid_until1002, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 108, "border": false, "anchor": "-20", "labelAlign": "top" });
    var description1006 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Beschreibung", "anchor": "-20", "name": "description" });
    var main_panel1007 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 108, "autoScroll": false, "items": [ main_1_panel998, main_2_panel1003, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": description1006, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1007;
    this.before_row_edit = function(record) {
    }
    Lino.uploads.Uploads.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.notes.Notes.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 90,
  initComponent : function() {
    var containing_panel = this;
    var date893 = new Lino.DateField({ "selectOnFocus": true, "allowBlank": false, "fieldLabel": "Datum", "anchor": "-20", "name": "date" });
    var event_type894 = new Lino.TwinCombo({ "fieldLabel": "Ereignisart (Form)", "name": "event_type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.notes.EventTypes.detail)}, "emptyText": "Ereignisart ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "event_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/Notes/event_type", "method": "GET" }) }) });
    var type895 = new Lino.TwinCombo({ "fieldLabel": "Notizart (Inhalt)", "name": "type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.notes.NoteTypes.detail)}, "emptyText": "Notizart ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/Notes/type", "method": "GET" }) }) });
    var left_1_panel896 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 180, "hideCheckBoxLabels": true, "items": [ { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": date893, "labelAlign": "top" }, { "flex": 41, "autoHeight": true, "layout": "form", "xtype": "panel", "items": event_type894, "labelAlign": "top" }, { "flex": 41, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type895, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var subject900 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Thema", "anchor": "-20", "name": "subject" });
    var project901 = new Lino.TwinCombo({ "fieldLabel": "Klient", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail)}, "emptyText": "Klient ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "projectHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/Notes/project", "method": "GET" }) }) });
    var company902 = new Lino.TwinCombo({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Organisation</span>", "name": "company", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Companies.detail)}, "emptyText": "Organisation ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Company","    An optional third-party Organization that is related to this Note.\n    The note will then be visible in that company's history panel.\n    ") }, "selectOnFocus": true, "hiddenName": "companyHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/Notes/company", "method": "GET" }) }) });
    var left_3_panel903 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 72, "hideCheckBoxLabels": true, "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": project901, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": company902, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var id906 = new Ext.form.NumberField({ "selectOnFocus": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var user907 = new Lino.TwinCombo({ "fieldLabel": "Autor", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "emptyText": "Benutzer ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "userHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/Notes/user", "method": "GET" }) }) });
    var language908 = new Lino.ChoicesFieldElement({ "fieldLabel": "Sprache", "allowBlank": false, "selectOnFocus": true, "hiddenName": "languageHidden", "anchor": "-20", "store": [ [ "de", "Deutsch" ], [ "fr", "Franz\u00f6sisch" ], [ "en", "Englisch" ] ], "name": "language" });
    var build_time909 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Druckdatum", "anchor": "-20", "value": "<br>", "name": "build_time" });
    var left_4_panel910 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 99, "hideCheckBoxLabels": true, "items": [ { "flex": 12, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id906, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user907, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language908, "labelAlign": "top" }, { "flex": 41, "autoHeight": true, "layout": "form", "xtype": "panel", "items": build_time909, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var body915 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 55, "containing_panel": this, "name": "body", "title": "Inhalt" });
    var left_panel916 = new Ext.Panel({ "flex": 66, "layout": "vbox", "items": [ left_1_panel896, { "items": subject900, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" }, left_3_panel903, left_4_panel910, body915 ], "frame": true, "layoutConfig": { "align": "stretch" }, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 72, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var UploadsByController_htmlbox918 = new Lino.HtmlBoxPanel({ "flex": 25, "ls_bbar_actions": [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true } ], "name": "UploadsByController", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "title": "Uploads", "master_panel": this, "value": "<br/>", "always_enabled": true, "bodyStyle": "overflow-x:hidden !important;", "ls_insert_handler": Lino.uploads.UploadsByController.insert, "layout": "fit", "tools": [ Lino.show_in_own_window_button(Lino.uploads.UploadsByController.grid) ] });
    var outbox_MailsByController_grid958 = new Lino.outbox.MailsByController.GridPanel({ "flex": 25, "hide_top_toolbar": true, "containing_panel": this, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." }, "tools": [ Lino.show_in_own_window_button(Lino.outbox.MailsByController.grid) ], "master_panel": this });
    var postings_PostingsByController_grid969 = new Lino.postings.PostingsByController.GridPanel({ "flex": 25, "hide_top_toolbar": true, "containing_panel": this, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." }, "tools": [ Lino.show_in_own_window_button(Lino.postings.PostingsByController.grid) ], "master_panel": this });
    var right_panel971 = new Ext.Panel({ "flex": 33, "layout": "vbox", "items": [ UploadsByController_htmlbox918, outbox_MailsByController_grid958, postings_PostingsByController_grid969 ], "frame": true, "layoutConfig": { "align": "stretch" }, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 72, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var main_1_panel972 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ left_panel916, right_panel971 ], "frame": false, "layoutConfig": { "align": "stretch" }, "labelAlign": "top" });
    var main_panel973 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "fit", "hideCheckBoxLabels": true, "items": [ main_1_panel972 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel973;
    this.before_row_edit = function(record) {
      body915.refresh();
      UploadsByController_htmlbox918.refresh();
      outbox_MailsByController_grid958.on_master_changed();
      postings_PostingsByController_grid969.on_master_changed();
    }
    Lino.notes.Notes.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.notes.NoteTypes.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 91,
  initComponent : function() {
    var containing_panel = this;
    var id1009 = new Ext.form.NumberField({ "selectOnFocus": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var name1010 = new Ext.form.TextField({ "fieldLabel": "Bezeichnung", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr1011 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Bezeichnung (fr)", "anchor": "-20", "name": "name_fr" });
    var name_en1012 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Bezeichnung (en)", "anchor": "-20", "name": "name_en" });
    var main_1_panel1013 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 7, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1009, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1010, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr1011, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_en1012, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var build_method1018 = new Lino.ChoicesFieldElement({ "fieldLabel": "Konstruktionsmethode", "name": "build_method", "selectOnFocus": true, "anchor": "-20", "store": [ [ "appyodt", "AppyOdtBuildMethod" ], [ "appypdf", "AppyPdfBuildMethod" ], [ "appyrtf", "AppyRtfBuildMethod" ], [ "latex", "LatexBuildMethod" ], [ "pisa", "PisaBuildMethod" ], [ "rtf", "RtfBuildMethod" ] ], "hiddenName": "build_methodHidden" });
    var template1019 = new Lino.SimpleRemoteComboFieldElement({ "selectOnFocus": true, "fieldLabel": "Vorlage", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/NoteTypes/template", "method": "GET" }) }), "name": "template" });
    var email_template1020 = new Lino.SimpleRemoteComboFieldElement({ "listeners": { "render": Lino.quicktip_renderer("Email template","The name of the file to be used as template \nwhen creating an email from a mailable of this type.\n") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">E-Mail-Vorlage</span>", "name": "email_template", "selectOnFocus": true, "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/NoteTypes/email_template", "method": "GET" }) }) });
    var attach_to_email1021 = new Ext.form.Checkbox({ "boxLabel": "als Anhang per E-Mail", "listeners": { "render": Lino.quicktip_renderer("Attach to email","Whether the printable file should be attached to the email\nwhen creating an email from a mailable of this type.\n") }, "hideLabel": true, "checked": false, "name": "attach_to_email", "selectOnFocus": true, "anchor": "-20" });
    var main_2_panel1022 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 144, "hideCheckBoxLabels": true, "items": [ { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": build_method1018, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": template1019, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": email_template1020, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": attach_to_email1021, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var remark1027 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Bemerkungen", "anchor": "-20 -10", "growMax": 2000, "name": "remark" });
    var notes_NotesByType_grid1042 = new Lino.notes.NotesByType.GridPanel({ "flex": 41, "hide_top_toolbar": true, "containing_panel": this, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." }, "tools": [ Lino.show_in_own_window_button(Lino.notes.NotesByType.grid) ], "master_panel": this });
    var main_panel1043 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "labelWidth": 63, "hideCheckBoxLabels": true, "items": [ main_1_panel1013, main_2_panel1022, { "items": remark1027, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 41 }, notes_NotesByType_grid1042 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1043;
    this.before_row_edit = function(record) {
      template1019.setContextValue('build_method',record ? record.data['build_methodHidden'] : undefined);
      notes_NotesByType_grid1042.on_master_changed();
    }
    this.onRender = function(ct, position) {
      build_method1018.on('change',Lino.chooser_handler(template1019,'build_method'));
      Lino.notes.NoteTypes.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.notes.NoteTypes.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.properties.PropTypes.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 16,
  initComponent : function() {
    var containing_panel = this;
    var id1045 = new Ext.form.NumberField({ "selectOnFocus": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var name1046 = new Ext.form.TextField({ "fieldLabel": "Bezeichnung", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr1047 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Bezeichnung (fr)", "anchor": "-20", "name": "name_fr" });
    var name_en1048 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Bezeichnung (en)", "anchor": "-20", "name": "name_en" });
    var choicelist1049 = new Lino.ChoicesFieldElement({ "fieldLabel": "Auswahliste", "name": "choicelist", "selectOnFocus": true, "anchor": "-20", "store": [ [ "countries.CityTypes", "Ortsart" ], [ "lino.ChangeTypes", "\u00c4nderungsart" ], [ "lino.UserGroups", "Benutzergruppe" ], [ "lino.UserLevels", "Benutzer-Level" ], [ "lino.UserProfiles", "Benutzerprofil" ], [ "properties.DoYouLike", "blo\u00df nicht ... sehr gerne" ], [ "properties.HowWell", "gar nicht ... sehr gut" ] ], "hiddenName": "choicelistHidden" });
    var default_value1050 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Standardwert", "name": "default_value", "selectOnFocus": true, "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/properties/PropTypes/default_value", "method": "GET" }) }), "hiddenName": "default_valueHidden" });
    var main_1_panel1051 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1045, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1046, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr1047, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_en1048, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": choicelist1049, "labelAlign": "top" }, { "flex": 10, "autoHeight": true, "layout": "form", "xtype": "panel", "items": default_value1050, "labelAlign": "top" } ], "region": "north", "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "split": true, "autoScroll": false, "labelWidth": 153, "border": false, "frame": false, "labelAlign": "top" });
    var ChoicesByType_grid1064 = new Lino.properties.ChoicesByType.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "center", "master_panel": this, "split": true, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." }, "tools": [ Lino.show_in_own_window_button(Lino.properties.ChoicesByType.grid) ] });
    var PropsByType_grid1071 = new Lino.properties.PropsByType.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "south", "master_panel": this, "split": true, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." }, "tools": [ Lino.show_in_own_window_button(Lino.properties.PropsByType.grid) ] });
    var main_panel1072 = new Lino.VBorderPanel({ "autoScroll": false, "border": false, "hideCheckBoxLabels": true, "items": [ main_1_panel1051, ChoicesByType_grid1064, PropsByType_grid1071 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1072;
    this.before_row_edit = function(record) {
      default_value1050.setContextValue('choicelist',record ? record.data['choicelistHidden'] : undefined);
      ChoicesByType_grid1064.on_master_changed();
      PropsByType_grid1071.on_master_changed();
    }
    this.onRender = function(ct, position) {
      choicelist1049.on('change',Lino.chooser_handler(default_value1050,'choicelist'));
      Lino.properties.PropTypes.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.properties.PropTypes.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.outbox.MailsByUser.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 28,
  initComponent : function() {
    var containing_panel = this;
    var subject930 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Thema", "anchor": "-20", "name": "subject" });
    var project931 = new Lino.TwinCombo({ "fieldLabel": "Klient", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail)}, "emptyText": "Klient ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "projectHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/Mails/project", "method": "GET" }) }) });
    var date932 = new Lino.DateField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Date","\n        The official date to be printed on the document.\n        ") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Datum</span>", "anchor": "-20", "name": "date" });
    var main_1_panel933 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 72, "hideCheckBoxLabels": true, "items": [ { "flex": 42, "autoHeight": true, "layout": "form", "xtype": "panel", "items": subject930, "labelAlign": "top" }, { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": project931, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": date932, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var user937 = new Lino.TwinCombo({ "fieldLabel": "Sender", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "emptyText": "Benutzer ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "userHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/Mails/user", "method": "GET" }) }) });
    var sent938 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "sent", "anchor": "-20", "value": "<br>", "name": "sent" });
    var id939 = new Ext.form.NumberField({ "selectOnFocus": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var owner_disp940 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Verkn\u00fcpft mit", "anchor": "-20", "name": "owner" });
    var main_2_panel941 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 126, "hideCheckBoxLabels": true, "items": [ { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user937, "labelAlign": "top" }, { "flex": 24, "autoHeight": true, "layout": "form", "xtype": "panel", "items": sent938, "labelAlign": "top" }, { "flex": 7, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id939, "labelAlign": "top" }, { "flex": 45, "autoHeight": true, "layout": "form", "xtype": "panel", "items": owner_disp940, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var RecipientsByMail_grid952 = new Lino.outbox.RecipientsByMail.GridPanel({ "flex": 55, "hide_top_toolbar": true, "containing_panel": this, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." }, "tools": [ Lino.show_in_own_window_button(Lino.outbox.RecipientsByMail.grid) ], "master_panel": this });
    var AttachmentsByMail_htmlbox953 = new Lino.HtmlBoxPanel({ "flex": 22, "layout": "fit", "name": "AttachmentsByMail", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "title": "Anh\u00e4nge", "master_panel": this, "value": "<br/>", "always_enabled": true, "bodyStyle": "overflow-x:hidden !important;", "tools": [ Lino.show_in_own_window_button(Lino.outbox.AttachmentsByMail.grid) ] });
    var UploadsByController_htmlbox954 = new Lino.HtmlBoxPanel({ "flex": 22, "ls_bbar_actions": [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true } ], "name": "UploadsByController", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "title": "Uploads", "master_panel": this, "value": "<br/>", "always_enabled": true, "bodyStyle": "overflow-x:hidden !important;", "ls_insert_handler": Lino.uploads.UploadsByController.insert, "layout": "fit", "tools": [ Lino.show_in_own_window_button(Lino.uploads.UploadsByController.grid) ] });
    var main_3_panel955 = new Ext.Panel({ "flex": 26, "border": false, "layout": "hbox", "labelWidth": 108, "hideCheckBoxLabels": true, "items": [ RecipientsByMail_grid952, AttachmentsByMail_htmlbox953, UploadsByController_htmlbox954 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var body956 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 52, "containing_panel": this, "name": "body", "title": "Inhalt" });
    var main_panel957 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "labelWidth": 0, "hideCheckBoxLabels": true, "items": [ main_1_panel933, main_2_panel941, main_3_panel955, body956 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel957;
    this.before_row_edit = function(record) {
      RecipientsByMail_grid952.on_master_changed();
      AttachmentsByMail_htmlbox953.refresh();
      UploadsByController_htmlbox954.refresh();
      body956.refresh();
    }
    Lino.outbox.MailsByUser.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.properties.Properties.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 13,
  initComponent : function() {
    var containing_panel = this;
    var id118 = new Ext.form.NumberField({ "selectOnFocus": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var group119 = new Lino.TwinCombo({ "fieldLabel": "Eigenschaftsgruppe", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.properties.PropGroups.detail)}, "emptyText": "Eigenschaftsgruppe ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "groupHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/properties/Properties/group", "method": "GET" }) }), "name": "group" });
    var type120 = new Lino.TwinCombo({ "fieldLabel": "Eigenschafts-Datentyp", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.properties.PropTypes.detail)}, "emptyText": "Eigenschafts-Datentyp ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/properties/Properties/type", "method": "GET" }) }), "name": "type" });
    var main_1_panel121 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 135, "hideCheckBoxLabels": true, "items": [ { "flex": 11, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id118, "labelAlign": "top" }, { "flex": 44, "autoHeight": true, "layout": "form", "xtype": "panel", "items": group119, "labelAlign": "top" }, { "flex": 44, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type120, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var name125 = new Ext.form.TextField({ "fieldLabel": "Bezeichnung", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr126 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Bezeichnung (fr)", "anchor": "-20", "name": "name_fr" });
    var name_en127 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Bezeichnung (en)", "anchor": "-20", "name": "name_en" });
    var main_2_panel128 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name125, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr126, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_en127, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var main_panel139 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel121, main_2_panel128 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel139;
    this.before_row_edit = function(record) {
    }
    Lino.properties.Properties.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.lino.Home.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  disable_editing: true,
  initComponent : function() {
    var containing_panel = this;
    var quick_links_htmlbox1073 = new Lino.HtmlBoxPanel({ "flex": 3, "layout": "fit", "name": "quick_links", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "master_panel": this, "value": "<br/>", "always_enabled": true, "bodyStyle": "overflow-x:hidden !important;" });
    var welcome_htmlbox1074 = new Lino.HtmlBoxPanel({ "flex": 16, "layout": "fit", "name": "welcome", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "title": "Willkommen", "master_panel": this, "value": "<br/>", "always_enabled": true, "bodyStyle": "overflow-x:hidden !important;" });
    var coming_reminders_htmlbox1076 = new Lino.HtmlBoxPanel({ "flex": 50, "layout": "fit", "name": "coming_reminders", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "title": "Ausblick", "master_panel": this, "value": "<br/>", "always_enabled": true, "bodyStyle": "overflow-x:hidden !important;" });
    var missed_reminders_htmlbox1077 = new Lino.HtmlBoxPanel({ "flex": 50, "layout": "fit", "name": "missed_reminders", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "title": "Verpasste Erinnerungen", "master_panel": this, "value": "<br/>", "always_enabled": true, "bodyStyle": "overflow-x:hidden !important;" });
    var main_4_panel1078 = new Ext.Panel({ "flex": 53, "border": false, "layout": "hbox", "labelWidth": 171, "hideCheckBoxLabels": true, "items": [ coming_reminders_htmlbox1076, missed_reminders_htmlbox1077 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var main_panel1079 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "labelWidth": 225, "hideCheckBoxLabels": true, "items": [ quick_links_htmlbox1073, welcome_htmlbox1074, main_4_panel1078 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1079;
    this.before_row_edit = function(record) {
      quick_links_htmlbox1073.refresh();
      welcome_htmlbox1074.refresh();
      coming_reminders_htmlbox1076.refresh();
      missed_reminders_htmlbox1077.refresh();
    }
    Lino.lino.Home.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.lino.Changes.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 3,
  disable_editing: true,
  initComponent : function() {
    var containing_panel = this;
    var time777 = new Ext.form.DisplayField({ "fieldLabel": "time", "name": "time", "selectOnFocus": true, "anchor": "-20", "value": "<br>", "allowBlank": false });
    var user778 = new Lino.TwinCombo({ "fieldLabel": "Benutzer", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "emptyText": "Benutzer ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "userHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/lino/Changes/user", "method": "GET" }) }), "name": "user" });
    var type779 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "\u00c4nderungsart", "allowBlank": false, "hiddenName": "typeHidden", "selectOnFocus": true, "anchor": "-20", "store": Lino.lino.ChangeTypes, "name": "type" });
    var master_disp780 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Stammdaten", "anchor": "-20", "name": "master" });
    var object_disp781 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Object", "anchor": "-20", "name": "object" });
    var id782 = new Ext.form.NumberField({ "selectOnFocus": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var main_1_panel783 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 108, "hideCheckBoxLabels": true, "items": [ { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": time777, "labelAlign": "top" }, { "flex": 13, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user778, "labelAlign": "top" }, { "flex": 12, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type779, "labelAlign": "top" }, { "flex": 27, "autoHeight": true, "layout": "form", "xtype": "panel", "items": master_disp780, "labelAlign": "top" }, { "flex": 27, "autoHeight": true, "layout": "form", "xtype": "panel", "items": object_disp781, "labelAlign": "top" }, { "flex": 4, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id782, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var diff790 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "\u00c4nderungen", "anchor": "-20 -10", "growMax": 2000, "name": "diff" });
    var main_panel791 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "labelWidth": 72, "hideCheckBoxLabels": true, "items": [ main_1_panel783, { "items": diff790, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 62 } ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel791;
    this.before_row_edit = function(record) {
    }
    Lino.lino.Changes.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.countries.Countries.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 9,
  initComponent : function() {
    var containing_panel = this;
    var isocode1080 = new Ext.form.TextField({ "fieldLabel": "isocode", "name": "isocode", "maxLength": 4, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(4), "anchor": "-20", "allowBlank": false });
    var name1081 = new Ext.form.TextField({ "fieldLabel": "Bezeichnung", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr1082 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Bezeichnung (fr)", "anchor": "-20", "name": "name_fr" });
    var name_en1083 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Bezeichnung (en)", "anchor": "-20", "name": "name_en" });
    var short_code1084 = new Ext.form.TextField({ "fieldLabel": "short code", "name": "short_code", "maxLength": 4, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(4), "anchor": "-20" });
    var inscode1085 = new Ext.form.TextField({ "fieldLabel": "INS-Code", "name": "inscode", "maxLength": 3, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(3), "anchor": "-20" });
    var main_1_panel1086 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 6, "autoHeight": true, "layout": "form", "xtype": "panel", "items": isocode1080, "labelAlign": "top" }, { "flex": 27, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1081, "labelAlign": "top" }, { "flex": 27, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr1082, "labelAlign": "top" }, { "flex": 27, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_en1083, "labelAlign": "top" }, { "flex": 6, "autoHeight": true, "layout": "form", "xtype": "panel", "items": short_code1084, "labelAlign": "top" }, { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": inscode1085, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var countries_CitiesByCountry_grid1100 = new Lino.countries.CitiesByCountry.GridPanel({ "flex": 37, "hide_top_toolbar": true, "containing_panel": this, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." }, "tools": [ Lino.show_in_own_window_button(Lino.countries.CitiesByCountry.grid) ], "master_panel": this });
    var main_2_panel1114 = new Ext.Panel({ "flex": 83, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ countries_CitiesByCountry_grid1100 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var main_panel1115 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel1086, main_2_panel1114 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1115;
    this.before_row_edit = function(record) {
      countries_CitiesByCountry_grid1100.on_master_changed();
    }
    Lino.countries.Countries.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.courses.Courses.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 92,
  initComponent : function() {
    var containing_panel = this;
    var id587 = new Ext.form.NumberField({ "selectOnFocus": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var start_date588 = new Lino.DateField({ "selectOnFocus": true, "allowBlank": false, "fieldLabel": "beginnt am", "anchor": "-20", "name": "start_date" });
    var offer589 = new Lino.TwinCombo({ "fieldLabel": "Kursangebot", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.courses.CourseOffers.detail)}, "emptyText": "Kursangebot ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "offerHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/courses/Courses/offer", "method": "GET" }) }), "name": "offer" });
    var title590 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Name", "anchor": "-20", "name": "title" });
    var main_1_panel591 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 117, "hideCheckBoxLabels": true, "items": [ { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id587, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date588, "labelAlign": "top" }, { "flex": 35, "autoHeight": true, "layout": "form", "xtype": "panel", "items": offer589, "labelAlign": "top" }, { "flex": 36, "autoHeight": true, "layout": "form", "xtype": "panel", "items": title590, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var remark596 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Bemerkungen", "anchor": "-20", "name": "remark" });
    var main_panel637 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "labelWidth": 63, "hideCheckBoxLabels": true, "items": [ main_1_panel591, { "items": remark596, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" } ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel637;
    this.before_row_edit = function(record) {
    }
    Lino.courses.Courses.DetailFormPanel.superclass.initComponent.call(this);
  }
});


// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUIlino.ContentTypesHandle
Lino.lino.ContentTypes.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/lino/ContentTypes",
  ls_bbar_actions : [ { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true } ],
  title : "Inhaltstypen",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "name" }, { "name": "app_label" }, { "name": "model" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 1,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 5,
  initComponent : function() {
    this.ls_detail_handler = Lino.lino.ContentTypes.detail;
    this.ls_insert_handler = Lino.lino.ContentTypes.insert;
    var ww = this.containing_window;
    var id1116 = new Ext.form.NumberField({ "selectOnFocus": true });
    var name1117 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 100 });
    var app_label1118 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 100 });
    var model1119 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 100 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "renderer": Lino.id_renderer, "hidden": false, "editor": id1116, "dataIndex": "id" }, { "colIndex": 1, "sortable": true, "header": "name", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name", "hidden": false, "editor": name1117 }, { "colIndex": 2, "sortable": true, "header": "app label", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "app_label", "hidden": false, "editor": app_label1118 }, { "colIndex": 3, "sortable": true, "header": "Python Modell-Klassenname", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "model", "hidden": false, "editor": model1119 } ];
    Lino.lino.ContentTypes.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.lino.ContentTypes.insertPanel = Ext.extend(Lino.lino.ContentTypes.DetailFormPanel,{
  empty_title: "Neu Inhaltstypen",
  hide_navigator: true,
  ls_bbar_actions: [  ],
  ls_url: "/lino/ContentTypes",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.lino.ContentTypes.detail;
    this.ls_insert_handler = Lino.lino.ContentTypes.insert;
    Lino.lino.ContentTypes.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.lino.ContentTypes.insert = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.lino.ContentTypes.insertPanel(p);
});

Lino.lino.ContentTypes.detailPanel = Ext.extend(Lino.lino.ContentTypes.DetailFormPanel,{
  empty_title: "Detail Inhaltstypen",
  ls_bbar_actions: [  ],
  ls_url: "/lino/ContentTypes",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.lino.ContentTypes.detail;
    this.ls_insert_handler = Lino.lino.ContentTypes.insert;
    Lino.lino.ContentTypes.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.lino.ContentTypes.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.lino.ContentTypes.detailPanel(p);
});
Lino.lino.ContentTypes.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.lino.ContentTypes.GridPanel(p);
});

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUIlino.HelpTextsHandle
Lino.lino.HelpTexts.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/lino/HelpTexts",
  ls_bbar_actions : [  ],
  title : "Hilfetexte",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "field" }, { "name": "verbose_name" }, { "name": "help_text" }, { "type": "int", "name": "id" }, { "name": "content_type" },'content_typeHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 3,
  ls_grid_configs : [  ],
  content_type : 4,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 7,
  initComponent : function() {
    var ww = this.containing_window;
    var field1121 = new Lino.SimpleRemoteComboFieldElement({ "selectOnFocus": true, "allowBlank": false, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/lino/HelpTexts/field", "method": "GET" }) }) });
    var verbose_name1122 = new Ext.form.TextField({ "disabled": true, "maxLength": 200 });
    var help_text1123 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var id1124 = new Ext.form.NumberField({ "selectOnFocus": true });
    var content_type1125 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/lino/HelpTexts/content_type", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Inhaltstyp ausw\u00e4hlen..." });
    this.before_row_edit = function(record) {
      field1121.setContextValue('content_type',record ? record.data['content_typeHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      content_type1125.on('change',Lino.chooser_handler(field1121,'content_type'));
      Lino.lino.HelpTexts.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Feld", "editable": true, "tooltip": "The name of the field.", "filter": { "type": "string" }, "width": Lino.chars2width(10), "dataIndex": "field", "hidden": false, "editor": field1121 }, { "colIndex": 1, "sortable": false, "header": "Feldbezeichnung", "editable": false, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "verbose_name", "hidden": false }, { "colIndex": 2, "sortable": false, "header": "Hilfetext", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(60), "renderer": Lino.text_renderer, "hidden": false, "editor": help_text1123, "dataIndex": "help_text" }, { "colIndex": 3, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "renderer": Lino.id_renderer, "hidden": false, "editor": id1124, "dataIndex": "id" }, { "colIndex": 4, "sortable": true, "header": "Modell", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('content_typeHidden','Lino.lino.ContentTypes.detail'), "hidden": false, "editor": content_type1125, "dataIndex": "content_type" } ];
    Lino.lino.HelpTexts.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.lino.HelpTexts.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.lino.HelpTexts.GridPanel(p);
});

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUIlino.ChangesHandle
Lino.lino.Changes.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/lino/Changes",
  ls_bbar_actions : [ { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true } ],
  title : "\u00c4nderungen",
  page_length : 20,
  stripeRows : true,
  disable_editing : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "time" }, { "name": "type" },'typeHidden', { "name": "user" },'userHidden', { "name": "object_type" },'object_typeHidden', { "name": "object_id" },'object_idHidden', { "name": "master_type" },'master_typeHidden', { "name": "master_id" },'master_idHidden', { "name": "diff" }, { "name": "object" }, { "name": "master" }, { "name": "disabled_fields" }, { "name": "disabled_actions" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 3,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 18,
  initComponent : function() {
    this.ls_detail_handler = Lino.lino.Changes.detail;
    var ww = this.containing_window;
    var id1127 = new Ext.form.NumberField({ "selectOnFocus": true });
    var time1128 = new Ext.form.DisplayField({ "selectOnFocus": true, "allowBlank": false, "value": "<br>" });
    var type1129 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.lino.ChangeTypes });
    var user1130 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/lino/Changes/user", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Benutzer ausw\u00e4hlen..." });
    var object_type1131 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/lino/Changes/object_type", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Inhaltstyp ausw\u00e4hlen..." });
    var object_id1132 = new Ext.form.NumberField({ "selectOnFocus": true, "allowBlank": false });
    var master_type1133 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/lino/Changes/master_type", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Inhaltstyp ausw\u00e4hlen..." });
    var master_id1134 = new Ext.form.NumberField({ "selectOnFocus": true, "allowBlank": false });
    var diff1135 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var object_disp1136 = new Ext.form.DisplayField({ "disabled": true });
    var master_disp1137 = new Ext.form.DisplayField({ "disabled": true });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "renderer": Lino.id_renderer, "hidden": false, "editor": id1127, "dataIndex": "id" }, { "colIndex": 1, "sortable": true, "header": "time", "editable": true, "width": Lino.chars2width(16), "dataIndex": "time", "hidden": false, "editor": time1128 }, { "colIndex": 2, "sortable": true, "header": "\u00c4nderungsart", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(14), "dataIndex": "type", "hidden": false, "editor": type1129 }, { "colIndex": 3, "sortable": true, "header": "Benutzer", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(15), "dataIndex": "user", "hidden": false, "editor": user1130 }, { "colIndex": 4, "sortable": true, "header": "Inhaltstyp", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('object_typeHidden','Lino.lino.ContentTypes.detail'), "hidden": false, "editor": object_type1131, "dataIndex": "object_type" }, { "colIndex": 5, "sortable": true, "header": "object id", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "dataIndex": "object_id", "hidden": false, "editor": object_id1132 }, { "colIndex": 6, "sortable": true, "header": "Inhaltstyp", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('master_typeHidden','Lino.lino.ContentTypes.detail'), "hidden": false, "editor": master_type1133, "dataIndex": "master_type" }, { "colIndex": 7, "sortable": true, "header": "master id", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "dataIndex": "master_id", "hidden": false, "editor": master_id1134 }, { "colIndex": 8, "sortable": false, "header": "\u00c4nderungen", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(60), "renderer": Lino.text_renderer, "hidden": false, "editor": diff1135, "dataIndex": "diff" }, { "width": Lino.chars2width(30), "colIndex": 9, "sortable": false, "dataIndex": "object", "header": "Object", "hidden": false, "editable": false }, { "width": Lino.chars2width(30), "colIndex": 10, "sortable": false, "dataIndex": "master", "header": "Stammdaten", "hidden": false, "editable": false } ];
    Lino.lino.Changes.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.lino.Changes.detailPanel = Ext.extend(Lino.lino.Changes.DetailFormPanel,{
  empty_title: "Detail \u00c4nderungen",
  ls_bbar_actions: [  ],
  ls_url: "/lino/Changes",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.lino.Changes.detail;
    Lino.lino.Changes.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.lino.Changes.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.lino.Changes.detailPanel(p);
});
Lino.lino.Changes.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.lino.Changes.GridPanel(p);
});

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUIusers.MySettingsHandle
Lino.users.MySettings.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/users/MySettings",
  ls_bbar_actions : [ { "itemId": "update_reminders", "menu_item_text": "Erinnerungen aktualisieren", "must_save": true, "panel_btn_handler": Lino.row_action_handler('update_reminders'), "text": "Erinnerungen aktualisieren", "overflowText": "Erinnerungen aktualisieren", "auto_save": true } ],
  title : "Benutzer",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "username" }, { "name": "profile" },'profileHidden', { "name": "first_name" }, { "name": "last_name" }, { "type": "int", "name": "id" }, { "name": "created" }, { "name": "modified" }, { "name": "password" }, { "name": "email" }, { "name": "remarks" }, { "name": "language" },'languageHidden', { "name": "partner" },'partnerHidden', { "name": "access_class" },'access_classHidden', { "name": "calendar" },'calendarHidden', { "name": "coaching_type" },'coaching_typeHidden', { "type": "boolean", "name": "coaching_supervisor" }, { "type": "int", "name": "newcomer_quota" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 5,
  ls_grid_configs : [  ],
  content_type : 8,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 24,
  initComponent : function() {
    this.ls_detail_handler = Lino.users.MySettings.detail;
    this.ls_insert_handler = Lino.users.Users.insert;
    var ww = this.containing_window;
    var username1139 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 30 });
    var profile1140 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": Lino.lino.UserProfiles });
    var first_name1141 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 30 });
    var last_name1142 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 30 });
    var id1143 = new Ext.form.NumberField({ "selectOnFocus": true });
    var created1144 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var modified1145 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var password1146 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 128 });
    var email1147 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75 });
    var remarks1148 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var language1149 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "allowBlank": false, "store": [ [ "de", "Deutsch" ], [ "fr", "Franz\u00f6sisch" ], [ "en", "Englisch" ] ] });
    var partner1150 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/MySettings/partner", "method": "GET" }) }), "pageSize": 20, "emptyText": "Partner ausw\u00e4hlen..." });
    var access_class1151 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.cal.AccessClasses });
    var calendar1152 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/MySettings/calendar", "method": "GET" }) }), "pageSize": 20, "emptyText": "Kalender ausw\u00e4hlen..." });
    var coaching_type1153 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/MySettings/coaching_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Dienst ausw\u00e4hlen..." });
    var coaching_supervisor1154 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var newcomer_quota1155 = new Ext.form.NumberField({ "selectOnFocus": true, "allowBlank": false, "value": 0 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Benutzername", "editable": true, "tooltip": "\n        Required. Must be unique. \n        ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "username", "hidden": false, "editor": username1139 }, { "colIndex": 1, "sortable": true, "header": "Benutzerprofil", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(43), "dataIndex": "profile", "hidden": false, "editor": profile1140 }, { "colIndex": 2, "sortable": true, "header": "Vorname", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "first_name", "hidden": false, "editor": first_name1141 }, { "colIndex": 3, "sortable": true, "header": "Familienname", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "last_name", "hidden": false, "editor": last_name1142 }, { "colIndex": 4, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "renderer": Lino.id_renderer, "hidden": false, "editor": id1143, "dataIndex": "id" }, { "width": Lino.chars2width(16), "colIndex": 5, "sortable": true, "dataIndex": "created", "header": "Erstellt", "hidden": false, "editable": false }, { "width": Lino.chars2width(16), "colIndex": 6, "sortable": true, "dataIndex": "modified", "header": "Bearbeitet", "hidden": false, "editable": false }, { "colIndex": 7, "sortable": true, "header": "Passwort", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "password", "hidden": false, "editor": password1146 }, { "colIndex": 8, "sortable": true, "header": "e-mail address", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "email", "hidden": false, "editor": email1147 }, { "colIndex": 9, "sortable": false, "header": "Bemerkungen", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(60), "renderer": Lino.text_renderer, "hidden": false, "editor": remarks1148, "dataIndex": "remarks" }, { "colIndex": 10, "sortable": true, "header": "Sprache", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "language", "hidden": false, "editor": language1149 }, { "colIndex": 11, "sortable": true, "header": "Partner", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "partner", "hidden": false, "editor": partner1150 }, { "colIndex": 12, "sortable": true, "header": "Standardm\u00e4\u00dfige Zugriffsklasse", "editable": true, "tooltip": "Die standardm\u00e4\u00dfige Zugriffsklasse f\u00fcr Ihre Termine und Aufgaben", "filter": { "type": "string" }, "width": Lino.chars2width(31), "dataIndex": "access_class", "hidden": false, "editor": access_class1151 }, { "colIndex": 13, "sortable": true, "header": "Standard-Kalender", "editable": true, "tooltip": "The default calendar for your events and tasks.", "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "calendar", "hidden": false, "editor": calendar1152 }, { "colIndex": 14, "sortable": true, "header": "Dienst", "editable": true, "tooltip": "The default CoachingType used when creating Coachings.", "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "coaching_type", "hidden": false, "editor": coaching_type1153 }, { "colIndex": 15, "sortable": false, "xtype": "checkcolumn", "header": "Benachrichtigung wenn ein Begleiter zugewiesen wird", "editable": true, "tooltip": "Wenn ein Neuantrag einem Begleiter zugewiesen wurde, wird au\u00dfer dem Begleiter auch dieser Benutzer benachrichtigt.", "filter": { "type": "boolean" }, "width": Lino.chars2width(10), "dataIndex": "coaching_supervisor", "hidden": false }, { "colIndex": 16, "sortable": true, "header": "Quote NZ", "editable": true, "tooltip": "Wieviele Neuantr\u00e4ge dieser Benutzer pro Monat verkraften kann.", "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "dataIndex": "newcomer_quota", "hidden": false, "editor": newcomer_quota1155 } ];
    Lino.users.MySettings.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.users.MySettings.detailPanel = Ext.extend(Lino.users.MySettings.DetailFormPanel,{
  empty_title: "Benutzer",
  ls_bbar_actions: [ { "itemId": "update_reminders", "menu_item_text": "Erinnerungen aktualisieren", "must_save": true, "panel_btn_handler": Lino.row_action_handler('update_reminders'), "text": "Erinnerungen aktualisieren", "overflowText": "Erinnerungen aktualisieren", "auto_save": true } ],
  ls_url: "/users/MySettings",
  initComponent : function() {
    this.ls_detail_handler = Lino.users.MySettings.detail;
    this.ls_insert_handler = Lino.users.Users.insert;
    Lino.users.MySettings.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.users.MySettings.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.users.MySettings.detailPanel(p);
});

Lino.users.MySettings.detailPanel = Ext.extend(Lino.users.MySettings.DetailFormPanel,{
  empty_title: "Benutzer",
  ls_bbar_actions: [ { "itemId": "update_reminders", "menu_item_text": "Erinnerungen aktualisieren", "must_save": true, "panel_btn_handler": Lino.row_action_handler('update_reminders'), "text": "Erinnerungen aktualisieren", "overflowText": "Erinnerungen aktualisieren", "auto_save": true } ],
  ls_url: "/users/MySettings",
  initComponent : function() {
    this.ls_detail_handler = Lino.users.MySettings.detail;
    this.ls_insert_handler = Lino.users.Users.insert;
    Lino.users.MySettings.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.users.MySettings.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.users.MySettings.detailPanel(p);
});

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUIcountries.LanguagesHandle
Lino.countries.Languages.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/countries/Languages",
  ls_bbar_actions : [ { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true } ],
  title : "Sprachen",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "name" }, { "name": "name_fr" }, { "name": "name_en" }, { "name": "id" }, { "name": "iso2" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 3,
  ls_grid_configs : [  ],
  content_type : 10,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 6,
  initComponent : function() {
    this.ls_detail_handler = Lino.countries.Languages.detail;
    this.ls_insert_handler = Lino.countries.Languages.insert;
    var ww = this.containing_window;
    var name1157 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_fr1158 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_en1159 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var id1160 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(3), "allowBlank": false, "maxLength": 3 });
    var iso21161 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(2), "maxLength": 2 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Bezeichnung", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name", "hidden": false, "editor": name1157 }, { "colIndex": 1, "sortable": true, "header": "Bezeichnung (fr)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name_fr", "hidden": false, "editor": name_fr1158 }, { "colIndex": 2, "sortable": true, "header": "Bezeichnung (en)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name_en", "hidden": false, "editor": name_en1159 }, { "colIndex": 3, "sortable": true, "header": "id", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(4), "dataIndex": "id", "hidden": false, "editor": id1160 }, { "colIndex": 4, "sortable": true, "header": "iso2", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(4), "dataIndex": "iso2", "hidden": false, "editor": iso21161 } ];
    Lino.countries.Languages.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.countries.Languages.insertPanel = Ext.extend(Lino.countries.Languages.DetailFormPanel,{
  empty_title: "Neu Sprachen",
  hide_navigator: true,
  ls_bbar_actions: [  ],
  ls_url: "/countries/Languages",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.countries.Languages.detail;
    this.ls_insert_handler = Lino.countries.Languages.insert;
    Lino.countries.Languages.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.countries.Languages.insert = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.countries.Languages.insertPanel(p);
});

Lino.countries.Languages.detailPanel = Ext.extend(Lino.countries.Languages.DetailFormPanel,{
  empty_title: "Detail Sprachen",
  ls_bbar_actions: [  ],
  ls_url: "/countries/Languages",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.countries.Languages.detail;
    this.ls_insert_handler = Lino.countries.Languages.insert;
    Lino.countries.Languages.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.countries.Languages.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.countries.Languages.detailPanel(p);
});
Lino.countries.Languages.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.countries.Languages.GridPanel(p);
});

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUIcountries.CountriesHandle
Lino.countries.Countries.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/countries/Countries",
  ls_bbar_actions : [ { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true } ],
  title : "L\u00e4nder",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "name" }, { "name": "name_fr" }, { "name": "name_en" }, { "name": "isocode" }, { "name": "short_code" }, { "name": "iso3" }, { "name": "inscode" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 3,
  ls_grid_configs : [  ],
  content_type : 9,
  ls_id_property : "isocode",
  gc_name : 0,
  disabled_actions_index : 8,
  initComponent : function() {
    this.ls_detail_handler = Lino.countries.Countries.detail;
    this.ls_insert_handler = Lino.countries.Countries.insert;
    var ww = this.containing_window;
    var name1163 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_fr1164 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_en1165 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var isocode1166 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(4), "allowBlank": false, "maxLength": 4 });
    var short_code1167 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(4), "maxLength": 4 });
    var iso31168 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(3), "maxLength": 3 });
    var inscode1169 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(3), "maxLength": 3 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Bezeichnung", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name", "hidden": false, "editor": name1163 }, { "colIndex": 1, "sortable": true, "header": "Bezeichnung (fr)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name_fr", "hidden": false, "editor": name_fr1164 }, { "colIndex": 2, "sortable": true, "header": "Bezeichnung (en)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name_en", "hidden": false, "editor": name_en1165 }, { "colIndex": 3, "sortable": true, "header": "isocode", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(5), "dataIndex": "isocode", "hidden": false, "editor": isocode1166 }, { "colIndex": 4, "sortable": true, "header": "short code", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(5), "dataIndex": "short_code", "hidden": false, "editor": short_code1167 }, { "colIndex": 5, "sortable": true, "header": "iso3", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(4), "dataIndex": "iso3", "hidden": false, "editor": iso31168 }, { "colIndex": 6, "sortable": true, "header": "INS-Code", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(4), "dataIndex": "inscode", "hidden": false, "editor": inscode1169 } ];
    Lino.countries.Countries.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.countries.Countries.insertPanel = Ext.extend(Lino.countries.Countries.DetailFormPanel,{
  empty_title: "Neu L\u00e4nder",
  hide_navigator: true,
  ls_bbar_actions: [  ],
  ls_url: "/countries/Countries",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.countries.Countries.detail;
    this.ls_insert_handler = Lino.countries.Countries.insert;
    Lino.countries.Countries.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.countries.Countries.insert = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.countries.Countries.insertPanel(p);
});

Lino.countries.Countries.detailPanel = Ext.extend(Lino.countries.Countries.DetailFormPanel,{
  empty_title: "Detail L\u00e4nder",
  ls_bbar_actions: [  ],
  ls_url: "/countries/Countries",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.countries.Countries.detail;
    this.ls_insert_handler = Lino.countries.Countries.insert;
    Lino.countries.Countries.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.countries.Countries.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.countries.Countries.detailPanel(p);
});
Lino.countries.Countries.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.countries.Countries.GridPanel(p);
});

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUIcountries.CitiesHandle
Lino.countries.Cities.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/countries/Cities",
  ls_bbar_actions : [ { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true } ],
  title : "Orte",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "country" },'countryHidden', { "name": "name" }, { "name": "type" },'typeHidden', { "name": "zip_code" }, { "type": "int", "name": "id" }, { "name": "parent" },'parentHidden', { "name": "inscode" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 6,
  ls_grid_configs : [  ],
  content_type : 11,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 11,
  initComponent : function() {
    this.ls_detail_handler = Lino.countries.Cities.detail;
    this.ls_insert_handler = Lino.countries.Cities.insert;
    var ww = this.containing_window;
    var country1171 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/countries/Cities/country", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Land ausw\u00e4hlen..." });
    var name1172 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var type1173 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/countries/Cities/type", "method": "GET" }) }) });
    var zip_code1174 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(8), "maxLength": 8 });
    var id1175 = new Ext.form.NumberField({ "selectOnFocus": true });
    var parent1176 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/countries/Cities/parent", "method": "GET" }) }), "pageSize": 20, "emptyText": "Ort ausw\u00e4hlen..." });
    var inscode1177 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(5), "maxLength": 5 });
    this.before_row_edit = function(record) {
      type1173.setContextValue('country',record ? record.data['countryHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      country1171.on('change',Lino.chooser_handler(type1173,'country'));
      Lino.countries.Cities.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Land", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('countryHidden','Lino.countries.Countries.detail'), "hidden": false, "editor": country1171, "dataIndex": "country" }, { "colIndex": 1, "sortable": true, "header": "name", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name", "hidden": false, "editor": name1172 }, { "colIndex": 2, "sortable": true, "header": "Ortsart", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(10), "dataIndex": "type", "hidden": false, "editor": type1173 }, { "colIndex": 3, "sortable": true, "header": "zip code", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(9), "dataIndex": "zip_code", "hidden": false, "editor": zip_code1174 }, { "colIndex": 4, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "renderer": Lino.id_renderer, "hidden": false, "editor": id1175, "dataIndex": "id" }, { "colIndex": 5, "sortable": true, "header": "Teil von", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('parentHidden','Lino.countries.Cities.detail'), "hidden": false, "editor": parent1176, "dataIndex": "parent" }, { "colIndex": 6, "sortable": true, "header": "INS-Code", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(6), "dataIndex": "inscode", "hidden": false, "editor": inscode1177 } ];
    Lino.countries.Cities.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.countries.Cities.insertPanel = Ext.extend(Lino.countries.Cities.DetailFormPanel,{
  empty_title: "Neu Orte",
  hide_navigator: true,
  ls_bbar_actions: [  ],
  ls_url: "/countries/Cities",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.countries.Cities.detail;
    this.ls_insert_handler = Lino.countries.Cities.insert;
    Lino.countries.Cities.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.countries.Cities.insert = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.countries.Cities.insertPanel(p);
});

Lino.countries.Cities.detailPanel = Ext.extend(Lino.countries.Cities.DetailFormPanel,{
  empty_title: "Detail Orte",
  ls_bbar_actions: [  ],
  ls_url: "/countries/Cities",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.countries.Cities.detail;
    this.ls_insert_handler = Lino.countries.Cities.insert;
    Lino.countries.Cities.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.countries.Cities.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.countries.Cities.detailPanel(p);
});
Lino.countries.Cities.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.countries.Cities.GridPanel(p);
});

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUIproperties.PropGroupsHandle
Lino.properties.PropGroups.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/properties/PropGroups",
  ls_bbar_actions : [ { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true } ],
  title : "Eigenschaftsgruppen",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "name" }, { "name": "name_fr" }, { "name": "name_en" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 15,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 5,
  initComponent : function() {
    this.ls_detail_handler = Lino.properties.PropGroups.detail;
    this.ls_insert_handler = Lino.properties.PropGroups.insert;
    var ww = this.containing_window;
    var id1179 = new Ext.form.NumberField({ "selectOnFocus": true });
    var name1180 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_fr1181 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_en1182 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "renderer": Lino.id_renderer, "hidden": false, "editor": id1179, "dataIndex": "id" }, { "colIndex": 1, "sortable": true, "header": "Bezeichnung", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name", "hidden": false, "editor": name1180 }, { "colIndex": 2, "sortable": true, "header": "Bezeichnung (fr)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name_fr", "hidden": false, "editor": name_fr1181 }, { "colIndex": 3, "sortable": true, "header": "Bezeichnung (en)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name_en", "hidden": false, "editor": name_en1182 } ];
    Lino.properties.PropGroups.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.properties.PropGroups.insertPanel = Ext.extend(Lino.properties.PropGroups.DetailFormPanel,{
  empty_title: "Neu Eigenschaftsgruppen",
  hide_navigator: true,
  ls_bbar_actions: [  ],
  ls_url: "/properties/PropGroups",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.properties.PropGroups.detail;
    this.ls_insert_handler = Lino.properties.PropGroups.insert;
    Lino.properties.PropGroups.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.properties.PropGroups.insert = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.properties.PropGroups.insertPanel(p);
});

Lino.properties.PropGroups.detailPanel = Ext.extend(Lino.properties.PropGroups.DetailFormPanel,{
  empty_title: "Detail Eigenschaftsgruppen",
  ls_bbar_actions: [  ],
  ls_url: "/properties/PropGroups",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.properties.PropGroups.detail;
    this.ls_insert_handler = Lino.properties.PropGroups.insert;
    Lino.properties.PropGroups.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.properties.PropGroups.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.properties.PropGroups.detailPanel(p);
});
Lino.properties.PropGroups.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.properties.PropGroups.GridPanel(p);
});

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUIproperties.PropTypesHandle
Lino.properties.PropTypes.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/properties/PropTypes",
  ls_bbar_actions : [ { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true } ],
  title : "Eigenschafts-Datentypen",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "name" }, { "name": "name_fr" }, { "name": "name_en" }, { "name": "choicelist" },'choicelistHidden', { "name": "default_value" },'default_valueHidden', { "type": "boolean", "name": "limit_to_choices" }, { "type": "boolean", "name": "multiple_choices" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 16,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 11,
  initComponent : function() {
    this.ls_detail_handler = Lino.properties.PropTypes.detail;
    this.ls_insert_handler = Lino.properties.PropTypes.insert;
    var ww = this.containing_window;
    var id1184 = new Ext.form.NumberField({ "selectOnFocus": true });
    var name1185 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_fr1186 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_en1187 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var choicelist1188 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "countries.CityTypes", "Ortsart" ], [ "lino.ChangeTypes", "\u00c4nderungsart" ], [ "lino.UserGroups", "Benutzergruppe" ], [ "lino.UserLevels", "Benutzer-Level" ], [ "lino.UserProfiles", "Benutzerprofil" ], [ "properties.DoYouLike", "blo\u00df nicht ... sehr gerne" ], [ "properties.HowWell", "gar nicht ... sehr gut" ] ] });
    var default_value1189 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/properties/PropTypes/default_value", "method": "GET" }) }) });
    var limit_to_choices1190 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var multiple_choices1191 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    this.before_row_edit = function(record) {
      default_value1189.setContextValue('choicelist',record ? record.data['choicelistHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      choicelist1188.on('change',Lino.chooser_handler(default_value1189,'choicelist'));
      Lino.properties.PropTypes.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "renderer": Lino.id_renderer, "hidden": false, "editor": id1184, "dataIndex": "id" }, { "colIndex": 1, "sortable": true, "header": "Bezeichnung", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name", "hidden": false, "editor": name1185 }, { "colIndex": 2, "sortable": true, "header": "Bezeichnung (fr)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name_fr", "hidden": false, "editor": name_fr1186 }, { "colIndex": 3, "sortable": true, "header": "Bezeichnung (en)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name_en", "hidden": false, "editor": name_en1187 }, { "colIndex": 4, "sortable": true, "header": "Auswahliste", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "choicelist", "hidden": false, "editor": choicelist1188 }, { "colIndex": 5, "sortable": true, "header": "Standardwert", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(10), "dataIndex": "default_value", "hidden": false, "editor": default_value1189 }, { "colIndex": 6, "sortable": false, "xtype": "checkcolumn", "header": "Beschr\u00e4nken auf Auswahl", "editable": true, "filter": { "type": "boolean" }, "width": Lino.chars2width(10), "dataIndex": "limit_to_choices", "hidden": false }, { "colIndex": 7, "sortable": false, "xtype": "checkcolumn", "header": "Mehrfachauswahl", "editable": true, "filter": { "type": "boolean" }, "width": Lino.chars2width(10), "dataIndex": "multiple_choices", "hidden": false } ];
    Lino.properties.PropTypes.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.properties.PropTypes.insertPanel = Ext.extend(Lino.properties.PropTypes.DetailFormPanel,{
  empty_title: "Neu Eigenschafts-Datentypen",
  hide_navigator: true,
  ls_bbar_actions: [  ],
  ls_url: "/properties/PropTypes",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.properties.PropTypes.detail;
    this.ls_insert_handler = Lino.properties.PropTypes.insert;
    Lino.properties.PropTypes.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.properties.PropTypes.insert = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.properties.PropTypes.insertPanel(p);
});

Lino.properties.PropTypes.detailPanel = Ext.extend(Lino.properties.PropTypes.DetailFormPanel,{
  empty_title: "Detail Eigenschafts-Datentypen",
  ls_bbar_actions: [  ],
  ls_url: "/properties/PropTypes",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.properties.PropTypes.detail;
    this.ls_insert_handler = Lino.properties.PropTypes.insert;
    Lino.properties.PropTypes.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.properties.PropTypes.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.properties.PropTypes.detailPanel(p);
});
Lino.properties.PropTypes.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.properties.PropTypes.GridPanel(p);
});

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUIproperties.PropertiesHandle
Lino.properties.Properties.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/properties/Properties",
  ls_bbar_actions : [ { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true } ],
  title : "Eigenschaften",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "name" }, { "name": "name_fr" }, { "name": "name_en" }, { "name": "group" },'groupHidden', { "name": "type" },'typeHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 13,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 9,
  initComponent : function() {
    this.ls_detail_handler = Lino.properties.Properties.detail;
    this.ls_insert_handler = Lino.properties.Properties.insert;
    var ww = this.containing_window;
    var id1193 = new Ext.form.NumberField({ "selectOnFocus": true });
    var name1194 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_fr1195 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_en1196 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var group1197 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/properties/Properties/group", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Eigenschaftsgruppe ausw\u00e4hlen..." });
    var type1198 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/properties/Properties/type", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Eigenschafts-Datentyp ausw\u00e4hlen..." });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "renderer": Lino.id_renderer, "hidden": false, "editor": id1193, "dataIndex": "id" }, { "colIndex": 1, "sortable": true, "header": "Bezeichnung", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name", "hidden": false, "editor": name1194 }, { "colIndex": 2, "sortable": true, "header": "Bezeichnung (fr)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name_fr", "hidden": false, "editor": name_fr1195 }, { "colIndex": 3, "sortable": true, "header": "Bezeichnung (en)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name_en", "hidden": false, "editor": name_en1196 }, { "colIndex": 4, "sortable": true, "header": "Eigenschaftsgruppe", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('groupHidden','Lino.properties.PropGroups.detail'), "hidden": false, "editor": group1197, "dataIndex": "group" }, { "colIndex": 5, "sortable": true, "header": "Eigenschafts-Datentyp", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('typeHidden','Lino.properties.PropTypes.detail'), "hidden": false, "editor": type1198, "dataIndex": "type" } ];
    Lino.properties.Properties.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.properties.Properties.insertPanel = Ext.extend(Lino.properties.Properties.DetailFormPanel,{
  empty_title: "Neu Eigenschaften",
  hide_navigator: true,
  ls_bbar_actions: [  ],
  ls_url: "/properties/Properties",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.properties.Properties.detail;
    this.ls_insert_handler = Lino.properties.Properties.insert;
    Lino.properties.Properties.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.properties.Properties.insert = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.properties.Properties.insertPanel(p);
});

Lino.properties.Properties.detailPanel = Ext.extend(Lino.properties.Properties.DetailFormPanel,{
  empty_title: "Detail Eigenschaften",
  ls_bbar_actions: [  ],
  ls_url: "/properties/Properties",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.properties.Properties.detail;
    this.ls_insert_handler = Lino.properties.Properties.insert;
    Lino.properties.Properties.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.properties.Properties.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.properties.Properties.detailPanel(p);
});
Lino.properties.Properties.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.properties.Properties.GridPanel(p);
});

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUIproperties.PropChoicesHandle
Lino.properties.PropChoices.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/properties/PropChoices",
  ls_bbar_actions : [  ],
  title : "Auswahlm\u00f6glichkeiten",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "type" },'typeHidden', { "name": "value" }, { "name": "text" }, { "name": "text_fr" }, { "name": "text_en" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 14,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 8,
  initComponent : function() {
    var ww = this.containing_window;
    var id1200 = new Ext.form.NumberField({ "selectOnFocus": true });
    var type1201 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/properties/PropChoices/type", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Eigenschafts-Datentyp ausw\u00e4hlen..." });
    var value1202 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var text1203 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var text_fr1204 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var text_en1205 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "renderer": Lino.id_renderer, "hidden": false, "editor": id1200, "dataIndex": "id" }, { "colIndex": 1, "sortable": true, "header": "Eigenschafts-Datentyp", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('typeHidden','Lino.properties.PropTypes.detail'), "hidden": false, "editor": type1201, "dataIndex": "type" }, { "colIndex": 2, "sortable": true, "header": "Wert", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "value", "hidden": false, "editor": value1202 }, { "colIndex": 3, "sortable": true, "header": "Bezeichnung", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "text", "hidden": false, "editor": text1203 }, { "colIndex": 4, "sortable": true, "header": "Bezeichnung (fr)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "text_fr", "hidden": false, "editor": text_fr1204 }, { "colIndex": 5, "sortable": true, "header": "Bezeichnung (en)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "text_en", "hidden": false, "editor": text_en1205 } ];
    Lino.properties.PropChoices.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.properties.PropChoices.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.properties.PropChoices.GridPanel(p);
});

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUIuploads.UploadTypesHandle
Lino.uploads.UploadTypes.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/uploads/UploadTypes",
  ls_bbar_actions : [  ],
  title : "Upload-Arten",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "name" }, { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 1,
  ls_grid_configs : [  ],
  content_type : 26,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 3,
  initComponent : function() {
    var ww = this.containing_window;
    var name1207 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var id1208 = new Ext.form.NumberField({ "selectOnFocus": true });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Name", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name", "hidden": false, "editor": name1207 }, { "colIndex": 1, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "renderer": Lino.id_renderer, "hidden": false, "editor": id1208, "dataIndex": "id" } ];
    Lino.uploads.UploadTypes.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.uploads.UploadTypes.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.uploads.UploadTypes.GridPanel(p);
});

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUIuploads.UploadsHandle
Lino.uploads.Uploads.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/uploads/Uploads",
  ls_bbar_actions : [ { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true } ],
  title : "Uploads",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "file" }, { "name": "user" },'userHidden', { "name": "created" }, { "name": "modified" }, { "type": "int", "name": "id" }, { "name": "owner_type" },'owner_typeHidden', { "name": "owner_id" },'owner_idHidden', { "name": "mimetype" }, { "name": "type" },'typeHidden', { "type": "date", "name": "valid_until", "dateFormat": "d.m.Y" }, { "name": "description" }, { "name": "owner" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 5,
  ls_grid_configs : [  ],
  content_type : 25,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 17,
  initComponent : function() {
    this.ls_detail_handler = Lino.uploads.Uploads.detail;
    this.ls_insert_handler = Lino.uploads.Uploads.insert;
    var ww = this.containing_window;
    var file1210 = Lino.file_field_handler(this,{ "selectOnFocus": true, "allowBlank": false, "maxLength": 100 });
    var user1211 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/Uploads/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Benutzer ausw\u00e4hlen..." });
    var created1212 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var modified1213 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var id1214 = new Ext.form.NumberField({ "selectOnFocus": true });
    var owner_type1215 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/Uploads/owner_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Inhaltstyp ausw\u00e4hlen..." });
    var owner_id1216 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/Uploads/owner_id", "method": "GET" }) }) });
    var mimetype1217 = new Ext.form.TextField({ "disabled": true, "maxLength": 64 });
    var type1218 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/Uploads/type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Upload-Art ausw\u00e4hlen..." });
    var valid_until1219 = new Lino.DateField({ "selectOnFocus": true });
    var description1220 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var owner_disp1221 = new Ext.form.DisplayField({ "disabled": true });
    this.before_row_edit = function(record) {
      owner_id1216.setContextValue('owner_type',record ? record.data['owner_typeHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      owner_type1215.on('change',Lino.chooser_handler(owner_id1216,'owner_type'));
      Lino.uploads.Uploads.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Datei", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "file", "hidden": false, "editor": file1210 }, { "colIndex": 1, "sortable": true, "header": "Autor", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(15), "dataIndex": "user", "hidden": false, "editor": user1211 }, { "width": Lino.chars2width(16), "colIndex": 2, "sortable": true, "dataIndex": "created", "header": "Erstellt", "hidden": false, "editable": false }, { "width": Lino.chars2width(16), "colIndex": 3, "sortable": true, "dataIndex": "modified", "header": "Bearbeitet", "hidden": false, "editable": false }, { "colIndex": 4, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "renderer": Lino.id_renderer, "hidden": false, "editor": id1214, "dataIndex": "id" }, { "colIndex": 5, "sortable": true, "header": "Verkn\u00fcpft mit (Modell)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('owner_typeHidden','Lino.lino.ContentTypes.detail'), "hidden": false, "editor": owner_type1215, "dataIndex": "owner_type" }, { "colIndex": 6, "sortable": true, "header": "Verkn\u00fcpft mit (Objekt)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(10), "dataIndex": "owner_id", "hidden": false, "editor": owner_id1216 }, { "colIndex": 7, "sortable": true, "header": "MIME-Art", "editable": false, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "mimetype", "hidden": false }, { "colIndex": 8, "sortable": true, "header": "Upload-Art", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "type", "hidden": false, "editor": type1218 }, { "colIndex": 9, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "g\u00fcltig bis", "dataIndex": "valid_until", "hidden": false, "width": Lino.chars2width(8), "editor": valid_until1219 }, { "colIndex": 10, "sortable": true, "header": "Beschreibung", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "description", "hidden": false, "editor": description1220 }, { "width": Lino.chars2width(30), "colIndex": 11, "sortable": false, "dataIndex": "owner", "header": "Verkn\u00fcpft mit", "hidden": false, "editable": false } ];
    Lino.uploads.Uploads.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.uploads.Uploads.insertPanel = Ext.extend(Lino.uploads.Uploads.InsertFormPanel,{
  empty_title: "Neu Uploads",
  hide_navigator: true,
  ls_bbar_actions: [  ],
  ls_url: "/uploads/Uploads",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.uploads.Uploads.detail;
    this.ls_insert_handler = Lino.uploads.Uploads.insert;
    Lino.uploads.Uploads.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.uploads.Uploads.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.uploads.Uploads.insertPanel(p);
});

Lino.uploads.Uploads.detailPanel = Ext.extend(Lino.uploads.Uploads.DetailFormPanel,{
  empty_title: "Detail Uploads",
  ls_bbar_actions: [  ],
  ls_url: "/uploads/Uploads",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.uploads.Uploads.detail;
    this.ls_insert_handler = Lino.uploads.Uploads.insert;
    Lino.uploads.Uploads.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.uploads.Uploads.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.uploads.Uploads.detailPanel(p);
});
Lino.uploads.Uploads.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.uploads.Uploads.GridPanel(p);
});

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUIhouseholds.TypesHandle
Lino.households.Types.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/households/Types",
  ls_bbar_actions : [ { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true } ],
  title : "Haushaltsarten",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "name" }, { "name": "name_fr" }, { "name": "name_en" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 43,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 5,
  initComponent : function() {
    this.ls_detail_handler = Lino.households.Types.detail;
    this.ls_insert_handler = Lino.households.Types.insert;
    var ww = this.containing_window;
    var id1223 = new Ext.form.NumberField({ "selectOnFocus": true });
    var name1224 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_fr1225 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_en1226 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "renderer": Lino.id_renderer, "hidden": false, "editor": id1223, "dataIndex": "id" }, { "colIndex": 1, "sortable": true, "header": "Bezeichnung", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name", "hidden": false, "editor": name1224 }, { "colIndex": 2, "sortable": true, "header": "Bezeichnung (fr)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name_fr", "hidden": false, "editor": name_fr1225 }, { "colIndex": 3, "sortable": true, "header": "Bezeichnung (en)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name_en", "hidden": false, "editor": name_en1226 } ];
    Lino.households.Types.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.households.Types.insertPanel = Ext.extend(Lino.households.Types.DetailFormPanel,{
  empty_title: "Neu Haushaltsarten",
  hide_navigator: true,
  ls_bbar_actions: [  ],
  ls_url: "/households/Types",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.households.Types.detail;
    this.ls_insert_handler = Lino.households.Types.insert;
    Lino.households.Types.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.households.Types.insert = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.households.Types.insertPanel(p);
});

Lino.households.Types.detailPanel = Ext.extend(Lino.households.Types.DetailFormPanel,{
  empty_title: "Detail Haushaltsarten",
  ls_bbar_actions: [  ],
  ls_url: "/households/Types",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.households.Types.detail;
    this.ls_insert_handler = Lino.households.Types.insert;
    Lino.households.Types.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.households.Types.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.households.Types.detailPanel(p);
});
Lino.households.Types.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.households.Types.GridPanel(p);
});

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUIhouseholds.RolesHandle
Lino.households.Roles.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/households/Roles",
  ls_bbar_actions : [ { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true } ],
  title : "Rollen in Haushalt",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "name" }, { "name": "name_fr" }, { "name": "name_en" }, { "type": "boolean", "name": "name_giving" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 42,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 6,
  initComponent : function() {
    this.ls_detail_handler = Lino.households.Roles.detail;
    this.ls_insert_handler = Lino.households.Roles.insert;
    var ww = this.containing_window;
    var id1228 = new Ext.form.NumberField({ "selectOnFocus": true });
    var name1229 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_fr1230 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_en1231 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_giving1232 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "renderer": Lino.id_renderer, "hidden": false, "editor": id1228, "dataIndex": "id" }, { "colIndex": 1, "sortable": true, "header": "Bezeichnung", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name", "hidden": false, "editor": name1229 }, { "colIndex": 2, "sortable": true, "header": "Bezeichnung (fr)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name_fr", "hidden": false, "editor": name_fr1230 }, { "colIndex": 3, "sortable": true, "header": "Bezeichnung (en)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name_en", "hidden": false, "editor": name_en1231 }, { "colIndex": 4, "sortable": false, "xtype": "checkcolumn", "header": "namensgebend", "editable": true, "tooltip": "When the `name` field of a Household is empty, \nits value is computed by joining the `Last Name` \nof all name-giving members with a dash (\"-\").\n      ", "filter": { "type": "boolean" }, "width": Lino.chars2width(10), "dataIndex": "name_giving", "hidden": false } ];
    Lino.households.Roles.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.households.Roles.insertPanel = Ext.extend(Lino.households.Roles.DetailFormPanel,{
  empty_title: "Neu Rollen in Haushalt",
  hide_navigator: true,
  ls_bbar_actions: [  ],
  ls_url: "/households/Roles",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.households.Roles.detail;
    this.ls_insert_handler = Lino.households.Roles.insert;
    Lino.households.Roles.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.households.Roles.insert = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.households.Roles.insertPanel(p);
});

Lino.households.Roles.detailPanel = Ext.extend(Lino.households.Roles.DetailFormPanel,{
  empty_title: "Detail Rollen in Haushalt",
  ls_bbar_actions: [  ],
  ls_url: "/households/Roles",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.households.Roles.detail;
    this.ls_insert_handler = Lino.households.Roles.insert;
    Lino.households.Roles.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.households.Roles.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.households.Roles.detailPanel(p);
});
Lino.households.Roles.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.households.Roles.GridPanel(p);
});

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUIhouseholds.MembersHandle
Lino.households.Members.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/households/Members",
  ls_bbar_actions : [  ],
  title : "Mitglieder",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "role" },'roleHidden', { "name": "household" },'householdHidden', { "name": "person" },'personHidden', { "type": "date", "name": "start_date", "dateFormat": "d.m.Y" }, { "type": "date", "name": "end_date", "dateFormat": "d.m.Y" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 41,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 10,
  initComponent : function() {
    var ww = this.containing_window;
    var id1234 = new Ext.form.NumberField({ "selectOnFocus": true });
    var role1235 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/Members/role", "method": "GET" }) }), "pageSize": 20, "emptyText": "Rolle in Haushalt ausw\u00e4hlen..." });
    var household1236 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/Members/household", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Haushalt ausw\u00e4hlen..." });
    var person1237 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/Members/person", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Person ausw\u00e4hlen..." });
    var start_date1238 = new Lino.DateField({ "selectOnFocus": true });
    var end_date1239 = new Lino.DateField({ "selectOnFocus": true });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "renderer": Lino.id_renderer, "hidden": false, "editor": id1234, "dataIndex": "id" }, { "colIndex": 1, "sortable": true, "width": Lino.chars2width(20), "editable": true, "tooltip": "The Role of this Person in this Household.\nList of choices is configured in `Configure --> Households --> Roles`.\n", "filter": { "type": "string" }, "header": "Rolle in Haushalt", "renderer": Lino.fk_renderer('roleHidden','Lino.households.Roles.detail'), "hidden": false, "editor": role1235, "dataIndex": "role" }, { "colIndex": 2, "sortable": true, "header": "Haushalt", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "household", "hidden": false, "editor": household1236 }, { "colIndex": 3, "sortable": true, "header": "Person", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "person", "hidden": false, "editor": person1237 }, { "colIndex": 4, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "From", "dataIndex": "start_date", "hidden": false, "width": Lino.chars2width(8), "editor": start_date1238 }, { "colIndex": 5, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Until", "dataIndex": "end_date", "hidden": false, "width": Lino.chars2width(8), "editor": end_date1239 } ];
    Lino.households.Members.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.households.Members.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.households.Members.GridPanel(p);
});

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUIaccounts.ChartsHandle
Lino.accounts.Charts.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/accounts/Charts",
  ls_bbar_actions : [ { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true } ],
  title : "Kontenpl\u00e4ne",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "name" }, { "name": "name_fr" }, { "name": "name_en" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 45,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 5,
  initComponent : function() {
    this.ls_detail_handler = Lino.accounts.Charts.detail;
    this.ls_insert_handler = Lino.accounts.Charts.insert;
    var ww = this.containing_window;
    var id1241 = new Ext.form.NumberField({ "selectOnFocus": true });
    var name1242 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_fr1243 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_en1244 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "renderer": Lino.id_renderer, "hidden": false, "editor": id1241, "dataIndex": "id" }, { "colIndex": 1, "sortable": true, "header": "Bezeichnung", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name", "hidden": false, "editor": name1242 }, { "colIndex": 2, "sortable": true, "header": "Bezeichnung (fr)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name_fr", "hidden": false, "editor": name_fr1243 }, { "colIndex": 3, "sortable": true, "header": "Bezeichnung (en)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name_en", "hidden": false, "editor": name_en1244 } ];
    Lino.accounts.Charts.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.accounts.Charts.insertPanel = Ext.extend(Lino.accounts.Charts.DetailFormPanel,{
  empty_title: "Neu Kontenpl\u00e4ne",
  hide_navigator: true,
  ls_bbar_actions: [  ],
  ls_url: "/accounts/Charts",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.accounts.Charts.detail;
    this.ls_insert_handler = Lino.accounts.Charts.insert;
    Lino.accounts.Charts.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.accounts.Charts.insert = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.accounts.Charts.insertPanel(p);
});

Lino.accounts.Charts.detailPanel = Ext.extend(Lino.accounts.Charts.DetailFormPanel,{
  empty_title: "Detail Kontenpl\u00e4ne",
  ls_bbar_actions: [  ],
  ls_url: "/accounts/Charts",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.accounts.Charts.detail;
    this.ls_insert_handler = Lino.accounts.Charts.insert;
    Lino.accounts.Charts.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.accounts.Charts.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.accounts.Charts.detailPanel(p);
});
Lino.accounts.Charts.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.accounts.Charts.GridPanel(p);
});

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUIaccounts.GroupsHandle
Lino.accounts.Groups.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/accounts/Groups",
  ls_bbar_actions : [ { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true } ],
  title : "Kontengruppen",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "chart" },'chartHidden', { "name": "ref" }, { "name": "name" }, { "name": "name_fr" }, { "name": "name_en" }, { "name": "account_type" },'account_typeHidden', { "type": "int", "name": "id" }, { "name": "help_text" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 8,
  ls_grid_configs : [  ],
  content_type : 46,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 11,
  initComponent : function() {
    this.ls_detail_handler = Lino.accounts.Groups.detail;
    this.ls_insert_handler = Lino.accounts.Groups.insert;
    var ww = this.containing_window;
    var chart1246 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/accounts/Groups/chart", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Kontenplan ausw\u00e4hlen..." });
    var ref1247 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 100 });
    var name1248 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_fr1249 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_en1250 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var account_type1251 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": Lino.accounts.AccountTypes });
    var id1252 = new Ext.form.NumberField({ "selectOnFocus": true });
    var help_text1253 = new Lino.RichTextPanel({ "selectOnFocus": true, "containing_panel": this, "title": "Einleitung" });
    this.before_row_edit = function(record) {
      help_text1253.refresh();
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Kontenplan", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('chartHidden','Lino.accounts.Charts.detail'), "hidden": false, "editor": chart1246, "dataIndex": "chart" }, { "colIndex": 1, "sortable": true, "header": "ref", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "ref", "hidden": false, "editor": ref1247 }, { "colIndex": 2, "sortable": true, "header": "Bezeichnung", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name", "hidden": false, "editor": name1248 }, { "colIndex": 3, "sortable": true, "header": "Bezeichnung (fr)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name_fr", "hidden": false, "editor": name_fr1249 }, { "colIndex": 4, "sortable": true, "header": "Bezeichnung (en)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name_en", "hidden": false, "editor": name_en1250 }, { "colIndex": 5, "sortable": true, "header": "Kontenart", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(15), "dataIndex": "account_type", "hidden": false, "editor": account_type1251 }, { "colIndex": 6, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "renderer": Lino.id_renderer, "hidden": false, "editor": id1252, "dataIndex": "id" }, { "colIndex": 7, "sortable": false, "header": "help_text", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(60), "renderer": Lino.text_renderer, "hidden": false, "editor": help_text1253, "dataIndex": "help_text" } ];
    Lino.accounts.Groups.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.accounts.Groups.insertPanel = Ext.extend(Lino.accounts.Groups.DetailFormPanel,{
  empty_title: "Neu Kontengruppen",
  hide_navigator: true,
  ls_bbar_actions: [  ],
  ls_url: "/accounts/Groups",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.accounts.Groups.detail;
    this.ls_insert_handler = Lino.accounts.Groups.insert;
    Lino.accounts.Groups.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.accounts.Groups.insert = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.accounts.Groups.insertPanel(p);
});

Lino.accounts.Groups.detailPanel = Ext.extend(Lino.accounts.Groups.DetailFormPanel,{
  empty_title: "Detail Kontengruppen",
  ls_bbar_actions: [  ],
  ls_url: "/accounts/Groups",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.accounts.Groups.detail;
    this.ls_insert_handler = Lino.accounts.Groups.insert;
    Lino.accounts.Groups.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.accounts.Groups.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.accounts.Groups.detailPanel(p);
});
Lino.accounts.Groups.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.accounts.Groups.GridPanel(p);
});

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUIaccounts.AccountsHandle
Lino.accounts.Accounts.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/accounts/Accounts",
  ls_bbar_actions : [ { "itemId": "duplicate_row", "menu_item_text": "Duplizieren", "must_save": true, "panel_btn_handler": Lino.row_action_handler('duplicate_row'), "text": "Duplizieren", "overflowText": "Duplizieren", "auto_save": true } ],
  title : "Konten",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "name" }, { "name": "name_fr" }, { "name": "name_en" }, { "type": "int", "name": "seqno" }, { "name": "chart" },'chartHidden', { "name": "group" },'groupHidden', { "name": "ref" }, { "name": "type" },'typeHidden', { "name": "help_text" }, { "type": "boolean", "name": "required_for_household" }, { "type": "boolean", "name": "required_for_person" }, { "type": "float", "name": "periods" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 44,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 17,
  initComponent : function() {
    var ww = this.containing_window;
    var id1255 = new Ext.form.NumberField({ "selectOnFocus": true });
    var name1256 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_fr1257 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_en1258 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var seqno1259 = new Ext.form.NumberField({ "selectOnFocus": true });
    var chart1260 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/accounts/Accounts/chart", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Kontenplan ausw\u00e4hlen..." });
    var group1261 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/accounts/Accounts/group", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Kontengruppe ausw\u00e4hlen..." });
    var ref1262 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var type1263 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.accounts.AccountTypes });
    var help_text1264 = new Lino.RichTextPanel({ "selectOnFocus": true, "containing_panel": this, "title": "Einleitung" });
    var required_for_household1265 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var required_for_person1266 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var periods1267 = { "xtype": "numberfield", "allowDecimals": false, "selectOnFocus": true, "value": 1, "allowBlank": false };
    this.before_row_edit = function(record) {
      help_text1264.refresh();
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "renderer": Lino.id_renderer, "hidden": false, "editor": id1255, "dataIndex": "id" }, { "colIndex": 1, "sortable": true, "header": "Bezeichnung", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name", "hidden": false, "editor": name1256 }, { "colIndex": 2, "sortable": true, "header": "Bezeichnung (fr)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name_fr", "hidden": false, "editor": name_fr1257 }, { "colIndex": 3, "sortable": true, "header": "Bezeichnung (en)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name_en", "hidden": false, "editor": name_en1258 }, { "colIndex": 4, "sortable": true, "header": "Seq.-Nr.", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "dataIndex": "seqno", "hidden": false, "editor": seqno1259 }, { "colIndex": 5, "sortable": true, "header": "Kontenplan", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('chartHidden','Lino.accounts.Charts.detail'), "hidden": false, "editor": chart1260, "dataIndex": "chart" }, { "colIndex": 6, "sortable": true, "header": "Kontengruppe", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('groupHidden','Lino.accounts.Groups.detail'), "hidden": false, "editor": group1261, "dataIndex": "group" }, { "colIndex": 7, "sortable": true, "header": "ref", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "ref", "hidden": false, "editor": ref1262 }, { "colIndex": 8, "sortable": true, "header": "Kontenart", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(15), "dataIndex": "type", "hidden": false, "editor": type1263 }, { "colIndex": 9, "sortable": false, "header": "help_text", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(60), "renderer": Lino.text_renderer, "hidden": false, "editor": help_text1264, "dataIndex": "help_text" }, { "colIndex": 10, "sortable": false, "xtype": "checkcolumn", "header": "verpflichtend f\u00fcr Haushalte", "editable": true, "filter": { "type": "boolean" }, "width": Lino.chars2width(10), "dataIndex": "required_for_household", "hidden": false }, { "colIndex": 11, "sortable": false, "xtype": "checkcolumn", "header": "verpflichtend f\u00fcr Personen", "editable": true, "filter": { "type": "boolean" }, "width": Lino.chars2width(10), "dataIndex": "required_for_person", "hidden": false }, { "colIndex": 12, "sortable": true, "xtype": "numbercolumn", "format": "0/i", "align": "right", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(3), "dataIndex": "periods", "header": "Perioden", "hidden": false, "editor": periods1267 } ];
    Lino.accounts.Accounts.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.accounts.Accounts.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.accounts.Accounts.GridPanel(p);
});
Lino.accounts.Accounts.duplicate_row = function(rp,pk) { 
  Lino.run_row_action(rp,"/accounts/Accounts",pk,"duplicate_row");
};

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUInotes.NoteTypesHandle
Lino.notes.NoteTypes.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/notes/NoteTypes",
  ls_bbar_actions : [ { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true } ],
  title : "Notizarten",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "name" }, { "name": "name_fr" }, { "name": "name_en" }, { "name": "build_method" },'build_methodHidden', { "name": "template" }, { "type": "int", "name": "id" }, { "type": "boolean", "name": "attach_to_email" }, { "name": "email_template" }, { "type": "boolean", "name": "important" }, { "name": "remark" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 6,
  ls_grid_configs : [  ],
  content_type : 91,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 12,
  initComponent : function() {
    this.ls_detail_handler = Lino.notes.NoteTypes.detail;
    this.ls_insert_handler = Lino.notes.NoteTypes.insert;
    var ww = this.containing_window;
    var name1269 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_fr1270 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_en1271 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var build_method1272 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "appyodt", "AppyOdtBuildMethod" ], [ "appypdf", "AppyPdfBuildMethod" ], [ "appyrtf", "AppyRtfBuildMethod" ], [ "latex", "LatexBuildMethod" ], [ "pisa", "PisaBuildMethod" ], [ "rtf", "RtfBuildMethod" ] ] });
    var template1273 = new Lino.SimpleRemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/NoteTypes/template", "method": "GET" }) }) });
    var id1274 = new Ext.form.NumberField({ "selectOnFocus": true });
    var attach_to_email1275 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var email_template1276 = new Lino.SimpleRemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/NoteTypes/email_template", "method": "GET" }) }) });
    var important1277 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var remark1278 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    this.before_row_edit = function(record) {
      template1273.setContextValue('build_method',record ? record.data['build_methodHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      build_method1272.on('change',Lino.chooser_handler(template1273,'build_method'));
      Lino.notes.NoteTypes.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Bezeichnung", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name", "hidden": false, "editor": name1269 }, { "colIndex": 1, "sortable": true, "header": "Bezeichnung (fr)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name_fr", "hidden": false, "editor": name_fr1270 }, { "colIndex": 2, "sortable": true, "header": "Bezeichnung (en)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name_en", "hidden": false, "editor": name_en1271 }, { "colIndex": 3, "sortable": true, "header": "Konstruktionsmethode", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "build_method", "hidden": false, "editor": build_method1272 }, { "colIndex": 4, "sortable": true, "header": "Vorlage", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(10), "dataIndex": "template", "hidden": false, "editor": template1273 }, { "colIndex": 5, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "renderer": Lino.id_renderer, "hidden": false, "editor": id1274, "dataIndex": "id" }, { "colIndex": 6, "sortable": false, "xtype": "checkcolumn", "header": "als Anhang per E-Mail", "editable": true, "tooltip": "Whether the printable file should be attached to the email\nwhen creating an email from a mailable of this type.\n", "filter": { "type": "boolean" }, "width": Lino.chars2width(10), "dataIndex": "attach_to_email", "hidden": false }, { "colIndex": 7, "sortable": true, "header": "E-Mail-Vorlage", "editable": true, "tooltip": "The name of the file to be used as template \nwhen creating an email from a mailable of this type.\n", "filter": { "type": "string" }, "width": Lino.chars2width(10), "dataIndex": "email_template", "hidden": false, "editor": email_template1276 }, { "colIndex": 8, "sortable": false, "xtype": "checkcolumn", "header": "wichtig", "editable": true, "filter": { "type": "boolean" }, "width": Lino.chars2width(10), "dataIndex": "important", "hidden": false }, { "colIndex": 9, "sortable": false, "header": "Bemerkungen", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(60), "renderer": Lino.text_renderer, "hidden": false, "editor": remark1278, "dataIndex": "remark" } ];
    Lino.notes.NoteTypes.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.notes.NoteTypes.insertPanel = Ext.extend(Lino.notes.NoteTypes.DetailFormPanel,{
  empty_title: "Neu Notizarten",
  hide_navigator: true,
  ls_bbar_actions: [  ],
  ls_url: "/notes/NoteTypes",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.notes.NoteTypes.detail;
    this.ls_insert_handler = Lino.notes.NoteTypes.insert;
    Lino.notes.NoteTypes.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.notes.NoteTypes.insert = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.notes.NoteTypes.insertPanel(p);
});

Lino.notes.NoteTypes.detailPanel = Ext.extend(Lino.notes.NoteTypes.DetailFormPanel,{
  empty_title: "Detail Notizarten",
  ls_bbar_actions: [  ],
  ls_url: "/notes/NoteTypes",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.notes.NoteTypes.detail;
    this.ls_insert_handler = Lino.notes.NoteTypes.insert;
    Lino.notes.NoteTypes.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.notes.NoteTypes.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.notes.NoteTypes.detailPanel(p);
});
Lino.notes.NoteTypes.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.notes.NoteTypes.GridPanel(p);
});

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUInotes.EventTypesHandle
Lino.notes.EventTypes.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/notes/EventTypes",
  ls_bbar_actions : [ { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true } ],
  title : "Ereignisarten",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "name" }, { "name": "name_fr" }, { "name": "name_en" }, { "type": "int", "name": "id" }, { "name": "remark" }, { "name": "body" }, { "name": "body_fr" }, { "name": "body_en" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 3,
  ls_grid_configs : [  ],
  content_type : 89,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 9,
  initComponent : function() {
    this.ls_detail_handler = Lino.notes.EventTypes.detail;
    this.ls_insert_handler = Lino.notes.EventTypes.insert;
    var ww = this.containing_window;
    var name1280 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_fr1281 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_en1282 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var id1283 = new Ext.form.NumberField({ "selectOnFocus": true });
    var remark1284 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var body1285 = new Lino.RichTextPanel({ "selectOnFocus": true, "containing_panel": this, "title": "Inhalt" });
    var body_fr1286 = new Lino.RichTextPanel({ "selectOnFocus": true, "containing_panel": this, "title": "Inhalt (fr)" });
    var body_en1287 = new Lino.RichTextPanel({ "selectOnFocus": true, "containing_panel": this, "title": "Inhalt (en)" });
    this.before_row_edit = function(record) {
      body1285.refresh();
      body_fr1286.refresh();
      body_en1287.refresh();
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Bezeichnung", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name", "hidden": false, "editor": name1280 }, { "colIndex": 1, "sortable": true, "header": "Bezeichnung (fr)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name_fr", "hidden": false, "editor": name_fr1281 }, { "colIndex": 2, "sortable": true, "header": "Bezeichnung (en)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name_en", "hidden": false, "editor": name_en1282 }, { "colIndex": 3, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "renderer": Lino.id_renderer, "hidden": false, "editor": id1283, "dataIndex": "id" }, { "colIndex": 4, "sortable": false, "header": "Bemerkungen", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(60), "renderer": Lino.text_renderer, "hidden": false, "editor": remark1284, "dataIndex": "remark" }, { "colIndex": 5, "sortable": false, "header": "body", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(60), "renderer": Lino.text_renderer, "hidden": false, "editor": body1285, "dataIndex": "body" }, { "colIndex": 6, "sortable": false, "header": "body_fr", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(60), "renderer": Lino.text_renderer, "hidden": false, "editor": body_fr1286, "dataIndex": "body_fr" }, { "colIndex": 7, "sortable": false, "header": "body_en", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(60), "renderer": Lino.text_renderer, "hidden": false, "editor": body_en1287, "dataIndex": "body_en" } ];
    Lino.notes.EventTypes.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.notes.EventTypes.insertPanel = Ext.extend(Lino.notes.EventTypes.DetailFormPanel,{
  empty_title: "Neu Ereignisarten",
  hide_navigator: true,
  ls_bbar_actions: [  ],
  ls_url: "/notes/EventTypes",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.notes.EventTypes.detail;
    this.ls_insert_handler = Lino.notes.EventTypes.insert;
    Lino.notes.EventTypes.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.notes.EventTypes.insert = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.notes.EventTypes.insertPanel(p);
});

Lino.notes.EventTypes.detailPanel = Ext.extend(Lino.notes.EventTypes.DetailFormPanel,{
  empty_title: "Detail Ereignisarten",
  ls_bbar_actions: [  ],
  ls_url: "/notes/EventTypes",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.notes.EventTypes.detail;
    this.ls_insert_handler = Lino.notes.EventTypes.insert;
    Lino.notes.EventTypes.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.notes.EventTypes.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.notes.EventTypes.detailPanel(p);
});
Lino.notes.EventTypes.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.notes.EventTypes.GridPanel(p);
});

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUInotes.NotesHandle
Lino.notes.Notes.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/notes/Notes",
  ls_bbar_actions : [ { "itemId": "duplicate_row", "menu_item_text": "Duplizieren", "must_save": true, "tooltip": "Duplizieren", "panel_btn_handler": Lino.row_action_handler('duplicate_row'), "iconCls": "x-tbar-duplicate", "overflowText": "Duplizieren", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": "do_print", "menu_item_text": "Drucken", "must_save": true, "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print'), "iconCls": "x-tbar-print", "overflowText": "Drucken", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Cache l\u00f6schen", "must_save": true, "tooltip": "Cache l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('do_clear_cache'), "iconCls": "x-tbar-clearcache", "overflowText": "Cache l\u00f6schen", "auto_save": true }, { "itemId": "create_postings", "menu_item_text": "per Post", "must_save": true, "tooltip": "Create classical mail postings from this", "panel_btn_handler": Lino.row_action_handler('create_postings'), "iconCls": "x-tbar-create-postings", "overflowText": "per Post", "auto_save": true }, { "itemId": "create_mail", "menu_item_text": "per E-Mail", "must_save": true, "tooltip": "Create an email from this", "panel_btn_handler": Lino.row_action_handler('create_mail'), "iconCls": "x-tbar-email_add", "overflowText": "per E-Mail", "auto_save": true } ],
  title : "Ereignisse/Notizen",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "type": "date", "name": "date", "dateFormat": "d.m.Y" }, { "name": "user" },'userHidden', { "name": "event_type" },'event_typeHidden', { "name": "type" },'typeHidden', { "name": "project" },'projectHidden', { "name": "subject" }, { "name": "owner_type" },'owner_typeHidden', { "name": "owner_id" },'owner_idHidden', { "name": "build_time" }, { "name": "language" },'languageHidden', { "name": "company" },'companyHidden', { "name": "owner" }, { "name": "body" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 90,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 23,
  initComponent : function() {
    this.ls_detail_handler = Lino.notes.Notes.detail;
    this.ls_insert_handler = Lino.notes.Notes.insert;
    var ww = this.containing_window;
    var id1289 = new Ext.form.NumberField({ "selectOnFocus": true });
    var date1290 = new Lino.DateField({ "selectOnFocus": true, "allowBlank": false });
    var user1291 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/Notes/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Benutzer ausw\u00e4hlen..." });
    var event_type1292 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/Notes/event_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Ereignisart ausw\u00e4hlen..." });
    var type1293 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/Notes/type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Notizart ausw\u00e4hlen..." });
    var project1294 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/Notes/project", "method": "GET" }) }), "pageSize": 20, "emptyText": "Klient ausw\u00e4hlen..." });
    var subject1295 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var owner_type1296 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/Notes/owner_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Inhaltstyp ausw\u00e4hlen..." });
    var owner_id1297 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/Notes/owner_id", "method": "GET" }) }) });
    var build_time1298 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var language1299 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "allowBlank": false, "store": [ [ "de", "Deutsch" ], [ "fr", "Franz\u00f6sisch" ], [ "en", "Englisch" ] ] });
    var company1300 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/Notes/company", "method": "GET" }) }), "pageSize": 20, "emptyText": "Organisation ausw\u00e4hlen..." });
    var owner_disp1301 = new Ext.form.DisplayField({ "disabled": true });
    var body1302 = new Lino.RichTextPanel({ "selectOnFocus": true, "containing_panel": this, "title": "Inhalt" });
    this.before_row_edit = function(record) {
      owner_id1297.setContextValue('owner_type',record ? record.data['owner_typeHidden'] : undefined);
      body1302.refresh();
    };
    this.onRender = function(ct, position) {
      owner_type1296.on('change',Lino.chooser_handler(owner_id1297,'owner_type'));
      Lino.notes.Notes.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "renderer": Lino.id_renderer, "hidden": false, "editor": id1289, "dataIndex": "id" }, { "colIndex": 1, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Datum", "dataIndex": "date", "hidden": false, "width": Lino.chars2width(8), "editor": date1290 }, { "colIndex": 2, "sortable": true, "header": "Autor", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(15), "dataIndex": "user", "hidden": false, "editor": user1291 }, { "colIndex": 3, "sortable": true, "header": "Ereignisart (Form)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('event_typeHidden','Lino.notes.EventTypes.detail'), "hidden": false, "editor": event_type1292, "dataIndex": "event_type" }, { "colIndex": 4, "sortable": true, "header": "Notizart (Inhalt)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('typeHidden','Lino.notes.NoteTypes.detail'), "hidden": false, "editor": type1293, "dataIndex": "type" }, { "colIndex": 5, "sortable": true, "header": "Klient", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "project", "hidden": false, "editor": project1294 }, { "colIndex": 6, "sortable": true, "header": "Thema", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "subject", "hidden": false, "editor": subject1295 }, { "colIndex": 7, "sortable": true, "header": "Verkn\u00fcpft mit (Modell)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('owner_typeHidden','Lino.lino.ContentTypes.detail'), "hidden": false, "editor": owner_type1296, "dataIndex": "owner_type" }, { "colIndex": 8, "sortable": true, "header": "Verkn\u00fcpft mit (Objekt)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(10), "dataIndex": "owner_id", "hidden": false, "editor": owner_id1297 }, { "width": Lino.chars2width(16), "colIndex": 9, "sortable": true, "dataIndex": "build_time", "header": "Druckdatum", "hidden": false, "editable": false }, { "colIndex": 10, "sortable": true, "header": "Sprache", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "language", "hidden": false, "editor": language1299 }, { "colIndex": 11, "sortable": true, "header": "Organisation", "editable": true, "tooltip": "    An optional third-party Organization that is related to this Note.\n    The note will then be visible in that company's history panel.\n    ", "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "company", "hidden": false, "editor": company1300 }, { "width": Lino.chars2width(30), "colIndex": 12, "sortable": false, "dataIndex": "owner", "header": "Verkn\u00fcpft mit", "hidden": false, "editable": false }, { "colIndex": 13, "sortable": false, "header": "body", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(60), "renderer": Lino.text_renderer, "hidden": false, "editor": body1302, "dataIndex": "body" } ];
    Lino.notes.Notes.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.notes.Notes.insertPanel = Ext.extend(Lino.notes.Notes.InsertFormPanel,{
  empty_title: "Neu Ereignisse/Notizen",
  hide_navigator: true,
  ls_bbar_actions: [  ],
  ls_url: "/notes/Notes",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.notes.Notes.detail;
    this.ls_insert_handler = Lino.notes.Notes.insert;
    Lino.notes.Notes.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.notes.Notes.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(50), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.notes.Notes.insertPanel(p);
});

Lino.notes.Notes.detailPanel = Ext.extend(Lino.notes.Notes.DetailFormPanel,{
  empty_title: "Detail Ereignisse/Notizen",
  ls_bbar_actions: [ { "itemId": "duplicate_row", "menu_item_text": "Duplizieren", "must_save": true, "tooltip": "Duplizieren", "panel_btn_handler": Lino.row_action_handler('duplicate_row'), "iconCls": "x-tbar-duplicate", "overflowText": "Duplizieren", "auto_save": true }, { "itemId": "do_print", "menu_item_text": "Drucken", "must_save": true, "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print'), "iconCls": "x-tbar-print", "overflowText": "Drucken", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Cache l\u00f6schen", "must_save": true, "tooltip": "Cache l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('do_clear_cache'), "iconCls": "x-tbar-clearcache", "overflowText": "Cache l\u00f6schen", "auto_save": true }, { "itemId": "create_postings", "menu_item_text": "per Post", "must_save": true, "tooltip": "Create classical mail postings from this", "panel_btn_handler": Lino.row_action_handler('create_postings'), "iconCls": "x-tbar-create-postings", "overflowText": "per Post", "auto_save": true }, { "itemId": "create_mail", "menu_item_text": "per E-Mail", "must_save": true, "tooltip": "Create an email from this", "panel_btn_handler": Lino.row_action_handler('create_mail'), "iconCls": "x-tbar-email_add", "overflowText": "per E-Mail", "auto_save": true } ],
  ls_url: "/notes/Notes",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.notes.Notes.detail;
    this.ls_insert_handler = Lino.notes.Notes.insert;
    Lino.notes.Notes.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.notes.Notes.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.notes.Notes.detailPanel(p);
});
Lino.notes.Notes.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.notes.Notes.GridPanel(p);
});

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUIpcsw.ClientContactTypesHandle
Lino.pcsw.ClientContactTypes.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/pcsw/ClientContactTypes",
  ls_bbar_actions : [  ],
  title : "Klientenkontaktarten",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "name" }, { "name": "name_fr" }, { "name": "name_en" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 49,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 5,
  initComponent : function() {
    var ww = this.containing_window;
    var id1304 = new Ext.form.NumberField({ "selectOnFocus": true });
    var name1305 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_fr1306 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_en1307 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "renderer": Lino.id_renderer, "hidden": false, "editor": id1304, "dataIndex": "id" }, { "colIndex": 1, "sortable": true, "header": "Bezeichnung", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name", "hidden": false, "editor": name1305 }, { "colIndex": 2, "sortable": true, "header": "Bezeichnung (fr)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name_fr", "hidden": false, "editor": name_fr1306 }, { "colIndex": 3, "sortable": true, "header": "Bezeichnung (en)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name_en", "hidden": false, "editor": name_en1307 } ];
    Lino.pcsw.ClientContactTypes.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.pcsw.ClientContactTypes.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.pcsw.ClientContactTypes.GridPanel(p);
});

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUIpcsw.ClientContactsHandle
Lino.pcsw.ClientContacts.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/pcsw/ClientContacts",
  ls_bbar_actions : [  ],
  title : "Klientenkontakte",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "company" },'companyHidden', { "name": "contact_person" },'contact_personHidden', { "name": "contact_role" },'contact_roleHidden', { "name": "client" },'clientHidden', { "name": "type" },'typeHidden', { "name": "remark" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 48,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 13,
  initComponent : function() {
    var ww = this.containing_window;
    var id1309 = new Ext.form.NumberField({ "selectOnFocus": true });
    var company1310 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/ClientContacts/company", "method": "GET" }) }), "pageSize": 20, "emptyText": "Organisation ausw\u00e4hlen..." });
    var contact_person1311 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/ClientContacts/contact_person", "method": "GET" }) }), "pageSize": 20, "emptyText": "Person ausw\u00e4hlen..." });
    var contact_role1312 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/ClientContacts/contact_role", "method": "GET" }) }), "pageSize": 20, "emptyText": "Funktion ausw\u00e4hlen..." });
    var client1313 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/ClientContacts/client", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Klient ausw\u00e4hlen..." });
    var type1314 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/ClientContacts/type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Klientenkontaktart ausw\u00e4hlen..." });
    var remark1315 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    this.before_row_edit = function(record) {
      company1310.setContextValue('type',record ? record.data['typeHidden'] : undefined);
      contact_person1311.setContextValue('company',record ? record.data['companyHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      type1314.on('change',Lino.chooser_handler(company1310,'type'));
      company1310.on('change',Lino.chooser_handler(contact_person1311,'company'));
      Lino.pcsw.ClientContacts.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "renderer": Lino.id_renderer, "hidden": false, "editor": id1309, "dataIndex": "id" }, { "colIndex": 1, "sortable": true, "header": "Organisation", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "company", "hidden": false, "editor": company1310 }, { "colIndex": 2, "sortable": true, "header": "Kontaktperson", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "contact_person", "hidden": false, "editor": contact_person1311 }, { "colIndex": 3, "sortable": true, "header": "in seiner Eigenschaft als", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "contact_role", "hidden": false, "editor": contact_role1312 }, { "colIndex": 4, "sortable": true, "header": "Klient", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "client", "hidden": false, "editor": client1313 }, { "colIndex": 5, "sortable": true, "header": "Klientenkontaktart", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "type", "hidden": false, "editor": type1314 }, { "colIndex": 6, "sortable": false, "header": "Bemerkungen", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(60), "renderer": Lino.text_renderer, "hidden": false, "editor": remark1315, "dataIndex": "remark" } ];
    Lino.pcsw.ClientContacts.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.pcsw.ClientContacts.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.pcsw.ClientContacts.GridPanel(p);
});

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUIpcsw.CoachingsHandle
Lino.pcsw.Coachings.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/pcsw/Coachings",
  ls_bbar_actions : [  ],
  title : "Begleitungen",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "user" },'userHidden', { "name": "client" },'clientHidden', { "type": "date", "name": "start_date", "dateFormat": "d.m.Y" }, { "type": "date", "name": "end_date", "dateFormat": "d.m.Y" }, { "name": "type" },'typeHidden', { "type": "boolean", "name": "primary" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 50,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 11,
  initComponent : function() {
    var ww = this.containing_window;
    var id1317 = new Ext.form.NumberField({ "selectOnFocus": true });
    var user1318 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Coachings/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Benutzer ausw\u00e4hlen..." });
    var client1319 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Coachings/client", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Klient ausw\u00e4hlen..." });
    var start_date1320 = new Lino.DateField({ "selectOnFocus": true });
    var end_date1321 = new Lino.DateField({ "selectOnFocus": true });
    var type1322 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Coachings/type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Dienst ausw\u00e4hlen..." });
    var primary1323 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "renderer": Lino.id_renderer, "hidden": false, "editor": id1317, "dataIndex": "id" }, { "colIndex": 1, "sortable": true, "header": "Begleiter", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(15), "dataIndex": "user", "hidden": false, "editor": user1318 }, { "colIndex": 2, "sortable": true, "header": "Klient", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "client", "hidden": false, "editor": client1319 }, { "colIndex": 3, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Begleitet seit", "dataIndex": "start_date", "hidden": false, "width": Lino.chars2width(8), "editor": start_date1320 }, { "colIndex": 4, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "bis", "dataIndex": "end_date", "hidden": false, "width": Lino.chars2width(8), "editor": end_date1321 }, { "colIndex": 5, "sortable": true, "header": "Dienst", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "type", "hidden": false, "editor": type1322 }, { "colIndex": 6, "sortable": false, "xtype": "checkcolumn", "header": "Prim\u00e4r", "editable": true, "tooltip": "There's at most one primary coach per client. \nEnabling this field will automatically make the other coachings non-primary.", "filter": { "type": "boolean" }, "width": Lino.chars2width(10), "dataIndex": "primary", "hidden": false } ];
    Lino.pcsw.Coachings.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.pcsw.Coachings.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.pcsw.Coachings.GridPanel(p);
});

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUIcbss.RetrieveTIGroupsRequestsHandle
Lino.cbss.RetrieveTIGroupsRequests.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/cbss/RetrieveTIGroupsRequests",
  ls_bbar_actions : [ { "itemId": "duplicate_row", "menu_item_text": "Duplizieren", "must_save": true, "tooltip": "Duplizieren", "panel_btn_handler": Lino.row_action_handler('duplicate_row'), "iconCls": "x-tbar-duplicate", "overflowText": "Duplizieren", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": "print_action", "menu_item_text": "Drucken", "must_save": true, "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('print_action'), "iconCls": "x-tbar-print", "overflowText": "Drucken", "auto_save": true } ],
  title : "Tx25-Anfragen",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "user" },'userHidden', { "name": "person" },'personHidden', { "name": "national_id" }, { "name": "language" },'languageHidden', { "type": "boolean", "name": "history" }, { "name": "status" },'statusHidden', { "name": "ticket" }, { "name": "sent" }, { "name": "environment" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 88,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 15,
  initComponent : function() {
    this.ls_detail_handler = Lino.cbss.RetrieveTIGroupsRequests.detail;
    this.ls_insert_handler = Lino.cbss.RetrieveTIGroupsRequests.insert;
    var ww = this.containing_window;
    var id1325 = new Ext.form.NumberField({ "selectOnFocus": true });
    var user1326 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cbss/RetrieveTIGroupsRequests/user", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Benutzer ausw\u00e4hlen..." });
    var person1327 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cbss/RetrieveTIGroupsRequests/person", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Klient ausw\u00e4hlen..." });
    var national_id1328 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var language1329 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": Lino.cbss.RequestLanguages });
    var history1330 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var status1331 = new Lino.ChoicesFieldElement({ "disabled": true, "forceSelection": true, "store": Lino.cbss.RequestStates });
    var ticket1332 = new Ext.form.TextField({ "disabled": true, "maxLength": 36 });
    var sent1333 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var environment1334 = new Ext.form.TextField({ "disabled": true, "boxMinWidth": Lino.chars2width(4), "maxLength": 4 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "renderer": Lino.id_renderer, "hidden": false, "editor": id1325, "dataIndex": "id" }, { "colIndex": 1, "sortable": true, "header": "Autor", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(15), "dataIndex": "user", "hidden": false, "editor": user1326 }, { "colIndex": 2, "sortable": true, "header": "Klient", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "person", "hidden": false, "editor": person1327 }, { "colIndex": 3, "sortable": true, "header": "NR-Nummer", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "national_id", "hidden": false, "editor": national_id1328 }, { "colIndex": 4, "sortable": true, "header": "Sprache", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(14), "dataIndex": "language", "hidden": false, "editor": language1329 }, { "colIndex": 5, "sortable": false, "xtype": "checkcolumn", "header": "Chronik", "editable": true, "tooltip": "Whatever this means.", "filter": { "type": "boolean" }, "width": Lino.chars2width(10), "dataIndex": "history", "hidden": false }, { "colIndex": 6, "sortable": true, "header": "Zustand", "editable": false, "filter": { "type": "string" }, "width": Lino.chars2width(15), "dataIndex": "status", "hidden": false }, { "colIndex": 7, "sortable": true, "header": "Ticket", "editable": false, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "ticket", "hidden": false }, { "colIndex": 8, "sortable": true, "header": "Versendet", "editable": false, "tooltip": "The date and time when this request has been executed. \nThis is empty for requests than haven't been sent.\nRead-only.", "width": Lino.chars2width(16), "dataIndex": "sent", "hidden": false }, { "colIndex": 9, "sortable": true, "header": "T/A/B", "editable": false, "filter": { "type": "string" }, "width": Lino.chars2width(5), "dataIndex": "environment", "hidden": false } ];
    Lino.cbss.RetrieveTIGroupsRequests.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.cbss.RetrieveTIGroupsRequests.insertPanel = Ext.extend(Lino.cbss.RetrieveTIGroupsRequests.InsertFormPanel,{
  empty_title: "Neu Tx25-Anfragen",
  hide_navigator: true,
  ls_bbar_actions: [  ],
  ls_url: "/cbss/RetrieveTIGroupsRequests",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.cbss.RetrieveTIGroupsRequests.detail;
    this.ls_insert_handler = Lino.cbss.RetrieveTIGroupsRequests.insert;
    Lino.cbss.RetrieveTIGroupsRequests.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.cbss.RetrieveTIGroupsRequests.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(40), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.cbss.RetrieveTIGroupsRequests.insertPanel(p);
});

Lino.cbss.RetrieveTIGroupsRequests.detailPanel = Ext.extend(Lino.cbss.RetrieveTIGroupsRequests.DetailFormPanel,{
  empty_title: "Detail Tx25-Anfragen",
  ls_bbar_actions: [ { "itemId": "duplicate_row", "menu_item_text": "Duplizieren", "must_save": true, "tooltip": "Duplizieren", "panel_btn_handler": Lino.row_action_handler('duplicate_row'), "iconCls": "x-tbar-duplicate", "overflowText": "Duplizieren", "auto_save": true }, { "itemId": "print_action", "menu_item_text": "Drucken", "must_save": true, "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('print_action'), "iconCls": "x-tbar-print", "overflowText": "Drucken", "auto_save": true } ],
  ls_url: "/cbss/RetrieveTIGroupsRequests",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.cbss.RetrieveTIGroupsRequests.detail;
    this.ls_insert_handler = Lino.cbss.RetrieveTIGroupsRequests.insert;
    Lino.cbss.RetrieveTIGroupsRequests.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.cbss.RetrieveTIGroupsRequests.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cbss.RetrieveTIGroupsRequests.detailPanel(p);
});
Lino.cbss.RetrieveTIGroupsRequests.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cbss.RetrieveTIGroupsRequests.GridPanel(p);
});

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUIcourses.CoursesHandle
Lino.courses.Courses.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/courses/Courses",
  ls_bbar_actions : [ { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": "print_candidates", "menu_item_text": "Kandidatenliste", "must_save": true, "tooltip": "Kandidatenliste", "panel_btn_handler": Lino.row_action_handler('print_candidates'), "iconCls": "x-tbar-print", "overflowText": "Kandidatenliste", "auto_save": true }, { "itemId": "print_participants", "menu_item_text": "Teilnehmerliste", "must_save": true, "tooltip": "Teilnehmerliste", "panel_btn_handler": Lino.row_action_handler('print_participants'), "iconCls": "x-tbar-print", "overflowText": "Teilnehmerliste", "auto_save": true } ],
  title : "Kurse",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "offer" },'offerHidden', { "name": "title" }, { "type": "date", "name": "start_date", "dateFormat": "d.m.Y" }, { "name": "remark" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 92,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 7,
  initComponent : function() {
    this.ls_detail_handler = Lino.courses.Courses.detail;
    this.ls_insert_handler = Lino.courses.Courses.insert;
    var ww = this.containing_window;
    var id1336 = new Ext.form.NumberField({ "selectOnFocus": true });
    var offer1337 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/courses/Courses/offer", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Kursangebot ausw\u00e4hlen..." });
    var title1338 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var start_date1339 = new Lino.DateField({ "selectOnFocus": true, "allowBlank": false });
    var remark1340 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "renderer": Lino.id_renderer, "hidden": false, "editor": id1336, "dataIndex": "id" }, { "colIndex": 1, "sortable": true, "header": "Kursangebot", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('offerHidden','Lino.courses.CourseOffers.detail'), "hidden": false, "editor": offer1337, "dataIndex": "offer" }, { "colIndex": 2, "sortable": true, "header": "Name", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "title", "hidden": false, "editor": title1338 }, { "colIndex": 3, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "beginnt am", "dataIndex": "start_date", "hidden": false, "width": Lino.chars2width(8), "editor": start_date1339 }, { "colIndex": 4, "sortable": true, "header": "Bemerkungen", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "remark", "hidden": false, "editor": remark1340 } ];
    Lino.courses.Courses.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.courses.Courses.insertPanel = Ext.extend(Lino.courses.Courses.DetailFormPanel,{
  empty_title: "Neu Kurse",
  hide_navigator: true,
  ls_bbar_actions: [  ],
  ls_url: "/courses/Courses",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.courses.Courses.detail;
    this.ls_insert_handler = Lino.courses.Courses.insert;
    Lino.courses.Courses.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.courses.Courses.insert = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.courses.Courses.insertPanel(p);
});

Lino.courses.Courses.detailPanel = Ext.extend(Lino.courses.Courses.DetailFormPanel,{
  empty_title: "Detail Kurse",
  ls_bbar_actions: [ { "itemId": "print_candidates", "menu_item_text": "Kandidatenliste", "must_save": true, "tooltip": "Kandidatenliste", "panel_btn_handler": Lino.row_action_handler('print_candidates'), "iconCls": "x-tbar-print", "overflowText": "Kandidatenliste", "auto_save": true }, { "itemId": "print_participants", "menu_item_text": "Teilnehmerliste", "must_save": true, "tooltip": "Teilnehmerliste", "panel_btn_handler": Lino.row_action_handler('print_participants'), "iconCls": "x-tbar-print", "overflowText": "Teilnehmerliste", "auto_save": true } ],
  ls_url: "/courses/Courses",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.courses.Courses.detail;
    this.ls_insert_handler = Lino.courses.Courses.insert;
    Lino.courses.Courses.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.courses.Courses.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.courses.Courses.detailPanel(p);
});
Lino.courses.Courses.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.courses.Courses.GridPanel(p);
});

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUIcourses.CourseContentsHandle
Lino.courses.CourseContents.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/courses/CourseContents",
  ls_bbar_actions : [  ],
  title : "Kursinhalte",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "name" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 93,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 3,
  initComponent : function() {
    var ww = this.containing_window;
    var id1342 = new Ext.form.NumberField({ "selectOnFocus": true });
    var name1343 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "renderer": Lino.id_renderer, "hidden": false, "editor": id1342, "dataIndex": "id" }, { "colIndex": 1, "sortable": true, "header": "Name", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name", "hidden": false, "editor": name1343 } ];
    Lino.courses.CourseContents.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.courses.CourseContents.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.courses.CourseContents.GridPanel(p);
});

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUIcourses.CourseOffersHandle
Lino.courses.CourseOffers.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/courses/CourseOffers",
  ls_bbar_actions : [ { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true } ],
  title : "Kursangebote",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "title" }, { "name": "content" },'contentHidden', { "name": "provider" },'providerHidden', { "name": "description" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 94,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 8,
  initComponent : function() {
    this.ls_detail_handler = Lino.courses.CourseOffers.detail;
    this.ls_insert_handler = Lino.courses.CourseOffers.insert;
    var ww = this.containing_window;
    var id1345 = new Ext.form.NumberField({ "selectOnFocus": true });
    var title1346 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var content1347 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/courses/CourseOffers/content", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Kursinhalt ausw\u00e4hlen..." });
    var provider1348 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/courses/CourseOffers/provider", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Kursanbieter ausw\u00e4hlen..." });
    var description1349 = new Lino.RichTextPanel({ "selectOnFocus": true, "containing_panel": this, "title": "Beschreibung" });
    this.before_row_edit = function(record) {
      description1349.refresh();
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "renderer": Lino.id_renderer, "hidden": false, "editor": id1345, "dataIndex": "id" }, { "colIndex": 1, "sortable": true, "header": "Name", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "title", "hidden": false, "editor": title1346 }, { "colIndex": 2, "sortable": true, "header": "Kursinhalt", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "content", "hidden": false, "editor": content1347 }, { "colIndex": 3, "sortable": true, "header": "Kursanbieter", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "provider", "hidden": false, "editor": provider1348 }, { "colIndex": 4, "sortable": false, "header": "description", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(60), "renderer": Lino.text_renderer, "hidden": false, "editor": description1349, "dataIndex": "description" } ];
    Lino.courses.CourseOffers.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.courses.CourseOffers.insertPanel = Ext.extend(Lino.courses.CourseOffers.DetailFormPanel,{
  empty_title: "Neu Kursangebote",
  hide_navigator: true,
  ls_bbar_actions: [  ],
  ls_url: "/courses/CourseOffers",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.courses.CourseOffers.detail;
    this.ls_insert_handler = Lino.courses.CourseOffers.insert;
    Lino.courses.CourseOffers.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.courses.CourseOffers.insert = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.courses.CourseOffers.insertPanel(p);
});

Lino.courses.CourseOffers.detailPanel = Ext.extend(Lino.courses.CourseOffers.DetailFormPanel,{
  empty_title: "Detail Kursangebote",
  ls_bbar_actions: [  ],
  ls_url: "/courses/CourseOffers",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.courses.CourseOffers.detail;
    this.ls_insert_handler = Lino.courses.CourseOffers.insert;
    Lino.courses.CourseOffers.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.courses.CourseOffers.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.courses.CourseOffers.detailPanel(p);
});
Lino.courses.CourseOffers.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.courses.CourseOffers.GridPanel(p);
});

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUIpcsw.WantedLanguageKnowledgeTableHandle
Lino.pcsw.WantedLanguageKnowledgeTable.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/pcsw/WantedLanguageKnowledgeTable",
  ls_bbar_actions : [  ],
  title : "wanted language knowledges",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "search" },'searchHidden', { "name": "language" },'languageHidden', { "name": "spoken" },'spokenHidden', { "name": "written" },'writtenHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 58,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 10,
  initComponent : function() {
    var ww = this.containing_window;
    var id1351 = new Ext.form.NumberField({ "selectOnFocus": true });
    var search1352 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/WantedLanguageKnowledgeTable/search", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Personensuche ausw\u00e4hlen..." });
    var language1353 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/WantedLanguageKnowledgeTable/language", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Sprache ausw\u00e4hlen..." });
    var spoken1354 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": Lino.properties.HowWell });
    var written1355 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": Lino.properties.HowWell });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "renderer": Lino.id_renderer, "hidden": false, "editor": id1351, "dataIndex": "id" }, { "colIndex": 1, "sortable": true, "header": "Personensuche", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "search", "hidden": false, "editor": search1352 }, { "colIndex": 2, "sortable": true, "header": "Sprache", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('languageHidden','Lino.countries.Languages.detail'), "hidden": false, "editor": language1353, "dataIndex": "language" }, { "colIndex": 3, "sortable": true, "header": "Wort", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "spoken", "hidden": false, "editor": spoken1354 }, { "colIndex": 4, "sortable": true, "header": "Schrift", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "written", "hidden": false, "editor": written1355 } ];
    Lino.pcsw.WantedLanguageKnowledgeTable.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.pcsw.WantedLanguageKnowledgeTable.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.pcsw.WantedLanguageKnowledgeTable.GridPanel(p);
});

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUIsessions.SessionTableHandle
Lino.sessions.SessionTable.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/sessions/SessionTable",
  ls_bbar_actions : [  ],
  title : "Sitzungen",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "session_key" }, { "name": "session_data" }, { "name": "expire_date" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 2,
  ls_id_property : "session_key",
  gc_name : 0,
  disabled_actions_index : 4,
  initComponent : function() {
    var ww = this.containing_window;
    var session_key1357 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 40 });
    var session_data1358 = new Ext.form.TextArea({ "selectOnFocus": true, "allowBlank": false, "growMax": 2000 });
    var expire_date1359 = new Ext.form.DisplayField({ "selectOnFocus": true, "allowBlank": false, "value": "<br>" });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Sitzungs-ID", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "session_key", "hidden": false, "editor": session_key1357 }, { "colIndex": 1, "sortable": false, "header": "Sitzungsdaten", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(60), "renderer": Lino.text_renderer, "hidden": false, "editor": session_data1358, "dataIndex": "session_data" }, { "colIndex": 2, "sortable": true, "header": "Verfallsdatum", "editable": true, "width": Lino.chars2width(16), "dataIndex": "expire_date", "hidden": false, "editor": expire_date1359 } ];
    Lino.sessions.SessionTable.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.sessions.SessionTable.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.sessions.SessionTable.GridPanel(p);
});

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUIproperties.WantedSkillTableHandle
Lino.properties.WantedSkillTable.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/properties/WantedSkillTable",
  ls_bbar_actions : [  ],
  title : "Gesuchte Eigenschaften",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "group" },'groupHidden', { "name": "property" },'propertyHidden', { "name": "value" },'valueHidden', { "name": "search" },'searchHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 18,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 10,
  initComponent : function() {
    var ww = this.containing_window;
    var id1361 = new Ext.form.NumberField({ "selectOnFocus": true });
    var group1362 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/properties/WantedSkillTable/group", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Eigenschaftsgruppe ausw\u00e4hlen..." });
    var property1363 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/properties/WantedSkillTable/property", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Eigenschaft ausw\u00e4hlen..." });
    var value1364 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/properties/WantedSkillTable/value", "method": "GET" }) }) });
    var search1365 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/properties/WantedSkillTable/search", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Personensuche ausw\u00e4hlen..." });
    this.before_row_edit = function(record) {
      property1363.setContextValue('group',record ? record.data['groupHidden'] : undefined);
      value1364.setContextValue('property',record ? record.data['propertyHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      group1362.on('change',Lino.chooser_handler(property1363,'group'));
      property1363.on('change',Lino.chooser_handler(value1364,'property'));
      Lino.properties.WantedSkillTable.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "renderer": Lino.id_renderer, "hidden": false, "editor": id1361, "dataIndex": "id" }, { "colIndex": 1, "sortable": true, "header": "Eigenschaftsgruppe", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('groupHidden','Lino.properties.PropGroups.detail'), "hidden": false, "editor": group1362, "dataIndex": "group" }, { "colIndex": 2, "sortable": true, "header": "Eigenschaft", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('propertyHidden','Lino.properties.Properties.detail'), "hidden": false, "editor": property1363, "dataIndex": "property" }, { "colIndex": 3, "sortable": true, "header": "Wert", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(10), "dataIndex": "value", "hidden": false, "editor": value1364 }, { "colIndex": 4, "sortable": true, "header": "Personensuche", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "search", "hidden": false, "editor": search1365 } ];
    Lino.properties.WantedSkillTable.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.properties.WantedSkillTable.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.properties.WantedSkillTable.GridPanel(p);
});

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUIproperties.UnwantedSkillTableHandle
Lino.properties.UnwantedSkillTable.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/properties/UnwantedSkillTable",
  ls_bbar_actions : [  ],
  title : "Unerw\u00fcnschte Eigenschaften",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "group" },'groupHidden', { "name": "property" },'propertyHidden', { "name": "value" },'valueHidden', { "name": "search" },'searchHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 17,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 10,
  initComponent : function() {
    var ww = this.containing_window;
    var id1367 = new Ext.form.NumberField({ "selectOnFocus": true });
    var group1368 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/properties/UnwantedSkillTable/group", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Eigenschaftsgruppe ausw\u00e4hlen..." });
    var property1369 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/properties/UnwantedSkillTable/property", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Eigenschaft ausw\u00e4hlen..." });
    var value1370 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/properties/UnwantedSkillTable/value", "method": "GET" }) }) });
    var search1371 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/properties/UnwantedSkillTable/search", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Personensuche ausw\u00e4hlen..." });
    this.before_row_edit = function(record) {
      property1369.setContextValue('group',record ? record.data['groupHidden'] : undefined);
      value1370.setContextValue('property',record ? record.data['propertyHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      group1368.on('change',Lino.chooser_handler(property1369,'group'));
      property1369.on('change',Lino.chooser_handler(value1370,'property'));
      Lino.properties.UnwantedSkillTable.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "renderer": Lino.id_renderer, "hidden": false, "editor": id1367, "dataIndex": "id" }, { "colIndex": 1, "sortable": true, "header": "Eigenschaftsgruppe", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('groupHidden','Lino.properties.PropGroups.detail'), "hidden": false, "editor": group1368, "dataIndex": "group" }, { "colIndex": 2, "sortable": true, "header": "Eigenschaft", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('propertyHidden','Lino.properties.Properties.detail'), "hidden": false, "editor": property1369, "dataIndex": "property" }, { "colIndex": 3, "sortable": true, "header": "Wert", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(10), "dataIndex": "value", "hidden": false, "editor": value1370 }, { "colIndex": 4, "sortable": true, "header": "Personensuche", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "search", "hidden": false, "editor": search1371 } ];
    Lino.properties.UnwantedSkillTable.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.properties.UnwantedSkillTable.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.properties.UnwantedSkillTable.GridPanel(p);
});

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUIusers.AuthoritiesGivenHandle
Lino.users.AuthoritiesGiven.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/users/AuthoritiesGiven",
  ls_bbar_actions : [  ],
  title : "Erteilte Vollmachten",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "authorized" },'authorizedHidden', { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 2,
  ls_grid_configs : [  ],
  content_type : 7,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 4,
  initComponent : function() {
    var ww = this.containing_window;
    var authorized248 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/AuthoritiesGiven/authorized", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Benutzer ausw\u00e4hlen..." });
    this.before_row_edit = function(record) {
      var bp = this.get_base_params();
      authorized248.setContextValue('mk',bp['mk']);
      authorized248.setContextValue('mt',bp['mt']);
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Benutzer", "editable": true, "tooltip": "The user who gets authority to act in your name.", "filter": { "type": "string" }, "width": Lino.chars2width(15), "dataIndex": "authorized", "hidden": false, "editor": authorized248 } ];
    Lino.users.AuthoritiesGiven.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.users.AuthoritiesGiven.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.users.AuthoritiesGiven.GridPanel(p);
});

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUIusers.AuthoritiesTakenHandle
Lino.users.AuthoritiesTaken.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/users/AuthoritiesTaken",
  ls_bbar_actions : [  ],
  title : "Erhaltene Vollmachten",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "user" },'userHidden', { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 2,
  ls_grid_configs : [  ],
  content_type : 7,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 4,
  initComponent : function() {
    var ww = this.containing_window;
    var user1373 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/AuthoritiesTaken/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Benutzer ausw\u00e4hlen..." });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Autor", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(15), "dataIndex": "user", "hidden": false, "editor": user1373 } ];
    Lino.users.AuthoritiesTaken.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.users.AuthoritiesTaken.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.users.AuthoritiesTaken.GridPanel(p);
});

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUIcountries.CitiesByCityHandle
Lino.countries.CitiesByCity.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/countries/CitiesByCity",
  ls_bbar_actions : [ { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true } ],
  title : "Orte",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "name" }, { "name": "type" },'typeHidden', { "name": "zip_code" }, { "type": "int", "name": "id" }, { "name": "country" },'countryHidden', { "name": "inscode" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 4,
  ls_grid_configs : [  ],
  content_type : 11,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 9,
  initComponent : function() {
    this.ls_detail_handler = Lino.countries.CitiesByCity.detail;
    this.ls_insert_handler = Lino.countries.CitiesByCity.insert;
    var ww = this.containing_window;
    var name655 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var type656 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/countries/CitiesByCity/type", "method": "GET" }) }) });
    var zip_code657 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(8), "maxLength": 8 });
    var id658 = new Ext.form.NumberField({ "selectOnFocus": true });
    var country659 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/countries/CitiesByCity/country", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Land ausw\u00e4hlen..." });
    var inscode660 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(5), "maxLength": 5 });
    this.before_row_edit = function(record) {
      type656.setContextValue('country',record ? record.data['countryHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      country659.on('change',Lino.chooser_handler(type656,'country'));
      Lino.countries.CitiesByCity.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "name", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name", "hidden": false, "editor": name655 }, { "colIndex": 1, "sortable": true, "header": "Ortsart", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(10), "dataIndex": "type", "hidden": false, "editor": type656 }, { "colIndex": 2, "sortable": true, "header": "zip code", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(9), "dataIndex": "zip_code", "hidden": false, "editor": zip_code657 }, { "colIndex": 3, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "renderer": Lino.id_renderer, "hidden": false, "editor": id658, "dataIndex": "id" }, { "colIndex": 4, "sortable": true, "header": "Land", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('countryHidden','Lino.countries.Countries.detail'), "hidden": false, "editor": country659, "dataIndex": "country" }, { "colIndex": 5, "sortable": true, "header": "INS-Code", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(6), "dataIndex": "inscode", "hidden": false, "editor": inscode660 } ];
    Lino.countries.CitiesByCity.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.countries.CitiesByCity.insertPanel = Ext.extend(Lino.countries.Cities.DetailFormPanel,{
  empty_title: "Neu Orte",
  hide_navigator: true,
  ls_bbar_actions: [  ],
  ls_url: "/countries/CitiesByCity",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.countries.CitiesByCity.detail;
    this.ls_insert_handler = Lino.countries.CitiesByCity.insert;
    Lino.countries.CitiesByCity.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.countries.CitiesByCity.insert = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.countries.CitiesByCity.insertPanel(p);
});

Lino.countries.CitiesByCity.detailPanel = Ext.extend(Lino.countries.Cities.DetailFormPanel,{
  empty_title: "Detail Orte",
  ls_bbar_actions: [  ],
  ls_url: "/countries/CitiesByCity",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.countries.CitiesByCity.detail;
    this.ls_insert_handler = Lino.countries.CitiesByCity.insert;
    Lino.countries.CitiesByCity.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.countries.CitiesByCity.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.countries.CitiesByCity.detailPanel(p);
});
Lino.countries.CitiesByCity.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.countries.CitiesByCity.GridPanel(p);
});

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUIcountries.CitiesByCountryHandle
Lino.countries.CitiesByCountry.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/countries/CitiesByCountry",
  ls_bbar_actions : [ { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true } ],
  title : "Orte",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "name" }, { "name": "type" },'typeHidden', { "name": "zip_code" }, { "type": "int", "name": "id" }, { "name": "parent" },'parentHidden', { "name": "inscode" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 4,
  ls_grid_configs : [  ],
  content_type : 11,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 9,
  initComponent : function() {
    this.ls_detail_handler = Lino.countries.CitiesByCountry.detail;
    this.ls_insert_handler = Lino.countries.CitiesByCountry.insert;
    var ww = this.containing_window;
    var name1093 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var type1094 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/countries/CitiesByCountry/type", "method": "GET" }) }) });
    var zip_code1095 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(8), "maxLength": 8 });
    var id1096 = new Ext.form.NumberField({ "selectOnFocus": true });
    var parent1097 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/countries/CitiesByCountry/parent", "method": "GET" }) }), "pageSize": 20, "emptyText": "Ort ausw\u00e4hlen..." });
    var inscode1098 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(5), "maxLength": 5 });
    this.before_row_edit = function(record) {
      var bp = this.get_base_params();
      type1094.setContextValue('mk',bp['mk']);
      type1094.setContextValue('mt',bp['mt']);
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "name", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name", "hidden": false, "editor": name1093 }, { "colIndex": 1, "sortable": true, "header": "Ortsart", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(10), "dataIndex": "type", "hidden": false, "editor": type1094 }, { "colIndex": 2, "sortable": true, "header": "zip code", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(9), "dataIndex": "zip_code", "hidden": false, "editor": zip_code1095 }, { "colIndex": 3, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "renderer": Lino.id_renderer, "hidden": false, "editor": id1096, "dataIndex": "id" }, { "colIndex": 4, "sortable": true, "header": "Teil von", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('parentHidden','Lino.countries.Cities.detail'), "hidden": false, "editor": parent1097, "dataIndex": "parent" }, { "colIndex": 5, "sortable": true, "header": "INS-Code", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(6), "dataIndex": "inscode", "hidden": false, "editor": inscode1098 } ];
    Lino.countries.CitiesByCountry.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.countries.CitiesByCountry.insertPanel = Ext.extend(Lino.countries.Cities.DetailFormPanel,{
  empty_title: "Neu Orte",
  hide_navigator: true,
  ls_bbar_actions: [  ],
  ls_url: "/countries/CitiesByCountry",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.countries.CitiesByCountry.detail;
    this.ls_insert_handler = Lino.countries.CitiesByCountry.insert;
    Lino.countries.CitiesByCountry.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.countries.CitiesByCountry.insert = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.countries.CitiesByCountry.insertPanel(p);
});

Lino.countries.CitiesByCountry.detailPanel = Ext.extend(Lino.countries.Cities.DetailFormPanel,{
  empty_title: "Detail Orte",
  ls_bbar_actions: [  ],
  ls_url: "/countries/CitiesByCountry",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.countries.CitiesByCountry.detail;
    this.ls_insert_handler = Lino.countries.CitiesByCountry.insert;
    Lino.countries.CitiesByCountry.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.countries.CitiesByCountry.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.countries.CitiesByCountry.detailPanel(p);
});
Lino.countries.CitiesByCountry.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.countries.CitiesByCountry.GridPanel(p);
});

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUIproperties.PropsByGroupHandle
Lino.properties.PropsByGroup.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/properties/PropsByGroup",
  ls_bbar_actions : [ { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true } ],
  title : "Eigenschaften",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "name" }, { "name": "name_fr" }, { "name": "name_en" }, { "name": "type" },'typeHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 13,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 7,
  initComponent : function() {
    this.ls_detail_handler = Lino.properties.PropsByGroup.detail;
    this.ls_insert_handler = Lino.properties.PropsByGroup.insert;
    var ww = this.containing_window;
    var id112 = new Ext.form.NumberField({ "selectOnFocus": true });
    var name113 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_fr114 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_en115 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var type116 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/properties/PropsByGroup/type", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Eigenschafts-Datentyp ausw\u00e4hlen..." });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "renderer": Lino.id_renderer, "hidden": false, "editor": id112, "dataIndex": "id" }, { "colIndex": 1, "sortable": true, "header": "Bezeichnung", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name", "hidden": false, "editor": name113 }, { "colIndex": 2, "sortable": true, "header": "Bezeichnung (fr)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name_fr", "hidden": false, "editor": name_fr114 }, { "colIndex": 3, "sortable": true, "header": "Bezeichnung (en)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name_en", "hidden": false, "editor": name_en115 }, { "colIndex": 4, "sortable": true, "header": "Eigenschafts-Datentyp", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('typeHidden','Lino.properties.PropTypes.detail'), "hidden": false, "editor": type116, "dataIndex": "type" } ];
    Lino.properties.PropsByGroup.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.properties.PropsByGroup.insertPanel = Ext.extend(Lino.properties.Properties.DetailFormPanel,{
  empty_title: "Neu Eigenschaften",
  hide_navigator: true,
  ls_bbar_actions: [  ],
  ls_url: "/properties/PropsByGroup",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.properties.PropsByGroup.detail;
    this.ls_insert_handler = Lino.properties.PropsByGroup.insert;
    Lino.properties.PropsByGroup.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.properties.PropsByGroup.insert = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.properties.PropsByGroup.insertPanel(p);
});

Lino.properties.PropsByGroup.detailPanel = Ext.extend(Lino.properties.Properties.DetailFormPanel,{
  empty_title: "Detail Eigenschaften",
  ls_bbar_actions: [  ],
  ls_url: "/properties/PropsByGroup",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.properties.PropsByGroup.detail;
    this.ls_insert_handler = Lino.properties.PropsByGroup.insert;
    Lino.properties.PropsByGroup.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.properties.PropsByGroup.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.properties.PropsByGroup.detailPanel(p);
});
Lino.properties.PropsByGroup.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.properties.PropsByGroup.GridPanel(p);
});

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUIproperties.PropsByTypeHandle
Lino.properties.PropsByType.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/properties/PropsByType",
  ls_bbar_actions : [ { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true } ],
  title : "Eigenschaften",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "name" }, { "name": "name_fr" }, { "name": "name_en" }, { "name": "group" },'groupHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 13,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 7,
  initComponent : function() {
    this.ls_detail_handler = Lino.properties.PropsByType.detail;
    this.ls_insert_handler = Lino.properties.PropsByType.insert;
    var ww = this.containing_window;
    var id1065 = new Ext.form.NumberField({ "selectOnFocus": true });
    var name1066 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_fr1067 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_en1068 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var group1069 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/properties/PropsByType/group", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Eigenschaftsgruppe ausw\u00e4hlen..." });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "renderer": Lino.id_renderer, "hidden": false, "editor": id1065, "dataIndex": "id" }, { "colIndex": 1, "sortable": true, "header": "Bezeichnung", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name", "hidden": false, "editor": name1066 }, { "colIndex": 2, "sortable": true, "header": "Bezeichnung (fr)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name_fr", "hidden": false, "editor": name_fr1067 }, { "colIndex": 3, "sortable": true, "header": "Bezeichnung (en)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name_en", "hidden": false, "editor": name_en1068 }, { "colIndex": 4, "sortable": true, "header": "Eigenschaftsgruppe", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('groupHidden','Lino.properties.PropGroups.detail'), "hidden": false, "editor": group1069, "dataIndex": "group" } ];
    Lino.properties.PropsByType.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.properties.PropsByType.insertPanel = Ext.extend(Lino.properties.Properties.DetailFormPanel,{
  empty_title: "Neu Eigenschaften",
  hide_navigator: true,
  ls_bbar_actions: [  ],
  ls_url: "/properties/PropsByType",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.properties.PropsByType.detail;
    this.ls_insert_handler = Lino.properties.PropsByType.insert;
    Lino.properties.PropsByType.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.properties.PropsByType.insert = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.properties.PropsByType.insertPanel(p);
});

Lino.properties.PropsByType.detailPanel = Ext.extend(Lino.properties.Properties.DetailFormPanel,{
  empty_title: "Detail Eigenschaften",
  ls_bbar_actions: [  ],
  ls_url: "/properties/PropsByType",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.properties.PropsByType.detail;
    this.ls_insert_handler = Lino.properties.PropsByType.insert;
    Lino.properties.PropsByType.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.properties.PropsByType.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.properties.PropsByType.detailPanel(p);
});
Lino.properties.PropsByType.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.properties.PropsByType.GridPanel(p);
});

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUIproperties.ChoicesByTypeHandle
Lino.properties.ChoicesByType.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/properties/ChoicesByType",
  ls_bbar_actions : [  ],
  title : "Auswahlm\u00f6glichkeiten",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "value" }, { "name": "text" }, { "name": "text_fr" }, { "name": "text_en" }, { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 4,
  ls_grid_configs : [  ],
  content_type : 14,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 6,
  initComponent : function() {
    var ww = this.containing_window;
    var value1058 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var text1059 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var text_fr1060 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var text_en1061 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var id1062 = new Ext.form.NumberField({ "selectOnFocus": true });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Wert", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "value", "hidden": false, "editor": value1058 }, { "colIndex": 1, "sortable": true, "header": "Bezeichnung", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "text", "hidden": false, "editor": text1059 }, { "colIndex": 2, "sortable": true, "header": "Bezeichnung (fr)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "text_fr", "hidden": false, "editor": text_fr1060 }, { "colIndex": 3, "sortable": true, "header": "Bezeichnung (en)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "text_en", "hidden": false, "editor": text_en1061 }, { "colIndex": 4, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "renderer": Lino.id_renderer, "hidden": false, "editor": id1062, "dataIndex": "id" } ];
    Lino.properties.ChoicesByType.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.properties.ChoicesByType.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.properties.ChoicesByType.GridPanel(p);
});

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUIcontacts.RolesByCompanyHandle
Lino.contacts.RolesByCompany.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/contacts/RolesByCompany",
  ls_bbar_actions : [  ],
  title : "Kontaktpersonen",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "person" },'personHidden', { "name": "type" },'typeHidden', { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 4,
  ls_grid_configs : [  ],
  content_type : 20,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 6,
  initComponent : function() {
    var ww = this.containing_window;
    var person1375 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/RolesByCompany/person", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Person ausw\u00e4hlen..." });
    var type1376 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/RolesByCompany/type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Funktion ausw\u00e4hlen..." });
    var id1377 = new Ext.form.NumberField({ "selectOnFocus": true });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Person", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "person", "hidden": false, "editor": person1375 }, { "colIndex": 1, "sortable": true, "header": "Funktion", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "type", "hidden": false, "editor": type1376 }, { "colIndex": 2, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "renderer": Lino.id_renderer, "hidden": false, "editor": id1377, "dataIndex": "id" } ];
    Lino.contacts.RolesByCompany.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.RolesByCompany.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.contacts.RolesByCompany.GridPanel(p);
});

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUIcontacts.RolesByPersonHandle
Lino.contacts.RolesByPerson.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/contacts/RolesByPerson",
  ls_bbar_actions : [  ],
  title : "Kontaktperson f\u00fcr",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "company" },'companyHidden', { "name": "type" },'typeHidden', { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 4,
  ls_grid_configs : [  ],
  content_type : 20,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 6,
  initComponent : function() {
    var ww = this.containing_window;
    var company1379 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/RolesByPerson/company", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Organisation ausw\u00e4hlen..." });
    var type1380 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/RolesByPerson/type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Funktion ausw\u00e4hlen..." });
    var id1381 = new Ext.form.NumberField({ "selectOnFocus": true });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Organisation", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "company", "hidden": false, "editor": company1379 }, { "colIndex": 1, "sortable": true, "header": "Funktion", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "type", "hidden": false, "editor": type1380 }, { "colIndex": 2, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "renderer": Lino.id_renderer, "hidden": false, "editor": id1381, "dataIndex": "id" } ];
    Lino.contacts.RolesByPerson.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.RolesByPerson.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.contacts.RolesByPerson.GridPanel(p);
});

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUIpostings.PostingsByPartnerHandle
Lino.postings.PostingsByPartner.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/postings/PostingsByPartner",
  ls_bbar_actions : [ { "itemId": "print_action", "menu_item_text": "Drucken", "must_save": true, "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('print_action'), "iconCls": "x-tbar-print", "overflowText": "Drucken", "auto_save": true } ],
  title : "Postsendungen",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "date", "name": "date", "dateFormat": "d.m.Y" }, { "name": "owner" }, { "name": "state" },'stateHidden', { "name": "workflow_buttons" }, { "type": "int", "name": "id" }, { "name": "owner_type" },'owner_typeHidden', { "name": "owner_id" },'owner_idHidden', { "name": "user" },'userHidden', { "name": "project" },'projectHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 5,
  ls_grid_configs : [  ],
  content_type : 39,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 15,
  initComponent : function() {
    var ww = this.containing_window;
    var date1383 = new Lino.DateField({ "selectOnFocus": true, "allowBlank": false });
    var owner_disp1384 = new Ext.form.DisplayField({ "disabled": true });
    var state1385 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.postings.PostingStates });
    var workflow_buttons_disp1386 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var id1387 = new Ext.form.NumberField({ "selectOnFocus": true });
    var owner_type1388 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/postings/PostingsByPartner/owner_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Inhaltstyp ausw\u00e4hlen..." });
    var owner_id1389 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/postings/PostingsByPartner/owner_id", "method": "GET" }) }) });
    var user1390 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/postings/PostingsByPartner/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Benutzer ausw\u00e4hlen..." });
    var project1391 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/postings/PostingsByPartner/project", "method": "GET" }) }), "pageSize": 20, "emptyText": "Klient ausw\u00e4hlen..." });
    this.before_row_edit = function(record) {
      owner_id1389.setContextValue('owner_type',record ? record.data['owner_typeHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      owner_type1388.on('change',Lino.chooser_handler(owner_id1389,'owner_type'));
      Lino.postings.PostingsByPartner.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "date", "dataIndex": "date", "hidden": false, "width": Lino.chars2width(8), "editor": date1383 }, { "width": Lino.chars2width(30), "colIndex": 1, "sortable": false, "dataIndex": "owner", "header": "Verkn\u00fcpft mit", "hidden": false, "editable": false }, { "colIndex": 2, "sortable": true, "header": "Zustand", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(19), "dataIndex": "state", "hidden": false, "editor": state1385 }, { "width": Lino.chars2width(30), "colIndex": 3, "sortable": false, "dataIndex": "workflow_buttons", "header": "Arbeitsablauf", "hidden": false, "editable": false }, { "colIndex": 4, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "renderer": Lino.id_renderer, "hidden": false, "editor": id1387, "dataIndex": "id" }, { "colIndex": 5, "sortable": true, "header": "Verkn\u00fcpft mit (Modell)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('owner_typeHidden','Lino.lino.ContentTypes.detail'), "hidden": false, "editor": owner_type1388, "dataIndex": "owner_type" }, { "colIndex": 6, "sortable": true, "header": "Verkn\u00fcpft mit (Objekt)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(10), "dataIndex": "owner_id", "hidden": false, "editor": owner_id1389 }, { "colIndex": 7, "sortable": true, "header": "Autor", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(15), "dataIndex": "user", "hidden": false, "editor": user1390 }, { "colIndex": 8, "sortable": true, "header": "Klient", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "project", "hidden": false, "editor": project1391 } ];
    Lino.postings.PostingsByPartner.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.postings.PostingsByPartner.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.postings.PostingsByPartner.GridPanel(p);
});
Lino.postings.PostingsByPartner.print_action = function(rp,pk) { 
  Lino.run_row_action(rp,"/postings/PostingsByPartner",pk,"print_action");
};

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUIpostings.PostingsByProjectHandle
Lino.postings.PostingsByProject.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/postings/PostingsByProject",
  ls_bbar_actions : [ { "itemId": "print_action", "menu_item_text": "Drucken", "must_save": true, "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('print_action'), "iconCls": "x-tbar-print", "overflowText": "Drucken", "auto_save": true } ],
  title : "Postsendungen",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "date", "name": "date", "dateFormat": "d.m.Y" }, { "name": "partner" },'partnerHidden', { "name": "state" },'stateHidden', { "name": "workflow_buttons" }, { "type": "int", "name": "id" }, { "name": "owner_type" },'owner_typeHidden', { "name": "owner_id" },'owner_idHidden', { "name": "user" },'userHidden', { "name": "owner" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 6,
  ls_grid_configs : [  ],
  content_type : 39,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 15,
  initComponent : function() {
    var ww = this.containing_window;
    var date1393 = new Lino.DateField({ "selectOnFocus": true, "allowBlank": false });
    var partner1394 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/postings/PostingsByProject/partner", "method": "GET" }) }), "pageSize": 20, "emptyText": "Partner ausw\u00e4hlen..." });
    var state1395 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.postings.PostingStates });
    var workflow_buttons_disp1396 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var id1397 = new Ext.form.NumberField({ "selectOnFocus": true });
    var owner_type1398 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/postings/PostingsByProject/owner_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Inhaltstyp ausw\u00e4hlen..." });
    var owner_id1399 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/postings/PostingsByProject/owner_id", "method": "GET" }) }) });
    var user1400 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/postings/PostingsByProject/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Benutzer ausw\u00e4hlen..." });
    var owner_disp1401 = new Ext.form.DisplayField({ "disabled": true });
    this.before_row_edit = function(record) {
      owner_id1399.setContextValue('owner_type',record ? record.data['owner_typeHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      owner_type1398.on('change',Lino.chooser_handler(owner_id1399,'owner_type'));
      Lino.postings.PostingsByProject.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "date", "dataIndex": "date", "hidden": false, "width": Lino.chars2width(8), "editor": date1393 }, { "colIndex": 1, "sortable": true, "header": "Empf\u00e4ngerEmpf\u00e4nger", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "partner", "hidden": false, "editor": partner1394 }, { "colIndex": 2, "sortable": true, "header": "Zustand", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(19), "dataIndex": "state", "hidden": false, "editor": state1395 }, { "width": Lino.chars2width(30), "colIndex": 3, "sortable": false, "dataIndex": "workflow_buttons", "header": "Arbeitsablauf", "hidden": false, "editable": false }, { "colIndex": 4, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "renderer": Lino.id_renderer, "hidden": false, "editor": id1397, "dataIndex": "id" }, { "colIndex": 5, "sortable": true, "header": "Verkn\u00fcpft mit (Modell)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('owner_typeHidden','Lino.lino.ContentTypes.detail'), "hidden": false, "editor": owner_type1398, "dataIndex": "owner_type" }, { "colIndex": 6, "sortable": true, "header": "Verkn\u00fcpft mit (Objekt)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(10), "dataIndex": "owner_id", "hidden": false, "editor": owner_id1399 }, { "colIndex": 7, "sortable": true, "header": "Autor", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(15), "dataIndex": "user", "hidden": false, "editor": user1400 }, { "width": Lino.chars2width(30), "colIndex": 8, "sortable": false, "dataIndex": "owner", "header": "Verkn\u00fcpft mit", "hidden": false, "editable": false } ];
    Lino.postings.PostingsByProject.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.postings.PostingsByProject.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.postings.PostingsByProject.GridPanel(p);
});
Lino.postings.PostingsByProject.print_action = function(rp,pk) { 
  Lino.run_row_action(rp,"/postings/PostingsByProject",pk,"print_action");
};

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUIoutbox.RecipientsByMailHandle
Lino.outbox.RecipientsByMail.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/outbox/RecipientsByMail",
  ls_bbar_actions : [  ],
  title : "Empf\u00e4nger",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "partner" },'partnerHidden', { "name": "address" }, { "name": "name" }, { "name": "type" },'typeHidden', { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 6,
  ls_grid_configs : [  ],
  content_type : 29,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 8,
  initComponent : function() {
    var ww = this.containing_window;
    var partner946 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/RecipientsByMail/partner", "method": "GET" }) }), "pageSize": 20, "emptyText": "Partner ausw\u00e4hlen..." });
    var address947 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75 });
    var name948 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var type949 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.outbox.RecipientType });
    var id950 = new Ext.form.NumberField({ "selectOnFocus": true });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Partner", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "partner", "hidden": false, "editor": partner946 }, { "colIndex": 1, "sortable": true, "header": "Adresse", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "address", "hidden": false, "editor": address947 }, { "colIndex": 2, "sortable": true, "header": "Name", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "name", "hidden": false, "editor": name948 }, { "colIndex": 3, "sortable": true, "header": "Empf\u00e4ngerart", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(10), "dataIndex": "type", "hidden": false, "editor": type949 }, { "colIndex": 4, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "renderer": Lino.id_renderer, "hidden": false, "editor": id950, "dataIndex": "id" } ];
    Lino.outbox.RecipientsByMail.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.outbox.RecipientsByMail.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.outbox.RecipientsByMail.GridPanel(p);
});

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUIoutbox.MailsByUserHandle
Lino.outbox.MailsByUser.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/outbox/MailsByUser",
  ls_bbar_actions : [ { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": "send_mail", "menu_item_text": "E-Mail senden", "must_save": true, "tooltip": "E-Mail senden", "panel_btn_handler": Lino.row_action_handler('send_mail'), "iconCls": "x-tbar-email_send", "overflowText": "E-Mail senden", "auto_save": true } ],
  title : "E-Mail-Ausgang",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "sent" }, { "name": "subject" }, { "name": "recipients" }, { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 3,
  ls_grid_configs : [  ],
  content_type : 28,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 5,
  initComponent : function() {
    this.ls_detail_handler = Lino.outbox.MailsByUser.detail;
    this.ls_insert_handler = Lino.outbox.MailsByUser.insert;
    var ww = this.containing_window;
    var sent1403 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var subject1404 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var recipients_htmlbox1405 = new Lino.HtmlBoxPanel({ "layout": "fit", "name": "recipients", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "title": "Empf\u00e4nger", "master_panel": this, "value": "<br/>", "always_enabled": true, "bodyStyle": "overflow-x:hidden !important;" });
    this.before_row_edit = function(record) {
      recipients_htmlbox1405.refresh();
    };
    this.ls_columns = [ { "width": Lino.chars2width(16), "colIndex": 0, "sortable": true, "dataIndex": "sent", "header": "sent", "hidden": false, "editable": false }, { "colIndex": 1, "sortable": true, "header": "Thema", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "subject", "hidden": false, "editor": subject1404 }, { "colIndex": 2, "sortable": false, "header": "Empf\u00e4nger", "editable": false, "filter": { "type": "string" }, "width": Lino.chars2width(30), "dataIndex": "recipients", "hidden": false } ];
    Lino.outbox.MailsByUser.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.outbox.MailsByUser.insertPanel = Ext.extend(Lino.outbox.MailsByUser.InsertFormPanel,{
  empty_title: "Neu E-Mail-Ausgang",
  hide_navigator: true,
  ls_bbar_actions: [  ],
  ls_url: "/outbox/MailsByUser",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.outbox.MailsByUser.detail;
    this.ls_insert_handler = Lino.outbox.MailsByUser.insert;
    Lino.outbox.MailsByUser.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.outbox.MailsByUser.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "maximizable": true, "modal": true, "maximized": false, "height": Lino.rows2height(20) },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.outbox.MailsByUser.insertPanel(p);
});

Lino.outbox.MailsByUser.detailPanel = Ext.extend(Lino.outbox.MailsByUser.DetailFormPanel,{
  empty_title: "Detail E-Mail-Ausgang",
  ls_bbar_actions: [ { "itemId": "send_mail", "menu_item_text": "E-Mail senden", "must_save": true, "tooltip": "E-Mail senden", "panel_btn_handler": Lino.row_action_handler('send_mail'), "iconCls": "x-tbar-email_send", "overflowText": "E-Mail senden", "auto_save": true } ],
  ls_url: "/outbox/MailsByUser",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.outbox.MailsByUser.detail;
    this.ls_insert_handler = Lino.outbox.MailsByUser.insert;
    Lino.outbox.MailsByUser.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.outbox.MailsByUser.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.outbox.MailsByUser.detailPanel(p);
});
Lino.outbox.MailsByUser.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.outbox.MailsByUser.GridPanel(p);
});

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUIoutbox.MailsByProjectHandle
Lino.outbox.MailsByProject.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/outbox/MailsByProject",
  ls_bbar_actions : [ { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": "send_mail", "menu_item_text": "E-Mail senden", "must_save": true, "tooltip": "E-Mail senden", "panel_btn_handler": Lino.row_action_handler('send_mail'), "iconCls": "x-tbar-email_send", "overflowText": "E-Mail senden", "auto_save": true } ],
  title : "E-Mail-Ausgang",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "date", "name": "date", "dateFormat": "d.m.Y" }, { "name": "subject" }, { "name": "recipients" }, { "name": "user" },'userHidden', { "type": "int", "name": "id" }, { "name": "owner_type" },'owner_typeHidden', { "name": "owner_id" },'owner_idHidden', { "name": "body" }, { "name": "sent" }, { "name": "owner" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 5,
  ls_grid_configs : [  ],
  content_type : 28,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 14,
  initComponent : function() {
    this.ls_detail_handler = Lino.outbox.MailsByProject.detail;
    this.ls_insert_handler = Lino.outbox.MailsByProject.insert;
    var ww = this.containing_window;
    var date1407 = new Lino.DateField({ "disabled": true });
    var subject1408 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var recipients_htmlbox1409 = new Lino.HtmlBoxPanel({ "layout": "fit", "name": "recipients", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "title": "Empf\u00e4nger", "master_panel": this, "value": "<br/>", "always_enabled": true, "bodyStyle": "overflow-x:hidden !important;" });
    var user1410 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/MailsByProject/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Benutzer ausw\u00e4hlen..." });
    var id1411 = new Ext.form.NumberField({ "selectOnFocus": true });
    var owner_type1412 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/MailsByProject/owner_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Inhaltstyp ausw\u00e4hlen..." });
    var owner_id1413 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/MailsByProject/owner_id", "method": "GET" }) }) });
    var body1414 = new Lino.RichTextPanel({ "selectOnFocus": true, "containing_panel": this, "title": "Inhalt" });
    var sent1415 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var owner_disp1416 = new Ext.form.DisplayField({ "disabled": true });
    this.before_row_edit = function(record) {
      recipients_htmlbox1409.refresh();
      owner_id1413.setContextValue('owner_type',record ? record.data['owner_typeHidden'] : undefined);
      body1414.refresh();
    };
    this.onRender = function(ct, position) {
      owner_type1412.on('change',Lino.chooser_handler(owner_id1413,'owner_type'));
      Lino.outbox.MailsByProject.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": false, "tooltip": "\n        The official date to be printed on the document.\n        ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Datum", "dataIndex": "date", "hidden": false, "width": Lino.chars2width(8) }, { "colIndex": 1, "sortable": true, "header": "Thema", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "subject", "hidden": false, "editor": subject1408 }, { "colIndex": 2, "sortable": false, "header": "Empf\u00e4nger", "editable": false, "filter": { "type": "string" }, "width": Lino.chars2width(30), "dataIndex": "recipients", "hidden": false }, { "colIndex": 3, "sortable": true, "header": "Sender", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(15), "dataIndex": "user", "hidden": false, "editor": user1410 }, { "colIndex": 4, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "renderer": Lino.id_renderer, "hidden": false, "editor": id1411, "dataIndex": "id" }, { "colIndex": 5, "sortable": true, "header": "Verkn\u00fcpft mit (Modell)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('owner_typeHidden','Lino.lino.ContentTypes.detail'), "hidden": false, "editor": owner_type1412, "dataIndex": "owner_type" }, { "colIndex": 6, "sortable": true, "header": "Verkn\u00fcpft mit (Objekt)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(10), "dataIndex": "owner_id", "hidden": false, "editor": owner_id1413 }, { "colIndex": 7, "sortable": false, "header": "body", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(60), "renderer": Lino.text_renderer, "hidden": false, "editor": body1414, "dataIndex": "body" }, { "width": Lino.chars2width(16), "colIndex": 8, "sortable": true, "dataIndex": "sent", "header": "sent", "hidden": false, "editable": false }, { "width": Lino.chars2width(30), "colIndex": 9, "sortable": false, "dataIndex": "owner", "header": "Verkn\u00fcpft mit", "hidden": false, "editable": false } ];
    Lino.outbox.MailsByProject.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.outbox.MailsByProject.insertPanel = Ext.extend(Lino.outbox.MailsByUser.InsertFormPanel,{
  empty_title: "Neu E-Mail-Ausgang",
  hide_navigator: true,
  ls_bbar_actions: [  ],
  ls_url: "/outbox/MailsByProject",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.outbox.MailsByProject.detail;
    this.ls_insert_handler = Lino.outbox.MailsByProject.insert;
    Lino.outbox.MailsByProject.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.outbox.MailsByProject.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "maximizable": true, "modal": true, "maximized": false, "height": Lino.rows2height(20) },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.outbox.MailsByProject.insertPanel(p);
});

Lino.outbox.MailsByProject.detailPanel = Ext.extend(Lino.outbox.MailsByUser.DetailFormPanel,{
  empty_title: "Detail E-Mail-Ausgang",
  ls_bbar_actions: [ { "itemId": "send_mail", "menu_item_text": "E-Mail senden", "must_save": true, "tooltip": "E-Mail senden", "panel_btn_handler": Lino.row_action_handler('send_mail'), "iconCls": "x-tbar-email_send", "overflowText": "E-Mail senden", "auto_save": true } ],
  ls_url: "/outbox/MailsByProject",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.outbox.MailsByProject.detail;
    this.ls_insert_handler = Lino.outbox.MailsByProject.insert;
    Lino.outbox.MailsByProject.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.outbox.MailsByProject.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.outbox.MailsByProject.detailPanel(p);
});
Lino.outbox.MailsByProject.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.outbox.MailsByProject.GridPanel(p);
});

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUIoutbox.SentByPartnerHandle
Lino.outbox.SentByPartner.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/outbox/SentByPartner",
  ls_bbar_actions : [ { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": "send_mail", "menu_item_text": "E-Mail senden", "must_save": true, "tooltip": "E-Mail senden", "panel_btn_handler": Lino.row_action_handler('send_mail'), "iconCls": "x-tbar-email_send", "overflowText": "E-Mail senden", "auto_save": true } ],
  title : "E-Mail-Ausgang",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "sent" }, { "name": "subject" }, { "name": "user" },'userHidden', { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 4,
  ls_grid_configs : [  ],
  content_type : 28,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 6,
  initComponent : function() {
    this.ls_detail_handler = Lino.outbox.SentByPartner.detail;
    this.ls_insert_handler = Lino.outbox.SentByPartner.insert;
    var ww = this.containing_window;
    var sent1418 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var subject1419 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var user1420 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/SentByPartner/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Benutzer ausw\u00e4hlen..." });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "width": Lino.chars2width(16), "colIndex": 0, "sortable": true, "dataIndex": "sent", "header": "sent", "hidden": false, "editable": false }, { "colIndex": 1, "sortable": true, "header": "Thema", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "subject", "hidden": false, "editor": subject1419 }, { "colIndex": 2, "sortable": true, "header": "Sender", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(15), "dataIndex": "user", "hidden": false, "editor": user1420 } ];
    Lino.outbox.SentByPartner.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.outbox.SentByPartner.insertPanel = Ext.extend(Lino.outbox.MailsByUser.InsertFormPanel,{
  empty_title: "Neu E-Mail-Ausgang",
  hide_navigator: true,
  ls_bbar_actions: [  ],
  ls_url: "/outbox/SentByPartner",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.outbox.SentByPartner.detail;
    this.ls_insert_handler = Lino.outbox.SentByPartner.insert;
    Lino.outbox.SentByPartner.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.outbox.SentByPartner.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "maximizable": true, "modal": true, "maximized": false, "height": Lino.rows2height(20) },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.outbox.SentByPartner.insertPanel(p);
});

Lino.outbox.SentByPartner.detailPanel = Ext.extend(Lino.outbox.MailsByUser.DetailFormPanel,{
  empty_title: "Detail E-Mail-Ausgang",
  ls_bbar_actions: [ { "itemId": "send_mail", "menu_item_text": "E-Mail senden", "must_save": true, "tooltip": "E-Mail senden", "panel_btn_handler": Lino.row_action_handler('send_mail'), "iconCls": "x-tbar-email_send", "overflowText": "E-Mail senden", "auto_save": true } ],
  ls_url: "/outbox/SentByPartner",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.outbox.SentByPartner.detail;
    this.ls_insert_handler = Lino.outbox.SentByPartner.insert;
    Lino.outbox.SentByPartner.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.outbox.SentByPartner.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.outbox.SentByPartner.detailPanel(p);
});
Lino.outbox.SentByPartner.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.outbox.SentByPartner.GridPanel(p);
});

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUIuploads.MyUploadsHandle
Lino.uploads.MyUploads.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/uploads/MyUploads",
  ls_bbar_actions : [ { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true } ],
  title : "Meine Uploads",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "file" }, { "name": "description" }, { "name": "user" },'userHidden', { "name": "owner" }, { "type": "int", "name": "id" }, { "name": "owner_type" },'owner_typeHidden', { "name": "owner_id" },'owner_idHidden', { "name": "created" }, { "name": "modified" }, { "name": "mimetype" }, { "name": "type" },'typeHidden', { "type": "date", "name": "valid_until", "dateFormat": "d.m.Y" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 5,
  ls_grid_configs : [  ],
  content_type : 25,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 17,
  initComponent : function() {
    this.ls_detail_handler = Lino.uploads.MyUploads.detail;
    this.ls_insert_handler = Lino.uploads.MyUploads.insert;
    var ww = this.containing_window;
    var file1422 = Lino.file_field_handler(this,{ "selectOnFocus": true, "allowBlank": false, "maxLength": 100 });
    var description1423 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var user1424 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/MyUploads/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Benutzer ausw\u00e4hlen..." });
    var owner_disp1425 = new Ext.form.DisplayField({ "disabled": true });
    var id1426 = new Ext.form.NumberField({ "selectOnFocus": true });
    var owner_type1427 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/MyUploads/owner_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Inhaltstyp ausw\u00e4hlen..." });
    var owner_id1428 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/MyUploads/owner_id", "method": "GET" }) }) });
    var created1429 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var modified1430 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var mimetype1431 = new Ext.form.TextField({ "disabled": true, "maxLength": 64 });
    var type1432 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/MyUploads/type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Upload-Art ausw\u00e4hlen..." });
    var valid_until1433 = new Lino.DateField({ "selectOnFocus": true });
    this.before_row_edit = function(record) {
      owner_id1428.setContextValue('owner_type',record ? record.data['owner_typeHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      owner_type1427.on('change',Lino.chooser_handler(owner_id1428,'owner_type'));
      Lino.uploads.MyUploads.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Datei", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "file", "hidden": false, "editor": file1422 }, { "colIndex": 1, "sortable": true, "header": "Beschreibung", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "description", "hidden": false, "editor": description1423 }, { "colIndex": 2, "sortable": true, "header": "Autor", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(15), "dataIndex": "user", "hidden": false, "editor": user1424 }, { "width": Lino.chars2width(30), "colIndex": 3, "sortable": false, "dataIndex": "owner", "header": "Verkn\u00fcpft mit", "hidden": false, "editable": false }, { "colIndex": 4, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "renderer": Lino.id_renderer, "hidden": false, "editor": id1426, "dataIndex": "id" }, { "colIndex": 5, "sortable": true, "header": "Verkn\u00fcpft mit (Modell)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('owner_typeHidden','Lino.lino.ContentTypes.detail'), "hidden": false, "editor": owner_type1427, "dataIndex": "owner_type" }, { "colIndex": 6, "sortable": true, "header": "Verkn\u00fcpft mit (Objekt)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(10), "dataIndex": "owner_id", "hidden": false, "editor": owner_id1428 }, { "width": Lino.chars2width(16), "colIndex": 7, "sortable": true, "dataIndex": "created", "header": "Erstellt", "hidden": false, "editable": false }, { "width": Lino.chars2width(16), "colIndex": 8, "sortable": true, "dataIndex": "modified", "header": "Bearbeitet", "hidden": false, "editable": false }, { "colIndex": 9, "sortable": true, "header": "MIME-Art", "editable": false, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "mimetype", "hidden": false }, { "colIndex": 10, "sortable": true, "header": "Upload-Art", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "type", "hidden": false, "editor": type1432 }, { "colIndex": 11, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "g\u00fcltig bis", "dataIndex": "valid_until", "hidden": false, "width": Lino.chars2width(8), "editor": valid_until1433 } ];
    Lino.uploads.MyUploads.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.uploads.MyUploads.insertPanel = Ext.extend(Lino.uploads.Uploads.InsertFormPanel,{
  empty_title: "Neu Meine Uploads",
  hide_navigator: true,
  ls_bbar_actions: [  ],
  ls_url: "/uploads/MyUploads",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.uploads.MyUploads.detail;
    this.ls_insert_handler = Lino.uploads.MyUploads.insert;
    Lino.uploads.MyUploads.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.uploads.MyUploads.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.uploads.MyUploads.insertPanel(p);
});

Lino.uploads.MyUploads.detailPanel = Ext.extend(Lino.uploads.Uploads.DetailFormPanel,{
  empty_title: "Detail Meine Uploads",
  ls_bbar_actions: [  ],
  ls_url: "/uploads/MyUploads",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.uploads.MyUploads.detail;
    this.ls_insert_handler = Lino.uploads.MyUploads.insert;
    Lino.uploads.MyUploads.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.uploads.MyUploads.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.uploads.MyUploads.detailPanel(p);
});
Lino.uploads.MyUploads.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.uploads.MyUploads.GridPanel(p);
});

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUIhouseholds.MembersByHouseholdHandle
Lino.households.MembersByHousehold.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/households/MembersByHousehold",
  ls_bbar_actions : [  ],
  title : "Mitglieder",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "person" },'personHidden', { "name": "role" },'roleHidden', { "type": "date", "name": "start_date", "dateFormat": "d.m.Y" }, { "type": "date", "name": "end_date", "dateFormat": "d.m.Y" }, { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 6,
  ls_grid_configs : [  ],
  content_type : 41,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 8,
  initComponent : function() {
    var ww = this.containing_window;
    var person411 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/MembersByHousehold/person", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Person ausw\u00e4hlen..." });
    var role412 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/MembersByHousehold/role", "method": "GET" }) }), "pageSize": 20, "emptyText": "Rolle in Haushalt ausw\u00e4hlen..." });
    var start_date413 = new Lino.DateField({ "selectOnFocus": true });
    var end_date414 = new Lino.DateField({ "selectOnFocus": true });
    var id415 = new Ext.form.NumberField({ "selectOnFocus": true });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Person", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "person", "hidden": false, "editor": person411 }, { "colIndex": 1, "sortable": true, "width": Lino.chars2width(20), "editable": true, "tooltip": "The Role of this Person in this Household.\nList of choices is configured in `Configure --> Households --> Roles`.\n", "filter": { "type": "string" }, "header": "Rolle in Haushalt", "renderer": Lino.fk_renderer('roleHidden','Lino.households.Roles.detail'), "hidden": false, "editor": role412, "dataIndex": "role" }, { "colIndex": 2, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "From", "dataIndex": "start_date", "hidden": false, "width": Lino.chars2width(8), "editor": start_date413 }, { "colIndex": 3, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Until", "dataIndex": "end_date", "hidden": false, "width": Lino.chars2width(8), "editor": end_date414 }, { "colIndex": 4, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "renderer": Lino.id_renderer, "hidden": false, "editor": id415, "dataIndex": "id" } ];
    Lino.households.MembersByHousehold.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.households.MembersByHousehold.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.households.MembersByHousehold.GridPanel(p);
});

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUIhouseholds.MembersByPersonHandle
Lino.households.MembersByPerson.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/households/MembersByPerson",
  ls_bbar_actions : [  ],
  title : "Mitglied von",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "household" },'householdHidden', { "name": "role" },'roleHidden', { "type": "date", "name": "start_date", "dateFormat": "d.m.Y" }, { "type": "date", "name": "end_date", "dateFormat": "d.m.Y" }, { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 6,
  ls_grid_configs : [  ],
  content_type : 41,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 8,
  initComponent : function() {
    var ww = this.containing_window;
    var household1435 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/MembersByPerson/household", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Haushalt ausw\u00e4hlen..." });
    var role1436 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/MembersByPerson/role", "method": "GET" }) }), "pageSize": 20, "emptyText": "Rolle in Haushalt ausw\u00e4hlen..." });
    var start_date1437 = new Lino.DateField({ "selectOnFocus": true });
    var end_date1438 = new Lino.DateField({ "selectOnFocus": true });
    var id1439 = new Ext.form.NumberField({ "selectOnFocus": true });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Haushalt", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "household", "hidden": false, "editor": household1435 }, { "colIndex": 1, "sortable": true, "width": Lino.chars2width(20), "editable": true, "tooltip": "The Role of this Person in this Household.\nList of choices is configured in `Configure --> Households --> Roles`.\n", "filter": { "type": "string" }, "header": "Rolle in Haushalt", "renderer": Lino.fk_renderer('roleHidden','Lino.households.Roles.detail'), "hidden": false, "editor": role1436, "dataIndex": "role" }, { "colIndex": 2, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "From", "dataIndex": "start_date", "hidden": false, "width": Lino.chars2width(8), "editor": start_date1437 }, { "colIndex": 3, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Until", "dataIndex": "end_date", "hidden": false, "width": Lino.chars2width(8), "editor": end_date1438 }, { "colIndex": 4, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "renderer": Lino.id_renderer, "hidden": false, "editor": id1439, "dataIndex": "id" } ];
    Lino.households.MembersByPerson.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.households.MembersByPerson.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.households.MembersByPerson.GridPanel(p);
});

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUIhouseholds.MembersByRoleHandle
Lino.households.MembersByRole.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/households/MembersByRole",
  ls_bbar_actions : [  ],
  title : "Mitglieder",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "person" },'personHidden', { "name": "household" },'householdHidden', { "type": "date", "name": "start_date", "dateFormat": "d.m.Y" }, { "type": "date", "name": "end_date", "dateFormat": "d.m.Y" }, { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 6,
  ls_grid_configs : [  ],
  content_type : 41,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 8,
  initComponent : function() {
    var ww = this.containing_window;
    var person861 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/MembersByRole/person", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Person ausw\u00e4hlen..." });
    var household862 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/MembersByRole/household", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Haushalt ausw\u00e4hlen..." });
    var start_date863 = new Lino.DateField({ "selectOnFocus": true });
    var end_date864 = new Lino.DateField({ "selectOnFocus": true });
    var id865 = new Ext.form.NumberField({ "selectOnFocus": true });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Person", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "person", "hidden": false, "editor": person861 }, { "colIndex": 1, "sortable": true, "header": "Haushalt", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "household", "hidden": false, "editor": household862 }, { "colIndex": 2, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "From", "dataIndex": "start_date", "hidden": false, "width": Lino.chars2width(8), "editor": start_date863 }, { "colIndex": 3, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Until", "dataIndex": "end_date", "hidden": false, "width": Lino.chars2width(8), "editor": end_date864 }, { "colIndex": 4, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "renderer": Lino.id_renderer, "hidden": false, "editor": id865, "dataIndex": "id" } ];
    Lino.households.MembersByRole.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.households.MembersByRole.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.households.MembersByRole.GridPanel(p);
});

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUIaccounts.GroupsByChartHandle
Lino.accounts.GroupsByChart.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/accounts/GroupsByChart",
  ls_bbar_actions : [ { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true } ],
  title : "Kontengruppen",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "ref" }, { "name": "name" }, { "name": "name_fr" }, { "name": "name_en" }, { "name": "account_type" },'account_typeHidden', { "type": "int", "name": "id" }, { "name": "help_text" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 6,
  ls_grid_configs : [  ],
  content_type : 46,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 9,
  initComponent : function() {
    this.ls_detail_handler = Lino.accounts.GroupsByChart.detail;
    this.ls_insert_handler = Lino.accounts.GroupsByChart.insert;
    var ww = this.containing_window;
    var ref986 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 100 });
    var name987 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_fr988 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_en989 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var account_type990 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": Lino.accounts.AccountTypes });
    var id991 = new Ext.form.NumberField({ "selectOnFocus": true });
    var help_text992 = new Lino.RichTextPanel({ "selectOnFocus": true, "containing_panel": this, "title": "Einleitung" });
    this.before_row_edit = function(record) {
      help_text992.refresh();
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "ref", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "ref", "hidden": false, "editor": ref986 }, { "colIndex": 1, "sortable": true, "header": "Bezeichnung", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name", "hidden": false, "editor": name987 }, { "colIndex": 2, "sortable": true, "header": "Bezeichnung (fr)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name_fr", "hidden": false, "editor": name_fr988 }, { "colIndex": 3, "sortable": true, "header": "Bezeichnung (en)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name_en", "hidden": false, "editor": name_en989 }, { "colIndex": 4, "sortable": true, "header": "Kontenart", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(15), "dataIndex": "account_type", "hidden": false, "editor": account_type990 }, { "colIndex": 5, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "renderer": Lino.id_renderer, "hidden": false, "editor": id991, "dataIndex": "id" }, { "colIndex": 6, "sortable": false, "header": "help_text", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(60), "renderer": Lino.text_renderer, "hidden": false, "editor": help_text992, "dataIndex": "help_text" } ];
    Lino.accounts.GroupsByChart.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.accounts.GroupsByChart.insertPanel = Ext.extend(Lino.accounts.Groups.DetailFormPanel,{
  empty_title: "Neu Kontengruppen",
  hide_navigator: true,
  ls_bbar_actions: [  ],
  ls_url: "/accounts/GroupsByChart",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.accounts.GroupsByChart.detail;
    this.ls_insert_handler = Lino.accounts.GroupsByChart.insert;
    Lino.accounts.GroupsByChart.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.accounts.GroupsByChart.insert = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.accounts.GroupsByChart.insertPanel(p);
});

Lino.accounts.GroupsByChart.detailPanel = Ext.extend(Lino.accounts.Groups.DetailFormPanel,{
  empty_title: "Detail Kontengruppen",
  ls_bbar_actions: [  ],
  ls_url: "/accounts/GroupsByChart",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.accounts.GroupsByChart.detail;
    this.ls_insert_handler = Lino.accounts.GroupsByChart.insert;
    Lino.accounts.GroupsByChart.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.accounts.GroupsByChart.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.accounts.GroupsByChart.detailPanel(p);
});
Lino.accounts.GroupsByChart.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.accounts.GroupsByChart.GridPanel(p);
});

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUIaccounts.AccountsByGroupHandle
Lino.accounts.AccountsByGroup.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/accounts/AccountsByGroup",
  ls_bbar_actions : [ { "itemId": "duplicate_row", "menu_item_text": "Duplizieren", "must_save": true, "panel_btn_handler": Lino.row_action_handler('duplicate_row'), "text": "Duplizieren", "overflowText": "Duplizieren", "auto_save": true } ],
  title : "Konten",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "name" }, { "name": "name_fr" }, { "name": "name_en" }, { "type": "int", "name": "seqno" }, { "name": "chart" },'chartHidden', { "name": "ref" }, { "name": "type" },'typeHidden', { "name": "help_text" }, { "type": "boolean", "name": "required_for_household" }, { "type": "boolean", "name": "required_for_person" }, { "type": "float", "name": "periods" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 44,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 15,
  initComponent : function() {
    var ww = this.containing_window;
    var id557 = new Ext.form.NumberField({ "selectOnFocus": true });
    var name558 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_fr559 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_en560 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var seqno561 = new Ext.form.NumberField({ "selectOnFocus": true });
    var chart562 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/accounts/AccountsByGroup/chart", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Kontenplan ausw\u00e4hlen..." });
    var ref563 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var type564 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.accounts.AccountTypes });
    var help_text565 = new Lino.RichTextPanel({ "selectOnFocus": true, "containing_panel": this, "title": "Einleitung" });
    var required_for_household566 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var required_for_person567 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var periods568 = { "xtype": "numberfield", "allowDecimals": false, "selectOnFocus": true, "value": 1, "allowBlank": false };
    this.before_row_edit = function(record) {
      help_text565.refresh();
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "renderer": Lino.id_renderer, "hidden": false, "editor": id557, "dataIndex": "id" }, { "colIndex": 1, "sortable": true, "header": "Bezeichnung", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name", "hidden": false, "editor": name558 }, { "colIndex": 2, "sortable": true, "header": "Bezeichnung (fr)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name_fr", "hidden": false, "editor": name_fr559 }, { "colIndex": 3, "sortable": true, "header": "Bezeichnung (en)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name_en", "hidden": false, "editor": name_en560 }, { "colIndex": 4, "sortable": true, "header": "Seq.-Nr.", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "dataIndex": "seqno", "hidden": false, "editor": seqno561 }, { "colIndex": 5, "sortable": true, "header": "Kontenplan", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('chartHidden','Lino.accounts.Charts.detail'), "hidden": false, "editor": chart562, "dataIndex": "chart" }, { "colIndex": 6, "sortable": true, "header": "ref", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "ref", "hidden": false, "editor": ref563 }, { "colIndex": 7, "sortable": true, "header": "Kontenart", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(15), "dataIndex": "type", "hidden": false, "editor": type564 }, { "colIndex": 8, "sortable": false, "header": "help_text", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(60), "renderer": Lino.text_renderer, "hidden": false, "editor": help_text565, "dataIndex": "help_text" }, { "colIndex": 9, "sortable": false, "xtype": "checkcolumn", "header": "verpflichtend f\u00fcr Haushalte", "editable": true, "filter": { "type": "boolean" }, "width": Lino.chars2width(10), "dataIndex": "required_for_household", "hidden": false }, { "colIndex": 10, "sortable": false, "xtype": "checkcolumn", "header": "verpflichtend f\u00fcr Personen", "editable": true, "filter": { "type": "boolean" }, "width": Lino.chars2width(10), "dataIndex": "required_for_person", "hidden": false }, { "colIndex": 11, "sortable": true, "xtype": "numbercolumn", "format": "0/i", "align": "right", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(3), "dataIndex": "periods", "header": "Perioden", "hidden": false, "editor": periods568 } ];
    Lino.accounts.AccountsByGroup.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.accounts.AccountsByGroup.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.accounts.AccountsByGroup.GridPanel(p);
});
Lino.accounts.AccountsByGroup.duplicate_row = function(rp,pk) { 
  Lino.run_row_action(rp,"/accounts/AccountsByGroup",pk,"duplicate_row");
};

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUInotes.NotesByTypeHandle
Lino.notes.NotesByType.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/notes/NotesByType",
  ls_bbar_actions : [ { "itemId": "duplicate_row", "menu_item_text": "Duplizieren", "must_save": true, "tooltip": "Duplizieren", "panel_btn_handler": Lino.row_action_handler('duplicate_row'), "iconCls": "x-tbar-duplicate", "overflowText": "Duplizieren", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": "do_print", "menu_item_text": "Drucken", "must_save": true, "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print'), "iconCls": "x-tbar-print", "overflowText": "Drucken", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Cache l\u00f6schen", "must_save": true, "tooltip": "Cache l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('do_clear_cache'), "iconCls": "x-tbar-clearcache", "overflowText": "Cache l\u00f6schen", "auto_save": true }, { "itemId": "create_postings", "menu_item_text": "per Post", "must_save": true, "tooltip": "Create classical mail postings from this", "panel_btn_handler": Lino.row_action_handler('create_postings'), "iconCls": "x-tbar-create-postings", "overflowText": "per Post", "auto_save": true }, { "itemId": "create_mail", "menu_item_text": "per E-Mail", "must_save": true, "tooltip": "Create an email from this", "panel_btn_handler": Lino.row_action_handler('create_mail'), "iconCls": "x-tbar-email_add", "overflowText": "per E-Mail", "auto_save": true } ],
  title : "Ereignisse/Notizen",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "date", "name": "date", "dateFormat": "d.m.Y" }, { "name": "event_type" },'event_typeHidden', { "name": "subject" }, { "name": "user" },'userHidden', { "type": "int", "name": "id" }, { "name": "owner_type" },'owner_typeHidden', { "name": "owner_id" },'owner_idHidden', { "name": "project" },'projectHidden', { "name": "build_time" }, { "name": "body" }, { "name": "language" },'languageHidden', { "name": "company" },'companyHidden', { "name": "owner" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 6,
  ls_grid_configs : [  ],
  content_type : 90,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 21,
  initComponent : function() {
    this.ls_detail_handler = Lino.notes.NotesByType.detail;
    this.ls_insert_handler = Lino.notes.NotesByType.insert;
    var ww = this.containing_window;
    var date1028 = new Lino.DateField({ "selectOnFocus": true, "allowBlank": false });
    var event_type1029 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/NotesByType/event_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Ereignisart ausw\u00e4hlen..." });
    var subject1030 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var user1031 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/NotesByType/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Benutzer ausw\u00e4hlen..." });
    var id1032 = new Ext.form.NumberField({ "selectOnFocus": true });
    var owner_type1033 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/NotesByType/owner_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Inhaltstyp ausw\u00e4hlen..." });
    var owner_id1034 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/NotesByType/owner_id", "method": "GET" }) }) });
    var project1035 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/NotesByType/project", "method": "GET" }) }), "pageSize": 20, "emptyText": "Klient ausw\u00e4hlen..." });
    var build_time1036 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var body1037 = new Lino.RichTextPanel({ "selectOnFocus": true, "containing_panel": this, "title": "Inhalt" });
    var language1038 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "allowBlank": false, "store": [ [ "de", "Deutsch" ], [ "fr", "Franz\u00f6sisch" ], [ "en", "Englisch" ] ] });
    var company1039 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/NotesByType/company", "method": "GET" }) }), "pageSize": 20, "emptyText": "Organisation ausw\u00e4hlen..." });
    var owner_disp1040 = new Ext.form.DisplayField({ "disabled": true });
    this.before_row_edit = function(record) {
      owner_id1034.setContextValue('owner_type',record ? record.data['owner_typeHidden'] : undefined);
      body1037.refresh();
    };
    this.onRender = function(ct, position) {
      owner_type1033.on('change',Lino.chooser_handler(owner_id1034,'owner_type'));
      Lino.notes.NotesByType.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Datum", "dataIndex": "date", "hidden": false, "width": Lino.chars2width(8), "editor": date1028 }, { "colIndex": 1, "sortable": true, "header": "Ereignisart (Form)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('event_typeHidden','Lino.notes.EventTypes.detail'), "hidden": false, "editor": event_type1029, "dataIndex": "event_type" }, { "colIndex": 2, "sortable": true, "header": "Thema", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "subject", "hidden": false, "editor": subject1030 }, { "colIndex": 3, "sortable": true, "header": "Autor", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(15), "dataIndex": "user", "hidden": false, "editor": user1031 }, { "colIndex": 4, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "renderer": Lino.id_renderer, "hidden": false, "editor": id1032, "dataIndex": "id" }, { "colIndex": 5, "sortable": true, "header": "Verkn\u00fcpft mit (Modell)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('owner_typeHidden','Lino.lino.ContentTypes.detail'), "hidden": false, "editor": owner_type1033, "dataIndex": "owner_type" }, { "colIndex": 6, "sortable": true, "header": "Verkn\u00fcpft mit (Objekt)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(10), "dataIndex": "owner_id", "hidden": false, "editor": owner_id1034 }, { "colIndex": 7, "sortable": true, "header": "Klient", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "project", "hidden": false, "editor": project1035 }, { "width": Lino.chars2width(16), "colIndex": 8, "sortable": true, "dataIndex": "build_time", "header": "Druckdatum", "hidden": false, "editable": false }, { "colIndex": 9, "sortable": false, "header": "body", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(60), "renderer": Lino.text_renderer, "hidden": false, "editor": body1037, "dataIndex": "body" }, { "colIndex": 10, "sortable": true, "header": "Sprache", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "language", "hidden": false, "editor": language1038 }, { "colIndex": 11, "sortable": true, "header": "Organisation", "editable": true, "tooltip": "    An optional third-party Organization that is related to this Note.\n    The note will then be visible in that company's history panel.\n    ", "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "company", "hidden": false, "editor": company1039 }, { "width": Lino.chars2width(30), "colIndex": 12, "sortable": false, "dataIndex": "owner", "header": "Verkn\u00fcpft mit", "hidden": false, "editable": false } ];
    Lino.notes.NotesByType.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.notes.NotesByType.insertPanel = Ext.extend(Lino.notes.Notes.InsertFormPanel,{
  empty_title: "Neu Ereignisse/Notizen",
  hide_navigator: true,
  ls_bbar_actions: [  ],
  ls_url: "/notes/NotesByType",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.notes.NotesByType.detail;
    this.ls_insert_handler = Lino.notes.NotesByType.insert;
    Lino.notes.NotesByType.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.notes.NotesByType.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(50), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.notes.NotesByType.insertPanel(p);
});

Lino.notes.NotesByType.detailPanel = Ext.extend(Lino.notes.Notes.DetailFormPanel,{
  empty_title: "Detail Ereignisse/Notizen",
  ls_bbar_actions: [ { "itemId": "duplicate_row", "menu_item_text": "Duplizieren", "must_save": true, "tooltip": "Duplizieren", "panel_btn_handler": Lino.row_action_handler('duplicate_row'), "iconCls": "x-tbar-duplicate", "overflowText": "Duplizieren", "auto_save": true }, { "itemId": "do_print", "menu_item_text": "Drucken", "must_save": true, "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print'), "iconCls": "x-tbar-print", "overflowText": "Drucken", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Cache l\u00f6schen", "must_save": true, "tooltip": "Cache l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('do_clear_cache'), "iconCls": "x-tbar-clearcache", "overflowText": "Cache l\u00f6schen", "auto_save": true }, { "itemId": "create_postings", "menu_item_text": "per Post", "must_save": true, "tooltip": "Create classical mail postings from this", "panel_btn_handler": Lino.row_action_handler('create_postings'), "iconCls": "x-tbar-create-postings", "overflowText": "per Post", "auto_save": true }, { "itemId": "create_mail", "menu_item_text": "per E-Mail", "must_save": true, "tooltip": "Create an email from this", "panel_btn_handler": Lino.row_action_handler('create_mail'), "iconCls": "x-tbar-email_add", "overflowText": "per E-Mail", "auto_save": true } ],
  ls_url: "/notes/NotesByType",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.notes.NotesByType.detail;
    this.ls_insert_handler = Lino.notes.NotesByType.insert;
    Lino.notes.NotesByType.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.notes.NotesByType.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.notes.NotesByType.detailPanel(p);
});
Lino.notes.NotesByType.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.notes.NotesByType.GridPanel(p);
});

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUInotes.NotesByEventTypeHandle
Lino.notes.NotesByEventType.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/notes/NotesByEventType",
  ls_bbar_actions : [ { "itemId": "duplicate_row", "menu_item_text": "Duplizieren", "must_save": true, "tooltip": "Duplizieren", "panel_btn_handler": Lino.row_action_handler('duplicate_row'), "iconCls": "x-tbar-duplicate", "overflowText": "Duplizieren", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": "do_print", "menu_item_text": "Drucken", "must_save": true, "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print'), "iconCls": "x-tbar-print", "overflowText": "Drucken", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Cache l\u00f6schen", "must_save": true, "tooltip": "Cache l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('do_clear_cache'), "iconCls": "x-tbar-clearcache", "overflowText": "Cache l\u00f6schen", "auto_save": true }, { "itemId": "create_postings", "menu_item_text": "per Post", "must_save": true, "tooltip": "Create classical mail postings from this", "panel_btn_handler": Lino.row_action_handler('create_postings'), "iconCls": "x-tbar-create-postings", "overflowText": "per Post", "auto_save": true }, { "itemId": "create_mail", "menu_item_text": "per E-Mail", "must_save": true, "tooltip": "Create an email from this", "panel_btn_handler": Lino.row_action_handler('create_mail'), "iconCls": "x-tbar-email_add", "overflowText": "per E-Mail", "auto_save": true } ],
  title : "Ereignisse/Notizen",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "date", "name": "date", "dateFormat": "d.m.Y" }, { "name": "type" },'typeHidden', { "name": "subject" }, { "name": "user" },'userHidden', { "type": "int", "name": "id" }, { "name": "owner_type" },'owner_typeHidden', { "name": "owner_id" },'owner_idHidden', { "name": "project" },'projectHidden', { "name": "build_time" }, { "name": "body" }, { "name": "language" },'languageHidden', { "name": "company" },'companyHidden', { "name": "owner" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 6,
  ls_grid_configs : [  ],
  content_type : 90,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 21,
  initComponent : function() {
    this.ls_detail_handler = Lino.notes.NotesByEventType.detail;
    this.ls_insert_handler = Lino.notes.NotesByEventType.insert;
    var ww = this.containing_window;
    var date879 = new Lino.DateField({ "selectOnFocus": true, "allowBlank": false });
    var type880 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/NotesByEventType/type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Notizart ausw\u00e4hlen..." });
    var subject881 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var user882 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/NotesByEventType/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Benutzer ausw\u00e4hlen..." });
    var id883 = new Ext.form.NumberField({ "selectOnFocus": true });
    var owner_type884 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/NotesByEventType/owner_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Inhaltstyp ausw\u00e4hlen..." });
    var owner_id885 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/NotesByEventType/owner_id", "method": "GET" }) }) });
    var project886 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/NotesByEventType/project", "method": "GET" }) }), "pageSize": 20, "emptyText": "Klient ausw\u00e4hlen..." });
    var build_time887 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var body888 = new Lino.RichTextPanel({ "selectOnFocus": true, "containing_panel": this, "title": "Inhalt" });
    var language889 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "allowBlank": false, "store": [ [ "de", "Deutsch" ], [ "fr", "Franz\u00f6sisch" ], [ "en", "Englisch" ] ] });
    var company890 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/NotesByEventType/company", "method": "GET" }) }), "pageSize": 20, "emptyText": "Organisation ausw\u00e4hlen..." });
    var owner_disp891 = new Ext.form.DisplayField({ "disabled": true });
    this.before_row_edit = function(record) {
      owner_id885.setContextValue('owner_type',record ? record.data['owner_typeHidden'] : undefined);
      body888.refresh();
    };
    this.onRender = function(ct, position) {
      owner_type884.on('change',Lino.chooser_handler(owner_id885,'owner_type'));
      Lino.notes.NotesByEventType.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Datum", "dataIndex": "date", "hidden": false, "width": Lino.chars2width(8), "editor": date879 }, { "colIndex": 1, "sortable": true, "header": "Notizart (Inhalt)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('typeHidden','Lino.notes.NoteTypes.detail'), "hidden": false, "editor": type880, "dataIndex": "type" }, { "colIndex": 2, "sortable": true, "header": "Thema", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "subject", "hidden": false, "editor": subject881 }, { "colIndex": 3, "sortable": true, "header": "Autor", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(15), "dataIndex": "user", "hidden": false, "editor": user882 }, { "colIndex": 4, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "renderer": Lino.id_renderer, "hidden": false, "editor": id883, "dataIndex": "id" }, { "colIndex": 5, "sortable": true, "header": "Verkn\u00fcpft mit (Modell)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('owner_typeHidden','Lino.lino.ContentTypes.detail'), "hidden": false, "editor": owner_type884, "dataIndex": "owner_type" }, { "colIndex": 6, "sortable": true, "header": "Verkn\u00fcpft mit (Objekt)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(10), "dataIndex": "owner_id", "hidden": false, "editor": owner_id885 }, { "colIndex": 7, "sortable": true, "header": "Klient", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "project", "hidden": false, "editor": project886 }, { "width": Lino.chars2width(16), "colIndex": 8, "sortable": true, "dataIndex": "build_time", "header": "Druckdatum", "hidden": false, "editable": false }, { "colIndex": 9, "sortable": false, "header": "body", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(60), "renderer": Lino.text_renderer, "hidden": false, "editor": body888, "dataIndex": "body" }, { "colIndex": 10, "sortable": true, "header": "Sprache", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "language", "hidden": false, "editor": language889 }, { "colIndex": 11, "sortable": true, "header": "Organisation", "editable": true, "tooltip": "    An optional third-party Organization that is related to this Note.\n    The note will then be visible in that company's history panel.\n    ", "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "company", "hidden": false, "editor": company890 }, { "width": Lino.chars2width(30), "colIndex": 12, "sortable": false, "dataIndex": "owner", "header": "Verkn\u00fcpft mit", "hidden": false, "editable": false } ];
    Lino.notes.NotesByEventType.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.notes.NotesByEventType.insertPanel = Ext.extend(Lino.notes.Notes.InsertFormPanel,{
  empty_title: "Neu Ereignisse/Notizen",
  hide_navigator: true,
  ls_bbar_actions: [  ],
  ls_url: "/notes/NotesByEventType",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.notes.NotesByEventType.detail;
    this.ls_insert_handler = Lino.notes.NotesByEventType.insert;
    Lino.notes.NotesByEventType.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.notes.NotesByEventType.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(50), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.notes.NotesByEventType.insertPanel(p);
});

Lino.notes.NotesByEventType.detailPanel = Ext.extend(Lino.notes.Notes.DetailFormPanel,{
  empty_title: "Detail Ereignisse/Notizen",
  ls_bbar_actions: [ { "itemId": "duplicate_row", "menu_item_text": "Duplizieren", "must_save": true, "tooltip": "Duplizieren", "panel_btn_handler": Lino.row_action_handler('duplicate_row'), "iconCls": "x-tbar-duplicate", "overflowText": "Duplizieren", "auto_save": true }, { "itemId": "do_print", "menu_item_text": "Drucken", "must_save": true, "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print'), "iconCls": "x-tbar-print", "overflowText": "Drucken", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Cache l\u00f6schen", "must_save": true, "tooltip": "Cache l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('do_clear_cache'), "iconCls": "x-tbar-clearcache", "overflowText": "Cache l\u00f6schen", "auto_save": true }, { "itemId": "create_postings", "menu_item_text": "per Post", "must_save": true, "tooltip": "Create classical mail postings from this", "panel_btn_handler": Lino.row_action_handler('create_postings'), "iconCls": "x-tbar-create-postings", "overflowText": "per Post", "auto_save": true }, { "itemId": "create_mail", "menu_item_text": "per E-Mail", "must_save": true, "tooltip": "Create an email from this", "panel_btn_handler": Lino.row_action_handler('create_mail'), "iconCls": "x-tbar-email_add", "overflowText": "per E-Mail", "auto_save": true } ],
  ls_url: "/notes/NotesByEventType",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.notes.NotesByEventType.detail;
    this.ls_insert_handler = Lino.notes.NotesByEventType.insert;
    Lino.notes.NotesByEventType.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.notes.NotesByEventType.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.notes.NotesByEventType.detailPanel(p);
});
Lino.notes.NotesByEventType.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.notes.NotesByEventType.GridPanel(p);
});

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUInotes.NotesByProjectHandle
Lino.notes.NotesByProject.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/notes/NotesByProject",
  ls_bbar_actions : [ { "itemId": "duplicate_row", "menu_item_text": "Duplizieren", "must_save": true, "tooltip": "Duplizieren", "panel_btn_handler": Lino.row_action_handler('duplicate_row'), "iconCls": "x-tbar-duplicate", "overflowText": "Duplizieren", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": "do_print", "menu_item_text": "Drucken", "must_save": true, "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print'), "iconCls": "x-tbar-print", "overflowText": "Drucken", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Cache l\u00f6schen", "must_save": true, "tooltip": "Cache l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('do_clear_cache'), "iconCls": "x-tbar-clearcache", "overflowText": "Cache l\u00f6schen", "auto_save": true }, { "itemId": "create_postings", "menu_item_text": "per Post", "must_save": true, "tooltip": "Create classical mail postings from this", "panel_btn_handler": Lino.row_action_handler('create_postings'), "iconCls": "x-tbar-create-postings", "overflowText": "per Post", "auto_save": true }, { "itemId": "create_mail", "menu_item_text": "per E-Mail", "must_save": true, "tooltip": "Create an email from this", "panel_btn_handler": Lino.row_action_handler('create_mail'), "iconCls": "x-tbar-email_add", "overflowText": "per E-Mail", "auto_save": true } ],
  title : "Ereignisse/Notizen",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "date", "name": "date", "dateFormat": "d.m.Y" }, { "name": "event_type" },'event_typeHidden', { "name": "type" },'typeHidden', { "name": "subject" }, { "name": "body" }, { "name": "user" },'userHidden', { "type": "int", "name": "id" }, { "name": "owner_type" },'owner_typeHidden', { "name": "owner_id" },'owner_idHidden', { "name": "build_time" }, { "name": "language" },'languageHidden', { "name": "company" },'companyHidden', { "name": "owner" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 9,
  ls_grid_configs : [  ],
  content_type : 90,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 21,
  initComponent : function() {
    this.ls_detail_handler = Lino.notes.NotesByProject.detail;
    this.ls_insert_handler = Lino.notes.NotesByProject.insert;
    var ww = this.containing_window;
    var date1441 = new Lino.DateField({ "selectOnFocus": true, "allowBlank": false });
    var event_type1442 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/NotesByProject/event_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Ereignisart ausw\u00e4hlen..." });
    var type1443 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/NotesByProject/type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Notizart ausw\u00e4hlen..." });
    var subject1444 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var body1445 = new Lino.RichTextPanel({ "selectOnFocus": true, "containing_panel": this, "title": "Inhalt" });
    var user1446 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/NotesByProject/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Benutzer ausw\u00e4hlen..." });
    var id1447 = new Ext.form.NumberField({ "selectOnFocus": true });
    var owner_type1448 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/NotesByProject/owner_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Inhaltstyp ausw\u00e4hlen..." });
    var owner_id1449 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/NotesByProject/owner_id", "method": "GET" }) }) });
    var build_time1450 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var language1451 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "allowBlank": false, "store": [ [ "de", "Deutsch" ], [ "fr", "Franz\u00f6sisch" ], [ "en", "Englisch" ] ] });
    var company1452 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/NotesByProject/company", "method": "GET" }) }), "pageSize": 20, "emptyText": "Organisation ausw\u00e4hlen..." });
    var owner_disp1453 = new Ext.form.DisplayField({ "disabled": true });
    this.before_row_edit = function(record) {
      body1445.refresh();
      owner_id1449.setContextValue('owner_type',record ? record.data['owner_typeHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      owner_type1448.on('change',Lino.chooser_handler(owner_id1449,'owner_type'));
      Lino.notes.NotesByProject.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Datum", "dataIndex": "date", "hidden": false, "width": Lino.chars2width(8), "editor": date1441 }, { "colIndex": 1, "sortable": true, "header": "Ereignisart (Form)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('event_typeHidden','Lino.notes.EventTypes.detail'), "hidden": false, "editor": event_type1442, "dataIndex": "event_type" }, { "colIndex": 2, "sortable": true, "header": "Notizart (Inhalt)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('typeHidden','Lino.notes.NoteTypes.detail'), "hidden": false, "editor": type1443, "dataIndex": "type" }, { "colIndex": 3, "sortable": true, "header": "Thema", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "subject", "hidden": false, "editor": subject1444 }, { "colIndex": 4, "sortable": false, "header": "body", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(60), "renderer": Lino.text_renderer, "hidden": false, "editor": body1445, "dataIndex": "body" }, { "colIndex": 5, "sortable": true, "header": "Autor", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(15), "dataIndex": "user", "hidden": false, "editor": user1446 }, { "colIndex": 6, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "renderer": Lino.id_renderer, "hidden": false, "editor": id1447, "dataIndex": "id" }, { "colIndex": 7, "sortable": true, "header": "Verkn\u00fcpft mit (Modell)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('owner_typeHidden','Lino.lino.ContentTypes.detail'), "hidden": false, "editor": owner_type1448, "dataIndex": "owner_type" }, { "colIndex": 8, "sortable": true, "header": "Verkn\u00fcpft mit (Objekt)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(10), "dataIndex": "owner_id", "hidden": false, "editor": owner_id1449 }, { "width": Lino.chars2width(16), "colIndex": 9, "sortable": true, "dataIndex": "build_time", "header": "Druckdatum", "hidden": false, "editable": false }, { "colIndex": 10, "sortable": true, "header": "Sprache", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "language", "hidden": false, "editor": language1451 }, { "colIndex": 11, "sortable": true, "header": "Organisation", "editable": true, "tooltip": "    An optional third-party Organization that is related to this Note.\n    The note will then be visible in that company's history panel.\n    ", "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "company", "hidden": false, "editor": company1452 }, { "width": Lino.chars2width(30), "colIndex": 12, "sortable": false, "dataIndex": "owner", "header": "Verkn\u00fcpft mit", "hidden": false, "editable": false } ];
    Lino.notes.NotesByProject.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.notes.NotesByProject.insertPanel = Ext.extend(Lino.notes.Notes.InsertFormPanel,{
  empty_title: "Neu Ereignisse/Notizen",
  hide_navigator: true,
  ls_bbar_actions: [  ],
  ls_url: "/notes/NotesByProject",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.notes.NotesByProject.detail;
    this.ls_insert_handler = Lino.notes.NotesByProject.insert;
    Lino.notes.NotesByProject.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.notes.NotesByProject.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(50), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.notes.NotesByProject.insertPanel(p);
});

Lino.notes.NotesByProject.detailPanel = Ext.extend(Lino.notes.Notes.DetailFormPanel,{
  empty_title: "Detail Ereignisse/Notizen",
  ls_bbar_actions: [ { "itemId": "duplicate_row", "menu_item_text": "Duplizieren", "must_save": true, "tooltip": "Duplizieren", "panel_btn_handler": Lino.row_action_handler('duplicate_row'), "iconCls": "x-tbar-duplicate", "overflowText": "Duplizieren", "auto_save": true }, { "itemId": "do_print", "menu_item_text": "Drucken", "must_save": true, "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print'), "iconCls": "x-tbar-print", "overflowText": "Drucken", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Cache l\u00f6schen", "must_save": true, "tooltip": "Cache l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('do_clear_cache'), "iconCls": "x-tbar-clearcache", "overflowText": "Cache l\u00f6schen", "auto_save": true }, { "itemId": "create_postings", "menu_item_text": "per Post", "must_save": true, "tooltip": "Create classical mail postings from this", "panel_btn_handler": Lino.row_action_handler('create_postings'), "iconCls": "x-tbar-create-postings", "overflowText": "per Post", "auto_save": true }, { "itemId": "create_mail", "menu_item_text": "per E-Mail", "must_save": true, "tooltip": "Create an email from this", "panel_btn_handler": Lino.row_action_handler('create_mail'), "iconCls": "x-tbar-email_add", "overflowText": "per E-Mail", "auto_save": true } ],
  ls_url: "/notes/NotesByProject",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.notes.NotesByProject.detail;
    this.ls_insert_handler = Lino.notes.NotesByProject.insert;
    Lino.notes.NotesByProject.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.notes.NotesByProject.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.notes.NotesByProject.detailPanel(p);
});
Lino.notes.NotesByProject.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.notes.NotesByProject.GridPanel(p);
});

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUIpcsw.ContactsByClientHandle
Lino.pcsw.ContactsByClient.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/pcsw/ContactsByClient",
  ls_bbar_actions : [  ],
  title : "Kontakte",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "type" },'typeHidden', { "name": "company" },'companyHidden', { "name": "contact_person" },'contact_personHidden', { "name": "contact_role" },'contact_roleHidden', { "name": "remark" }, { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 9,
  ls_grid_configs : [  ],
  content_type : 48,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 11,
  initComponent : function() {
    var ww = this.containing_window;
    var type1455 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/ContactsByClient/type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Klientenkontaktart ausw\u00e4hlen..." });
    var company1456 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/ContactsByClient/company", "method": "GET" }) }), "pageSize": 20, "emptyText": "Organisation ausw\u00e4hlen..." });
    var contact_person1457 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/ContactsByClient/contact_person", "method": "GET" }) }), "pageSize": 20, "emptyText": "Person ausw\u00e4hlen..." });
    var contact_role1458 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/ContactsByClient/contact_role", "method": "GET" }) }), "pageSize": 20, "emptyText": "Funktion ausw\u00e4hlen..." });
    var remark1459 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var id1460 = new Ext.form.NumberField({ "selectOnFocus": true });
    this.before_row_edit = function(record) {
      company1456.setContextValue('type',record ? record.data['typeHidden'] : undefined);
      contact_person1457.setContextValue('company',record ? record.data['companyHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      type1455.on('change',Lino.chooser_handler(company1456,'type'));
      company1456.on('change',Lino.chooser_handler(contact_person1457,'company'));
      Lino.pcsw.ContactsByClient.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Klientenkontaktart", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "type", "hidden": false, "editor": type1455 }, { "colIndex": 1, "sortable": true, "header": "Organisation", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "company", "hidden": false, "editor": company1456 }, { "colIndex": 2, "sortable": true, "header": "Kontaktperson", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "contact_person", "hidden": false, "editor": contact_person1457 }, { "colIndex": 3, "sortable": true, "header": "in seiner Eigenschaft als", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "contact_role", "hidden": false, "editor": contact_role1458 }, { "colIndex": 4, "sortable": false, "header": "Bemerkungen", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(60), "renderer": Lino.text_renderer, "hidden": false, "editor": remark1459, "dataIndex": "remark" }, { "colIndex": 5, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "renderer": Lino.id_renderer, "hidden": false, "editor": id1460, "dataIndex": "id" } ];
    Lino.pcsw.ContactsByClient.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.pcsw.ContactsByClient.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.pcsw.ContactsByClient.GridPanel(p);
});

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUIpcsw.CoachingsByClientHandle
Lino.pcsw.CoachingsByClient.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/pcsw/CoachingsByClient",
  ls_bbar_actions : [  ],
  title : "Begleitungen",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "date", "name": "start_date", "dateFormat": "d.m.Y" }, { "type": "date", "name": "end_date", "dateFormat": "d.m.Y" }, { "name": "user" },'userHidden', { "type": "boolean", "name": "primary" }, { "name": "type" },'typeHidden', { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 7,
  ls_grid_configs : [  ],
  content_type : 50,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 9,
  initComponent : function() {
    var ww = this.containing_window;
    var start_date1462 = new Lino.DateField({ "selectOnFocus": true });
    var end_date1463 = new Lino.DateField({ "selectOnFocus": true });
    var user1464 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/CoachingsByClient/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Benutzer ausw\u00e4hlen..." });
    var primary1465 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var type1466 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/CoachingsByClient/type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Dienst ausw\u00e4hlen..." });
    var id1467 = new Ext.form.NumberField({ "selectOnFocus": true });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Begleitet seit", "dataIndex": "start_date", "hidden": false, "width": Lino.chars2width(8), "editor": start_date1462 }, { "colIndex": 1, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "bis", "dataIndex": "end_date", "hidden": false, "width": Lino.chars2width(8), "editor": end_date1463 }, { "colIndex": 2, "sortable": true, "header": "Begleiter", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(15), "dataIndex": "user", "hidden": false, "editor": user1464 }, { "colIndex": 3, "sortable": false, "xtype": "checkcolumn", "header": "Prim\u00e4r", "editable": true, "tooltip": "There's at most one primary coach per client. \nEnabling this field will automatically make the other coachings non-primary.", "filter": { "type": "boolean" }, "width": Lino.chars2width(10), "dataIndex": "primary", "hidden": false }, { "colIndex": 4, "sortable": true, "header": "Dienst", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "type", "hidden": false, "editor": type1466 }, { "colIndex": 5, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "renderer": Lino.id_renderer, "hidden": false, "editor": id1467, "dataIndex": "id" } ];
    Lino.pcsw.CoachingsByClient.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.pcsw.CoachingsByClient.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.pcsw.CoachingsByClient.GridPanel(p);
});

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUIpcsw.CoachingsByUserHandle
Lino.pcsw.CoachingsByUser.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/pcsw/CoachingsByUser",
  ls_bbar_actions : [  ],
  title : "Begleitungen",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "date", "name": "start_date", "dateFormat": "d.m.Y" }, { "type": "date", "name": "end_date", "dateFormat": "d.m.Y" }, { "name": "client" },'clientHidden', { "name": "type" },'typeHidden', { "type": "boolean", "name": "primary" }, { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 7,
  ls_grid_configs : [  ],
  content_type : 50,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 9,
  initComponent : function() {
    var ww = this.containing_window;
    var start_date305 = new Lino.DateField({ "selectOnFocus": true });
    var end_date306 = new Lino.DateField({ "selectOnFocus": true });
    var client307 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/CoachingsByUser/client", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Klient ausw\u00e4hlen..." });
    var type308 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/CoachingsByUser/type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Dienst ausw\u00e4hlen..." });
    var primary309 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var id310 = new Ext.form.NumberField({ "selectOnFocus": true });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Begleitet seit", "dataIndex": "start_date", "hidden": false, "width": Lino.chars2width(8), "editor": start_date305 }, { "colIndex": 1, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "bis", "dataIndex": "end_date", "hidden": false, "width": Lino.chars2width(8), "editor": end_date306 }, { "colIndex": 2, "sortable": true, "header": "Klient", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "client", "hidden": false, "editor": client307 }, { "colIndex": 3, "sortable": true, "header": "Dienst", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "type", "hidden": false, "editor": type308 }, { "colIndex": 4, "sortable": false, "xtype": "checkcolumn", "header": "Prim\u00e4r", "editable": true, "tooltip": "There's at most one primary coach per client. \nEnabling this field will automatically make the other coachings non-primary.", "filter": { "type": "boolean" }, "width": Lino.chars2width(10), "dataIndex": "primary", "hidden": false }, { "colIndex": 5, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "renderer": Lino.id_renderer, "hidden": false, "editor": id310, "dataIndex": "id" } ];
    Lino.pcsw.CoachingsByUser.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.pcsw.CoachingsByUser.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.pcsw.CoachingsByUser.GridPanel(p);
});

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUIpcsw.MyCoachingsHandle
Lino.pcsw.MyCoachings.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/pcsw/MyCoachings",
  ls_bbar_actions : [  ],
  title : "Meine Begleitungen",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "date", "name": "start_date", "dateFormat": "d.m.Y" }, { "type": "date", "name": "end_date", "dateFormat": "d.m.Y" }, { "name": "client" },'clientHidden', { "name": "type" },'typeHidden', { "type": "boolean", "name": "primary" }, { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 7,
  ls_grid_configs : [  ],
  content_type : 50,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 9,
  initComponent : function() {
    var ww = this.containing_window;
    var start_date1469 = new Lino.DateField({ "selectOnFocus": true });
    var end_date1470 = new Lino.DateField({ "selectOnFocus": true });
    var client1471 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/MyCoachings/client", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Klient ausw\u00e4hlen..." });
    var type1472 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/MyCoachings/type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Dienst ausw\u00e4hlen..." });
    var primary1473 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var id1474 = new Ext.form.NumberField({ "selectOnFocus": true });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Begleitet seit", "dataIndex": "start_date", "hidden": false, "width": Lino.chars2width(8), "editor": start_date1469 }, { "colIndex": 1, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "bis", "dataIndex": "end_date", "hidden": false, "width": Lino.chars2width(8), "editor": end_date1470 }, { "colIndex": 2, "sortable": true, "header": "Klient", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "client", "hidden": false, "editor": client1471 }, { "colIndex": 3, "sortable": true, "header": "Dienst", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "type", "hidden": false, "editor": type1472 }, { "colIndex": 4, "sortable": false, "xtype": "checkcolumn", "header": "Prim\u00e4r", "editable": true, "tooltip": "There's at most one primary coach per client. \nEnabling this field will automatically make the other coachings non-primary.", "filter": { "type": "boolean" }, "width": Lino.chars2width(10), "dataIndex": "primary", "hidden": false }, { "colIndex": 5, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "renderer": Lino.id_renderer, "hidden": false, "editor": id1474, "dataIndex": "id" } ];
    Lino.pcsw.MyCoachings.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.pcsw.MyCoachings.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.pcsw.MyCoachings.GridPanel(p);
});

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUIpcsw.NotesByPersonHandle
Lino.pcsw.NotesByPerson.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/pcsw/NotesByPerson",
  ls_bbar_actions : [ { "itemId": "duplicate_row", "menu_item_text": "Duplizieren", "must_save": true, "tooltip": "Duplizieren", "panel_btn_handler": Lino.row_action_handler('duplicate_row'), "iconCls": "x-tbar-duplicate", "overflowText": "Duplizieren", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": "do_print", "menu_item_text": "Drucken", "must_save": true, "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print'), "iconCls": "x-tbar-print", "overflowText": "Drucken", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Cache l\u00f6schen", "must_save": true, "tooltip": "Cache l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('do_clear_cache'), "iconCls": "x-tbar-clearcache", "overflowText": "Cache l\u00f6schen", "auto_save": true }, { "itemId": "create_postings", "menu_item_text": "per Post", "must_save": true, "tooltip": "Create classical mail postings from this", "panel_btn_handler": Lino.row_action_handler('create_postings'), "iconCls": "x-tbar-create-postings", "overflowText": "per Post", "auto_save": true }, { "itemId": "create_mail", "menu_item_text": "per E-Mail", "must_save": true, "tooltip": "Create an email from this", "panel_btn_handler": Lino.row_action_handler('create_mail'), "iconCls": "x-tbar-email_add", "overflowText": "per E-Mail", "auto_save": true } ],
  title : "Ereignisse/Notizen",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "date", "name": "date", "dateFormat": "d.m.Y" }, { "name": "event_type" },'event_typeHidden', { "name": "type" },'typeHidden', { "name": "subject" }, { "name": "body" }, { "name": "user" },'userHidden', { "name": "company" },'companyHidden', { "type": "int", "name": "id" }, { "name": "owner_type" },'owner_typeHidden', { "name": "owner_id" },'owner_idHidden', { "name": "build_time" }, { "name": "language" },'languageHidden', { "name": "owner" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 11,
  ls_grid_configs : [  ],
  content_type : 90,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 21,
  initComponent : function() {
    this.ls_detail_handler = Lino.pcsw.NotesByPerson.detail;
    this.ls_insert_handler = Lino.pcsw.NotesByPerson.insert;
    var ww = this.containing_window;
    var date1476 = new Lino.DateField({ "selectOnFocus": true, "allowBlank": false });
    var event_type1477 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/NotesByPerson/event_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Ereignisart ausw\u00e4hlen..." });
    var type1478 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/NotesByPerson/type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Notizart ausw\u00e4hlen..." });
    var subject1479 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var body1480 = new Lino.RichTextPanel({ "selectOnFocus": true, "containing_panel": this, "title": "Inhalt" });
    var user1481 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/NotesByPerson/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Benutzer ausw\u00e4hlen..." });
    var company1482 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/NotesByPerson/company", "method": "GET" }) }), "pageSize": 20, "emptyText": "Organisation ausw\u00e4hlen..." });
    var id1483 = new Ext.form.NumberField({ "selectOnFocus": true });
    var owner_type1484 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/NotesByPerson/owner_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Inhaltstyp ausw\u00e4hlen..." });
    var owner_id1485 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/NotesByPerson/owner_id", "method": "GET" }) }) });
    var build_time1486 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var language1487 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "allowBlank": false, "store": [ [ "de", "Deutsch" ], [ "fr", "Franz\u00f6sisch" ], [ "en", "Englisch" ] ] });
    var owner_disp1488 = new Ext.form.DisplayField({ "disabled": true });
    this.before_row_edit = function(record) {
      body1480.refresh();
      owner_id1485.setContextValue('owner_type',record ? record.data['owner_typeHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      owner_type1484.on('change',Lino.chooser_handler(owner_id1485,'owner_type'));
      Lino.pcsw.NotesByPerson.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Datum", "dataIndex": "date", "hidden": false, "width": Lino.chars2width(8), "editor": date1476 }, { "colIndex": 1, "sortable": true, "header": "Ereignisart (Form)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('event_typeHidden','Lino.notes.EventTypes.detail'), "hidden": false, "editor": event_type1477, "dataIndex": "event_type" }, { "colIndex": 2, "sortable": true, "header": "Notizart (Inhalt)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('typeHidden','Lino.notes.NoteTypes.detail'), "hidden": false, "editor": type1478, "dataIndex": "type" }, { "colIndex": 3, "sortable": true, "header": "Thema", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "subject", "hidden": false, "editor": subject1479 }, { "colIndex": 4, "sortable": false, "header": "body", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(60), "renderer": Lino.text_renderer, "hidden": false, "editor": body1480, "dataIndex": "body" }, { "colIndex": 5, "sortable": true, "header": "Autor", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(15), "dataIndex": "user", "hidden": false, "editor": user1481 }, { "colIndex": 6, "sortable": true, "header": "Organisation", "editable": true, "tooltip": "    An optional third-party Organization that is related to this Note.\n    The note will then be visible in that company's history panel.\n    ", "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "company", "hidden": false, "editor": company1482 }, { "colIndex": 7, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "renderer": Lino.id_renderer, "hidden": false, "editor": id1483, "dataIndex": "id" }, { "colIndex": 8, "sortable": true, "header": "Verkn\u00fcpft mit (Modell)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('owner_typeHidden','Lino.lino.ContentTypes.detail'), "hidden": false, "editor": owner_type1484, "dataIndex": "owner_type" }, { "colIndex": 9, "sortable": true, "header": "Verkn\u00fcpft mit (Objekt)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(10), "dataIndex": "owner_id", "hidden": false, "editor": owner_id1485 }, { "width": Lino.chars2width(16), "colIndex": 10, "sortable": true, "dataIndex": "build_time", "header": "Druckdatum", "hidden": false, "editable": false }, { "colIndex": 11, "sortable": true, "header": "Sprache", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "language", "hidden": false, "editor": language1487 }, { "width": Lino.chars2width(30), "colIndex": 12, "sortable": false, "dataIndex": "owner", "header": "Verkn\u00fcpft mit", "hidden": false, "editable": false } ];
    Lino.pcsw.NotesByPerson.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.pcsw.NotesByPerson.insertPanel = Ext.extend(Lino.notes.Notes.InsertFormPanel,{
  empty_title: "Neu Ereignisse/Notizen",
  hide_navigator: true,
  ls_bbar_actions: [  ],
  ls_url: "/pcsw/NotesByPerson",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.pcsw.NotesByPerson.detail;
    this.ls_insert_handler = Lino.pcsw.NotesByPerson.insert;
    Lino.pcsw.NotesByPerson.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.pcsw.NotesByPerson.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(50), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.pcsw.NotesByPerson.insertPanel(p);
});

Lino.pcsw.NotesByPerson.detailPanel = Ext.extend(Lino.notes.Notes.DetailFormPanel,{
  empty_title: "Detail Ereignisse/Notizen",
  ls_bbar_actions: [ { "itemId": "duplicate_row", "menu_item_text": "Duplizieren", "must_save": true, "tooltip": "Duplizieren", "panel_btn_handler": Lino.row_action_handler('duplicate_row'), "iconCls": "x-tbar-duplicate", "overflowText": "Duplizieren", "auto_save": true }, { "itemId": "do_print", "menu_item_text": "Drucken", "must_save": true, "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print'), "iconCls": "x-tbar-print", "overflowText": "Drucken", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Cache l\u00f6schen", "must_save": true, "tooltip": "Cache l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('do_clear_cache'), "iconCls": "x-tbar-clearcache", "overflowText": "Cache l\u00f6schen", "auto_save": true }, { "itemId": "create_postings", "menu_item_text": "per Post", "must_save": true, "tooltip": "Create classical mail postings from this", "panel_btn_handler": Lino.row_action_handler('create_postings'), "iconCls": "x-tbar-create-postings", "overflowText": "per Post", "auto_save": true }, { "itemId": "create_mail", "menu_item_text": "per E-Mail", "must_save": true, "tooltip": "Create an email from this", "panel_btn_handler": Lino.row_action_handler('create_mail'), "iconCls": "x-tbar-email_add", "overflowText": "per E-Mail", "auto_save": true } ],
  ls_url: "/pcsw/NotesByPerson",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.pcsw.NotesByPerson.detail;
    this.ls_insert_handler = Lino.pcsw.NotesByPerson.insert;
    Lino.pcsw.NotesByPerson.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.pcsw.NotesByPerson.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.pcsw.NotesByPerson.detailPanel(p);
});
Lino.pcsw.NotesByPerson.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.pcsw.NotesByPerson.GridPanel(p);
});

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUIpcsw.NotesByCompanyHandle
Lino.pcsw.NotesByCompany.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/pcsw/NotesByCompany",
  ls_bbar_actions : [ { "itemId": "duplicate_row", "menu_item_text": "Duplizieren", "must_save": true, "tooltip": "Duplizieren", "panel_btn_handler": Lino.row_action_handler('duplicate_row'), "iconCls": "x-tbar-duplicate", "overflowText": "Duplizieren", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": "do_print", "menu_item_text": "Drucken", "must_save": true, "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print'), "iconCls": "x-tbar-print", "overflowText": "Drucken", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Cache l\u00f6schen", "must_save": true, "tooltip": "Cache l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('do_clear_cache'), "iconCls": "x-tbar-clearcache", "overflowText": "Cache l\u00f6schen", "auto_save": true }, { "itemId": "create_postings", "menu_item_text": "per Post", "must_save": true, "tooltip": "Create classical mail postings from this", "panel_btn_handler": Lino.row_action_handler('create_postings'), "iconCls": "x-tbar-create-postings", "overflowText": "per Post", "auto_save": true }, { "itemId": "create_mail", "menu_item_text": "per E-Mail", "must_save": true, "tooltip": "Create an email from this", "panel_btn_handler": Lino.row_action_handler('create_mail'), "iconCls": "x-tbar-email_add", "overflowText": "per E-Mail", "auto_save": true } ],
  title : "Ereignisse/Notizen",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "date", "name": "date", "dateFormat": "d.m.Y" }, { "name": "project" },'projectHidden', { "name": "event_type" },'event_typeHidden', { "name": "type" },'typeHidden', { "name": "subject" }, { "name": "body" }, { "name": "user" },'userHidden', { "type": "int", "name": "id" }, { "name": "owner_type" },'owner_typeHidden', { "name": "owner_id" },'owner_idHidden', { "name": "build_time" }, { "name": "language" },'languageHidden', { "name": "owner" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 11,
  ls_grid_configs : [  ],
  content_type : 90,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 21,
  initComponent : function() {
    this.ls_detail_handler = Lino.pcsw.NotesByCompany.detail;
    this.ls_insert_handler = Lino.pcsw.NotesByCompany.insert;
    var ww = this.containing_window;
    var date1490 = new Lino.DateField({ "selectOnFocus": true, "allowBlank": false });
    var project1491 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/NotesByCompany/project", "method": "GET" }) }), "pageSize": 20, "emptyText": "Klient ausw\u00e4hlen..." });
    var event_type1492 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/NotesByCompany/event_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Ereignisart ausw\u00e4hlen..." });
    var type1493 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/NotesByCompany/type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Notizart ausw\u00e4hlen..." });
    var subject1494 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var body1495 = new Lino.RichTextPanel({ "selectOnFocus": true, "containing_panel": this, "title": "Inhalt" });
    var user1496 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/NotesByCompany/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Benutzer ausw\u00e4hlen..." });
    var id1497 = new Ext.form.NumberField({ "selectOnFocus": true });
    var owner_type1498 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/NotesByCompany/owner_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Inhaltstyp ausw\u00e4hlen..." });
    var owner_id1499 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/NotesByCompany/owner_id", "method": "GET" }) }) });
    var build_time1500 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var language1501 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "allowBlank": false, "store": [ [ "de", "Deutsch" ], [ "fr", "Franz\u00f6sisch" ], [ "en", "Englisch" ] ] });
    var owner_disp1502 = new Ext.form.DisplayField({ "disabled": true });
    this.before_row_edit = function(record) {
      body1495.refresh();
      owner_id1499.setContextValue('owner_type',record ? record.data['owner_typeHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      owner_type1498.on('change',Lino.chooser_handler(owner_id1499,'owner_type'));
      Lino.pcsw.NotesByCompany.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Datum", "dataIndex": "date", "hidden": false, "width": Lino.chars2width(8), "editor": date1490 }, { "colIndex": 1, "sortable": true, "header": "Klient", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "project", "hidden": false, "editor": project1491 }, { "colIndex": 2, "sortable": true, "header": "Ereignisart (Form)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('event_typeHidden','Lino.notes.EventTypes.detail'), "hidden": false, "editor": event_type1492, "dataIndex": "event_type" }, { "colIndex": 3, "sortable": true, "header": "Notizart (Inhalt)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('typeHidden','Lino.notes.NoteTypes.detail'), "hidden": false, "editor": type1493, "dataIndex": "type" }, { "colIndex": 4, "sortable": true, "header": "Thema", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "subject", "hidden": false, "editor": subject1494 }, { "colIndex": 5, "sortable": false, "header": "body", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(60), "renderer": Lino.text_renderer, "hidden": false, "editor": body1495, "dataIndex": "body" }, { "colIndex": 6, "sortable": true, "header": "Autor", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(15), "dataIndex": "user", "hidden": false, "editor": user1496 }, { "colIndex": 7, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "renderer": Lino.id_renderer, "hidden": false, "editor": id1497, "dataIndex": "id" }, { "colIndex": 8, "sortable": true, "header": "Verkn\u00fcpft mit (Modell)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('owner_typeHidden','Lino.lino.ContentTypes.detail'), "hidden": false, "editor": owner_type1498, "dataIndex": "owner_type" }, { "colIndex": 9, "sortable": true, "header": "Verkn\u00fcpft mit (Objekt)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(10), "dataIndex": "owner_id", "hidden": false, "editor": owner_id1499 }, { "width": Lino.chars2width(16), "colIndex": 10, "sortable": true, "dataIndex": "build_time", "header": "Druckdatum", "hidden": false, "editable": false }, { "colIndex": 11, "sortable": true, "header": "Sprache", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "language", "hidden": false, "editor": language1501 }, { "width": Lino.chars2width(30), "colIndex": 12, "sortable": false, "dataIndex": "owner", "header": "Verkn\u00fcpft mit", "hidden": false, "editable": false } ];
    Lino.pcsw.NotesByCompany.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.pcsw.NotesByCompany.insertPanel = Ext.extend(Lino.notes.Notes.InsertFormPanel,{
  empty_title: "Neu Ereignisse/Notizen",
  hide_navigator: true,
  ls_bbar_actions: [  ],
  ls_url: "/pcsw/NotesByCompany",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.pcsw.NotesByCompany.detail;
    this.ls_insert_handler = Lino.pcsw.NotesByCompany.insert;
    Lino.pcsw.NotesByCompany.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.pcsw.NotesByCompany.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(50), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.pcsw.NotesByCompany.insertPanel(p);
});

Lino.pcsw.NotesByCompany.detailPanel = Ext.extend(Lino.notes.Notes.DetailFormPanel,{
  empty_title: "Detail Ereignisse/Notizen",
  ls_bbar_actions: [ { "itemId": "duplicate_row", "menu_item_text": "Duplizieren", "must_save": true, "tooltip": "Duplizieren", "panel_btn_handler": Lino.row_action_handler('duplicate_row'), "iconCls": "x-tbar-duplicate", "overflowText": "Duplizieren", "auto_save": true }, { "itemId": "do_print", "menu_item_text": "Drucken", "must_save": true, "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print'), "iconCls": "x-tbar-print", "overflowText": "Drucken", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Cache l\u00f6schen", "must_save": true, "tooltip": "Cache l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('do_clear_cache'), "iconCls": "x-tbar-clearcache", "overflowText": "Cache l\u00f6schen", "auto_save": true }, { "itemId": "create_postings", "menu_item_text": "per Post", "must_save": true, "tooltip": "Create classical mail postings from this", "panel_btn_handler": Lino.row_action_handler('create_postings'), "iconCls": "x-tbar-create-postings", "overflowText": "per Post", "auto_save": true }, { "itemId": "create_mail", "menu_item_text": "per E-Mail", "must_save": true, "tooltip": "Create an email from this", "panel_btn_handler": Lino.row_action_handler('create_mail'), "iconCls": "x-tbar-email_add", "overflowText": "per E-Mail", "auto_save": true } ],
  ls_url: "/pcsw/NotesByCompany",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.pcsw.NotesByCompany.detail;
    this.ls_insert_handler = Lino.pcsw.NotesByCompany.insert;
    Lino.pcsw.NotesByCompany.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.pcsw.NotesByCompany.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.pcsw.NotesByCompany.detailPanel(p);
});
Lino.pcsw.NotesByCompany.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.pcsw.NotesByCompany.GridPanel(p);
});

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUIjobs.CandidaturesByOfferHandle
Lino.jobs.CandidaturesByOffer.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/jobs/CandidaturesByOffer",
  ls_bbar_actions : [  ],
  title : "Kandidaten",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "sector" },'sectorHidden', { "name": "function" },'functionHidden', { "name": "person" },'personHidden', { "name": "job" },'jobHidden', { "type": "date", "name": "date_submitted", "dateFormat": "d.m.Y" }, { "name": "remark" }, { "type": "boolean", "name": "active" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 65,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 13,
  initComponent : function() {
    var ww = this.containing_window;
    var id1504 = new Ext.form.NumberField({ "selectOnFocus": true });
    var sector1505 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/CandidaturesByOffer/sector", "method": "GET" }) }), "pageSize": 20, "emptyText": "Sektor ausw\u00e4hlen..." });
    var function1506 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/CandidaturesByOffer/function", "method": "GET" }) }), "pageSize": 20, "emptyText": "Funktion ausw\u00e4hlen..." });
    var person1507 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/CandidaturesByOffer/person", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Klient ausw\u00e4hlen..." });
    var job1508 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/CandidaturesByOffer/job", "method": "GET" }) }), "pageSize": 20, "emptyText": "Stelle ausw\u00e4hlen..." });
    var date_submitted1509 = new Lino.DateField({ "selectOnFocus": true, "allowBlank": false });
    var remark1510 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var active1511 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": true });
    this.before_row_edit = function(record) {
      function1506.setContextValue('sector',record ? record.data['sectorHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      sector1505.on('change',Lino.chooser_handler(function1506,'sector'));
      Lino.jobs.CandidaturesByOffer.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "renderer": Lino.id_renderer, "hidden": false, "editor": id1504, "dataIndex": "id" }, { "colIndex": 1, "sortable": true, "header": "Sektor", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "sector", "hidden": false, "editor": sector1505 }, { "colIndex": 2, "sortable": true, "header": "Funktion", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "function", "hidden": false, "editor": function1506 }, { "colIndex": 3, "sortable": true, "header": "Klient", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "person", "hidden": false, "editor": person1507 }, { "colIndex": 4, "sortable": true, "header": "Stelle", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "job", "hidden": false, "editor": job1508 }, { "colIndex": 5, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "eingereicht am ", "dataIndex": "date_submitted", "hidden": false, "width": Lino.chars2width(8), "editor": date_submitted1509 }, { "colIndex": 6, "sortable": false, "header": "Bemerkungen", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(60), "renderer": Lino.text_renderer, "hidden": false, "editor": remark1510, "dataIndex": "remark" }, { "colIndex": 7, "sortable": false, "xtype": "checkcolumn", "header": "Active", "editable": true, "filter": { "type": "boolean" }, "width": Lino.chars2width(10), "dataIndex": "active", "hidden": false } ];
    Lino.jobs.CandidaturesByOffer.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.jobs.CandidaturesByOffer.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.jobs.CandidaturesByOffer.GridPanel(p);
});

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUIjobs.ExperiencesByOfferHandle
Lino.jobs.ExperiencesByOffer.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/jobs/ExperiencesByOffer",
  ls_bbar_actions : [  ],
  title : "Kandidaten",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "sector" },'sectorHidden', { "name": "function" },'functionHidden', { "name": "person" },'personHidden', { "name": "company" }, { "name": "title" }, { "name": "country" },'countryHidden', { "type": "date", "name": "started", "dateFormat": "d.m.Y" }, { "type": "date", "name": "stopped", "dateFormat": "d.m.Y" }, { "name": "remarks" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 68,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 15,
  initComponent : function() {
    var ww = this.containing_window;
    var id1513 = new Ext.form.NumberField({ "selectOnFocus": true });
    var sector1514 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/ExperiencesByOffer/sector", "method": "GET" }) }), "pageSize": 20, "emptyText": "Sektor ausw\u00e4hlen..." });
    var function1515 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/ExperiencesByOffer/function", "method": "GET" }) }), "pageSize": 20, "emptyText": "Funktion ausw\u00e4hlen..." });
    var person1516 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/ExperiencesByOffer/person", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Klient ausw\u00e4hlen..." });
    var company1517 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var title1518 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var country1519 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/ExperiencesByOffer/country", "method": "GET" }) }), "pageSize": 20, "emptyText": "Land ausw\u00e4hlen..." });
    var started1520 = new Lino.DateField({ "selectOnFocus": true, "format": "m/Y", "plugins": "monthPickerPlugin" });
    var stopped1521 = new Lino.DateField({ "selectOnFocus": true, "format": "m/Y", "plugins": "monthPickerPlugin" });
    var remarks1522 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    this.before_row_edit = function(record) {
      function1515.setContextValue('sector',record ? record.data['sectorHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      sector1514.on('change',Lino.chooser_handler(function1515,'sector'));
      Lino.jobs.ExperiencesByOffer.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "renderer": Lino.id_renderer, "hidden": false, "editor": id1513, "dataIndex": "id" }, { "colIndex": 1, "sortable": true, "header": "Sektor", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "sector", "hidden": false, "editor": sector1514 }, { "colIndex": 2, "sortable": true, "header": "Funktion", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "function", "hidden": false, "editor": function1515 }, { "colIndex": 3, "sortable": true, "header": "Klient", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "person", "hidden": false, "editor": person1516 }, { "colIndex": 4, "sortable": true, "header": "Firma", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "company", "hidden": false, "editor": company1517 }, { "colIndex": 5, "sortable": true, "header": "Bezeichnung", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "title", "hidden": false, "editor": title1518 }, { "colIndex": 6, "sortable": true, "header": "Land", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('countryHidden','Lino.countries.Countries.detail'), "hidden": false, "editor": country1519, "dataIndex": "country" }, { "colIndex": 7, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "begonnen", "dataIndex": "started", "hidden": false, "width": Lino.chars2width(8), "editor": started1520 }, { "colIndex": 8, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "beendet", "dataIndex": "stopped", "hidden": false, "width": Lino.chars2width(8), "editor": stopped1521 }, { "colIndex": 9, "sortable": false, "header": "Bemerkungen", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(60), "renderer": Lino.text_renderer, "hidden": false, "editor": remarks1522, "dataIndex": "remarks" } ];
    Lino.jobs.ExperiencesByOffer.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.jobs.ExperiencesByOffer.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.jobs.ExperiencesByOffer.GridPanel(p);
});

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUInewcomers.CompetencesByUserHandle
Lino.newcomers.CompetencesByUser.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/newcomers/CompetencesByUser",
  ls_bbar_actions : [ { "itemId": "duplicate_row", "menu_item_text": "Duplizieren", "must_save": true, "panel_btn_handler": Lino.row_action_handler('duplicate_row'), "text": "Duplizieren", "overflowText": "Duplizieren", "auto_save": true } ],
  title : "Kompetenzen",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "seqno" }, { "name": "faculty" },'facultyHidden', { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 3,
  ls_grid_configs : [  ],
  content_type : 79,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 5,
  initComponent : function() {
    var ww = this.containing_window;
    var seqno296 = new Ext.form.NumberField({ "selectOnFocus": true });
    var faculty297 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/newcomers/CompetencesByUser/faculty", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Fachbereich ausw\u00e4hlen..." });
    var id298 = new Ext.form.NumberField({ "selectOnFocus": true });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Seq.-Nr.", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "dataIndex": "seqno", "hidden": false, "editor": seqno296 }, { "colIndex": 1, "sortable": true, "header": "Fachbereich", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "faculty", "hidden": false, "editor": faculty297 }, { "colIndex": 2, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "renderer": Lino.id_renderer, "hidden": false, "editor": id298, "dataIndex": "id" } ];
    Lino.newcomers.CompetencesByUser.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.newcomers.CompetencesByUser.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.newcomers.CompetencesByUser.GridPanel(p);
});
Lino.newcomers.CompetencesByUser.duplicate_row = function(rp,pk) { 
  Lino.run_row_action(rp,"/newcomers/CompetencesByUser",pk,"duplicate_row");
};

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUInewcomers.MyCompetencesHandle
Lino.newcomers.MyCompetences.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/newcomers/MyCompetences",
  ls_bbar_actions : [ { "itemId": "duplicate_row", "menu_item_text": "Duplizieren", "must_save": true, "panel_btn_handler": Lino.row_action_handler('duplicate_row'), "text": "Duplizieren", "overflowText": "Duplizieren", "auto_save": true } ],
  title : "Meine Kompetenzen",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "seqno" }, { "name": "faculty" },'facultyHidden', { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 3,
  ls_grid_configs : [  ],
  content_type : 79,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 5,
  initComponent : function() {
    var ww = this.containing_window;
    var seqno1524 = new Ext.form.NumberField({ "selectOnFocus": true });
    var faculty1525 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/newcomers/MyCompetences/faculty", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Fachbereich ausw\u00e4hlen..." });
    var id1526 = new Ext.form.NumberField({ "selectOnFocus": true });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Seq.-Nr.", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "dataIndex": "seqno", "hidden": false, "editor": seqno1524 }, { "colIndex": 1, "sortable": true, "header": "Fachbereich", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "faculty", "hidden": false, "editor": faculty1525 }, { "colIndex": 2, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "renderer": Lino.id_renderer, "hidden": false, "editor": id1526, "dataIndex": "id" } ];
    Lino.newcomers.MyCompetences.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.newcomers.MyCompetences.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.newcomers.MyCompetences.GridPanel(p);
});
Lino.newcomers.MyCompetences.duplicate_row = function(rp,pk) { 
  Lino.run_row_action(rp,"/newcomers/MyCompetences",pk,"duplicate_row");
};

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUIcbss.RetrieveTIGroupsRequestsByPersonHandle
Lino.cbss.RetrieveTIGroupsRequestsByPerson.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/cbss/RetrieveTIGroupsRequestsByPerson",
  ls_bbar_actions : [ { "itemId": "duplicate_row", "menu_item_text": "Duplizieren", "must_save": true, "tooltip": "Duplizieren", "panel_btn_handler": Lino.row_action_handler('duplicate_row'), "iconCls": "x-tbar-duplicate", "overflowText": "Duplizieren", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": "print_action", "menu_item_text": "Drucken", "must_save": true, "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('print_action'), "iconCls": "x-tbar-print", "overflowText": "Drucken", "auto_save": true } ],
  title : "Tx25-Anfragen",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "user" },'userHidden', { "name": "person" },'personHidden', { "name": "national_id" }, { "name": "language" },'languageHidden', { "type": "boolean", "name": "history" }, { "name": "status" },'statusHidden', { "name": "ticket" }, { "name": "sent" }, { "name": "environment" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 88,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 15,
  initComponent : function() {
    this.ls_detail_handler = Lino.cbss.RetrieveTIGroupsRequestsByPerson.detail;
    this.ls_insert_handler = Lino.cbss.RetrieveTIGroupsRequestsByPerson.insert;
    var ww = this.containing_window;
    var id1528 = new Ext.form.NumberField({ "selectOnFocus": true });
    var user1529 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cbss/RetrieveTIGroupsRequestsByPerson/user", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Benutzer ausw\u00e4hlen..." });
    var person1530 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cbss/RetrieveTIGroupsRequestsByPerson/person", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Klient ausw\u00e4hlen..." });
    var national_id1531 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var language1532 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": Lino.cbss.RequestLanguages });
    var history1533 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var status1534 = new Lino.ChoicesFieldElement({ "disabled": true, "forceSelection": true, "store": Lino.cbss.RequestStates });
    var ticket1535 = new Ext.form.TextField({ "disabled": true, "maxLength": 36 });
    var sent1536 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var environment1537 = new Ext.form.TextField({ "disabled": true, "boxMinWidth": Lino.chars2width(4), "maxLength": 4 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "renderer": Lino.id_renderer, "hidden": false, "editor": id1528, "dataIndex": "id" }, { "colIndex": 1, "sortable": true, "header": "Autor", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(15), "dataIndex": "user", "hidden": false, "editor": user1529 }, { "colIndex": 2, "sortable": true, "header": "Klient", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "person", "hidden": false, "editor": person1530 }, { "colIndex": 3, "sortable": true, "header": "NR-Nummer", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "national_id", "hidden": false, "editor": national_id1531 }, { "colIndex": 4, "sortable": true, "header": "Sprache", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(14), "dataIndex": "language", "hidden": false, "editor": language1532 }, { "colIndex": 5, "sortable": false, "xtype": "checkcolumn", "header": "Chronik", "editable": true, "tooltip": "Whatever this means.", "filter": { "type": "boolean" }, "width": Lino.chars2width(10), "dataIndex": "history", "hidden": false }, { "colIndex": 6, "sortable": true, "header": "Zustand", "editable": false, "filter": { "type": "string" }, "width": Lino.chars2width(15), "dataIndex": "status", "hidden": false }, { "colIndex": 7, "sortable": true, "header": "Ticket", "editable": false, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "ticket", "hidden": false }, { "colIndex": 8, "sortable": true, "header": "Versendet", "editable": false, "tooltip": "The date and time when this request has been executed. \nThis is empty for requests than haven't been sent.\nRead-only.", "width": Lino.chars2width(16), "dataIndex": "sent", "hidden": false }, { "colIndex": 9, "sortable": true, "header": "T/A/B", "editable": false, "filter": { "type": "string" }, "width": Lino.chars2width(5), "dataIndex": "environment", "hidden": false } ];
    Lino.cbss.RetrieveTIGroupsRequestsByPerson.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.cbss.RetrieveTIGroupsRequestsByPerson.insertPanel = Ext.extend(Lino.cbss.RetrieveTIGroupsRequests.InsertFormPanel,{
  empty_title: "Neu Tx25-Anfragen",
  hide_navigator: true,
  ls_bbar_actions: [  ],
  ls_url: "/cbss/RetrieveTIGroupsRequestsByPerson",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.cbss.RetrieveTIGroupsRequestsByPerson.detail;
    this.ls_insert_handler = Lino.cbss.RetrieveTIGroupsRequestsByPerson.insert;
    Lino.cbss.RetrieveTIGroupsRequestsByPerson.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.cbss.RetrieveTIGroupsRequestsByPerson.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(40), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.cbss.RetrieveTIGroupsRequestsByPerson.insertPanel(p);
});

Lino.cbss.RetrieveTIGroupsRequestsByPerson.detailPanel = Ext.extend(Lino.cbss.RetrieveTIGroupsRequests.DetailFormPanel,{
  empty_title: "Detail Tx25-Anfragen",
  ls_bbar_actions: [ { "itemId": "duplicate_row", "menu_item_text": "Duplizieren", "must_save": true, "tooltip": "Duplizieren", "panel_btn_handler": Lino.row_action_handler('duplicate_row'), "iconCls": "x-tbar-duplicate", "overflowText": "Duplizieren", "auto_save": true }, { "itemId": "print_action", "menu_item_text": "Drucken", "must_save": true, "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('print_action'), "iconCls": "x-tbar-print", "overflowText": "Drucken", "auto_save": true } ],
  ls_url: "/cbss/RetrieveTIGroupsRequestsByPerson",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.cbss.RetrieveTIGroupsRequestsByPerson.detail;
    this.ls_insert_handler = Lino.cbss.RetrieveTIGroupsRequestsByPerson.insert;
    Lino.cbss.RetrieveTIGroupsRequestsByPerson.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.cbss.RetrieveTIGroupsRequestsByPerson.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cbss.RetrieveTIGroupsRequestsByPerson.detailPanel(p);
});
Lino.cbss.RetrieveTIGroupsRequestsByPerson.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cbss.RetrieveTIGroupsRequestsByPerson.GridPanel(p);
});

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUIcbss.MyRetrieveTIGroupsRequestsHandle
Lino.cbss.MyRetrieveTIGroupsRequests.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/cbss/MyRetrieveTIGroupsRequests",
  ls_bbar_actions : [ { "itemId": "duplicate_row", "menu_item_text": "Duplizieren", "must_save": true, "tooltip": "Duplizieren", "panel_btn_handler": Lino.row_action_handler('duplicate_row'), "iconCls": "x-tbar-duplicate", "overflowText": "Duplizieren", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": "print_action", "menu_item_text": "Drucken", "must_save": true, "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('print_action'), "iconCls": "x-tbar-print", "overflowText": "Drucken", "auto_save": true } ],
  title : "Meine Tx25-Anfragen",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "user" },'userHidden', { "name": "person" },'personHidden', { "name": "national_id" }, { "name": "language" },'languageHidden', { "type": "boolean", "name": "history" }, { "name": "status" },'statusHidden', { "name": "ticket" }, { "name": "sent" }, { "name": "environment" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 88,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 15,
  initComponent : function() {
    this.ls_detail_handler = Lino.cbss.MyRetrieveTIGroupsRequests.detail;
    this.ls_insert_handler = Lino.cbss.MyRetrieveTIGroupsRequests.insert;
    var ww = this.containing_window;
    var id1539 = new Ext.form.NumberField({ "selectOnFocus": true });
    var user1540 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cbss/MyRetrieveTIGroupsRequests/user", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Benutzer ausw\u00e4hlen..." });
    var person1541 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cbss/MyRetrieveTIGroupsRequests/person", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Klient ausw\u00e4hlen..." });
    var national_id1542 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var language1543 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": Lino.cbss.RequestLanguages });
    var history1544 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var status1545 = new Lino.ChoicesFieldElement({ "disabled": true, "forceSelection": true, "store": Lino.cbss.RequestStates });
    var ticket1546 = new Ext.form.TextField({ "disabled": true, "maxLength": 36 });
    var sent1547 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var environment1548 = new Ext.form.TextField({ "disabled": true, "boxMinWidth": Lino.chars2width(4), "maxLength": 4 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "renderer": Lino.id_renderer, "hidden": false, "editor": id1539, "dataIndex": "id" }, { "colIndex": 1, "sortable": true, "header": "Autor", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(15), "dataIndex": "user", "hidden": false, "editor": user1540 }, { "colIndex": 2, "sortable": true, "header": "Klient", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "person", "hidden": false, "editor": person1541 }, { "colIndex": 3, "sortable": true, "header": "NR-Nummer", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "national_id", "hidden": false, "editor": national_id1542 }, { "colIndex": 4, "sortable": true, "header": "Sprache", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(14), "dataIndex": "language", "hidden": false, "editor": language1543 }, { "colIndex": 5, "sortable": false, "xtype": "checkcolumn", "header": "Chronik", "editable": true, "tooltip": "Whatever this means.", "filter": { "type": "boolean" }, "width": Lino.chars2width(10), "dataIndex": "history", "hidden": false }, { "colIndex": 6, "sortable": true, "header": "Zustand", "editable": false, "filter": { "type": "string" }, "width": Lino.chars2width(15), "dataIndex": "status", "hidden": false }, { "colIndex": 7, "sortable": true, "header": "Ticket", "editable": false, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "ticket", "hidden": false }, { "colIndex": 8, "sortable": true, "header": "Versendet", "editable": false, "tooltip": "The date and time when this request has been executed. \nThis is empty for requests than haven't been sent.\nRead-only.", "width": Lino.chars2width(16), "dataIndex": "sent", "hidden": false }, { "colIndex": 9, "sortable": true, "header": "T/A/B", "editable": false, "filter": { "type": "string" }, "width": Lino.chars2width(5), "dataIndex": "environment", "hidden": false } ];
    Lino.cbss.MyRetrieveTIGroupsRequests.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.cbss.MyRetrieveTIGroupsRequests.insertPanel = Ext.extend(Lino.cbss.RetrieveTIGroupsRequests.InsertFormPanel,{
  empty_title: "Neu Meine Tx25-Anfragen",
  hide_navigator: true,
  ls_bbar_actions: [  ],
  ls_url: "/cbss/MyRetrieveTIGroupsRequests",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.cbss.MyRetrieveTIGroupsRequests.detail;
    this.ls_insert_handler = Lino.cbss.MyRetrieveTIGroupsRequests.insert;
    Lino.cbss.MyRetrieveTIGroupsRequests.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.cbss.MyRetrieveTIGroupsRequests.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(40), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.cbss.MyRetrieveTIGroupsRequests.insertPanel(p);
});

Lino.cbss.MyRetrieveTIGroupsRequests.detailPanel = Ext.extend(Lino.cbss.RetrieveTIGroupsRequests.DetailFormPanel,{
  empty_title: "Detail Meine Tx25-Anfragen",
  ls_bbar_actions: [ { "itemId": "duplicate_row", "menu_item_text": "Duplizieren", "must_save": true, "tooltip": "Duplizieren", "panel_btn_handler": Lino.row_action_handler('duplicate_row'), "iconCls": "x-tbar-duplicate", "overflowText": "Duplizieren", "auto_save": true }, { "itemId": "print_action", "menu_item_text": "Drucken", "must_save": true, "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('print_action'), "iconCls": "x-tbar-print", "overflowText": "Drucken", "auto_save": true } ],
  ls_url: "/cbss/MyRetrieveTIGroupsRequests",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.cbss.MyRetrieveTIGroupsRequests.detail;
    this.ls_insert_handler = Lino.cbss.MyRetrieveTIGroupsRequests.insert;
    Lino.cbss.MyRetrieveTIGroupsRequests.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.cbss.MyRetrieveTIGroupsRequests.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cbss.MyRetrieveTIGroupsRequests.detailPanel(p);
});
Lino.cbss.MyRetrieveTIGroupsRequests.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cbss.MyRetrieveTIGroupsRequests.GridPanel(p);
});

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUIcourses.CoursesByOfferHandle
Lino.courses.CoursesByOffer.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/courses/CoursesByOffer",
  ls_bbar_actions : [ { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": "print_participants", "menu_item_text": "Teilnehmerliste", "must_save": true, "tooltip": "Teilnehmerliste", "panel_btn_handler": Lino.row_action_handler('print_participants'), "iconCls": "x-tbar-print", "overflowText": "Teilnehmerliste", "auto_save": true }, { "itemId": "print_candidates", "menu_item_text": "Kandidatenliste", "must_save": true, "tooltip": "Kandidatenliste", "panel_btn_handler": Lino.row_action_handler('print_candidates'), "iconCls": "x-tbar-print", "overflowText": "Kandidatenliste", "auto_save": true } ],
  title : "Kurse",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "date", "name": "start_date", "dateFormat": "d.m.Y" }, { "name": "title" }, { "name": "remark" }, { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 3,
  ls_grid_configs : [  ],
  content_type : 92,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 5,
  initComponent : function() {
    this.ls_detail_handler = Lino.courses.CoursesByOffer.detail;
    this.ls_insert_handler = Lino.courses.CoursesByOffer.insert;
    var ww = this.containing_window;
    var start_date582 = new Lino.DateField({ "selectOnFocus": true, "allowBlank": false });
    var title583 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var remark584 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var id585 = new Ext.form.NumberField({ "selectOnFocus": true });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "beginnt am", "dataIndex": "start_date", "hidden": false, "width": Lino.chars2width(8), "editor": start_date582 }, { "colIndex": 1, "sortable": true, "header": "Name", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "title", "hidden": false, "editor": title583 }, { "colIndex": 2, "sortable": true, "header": "Bemerkungen", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "remark", "hidden": false, "editor": remark584 }, { "colIndex": 3, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "renderer": Lino.id_renderer, "hidden": false, "editor": id585, "dataIndex": "id" } ];
    Lino.courses.CoursesByOffer.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.courses.CoursesByOffer.insertPanel = Ext.extend(Lino.courses.Courses.DetailFormPanel,{
  empty_title: "Neu Kurse",
  hide_navigator: true,
  ls_bbar_actions: [  ],
  ls_url: "/courses/CoursesByOffer",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.courses.CoursesByOffer.detail;
    this.ls_insert_handler = Lino.courses.CoursesByOffer.insert;
    Lino.courses.CoursesByOffer.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.courses.CoursesByOffer.insert = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.courses.CoursesByOffer.insertPanel(p);
});

Lino.courses.CoursesByOffer.detailPanel = Ext.extend(Lino.courses.Courses.DetailFormPanel,{
  empty_title: "Detail Kurse",
  ls_bbar_actions: [ { "itemId": "print_participants", "menu_item_text": "Teilnehmerliste", "must_save": true, "tooltip": "Teilnehmerliste", "panel_btn_handler": Lino.row_action_handler('print_participants'), "iconCls": "x-tbar-print", "overflowText": "Teilnehmerliste", "auto_save": true }, { "itemId": "print_candidates", "menu_item_text": "Kandidatenliste", "must_save": true, "tooltip": "Kandidatenliste", "panel_btn_handler": Lino.row_action_handler('print_candidates'), "iconCls": "x-tbar-print", "overflowText": "Kandidatenliste", "auto_save": true } ],
  ls_url: "/courses/CoursesByOffer",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.courses.CoursesByOffer.detail;
    this.ls_insert_handler = Lino.courses.CoursesByOffer.insert;
    Lino.courses.CoursesByOffer.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.courses.CoursesByOffer.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.courses.CoursesByOffer.detailPanel(p);
});
Lino.courses.CoursesByOffer.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.courses.CoursesByOffer.GridPanel(p);
});

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUIcourses.CourseOffersByProviderHandle
Lino.courses.CourseOffersByProvider.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/courses/CourseOffersByProvider",
  ls_bbar_actions : [ { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true } ],
  title : "Kursangebote",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "title" }, { "name": "content" },'contentHidden', { "name": "description" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 94,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 6,
  initComponent : function() {
    this.ls_detail_handler = Lino.courses.CourseOffersByProvider.detail;
    this.ls_insert_handler = Lino.courses.CourseOffersByProvider.insert;
    var ww = this.containing_window;
    var id1550 = new Ext.form.NumberField({ "selectOnFocus": true });
    var title1551 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var content1552 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/courses/CourseOffersByProvider/content", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Kursinhalt ausw\u00e4hlen..." });
    var description1553 = new Lino.RichTextPanel({ "selectOnFocus": true, "containing_panel": this, "title": "Beschreibung" });
    this.before_row_edit = function(record) {
      description1553.refresh();
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "renderer": Lino.id_renderer, "hidden": false, "editor": id1550, "dataIndex": "id" }, { "colIndex": 1, "sortable": true, "header": "Name", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "title", "hidden": false, "editor": title1551 }, { "colIndex": 2, "sortable": true, "header": "Kursinhalt", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "content", "hidden": false, "editor": content1552 }, { "colIndex": 3, "sortable": false, "header": "description", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(60), "renderer": Lino.text_renderer, "hidden": false, "editor": description1553, "dataIndex": "description" } ];
    Lino.courses.CourseOffersByProvider.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.courses.CourseOffersByProvider.insertPanel = Ext.extend(Lino.courses.CourseOffers.DetailFormPanel,{
  empty_title: "Neu Kursangebote",
  hide_navigator: true,
  ls_bbar_actions: [  ],
  ls_url: "/courses/CourseOffersByProvider",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.courses.CourseOffersByProvider.detail;
    this.ls_insert_handler = Lino.courses.CourseOffersByProvider.insert;
    Lino.courses.CourseOffersByProvider.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.courses.CourseOffersByProvider.insert = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.courses.CourseOffersByProvider.insertPanel(p);
});

Lino.courses.CourseOffersByProvider.detailPanel = Ext.extend(Lino.courses.CourseOffers.DetailFormPanel,{
  empty_title: "Detail Kursangebote",
  ls_bbar_actions: [  ],
  ls_url: "/courses/CourseOffersByProvider",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.courses.CourseOffersByProvider.detail;
    this.ls_insert_handler = Lino.courses.CourseOffersByProvider.insert;
    Lino.courses.CourseOffersByProvider.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.courses.CourseOffersByProvider.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.courses.CourseOffersByProvider.detailPanel(p);
});
Lino.courses.CourseOffersByProvider.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.courses.CourseOffersByProvider.GridPanel(p);
});

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUIuploads.UploadsByControllerHandle
Lino.uploads.UploadsByController.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/uploads/UploadsByController",
  ls_bbar_actions : [ { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true } ],
  title : "Uploads",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "file" }, { "name": "type" },'typeHidden', { "name": "description" }, { "name": "user" },'userHidden', { "type": "int", "name": "id" }, { "name": "owner_type" },'owner_typeHidden', { "name": "owner_id" },'owner_idHidden', { "name": "created" }, { "name": "modified" }, { "name": "mimetype" }, { "type": "date", "name": "valid_until", "dateFormat": "d.m.Y" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 6,
  ls_grid_configs : [  ],
  content_type : 25,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 16,
  initComponent : function() {
    this.ls_detail_handler = Lino.uploads.UploadsByController.detail;
    this.ls_insert_handler = Lino.uploads.UploadsByController.insert;
    var ww = this.containing_window;
    var file1555 = Lino.file_field_handler(this,{ "selectOnFocus": true, "allowBlank": false, "maxLength": 100 });
    var type1556 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/UploadsByController/type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Upload-Art ausw\u00e4hlen..." });
    var description1557 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var user1558 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/UploadsByController/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Benutzer ausw\u00e4hlen..." });
    var id1559 = new Ext.form.NumberField({ "selectOnFocus": true });
    var owner_type1560 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/UploadsByController/owner_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Inhaltstyp ausw\u00e4hlen..." });
    var owner_id1561 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/UploadsByController/owner_id", "method": "GET" }) }) });
    var created1562 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var modified1563 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var mimetype1564 = new Ext.form.TextField({ "disabled": true, "maxLength": 64 });
    var valid_until1565 = new Lino.DateField({ "selectOnFocus": true });
    this.before_row_edit = function(record) {
      owner_id1561.setContextValue('owner_type',record ? record.data['owner_typeHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      owner_type1560.on('change',Lino.chooser_handler(owner_id1561,'owner_type'));
      Lino.uploads.UploadsByController.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Datei", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "file", "hidden": false, "editor": file1555 }, { "colIndex": 1, "sortable": true, "header": "Upload-Art", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "type", "hidden": false, "editor": type1556 }, { "colIndex": 2, "sortable": true, "header": "Beschreibung", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "description", "hidden": false, "editor": description1557 }, { "colIndex": 3, "sortable": true, "header": "Autor", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(15), "dataIndex": "user", "hidden": false, "editor": user1558 }, { "colIndex": 4, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "renderer": Lino.id_renderer, "hidden": false, "editor": id1559, "dataIndex": "id" }, { "colIndex": 5, "sortable": true, "header": "Verkn\u00fcpft mit (Modell)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('owner_typeHidden','Lino.lino.ContentTypes.detail'), "hidden": false, "editor": owner_type1560, "dataIndex": "owner_type" }, { "colIndex": 6, "sortable": true, "header": "Verkn\u00fcpft mit (Objekt)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(10), "dataIndex": "owner_id", "hidden": false, "editor": owner_id1561 }, { "width": Lino.chars2width(16), "colIndex": 7, "sortable": true, "dataIndex": "created", "header": "Erstellt", "hidden": false, "editable": false }, { "width": Lino.chars2width(16), "colIndex": 8, "sortable": true, "dataIndex": "modified", "header": "Bearbeitet", "hidden": false, "editable": false }, { "colIndex": 9, "sortable": true, "header": "MIME-Art", "editable": false, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "mimetype", "hidden": false }, { "colIndex": 10, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "g\u00fcltig bis", "dataIndex": "valid_until", "hidden": false, "width": Lino.chars2width(8), "editor": valid_until1565 } ];
    Lino.uploads.UploadsByController.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.uploads.UploadsByController.insertPanel = Ext.extend(Lino.uploads.Uploads.InsertFormPanel,{
  empty_title: "Neu Uploads",
  hide_navigator: true,
  ls_bbar_actions: [  ],
  ls_url: "/uploads/UploadsByController",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.uploads.UploadsByController.detail;
    this.ls_insert_handler = Lino.uploads.UploadsByController.insert;
    Lino.uploads.UploadsByController.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.uploads.UploadsByController.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.uploads.UploadsByController.insertPanel(p);
});

Lino.uploads.UploadsByController.detailPanel = Ext.extend(Lino.uploads.Uploads.DetailFormPanel,{
  empty_title: "Detail Uploads",
  ls_bbar_actions: [  ],
  ls_url: "/uploads/UploadsByController",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.uploads.UploadsByController.detail;
    this.ls_insert_handler = Lino.uploads.UploadsByController.insert;
    Lino.uploads.UploadsByController.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.uploads.UploadsByController.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.uploads.UploadsByController.detailPanel(p);
});
Lino.uploads.UploadsByController.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.uploads.UploadsByController.GridPanel(p);
});

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUIlino.HelpTextsByModelHandle
Lino.lino.HelpTextsByModel.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/lino/HelpTextsByModel",
  ls_bbar_actions : [  ],
  title : "Hilfetexte",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "field" }, { "name": "verbose_name" }, { "name": "help_text" }, { "type": "int", "name": "id" }, { "name": "content_type" },'content_typeHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 3,
  ls_grid_configs : [  ],
  content_type : 4,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 7,
  initComponent : function() {
    var ww = this.containing_window;
    var field95 = new Lino.SimpleRemoteComboFieldElement({ "selectOnFocus": true, "allowBlank": false, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/lino/HelpTextsByModel/field", "method": "GET" }) }) });
    var verbose_name96 = new Ext.form.TextField({ "disabled": true, "maxLength": 200 });
    var help_text97 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var id98 = new Ext.form.NumberField({ "selectOnFocus": true });
    var content_type99 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/lino/HelpTextsByModel/content_type", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Inhaltstyp ausw\u00e4hlen..." });
    this.before_row_edit = function(record) {
      var bp = this.get_base_params();
      field95.setContextValue('mk',bp['mk']);
      field95.setContextValue('mt',bp['mt']);
    };
    this.onRender = function(ct, position) {
      content_type99.on('change',Lino.chooser_handler(field95,'content_type'));
      Lino.lino.HelpTextsByModel.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Feld", "editable": true, "tooltip": "The name of the field.", "filter": { "type": "string" }, "width": Lino.chars2width(10), "dataIndex": "field", "hidden": false, "editor": field95 }, { "colIndex": 1, "sortable": false, "header": "Feldbezeichnung", "editable": false, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "verbose_name", "hidden": false }, { "colIndex": 2, "sortable": false, "header": "Hilfetext", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(60), "renderer": Lino.text_renderer, "hidden": false, "editor": help_text97, "dataIndex": "help_text" }, { "colIndex": 3, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "renderer": Lino.id_renderer, "hidden": false, "editor": id98, "dataIndex": "id" }, { "colIndex": 4, "sortable": true, "header": "Modell", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('content_typeHidden','Lino.lino.ContentTypes.detail'), "hidden": false, "editor": content_type99, "dataIndex": "content_type" } ];
    Lino.lino.HelpTextsByModel.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.lino.HelpTextsByModel.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.lino.HelpTextsByModel.GridPanel(p);
});

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUIpostings.PostingsByControllerHandle
Lino.postings.PostingsByController.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/postings/PostingsByController",
  ls_bbar_actions : [ { "itemId": "print_action", "menu_item_text": "Drucken", "must_save": true, "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('print_action'), "iconCls": "x-tbar-print", "overflowText": "Drucken", "auto_save": true } ],
  title : "Postsendungen",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "date", "name": "date", "dateFormat": "d.m.Y" }, { "name": "partner" },'partnerHidden', { "name": "state" },'stateHidden', { "name": "workflow_buttons" }, { "type": "int", "name": "id" }, { "name": "owner_type" },'owner_typeHidden', { "name": "owner_id" },'owner_idHidden', { "name": "user" },'userHidden', { "name": "project" },'projectHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 6,
  ls_grid_configs : [  ],
  content_type : 39,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 16,
  initComponent : function() {
    var ww = this.containing_window;
    var date959 = new Lino.DateField({ "selectOnFocus": true, "allowBlank": false });
    var partner960 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/postings/PostingsByController/partner", "method": "GET" }) }), "pageSize": 20, "emptyText": "Partner ausw\u00e4hlen..." });
    var state961 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.postings.PostingStates });
    var workflow_buttons_disp962 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var id963 = new Ext.form.NumberField({ "selectOnFocus": true });
    var owner_type964 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/postings/PostingsByController/owner_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Inhaltstyp ausw\u00e4hlen..." });
    var owner_id965 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/postings/PostingsByController/owner_id", "method": "GET" }) }) });
    var user966 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/postings/PostingsByController/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Benutzer ausw\u00e4hlen..." });
    var project967 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/postings/PostingsByController/project", "method": "GET" }) }), "pageSize": 20, "emptyText": "Klient ausw\u00e4hlen..." });
    this.before_row_edit = function(record) {
      owner_id965.setContextValue('owner_type',record ? record.data['owner_typeHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      owner_type964.on('change',Lino.chooser_handler(owner_id965,'owner_type'));
      Lino.postings.PostingsByController.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "date", "dataIndex": "date", "hidden": false, "width": Lino.chars2width(8), "editor": date959 }, { "colIndex": 1, "sortable": true, "header": "Empf\u00e4ngerEmpf\u00e4nger", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "partner", "hidden": false, "editor": partner960 }, { "colIndex": 2, "sortable": true, "header": "Zustand", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(19), "dataIndex": "state", "hidden": false, "editor": state961 }, { "width": Lino.chars2width(30), "colIndex": 3, "sortable": false, "dataIndex": "workflow_buttons", "header": "Arbeitsablauf", "hidden": false, "editable": false }, { "colIndex": 4, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "renderer": Lino.id_renderer, "hidden": false, "editor": id963, "dataIndex": "id" }, { "colIndex": 5, "sortable": true, "header": "Verkn\u00fcpft mit (Modell)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('owner_typeHidden','Lino.lino.ContentTypes.detail'), "hidden": false, "editor": owner_type964, "dataIndex": "owner_type" }, { "colIndex": 6, "sortable": true, "header": "Verkn\u00fcpft mit (Objekt)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(10), "dataIndex": "owner_id", "hidden": false, "editor": owner_id965 }, { "colIndex": 7, "sortable": true, "header": "Autor", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(15), "dataIndex": "user", "hidden": false, "editor": user966 }, { "colIndex": 8, "sortable": true, "header": "Klient", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "project", "hidden": false, "editor": project967 } ];
    Lino.postings.PostingsByController.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.postings.PostingsByController.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.postings.PostingsByController.GridPanel(p);
});
Lino.postings.PostingsByController.print_action = function(rp,pk) { 
  Lino.run_row_action(rp,"/postings/PostingsByController",pk,"print_action");
};

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUIlino.ChangesByMasterHandle
Lino.lino.ChangesByMaster.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/lino/ChangesByMaster",
  ls_bbar_actions : [ { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true } ],
  title : "\u00c4nderungen",
  page_length : 20,
  stripeRows : true,
  disable_editing : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "time" }, { "name": "user" },'userHidden', { "name": "type" },'typeHidden', { "name": "object" }, { "name": "diff" }, { "name": "object_type" },'object_typeHidden', { "name": "object_id" },'object_idHidden', { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" } ],
  pk_index : 11,
  ls_grid_configs : [  ],
  content_type : 3,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 13,
  initComponent : function() {
    this.ls_detail_handler = Lino.lino.ChangesByMaster.detail;
    var ww = this.containing_window;
    var time769 = new Ext.form.DisplayField({ "selectOnFocus": true, "allowBlank": false, "value": "<br>" });
    var user770 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/lino/ChangesByMaster/user", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Benutzer ausw\u00e4hlen..." });
    var type771 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.lino.ChangeTypes });
    var object_disp772 = new Ext.form.DisplayField({ "disabled": true });
    var diff773 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var object_type774 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/lino/ChangesByMaster/object_type", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Inhaltstyp ausw\u00e4hlen..." });
    var object_id775 = new Ext.form.NumberField({ "selectOnFocus": true, "allowBlank": false });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "time", "editable": true, "width": Lino.chars2width(16), "dataIndex": "time", "hidden": false, "editor": time769 }, { "colIndex": 1, "sortable": true, "header": "Benutzer", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(15), "dataIndex": "user", "hidden": false, "editor": user770 }, { "colIndex": 2, "sortable": true, "header": "\u00c4nderungsart", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(14), "dataIndex": "type", "hidden": false, "editor": type771 }, { "width": Lino.chars2width(30), "colIndex": 3, "sortable": false, "dataIndex": "object", "header": "Object", "hidden": false, "editable": false }, { "colIndex": 4, "sortable": false, "header": "\u00c4nderungen", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(60), "renderer": Lino.text_renderer, "hidden": false, "editor": diff773, "dataIndex": "diff" }, { "colIndex": 5, "sortable": true, "header": "Inhaltstyp", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('object_typeHidden','Lino.lino.ContentTypes.detail'), "hidden": false, "editor": object_type774, "dataIndex": "object_type" }, { "colIndex": 6, "sortable": true, "header": "object id", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "dataIndex": "object_id", "hidden": false, "editor": object_id775 } ];
    Lino.lino.ChangesByMaster.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.lino.ChangesByMaster.detailPanel = Ext.extend(Lino.lino.Changes.DetailFormPanel,{
  empty_title: "Detail \u00c4nderungen",
  ls_bbar_actions: [  ],
  ls_url: "/lino/ChangesByMaster",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.lino.ChangesByMaster.detail;
    Lino.lino.ChangesByMaster.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.lino.ChangesByMaster.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.lino.ChangesByMaster.detailPanel(p);
});
Lino.lino.ChangesByMaster.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.lino.ChangesByMaster.GridPanel(p);
});

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUIoutbox.MailsByControllerHandle
Lino.outbox.MailsByController.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/outbox/MailsByController",
  ls_bbar_actions : [ { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": "send_mail", "menu_item_text": "E-Mail senden", "must_save": true, "tooltip": "E-Mail senden", "panel_btn_handler": Lino.row_action_handler('send_mail'), "iconCls": "x-tbar-email_send", "overflowText": "E-Mail senden", "auto_save": true } ],
  title : "E-Mail-Ausg\u00e4nge",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "sent" }, { "name": "recipients" }, { "name": "subject" }, { "type": "int", "name": "id" }, { "name": "owner_type" },'owner_typeHidden', { "name": "owner_id" },'owner_idHidden', { "name": "user" },'userHidden', { "name": "project" },'projectHidden', { "type": "date", "name": "date", "dateFormat": "d.m.Y" }, { "name": "body" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 3,
  ls_grid_configs : [  ],
  content_type : 28,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 15,
  initComponent : function() {
    this.ls_detail_handler = Lino.outbox.MailsByController.detail;
    this.ls_insert_handler = Lino.outbox.MailsByController.insert;
    var ww = this.containing_window;
    var sent919 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var recipients_htmlbox920 = new Lino.HtmlBoxPanel({ "layout": "fit", "name": "recipients", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "title": "Empf\u00e4nger", "master_panel": this, "value": "<br/>", "always_enabled": true, "bodyStyle": "overflow-x:hidden !important;" });
    var subject921 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var id922 = new Ext.form.NumberField({ "selectOnFocus": true });
    var owner_type923 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/MailsByController/owner_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Inhaltstyp ausw\u00e4hlen..." });
    var owner_id924 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/MailsByController/owner_id", "method": "GET" }) }) });
    var user925 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/MailsByController/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Benutzer ausw\u00e4hlen..." });
    var project926 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/MailsByController/project", "method": "GET" }) }), "pageSize": 20, "emptyText": "Klient ausw\u00e4hlen..." });
    var date927 = new Lino.DateField({ "disabled": true });
    var body928 = new Lino.RichTextPanel({ "selectOnFocus": true, "containing_panel": this, "title": "Inhalt" });
    this.before_row_edit = function(record) {
      recipients_htmlbox920.refresh();
      owner_id924.setContextValue('owner_type',record ? record.data['owner_typeHidden'] : undefined);
      body928.refresh();
    };
    this.onRender = function(ct, position) {
      owner_type923.on('change',Lino.chooser_handler(owner_id924,'owner_type'));
      Lino.outbox.MailsByController.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "width": Lino.chars2width(16), "colIndex": 0, "sortable": true, "dataIndex": "sent", "header": "sent", "hidden": false, "editable": false }, { "colIndex": 1, "sortable": false, "header": "Empf\u00e4nger", "editable": false, "filter": { "type": "string" }, "width": Lino.chars2width(30), "dataIndex": "recipients", "hidden": false }, { "colIndex": 2, "sortable": true, "header": "Thema", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "subject", "hidden": false, "editor": subject921 }, { "colIndex": 3, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "renderer": Lino.id_renderer, "hidden": false, "editor": id922, "dataIndex": "id" }, { "colIndex": 4, "sortable": true, "header": "Verkn\u00fcpft mit (Modell)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('owner_typeHidden','Lino.lino.ContentTypes.detail'), "hidden": false, "editor": owner_type923, "dataIndex": "owner_type" }, { "colIndex": 5, "sortable": true, "header": "Verkn\u00fcpft mit (Objekt)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(10), "dataIndex": "owner_id", "hidden": false, "editor": owner_id924 }, { "colIndex": 6, "sortable": true, "header": "Sender", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(15), "dataIndex": "user", "hidden": false, "editor": user925 }, { "colIndex": 7, "sortable": true, "header": "Klient", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "project", "hidden": false, "editor": project926 }, { "colIndex": 8, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": false, "tooltip": "\n        The official date to be printed on the document.\n        ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Datum", "dataIndex": "date", "hidden": false, "width": Lino.chars2width(8) }, { "colIndex": 9, "sortable": false, "header": "body", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(60), "renderer": Lino.text_renderer, "hidden": false, "editor": body928, "dataIndex": "body" } ];
    Lino.outbox.MailsByController.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.outbox.MailsByController.insertPanel = Ext.extend(Lino.outbox.MailsByUser.InsertFormPanel,{
  empty_title: "Neu E-Mail-Ausg\u00e4nge",
  hide_navigator: true,
  ls_bbar_actions: [  ],
  ls_url: "/outbox/MailsByController",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.outbox.MailsByController.detail;
    this.ls_insert_handler = Lino.outbox.MailsByController.insert;
    Lino.outbox.MailsByController.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.outbox.MailsByController.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "maximizable": true, "modal": true, "maximized": false, "height": Lino.rows2height(20) },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.outbox.MailsByController.insertPanel(p);
});

Lino.outbox.MailsByController.detailPanel = Ext.extend(Lino.outbox.MailsByUser.DetailFormPanel,{
  empty_title: "Detail E-Mail-Ausg\u00e4nge",
  ls_bbar_actions: [ { "itemId": "send_mail", "menu_item_text": "E-Mail senden", "must_save": true, "tooltip": "E-Mail senden", "panel_btn_handler": Lino.row_action_handler('send_mail'), "iconCls": "x-tbar-email_send", "overflowText": "E-Mail senden", "auto_save": true } ],
  ls_url: "/outbox/MailsByController",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.outbox.MailsByController.detail;
    this.ls_insert_handler = Lino.outbox.MailsByController.insert;
    Lino.outbox.MailsByController.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.outbox.MailsByController.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.outbox.MailsByController.detailPanel(p);
});
Lino.outbox.MailsByController.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.outbox.MailsByController.GridPanel(p);
});

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUIabout.ModelsHandle
Lino.about.Models.GridPanel = Ext.extend(Lino.GridPanel,{
  ls_url : "/about/Models",
  ls_bbar_actions : [ { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true } ],
  title : "Modelle",
  page_length : 20,
  gc_name : 0,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "app" }, { "name": "name" }, { "name": "docstring" }, { "name": "rows" }, { "name": "detail_action" }, { "name": "disabled_fields" }, { "name": "disabled_actions" } ],
  ls_grid_configs : [  ],
  viewConfig : { "emptyText": "Keine Daten anzuzeigen." },
  disable_editing : true,
  disabled_actions_index : 6,
  initComponent : function() {
    this.ls_detail_handler = Lino.about.Models.detail;
    var ww = this.containing_window;
    var app_disp1567 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var name_disp1568 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var docstring_disp1569 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var rows_disp1570 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var detail_action_disp1571 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "width": Lino.chars2width(30), "colIndex": 0, "sortable": false, "dataIndex": "app", "header": "app_label", "hidden": false, "editable": false }, { "width": Lino.chars2width(30), "colIndex": 1, "sortable": false, "dataIndex": "name", "header": "Name", "hidden": false, "editable": false }, { "width": Lino.chars2width(30), "colIndex": 2, "sortable": false, "dataIndex": "docstring", "header": "docstring", "hidden": false, "editable": false }, { "width": Lino.chars2width(8), "colIndex": 3, "sortable": false, "dataIndex": "rows", "header": "Zeilen", "hidden": false, "editable": false }, { "width": Lino.chars2width(30), "colIndex": 4, "sortable": false, "dataIndex": "detail_action", "header": "detail_action", "hidden": false, "editable": false } ];
    Lino.about.Models.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.about.Models.detailPanel = Ext.extend(Lino.about.Models.DetailFormPanel,{
  empty_title: "Detail Modelle",
  ls_bbar_actions: [  ],
  ls_url: "/about/Models",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.about.Models.detail;
    Lino.about.Models.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.about.Models.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.about.Models.detailPanel(p);
});
Lino.about.Models.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.about.Models.GridPanel(p);
});

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUIabout.FieldsByModelHandle
Lino.about.FieldsByModel.GridPanel = Ext.extend(Lino.GridPanel,{
  ls_url : "/about/FieldsByModel",
  ls_bbar_actions : [  ],
  title : "Felder",
  page_length : 20,
  gc_name : 0,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "name" }, { "name": "verbose_name" }, { "name": "help_text_column" }, { "name": "disabled_fields" }, { "name": "disabled_actions" } ],
  ls_grid_configs : [  ],
  viewConfig : { "emptyText": "Keine Daten anzuzeigen." },
  disable_editing : true,
  disabled_actions_index : 4,
  initComponent : function() {
    var ww = this.containing_window;
    var name_disp828 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var verbose_name_disp829 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var help_text_column_disp830 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "width": Lino.chars2width(30), "colIndex": 0, "sortable": false, "dataIndex": "name", "header": "Name", "hidden": false, "editable": false }, { "width": Lino.chars2width(30), "colIndex": 1, "sortable": false, "dataIndex": "verbose_name", "header": "Feldbezeichnung", "hidden": false, "editable": false }, { "width": Lino.chars2width(30), "colIndex": 2, "sortable": false, "dataIndex": "help_text_column", "header": "Hilfetext", "hidden": false, "editable": false } ];
    Lino.about.FieldsByModel.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.about.FieldsByModel.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.about.FieldsByModel.GridPanel(p);
});

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUIabout.SourceFilesHandle
Lino.about.SourceFiles.GridPanel = Ext.extend(Lino.GridPanel,{
  ls_url : "/about/SourceFiles",
  ls_bbar_actions : [  ],
  title : "Source files",
  page_length : 20,
  gc_name : 0,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "module_name" }, { "type": "int", "name": "code_lines" }, { "type": "int", "name": "doc_lines" }, { "name": "disabled_fields" }, { "name": "disabled_actions" } ],
  ls_grid_configs : [  ],
  viewConfig : { "emptyText": "Keine Daten anzuzeigen." },
  disable_editing : true,
  disabled_actions_index : 4,
  initComponent : function() {
    var ww = this.containing_window;
    var module_name1573 = new Ext.form.TextField({ "disabled": true, "maxLength": null });
    var code_lines1574 = new Ext.form.NumberField({ "disabled": true });
    var doc_lines1575 = new Ext.form.NumberField({ "disabled": true });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": false, "header": "module name", "editable": false, "filter": { "type": "string" }, "width": Lino.chars2width(4), "dataIndex": "module_name", "hidden": false }, { "colIndex": 1, "sortable": false, "header": "Code", "editable": false, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "dataIndex": "code_lines", "hidden": false }, { "colIndex": 2, "sortable": false, "header": "doc", "editable": false, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "dataIndex": "doc_lines", "hidden": false } ];
    Lino.about.SourceFiles.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.about.SourceFiles.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.about.SourceFiles.GridPanel(p);
});

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUIcbss.IdentifyPersonResultHandle
Lino.cbss.IdentifyPersonResult.GridPanel = Ext.extend(Lino.GridPanel,{
  ls_url : "/cbss/IdentifyPersonResult",
  ls_bbar_actions : [  ],
  title : "Resultate",
  page_length : 20,
  gc_name : 0,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "national_id" }, { "name": "last_name" }, { "name": "first_name" }, { "name": "address" }, { "name": "birth_date" }, { "name": "birth_location" }, { "name": "civil_state" }, { "name": "gender" },'genderHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" } ],
  ls_grid_configs : [  ],
  viewConfig : { "emptyText": "Keine Daten anzuzeigen." },
  disable_editing : true,
  disabled_actions_index : 10,
  initComponent : function() {
    var ww = this.containing_window;
    var national_id_disp1577 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var last_name_disp1578 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var first_name_disp1579 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var address_disp1580 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var birth_date_disp1581 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var birth_location_disp1582 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var civil_state_disp1583 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var gender1584 = new Lino.ChoicesFieldElement({ "disabled": true, "store": [ [ "M", "M\u00e4nnlich" ], [ "F", "Weiblich" ] ] });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "width": Lino.chars2width(10), "colIndex": 0, "sortable": false, "dataIndex": "national_id", "header": "NR-Nummer", "hidden": false, "editable": false }, { "width": Lino.chars2width(20), "colIndex": 1, "sortable": false, "dataIndex": "last_name", "header": "Familienname", "hidden": false, "editable": false }, { "width": Lino.chars2width(10), "colIndex": 2, "sortable": false, "dataIndex": "first_name", "header": "Vorname", "hidden": false, "editable": false }, { "width": Lino.chars2width(30), "colIndex": 3, "sortable": false, "dataIndex": "address", "header": "Adresse", "hidden": false, "editable": false }, { "width": Lino.chars2width(10), "colIndex": 4, "sortable": false, "dataIndex": "birth_date", "header": "Geburtsdatum", "hidden": false, "editable": false }, { "width": Lino.chars2width(30), "colIndex": 5, "sortable": false, "dataIndex": "birth_location", "header": "Geburtsort", "hidden": false, "editable": false }, { "width": Lino.chars2width(30), "colIndex": 6, "sortable": false, "dataIndex": "civil_state", "header": "Zivilstand", "hidden": false, "editable": false }, { "colIndex": 7, "sortable": false, "header": "Geschlecht", "editable": false, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "gender", "hidden": false } ];
    Lino.cbss.IdentifyPersonResult.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.cbss.IdentifyPersonResult.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cbss.IdentifyPersonResult.GridPanel(p);
});

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUIcbss.RetrieveTIGroupsResultHandle
Lino.cbss.RetrieveTIGroupsResult.GridPanel = Ext.extend(Lino.GridPanel,{
  ls_url : "/cbss/RetrieveTIGroupsResult",
  ls_bbar_actions : [  ],
  title : "Resultate",
  page_length : 20,
  gc_name : 0,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "group" }, { "name": "type" }, { "type": "date", "name": "since", "dateFormat": "d.m.Y" }, { "name": "info" }, { "name": "disabled_fields" }, { "name": "disabled_actions" } ],
  ls_grid_configs : [  ],
  viewConfig : { "emptyText": "Keine Daten anzuzeigen." },
  disable_editing : true,
  disabled_actions_index : 5,
  initComponent : function() {
    var ww = this.containing_window;
    var group_disp57 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var type_disp58 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var since59 = new Lino.DateField({ "disabled": true });
    var info_disp60 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "width": Lino.chars2width(18), "colIndex": 0, "sortable": false, "dataIndex": "group", "header": "Gruppe", "hidden": false, "editable": false }, { "width": Lino.chars2width(5), "colIndex": 1, "sortable": false, "dataIndex": "type", "header": "TI", "hidden": false, "editable": false }, { "colIndex": 2, "sortable": false, "xtype": "datecolumn", "format": "d.m.Y", "editable": false, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Seit", "dataIndex": "since", "hidden": false, "width": Lino.chars2width(14) }, { "width": Lino.chars2width(50), "colIndex": 3, "sortable": false, "dataIndex": "info", "header": "Information", "hidden": false, "editable": false } ];
    Lino.cbss.RetrieveTIGroupsResult.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.cbss.RetrieveTIGroupsResult.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cbss.RetrieveTIGroupsResult.GridPanel(p);
});

Lino.about.About.showPanel = Ext.extend(Lino.about.About.DetailFormPanel,{
  empty_title: "Info",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "do_print", "menu_item_text": "Drucken", "must_save": true, "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print'), "iconCls": "x-tbar-print", "overflowText": "Drucken", "auto_save": true } ],
  ls_url: "/about/About",
  initComponent : function() {
    this.ls_detail_handler = Lino.about.About.show;
    Lino.about.About.showPanel.superclass.initComponent.call(this);
  }
});

Lino.about.About.show = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "maximizable": true, "modal": true, "maximized": false, "height": Lino.rows2height(20) },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.about.About.showPanel(p);
});

Lino.about.About.showPanel = Ext.extend(Lino.about.About.DetailFormPanel,{
  empty_title: "Info",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "do_print", "menu_item_text": "Drucken", "must_save": true, "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print'), "iconCls": "x-tbar-print", "overflowText": "Drucken", "auto_save": true } ],
  ls_url: "/about/About",
  initComponent : function() {
    this.ls_detail_handler = Lino.about.About.show;
    Lino.about.About.showPanel.superclass.initComponent.call(this);
  }
});

Lino.about.About.show = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "maximizable": true, "modal": true, "maximized": false, "height": Lino.rows2height(20) },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.about.About.showPanel(p);
});

Lino.lino.Home.showPanel = Ext.extend(Lino.lino.Home.DetailFormPanel,{
  empty_title: "Startseite",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "do_print", "menu_item_text": "Drucken", "must_save": true, "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print'), "iconCls": "x-tbar-print", "overflowText": "Drucken", "auto_save": true } ],
  ls_url: "/lino/Home",
  initComponent : function() {
    this.ls_detail_handler = Lino.lino.Home.show;
    Lino.lino.Home.showPanel.superclass.initComponent.call(this);
  }
});

Lino.lino.Home.show = new Lino.WindowAction({  },function(){
  var p = { "hide_window_title": true, "hide_top_toolbar": true, "is_main_window": true };
  return new Lino.lino.Home.showPanel(p);
});

Lino.lino.Home.showPanel = Ext.extend(Lino.lino.Home.DetailFormPanel,{
  empty_title: "Startseite",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "do_print", "menu_item_text": "Drucken", "must_save": true, "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print'), "iconCls": "x-tbar-print", "overflowText": "Drucken", "auto_save": true } ],
  ls_url: "/lino/Home",
  initComponent : function() {
    this.ls_detail_handler = Lino.lino.Home.show;
    Lino.lino.Home.showPanel.superclass.initComponent.call(this);
  }
});

Lino.lino.Home.show = new Lino.WindowAction({  },function(){
  var p = { "hide_window_title": true, "hide_top_toolbar": true, "is_main_window": true };
  return new Lino.lino.Home.showPanel(p);
});
