# This API was generated by pyCaCORE
import cabig.cabio.CaBioWSQueryService_client as services
from cabig.cacore.ws.proxy import *

schema = services.ns3

class AgentAlias(WSBean):

    arrayType =  services.ns1.ArrayOf_xsd_anyType_Def(None).pyclass
    className = "gov.nih.nci.cabio.domain.AgentAlias"

    id = ProxyAttr('id')
    name = ProxyAttr('name')
    type = ProxyAttr('type')
    agentCollection = ProxyAssoc('agentCollection',True)
    
    def __init__(self, holder=None, service=None, **kwargs):
        if not(holder): holder = schema.AgentAlias_Def(None).pyclass()
        WSBean.__init__(self, holder, service=service, **kwargs)
    
class Agent(WSBean):

    arrayType =  services.ns1.ArrayOf_xsd_anyType_Def(None).pyclass
    className = "gov.nih.nci.cabio.domain.Agent"

    EVSId = ProxyAttr('EVSId')
    IUPACName = ProxyAttr('IUPACName')
    NSCNumber = ProxyAttr('NSCNumber')
    SMILESCode = ProxyAttr('SMILESCode')
    absorption = ProxyAttr('absorption')
    bigid = ProxyAttr('bigid')
    biotransformation = ProxyAttr('biotransformation')
    casNumber = ProxyAttr('casNumber')
    chemicalFormula = ProxyAttr('chemicalFormula')
    comment = ProxyAttr('comment')
    drugbankAccession = ProxyAttr('drugbankAccession')
    halfLife = ProxyAttr('halfLife')
    id = ProxyAttr('id')
    indication = ProxyAttr('indication')
    isCMAPAgent = ProxyAttr('isCMAPAgent')
    mechanismOfAction = ProxyAttr('mechanismOfAction')
    molecularWeight = ProxyAttr('molecularWeight')
    name = ProxyAttr('name')
    percentProteinBinding = ProxyAttr('percentProteinBinding')
    pharmacology = ProxyAttr('pharmacology')
    pubchemCompoundId = ProxyAttr('pubchemCompoundId')
    pubchemSubstanceId = ProxyAttr('pubchemSubstanceId')
    source = ProxyAttr('source')
    toxicity = ProxyAttr('toxicity')
    agentAliasCollection = ProxyAssoc('agentAliasCollection',True)
    clinicalTrialProtocolCollection = ProxyAssoc('clinicalTrialProtocolCollection',True)
    geneFunctionAssociationCollection = ProxyAssoc('geneFunctionAssociationCollection',True)
    pathwayEntityCollection = ProxyAssoc('pathwayEntityCollection',True)
    targetCollection = ProxyAssoc('targetCollection',True)
    
    def __init__(self, holder=None, service=None, **kwargs):
        if not(holder): holder = schema.Agent_Def(None).pyclass()
        WSBean.__init__(self, holder, service=service, **kwargs)
    
class Anomaly(WSBean):

    arrayType =  services.ns1.ArrayOf_xsd_anyType_Def(None).pyclass
    className = "gov.nih.nci.cabio.domain.Anomaly"

    bigid = ProxyAttr('bigid')
    description = ProxyAttr('description')
    id = ProxyAttr('id')
    histopathology = ProxyAssoc('histopathology',False)
    organOntologyCollection = ProxyAssoc('organOntologyCollection',True)
    vocabularyCollection = ProxyAssoc('vocabularyCollection',True)
    
    def __init__(self, holder=None, service=None, **kwargs):
        if not(holder): holder = schema.Anomaly_Def(None).pyclass()
        WSBean.__init__(self, holder, service=service, **kwargs)
    
class ArrayReporterCytogeneticLocation(WSBean):

    arrayType =  services.ns1.ArrayOf_xsd_anyType_Def(None).pyclass
    className = "gov.nih.nci.cabio.domain.ArrayReporterCytogeneticLocation"

    id = ProxyAttr('id')
    bigid = ProxyAttr('bigid')
    chromosome = ProxyAssoc('chromosome',False)
    endCytoband = ProxyAssoc('endCytoband',False)
    startCytoband = ProxyAssoc('startCytoband',False)
    arrayReporter = ProxyAssoc('arrayReporter',False)
    
    def __init__(self, holder=None, service=None, **kwargs):
        if not(holder): holder = schema.ArrayReporterCytogeneticLocation_Def(None).pyclass()
        WSBean.__init__(self, holder, service=service, **kwargs)
    
class ArrayReporterPhysicalLocation(WSBean):

    arrayType =  services.ns1.ArrayOf_xsd_anyType_Def(None).pyclass
    className = "gov.nih.nci.cabio.domain.ArrayReporterPhysicalLocation"

    id = ProxyAttr('id')
    assembly = ProxyAttr('assembly')
    chromosomalEndPosition = ProxyAttr('chromosomalEndPosition')
    chromosomalStartPosition = ProxyAttr('chromosomalStartPosition')
    chromosome = ProxyAssoc('chromosome',False)
    arrayReporter = ProxyAssoc('arrayReporter',False)
    
    def __init__(self, holder=None, service=None, **kwargs):
        if not(holder): holder = schema.ArrayReporterPhysicalLocation_Def(None).pyclass()
        WSBean.__init__(self, holder, service=service, **kwargs)
    
class ArrayReporter(WSBean):

    arrayType =  services.ns1.ArrayOf_xsd_anyType_Def(None).pyclass
    className = "gov.nih.nci.cabio.domain.ArrayReporter"

    bigid = ProxyAttr('bigid')
    id = ProxyAttr('id')
    name = ProxyAttr('name')
    cytogeneticLocationCollection = ProxyAssoc('cytogeneticLocationCollection',True)
    microarray = ProxyAssoc('microarray',False)
    physicalLocationCollection = ProxyAssoc('physicalLocationCollection',True)
    
    def __init__(self, holder=None, service=None, **kwargs):
        if not(holder): holder = schema.ArrayReporter_Def(None).pyclass()
        WSBean.__init__(self, holder, service=service, **kwargs)
    
class Chromosome(WSBean):

    arrayType =  services.ns1.ArrayOf_xsd_anyType_Def(None).pyclass
    className = "gov.nih.nci.cabio.domain.Chromosome"

    bigid = ProxyAttr('bigid')
    id = ProxyAttr('id')
    number = ProxyAttr('number')
    cytobandCollection = ProxyAssoc('cytobandCollection',True)
    geneCollection = ProxyAssoc('geneCollection',True)
    locationCollection = ProxyAssoc('locationCollection',True)
    taxon = ProxyAssoc('taxon',False)
    
    def __init__(self, holder=None, service=None, **kwargs):
        if not(holder): holder = schema.Chromosome_Def(None).pyclass()
        WSBean.__init__(self, holder, service=service, **kwargs)
    
class ClinicalTrialProtocol(WSBean):

    arrayType =  services.ns1.ArrayOf_xsd_anyType_Def(None).pyclass
    className = "gov.nih.nci.cabio.domain.ClinicalTrialProtocol"

    NIHAdminCode = ProxyAttr('NIHAdminCode')
    PDQIdentifier = ProxyAttr('PDQIdentifier')
    PIName = ProxyAttr('PIName')
    bigid = ProxyAttr('bigid')
    currentStatus = ProxyAttr('currentStatus')
    currentStatusDate = ProxyAttr('currentStatusDate')
    documentNumber = ProxyAttr('documentNumber')
    id = ProxyAttr('id')
    leadOrganizationId = ProxyAttr('leadOrganizationId')
    leadOrganizationName = ProxyAttr('leadOrganizationName')
    participationType = ProxyAttr('participationType')
    phase = ProxyAttr('phase')
    title = ProxyAttr('title')
    treatmentFlag = ProxyAttr('treatmentFlag')
    agentCollection = ProxyAssoc('agentCollection',True)
    diseaseOntologyCollection = ProxyAssoc('diseaseOntologyCollection',True)
    histopathologyCollection = ProxyAssoc('histopathologyCollection',True)
    protocolAssociationCollection = ProxyAssoc('protocolAssociationCollection',True)
    
    def __init__(self, holder=None, service=None, **kwargs):
        if not(holder): holder = schema.ClinicalTrialProtocol_Def(None).pyclass()
        WSBean.__init__(self, holder, service=service, **kwargs)
    
class CloneRelativeLocation(WSBean):

    arrayType =  services.ns1.ArrayOf_xsd_anyType_Def(None).pyclass
    className = "gov.nih.nci.cabio.domain.CloneRelativeLocation"

    bigid = ProxyAttr('bigid')
    id = ProxyAttr('id')
    type = ProxyAttr('type')
    clone = ProxyAssoc('clone',False)
    nucleicAcidSequence = ProxyAssoc('nucleicAcidSequence',False)
    
    def __init__(self, holder=None, service=None, **kwargs):
        if not(holder): holder = schema.CloneRelativeLocation_Def(None).pyclass()
        WSBean.__init__(self, holder, service=service, **kwargs)
    
class Clone(WSBean):

    arrayType =  services.ns1.ArrayOf_xsd_anyType_Def(None).pyclass
    className = "gov.nih.nci.cabio.domain.Clone"

    bigid = ProxyAttr('bigid')
    id = ProxyAttr('id')
    insertSize = ProxyAttr('insertSize')
    name = ProxyAttr('name')
    type = ProxyAttr('type')
    cloneRelativeLocationCollection = ProxyAssoc('cloneRelativeLocationCollection',True)
    library = ProxyAssoc('library',False)
    nucleicAcidSequenceCollection = ProxyAssoc('nucleicAcidSequenceCollection',True)
    taxonCollection = ProxyAssoc('taxonCollection',True)
    
    def __init__(self, holder=None, service=None, **kwargs):
        if not(holder): holder = schema.Clone_Def(None).pyclass()
        WSBean.__init__(self, holder, service=service, **kwargs)
    
class ConstrainedRegion(WSBean):

    arrayType =  services.ns1.ArrayOf_xsd_anyType_Def(None).pyclass
    className = "gov.nih.nci.cabio.domain.ConstrainedRegion"

    id = ProxyAttr('id')
    assembly = ProxyAttr('assembly')
    chromosomalEndPosition = ProxyAttr('chromosomalEndPosition')
    chromosomalStartPosition = ProxyAttr('chromosomalStartPosition')
    pvalue = ProxyAttr('pvalue')
    score = ProxyAttr('score')
    chromosome = ProxyAssoc('chromosome',False)
    multipleAlignment = ProxyAssoc('multipleAlignment',False)
    
    def __init__(self, holder=None, service=None, **kwargs):
        if not(holder): holder = schema.ConstrainedRegion_Def(None).pyclass()
        WSBean.__init__(self, holder, service=service, **kwargs)
    
class CytobandPhysicalLocation(WSBean):

    arrayType =  services.ns1.ArrayOf_xsd_anyType_Def(None).pyclass
    className = "gov.nih.nci.cabio.domain.CytobandPhysicalLocation"

    id = ProxyAttr('id')
    assembly = ProxyAttr('assembly')
    chromosomalEndPosition = ProxyAttr('chromosomalEndPosition')
    chromosomalStartPosition = ProxyAttr('chromosomalStartPosition')
    chromosome = ProxyAssoc('chromosome',False)
    cytoband = ProxyAssoc('cytoband',False)
    
    def __init__(self, holder=None, service=None, **kwargs):
        if not(holder): holder = schema.CytobandPhysicalLocation_Def(None).pyclass()
        WSBean.__init__(self, holder, service=service, **kwargs)
    
class Cytoband(WSBean):

    arrayType =  services.ns1.ArrayOf_xsd_anyType_Def(None).pyclass
    className = "gov.nih.nci.cabio.domain.Cytoband"

    bigid = ProxyAttr('bigid')
    id = ProxyAttr('id')
    name = ProxyAttr('name')
    chromosome = ProxyAssoc('chromosome',False)
    physicalLocationCollection = ProxyAssoc('physicalLocationCollection',True)
    
    def __init__(self, holder=None, service=None, **kwargs):
        if not(holder): holder = schema.Cytoband_Def(None).pyclass()
        WSBean.__init__(self, holder, service=service, **kwargs)
    
class CytogeneticLocation(WSBean):

    arrayType =  services.ns1.ArrayOf_xsd_anyType_Def(None).pyclass
    className = "gov.nih.nci.cabio.domain.CytogeneticLocation"

    id = ProxyAttr('id')
    bigid = ProxyAttr('bigid')
    chromosome = ProxyAssoc('chromosome',False)
    endCytoband = ProxyAssoc('endCytoband',False)
    startCytoband = ProxyAssoc('startCytoband',False)
    
    def __init__(self, holder=None, service=None, **kwargs):
        if not(holder): holder = schema.CytogeneticLocation_Def(None).pyclass()
        WSBean.__init__(self, holder, service=service, **kwargs)
    
class DiseaseOntologyRelationship(WSBean):

    arrayType =  services.ns1.ArrayOf_xsd_anyType_Def(None).pyclass
    className = "gov.nih.nci.cabio.domain.DiseaseOntologyRelationship"

    bigid = ProxyAttr('bigid')
    id = ProxyAttr('id')
    type = ProxyAttr('type')
    childDiseaseOntology = ProxyAssoc('childDiseaseOntology',False)
    parentDiseaseOntology = ProxyAssoc('parentDiseaseOntology',False)
    
    def __init__(self, holder=None, service=None, **kwargs):
        if not(holder): holder = schema.DiseaseOntologyRelationship_Def(None).pyclass()
        WSBean.__init__(self, holder, service=service, **kwargs)
    
class DiseaseOntology(WSBean):

    arrayType =  services.ns1.ArrayOf_xsd_anyType_Def(None).pyclass
    className = "gov.nih.nci.cabio.domain.DiseaseOntology"

    EVSId = ProxyAttr('EVSId')
    bigid = ProxyAttr('bigid')
    id = ProxyAttr('id')
    name = ProxyAttr('name')
    childDiseaseOntologyRelationshipCollection = ProxyAssoc('childDiseaseOntologyRelationshipCollection',True)
    clinicalTrialProtocolCollection = ProxyAssoc('clinicalTrialProtocolCollection',True)
    geneFunctionAssociationCollection = ProxyAssoc('geneFunctionAssociationCollection',True)
    histopathologyCollection = ProxyAssoc('histopathologyCollection',True)
    parentDiseaseOntologyRelationshipCollection = ProxyAssoc('parentDiseaseOntologyRelationshipCollection',True)
    
    def __init__(self, holder=None, service=None, **kwargs):
        if not(holder): holder = schema.DiseaseOntology_Def(None).pyclass()
        WSBean.__init__(self, holder, service=service, **kwargs)
    
class EvidenceCode(WSBean):

    arrayType =  services.ns1.ArrayOf_xsd_anyType_Def(None).pyclass
    className = "gov.nih.nci.cabio.domain.EvidenceCode"

    bigid = ProxyAttr('bigid')
    evidenceCode = ProxyAttr('evidenceCode')
    id = ProxyAttr('id')
    evidenceCollection = ProxyAssoc('evidenceCollection',True)
    interactionCollection = ProxyAssoc('interactionCollection',True)
    
    def __init__(self, holder=None, service=None, **kwargs):
        if not(holder): holder = schema.EvidenceCode_Def(None).pyclass()
        WSBean.__init__(self, holder, service=service, **kwargs)
    
class Evidence(WSBean):

    arrayType =  services.ns1.ArrayOf_xsd_anyType_Def(None).pyclass
    className = "gov.nih.nci.cabio.domain.Evidence"

    bigid = ProxyAttr('bigid')
    celllineStatus = ProxyAttr('celllineStatus')
    comments = ProxyAttr('comments')
    id = ProxyAttr('id')
    negationStatus = ProxyAttr('negationStatus')
    pubmedId = ProxyAttr('pubmedId')
    sentence = ProxyAttr('sentence')
    sentenceStatus = ProxyAttr('sentenceStatus')
    evidenceCodeCollection = ProxyAssoc('evidenceCodeCollection',True)
    geneFunctionAssociationCollection = ProxyAssoc('geneFunctionAssociationCollection',True)
    interactionCollection = ProxyAssoc('interactionCollection',True)
    
    def __init__(self, holder=None, service=None, **kwargs):
        if not(holder): holder = schema.Evidence_Def(None).pyclass()
        WSBean.__init__(self, holder, service=service, **kwargs)
    
class ExonArrayReporter(WSBean):

    arrayType =  services.ns1.ArrayOf_xsd_anyType_Def(None).pyclass
    className = "gov.nih.nci.cabio.domain.ExonArrayReporter"

    bigid = ProxyAttr('bigid')
    id = ProxyAttr('id')
    name = ProxyAttr('name')
    probeCount = ProxyAttr('probeCount')
    probeSelectionRegionId = ProxyAttr('probeSelectionRegionId')
    strand = ProxyAttr('strand')
    cytogeneticLocationCollection = ProxyAssoc('cytogeneticLocationCollection',True)
    microarray = ProxyAssoc('microarray',False)
    physicalLocationCollection = ProxyAssoc('physicalLocationCollection',True)
    exon = ProxyAssoc('exon',False)
    geneCollection = ProxyAssoc('geneCollection',True)
    transcript = ProxyAssoc('transcript',False)
    
    def __init__(self, holder=None, service=None, **kwargs):
        if not(holder): holder = schema.ExonArrayReporter_Def(None).pyclass()
        WSBean.__init__(self, holder, service=service, **kwargs)
    
class Exon(WSBean):

    arrayType =  services.ns1.ArrayOf_xsd_anyType_Def(None).pyclass
    className = "gov.nih.nci.cabio.domain.Exon"

    bigid = ProxyAttr('bigid')
    id = ProxyAttr('id')
    source = ProxyAttr('source')
    sourceId = ProxyAttr('sourceId')
    exonArrayReporterCollection = ProxyAssoc('exonArrayReporterCollection',True)
    transcript = ProxyAssoc('transcript',False)
    
    def __init__(self, holder=None, service=None, **kwargs):
        if not(holder): holder = schema.Exon_Def(None).pyclass()
        WSBean.__init__(self, holder, service=service, **kwargs)
    
class ExpressedSequenceTag(WSBean):

    arrayType =  services.ns1.ArrayOf_xsd_anyType_Def(None).pyclass
    className = "gov.nih.nci.cabio.domain.ExpressedSequenceTag"

    accessionNumber = ProxyAttr('accessionNumber')
    accessionNumberVersion = ProxyAttr('accessionNumberVersion')
    bigid = ProxyAttr('bigid')
    description = ProxyAttr('description')
    id = ProxyAttr('id')
    length = ProxyAttr('length')
    type = ProxyAttr('type')
    value = ProxyAttr('value')
    cloneRelativeLocation = ProxyAssoc('cloneRelativeLocation',False)
    databaseCrossReferenceCollection = ProxyAssoc('databaseCrossReferenceCollection',True)
    expressionArrayReporterCollection = ProxyAssoc('expressionArrayReporterCollection',True)
    geneCollection = ProxyAssoc('geneCollection',True)
    pathwayEntityCollection = ProxyAssoc('pathwayEntityCollection',True)
    physicalLocationCollection = ProxyAssoc('physicalLocationCollection',True)
    
    def __init__(self, holder=None, service=None, **kwargs):
        if not(holder): holder = schema.ExpressedSequenceTag_Def(None).pyclass()
        WSBean.__init__(self, holder, service=service, **kwargs)
    
class ExpressionArrayReporter(WSBean):

    arrayType =  services.ns1.ArrayOf_xsd_anyType_Def(None).pyclass
    className = "gov.nih.nci.cabio.domain.ExpressionArrayReporter"

    bigid = ProxyAttr('bigid')
    id = ProxyAttr('id')
    name = ProxyAttr('name')
    sequenceSource = ProxyAttr('sequenceSource')
    sequenceType = ProxyAttr('sequenceType')
    targetDescription = ProxyAttr('targetDescription')
    targetId = ProxyAttr('targetId')
    cytogeneticLocationCollection = ProxyAssoc('cytogeneticLocationCollection',True)
    microarray = ProxyAssoc('microarray',False)
    physicalLocationCollection = ProxyAssoc('physicalLocationCollection',True)
    gene = ProxyAssoc('gene',False)
    nucleicAcidSequence = ProxyAssoc('nucleicAcidSequence',False)
    proteinDomainCollection = ProxyAssoc('proteinDomainCollection',True)
    
    def __init__(self, holder=None, service=None, **kwargs):
        if not(holder): holder = schema.ExpressionArrayReporter_Def(None).pyclass()
        WSBean.__init__(self, holder, service=service, **kwargs)
    
class GeneAgentAssociation(WSBean):

    arrayType =  services.ns1.ArrayOf_xsd_anyType_Def(None).pyclass
    className = "gov.nih.nci.cabio.domain.GeneAgentAssociation"

    bigid = ProxyAttr('bigid')
    id = ProxyAttr('id')
    role = ProxyAttr('role')
    source = ProxyAttr('source')
    evidenceCollection = ProxyAssoc('evidenceCollection',True)
    gene = ProxyAssoc('gene',False)
    agent = ProxyAssoc('agent',False)
    
    def __init__(self, holder=None, service=None, **kwargs):
        if not(holder): holder = schema.GeneAgentAssociation_Def(None).pyclass()
        WSBean.__init__(self, holder, service=service, **kwargs)
    
class GeneAlias(WSBean):

    arrayType =  services.ns1.ArrayOf_xsd_anyType_Def(None).pyclass
    className = "gov.nih.nci.cabio.domain.GeneAlias"

    bigid = ProxyAttr('bigid')
    id = ProxyAttr('id')
    name = ProxyAttr('name')
    type = ProxyAttr('type')
    geneCollection = ProxyAssoc('geneCollection',True)
    
    def __init__(self, holder=None, service=None, **kwargs):
        if not(holder): holder = schema.GeneAlias_Def(None).pyclass()
        WSBean.__init__(self, holder, service=service, **kwargs)
    
class GeneCytogeneticLocation(WSBean):

    arrayType =  services.ns1.ArrayOf_xsd_anyType_Def(None).pyclass
    className = "gov.nih.nci.cabio.domain.GeneCytogeneticLocation"

    id = ProxyAttr('id')
    bigid = ProxyAttr('bigid')
    chromosome = ProxyAssoc('chromosome',False)
    endCytoband = ProxyAssoc('endCytoband',False)
    startCytoband = ProxyAssoc('startCytoband',False)
    gene = ProxyAssoc('gene',False)
    
    def __init__(self, holder=None, service=None, **kwargs):
        if not(holder): holder = schema.GeneCytogeneticLocation_Def(None).pyclass()
        WSBean.__init__(self, holder, service=service, **kwargs)
    
class GeneDiseaseAssociation(WSBean):

    arrayType =  services.ns1.ArrayOf_xsd_anyType_Def(None).pyclass
    className = "gov.nih.nci.cabio.domain.GeneDiseaseAssociation"

    bigid = ProxyAttr('bigid')
    id = ProxyAttr('id')
    role = ProxyAttr('role')
    source = ProxyAttr('source')
    evidenceCollection = ProxyAssoc('evidenceCollection',True)
    gene = ProxyAssoc('gene',False)
    diseaseOntology = ProxyAssoc('diseaseOntology',False)
    
    def __init__(self, holder=None, service=None, **kwargs):
        if not(holder): holder = schema.GeneDiseaseAssociation_Def(None).pyclass()
        WSBean.__init__(self, holder, service=service, **kwargs)
    
class GeneFunctionAssociation(WSBean):

    arrayType =  services.ns1.ArrayOf_xsd_anyType_Def(None).pyclass
    className = "gov.nih.nci.cabio.domain.GeneFunctionAssociation"

    bigid = ProxyAttr('bigid')
    id = ProxyAttr('id')
    role = ProxyAttr('role')
    source = ProxyAttr('source')
    evidenceCollection = ProxyAssoc('evidenceCollection',True)
    gene = ProxyAssoc('gene',False)
    
    def __init__(self, holder=None, service=None, **kwargs):
        if not(holder): holder = schema.GeneFunctionAssociation_Def(None).pyclass()
        WSBean.__init__(self, holder, service=service, **kwargs)
    
class GeneOntologyRelationship(WSBean):

    arrayType =  services.ns1.ArrayOf_xsd_anyType_Def(None).pyclass
    className = "gov.nih.nci.cabio.domain.GeneOntologyRelationship"

    bigid = ProxyAttr('bigid')
    id = ProxyAttr('id')
    relationshipType = ProxyAttr('relationshipType')
    childGeneOntology = ProxyAssoc('childGeneOntology',False)
    parentGeneOntology = ProxyAssoc('parentGeneOntology',False)
    
    def __init__(self, holder=None, service=None, **kwargs):
        if not(holder): holder = schema.GeneOntologyRelationship_Def(None).pyclass()
        WSBean.__init__(self, holder, service=service, **kwargs)
    
class GeneOntology(WSBean):

    arrayType =  services.ns1.ArrayOf_xsd_anyType_Def(None).pyclass
    className = "gov.nih.nci.cabio.domain.GeneOntology"

    bigid = ProxyAttr('bigid')
    id = ProxyAttr('id')
    name = ProxyAttr('name')
    childGeneOntologyRelationshipCollection = ProxyAssoc('childGeneOntologyRelationshipCollection',True)
    geneCollection = ProxyAssoc('geneCollection',True)
    parentGeneOntologyRelationshipCollection = ProxyAssoc('parentGeneOntologyRelationshipCollection',True)
    
    def __init__(self, holder=None, service=None, **kwargs):
        if not(holder): holder = schema.GeneOntology_Def(None).pyclass()
        WSBean.__init__(self, holder, service=service, **kwargs)
    
class GenePhysicalLocation(WSBean):

    arrayType =  services.ns1.ArrayOf_xsd_anyType_Def(None).pyclass
    className = "gov.nih.nci.cabio.domain.GenePhysicalLocation"

    id = ProxyAttr('id')
    assembly = ProxyAttr('assembly')
    chromosomalEndPosition = ProxyAttr('chromosomalEndPosition')
    chromosomalStartPosition = ProxyAttr('chromosomalStartPosition')
    featureType = ProxyAttr('featureType')
    chromosome = ProxyAssoc('chromosome',False)
    gene = ProxyAssoc('gene',False)
    
    def __init__(self, holder=None, service=None, **kwargs):
        if not(holder): holder = schema.GenePhysicalLocation_Def(None).pyclass()
        WSBean.__init__(self, holder, service=service, **kwargs)
    
class GeneRelativeLocation(WSBean):

    arrayType =  services.ns1.ArrayOf_xsd_anyType_Def(None).pyclass
    className = "gov.nih.nci.cabio.domain.GeneRelativeLocation"

    bigid = ProxyAttr('bigid')
    distance = ProxyAttr('distance')
    id = ProxyAttr('id')
    orientation = ProxyAttr('orientation')
    SNP = ProxyAssoc('SNP',False)
    gene = ProxyAssoc('gene',False)
    
    def __init__(self, holder=None, service=None, **kwargs):
        if not(holder): holder = schema.GeneRelativeLocation_Def(None).pyclass()
        WSBean.__init__(self, holder, service=service, **kwargs)
    
class Gene(WSBean):

    arrayType =  services.ns1.ArrayOf_xsd_anyType_Def(None).pyclass
    className = "gov.nih.nci.cabio.domain.Gene"

    bigid = ProxyAttr('bigid')
    clusterId = ProxyAttr('clusterId')
    fullName = ProxyAttr('fullName')
    hugoSymbol = ProxyAttr('hugoSymbol')
    id = ProxyAttr('id')
    symbol = ProxyAttr('symbol')
    chromosome = ProxyAssoc('chromosome',False)
    cytogeneticLocationCollection = ProxyAssoc('cytogeneticLocationCollection',True)
    databaseCrossReferenceCollection = ProxyAssoc('databaseCrossReferenceCollection',True)
    exonArrayReporterCollection = ProxyAssoc('exonArrayReporterCollection',True)
    expressionArrayReporterCollection = ProxyAssoc('expressionArrayReporterCollection',True)
    geneAliasCollection = ProxyAssoc('geneAliasCollection',True)
    geneFunctionAssociationCollection = ProxyAssoc('geneFunctionAssociationCollection',True)
    geneOntologyCollection = ProxyAssoc('geneOntologyCollection',True)
    geneRelativeLocationCollection = ProxyAssoc('geneRelativeLocationCollection',True)
    histopathologyCollection = ProxyAssoc('histopathologyCollection',True)
    homologousAssociationCollection = ProxyAssoc('homologousAssociationCollection',True)
    libraryCollection = ProxyAssoc('libraryCollection',True)
    markerCollection = ProxyAssoc('markerCollection',True)
    nucleicAcidSequenceCollection = ProxyAssoc('nucleicAcidSequenceCollection',True)
    organOntologyCollection = ProxyAssoc('organOntologyCollection',True)
    pathwayCollection = ProxyAssoc('pathwayCollection',True)
    physicalLocationCollection = ProxyAssoc('physicalLocationCollection',True)
    proteinCollection = ProxyAssoc('proteinCollection',True)
    targetCollection = ProxyAssoc('targetCollection',True)
    taxon = ProxyAssoc('taxon',False)
    transcriptCollection = ProxyAssoc('transcriptCollection',True)
    
    def __init__(self, holder=None, service=None, **kwargs):
        if not(holder): holder = schema.Gene_Def(None).pyclass()
        WSBean.__init__(self, holder, service=service, **kwargs)
    
class Histopathology(WSBean):

    arrayType =  services.ns1.ArrayOf_xsd_anyType_Def(None).pyclass
    className = "gov.nih.nci.cabio.domain.Histopathology"

    ageOfOnset = ProxyAttr('ageOfOnset')
    comments = ProxyAttr('comments')
    grossDescription = ProxyAttr('grossDescription')
    id = ProxyAttr('id')
    microscopicDescription = ProxyAttr('microscopicDescription')
    relationalOperation = ProxyAttr('relationalOperation')
    survivalInfo = ProxyAttr('survivalInfo')
    tumorIncidenceRate = ProxyAttr('tumorIncidenceRate')
    anomalyCollection = ProxyAssoc('anomalyCollection',True)
    clinicalTrialProtocolCollection = ProxyAssoc('clinicalTrialProtocolCollection',True)
    diseaseOntology = ProxyAssoc('diseaseOntology',False)
    geneCollection = ProxyAssoc('geneCollection',True)
    libraryCollection = ProxyAssoc('libraryCollection',True)
    metastasisCollection = ProxyAssoc('metastasisCollection',True)
    organOntology = ProxyAssoc('organOntology',False)
    
    def __init__(self, holder=None, service=None, **kwargs):
        if not(holder): holder = schema.Histopathology_Def(None).pyclass()
        WSBean.__init__(self, holder, service=service, **kwargs)
    
class HomologousAssociation(WSBean):

    arrayType =  services.ns1.ArrayOf_xsd_anyType_Def(None).pyclass
    className = "gov.nih.nci.cabio.domain.HomologousAssociation"

    bigid = ProxyAttr('bigid')
    id = ProxyAttr('id')
    similarityPercentage = ProxyAttr('similarityPercentage')
    gene = ProxyAssoc('gene',False)
    homologousGene = ProxyAssoc('homologousGene',False)
    
    def __init__(self, holder=None, service=None, **kwargs):
        if not(holder): holder = schema.HomologousAssociation_Def(None).pyclass()
        WSBean.__init__(self, holder, service=service, **kwargs)
    
class Library(WSBean):

    arrayType =  services.ns1.ArrayOf_xsd_anyType_Def(None).pyclass
    className = "gov.nih.nci.cabio.domain.Library"

    bigid = ProxyAttr('bigid')
    cloneProducer = ProxyAttr('cloneProducer')
    cloneVector = ProxyAttr('cloneVector')
    cloneVectorType = ProxyAttr('cloneVectorType')
    clonesToDate = ProxyAttr('clonesToDate')
    creationDate = ProxyAttr('creationDate')
    description = ProxyAttr('description')
    id = ProxyAttr('id')
    keyword = ProxyAttr('keyword')
    labHost = ProxyAttr('labHost')
    name = ProxyAttr('name')
    rsite1 = ProxyAttr('rsite1')
    rsite2 = ProxyAttr('rsite2')
    sequencesToDate = ProxyAttr('sequencesToDate')
    type = ProxyAttr('type')
    uniGeneId = ProxyAttr('uniGeneId')
    cloneCollection = ProxyAssoc('cloneCollection',True)
    geneCollection = ProxyAssoc('geneCollection',True)
    histopathologyCollection = ProxyAssoc('histopathologyCollection',True)
    protocol = ProxyAssoc('protocol',False)
    tissue = ProxyAssoc('tissue',False)
    
    def __init__(self, holder=None, service=None, **kwargs):
        if not(holder): holder = schema.Library_Def(None).pyclass()
        WSBean.__init__(self, holder, service=service, **kwargs)
    
class Location(WSBean):

    arrayType =  services.ns1.ArrayOf_xsd_anyType_Def(None).pyclass
    className = "gov.nih.nci.cabio.domain.Location"

    id = ProxyAttr('id')
    chromosome = ProxyAssoc('chromosome',False)
    
    def __init__(self, holder=None, service=None, **kwargs):
        if not(holder): holder = schema.Location_Def(None).pyclass()
        WSBean.__init__(self, holder, service=service, **kwargs)
    
class MarkerAlias(WSBean):

    arrayType =  services.ns1.ArrayOf_xsd_anyType_Def(None).pyclass
    className = "gov.nih.nci.cabio.domain.MarkerAlias"

    bigid = ProxyAttr('bigid')
    id = ProxyAttr('id')
    name = ProxyAttr('name')
    markerCollection = ProxyAssoc('markerCollection',True)
    
    def __init__(self, holder=None, service=None, **kwargs):
        if not(holder): holder = schema.MarkerAlias_Def(None).pyclass()
        WSBean.__init__(self, holder, service=service, **kwargs)
    
class MarkerPhysicalLocation(WSBean):

    arrayType =  services.ns1.ArrayOf_xsd_anyType_Def(None).pyclass
    className = "gov.nih.nci.cabio.domain.MarkerPhysicalLocation"

    id = ProxyAttr('id')
    assembly = ProxyAttr('assembly')
    chromosomalEndPosition = ProxyAttr('chromosomalEndPosition')
    chromosomalStartPosition = ProxyAttr('chromosomalStartPosition')
    chromosome = ProxyAssoc('chromosome',False)
    marker = ProxyAssoc('marker',False)
    
    def __init__(self, holder=None, service=None, **kwargs):
        if not(holder): holder = schema.MarkerPhysicalLocation_Def(None).pyclass()
        WSBean.__init__(self, holder, service=service, **kwargs)
    
class MarkerRelativeLocation(WSBean):

    arrayType =  services.ns1.ArrayOf_xsd_anyType_Def(None).pyclass
    className = "gov.nih.nci.cabio.domain.MarkerRelativeLocation"

    bigid = ProxyAttr('bigid')
    distance = ProxyAttr('distance')
    id = ProxyAttr('id')
    orientation = ProxyAttr('orientation')
    type = ProxyAttr('type')
    SNP = ProxyAssoc('SNP',False)
    markerCollection = ProxyAssoc('markerCollection',True)
    
    def __init__(self, holder=None, service=None, **kwargs):
        if not(holder): holder = schema.MarkerRelativeLocation_Def(None).pyclass()
        WSBean.__init__(self, holder, service=service, **kwargs)
    
class Marker(WSBean):

    arrayType =  services.ns1.ArrayOf_xsd_anyType_Def(None).pyclass
    className = "gov.nih.nci.cabio.domain.Marker"

    bigid = ProxyAttr('bigid')
    geneticMarkerId = ProxyAttr('geneticMarkerId')
    id = ProxyAttr('id')
    name = ProxyAttr('name')
    type = ProxyAttr('type')
    geneCollection = ProxyAssoc('geneCollection',True)
    markerAliasCollection = ProxyAssoc('markerAliasCollection',True)
    markerRelativeLocationCollection = ProxyAssoc('markerRelativeLocationCollection',True)
    physicalLocationCollection = ProxyAssoc('physicalLocationCollection',True)
    taxon = ProxyAssoc('taxon',False)
    
    def __init__(self, holder=None, service=None, **kwargs):
        if not(holder): holder = schema.Marker_Def(None).pyclass()
        WSBean.__init__(self, holder, service=service, **kwargs)
    
class MessengerRNA(WSBean):

    arrayType =  services.ns1.ArrayOf_xsd_anyType_Def(None).pyclass
    className = "gov.nih.nci.cabio.domain.MessengerRNA"

    accessionNumber = ProxyAttr('accessionNumber')
    accessionNumberVersion = ProxyAttr('accessionNumberVersion')
    bigid = ProxyAttr('bigid')
    description = ProxyAttr('description')
    id = ProxyAttr('id')
    length = ProxyAttr('length')
    type = ProxyAttr('type')
    value = ProxyAttr('value')
    cloneRelativeLocation = ProxyAssoc('cloneRelativeLocation',False)
    databaseCrossReferenceCollection = ProxyAssoc('databaseCrossReferenceCollection',True)
    expressionArrayReporterCollection = ProxyAssoc('expressionArrayReporterCollection',True)
    geneCollection = ProxyAssoc('geneCollection',True)
    pathwayEntityCollection = ProxyAssoc('pathwayEntityCollection',True)
    physicalLocationCollection = ProxyAssoc('physicalLocationCollection',True)
    
    def __init__(self, holder=None, service=None, **kwargs):
        if not(holder): holder = schema.MessengerRNA_Def(None).pyclass()
        WSBean.__init__(self, holder, service=service, **kwargs)
    
class Microarray(WSBean):

    arrayType =  services.ns1.ArrayOf_xsd_anyType_Def(None).pyclass
    className = "gov.nih.nci.cabio.domain.Microarray"

    LSID = ProxyAttr('LSID')
    annotationDate = ProxyAttr('annotationDate')
    annotationVersion = ProxyAttr('annotationVersion')
    bigid = ProxyAttr('bigid')
    dbSNPVersion = ProxyAttr('dbSNPVersion')
    description = ProxyAttr('description')
    genomeVersion = ProxyAttr('genomeVersion')
    id = ProxyAttr('id')
    manufacturer = ProxyAttr('manufacturer')
    name = ProxyAttr('name')
    type = ProxyAttr('type')
    arrayReporterCollection = ProxyAssoc('arrayReporterCollection',True)
    
    def __init__(self, holder=None, service=None, **kwargs):
        if not(holder): holder = schema.Microarray_Def(None).pyclass()
        WSBean.__init__(self, holder, service=service, **kwargs)
    
class MultipleAlignment(WSBean):

    arrayType =  services.ns1.ArrayOf_xsd_anyType_Def(None).pyclass
    className = "gov.nih.nci.cabio.domain.MultipleAlignment"

    id = ProxyAttr('id')
    name = ProxyAttr('name')
    source = ProxyAttr('source')
    type = ProxyAttr('type')
    conservedPhysicalLocationCollection = ProxyAssoc('conservedPhysicalLocationCollection',True)
    taxonCollection = ProxyAssoc('taxonCollection',True)
    
    def __init__(self, holder=None, service=None, **kwargs):
        if not(holder): holder = schema.MultipleAlignment_Def(None).pyclass()
        WSBean.__init__(self, holder, service=service, **kwargs)
    
class NucleicAcidPhysicalLocation(WSBean):

    arrayType =  services.ns1.ArrayOf_xsd_anyType_Def(None).pyclass
    className = "gov.nih.nci.cabio.domain.NucleicAcidPhysicalLocation"

    id = ProxyAttr('id')
    assembly = ProxyAttr('assembly')
    chromosomalEndPosition = ProxyAttr('chromosomalEndPosition')
    chromosomalStartPosition = ProxyAttr('chromosomalStartPosition')
    chromosome = ProxyAssoc('chromosome',False)
    nucleicAcidSequence = ProxyAssoc('nucleicAcidSequence',False)
    
    def __init__(self, holder=None, service=None, **kwargs):
        if not(holder): holder = schema.NucleicAcidPhysicalLocation_Def(None).pyclass()
        WSBean.__init__(self, holder, service=service, **kwargs)
    
class NucleicAcidSequence(WSBean):

    arrayType =  services.ns1.ArrayOf_xsd_anyType_Def(None).pyclass
    className = "gov.nih.nci.cabio.domain.NucleicAcidSequence"

    accessionNumber = ProxyAttr('accessionNumber')
    accessionNumberVersion = ProxyAttr('accessionNumberVersion')
    bigid = ProxyAttr('bigid')
    description = ProxyAttr('description')
    id = ProxyAttr('id')
    length = ProxyAttr('length')
    type = ProxyAttr('type')
    value = ProxyAttr('value')
    cloneRelativeLocation = ProxyAssoc('cloneRelativeLocation',False)
    databaseCrossReferenceCollection = ProxyAssoc('databaseCrossReferenceCollection',True)
    expressionArrayReporterCollection = ProxyAssoc('expressionArrayReporterCollection',True)
    geneCollection = ProxyAssoc('geneCollection',True)
    pathwayEntityCollection = ProxyAssoc('pathwayEntityCollection',True)
    physicalLocationCollection = ProxyAssoc('physicalLocationCollection',True)
    
    def __init__(self, holder=None, service=None, **kwargs):
        if not(holder): holder = schema.NucleicAcidSequence_Def(None).pyclass()
        WSBean.__init__(self, holder, service=service, **kwargs)
    
class OrganOntologyRelationship(WSBean):

    arrayType =  services.ns1.ArrayOf_xsd_anyType_Def(None).pyclass
    className = "gov.nih.nci.cabio.domain.OrganOntologyRelationship"

    bigid = ProxyAttr('bigid')
    id = ProxyAttr('id')
    type = ProxyAttr('type')
    childOrganOntology = ProxyAssoc('childOrganOntology',False)
    parentOrganOntology = ProxyAssoc('parentOrganOntology',False)
    
    def __init__(self, holder=None, service=None, **kwargs):
        if not(holder): holder = schema.OrganOntologyRelationship_Def(None).pyclass()
        WSBean.__init__(self, holder, service=service, **kwargs)
    
class OrganOntology(WSBean):

    arrayType =  services.ns1.ArrayOf_xsd_anyType_Def(None).pyclass
    className = "gov.nih.nci.cabio.domain.OrganOntology"

    bigid = ProxyAttr('bigid')
    id = ProxyAttr('id')
    name = ProxyAttr('name')
    anomalyCollection = ProxyAssoc('anomalyCollection',True)
    childOrganOntologyRelationshipCollection = ProxyAssoc('childOrganOntologyRelationshipCollection',True)
    geneCollection = ProxyAssoc('geneCollection',True)
    histopathologyCollection = ProxyAssoc('histopathologyCollection',True)
    parentOrganOntologyRelationshipCollection = ProxyAssoc('parentOrganOntologyRelationshipCollection',True)
    
    def __init__(self, holder=None, service=None, **kwargs):
        if not(holder): holder = schema.OrganOntology_Def(None).pyclass()
        WSBean.__init__(self, holder, service=service, **kwargs)
    
class Pathway(WSBean):

    arrayType =  services.ns1.ArrayOf_xsd_anyType_Def(None).pyclass
    className = "gov.nih.nci.cabio.domain.Pathway"

    bigid = ProxyAttr('bigid')
    curator = ProxyAttr('curator')
    description = ProxyAttr('description')
    diagram = ProxyAttr('diagram')
    displayValue = ProxyAttr('displayValue')
    id = ProxyAttr('id')
    name = ProxyAttr('name')
    reviewer = ProxyAttr('reviewer')
    source = ProxyAttr('source')
    geneCollection = ProxyAssoc('geneCollection',True)
    histopathologyCollection = ProxyAssoc('histopathologyCollection',True)
    interactionCollection = ProxyAssoc('interactionCollection',True)
    pathwayReferenceCollection = ProxyAssoc('pathwayReferenceCollection',True)
    taxon = ProxyAssoc('taxon',False)
    
    def __init__(self, holder=None, service=None, **kwargs):
        if not(holder): holder = schema.Pathway_Def(None).pyclass()
        WSBean.__init__(self, holder, service=service, **kwargs)
    
class PhysicalLocation(WSBean):

    arrayType =  services.ns1.ArrayOf_xsd_anyType_Def(None).pyclass
    className = "gov.nih.nci.cabio.domain.PhysicalLocation"

    id = ProxyAttr('id')
    assembly = ProxyAttr('assembly')
    chromosomalEndPosition = ProxyAttr('chromosomalEndPosition')
    chromosomalStartPosition = ProxyAttr('chromosomalStartPosition')
    chromosome = ProxyAssoc('chromosome',False)
    
    def __init__(self, holder=None, service=None, **kwargs):
        if not(holder): holder = schema.PhysicalLocation_Def(None).pyclass()
        WSBean.__init__(self, holder, service=service, **kwargs)
    
class PopulationFrequency(WSBean):

    arrayType =  services.ns1.ArrayOf_xsd_anyType_Def(None).pyclass
    className = "gov.nih.nci.cabio.domain.PopulationFrequency"

    bigid = ProxyAttr('bigid')
    ethnicity = ProxyAttr('ethnicity')
    heterozygousFrequency = ProxyAttr('heterozygousFrequency')
    id = ProxyAttr('id')
    majorAllele = ProxyAttr('majorAllele')
    majorFrequency = ProxyAttr('majorFrequency')
    minorAllele = ProxyAttr('minorAllele')
    minorFrequency = ProxyAttr('minorFrequency')
    type = ProxyAttr('type')
    SNP = ProxyAssoc('SNP',False)
    
    def __init__(self, holder=None, service=None, **kwargs):
        if not(holder): holder = schema.PopulationFrequency_Def(None).pyclass()
        WSBean.__init__(self, holder, service=service, **kwargs)
    
class ProteinAlias(WSBean):

    arrayType =  services.ns1.ArrayOf_xsd_anyType_Def(None).pyclass
    className = "gov.nih.nci.cabio.domain.ProteinAlias"

    bigid = ProxyAttr('bigid')
    id = ProxyAttr('id')
    name = ProxyAttr('name')
    proteinCollection = ProxyAssoc('proteinCollection',True)
    
    def __init__(self, holder=None, service=None, **kwargs):
        if not(holder): holder = schema.ProteinAlias_Def(None).pyclass()
        WSBean.__init__(self, holder, service=service, **kwargs)
    
class ProteinDomain(WSBean):

    arrayType =  services.ns1.ArrayOf_xsd_anyType_Def(None).pyclass
    className = "gov.nih.nci.cabio.domain.ProteinDomain"

    accessionNumber = ProxyAttr('accessionNumber')
    bigid = ProxyAttr('bigid')
    description = ProxyAttr('description')
    id = ProxyAttr('id')
    source = ProxyAttr('source')
    expressionArrayReporterCollection = ProxyAssoc('expressionArrayReporterCollection',True)
    
    def __init__(self, holder=None, service=None, **kwargs):
        if not(holder): holder = schema.ProteinDomain_Def(None).pyclass()
        WSBean.__init__(self, holder, service=service, **kwargs)
    
class ProteinSequence(WSBean):

    arrayType =  services.ns1.ArrayOf_xsd_anyType_Def(None).pyclass
    className = "gov.nih.nci.cabio.domain.ProteinSequence"

    bigid = ProxyAttr('bigid')
    checkSum = ProxyAttr('checkSum')
    id = ProxyAttr('id')
    length = ProxyAttr('length')
    molecularWeightInDaltons = ProxyAttr('molecularWeightInDaltons')
    value = ProxyAttr('value')
    protein = ProxyAssoc('protein',False)
    
    def __init__(self, holder=None, service=None, **kwargs):
        if not(holder): holder = schema.ProteinSequence_Def(None).pyclass()
        WSBean.__init__(self, holder, service=service, **kwargs)
    
class Protein(WSBean):

    arrayType =  services.ns1.ArrayOf_xsd_anyType_Def(None).pyclass
    className = "gov.nih.nci.cabio.domain.Protein"

    bigid = ProxyAttr('bigid')
    copyrightStatement = ProxyAttr('copyrightStatement')
    id = ProxyAttr('id')
    name = ProxyAttr('name')
    primaryAccession = ProxyAttr('primaryAccession')
    uniProtCode = ProxyAttr('uniProtCode')
    geneCollection = ProxyAssoc('geneCollection',True)
    keywords = ProxyAssoc('keywords',True)
    pathwayEntityCollection = ProxyAssoc('pathwayEntityCollection',True)
    proteinAliasCollection = ProxyAssoc('proteinAliasCollection',True)
    proteinSequenceCollection = ProxyAssoc('proteinSequenceCollection',True)
    secondaryAccession = ProxyAssoc('secondaryAccession',True)
    taxonCollection = ProxyAssoc('taxonCollection',True)
    
    def __init__(self, holder=None, service=None, **kwargs):
        if not(holder): holder = schema.Protein_Def(None).pyclass()
        WSBean.__init__(self, holder, service=service, **kwargs)
    
class ProtocolAssociation(WSBean):

    arrayType =  services.ns1.ArrayOf_xsd_anyType_Def(None).pyclass
    className = "gov.nih.nci.cabio.domain.ProtocolAssociation"

    CTEPNAME = ProxyAttr('CTEPNAME')
    IMTCODE = ProxyAttr('IMTCODE')
    bigid = ProxyAttr('bigid')
    diseaseCategory = ProxyAttr('diseaseCategory')
    diseaseSubCategory = ProxyAttr('diseaseSubCategory')
    id = ProxyAttr('id')
    clinicalTrialProtocol = ProxyAssoc('clinicalTrialProtocol',False)
    
    def __init__(self, holder=None, service=None, **kwargs):
        if not(holder): holder = schema.ProtocolAssociation_Def(None).pyclass()
        WSBean.__init__(self, holder, service=service, **kwargs)
    
class Protocol(WSBean):

    arrayType =  services.ns1.ArrayOf_xsd_anyType_Def(None).pyclass
    className = "gov.nih.nci.cabio.domain.Protocol"

    bigid = ProxyAttr('bigid')
    description = ProxyAttr('description')
    id = ProxyAttr('id')
    name = ProxyAttr('name')
    type = ProxyAttr('type')
    libraryCollection = ProxyAssoc('libraryCollection',True)
    tissueCollection = ProxyAssoc('tissueCollection',True)
    
    def __init__(self, holder=None, service=None, **kwargs):
        if not(holder): holder = schema.Protocol_Def(None).pyclass()
        WSBean.__init__(self, holder, service=service, **kwargs)
    
class RelativeLocation(WSBean):

    arrayType =  services.ns1.ArrayOf_xsd_anyType_Def(None).pyclass
    className = "gov.nih.nci.cabio.domain.RelativeLocation"

    bigid = ProxyAttr('bigid')
    distance = ProxyAttr('distance')
    id = ProxyAttr('id')
    orientation = ProxyAttr('orientation')
    SNP = ProxyAssoc('SNP',False)
    
    def __init__(self, holder=None, service=None, **kwargs):
        if not(holder): holder = schema.RelativeLocation_Def(None).pyclass()
        WSBean.__init__(self, holder, service=service, **kwargs)
    
class SNPArrayReporter(WSBean):

    arrayType =  services.ns1.ArrayOf_xsd_anyType_Def(None).pyclass
    className = "gov.nih.nci.cabio.domain.SNPArrayReporter"

    bigid = ProxyAttr('bigid')
    id = ProxyAttr('id')
    name = ProxyAttr('name')
    phastConservation = ProxyAttr('phastConservation')
    cytogeneticLocationCollection = ProxyAssoc('cytogeneticLocationCollection',True)
    microarray = ProxyAssoc('microarray',False)
    physicalLocationCollection = ProxyAssoc('physicalLocationCollection',True)
    SNP = ProxyAssoc('SNP',False)
    
    def __init__(self, holder=None, service=None, **kwargs):
        if not(holder): holder = schema.SNPArrayReporter_Def(None).pyclass()
        WSBean.__init__(self, holder, service=service, **kwargs)
    
class SNPCytogeneticLocation(WSBean):

    arrayType =  services.ns1.ArrayOf_xsd_anyType_Def(None).pyclass
    className = "gov.nih.nci.cabio.domain.SNPCytogeneticLocation"

    id = ProxyAttr('id')
    bigid = ProxyAttr('bigid')
    chromosome = ProxyAssoc('chromosome',False)
    endCytoband = ProxyAssoc('endCytoband',False)
    startCytoband = ProxyAssoc('startCytoband',False)
    SNP = ProxyAssoc('SNP',False)
    
    def __init__(self, holder=None, service=None, **kwargs):
        if not(holder): holder = schema.SNPCytogeneticLocation_Def(None).pyclass()
        WSBean.__init__(self, holder, service=service, **kwargs)
    
class SNPPhysicalLocation(WSBean):

    arrayType =  services.ns1.ArrayOf_xsd_anyType_Def(None).pyclass
    className = "gov.nih.nci.cabio.domain.SNPPhysicalLocation"

    id = ProxyAttr('id')
    assembly = ProxyAttr('assembly')
    chromosomalEndPosition = ProxyAttr('chromosomalEndPosition')
    chromosomalStartPosition = ProxyAttr('chromosomalStartPosition')
    chromosome = ProxyAssoc('chromosome',False)
    SNP = ProxyAssoc('SNP',False)
    
    def __init__(self, holder=None, service=None, **kwargs):
        if not(holder): holder = schema.SNPPhysicalLocation_Def(None).pyclass()
        WSBean.__init__(self, holder, service=service, **kwargs)
    
class SNP(WSBean):

    arrayType =  services.ns1.ArrayOf_xsd_anyType_Def(None).pyclass
    className = "gov.nih.nci.cabio.domain.SNP"

    DBSNPID = ProxyAttr('DBSNPID')
    alleleA = ProxyAttr('alleleA')
    alleleB = ProxyAttr('alleleB')
    aminoAcidChange = ProxyAttr('aminoAcidChange')
    bigid = ProxyAttr('bigid')
    chrXPseudoAutosomalRegion = ProxyAttr('chrXPseudoAutosomalRegion')
    codingStatus = ProxyAttr('codingStatus')
    flank = ProxyAttr('flank')
    id = ProxyAttr('id')
    validationStatus = ProxyAttr('validationStatus')
    cytogeneticLocationCollection = ProxyAssoc('cytogeneticLocationCollection',True)
    databaseCrossReferenceCollection = ProxyAssoc('databaseCrossReferenceCollection',True)
    physicalLocationCollection = ProxyAssoc('physicalLocationCollection',True)
    populationFrequencyCollection = ProxyAssoc('populationFrequencyCollection',True)
    relativeLocationCollection = ProxyAssoc('relativeLocationCollection',True)
    snpArrayReporterCollection = ProxyAssoc('snpArrayReporterCollection',True)
    
    def __init__(self, holder=None, service=None, **kwargs):
        if not(holder): holder = schema.SNP_Def(None).pyclass()
        WSBean.__init__(self, holder, service=service, **kwargs)
    
class Target(WSBean):

    arrayType =  services.ns1.ArrayOf_xsd_anyType_Def(None).pyclass
    className = "gov.nih.nci.cabio.domain.Target"

    bigid = ProxyAttr('bigid')
    id = ProxyAttr('id')
    name = ProxyAttr('name')
    type = ProxyAttr('type')
    agentCollection = ProxyAssoc('agentCollection',True)
    anomalyCollection = ProxyAssoc('anomalyCollection',True)
    geneCollection = ProxyAssoc('geneCollection',True)
    
    def __init__(self, holder=None, service=None, **kwargs):
        if not(holder): holder = schema.Target_Def(None).pyclass()
        WSBean.__init__(self, holder, service=service, **kwargs)
    
class Taxon(WSBean):

    arrayType =  services.ns1.ArrayOf_xsd_anyType_Def(None).pyclass
    className = "gov.nih.nci.cabio.domain.Taxon"

    abbreviation = ProxyAttr('abbreviation')
    bigid = ProxyAttr('bigid')
    commonName = ProxyAttr('commonName')
    ethnicityStrain = ProxyAttr('ethnicityStrain')
    id = ProxyAttr('id')
    scientificName = ProxyAttr('scientificName')
    chromosomeCollection = ProxyAssoc('chromosomeCollection',True)
    cloneCollection = ProxyAssoc('cloneCollection',True)
    geneCollection = ProxyAssoc('geneCollection',True)
    markerCollection = ProxyAssoc('markerCollection',True)
    multipleAlignmentCollection = ProxyAssoc('multipleAlignmentCollection',True)
    pathwayCollection = ProxyAssoc('pathwayCollection',True)
    proteinCollection = ProxyAssoc('proteinCollection',True)
    tissueCollection = ProxyAssoc('tissueCollection',True)
    
    def __init__(self, holder=None, service=None, **kwargs):
        if not(holder): holder = schema.Taxon_Def(None).pyclass()
        WSBean.__init__(self, holder, service=service, **kwargs)
    
class Tissue(WSBean):

    arrayType =  services.ns1.ArrayOf_xsd_anyType_Def(None).pyclass
    className = "gov.nih.nci.cabio.domain.Tissue"

    cellLine = ProxyAttr('cellLine')
    cellType = ProxyAttr('cellType')
    description = ProxyAttr('description')
    developmentalStage = ProxyAttr('developmentalStage')
    histology = ProxyAttr('histology')
    id = ProxyAttr('id')
    name = ProxyAttr('name')
    organ = ProxyAttr('organ')
    sex = ProxyAttr('sex')
    supplier = ProxyAttr('supplier')
    type = ProxyAttr('type')
    libraryCollection = ProxyAssoc('libraryCollection',True)
    protocol = ProxyAssoc('protocol',False)
    taxon = ProxyAssoc('taxon',False)
    
    def __init__(self, holder=None, service=None, **kwargs):
        if not(holder): holder = schema.Tissue_Def(None).pyclass()
        WSBean.__init__(self, holder, service=service, **kwargs)
    
class TranscriptArrayReporter(WSBean):

    arrayType =  services.ns1.ArrayOf_xsd_anyType_Def(None).pyclass
    className = "gov.nih.nci.cabio.domain.TranscriptArrayReporter"

    bigid = ProxyAttr('bigid')
    id = ProxyAttr('id')
    name = ProxyAttr('name')
    cytogeneticLocationCollection = ProxyAssoc('cytogeneticLocationCollection',True)
    microarray = ProxyAssoc('microarray',False)
    physicalLocationCollection = ProxyAssoc('physicalLocationCollection',True)
    
    def __init__(self, holder=None, service=None, **kwargs):
        if not(holder): holder = schema.TranscriptArrayReporter_Def(None).pyclass()
        WSBean.__init__(self, holder, service=service, **kwargs)
    
class TranscriptPhysicalLocation(WSBean):

    arrayType =  services.ns1.ArrayOf_xsd_anyType_Def(None).pyclass
    className = "gov.nih.nci.cabio.domain.TranscriptPhysicalLocation"

    id = ProxyAttr('id')
    assembly = ProxyAttr('assembly')
    chromosomalEndPosition = ProxyAttr('chromosomalEndPosition')
    chromosomalStartPosition = ProxyAttr('chromosomalStartPosition')
    chromosome = ProxyAssoc('chromosome',False)
    transcript = ProxyAssoc('transcript',False)
    
    def __init__(self, holder=None, service=None, **kwargs):
        if not(holder): holder = schema.TranscriptPhysicalLocation_Def(None).pyclass()
        WSBean.__init__(self, holder, service=service, **kwargs)
    
class Transcript(WSBean):

    arrayType =  services.ns1.ArrayOf_xsd_anyType_Def(None).pyclass
    className = "gov.nih.nci.cabio.domain.Transcript"

    bigid = ProxyAttr('bigid')
    id = ProxyAttr('id')
    source = ProxyAttr('source')
    sourceId = ProxyAttr('sourceId')
    strand = ProxyAttr('strand')
    totalProbeCount = ProxyAttr('totalProbeCount')
    exonArrayReporterCollection = ProxyAssoc('exonArrayReporterCollection',True)
    exonCollection = ProxyAssoc('exonCollection',True)
    geneCollection = ProxyAssoc('geneCollection',True)
    physicalLocationCollection = ProxyAssoc('physicalLocationCollection',True)
    
    def __init__(self, holder=None, service=None, **kwargs):
        if not(holder): holder = schema.Transcript_Def(None).pyclass()
        WSBean.__init__(self, holder, service=service, **kwargs)
    
class Vocabulary(WSBean):

    arrayType =  services.ns1.ArrayOf_xsd_anyType_Def(None).pyclass
    className = "gov.nih.nci.cabio.domain.Vocabulary"

    bigid = ProxyAttr('bigid')
    coreTerm = ProxyAttr('coreTerm')
    generalTerm = ProxyAttr('generalTerm')
    id = ProxyAttr('id')
    anomalyCollection = ProxyAssoc('anomalyCollection',True)
    
    def __init__(self, holder=None, service=None, **kwargs):
        if not(holder): holder = schema.Vocabulary_Def(None).pyclass()
        WSBean.__init__(self, holder, service=service, **kwargs)
    
