/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.data.io;

import java.util.Date;
import org.brunel.data.Data;
import org.brunel.data.io.ByteOutput;
import org.brunel.translator.JSTranslation;

class ByteInput {
    private final byte[] data;
    private int p;

    public Number readNumber() {
        int a = this.readByte() & 0xFF;
        if (a <= 252) {
            return a;
        }
        if (a == 253) {
            int d3 = this.readByte() & 0xFF;
            int d4 = this.readByte() & 0xFF;
            return d3 + d4 * 256;
        }
        if (a == 254) {
            return this.readDouble();
        }
        if (a == 255) {
            return null;
        }
        throw new IllegalStateException("Serializing " + a);
    }

    public Date readDate() {
        return Data.asDate(this.readNumber());
    }

    private Number readDouble() {
        String s = this.readString();
        return s.equals("NaN") ? Double.NaN : Double.parseDouble(s);
    }

    @JSTranslation(js={"var i, len, c, d, char2, char3, out=''", "for(;;) {", "  c = this.readByte();", "  if (c == 3 && out == '') return null;    // 03 at start encodes a null", "  if (c == 0) return out;                  // 00 terminates the string", "  d = c >> 4;                              // handle the UTF-8 top nibble encoding", "  if (d<8) out += String.fromCharCode(c);  // One byte", "  else if (d == 12 || d == 13) {           // Two bytes", "    out += String.fromCharCode(((c & 0x1F) << 6) | (this.readByte() & 0x3F));", "  } else if (d == 14) {                    // Three bytes", "    var c2 = this.readByte(), c3 = this.readByte();", "    out += String.fromCharCode( ((c & 0x0F) << 12) | ((c2 & 0x3F) << 6) | (c3 & 0x3F) );", "  }", "}"})
    String readString() {
        if (this.data[this.p] == 3) {
            ++this.p;
            return null;
        }
        int s = this.p;
        while (this.data[this.p] != 0) {
            ++this.p;
        }
        return new String(this.data, s, this.p++ - s, ByteOutput.ENCODING);
    }

    byte readByte() {
        return this.data[this.p++];
    }

    ByteInput(byte[] data) {
        this.data = data;
        this.p = 0;
    }
}

