/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.data.diagram;

import java.util.HashMap;
import org.brunel.data.Data;
import org.brunel.data.Dataset;
import org.brunel.data.Field;

public class Chord {
    private final double[][] mtx;
    private final int[][] idx;
    private final Object[] names;

    public static Chord make(Dataset data, String fieldA, String fieldB, String fieldSize) {
        return new Chord(data, fieldA, fieldB, fieldSize);
    }

    public Chord(Dataset data, String fieldA, String fieldB, String fieldSize) {
        Field a = data.field(fieldA);
        Field b = data.field(fieldB);
        Field s = data.field(fieldSize);
        HashMap<Object, Integer> indices = new HashMap<Object, Integer>();
        for (Object o : a.categories()) {
            if (indices.get(o) != null) continue;
            indices.put(o, indices.size());
        }
        for (Object o : b.categories()) {
            if (indices.get(o) != null) continue;
            indices.put(o, indices.size());
        }
        int N = indices.size();
        this.names = new Object[N];
        for (Object o : indices.keySet()) {
            this.names[((Integer)indices.get(o)).intValue()] = o;
        }
        this.mtx = new double[N][N];
        this.idx = new int[N][N];
        for (int i = 0; i < a.rowCount(); ++i) {
            Double size = s == null ? 1.0 : Data.asNumeric(s.value(i));
            if (!(size > 0.0)) continue;
            Integer i1 = (Integer)indices.get(a.value(i));
            Integer i2 = (Integer)indices.get(b.value(i));
            double[] dArray = this.mtx[i1];
            int n = i2;
            dArray[n] = dArray[n] + size;
            double[] dArray2 = this.mtx[i2];
            int n2 = i1;
            dArray2[n2] = dArray2[n2] + size;
            this.idx[i1.intValue()][i2.intValue()] = i;
            this.idx[i2.intValue()][i1.intValue()] = i;
        }
    }

    public Object group(int i) {
        return this.names[i];
    }

    public int index(int from, int to) {
        return this.idx[from][to];
    }

    public double[][] matrix() {
        return this.mtx;
    }
}

