/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.maps.projection;

import org.brunel.geom.Point;
import org.brunel.geom.Rect;
import org.brunel.maps.projection.Albers;
import org.brunel.maps.projection.Projection;

class AlbersUSA
extends Projection {
    private final Albers lower48 = new Albers(29.5, 45.5, 96.0);
    private final Albers alaska = new Albers(0.0, 50.0, 120.0);
    private final Albers hawaii = new Albers(-140.0, 9.0, 120.0);
    private final Albers pr = new Albers(0.0, 21.0, 120.0);
    private final Rect lower48Rect = this.lower48.transform(new Rect(-125.0, -65.0, 25.0, 50.0));
    private final Point alaskaTopLeft = this.alaska.transform(new Point(-180.0, 73.0));
    private final Point hawaiiTopLeft = this.hawaii.transform(new Point(-160.5, 22.5));
    private final Point prTopLeft = this.hawaii.transform(new Point(-67.5, 18.5));

    @Override
    public String d3Definition(Rect bounds) {
        return "d3.geo.albersUsa()\n\t\t.scale(Math.min(geom.inner_width/0.96, geom.inner_height/0.48))\n\t\t" + this.translateDefinition();
    }

    @Override
    public Point transform(Point p) {
        Point q = p.y > 50.0 ? this.shift(this.alaska.transform(p), this.alaskaTopLeft, 0.0, 0.75) : (p.x < -140.0 ? this.shift(this.hawaii.transform(p), this.hawaiiTopLeft, 0.33, 0.8) : (p.y < 21.0 ? this.shift(this.pr.transform(p), this.prTopLeft, 0.7, 0.8) : this.lower48.transform(p)));
        return q;
    }

    @Override
    public Point inverse(Point p) {
        throw new UnsupportedOperationException("Not supported");
    }

    private Point shift(Point point, Point base, double targetX, double targetY) {
        return new Point((point.x - base.x) * targetX * this.lower48Rect.width() + this.lower48Rect.left, (point.y - base.y) * targetY * this.lower48Rect.height() + this.lower48Rect.top);
    }
}

