/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.geom;

import org.brunel.geom.Geom;
import org.brunel.geom.Point;

public class Rect {
    public final double left;
    public final double top;
    public final double right;
    public final double bottom;

    public Rect(double left, double right, double top, double bottom) {
        this.left = left;
        this.top = top;
        this.right = right;
        this.bottom = bottom;
        assert (right >= left && bottom >= top);
    }

    public final double area() {
        return (this.right - this.left) * (this.bottom - this.top);
    }

    public final Point center() {
        return new Point(this.cx(), this.cy());
    }

    public final double cx() {
        return (this.left + this.right) / 2.0;
    }

    public final double cy() {
        return (this.top + this.bottom) / 2.0;
    }

    public final double distance(Rect o) {
        if (o.right < this.left) {
            if (o.top > this.bottom) {
                return Geom.distance(o.right, o.top, this.left, this.bottom);
            }
            if (o.bottom < this.top) {
                return Geom.distance(o.right, o.bottom, this.left, this.top);
            }
            return this.left - o.left - o.width();
        }
        if (o.left > this.right) {
            if (o.top > this.bottom) {
                return Geom.distance(o.left, o.top, this.right, this.bottom);
            }
            if (o.bottom < this.top) {
                return Geom.distance(o.left, o.bottom, this.right, this.top);
            }
            return o.left - this.right;
        }
        if (o.top > this.bottom) {
            return o.top - this.bottom;
        }
        if (o.bottom < this.top) {
            return this.top - o.bottom;
        }
        if (this.contains(o) || o.contains(this)) {
            double d1 = Math.min(Math.abs(this.left - o.left), Math.abs(this.right - o.right));
            double d2 = Math.min(Math.abs(this.top - o.top), Math.abs(this.bottom - o.bottom));
            return -Math.min(d1, d2);
        }
        return 0.0;
    }

    public double width() {
        return this.right - this.left;
    }

    private boolean contains(Rect o) {
        return o.left >= this.left && o.right <= this.right && o.top >= this.top && o.bottom <= this.bottom;
    }

    public final double distanceTo(Point p) {
        if (p.y < this.top) {
            if (p.x < this.left) {
                return Math.sqrt((p.x - this.left) * (p.x - this.left) + (p.y - this.top) * (p.y - this.top));
            }
            if (p.x > this.right) {
                return Math.sqrt((p.x - this.right) * (p.x - this.right) + (p.y - this.top) * (p.y - this.top));
            }
            return this.top - p.y;
        }
        if (p.y > this.bottom) {
            if (p.x < this.left) {
                return Math.sqrt((p.x - this.left) * (p.x - this.left) + (p.y - this.bottom) * (p.y - this.bottom));
            }
            if (p.x > this.right) {
                return Math.sqrt((p.x - this.right) * (p.x - this.right) + (p.y - this.bottom) * (p.y - this.bottom));
            }
            return p.y - this.bottom;
        }
        if (p.x < this.left) {
            return this.left - p.x;
        }
        if (p.x > this.right) {
            return p.x - this.right;
        }
        return -Math.min(Math.min(p.x - this.left, this.right - p.x), Math.min(p.y - this.top, this.bottom - p.y));
    }

    public Rect expand(double v) {
        return new Rect(this.left - this.width() * v, this.right + this.width() * v, this.top - this.height() * v, this.bottom + this.height() * v);
    }

    public double height() {
        return this.bottom - this.top;
    }

    public final boolean intersects(Rect other) {
        return this.bottom >= other.top && this.top <= other.bottom && this.right >= other.left && this.left <= other.right;
    }

    public Point[] makeBoundaryPoints() {
        return new Point[]{new Point(this.left, this.top), new Point(this.cx(), this.top), new Point(this.right, this.top), new Point(this.right, this.cy()), new Point(this.right, this.bottom), new Point(this.cx(), this.bottom), new Point(this.left, this.bottom), new Point(this.left, this.cy())};
    }

    public String toString() {
        return "[" + this.left + ", " + this.right + " : " + this.top + ", " + this.bottom + ")]";
    }

    public Rect union(Point p) {
        if (this.contains(p)) {
            return this;
        }
        return new Rect(Math.min(p.x, this.left), Math.max(p.x, this.right), Math.min(p.y, this.top), Math.max(p.y, this.bottom));
    }

    public final boolean contains(Point p) {
        return p.x >= this.left && p.y >= this.top && p.x <= this.right && p.y <= this.bottom;
    }

    public static Rect union(Rect a, Rect b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        if (a.contains(b)) {
            return a;
        }
        if (b.contains(a)) {
            return b;
        }
        return new Rect(Math.min(a.left, b.left), Math.max(a.right, b.right), Math.min(a.top, b.top), Math.max(a.bottom, b.bottom));
    }
}

