/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.geom;

public class Point
implements Comparable<Point> {
    public final double x;
    public final double y;

    public static int ccw(Point a, Point b, Point c) {
        double area2 = (b.x - a.x) * (c.y - a.y) - (b.y - a.y) * (c.x - a.x);
        return area2 < 0.0 ? -1 : (area2 > 0.0 ? 1 : 0);
    }

    public Point(double x, double y) {
        this.x = x;
        this.y = y;
    }

    @Override
    public int compareTo(Point p) {
        int d = Double.compare(this.y, p.y);
        return d == 0 ? Double.compare(this.x, p.x) : d;
    }

    public int hashCode() {
        long temp = Double.doubleToLongBits(this.x);
        int result = (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.y);
        return 31 * result + (int)(temp ^ temp >>> 32);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return ((Point)o).x == this.x && ((Point)o).y == this.y;
    }

    public String toString() {
        return String.format("(%.2f,%.2f)", this.x, this.y);
    }

    public Point translate(double dx, double dy) {
        return new Point(this.x + dx, this.y + dy);
    }
}

