/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.build.d3.diagrams;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import org.brunel.build.d3.D3Util;
import org.brunel.build.d3.diagrams.D3Diagram;
import org.brunel.build.element.ElementDefinition;
import org.brunel.build.element.ElementDetails;
import org.brunel.build.util.ModelUtil;
import org.brunel.build.util.ScriptWriter;
import org.brunel.data.Data;
import org.brunel.data.Dataset;
import org.brunel.maps.GeoInformation;
import org.brunel.maps.GeoMapping;
import org.brunel.maps.projection.ProjectionBuilder;
import org.brunel.model.VisSingle;
import org.brunel.model.VisTypes;

public class GeoMap
extends D3Diagram {
    private final GeoMapping mapping;

    public static void writeProjection(ScriptWriter out, GeoInformation geo) {
        out.comment("Define the projection");
        String[] projectionDescription = geo.d3Definition().split("\n");
        out.indentMore();
        out.add("var ");
        out.indentMore();
        if (projectionDescription[0].contains("winkel3")) {
            String[] strings = ProjectionBuilder.WinkelD3Function;
            out.add("winkel3 =", strings[0]);
            out.indentMore();
            for (int i = 1; i < strings.length; ++i) {
                out.onNewLine().add(strings[i]);
            }
            out.add(",").onNewLine();
            out.indentLess();
        }
        out.add("projection =", projectionDescription[0].trim());
        out.indentMore();
        for (int i = 1; i < projectionDescription.length; ++i) {
            out.onNewLine().add(projectionDescription[i].trim());
        }
        out.add(",").onNewLine();
        out.indentLess();
        out.add("zoom = d3.behavior.zoom()").addChained("scale(projection.scale()).translate(projection.translate())").addChained("on('zoom', function() {").onNewLine();
        out.indentMore();
        out.add("projection.translate(zoom.translate()).scale(zoom.scale())").endStatement();
        out.add("updateAll(0)").endStatement();
        out.indentLess().add("})");
        out.endStatement();
        out.indentLess();
        out.add("vis.call(zoom)").endStatement();
        out.add("function projectTransform(p) {").indentMore().onNewLine().add("var q = projection(p)").endStatement().onNewLine().add("if (!q) q = [-9e9,9e9]").endStatement().onNewLine().add("return 'translate(' + q[0] + ',' + q[1] + ')'").indentLess().onNewLine().add("}");
        out.onNewLine().add("function proj(p) { var q = p ? projection(p) : null; return q || [null,null] }").ln();
    }

    public GeoMap(VisSingle vis, Dataset data, GeoMapping mapping, ScriptWriter out) {
        super(vis, data, out);
        this.mapping = mapping;
        if (mapping == null) {
            throw new IllegalStateException("Maps need either a position field or key with the feature names; or another element to define positions");
        }
    }

    @Override
    public ElementDetails initializeDiagram() {
        this.out.indentLess().comment("Read in the feature data and call build again when done");
        this.writeFeatureHookup(this.mapping, GeoInformation.getIDField(this.vis));
        if (this.vis.tElement == VisTypes.Element.point || this.vis.tElement == VisTypes.Element.text) {
            return ElementDetails.makeForCoordinates(this.vis, ModelUtil.getElementSymbol(this.vis));
        }
        this.out.add("var path = d3.geo.path().projection(projection)").endStatement();
        return ElementDetails.makeForDiagram(this.vis, "data._rows", "path", "polygon", "geo", false);
    }

    private void writeFeatureHookup(GeoMapping mapping, String idField) {
        if (mapping.fileCount() == 0) {
            throw new IllegalStateException("No suitable map found");
        }
        this.out.add("var features = ");
        GeoMap.writeMapping(this.out, mapping);
        this.out.endStatement();
        String idName = idField == null ? "null" : "data." + D3Util.canonicalFieldName(idField);
        this.out.add("if (BrunelD3.addFeatures(data, features,", idName, ", this, transitionMillis)) return").endStatement();
    }

    public static void writeMapping(ScriptWriter out, GeoMapping map) {
        String[] files = map.getFiles();
        LinkedHashMap combined = new LinkedHashMap();
        for (String geo : files) {
            combined.put(geo, new TreeMap());
        }
        for (Map.Entry<Object, int[]> e : map.getFeatureMap().entrySet()) {
            Object dataName = e.getKey();
            int[] indices = e.getValue();
            String fileName = files[indices[0]];
            Map features = (Map)combined.get(fileName);
            features.put(dataName, indices[1]);
        }
        out.add("{").indentMore();
        for (int k = 0; k < files.length; ++k) {
            if (k > 0) {
                out.add(",").onNewLine();
            }
            String fileName = files[k];
            String source = Data.quote((String)(out.options.locMaps + "/" + out.options.version + "/" + fileName + ".json"));
            out.onNewLine().add(source, ":{").indentMore();
            int i = 0;
            Map features = (Map)combined.get(fileName);
            for (Map.Entry s : features.entrySet()) {
                if (i++ > 0) {
                    out.add(", ");
                }
                out.addQuoted(s.getKey()).add(":").add(s.getValue());
            }
            out.indentLess().onNewLine().add("}");
        }
        out.indentLess().onNewLine().add("}");
    }

    @Override
    public void writeDefinition(ElementDetails details, ElementDefinition elementDef) {
        if (this.vis.tElement == VisTypes.Element.point || this.vis.tElement == VisTypes.Element.text) {
            this.out.addChained("attr('transform', function(d) { return projectTransform(d.geo_properties ? [d.geo_properties.c, d.geo_properties.d]: [-999,-999]) } )");
            this.definePoint(elementDef, details);
            this.out.endStatement();
            this.addAestheticsAndTooltips(details, true);
        } else {
            this.out.addChained("attr('d', path )").endStatement();
        }
        this.addAestheticsAndTooltips(details, true);
    }

    @Override
    public void writeDiagramEnter() {
        super.writeDiagramEnter();
    }

    @Override
    public void writePreDefinition(ElementDetails details, ElementDefinition elementDef) {
        this.out.add("selection.classed('nondata', function(d) {return !d || d.row == null})").endStatement();
    }
}

