/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.build.d3;

import org.brunel.build.d3.D3LabelBuilder;
import org.brunel.build.d3.D3Util;
import org.brunel.build.element.ElementDefinition;
import org.brunel.build.element.ElementDetails;
import org.brunel.build.util.ScriptWriter;
import org.brunel.model.VisSingle;

public class D3PointBuilder {
    private final ScriptWriter out;

    public D3PointBuilder(ScriptWriter out) {
        this.out = out;
    }

    public boolean needsExtentFunctions(ElementDetails details) {
        return details.elementType.equals("rect");
    }

    public void defineShapeGeometry(VisSingle vis, ElementDefinition elementDef, ElementDetails details) {
        if (details.elementType.equals("rect")) {
            this.defineRect(elementDef);
        } else if (details.elementType.equals("text")) {
            this.defineText(elementDef, vis);
        } else {
            this.defineCircle(elementDef);
        }
    }

    private void defineText(ElementDefinition elementDef, VisSingle vis) {
        if (elementDef.x.center != null) {
            this.out.addChained("attr('x'," + elementDef.x.center + ")");
        }
        if (elementDef.y.center != null) {
            this.out.addChained("attr('y'," + elementDef.y.center + ")");
        }
        this.out.addChained("attr('dy', '0.35em').text(labeling.content)");
        D3LabelBuilder.addFontSizeAttribute(vis, this.out);
    }

    private void defineCircle(ElementDefinition elementDef) {
        if (elementDef.x.center != null) {
            this.out.addChained("attr('cx'," + elementDef.x.center + ")");
        }
        if (elementDef.y.center != null) {
            this.out.addChained("attr('cy'," + elementDef.y.center + ")");
        }
        this.out.addChained("attr('r'," + this.halve(elementDef.overallSize) + ")");
    }

    private String halve(String sizeText) {
        String body = D3Util.stripFunction(sizeText);
        if (body.equals(sizeText)) {
            return body + " / 2";
        }
        return "function(d) { return d.row ? " + body + " / 2 : 0 }";
    }

    private void defineRect(ElementDefinition elementDef) {
        this.defineHorizontalExtent(elementDef.x);
        this.defineVerticalExtent(elementDef.y);
    }

    void defineHorizontalExtent(ElementDefinition.ElementDimensionDefinition dimensionDef) {
        String width;
        String left;
        if (dimensionDef.left != null) {
            left = "function(d) { return Math.min(x0(d), x1(d)) }";
            width = "function(d) { return Math.abs(x1(d) - x0(d)) }";
        } else if (dimensionDef.center != null) {
            left = dimensionDef.size.startsWith("function") ? "function(d) { return x(d) - w(d)/2 }" : "function(d) { return x(d) - w/2 }";
            width = "w";
        } else {
            left = null;
            width = dimensionDef.size;
        }
        if (left != null) {
            this.out.addChained("attr('x', ", left, ")");
        }
        this.out.addChained("attr('width', ", width, ")");
        this.out.addChained("style('width', ", width, ")");
    }

    private void defineVerticalExtent(ElementDefinition.ElementDimensionDefinition dimensionDef) {
        String height;
        String top;
        if (dimensionDef.left != null) {
            top = "function(d) { return Math.min(y0(d), y1(d)) }";
            height = "function(d) { return Math.max(0.0001, Math.abs(y1(d) - y0(d))) }";
        } else if (dimensionDef.center != null) {
            top = dimensionDef.size.startsWith("function") ? "function(d) { return y(d) - h(d)/2 }" : "function(d) { return y(d) - h/2 }";
            height = "h";
        } else {
            top = null;
            height = dimensionDef.size;
        }
        this.out.addChained("attr('y', ", top, ")");
        this.out.addChained("attr('height', ", height, ")");
    }
}

