/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.action;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.brunel.action.ActionStep;
import org.brunel.action.Param;
import org.brunel.action.parse.GrammarItem;
import org.brunel.action.parse.ParseGrammar;

class ActionSimplification {
    private static final Map<String, Integer> ORDER = new HashMap<String, Integer>();
    private final ArrayList<ActionStep> items;
    private final ParseGrammar grammar = ParseGrammar.instance();

    public ActionSimplification(ActionStep[] steps) {
        this.items = new ArrayList<ActionStep>(Arrays.asList(steps));
    }

    public ActionStep[] make() {
        ArrayList<ActionStep> result = new ArrayList<ActionStep>();
        int last = 0;
        for (int i = 0; i < this.items.size(); ++i) {
            String name = this.items.get((int)i).name;
            if (!name.equals(">") && !name.equals(">>") && !name.equals("|") && !name.equals("+")) continue;
            ArrayList<ActionStep> base = this.process(this.items.subList(last, i));
            result.addAll(base);
            result.add(this.items.get(i));
            last = i + 1;
        }
        if (last < this.items.size()) {
            result.addAll(this.process(this.items.subList(last, this.items.size())));
        }
        return result.toArray(new ActionStep[result.size()]);
    }

    private boolean canMerge(String name) {
        GrammarItem def = this.grammar.get(name);
        return !def.type.equals("color") && def.allowsMultiples();
    }

    private void dropAllExceptLast(ArrayList<ActionStep> base, String type, boolean ignoreParameters) {
        boolean found = false;
        Param[] lastParams = null;
        for (int i = base.size() - 1; i >= 0; --i) {
            ActionStep single = base.get(i);
            String actionType = this.grammar.get((String)single.name).type;
            if (!actionType.equals(type) || found && !ignoreParameters && !this.parametersMatch(single.parameters, lastParams)) continue;
            if (found) {
                base.remove(i);
                continue;
            }
            found = true;
            lastParams = single.parameters;
        }
    }

    private void dropAllExceptLastByName(ArrayList<ActionStep> base, String name) {
        boolean found = false;
        for (int i = base.size() - 1; i >= 0; --i) {
            String actionName = base.get((int)i).name;
            if (!actionName.equals(name)) continue;
            if (found) {
                base.remove(i);
                continue;
            }
            found = true;
        }
    }

    private void sortMultiOptions(ArrayList<ActionStep> base) {
        for (ActionStep step : base) {
            if (!this.grammar.get(step.name).mayHaveMultipleOptions()) continue;
            Arrays.sort(step.parameters);
        }
    }

    private ActionStep mergeActions(ActionStep a, ActionStep b) {
        assert (a.name.equals(b.name));
        Param[] params = new Param[a.parameters.length + b.parameters.length];
        System.arraycopy(a.parameters, 0, params, 0, a.parameters.length);
        System.arraycopy(b.parameters, 0, params, a.parameters.length, b.parameters.length);
        return new ActionStep(a.name, params);
    }

    private void mergeSimilar(ArrayList<ActionStep> base) {
        int lastIndex = -1;
        for (int i = base.size() - 1; i >= 0; --i) {
            String name = base.get((int)i).name;
            int index = ORDER.get(name);
            if (index == lastIndex && this.canMerge(name)) {
                base.set(i, this.mergeActions(base.get(i), base.remove(i + 1)));
                continue;
            }
            lastIndex = index;
        }
    }

    private void orderCanonically(ArrayList<ActionStep> base) {
        Collections.sort(base, new Comparator<ActionStep>(){

            @Override
            public int compare(ActionStep o1, ActionStep o2) {
                return (Integer)ORDER.get(o1.name) - (Integer)ORDER.get(o2.name);
            }
        });
    }

    private boolean parametersMatch(Param[] a, Param[] b) {
        return Arrays.equals(a, b);
    }

    private ArrayList<ActionStep> process(List<ActionStep> subList) {
        ArrayList<ActionStep> base = new ArrayList<ActionStep>(subList);
        this.dropAllExceptLast(base, "element", true);
        this.dropAllExceptLast(base, "diagram", true);
        this.dropAllExceptLast(base, "data", false);
        this.dropAllExceptLastByName(base, "data");
        this.dropAllExceptLastByName(base, "legends");
        this.dropAllExceptLastByName(base, "at");
        this.orderCanonically(base);
        this.mergeSimilar(base);
        this.sortMultiOptions(base);
        return base;
    }

    static {
        for (String s : ParseGrammar.getCommands()) {
            ORDER.put(s, ORDER.size());
        }
    }
}

