/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive.scheduler.rest.data;

import java.io.Serializable;
import java.util.Map;
import java.util.stream.Collectors;
import org.ow2.proactive.scheduler.common.exception.UnknownTaskException;
import org.ow2.proactive.scheduler.common.job.JobId;
import org.ow2.proactive.scheduler.common.job.JobInfo;
import org.ow2.proactive.scheduler.common.job.JobResult;
import org.ow2.proactive.scheduler.common.task.TaskResult;
import org.ow2.proactive.scheduler.job.JobIdImpl;
import org.ow2.proactive.scheduler.rest.data.DataUtility;
import org.ow2.proactive.utils.ObjectByteConverter;
import org.ow2.proactive_grid_cloud_portal.scheduler.dto.JobIdData;
import org.ow2.proactive_grid_cloud_portal.scheduler.dto.JobInfoData;
import org.ow2.proactive_grid_cloud_portal.scheduler.dto.JobResultData;
import org.ow2.proactive_grid_cloud_portal.scheduler.dto.TaskResultData;

public class JobResultImpl
implements JobResult {
    private static final long serialVersionUID = 1L;
    private JobId jobId;
    private JobInfoData jobInfo;
    private Map<String, TaskResult> allResults;
    private Map<String, TaskResult> preciousResults;
    private Map<String, Serializable> resultMap;
    private Map<String, TaskResult> exceptionResults;

    JobResultImpl(JobResultData data) {
        JobIdData id = data.getId();
        this.jobId = new JobIdImpl(id.getId(), id.getReadableName());
        this.allResults = this.createTaskResultMap(data.getAllResults());
        this.preciousResults = this.createTaskResultMap(data.getPreciousResults());
        this.exceptionResults = this.createTaskResultMap(data.getExceptionResults());
        this.resultMap = ObjectByteConverter.mapOfBase64StringToSerializable((Map)data.getSerializedResultMap());
        this.jobInfo = data.getJobInfo();
    }

    private Map<String, TaskResult> createTaskResultMap(Map<String, TaskResultData> inputDataMap) {
        return inputDataMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> DataUtility.toTaskResult(this.jobId, (TaskResultData)entry.getValue())));
    }

    public Map<String, TaskResult> getAllResults() {
        return this.allResults;
    }

    public Map<String, TaskResult> getExceptionResults() {
        return this.exceptionResults;
    }

    public JobId getJobId() {
        return this.jobId;
    }

    public JobInfo getJobInfo() {
        return DataUtility.toJobInfo(this.jobInfo);
    }

    public String getName() {
        return this.jobId.getReadableName();
    }

    public Map<String, TaskResult> getPreciousResults() {
        return this.preciousResults;
    }

    public Map<String, Serializable> getResultMap() {
        return this.resultMap;
    }

    public TaskResult getResult(String taskName) throws UnknownTaskException {
        return this.allResults.get(taskName);
    }

    public boolean hadException() {
        return this.exceptionResults.size() > 0;
    }

    public void removeResult(String taskName) throws UnknownTaskException {
        this.allResults.remove(taskName);
    }
}

