/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive.scheduler.common.task;

import com.google.common.base.Throwables;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.LinkedList;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Category;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.Priority;
import org.apache.log4j.spi.LoggingEvent;
import org.objectweb.proactive.annotation.PublicAPI;
import org.ow2.proactive.scheduler.common.job.JobId;
import org.ow2.proactive.scheduler.common.task.TaskLogs;
import org.ow2.proactive.scheduler.core.properties.PASchedulerProperties;
import org.ow2.proactive.utils.ObjectByteConverter;

@PublicAPI
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Log4JTaskLogs
implements TaskLogs {
    private static final long serialVersionUID = 1L;
    public static final String JOB_LOGGER_PREFIX = "logger.scheduler.";
    public static final String MDC_JOB_ID = "job.id";
    public static final String MDC_TASK_ID = "task.id";
    public static final String MDC_TASK_NAME = "task.name";
    public static final String MDC_HOST = "host";
    public static final Level STDOUT_LEVEL = Level.INFO;
    public static final Level STDERR_LEVEL = Level.ERROR;
    private transient LinkedList<LoggingEvent> allEvents;
    private byte[] serializedAllEvents;
    private String loggerName;
    private static final String nl = System.lineSeparator();

    public static Layout getTaskLogLayout() {
        PatternLayout patternLayout = PASchedulerProperties.SCHEDULER_JOB_LOGS_PATTERN.isSet() ? new PatternLayout(PASchedulerProperties.SCHEDULER_JOB_LOGS_PATTERN.getValueAsString()) : new PatternLayout("[%X{job.id}t%X{task.id}@%X{host};%d{HH:mm:ss}] %m %n");
        return patternLayout;
    }

    public static String getLoggerName(String jobId) {
        return JOB_LOGGER_PREFIX + jobId;
    }

    public static String getLoggerName(JobId jobId) {
        return Log4JTaskLogs.getLoggerName(jobId.toString());
    }

    public Log4JTaskLogs() {
    }

    public Log4JTaskLogs(LinkedList<LoggingEvent> all, String jobId) {
        this.allEvents = all;
        this.loggerName = JOB_LOGGER_PREFIX + jobId;
        this.storeEvents();
    }

    @Override
    public synchronized String getAllLogs(boolean timeStamp) {
        this.restoreEvents();
        StringBuffer logs = new StringBuffer(this.allEvents.size());
        Layout l = Log4JTaskLogs.getTaskLogLayout();
        for (LoggingEvent e : this.allEvents) {
            this.appendEventToLogs(e, logs, l, timeStamp);
        }
        return logs.toString();
    }

    private void appendEventToLogs(LoggingEvent logEvent, StringBuffer logs, Layout logFormat, boolean timeStamp) {
        if (timeStamp) {
            logs.append(StringUtils.stripEnd((String)logFormat.format(logEvent), null) + nl);
        } else {
            Object message = logEvent.getMessage();
            logs.append(StringUtils.stripEnd((String)message.toString(), null) + nl);
        }
    }

    private void restoreEvents() {
        if (this.allEvents == null) {
            try {
                this.allEvents = (LinkedList)ObjectByteConverter.byteArrayToObject((byte[])this.serializedAllEvents, (boolean)true);
            }
            catch (Exception e) {
                LoggingEvent logError = new LoggingEvent(this.loggerName, (Category)Logger.getLogger((String)this.loggerName), (Priority)STDERR_LEVEL, (Object)("Cannot restore logging event from byte array : " + Throwables.getStackTraceAsString((Throwable)e)), (Throwable)e);
                this.allEvents = new LinkedList();
                this.allEvents.add(logError);
            }
        }
    }

    private void storeEvents() {
        if (this.serializedAllEvents == null) {
            try {
                this.serializedAllEvents = ObjectByteConverter.objectToByteArray(this.allEvents, (boolean)true);
            }
            catch (Exception e) {
                LoggingEvent logError = new LoggingEvent(this.loggerName, (Category)Logger.getLogger((String)this.loggerName), (Priority)STDERR_LEVEL, (Object)("Could not convert logging event to byte array : " + Throwables.getStackTraceAsString((Throwable)e)), (Throwable)e);
                LinkedList<LoggingEvent> errorEvent = new LinkedList<LoggingEvent>();
                errorEvent.add(logError);
                try {
                    this.serializedAllEvents = ObjectByteConverter.objectToByteArray(errorEvent, (boolean)true);
                }
                catch (Exception e1) {
                    Logger.getLogger(Log4JTaskLogs.class).error((Object)"Could not convert to serialized events", (Throwable)e1);
                }
            }
            this.allEvents = null;
        }
    }

    @Override
    public synchronized String getStderrLogs(boolean timeStamp) {
        this.restoreEvents();
        StringBuffer logs = new StringBuffer();
        Layout l = Log4JTaskLogs.getTaskLogLayout();
        for (LoggingEvent e : this.allEvents) {
            if (!STDERR_LEVEL.equals((Object)e.getLevel())) continue;
            this.appendEventToLogs(e, logs, l, timeStamp);
        }
        return logs.toString();
    }

    @Override
    public String getStdoutLogs() {
        return this.getStdoutLogs(false);
    }

    @Override
    public String getStderrLogs() {
        return this.getStderrLogs(false);
    }

    @Override
    public String getAllLogs() {
        return this.getAllLogs(false);
    }

    @Override
    public synchronized String getStdoutLogs(boolean timeStamp) {
        this.restoreEvents();
        StringBuffer logs = new StringBuffer();
        Layout l = Log4JTaskLogs.getTaskLogLayout();
        for (LoggingEvent e : this.allEvents) {
            if (!STDOUT_LEVEL.equals((Object)e.getLevel())) continue;
            this.appendEventToLogs(e, logs, l, timeStamp);
        }
        return logs.toString();
    }

    public synchronized LinkedList<LoggingEvent> getAllEvents() {
        this.restoreEvents();
        return (LinkedList)this.allEvents.clone();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.storeEvents();
        out.defaultWriteObject();
    }
}

