# Copyright 2020 StrongDM Inc
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

# Code generated by protogen. DO NOT EDIT.

import collections


class AKS:
    __slots__ = [
        'allow_resource_role_bypass',
        'bind_interface',
        'certificate_authority',
        'client_certificate',
        'client_key',
        'discovery_enabled',
        'discovery_username',
        'egress_filter',
        'healthcheck_namespace',
        'healthy',
        'hostname',
        'id',
        'identity_alias_healthcheck_username',
        'identity_set_id',
        'name',
        'port',
        'port_override',
        'proxy_cluster_id',
        'secret_store_id',
        'subdomain',
        'tags',
    ]

    def __init__(
        self,
        allow_resource_role_bypass=None,
        bind_interface=None,
        certificate_authority=None,
        client_certificate=None,
        client_key=None,
        discovery_enabled=None,
        discovery_username=None,
        egress_filter=None,
        healthcheck_namespace=None,
        healthy=None,
        hostname=None,
        id=None,
        identity_alias_healthcheck_username=None,
        identity_set_id=None,
        name=None,
        port=None,
        port_override=None,
        proxy_cluster_id=None,
        secret_store_id=None,
        subdomain=None,
        tags=None,
    ):
        self.allow_resource_role_bypass = allow_resource_role_bypass if allow_resource_role_bypass is not None else False
        '''
         If true, allows users to fallback to the existing authentication mode (Leased Credential or Identity Set)
         when a resource role is not provided.
        '''
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided and may also be set to one of the ResourceIPAllocationMode constants to select between VNM, loopback, or default allocation.
        '''
        self.certificate_authority = certificate_authority if certificate_authority is not None else ''
        '''
         The CA to authenticate TLS connections with.
        '''
        self.client_certificate = client_certificate if client_certificate is not None else ''
        '''
         The certificate to authenticate TLS connections with.
        '''
        self.client_key = client_key if client_key is not None else ''
        '''
         The key to authenticate TLS connections with.
        '''
        self.discovery_enabled = discovery_enabled if discovery_enabled is not None else False
        '''
         If true, configures discovery of a cluster to be run from a node.
        '''
        self.discovery_username = discovery_username if discovery_username is not None else ''
        '''
         If a cluster is configured for user impersonation, this is the user to impersonate when
         running discovery.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthcheck_namespace = healthcheck_namespace if healthcheck_namespace is not None else ''
        '''
         The path used to check the health of your connection.  Defaults to `default`.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        '''
         The host to dial to initiate a connection from the egress node to this resource.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.identity_alias_healthcheck_username = identity_alias_healthcheck_username if identity_alias_healthcheck_username is not None else ''
        '''
         The username to use for healthchecks, when clients otherwise connect with their own identity alias username.
        '''
        self.identity_set_id = identity_set_id if identity_set_id is not None else ''
        '''
         The ID of the identity set to use for identity connections.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.port = port if port is not None else 0
        '''
         The port to dial to initiate a connection from the egress node to this resource.
        '''
        self.port_override = port_override if port_override is not None else 0
        '''
         The local port used by clients to connect to this resource. It is automatically generated if not provided on create and may be re-generated on update by specifying a value of -1.
        '''
        self.proxy_cluster_id = proxy_cluster_id if proxy_cluster_id is not None else ''
        '''
         ID of the proxy cluster for this resource, if any.
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         DNS subdomain through which this resource may be accessed on clients.  (e.g. "app-prod1" allows the resource to be accessed at "app-prod1.your-org-name.sdm-proxy-domain"). Only applicable to HTTP-based resources or resources using virtual networking mode.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''

    def __repr__(self):
        return '<sdm.AKS ' + \
            'allow_resource_role_bypass: ' + repr(self.allow_resource_role_bypass) + ' ' +\
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'certificate_authority: ' + repr(self.certificate_authority) + ' ' +\
            'client_certificate: ' + repr(self.client_certificate) + ' ' +\
            'client_key: ' + repr(self.client_key) + ' ' +\
            'discovery_enabled: ' + repr(self.discovery_enabled) + ' ' +\
            'discovery_username: ' + repr(self.discovery_username) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthcheck_namespace: ' + repr(self.healthcheck_namespace) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'identity_alias_healthcheck_username: ' + repr(self.identity_alias_healthcheck_username) + ' ' +\
            'identity_set_id: ' + repr(self.identity_set_id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'proxy_cluster_id: ' + repr(self.proxy_cluster_id) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'allow_resource_role_bypass': self.allow_resource_role_bypass,
            'bind_interface': self.bind_interface,
            'certificate_authority': self.certificate_authority,
            'client_certificate': self.client_certificate,
            'client_key': self.client_key,
            'discovery_enabled': self.discovery_enabled,
            'discovery_username': self.discovery_username,
            'egress_filter': self.egress_filter,
            'healthcheck_namespace': self.healthcheck_namespace,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'identity_alias_healthcheck_username':
            self.identity_alias_healthcheck_username,
            'identity_set_id': self.identity_set_id,
            'name': self.name,
            'port': self.port,
            'port_override': self.port_override,
            'proxy_cluster_id': self.proxy_cluster_id,
            'secret_store_id': self.secret_store_id,
            'subdomain': self.subdomain,
            'tags': self.tags,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            allow_resource_role_bypass=d.get('allow_resource_role_bypass'),
            bind_interface=d.get('bind_interface'),
            certificate_authority=d.get('certificate_authority'),
            client_certificate=d.get('client_certificate'),
            client_key=d.get('client_key'),
            discovery_enabled=d.get('discovery_enabled'),
            discovery_username=d.get('discovery_username'),
            egress_filter=d.get('egress_filter'),
            healthcheck_namespace=d.get('healthcheck_namespace'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            identity_alias_healthcheck_username=d.get(
                'identity_alias_healthcheck_username'),
            identity_set_id=d.get('identity_set_id'),
            name=d.get('name'),
            port=d.get('port'),
            port_override=d.get('port_override'),
            proxy_cluster_id=d.get('proxy_cluster_id'),
            secret_store_id=d.get('secret_store_id'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
        )


class AKSBasicAuth:
    '''
    AKSBasicAuth is currently unstable, and its API may change, or it may be removed,
    without a major version bump.
    '''
    __slots__ = [
        'bind_interface',
        'egress_filter',
        'healthcheck_namespace',
        'healthy',
        'hostname',
        'id',
        'name',
        'password',
        'port',
        'port_override',
        'proxy_cluster_id',
        'secret_store_id',
        'subdomain',
        'tags',
        'username',
    ]

    def __init__(
        self,
        bind_interface=None,
        egress_filter=None,
        healthcheck_namespace=None,
        healthy=None,
        hostname=None,
        id=None,
        name=None,
        password=None,
        port=None,
        port_override=None,
        proxy_cluster_id=None,
        secret_store_id=None,
        subdomain=None,
        tags=None,
        username=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided and may also be set to one of the ResourceIPAllocationMode constants to select between VNM, loopback, or default allocation.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthcheck_namespace = healthcheck_namespace if healthcheck_namespace is not None else ''
        '''
         The path used to check the health of your connection.  Defaults to `default`.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        '''
         The host to dial to initiate a connection from the egress node to this resource.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.password = password if password is not None else ''
        '''
         The password to authenticate with.
        '''
        self.port = port if port is not None else 0
        '''
         The port to dial to initiate a connection from the egress node to this resource.
        '''
        self.port_override = port_override if port_override is not None else 0
        '''
         The local port used by clients to connect to this resource. It is automatically generated if not provided on create and may be re-generated on update by specifying a value of -1.
        '''
        self.proxy_cluster_id = proxy_cluster_id if proxy_cluster_id is not None else ''
        '''
         ID of the proxy cluster for this resource, if any.
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         DNS subdomain through which this resource may be accessed on clients.  (e.g. "app-prod1" allows the resource to be accessed at "app-prod1.your-org-name.sdm-proxy-domain"). Only applicable to HTTP-based resources or resources using virtual networking mode.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.username = username if username is not None else ''
        '''
         The username to authenticate with.
        '''

    def __repr__(self):
        return '<sdm.AKSBasicAuth ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthcheck_namespace: ' + repr(self.healthcheck_namespace) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'password: ' + repr(self.password) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'proxy_cluster_id: ' + repr(self.proxy_cluster_id) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'username: ' + repr(self.username) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'egress_filter': self.egress_filter,
            'healthcheck_namespace': self.healthcheck_namespace,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'name': self.name,
            'password': self.password,
            'port': self.port,
            'port_override': self.port_override,
            'proxy_cluster_id': self.proxy_cluster_id,
            'secret_store_id': self.secret_store_id,
            'subdomain': self.subdomain,
            'tags': self.tags,
            'username': self.username,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            egress_filter=d.get('egress_filter'),
            healthcheck_namespace=d.get('healthcheck_namespace'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            name=d.get('name'),
            password=d.get('password'),
            port=d.get('port'),
            port_override=d.get('port_override'),
            proxy_cluster_id=d.get('proxy_cluster_id'),
            secret_store_id=d.get('secret_store_id'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
            username=d.get('username'),
        )


class AKSServiceAccount:
    __slots__ = [
        'allow_resource_role_bypass',
        'bind_interface',
        'discovery_enabled',
        'discovery_username',
        'egress_filter',
        'healthcheck_namespace',
        'healthy',
        'hostname',
        'id',
        'identity_alias_healthcheck_username',
        'identity_set_id',
        'name',
        'port',
        'port_override',
        'proxy_cluster_id',
        'secret_store_id',
        'subdomain',
        'tags',
        'token',
    ]

    def __init__(
        self,
        allow_resource_role_bypass=None,
        bind_interface=None,
        discovery_enabled=None,
        discovery_username=None,
        egress_filter=None,
        healthcheck_namespace=None,
        healthy=None,
        hostname=None,
        id=None,
        identity_alias_healthcheck_username=None,
        identity_set_id=None,
        name=None,
        port=None,
        port_override=None,
        proxy_cluster_id=None,
        secret_store_id=None,
        subdomain=None,
        tags=None,
        token=None,
    ):
        self.allow_resource_role_bypass = allow_resource_role_bypass if allow_resource_role_bypass is not None else False
        '''
         If true, allows users to fallback to the existing authentication mode (Leased Credential or Identity Set)
         when a resource role is not provided.
        '''
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided and may also be set to one of the ResourceIPAllocationMode constants to select between VNM, loopback, or default allocation.
        '''
        self.discovery_enabled = discovery_enabled if discovery_enabled is not None else False
        '''
         If true, configures discovery of a cluster to be run from a node.
        '''
        self.discovery_username = discovery_username if discovery_username is not None else ''
        '''
         If a cluster is configured for user impersonation, this is the user to impersonate when
         running discovery.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthcheck_namespace = healthcheck_namespace if healthcheck_namespace is not None else ''
        '''
         The path used to check the health of your connection.  Defaults to `default`.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        '''
         The host to dial to initiate a connection from the egress node to this resource.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.identity_alias_healthcheck_username = identity_alias_healthcheck_username if identity_alias_healthcheck_username is not None else ''
        '''
         The username to use for healthchecks, when clients otherwise connect with their own identity alias username.
        '''
        self.identity_set_id = identity_set_id if identity_set_id is not None else ''
        '''
         The ID of the identity set to use for identity connections.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.port = port if port is not None else 0
        '''
         The port to dial to initiate a connection from the egress node to this resource.
        '''
        self.port_override = port_override if port_override is not None else 0
        '''
         The local port used by clients to connect to this resource. It is automatically generated if not provided on create and may be re-generated on update by specifying a value of -1.
        '''
        self.proxy_cluster_id = proxy_cluster_id if proxy_cluster_id is not None else ''
        '''
         ID of the proxy cluster for this resource, if any.
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         DNS subdomain through which this resource may be accessed on clients.  (e.g. "app-prod1" allows the resource to be accessed at "app-prod1.your-org-name.sdm-proxy-domain"). Only applicable to HTTP-based resources or resources using virtual networking mode.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.token = token if token is not None else ''
        '''
         The API token to authenticate with.
        '''

    def __repr__(self):
        return '<sdm.AKSServiceAccount ' + \
            'allow_resource_role_bypass: ' + repr(self.allow_resource_role_bypass) + ' ' +\
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'discovery_enabled: ' + repr(self.discovery_enabled) + ' ' +\
            'discovery_username: ' + repr(self.discovery_username) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthcheck_namespace: ' + repr(self.healthcheck_namespace) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'identity_alias_healthcheck_username: ' + repr(self.identity_alias_healthcheck_username) + ' ' +\
            'identity_set_id: ' + repr(self.identity_set_id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'proxy_cluster_id: ' + repr(self.proxy_cluster_id) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'token: ' + repr(self.token) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'allow_resource_role_bypass': self.allow_resource_role_bypass,
            'bind_interface': self.bind_interface,
            'discovery_enabled': self.discovery_enabled,
            'discovery_username': self.discovery_username,
            'egress_filter': self.egress_filter,
            'healthcheck_namespace': self.healthcheck_namespace,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'identity_alias_healthcheck_username':
            self.identity_alias_healthcheck_username,
            'identity_set_id': self.identity_set_id,
            'name': self.name,
            'port': self.port,
            'port_override': self.port_override,
            'proxy_cluster_id': self.proxy_cluster_id,
            'secret_store_id': self.secret_store_id,
            'subdomain': self.subdomain,
            'tags': self.tags,
            'token': self.token,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            allow_resource_role_bypass=d.get('allow_resource_role_bypass'),
            bind_interface=d.get('bind_interface'),
            discovery_enabled=d.get('discovery_enabled'),
            discovery_username=d.get('discovery_username'),
            egress_filter=d.get('egress_filter'),
            healthcheck_namespace=d.get('healthcheck_namespace'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            identity_alias_healthcheck_username=d.get(
                'identity_alias_healthcheck_username'),
            identity_set_id=d.get('identity_set_id'),
            name=d.get('name'),
            port=d.get('port'),
            port_override=d.get('port_override'),
            proxy_cluster_id=d.get('proxy_cluster_id'),
            secret_store_id=d.get('secret_store_id'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
            token=d.get('token'),
        )


class AKSServiceAccountUserImpersonation:
    '''
    AKSServiceAccountUserImpersonation is deprecated, see docs for more info.
    '''
    __slots__ = [
        'bind_interface',
        'egress_filter',
        'healthcheck_namespace',
        'healthy',
        'hostname',
        'id',
        'name',
        'port',
        'port_override',
        'proxy_cluster_id',
        'secret_store_id',
        'subdomain',
        'tags',
        'token',
    ]

    def __init__(
        self,
        bind_interface=None,
        egress_filter=None,
        healthcheck_namespace=None,
        healthy=None,
        hostname=None,
        id=None,
        name=None,
        port=None,
        port_override=None,
        proxy_cluster_id=None,
        secret_store_id=None,
        subdomain=None,
        tags=None,
        token=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided and may also be set to one of the ResourceIPAllocationMode constants to select between VNM, loopback, or default allocation.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthcheck_namespace = healthcheck_namespace if healthcheck_namespace is not None else ''
        '''
         The path used to check the health of your connection.  Defaults to `default`.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        '''
         The host to dial to initiate a connection from the egress node to this resource.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.port = port if port is not None else 0
        '''
         The port to dial to initiate a connection from the egress node to this resource.
        '''
        self.port_override = port_override if port_override is not None else 0
        '''
         The local port used by clients to connect to this resource. It is automatically generated if not provided on create and may be re-generated on update by specifying a value of -1.
        '''
        self.proxy_cluster_id = proxy_cluster_id if proxy_cluster_id is not None else ''
        '''
         ID of the proxy cluster for this resource, if any.
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         DNS subdomain through which this resource may be accessed on clients.  (e.g. "app-prod1" allows the resource to be accessed at "app-prod1.your-org-name.sdm-proxy-domain"). Only applicable to HTTP-based resources or resources using virtual networking mode.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.token = token if token is not None else ''
        '''
         The API token to authenticate with.
        '''

    def __repr__(self):
        return '<sdm.AKSServiceAccountUserImpersonation ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthcheck_namespace: ' + repr(self.healthcheck_namespace) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'proxy_cluster_id: ' + repr(self.proxy_cluster_id) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'token: ' + repr(self.token) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'egress_filter': self.egress_filter,
            'healthcheck_namespace': self.healthcheck_namespace,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'name': self.name,
            'port': self.port,
            'port_override': self.port_override,
            'proxy_cluster_id': self.proxy_cluster_id,
            'secret_store_id': self.secret_store_id,
            'subdomain': self.subdomain,
            'tags': self.tags,
            'token': self.token,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            egress_filter=d.get('egress_filter'),
            healthcheck_namespace=d.get('healthcheck_namespace'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            name=d.get('name'),
            port=d.get('port'),
            port_override=d.get('port_override'),
            proxy_cluster_id=d.get('proxy_cluster_id'),
            secret_store_id=d.get('secret_store_id'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
            token=d.get('token'),
        )


class AKSUserImpersonation:
    '''
    AKSUserImpersonation is deprecated, see docs for more info.
    '''
    __slots__ = [
        'bind_interface',
        'certificate_authority',
        'client_certificate',
        'client_key',
        'egress_filter',
        'healthcheck_namespace',
        'healthy',
        'hostname',
        'id',
        'name',
        'port',
        'port_override',
        'proxy_cluster_id',
        'secret_store_id',
        'subdomain',
        'tags',
    ]

    def __init__(
        self,
        bind_interface=None,
        certificate_authority=None,
        client_certificate=None,
        client_key=None,
        egress_filter=None,
        healthcheck_namespace=None,
        healthy=None,
        hostname=None,
        id=None,
        name=None,
        port=None,
        port_override=None,
        proxy_cluster_id=None,
        secret_store_id=None,
        subdomain=None,
        tags=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided and may also be set to one of the ResourceIPAllocationMode constants to select between VNM, loopback, or default allocation.
        '''
        self.certificate_authority = certificate_authority if certificate_authority is not None else ''
        '''
         The CA to authenticate TLS connections with.
        '''
        self.client_certificate = client_certificate if client_certificate is not None else ''
        '''
         The certificate to authenticate TLS connections with.
        '''
        self.client_key = client_key if client_key is not None else ''
        '''
         The key to authenticate TLS connections with.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthcheck_namespace = healthcheck_namespace if healthcheck_namespace is not None else ''
        '''
         The path used to check the health of your connection.  Defaults to `default`.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        '''
         The host to dial to initiate a connection from the egress node to this resource.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.port = port if port is not None else 0
        '''
         The port to dial to initiate a connection from the egress node to this resource.
        '''
        self.port_override = port_override if port_override is not None else 0
        '''
         The local port used by clients to connect to this resource. It is automatically generated if not provided on create and may be re-generated on update by specifying a value of -1.
        '''
        self.proxy_cluster_id = proxy_cluster_id if proxy_cluster_id is not None else ''
        '''
         ID of the proxy cluster for this resource, if any.
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         DNS subdomain through which this resource may be accessed on clients.  (e.g. "app-prod1" allows the resource to be accessed at "app-prod1.your-org-name.sdm-proxy-domain"). Only applicable to HTTP-based resources or resources using virtual networking mode.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''

    def __repr__(self):
        return '<sdm.AKSUserImpersonation ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'certificate_authority: ' + repr(self.certificate_authority) + ' ' +\
            'client_certificate: ' + repr(self.client_certificate) + ' ' +\
            'client_key: ' + repr(self.client_key) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthcheck_namespace: ' + repr(self.healthcheck_namespace) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'proxy_cluster_id: ' + repr(self.proxy_cluster_id) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'certificate_authority': self.certificate_authority,
            'client_certificate': self.client_certificate,
            'client_key': self.client_key,
            'egress_filter': self.egress_filter,
            'healthcheck_namespace': self.healthcheck_namespace,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'name': self.name,
            'port': self.port,
            'port_override': self.port_override,
            'proxy_cluster_id': self.proxy_cluster_id,
            'secret_store_id': self.secret_store_id,
            'subdomain': self.subdomain,
            'tags': self.tags,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            certificate_authority=d.get('certificate_authority'),
            client_certificate=d.get('client_certificate'),
            client_key=d.get('client_key'),
            egress_filter=d.get('egress_filter'),
            healthcheck_namespace=d.get('healthcheck_namespace'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            name=d.get('name'),
            port=d.get('port'),
            port_override=d.get('port_override'),
            proxy_cluster_id=d.get('proxy_cluster_id'),
            secret_store_id=d.get('secret_store_id'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
        )


class AMQP:
    '''
    AMQP is currently unstable, and its API may change, or it may be removed,
    without a major version bump.
    '''
    __slots__ = [
        'bind_interface',
        'egress_filter',
        'healthy',
        'hostname',
        'id',
        'name',
        'password',
        'port',
        'port_override',
        'proxy_cluster_id',
        'secret_store_id',
        'subdomain',
        'tags',
        'tls_required',
        'username',
    ]

    def __init__(
        self,
        bind_interface=None,
        egress_filter=None,
        healthy=None,
        hostname=None,
        id=None,
        name=None,
        password=None,
        port=None,
        port_override=None,
        proxy_cluster_id=None,
        secret_store_id=None,
        subdomain=None,
        tags=None,
        tls_required=None,
        username=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided and may also be set to one of the ResourceIPAllocationMode constants to select between VNM, loopback, or default allocation.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        '''
         The host to dial to initiate a connection from the egress node to this resource.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.password = password if password is not None else ''
        '''
         The password to authenticate with.
        '''
        self.port = port if port is not None else 0
        '''
         The port to dial to initiate a connection from the egress node to this resource.
        '''
        self.port_override = port_override if port_override is not None else 0
        '''
         The local port used by clients to connect to this resource. It is automatically generated if not provided on create and may be re-generated on update by specifying a value of -1.
        '''
        self.proxy_cluster_id = proxy_cluster_id if proxy_cluster_id is not None else ''
        '''
         ID of the proxy cluster for this resource, if any.
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         DNS subdomain through which this resource may be accessed on clients.  (e.g. "app-prod1" allows the resource to be accessed at "app-prod1.your-org-name.sdm-proxy-domain"). Only applicable to HTTP-based resources or resources using virtual networking mode.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.tls_required = tls_required if tls_required is not None else False
        '''
         If set, TLS must be used to connect to this resource.
        '''
        self.username = username if username is not None else ''
        '''
         The username to authenticate with.
        '''

    def __repr__(self):
        return '<sdm.AMQP ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'password: ' + repr(self.password) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'proxy_cluster_id: ' + repr(self.proxy_cluster_id) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'tls_required: ' + repr(self.tls_required) + ' ' +\
            'username: ' + repr(self.username) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'egress_filter': self.egress_filter,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'name': self.name,
            'password': self.password,
            'port': self.port,
            'port_override': self.port_override,
            'proxy_cluster_id': self.proxy_cluster_id,
            'secret_store_id': self.secret_store_id,
            'subdomain': self.subdomain,
            'tags': self.tags,
            'tls_required': self.tls_required,
            'username': self.username,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            egress_filter=d.get('egress_filter'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            name=d.get('name'),
            password=d.get('password'),
            port=d.get('port'),
            port_override=d.get('port_override'),
            proxy_cluster_id=d.get('proxy_cluster_id'),
            secret_store_id=d.get('secret_store_id'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
            tls_required=d.get('tls_required'),
            username=d.get('username'),
        )


class AWS:
    __slots__ = [
        'access_key',
        'bind_interface',
        'egress_filter',
        'healthcheck_region',
        'healthy',
        'id',
        'name',
        'port_override',
        'proxy_cluster_id',
        'role_arn',
        'role_external_id',
        'secret_access_key',
        'secret_store_id',
        'subdomain',
        'tags',
    ]

    def __init__(
        self,
        access_key=None,
        bind_interface=None,
        egress_filter=None,
        healthcheck_region=None,
        healthy=None,
        id=None,
        name=None,
        port_override=None,
        proxy_cluster_id=None,
        role_arn=None,
        role_external_id=None,
        secret_access_key=None,
        secret_store_id=None,
        subdomain=None,
        tags=None,
    ):
        self.access_key = access_key if access_key is not None else ''
        '''
         The Access Key ID to use to authenticate.
        '''
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided and may also be set to one of the ResourceIPAllocationMode constants to select between VNM, loopback, or default allocation.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthcheck_region = healthcheck_region if healthcheck_region is not None else ''
        '''
         The AWS region healthcheck requests should attempt to connect to.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.port_override = port_override if port_override is not None else 0
        '''
         The local port used by clients to connect to this resource. It is automatically generated if not provided on create and may be re-generated on update by specifying a value of -1.
        '''
        self.proxy_cluster_id = proxy_cluster_id if proxy_cluster_id is not None else ''
        '''
         ID of the proxy cluster for this resource, if any.
        '''
        self.role_arn = role_arn if role_arn is not None else ''
        '''
         The role to assume after logging in.
        '''
        self.role_external_id = role_external_id if role_external_id is not None else ''
        '''
         The external ID to associate with assume role requests. Does nothing if a role ARN is not provided.
        '''
        self.secret_access_key = secret_access_key if secret_access_key is not None else ''
        '''
         The Secret Access Key to use to authenticate.
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         DNS subdomain through which this resource may be accessed on clients.  (e.g. "app-prod1" allows the resource to be accessed at "app-prod1.your-org-name.sdm-proxy-domain"). Only applicable to HTTP-based resources or resources using virtual networking mode.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''

    def __repr__(self):
        return '<sdm.AWS ' + \
            'access_key: ' + repr(self.access_key) + ' ' +\
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthcheck_region: ' + repr(self.healthcheck_region) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'proxy_cluster_id: ' + repr(self.proxy_cluster_id) + ' ' +\
            'role_arn: ' + repr(self.role_arn) + ' ' +\
            'role_external_id: ' + repr(self.role_external_id) + ' ' +\
            'secret_access_key: ' + repr(self.secret_access_key) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'access_key': self.access_key,
            'bind_interface': self.bind_interface,
            'egress_filter': self.egress_filter,
            'healthcheck_region': self.healthcheck_region,
            'healthy': self.healthy,
            'id': self.id,
            'name': self.name,
            'port_override': self.port_override,
            'proxy_cluster_id': self.proxy_cluster_id,
            'role_arn': self.role_arn,
            'role_external_id': self.role_external_id,
            'secret_access_key': self.secret_access_key,
            'secret_store_id': self.secret_store_id,
            'subdomain': self.subdomain,
            'tags': self.tags,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            access_key=d.get('access_key'),
            bind_interface=d.get('bind_interface'),
            egress_filter=d.get('egress_filter'),
            healthcheck_region=d.get('healthcheck_region'),
            healthy=d.get('healthy'),
            id=d.get('id'),
            name=d.get('name'),
            port_override=d.get('port_override'),
            proxy_cluster_id=d.get('proxy_cluster_id'),
            role_arn=d.get('role_arn'),
            role_external_id=d.get('role_external_id'),
            secret_access_key=d.get('secret_access_key'),
            secret_store_id=d.get('secret_store_id'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
        )


class AWSCertX509Store:
    __slots__ = [
        'caarn',
        'certificatetemplatearn',
        'id',
        'issuedcertttlminutes',
        'name',
        'region',
        'signingalgo',
        'tags',
    ]

    def __init__(
        self,
        caarn=None,
        certificatetemplatearn=None,
        id=None,
        issuedcertttlminutes=None,
        name=None,
        region=None,
        signingalgo=None,
        tags=None,
    ):
        self.caarn = caarn if caarn is not None else ''
        '''
         The ARN of the CA in AWS Private CA
        '''
        self.certificatetemplatearn = certificatetemplatearn if certificatetemplatearn is not None else ''
        '''
         The ARN of the AWS certificate template for requested certificates. Must allow SAN, key usage, and ext key usage passthrough from CSR
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the SecretStore.
        '''
        self.issuedcertttlminutes = issuedcertttlminutes if issuedcertttlminutes is not None else 0
        '''
         The lifetime of certificates issued by this CA represented in minutes.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the SecretStore.
        '''
        self.region = region if region is not None else ''
        '''
         The AWS region to target e.g. us-east-1
        '''
        self.signingalgo = signingalgo if signingalgo is not None else ''
        '''
         The specified signing algorithm family (RSA or ECDSA) must match the algorithm family of the CA's secret key. e.g. SHA256WITHRSA
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''

    def __repr__(self):
        return '<sdm.AWSCertX509Store ' + \
            'caarn: ' + repr(self.caarn) + ' ' +\
            'certificatetemplatearn: ' + repr(self.certificatetemplatearn) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'issuedcertttlminutes: ' + repr(self.issuedcertttlminutes) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'region: ' + repr(self.region) + ' ' +\
            'signingalgo: ' + repr(self.signingalgo) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'caarn': self.caarn,
            'certificatetemplatearn': self.certificatetemplatearn,
            'id': self.id,
            'issuedcertttlminutes': self.issuedcertttlminutes,
            'name': self.name,
            'region': self.region,
            'signingalgo': self.signingalgo,
            'tags': self.tags,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            caarn=d.get('caarn'),
            certificatetemplatearn=d.get('certificatetemplatearn'),
            id=d.get('id'),
            issuedcertttlminutes=d.get('issuedcertttlminutes'),
            name=d.get('name'),
            region=d.get('region'),
            signingalgo=d.get('signingalgo'),
            tags=d.get('tags'),
        )


class AWSConsole:
    __slots__ = [
        'bind_interface',
        'egress_filter',
        'enable_env_variables',
        'healthy',
        'id',
        'identity_alias_healthcheck_username',
        'identity_set_id',
        'name',
        'port_override',
        'proxy_cluster_id',
        'region',
        'role_arn',
        'role_external_id',
        'secret_store_id',
        'session_expiry',
        'subdomain',
        'tags',
    ]

    def __init__(
        self,
        bind_interface=None,
        egress_filter=None,
        enable_env_variables=None,
        healthy=None,
        id=None,
        identity_alias_healthcheck_username=None,
        identity_set_id=None,
        name=None,
        port_override=None,
        proxy_cluster_id=None,
        region=None,
        role_arn=None,
        role_external_id=None,
        secret_store_id=None,
        session_expiry=None,
        subdomain=None,
        tags=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided and may also be set to one of the ResourceIPAllocationMode constants to select between VNM, loopback, or default allocation.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.enable_env_variables = enable_env_variables if enable_env_variables is not None else False
        '''
         If true, prefer environment variables to authenticate connection even if EC2 roles are configured.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.identity_alias_healthcheck_username = identity_alias_healthcheck_username if identity_alias_healthcheck_username is not None else ''
        '''
         The username to use for healthchecks, when clients otherwise connect with their own identity alias username.
        '''
        self.identity_set_id = identity_set_id if identity_set_id is not None else ''
        '''
         The ID of the identity set to use for identity connections.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.port_override = port_override if port_override is not None else 0
        '''
         The local port used by clients to connect to this resource. It is automatically generated if not provided on create and may be re-generated on update by specifying a value of -1.
        '''
        self.proxy_cluster_id = proxy_cluster_id if proxy_cluster_id is not None else ''
        '''
         ID of the proxy cluster for this resource, if any.
        '''
        self.region = region if region is not None else ''
        '''
         The AWS region to connect to.
        '''
        self.role_arn = role_arn if role_arn is not None else ''
        '''
         The role to assume after logging in.
        '''
        self.role_external_id = role_external_id if role_external_id is not None else ''
        '''
         The external ID to associate with assume role requests. Does nothing if a role ARN is not provided.
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.session_expiry = session_expiry if session_expiry is not None else 0
        '''
         The length of time in seconds AWS console sessions will live before needing to reauthenticate.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         Subdomain is the local DNS address.  (e.g. app-prod1 turns into app-prod1.your-org-name.sdm.network)
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''

    def __repr__(self):
        return '<sdm.AWSConsole ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'enable_env_variables: ' + repr(self.enable_env_variables) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'identity_alias_healthcheck_username: ' + repr(self.identity_alias_healthcheck_username) + ' ' +\
            'identity_set_id: ' + repr(self.identity_set_id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'proxy_cluster_id: ' + repr(self.proxy_cluster_id) + ' ' +\
            'region: ' + repr(self.region) + ' ' +\
            'role_arn: ' + repr(self.role_arn) + ' ' +\
            'role_external_id: ' + repr(self.role_external_id) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'session_expiry: ' + repr(self.session_expiry) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'egress_filter': self.egress_filter,
            'enable_env_variables': self.enable_env_variables,
            'healthy': self.healthy,
            'id': self.id,
            'identity_alias_healthcheck_username':
            self.identity_alias_healthcheck_username,
            'identity_set_id': self.identity_set_id,
            'name': self.name,
            'port_override': self.port_override,
            'proxy_cluster_id': self.proxy_cluster_id,
            'region': self.region,
            'role_arn': self.role_arn,
            'role_external_id': self.role_external_id,
            'secret_store_id': self.secret_store_id,
            'session_expiry': self.session_expiry,
            'subdomain': self.subdomain,
            'tags': self.tags,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            egress_filter=d.get('egress_filter'),
            enable_env_variables=d.get('enable_env_variables'),
            healthy=d.get('healthy'),
            id=d.get('id'),
            identity_alias_healthcheck_username=d.get(
                'identity_alias_healthcheck_username'),
            identity_set_id=d.get('identity_set_id'),
            name=d.get('name'),
            port_override=d.get('port_override'),
            proxy_cluster_id=d.get('proxy_cluster_id'),
            region=d.get('region'),
            role_arn=d.get('role_arn'),
            role_external_id=d.get('role_external_id'),
            secret_store_id=d.get('secret_store_id'),
            session_expiry=d.get('session_expiry'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
        )


class AWSConsoleStaticKeyPair:
    __slots__ = [
        'access_key',
        'bind_interface',
        'egress_filter',
        'healthy',
        'id',
        'identity_alias_healthcheck_username',
        'identity_set_id',
        'name',
        'port_override',
        'proxy_cluster_id',
        'region',
        'role_arn',
        'role_external_id',
        'secret_access_key',
        'secret_store_id',
        'session_expiry',
        'subdomain',
        'tags',
    ]

    def __init__(
        self,
        access_key=None,
        bind_interface=None,
        egress_filter=None,
        healthy=None,
        id=None,
        identity_alias_healthcheck_username=None,
        identity_set_id=None,
        name=None,
        port_override=None,
        proxy_cluster_id=None,
        region=None,
        role_arn=None,
        role_external_id=None,
        secret_access_key=None,
        secret_store_id=None,
        session_expiry=None,
        subdomain=None,
        tags=None,
    ):
        self.access_key = access_key if access_key is not None else ''
        '''
         The Access Key ID to authenticate with.
        '''
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided and may also be set to one of the ResourceIPAllocationMode constants to select between VNM, loopback, or default allocation.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.identity_alias_healthcheck_username = identity_alias_healthcheck_username if identity_alias_healthcheck_username is not None else ''
        '''
         The username to use for healthchecks, when clients otherwise connect with their own identity alias username.
        '''
        self.identity_set_id = identity_set_id if identity_set_id is not None else ''
        '''
         The ID of the identity set to use for identity connections.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.port_override = port_override if port_override is not None else 0
        '''
         The local port used by clients to connect to this resource. It is automatically generated if not provided on create and may be re-generated on update by specifying a value of -1.
        '''
        self.proxy_cluster_id = proxy_cluster_id if proxy_cluster_id is not None else ''
        '''
         ID of the proxy cluster for this resource, if any.
        '''
        self.region = region if region is not None else ''
        '''
         The AWS region to connect to.
        '''
        self.role_arn = role_arn if role_arn is not None else ''
        '''
         The role to assume after logging in.
        '''
        self.role_external_id = role_external_id if role_external_id is not None else ''
        '''
         The external ID to associate with assume role requests. Does nothing if a role ARN is not provided.
        '''
        self.secret_access_key = secret_access_key if secret_access_key is not None else ''
        '''
         The Secret Access Key to authenticate with.
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.session_expiry = session_expiry if session_expiry is not None else 0
        '''
         The length of time in seconds AWS console sessions will live before needing to reauthenticate.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         Subdomain is the local DNS address.  (e.g. app-prod1 turns into app-prod1.your-org-name.sdm.network)
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''

    def __repr__(self):
        return '<sdm.AWSConsoleStaticKeyPair ' + \
            'access_key: ' + repr(self.access_key) + ' ' +\
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'identity_alias_healthcheck_username: ' + repr(self.identity_alias_healthcheck_username) + ' ' +\
            'identity_set_id: ' + repr(self.identity_set_id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'proxy_cluster_id: ' + repr(self.proxy_cluster_id) + ' ' +\
            'region: ' + repr(self.region) + ' ' +\
            'role_arn: ' + repr(self.role_arn) + ' ' +\
            'role_external_id: ' + repr(self.role_external_id) + ' ' +\
            'secret_access_key: ' + repr(self.secret_access_key) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'session_expiry: ' + repr(self.session_expiry) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'access_key': self.access_key,
            'bind_interface': self.bind_interface,
            'egress_filter': self.egress_filter,
            'healthy': self.healthy,
            'id': self.id,
            'identity_alias_healthcheck_username':
            self.identity_alias_healthcheck_username,
            'identity_set_id': self.identity_set_id,
            'name': self.name,
            'port_override': self.port_override,
            'proxy_cluster_id': self.proxy_cluster_id,
            'region': self.region,
            'role_arn': self.role_arn,
            'role_external_id': self.role_external_id,
            'secret_access_key': self.secret_access_key,
            'secret_store_id': self.secret_store_id,
            'session_expiry': self.session_expiry,
            'subdomain': self.subdomain,
            'tags': self.tags,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            access_key=d.get('access_key'),
            bind_interface=d.get('bind_interface'),
            egress_filter=d.get('egress_filter'),
            healthy=d.get('healthy'),
            id=d.get('id'),
            identity_alias_healthcheck_username=d.get(
                'identity_alias_healthcheck_username'),
            identity_set_id=d.get('identity_set_id'),
            name=d.get('name'),
            port_override=d.get('port_override'),
            proxy_cluster_id=d.get('proxy_cluster_id'),
            region=d.get('region'),
            role_arn=d.get('role_arn'),
            role_external_id=d.get('role_external_id'),
            secret_access_key=d.get('secret_access_key'),
            secret_store_id=d.get('secret_store_id'),
            session_expiry=d.get('session_expiry'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
        )


class AWSInstanceProfile:
    __slots__ = [
        'bind_interface',
        'egress_filter',
        'enable_env_variables',
        'healthy',
        'id',
        'name',
        'port_override',
        'proxy_cluster_id',
        'region',
        'role_arn',
        'role_external_id',
        'secret_store_id',
        'subdomain',
        'tags',
    ]

    def __init__(
        self,
        bind_interface=None,
        egress_filter=None,
        enable_env_variables=None,
        healthy=None,
        id=None,
        name=None,
        port_override=None,
        proxy_cluster_id=None,
        region=None,
        role_arn=None,
        role_external_id=None,
        secret_store_id=None,
        subdomain=None,
        tags=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided and may also be set to one of the ResourceIPAllocationMode constants to select between VNM, loopback, or default allocation.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.enable_env_variables = enable_env_variables if enable_env_variables is not None else False
        '''
         If true, prefer environment variables to authenticate connection even if EC2 roles are configured.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.port_override = port_override if port_override is not None else 0
        '''
         The local port used by clients to connect to this resource. It is automatically generated if not provided on create and may be re-generated on update by specifying a value of -1.
        '''
        self.proxy_cluster_id = proxy_cluster_id if proxy_cluster_id is not None else ''
        '''
         ID of the proxy cluster for this resource, if any.
        '''
        self.region = region if region is not None else ''
        '''
         The AWS region to connect to.
        '''
        self.role_arn = role_arn if role_arn is not None else ''
        '''
         The role to assume after logging in.
        '''
        self.role_external_id = role_external_id if role_external_id is not None else ''
        '''
         The external ID to associate with assume role requests. Does nothing if a role ARN is not provided.
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         DNS subdomain through which this resource may be accessed on clients.  (e.g. "app-prod1" allows the resource to be accessed at "app-prod1.your-org-name.sdm-proxy-domain"). Only applicable to HTTP-based resources or resources using virtual networking mode.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''

    def __repr__(self):
        return '<sdm.AWSInstanceProfile ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'enable_env_variables: ' + repr(self.enable_env_variables) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'proxy_cluster_id: ' + repr(self.proxy_cluster_id) + ' ' +\
            'region: ' + repr(self.region) + ' ' +\
            'role_arn: ' + repr(self.role_arn) + ' ' +\
            'role_external_id: ' + repr(self.role_external_id) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'egress_filter': self.egress_filter,
            'enable_env_variables': self.enable_env_variables,
            'healthy': self.healthy,
            'id': self.id,
            'name': self.name,
            'port_override': self.port_override,
            'proxy_cluster_id': self.proxy_cluster_id,
            'region': self.region,
            'role_arn': self.role_arn,
            'role_external_id': self.role_external_id,
            'secret_store_id': self.secret_store_id,
            'subdomain': self.subdomain,
            'tags': self.tags,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            egress_filter=d.get('egress_filter'),
            enable_env_variables=d.get('enable_env_variables'),
            healthy=d.get('healthy'),
            id=d.get('id'),
            name=d.get('name'),
            port_override=d.get('port_override'),
            proxy_cluster_id=d.get('proxy_cluster_id'),
            region=d.get('region'),
            role_arn=d.get('role_arn'),
            role_external_id=d.get('role_external_id'),
            secret_store_id=d.get('secret_store_id'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
        )


class AWSStore:
    __slots__ = [
        'id',
        'name',
        'region',
        'role_arn',
        'role_external_id',
        'tags',
    ]

    def __init__(
        self,
        id=None,
        name=None,
        region=None,
        role_arn=None,
        role_external_id=None,
        tags=None,
    ):
        self.id = id if id is not None else ''
        '''
         Unique identifier of the SecretStore.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the SecretStore.
        '''
        self.region = region if region is not None else ''
        '''
         The AWS region to target e.g. us-east-1
        '''
        self.role_arn = role_arn if role_arn is not None else ''
        '''
         The role to assume after logging in.
        '''
        self.role_external_id = role_external_id if role_external_id is not None else ''
        '''
         The external ID to associate with assume role requests. Does nothing if a role ARN is not provided.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''

    def __repr__(self):
        return '<sdm.AWSStore ' + \
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'region: ' + repr(self.region) + ' ' +\
            'role_arn: ' + repr(self.role_arn) + ' ' +\
            'role_external_id: ' + repr(self.role_external_id) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'id': self.id,
            'name': self.name,
            'region': self.region,
            'role_arn': self.role_arn,
            'role_external_id': self.role_external_id,
            'tags': self.tags,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            id=d.get('id'),
            name=d.get('name'),
            region=d.get('region'),
            role_arn=d.get('role_arn'),
            role_external_id=d.get('role_external_id'),
            tags=d.get('tags'),
        )


class AccessRequest:
    '''
         AccessRequests are requests for access to a resource that may match a Workflow.
    '''
    __slots__ = [
        'account_id',
        'duration',
        'grant_id',
        'id',
        'reason',
        'requestedduration',
        'resource_id',
        'resultduration',
        'start_from',
        'status',
        'status_at',
        'valid_until',
        'workflow_id',
    ]

    def __init__(
        self,
        account_id=None,
        duration=None,
        grant_id=None,
        id=None,
        reason=None,
        requestedduration=None,
        resource_id=None,
        resultduration=None,
        start_from=None,
        status=None,
        status_at=None,
        valid_until=None,
        workflow_id=None,
    ):
        self.account_id = account_id if account_id is not None else ''
        '''
         The account that initiated the request.
        '''
        self.duration = duration if duration is not None else 0
        '''
         Duration of the access request.
         Deprecated: use requested/result duration instead
        '''
        self.grant_id = grant_id if grant_id is not None else ''
        '''
         The account grant created, if it exists.
        '''
        self.id = id if id is not None else ''
        '''
         The access request id.
        '''
        self.reason = reason if reason is not None else ''
        '''
         The reason the access was requested.
        '''
        self.requestedduration = requestedduration if requestedduration is not None else None
        '''
         The duration that access was requested for, if any.
        '''
        self.resource_id = resource_id if resource_id is not None else ''
        '''
         The resource id.
        '''
        self.resultduration = resultduration if resultduration is not None else None
        '''
         The duration that results from an approved request.
        '''
        self.start_from = start_from if start_from is not None else None
        '''
         The timestamp when the requested access will be granted.
         If this field is not specified it will default to the current time.
        '''
        self.status = status if status is not None else ''
        '''
         The status of the access request.
        '''
        self.status_at = status_at if status_at is not None else None
        '''
         The timestamp when the status changed.
        '''
        self.valid_until = valid_until if valid_until is not None else None
        '''
         The timestamp when the requested access will expire.
        '''
        self.workflow_id = workflow_id if workflow_id is not None else ''
        '''
         The workflow the request bound to.
        '''

    def __repr__(self):
        return '<sdm.AccessRequest ' + \
            'account_id: ' + repr(self.account_id) + ' ' +\
            'duration: ' + repr(self.duration) + ' ' +\
            'grant_id: ' + repr(self.grant_id) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'reason: ' + repr(self.reason) + ' ' +\
            'requestedduration: ' + repr(self.requestedduration) + ' ' +\
            'resource_id: ' + repr(self.resource_id) + ' ' +\
            'resultduration: ' + repr(self.resultduration) + ' ' +\
            'start_from: ' + repr(self.start_from) + ' ' +\
            'status: ' + repr(self.status) + ' ' +\
            'status_at: ' + repr(self.status_at) + ' ' +\
            'valid_until: ' + repr(self.valid_until) + ' ' +\
            'workflow_id: ' + repr(self.workflow_id) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'account_id': self.account_id,
            'duration': self.duration,
            'grant_id': self.grant_id,
            'id': self.id,
            'reason': self.reason,
            'requestedduration': self.requestedduration,
            'resource_id': self.resource_id,
            'resultduration': self.resultduration,
            'start_from': self.start_from,
            'status': self.status,
            'status_at': self.status_at,
            'valid_until': self.valid_until,
            'workflow_id': self.workflow_id,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            account_id=d.get('account_id'),
            duration=d.get('duration'),
            grant_id=d.get('grant_id'),
            id=d.get('id'),
            reason=d.get('reason'),
            requestedduration=d.get('requestedduration'),
            resource_id=d.get('resource_id'),
            resultduration=d.get('resultduration'),
            start_from=d.get('start_from'),
            status=d.get('status'),
            status_at=d.get('status_at'),
            valid_until=d.get('valid_until'),
            workflow_id=d.get('workflow_id'),
        )


class AccessRequestConfig:
    '''
         AccessRequestConfig holds the information required to request access to a resource
    '''
    __slots__ = [
        'duration',
        'reason',
        'resource_id',
        'start_from',
    ]

    def __init__(
        self,
        duration=None,
        reason=None,
        resource_id=None,
        start_from=None,
    ):
        self.duration = duration if duration is not None else ''
        '''
         The time access should end, defaults to the next occurance of 5 pm
        '''
        self.reason = reason if reason is not None else ''
        '''
         The reason for access
        '''
        self.resource_id = resource_id if resource_id is not None else ''
        '''
         The resource for which access is being requested
        '''
        self.start_from = start_from if start_from is not None else None
        '''
         The time access should start, defaults to now
        '''

    def __repr__(self):
        return '<sdm.AccessRequestConfig ' + \
            'duration: ' + repr(self.duration) + ' ' +\
            'reason: ' + repr(self.reason) + ' ' +\
            'resource_id: ' + repr(self.resource_id) + ' ' +\
            'start_from: ' + repr(self.start_from) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'duration': self.duration,
            'reason': self.reason,
            'resource_id': self.resource_id,
            'start_from': self.start_from,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            duration=d.get('duration'),
            reason=d.get('reason'),
            resource_id=d.get('resource_id'),
            start_from=d.get('start_from'),
        )


class AccessRequestEvent:
    '''
         AccessRequestEvents hold information about events related to an access
     request such as creation, approval and denial.
    '''
    __slots__ = [
        'actor_id',
        'id',
        'metadata',
        'request_id',
        'type',
    ]

    def __init__(
        self,
        actor_id=None,
        id=None,
        metadata=None,
        request_id=None,
        type=None,
    ):
        self.actor_id = actor_id if actor_id is not None else ''
        '''
         The account responsible for the event.
        '''
        self.id = id if id is not None else ''
        '''
         The access request event id.
        '''
        self.metadata = metadata if metadata is not None else ''
        '''
         The metadata about the event
        '''
        self.request_id = request_id if request_id is not None else ''
        '''
         The request that the event is bound to.
        '''
        self.type = type if type is not None else ''
        '''
         The type of event.
        '''

    def __repr__(self):
        return '<sdm.AccessRequestEvent ' + \
            'actor_id: ' + repr(self.actor_id) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'metadata: ' + repr(self.metadata) + ' ' +\
            'request_id: ' + repr(self.request_id) + ' ' +\
            'type: ' + repr(self.type) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'actor_id': self.actor_id,
            'id': self.id,
            'metadata': self.metadata,
            'request_id': self.request_id,
            'type': self.type,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            actor_id=d.get('actor_id'),
            id=d.get('id'),
            metadata=d.get('metadata'),
            request_id=d.get('request_id'),
            type=d.get('type'),
        )


class AccessRequestEventHistory:
    '''
         AccessRequestEventHistory records the state of a AccessRequest at a given point in time,
     where every change (create, update and delete) to a AccessRequest produces an
     AccessRequestEventHistory record.
    '''
    __slots__ = [
        'access_request_event',
        'activity_id',
        'deleted_at',
        'timestamp',
    ]

    def __init__(
        self,
        access_request_event=None,
        activity_id=None,
        deleted_at=None,
        timestamp=None,
    ):
        self.access_request_event = access_request_event if access_request_event is not None else None
        '''
         The complete AccessRequestEvent state at this time.
        '''
        self.activity_id = activity_id if activity_id is not None else ''
        '''
         The unique identifier of the Activity that produced this change to the AccessRequest.
         May be empty for some system-initiated updates.
        '''
        self.deleted_at = deleted_at if deleted_at is not None else None
        '''
         If this Workflow was deleted, the time it was deleted.
        '''
        self.timestamp = timestamp if timestamp is not None else None
        '''
         The time at which the AccessRequest state was recorded.
        '''

    def __repr__(self):
        return '<sdm.AccessRequestEventHistory ' + \
            'access_request_event: ' + repr(self.access_request_event) + ' ' +\
            'activity_id: ' + repr(self.activity_id) + ' ' +\
            'deleted_at: ' + repr(self.deleted_at) + ' ' +\
            'timestamp: ' + repr(self.timestamp) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'access_request_event': self.access_request_event,
            'activity_id': self.activity_id,
            'deleted_at': self.deleted_at,
            'timestamp': self.timestamp,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            access_request_event=d.get('access_request_event'),
            activity_id=d.get('activity_id'),
            deleted_at=d.get('deleted_at'),
            timestamp=d.get('timestamp'),
        )


class AccessRequestHistory:
    '''
         AccessRequestHistory records the state of a AccessRequest at a given point in time,
     where every change (create, update and delete) to a AccessRequest produces an
     AccessRequestHistory record.
    '''
    __slots__ = [
        'access_request',
        'activity_id',
        'deleted_at',
        'timestamp',
    ]

    def __init__(
        self,
        access_request=None,
        activity_id=None,
        deleted_at=None,
        timestamp=None,
    ):
        self.access_request = access_request if access_request is not None else None
        '''
         The complete AccessRequest state at this time.
        '''
        self.activity_id = activity_id if activity_id is not None else ''
        '''
         The unique identifier of the Activity that produced this change to the AccessRequest.
         May be empty for some system-initiated updates.
        '''
        self.deleted_at = deleted_at if deleted_at is not None else None
        '''
         If this Workflow was deleted, the time it was deleted.
        '''
        self.timestamp = timestamp if timestamp is not None else None
        '''
         The time at which the AccessRequest state was recorded.
        '''

    def __repr__(self):
        return '<sdm.AccessRequestHistory ' + \
            'access_request: ' + repr(self.access_request) + ' ' +\
            'activity_id: ' + repr(self.activity_id) + ' ' +\
            'deleted_at: ' + repr(self.deleted_at) + ' ' +\
            'timestamp: ' + repr(self.timestamp) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'access_request': self.access_request,
            'activity_id': self.activity_id,
            'deleted_at': self.deleted_at,
            'timestamp': self.timestamp,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            access_request=d.get('access_request'),
            activity_id=d.get('activity_id'),
            deleted_at=d.get('deleted_at'),
            timestamp=d.get('timestamp'),
        )


class AccessRequestListRequest:
    '''
         AccessRequestListRequest specifies criteria for retrieving a list of
     AccessRequest records
    '''
    __slots__ = [
        'filter',
    ]

    def __init__(
        self,
        filter=None,
    ):
        self.filter = filter if filter is not None else ''
        '''
         A human-readable filter query string.
        '''

    def __repr__(self):
        return '<sdm.AccessRequestListRequest ' + \
            'filter: ' + repr(self.filter) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'filter': self.filter,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(filter=d.get('filter'), )


class AccessRequestListResponse:
    '''
         AccessRequestListResponse returns a list of access requests records that meet
     the criteria of a AccessRequestListRequest.
    '''
    __slots__ = [
        'rate_limit',
    ]

    def __init__(
        self,
        rate_limit=None,
    ):
        self.rate_limit = rate_limit if rate_limit is not None else None
        '''
         Rate limit information.
        '''

    def __repr__(self):
        return '<sdm.AccessRequestListResponse ' + \
            'rate_limit: ' + repr(self.rate_limit) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'rate_limit': self.rate_limit,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(rate_limit=d.get('rate_limit'), )


class AccountAttachment:
    '''
         AccountAttachments assign an account to a role.
    '''
    __slots__ = [
        'account_id',
        'id',
        'role_id',
    ]

    def __init__(
        self,
        account_id=None,
        id=None,
        role_id=None,
    ):
        self.account_id = account_id if account_id is not None else ''
        '''
         The id of the account of this AccountAttachment.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the AccountAttachment.
        '''
        self.role_id = role_id if role_id is not None else ''
        '''
         The id of the attached role of this AccountAttachment.
        '''

    def __repr__(self):
        return '<sdm.AccountAttachment ' + \
            'account_id: ' + repr(self.account_id) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'role_id: ' + repr(self.role_id) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'account_id': self.account_id,
            'id': self.id,
            'role_id': self.role_id,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            account_id=d.get('account_id'),
            id=d.get('id'),
            role_id=d.get('role_id'),
        )


class AccountAttachmentCreateResponse:
    '''
         AccountAttachmentCreateResponse reports how the AccountAttachments were created in the system.
    '''
    __slots__ = [
        'account_attachment',
        'meta',
        'rate_limit',
    ]

    def __init__(
        self,
        account_attachment=None,
        meta=None,
        rate_limit=None,
    ):
        self.account_attachment = account_attachment if account_attachment is not None else None
        '''
         The created AccountAttachment.
        '''
        self.meta = meta if meta is not None else None
        '''
         Reserved for future use.
        '''
        self.rate_limit = rate_limit if rate_limit is not None else None
        '''
         Rate limit information.
        '''

    def __repr__(self):
        return '<sdm.AccountAttachmentCreateResponse ' + \
            'account_attachment: ' + repr(self.account_attachment) + ' ' +\
            'meta: ' + repr(self.meta) + ' ' +\
            'rate_limit: ' + repr(self.rate_limit) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'account_attachment': self.account_attachment,
            'meta': self.meta,
            'rate_limit': self.rate_limit,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            account_attachment=d.get('account_attachment'),
            meta=d.get('meta'),
            rate_limit=d.get('rate_limit'),
        )


class AccountAttachmentDeleteResponse:
    '''
         AccountAttachmentDeleteResponse returns information about a AccountAttachment that was deleted.
    '''
    __slots__ = [
        'meta',
        'rate_limit',
    ]

    def __init__(
        self,
        meta=None,
        rate_limit=None,
    ):
        self.meta = meta if meta is not None else None
        '''
         Reserved for future use.
        '''
        self.rate_limit = rate_limit if rate_limit is not None else None
        '''
         Rate limit information.
        '''

    def __repr__(self):
        return '<sdm.AccountAttachmentDeleteResponse ' + \
            'meta: ' + repr(self.meta) + ' ' +\
            'rate_limit: ' + repr(self.rate_limit) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'meta': self.meta,
            'rate_limit': self.rate_limit,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            meta=d.get('meta'),
            rate_limit=d.get('rate_limit'),
        )


class AccountAttachmentGetResponse:
    '''
         AccountAttachmentGetResponse returns a requested AccountAttachment.
    '''
    __slots__ = [
        'account_attachment',
        'meta',
        'rate_limit',
    ]

    def __init__(
        self,
        account_attachment=None,
        meta=None,
        rate_limit=None,
    ):
        self.account_attachment = account_attachment if account_attachment is not None else None
        '''
         The requested AccountAttachment.
        '''
        self.meta = meta if meta is not None else None
        '''
         Reserved for future use.
        '''
        self.rate_limit = rate_limit if rate_limit is not None else None
        '''
         Rate limit information.
        '''

    def __repr__(self):
        return '<sdm.AccountAttachmentGetResponse ' + \
            'account_attachment: ' + repr(self.account_attachment) + ' ' +\
            'meta: ' + repr(self.meta) + ' ' +\
            'rate_limit: ' + repr(self.rate_limit) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'account_attachment': self.account_attachment,
            'meta': self.meta,
            'rate_limit': self.rate_limit,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            account_attachment=d.get('account_attachment'),
            meta=d.get('meta'),
            rate_limit=d.get('rate_limit'),
        )


class AccountAttachmentHistory:
    '''
         AccountAttachmentHistory records the state of an AccountAttachment at a given point in time,
     where every change (create or delete) to an AccountAttachment produces an
     AccountAttachmentHistory record.
    '''
    __slots__ = [
        'account_attachment',
        'activity_id',
        'deleted_at',
        'timestamp',
    ]

    def __init__(
        self,
        account_attachment=None,
        activity_id=None,
        deleted_at=None,
        timestamp=None,
    ):
        self.account_attachment = account_attachment if account_attachment is not None else None
        '''
         The complete AccountAttachment state at this time.
        '''
        self.activity_id = activity_id if activity_id is not None else ''
        '''
         The unique identifier of the Activity that produced this change to the AccountAttachment.
         May be empty for some system-initiated updates.
        '''
        self.deleted_at = deleted_at if deleted_at is not None else None
        '''
         If this AccountAttachment was deleted, the time it was deleted.
        '''
        self.timestamp = timestamp if timestamp is not None else None
        '''
         The time at which the AccountAttachment state was recorded.
        '''

    def __repr__(self):
        return '<sdm.AccountAttachmentHistory ' + \
            'account_attachment: ' + repr(self.account_attachment) + ' ' +\
            'activity_id: ' + repr(self.activity_id) + ' ' +\
            'deleted_at: ' + repr(self.deleted_at) + ' ' +\
            'timestamp: ' + repr(self.timestamp) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'account_attachment': self.account_attachment,
            'activity_id': self.activity_id,
            'deleted_at': self.deleted_at,
            'timestamp': self.timestamp,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            account_attachment=d.get('account_attachment'),
            activity_id=d.get('activity_id'),
            deleted_at=d.get('deleted_at'),
            timestamp=d.get('timestamp'),
        )


class AccountCreateResponse:
    '''
         AccountCreateResponse reports how the Accounts were created in the system.
    '''
    __slots__ = [
        'access_key',
        'account',
        'meta',
        'rate_limit',
        'secret_key',
        'token',
    ]

    def __init__(
        self,
        access_key=None,
        account=None,
        meta=None,
        rate_limit=None,
        secret_key=None,
        token=None,
    ):
        self.access_key = access_key if access_key is not None else ''
        '''
         ID part of the API key.
        '''
        self.account = account if account is not None else None
        '''
         The created Account.
        '''
        self.meta = meta if meta is not None else None
        '''
         Reserved for future use.
        '''
        self.rate_limit = rate_limit if rate_limit is not None else None
        '''
         Rate limit information.
        '''
        self.secret_key = secret_key if secret_key is not None else ''
        '''
         Secret part of the API key.
        '''
        self.token = token if token is not None else ''
        '''
         The auth token generated for the Account. The Account will use this token to
         authenticate with the strongDM API.
        '''

    def __repr__(self):
        return '<sdm.AccountCreateResponse ' + \
            'access_key: ' + repr(self.access_key) + ' ' +\
            'account: ' + repr(self.account) + ' ' +\
            'meta: ' + repr(self.meta) + ' ' +\
            'rate_limit: ' + repr(self.rate_limit) + ' ' +\
            'secret_key: ' + repr(self.secret_key) + ' ' +\
            'token: ' + repr(self.token) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'access_key': self.access_key,
            'account': self.account,
            'meta': self.meta,
            'rate_limit': self.rate_limit,
            'secret_key': self.secret_key,
            'token': self.token,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            access_key=d.get('access_key'),
            account=d.get('account'),
            meta=d.get('meta'),
            rate_limit=d.get('rate_limit'),
            secret_key=d.get('secret_key'),
            token=d.get('token'),
        )


class AccountDeleteResponse:
    '''
         AccountDeleteResponse returns information about a Account that was deleted.
    '''
    __slots__ = [
        'meta',
        'rate_limit',
    ]

    def __init__(
        self,
        meta=None,
        rate_limit=None,
    ):
        self.meta = meta if meta is not None else None
        '''
         Reserved for future use.
        '''
        self.rate_limit = rate_limit if rate_limit is not None else None
        '''
         Rate limit information.
        '''

    def __repr__(self):
        return '<sdm.AccountDeleteResponse ' + \
            'meta: ' + repr(self.meta) + ' ' +\
            'rate_limit: ' + repr(self.rate_limit) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'meta': self.meta,
            'rate_limit': self.rate_limit,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            meta=d.get('meta'),
            rate_limit=d.get('rate_limit'),
        )


class AccountGetResponse:
    '''
         AccountGetResponse returns a requested Account.
    '''
    __slots__ = [
        'account',
        'meta',
        'rate_limit',
    ]

    def __init__(
        self,
        account=None,
        meta=None,
        rate_limit=None,
    ):
        self.account = account if account is not None else None
        '''
         The requested Account.
        '''
        self.meta = meta if meta is not None else None
        '''
         Reserved for future use.
        '''
        self.rate_limit = rate_limit if rate_limit is not None else None
        '''
         Rate limit information.
        '''

    def __repr__(self):
        return '<sdm.AccountGetResponse ' + \
            'account: ' + repr(self.account) + ' ' +\
            'meta: ' + repr(self.meta) + ' ' +\
            'rate_limit: ' + repr(self.rate_limit) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'account': self.account,
            'meta': self.meta,
            'rate_limit': self.rate_limit,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            account=d.get('account'),
            meta=d.get('meta'),
            rate_limit=d.get('rate_limit'),
        )


class AccountGrant:
    '''
         AccountGrants connect a resource directly to an account, giving the account the permission to connect to that resource.
    '''
    __slots__ = [
        'access_rule',
        'account_id',
        'id',
        'resource_id',
        'start_from',
        'valid_until',
    ]

    def __init__(
        self,
        access_rule=None,
        account_id=None,
        id=None,
        resource_id=None,
        start_from=None,
        valid_until=None,
    ):
        self.access_rule = access_rule if access_rule is not None else _porcelain_zero_value_access_rule(
        )
        '''
         The access rule associated with this AccountGrant.
        '''
        self.account_id = account_id if account_id is not None else ''
        '''
         The account ID of this AccountGrant.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the AccountGrant.
        '''
        self.resource_id = resource_id if resource_id is not None else ''
        '''
         The resource ID of this AccountGrant.
        '''
        self.start_from = start_from if start_from is not None else None
        '''
         The timestamp when the resource will be granted. When creating an AccountGrant, if this field is not specified, it will default to the current time.
        '''
        self.valid_until = valid_until if valid_until is not None else None
        '''
         The timestamp when the resource grant will expire.
        '''

    def __repr__(self):
        return '<sdm.AccountGrant ' + \
            'access_rule: ' + repr(self.access_rule) + ' ' +\
            'account_id: ' + repr(self.account_id) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'resource_id: ' + repr(self.resource_id) + ' ' +\
            'start_from: ' + repr(self.start_from) + ' ' +\
            'valid_until: ' + repr(self.valid_until) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'access_rule': self.access_rule,
            'account_id': self.account_id,
            'id': self.id,
            'resource_id': self.resource_id,
            'start_from': self.start_from,
            'valid_until': self.valid_until,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            access_rule=d.get('access_rule'),
            account_id=d.get('account_id'),
            id=d.get('id'),
            resource_id=d.get('resource_id'),
            start_from=d.get('start_from'),
            valid_until=d.get('valid_until'),
        )


class AccountGrantCreateResponse:
    '''
         AccountGrantCreateResponse reports how the AccountGrants were created in the system.
    '''
    __slots__ = [
        'account_grant',
        'meta',
        'rate_limit',
    ]

    def __init__(
        self,
        account_grant=None,
        meta=None,
        rate_limit=None,
    ):
        self.account_grant = account_grant if account_grant is not None else None
        '''
         The created AccountGrant.
        '''
        self.meta = meta if meta is not None else None
        '''
         Reserved for future use.
        '''
        self.rate_limit = rate_limit if rate_limit is not None else None
        '''
         Rate limit information.
        '''

    def __repr__(self):
        return '<sdm.AccountGrantCreateResponse ' + \
            'account_grant: ' + repr(self.account_grant) + ' ' +\
            'meta: ' + repr(self.meta) + ' ' +\
            'rate_limit: ' + repr(self.rate_limit) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'account_grant': self.account_grant,
            'meta': self.meta,
            'rate_limit': self.rate_limit,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            account_grant=d.get('account_grant'),
            meta=d.get('meta'),
            rate_limit=d.get('rate_limit'),
        )


class AccountGrantDeleteResponse:
    '''
         AccountGrantDeleteResponse returns information about a AccountGrant that was deleted.
    '''
    __slots__ = [
        'meta',
        'rate_limit',
    ]

    def __init__(
        self,
        meta=None,
        rate_limit=None,
    ):
        self.meta = meta if meta is not None else None
        '''
         Reserved for future use.
        '''
        self.rate_limit = rate_limit if rate_limit is not None else None
        '''
         Rate limit information.
        '''

    def __repr__(self):
        return '<sdm.AccountGrantDeleteResponse ' + \
            'meta: ' + repr(self.meta) + ' ' +\
            'rate_limit: ' + repr(self.rate_limit) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'meta': self.meta,
            'rate_limit': self.rate_limit,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            meta=d.get('meta'),
            rate_limit=d.get('rate_limit'),
        )


class AccountGrantGetResponse:
    '''
         AccountGrantGetResponse returns a requested AccountGrant.
    '''
    __slots__ = [
        'account_grant',
        'meta',
        'rate_limit',
    ]

    def __init__(
        self,
        account_grant=None,
        meta=None,
        rate_limit=None,
    ):
        self.account_grant = account_grant if account_grant is not None else None
        '''
         The requested AccountGrant.
        '''
        self.meta = meta if meta is not None else None
        '''
         Reserved for future use.
        '''
        self.rate_limit = rate_limit if rate_limit is not None else None
        '''
         Rate limit information.
        '''

    def __repr__(self):
        return '<sdm.AccountGrantGetResponse ' + \
            'account_grant: ' + repr(self.account_grant) + ' ' +\
            'meta: ' + repr(self.meta) + ' ' +\
            'rate_limit: ' + repr(self.rate_limit) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'account_grant': self.account_grant,
            'meta': self.meta,
            'rate_limit': self.rate_limit,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            account_grant=d.get('account_grant'),
            meta=d.get('meta'),
            rate_limit=d.get('rate_limit'),
        )


class AccountGrantHistory:
    '''
         AccountGrantHistory records the state of an AccountGrant at a given point in time,
     where every change (create or delete) to an AccountGrant produces an
     AccountGrantHistory record.
    '''
    __slots__ = [
        'account_grant',
        'activity_id',
        'deleted_at',
        'timestamp',
    ]

    def __init__(
        self,
        account_grant=None,
        activity_id=None,
        deleted_at=None,
        timestamp=None,
    ):
        self.account_grant = account_grant if account_grant is not None else None
        '''
         The complete AccountGrant state at this time.
        '''
        self.activity_id = activity_id if activity_id is not None else ''
        '''
         The unique identifier of the Activity that produced this change to the AccountGrant.
         May be empty for some system-initiated updates.
        '''
        self.deleted_at = deleted_at if deleted_at is not None else None
        '''
         If this AccountGrant was deleted, the time it was deleted.
        '''
        self.timestamp = timestamp if timestamp is not None else None
        '''
         The time at which the AccountGrant state was recorded.
        '''

    def __repr__(self):
        return '<sdm.AccountGrantHistory ' + \
            'account_grant: ' + repr(self.account_grant) + ' ' +\
            'activity_id: ' + repr(self.activity_id) + ' ' +\
            'deleted_at: ' + repr(self.deleted_at) + ' ' +\
            'timestamp: ' + repr(self.timestamp) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'account_grant': self.account_grant,
            'activity_id': self.activity_id,
            'deleted_at': self.deleted_at,
            'timestamp': self.timestamp,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            account_grant=d.get('account_grant'),
            activity_id=d.get('activity_id'),
            deleted_at=d.get('deleted_at'),
            timestamp=d.get('timestamp'),
        )


class AccountGroup:
    '''
         An AccountGroup is a link between an Account and a Group.
    '''
    __slots__ = [
        'account_id',
        'group_id',
        'id',
    ]

    def __init__(
        self,
        account_id=None,
        group_id=None,
        id=None,
    ):
        self.account_id = account_id if account_id is not None else ''
        '''
         Unique identifier of the Account.
        '''
        self.group_id = group_id if group_id is not None else ''
        '''
         Unique identifier of the Group.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the AccountGroup.
        '''

    def __repr__(self):
        return '<sdm.AccountGroup ' + \
            'account_id: ' + repr(self.account_id) + ' ' +\
            'group_id: ' + repr(self.group_id) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'account_id': self.account_id,
            'group_id': self.group_id,
            'id': self.id,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            account_id=d.get('account_id'),
            group_id=d.get('group_id'),
            id=d.get('id'),
        )


class AccountGroupCreateRequest:
    '''
         AccountGroupCreateRequest specifies an AccountGroup to create.
    '''
    __slots__ = [
        'account_group',
    ]

    def __init__(
        self,
        account_group=None,
    ):
        self.account_group = account_group if account_group is not None else None
        '''
         Parameters to define the new AccountGroup.
        '''

    def __repr__(self):
        return '<sdm.AccountGroupCreateRequest ' + \
            'account_group: ' + repr(self.account_group) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'account_group': self.account_group,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(account_group=d.get('account_group'), )


class AccountGroupCreateResponse:
    '''
         AccountGroupCreateResponse reports the result of a create.
    '''
    __slots__ = [
        'account_group',
        'rate_limit',
    ]

    def __init__(
        self,
        account_group=None,
        rate_limit=None,
    ):
        self.account_group = account_group if account_group is not None else None
        '''
         The created AccountGroup.
        '''
        self.rate_limit = rate_limit if rate_limit is not None else None
        '''
         Rate limit information.
        '''

    def __repr__(self):
        return '<sdm.AccountGroupCreateResponse ' + \
            'account_group: ' + repr(self.account_group) + ' ' +\
            'rate_limit: ' + repr(self.rate_limit) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'account_group': self.account_group,
            'rate_limit': self.rate_limit,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            account_group=d.get('account_group'),
            rate_limit=d.get('rate_limit'),
        )


class AccountGroupDeleteRequest:
    '''
         GroupDeleteRequest identifies an AccountGroup by ID to delete.
    '''
    __slots__ = [
        'id',
    ]

    def __init__(
        self,
        id=None,
    ):
        self.id = id if id is not None else ''
        '''
         The unique identifier of the group to delete.
        '''

    def __repr__(self):
        return '<sdm.AccountGroupDeleteRequest ' + \
            'id: ' + repr(self.id) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'id': self.id,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(id=d.get('id'), )


class AccountGroupDeleteResponse:
    '''
         GroupDeleteResponse returns information about an AccountGroup that was deleted.
    '''
    __slots__ = [
        'meta',
        'rate_limit',
    ]

    def __init__(
        self,
        meta=None,
        rate_limit=None,
    ):
        self.meta = meta if meta is not None else None
        '''
         Reserved for future use.
        '''
        self.rate_limit = rate_limit if rate_limit is not None else None
        '''
         Rate limit information.
        '''

    def __repr__(self):
        return '<sdm.AccountGroupDeleteResponse ' + \
            'meta: ' + repr(self.meta) + ' ' +\
            'rate_limit: ' + repr(self.rate_limit) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'meta': self.meta,
            'rate_limit': self.rate_limit,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            meta=d.get('meta'),
            rate_limit=d.get('rate_limit'),
        )


class AccountGroupGetRequest:
    '''
         AccountGroupGetRequest specifies which AccountGroup to retrieve.
    '''
    __slots__ = [
        'id',
    ]

    def __init__(
        self,
        id=None,
    ):
        self.id = id if id is not None else ''
        '''
         The unique identifier of the AccountGroup to retrieve.
        '''

    def __repr__(self):
        return '<sdm.AccountGroupGetRequest ' + \
            'id: ' + repr(self.id) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'id': self.id,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(id=d.get('id'), )


class AccountGroupGetResponse:
    '''
         AccountGroupGetResponse returns a requested AccountGroup.
    '''
    __slots__ = [
        'account_group',
        'meta',
        'rate_limit',
    ]

    def __init__(
        self,
        account_group=None,
        meta=None,
        rate_limit=None,
    ):
        self.account_group = account_group if account_group is not None else None
        '''
         The requested AccountGroup.
        '''
        self.meta = meta if meta is not None else None
        '''
         Reserved for future use.
        '''
        self.rate_limit = rate_limit if rate_limit is not None else None
        '''
         Rate limit information.
        '''

    def __repr__(self):
        return '<sdm.AccountGroupGetResponse ' + \
            'account_group: ' + repr(self.account_group) + ' ' +\
            'meta: ' + repr(self.meta) + ' ' +\
            'rate_limit: ' + repr(self.rate_limit) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'account_group': self.account_group,
            'meta': self.meta,
            'rate_limit': self.rate_limit,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            account_group=d.get('account_group'),
            meta=d.get('meta'),
            rate_limit=d.get('rate_limit'),
        )


class AccountGroupHistory:
    '''
         AccountGroupHistory records the state of an AccountGroup at a given point in time,
     where every change (create, update and delete) to an AccountGroup produces an
     AccountGroupHistory record.
    '''
    __slots__ = [
        'account_group',
        'activity_id',
        'deleted_at',
        'timestamp',
    ]

    def __init__(
        self,
        account_group=None,
        activity_id=None,
        deleted_at=None,
        timestamp=None,
    ):
        self.account_group = account_group if account_group is not None else None
        '''
         The complete AccountGroup state at this time.
        '''
        self.activity_id = activity_id if activity_id is not None else ''
        '''
         The unique identifier of the Activity that produced this change to the AccountGroup.
         May be empty for some system-initiated updates.
        '''
        self.deleted_at = deleted_at if deleted_at is not None else None
        '''
         If this AccountGroup was deleted, the time it was deleted.
        '''
        self.timestamp = timestamp if timestamp is not None else None
        '''
         The time at which the AccountGroup state was recorded.
        '''

    def __repr__(self):
        return '<sdm.AccountGroupHistory ' + \
            'account_group: ' + repr(self.account_group) + ' ' +\
            'activity_id: ' + repr(self.activity_id) + ' ' +\
            'deleted_at: ' + repr(self.deleted_at) + ' ' +\
            'timestamp: ' + repr(self.timestamp) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'account_group': self.account_group,
            'activity_id': self.activity_id,
            'deleted_at': self.deleted_at,
            'timestamp': self.timestamp,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            account_group=d.get('account_group'),
            activity_id=d.get('activity_id'),
            deleted_at=d.get('deleted_at'),
            timestamp=d.get('timestamp'),
        )


class AccountGroupListRequest:
    '''
         GroupListRequest specifies criteria for retrieving a list of groups.
    '''
    __slots__ = [
        'filter',
    ]

    def __init__(
        self,
        filter=None,
    ):
        self.filter = filter if filter is not None else ''
        '''
         A human-readable filter query string.
        '''

    def __repr__(self):
        return '<sdm.AccountGroupListRequest ' + \
            'filter: ' + repr(self.filter) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'filter': self.filter,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(filter=d.get('filter'), )


class AccountGroupListResponse:
    '''
         GroupListResponse returns a list of groups that meet the criteria of a
     GroupListRequest.
    '''
    __slots__ = [
        'rate_limit',
    ]

    def __init__(
        self,
        rate_limit=None,
    ):
        self.rate_limit = rate_limit if rate_limit is not None else None
        '''
         Rate limit information.
        '''

    def __repr__(self):
        return '<sdm.AccountGroupListResponse ' + \
            'rate_limit: ' + repr(self.rate_limit) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'rate_limit': self.rate_limit,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(rate_limit=d.get('rate_limit'), )


class AccountHistory:
    '''
         AccountHistory records the state of an Account at a given point in time,
     where every change (create, update and delete) to an Account produces an
     AccountHistory record.
    '''
    __slots__ = [
        'account',
        'activity_id',
        'deleted_at',
        'timestamp',
    ]

    def __init__(
        self,
        account=None,
        activity_id=None,
        deleted_at=None,
        timestamp=None,
    ):
        self.account = account if account is not None else None
        '''
         The complete Account state at this time.
        '''
        self.activity_id = activity_id if activity_id is not None else ''
        '''
         The unique identifier of the Activity that produced this change to the Account.
         May be empty for some system-initiated updates.
        '''
        self.deleted_at = deleted_at if deleted_at is not None else None
        '''
         If this Account was deleted, the time it was deleted.
        '''
        self.timestamp = timestamp if timestamp is not None else None
        '''
         The time at which the Account state was recorded.
        '''

    def __repr__(self):
        return '<sdm.AccountHistory ' + \
            'account: ' + repr(self.account) + ' ' +\
            'activity_id: ' + repr(self.activity_id) + ' ' +\
            'deleted_at: ' + repr(self.deleted_at) + ' ' +\
            'timestamp: ' + repr(self.timestamp) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'account': self.account,
            'activity_id': self.activity_id,
            'deleted_at': self.deleted_at,
            'timestamp': self.timestamp,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            account=d.get('account'),
            activity_id=d.get('activity_id'),
            deleted_at=d.get('deleted_at'),
            timestamp=d.get('timestamp'),
        )


class AccountPermission:
    '''
         AccountPermission represents an individual API action available to an account.
    '''
    __slots__ = [
        'account_id',
        'granted_at',
        'permission',
        'scope',
        'scoped_id',
    ]

    def __init__(
        self,
        account_id=None,
        granted_at=None,
        permission=None,
        scope=None,
        scoped_id=None,
    ):
        self.account_id = account_id if account_id is not None else ''
        '''
         The unique identifier of the Account this permission belongs to.
        '''
        self.granted_at = granted_at if granted_at is not None else None
        '''
         The most recent time at which the permission was granted. If a permission was
         granted, revoked, and granted again, this will reflect the later time.
        '''
        self.permission = permission if permission is not None else ''
        '''
         The value of this permission, split into vertical and action, one of the Permission constants.
        '''
        self.scope = scope if scope is not None else ''
        '''
         The scope of this permission. A global scope means this action can be taken
         on any entity; otherwise the action can only be taken on or in the scope of
         the scoped id.
        '''
        self.scoped_id = scoped_id if scoped_id is not None else ''
        '''
         The ID to which or in whose context this operation is permitted. e.g. The ID of a
         role that a team leader has the abillity to remove and add accounts to, or the
         ID of a resource that a user has the permission to connect to. If Scope is global,
         scoped id is not populated.
        '''

    def __repr__(self):
        return '<sdm.AccountPermission ' + \
            'account_id: ' + repr(self.account_id) + ' ' +\
            'granted_at: ' + repr(self.granted_at) + ' ' +\
            'permission: ' + repr(self.permission) + ' ' +\
            'scope: ' + repr(self.scope) + ' ' +\
            'scoped_id: ' + repr(self.scoped_id) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'account_id': self.account_id,
            'granted_at': self.granted_at,
            'permission': self.permission,
            'scope': self.scope,
            'scoped_id': self.scoped_id,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            account_id=d.get('account_id'),
            granted_at=d.get('granted_at'),
            permission=d.get('permission'),
            scope=d.get('scope'),
            scoped_id=d.get('scoped_id'),
        )


class AccountResource:
    '''
         AccountResource represents an individual access grant of a Account to a Resource.
    '''
    __slots__ = [
        'account_grant_id',
        'account_id',
        'created_at',
        'expires_at',
        'granted_at',
        'resource_id',
        'role_id',
    ]

    def __init__(
        self,
        account_grant_id=None,
        account_id=None,
        created_at=None,
        expires_at=None,
        granted_at=None,
        resource_id=None,
        role_id=None,
    ):
        self.account_grant_id = account_grant_id if account_grant_id is not None else ''
        '''
         The unique identifier of the AccountGrant through which the Account was granted access to the Resource.
         If empty, access was not granted through an AccountGrant.
        '''
        self.account_id = account_id if account_id is not None else ''
        '''
         The unique identifier of the Account to which access is granted.
        '''
        self.created_at = created_at if created_at is not None else None
        '''
         The time this grant was created, distinct from 'granted at' in the case where access is scheduled
         for the future. If access was granted, revoked, and granted again, this will reflect the later creation time.
        '''
        self.expires_at = expires_at if expires_at is not None else None
        '''
         The time at which access will expire. If empty, this access has no expiration.
        '''
        self.granted_at = granted_at if granted_at is not None else None
        '''
         The most recent time at which access was granted. If access was granted,
         revoked, and granted again, this will reflect the later time.
        '''
        self.resource_id = resource_id if resource_id is not None else ''
        '''
         The unique identifier of the Resource to which access is granted.
        '''
        self.role_id = role_id if role_id is not None else ''
        '''
         The unique identifier of the Role through which the Account was granted access to the Resource.
         If empty, access was not granted through an AccountAttachment to a Role.
        '''

    def __repr__(self):
        return '<sdm.AccountResource ' + \
            'account_grant_id: ' + repr(self.account_grant_id) + ' ' +\
            'account_id: ' + repr(self.account_id) + ' ' +\
            'created_at: ' + repr(self.created_at) + ' ' +\
            'expires_at: ' + repr(self.expires_at) + ' ' +\
            'granted_at: ' + repr(self.granted_at) + ' ' +\
            'resource_id: ' + repr(self.resource_id) + ' ' +\
            'role_id: ' + repr(self.role_id) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'account_grant_id': self.account_grant_id,
            'account_id': self.account_id,
            'created_at': self.created_at,
            'expires_at': self.expires_at,
            'granted_at': self.granted_at,
            'resource_id': self.resource_id,
            'role_id': self.role_id,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            account_grant_id=d.get('account_grant_id'),
            account_id=d.get('account_id'),
            created_at=d.get('created_at'),
            expires_at=d.get('expires_at'),
            granted_at=d.get('granted_at'),
            resource_id=d.get('resource_id'),
            role_id=d.get('role_id'),
        )


class AccountResourceHistory:
    '''
         AccountResourceHistory records the state of a AccountResource at a given point in time,
     where every change (create or delete) to a AccountResource produces an
     AccountResourceHistory record.
    '''
    __slots__ = [
        'account_resource',
        'activity_id',
        'deleted_at',
        'timestamp',
    ]

    def __init__(
        self,
        account_resource=None,
        activity_id=None,
        deleted_at=None,
        timestamp=None,
    ):
        self.account_resource = account_resource if account_resource is not None else None
        '''
         The complete AccountResource state at this time.
        '''
        self.activity_id = activity_id if activity_id is not None else ''
        '''
         The unique identifier of the Activity that produced this change to the AccountResource.
         May be empty for some system-initiated updates.
        '''
        self.deleted_at = deleted_at if deleted_at is not None else None
        '''
         If this AccountResource was deleted, the time it was deleted.
        '''
        self.timestamp = timestamp if timestamp is not None else None
        '''
         The time at which the AccountResource state was recorded.
        '''

    def __repr__(self):
        return '<sdm.AccountResourceHistory ' + \
            'account_resource: ' + repr(self.account_resource) + ' ' +\
            'activity_id: ' + repr(self.activity_id) + ' ' +\
            'deleted_at: ' + repr(self.deleted_at) + ' ' +\
            'timestamp: ' + repr(self.timestamp) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'account_resource': self.account_resource,
            'activity_id': self.activity_id,
            'deleted_at': self.deleted_at,
            'timestamp': self.timestamp,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            account_resource=d.get('account_resource'),
            activity_id=d.get('activity_id'),
            deleted_at=d.get('deleted_at'),
            timestamp=d.get('timestamp'),
        )


class AccountUpdateResponse:
    '''
         AccountUpdateResponse returns the fields of a Account after it has been updated by
     a AccountUpdateRequest.
    '''
    __slots__ = [
        'account',
        'meta',
        'rate_limit',
    ]

    def __init__(
        self,
        account=None,
        meta=None,
        rate_limit=None,
    ):
        self.account = account if account is not None else None
        '''
         The updated Account.
        '''
        self.meta = meta if meta is not None else None
        '''
         Reserved for future use.
        '''
        self.rate_limit = rate_limit if rate_limit is not None else None
        '''
         Rate limit information.
        '''

    def __repr__(self):
        return '<sdm.AccountUpdateResponse ' + \
            'account: ' + repr(self.account) + ' ' +\
            'meta: ' + repr(self.meta) + ' ' +\
            'rate_limit: ' + repr(self.rate_limit) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'account': self.account,
            'meta': self.meta,
            'rate_limit': self.rate_limit,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            account=d.get('account'),
            meta=d.get('meta'),
            rate_limit=d.get('rate_limit'),
        )


class ActiveDirectoryEngine:
    __slots__ = [
        'after_read_ttl',
        'binddn',
        'bindpass',
        'certificate',
        'connection_timeout',
        'do_not_validate_timestamps',
        'id',
        'insecure_tls',
        'key_rotation_interval_days',
        'max_backoff_duration',
        'name',
        'policy',
        'public_key',
        'request_timeout',
        'secret_store_id',
        'secret_store_root_path',
        'start_tls',
        'tags',
        'ttl',
        'upndomain',
        'url',
        'userdn',
    ]

    def __init__(
        self,
        after_read_ttl=None,
        binddn=None,
        bindpass=None,
        certificate=None,
        connection_timeout=None,
        do_not_validate_timestamps=None,
        id=None,
        insecure_tls=None,
        key_rotation_interval_days=None,
        max_backoff_duration=None,
        name=None,
        policy=None,
        public_key=None,
        request_timeout=None,
        secret_store_id=None,
        secret_store_root_path=None,
        start_tls=None,
        tags=None,
        ttl=None,
        upndomain=None,
        url=None,
        userdn=None,
    ):
        self.after_read_ttl = after_read_ttl if after_read_ttl is not None else None
        '''
         The default time-to-live duration of the password after it's read. Once the ttl has passed, a password will be rotated.
        '''
        self.binddn = binddn if binddn is not None else ''
        '''
         Distinguished name of object to bind when performing user and group search. Example: cn=vault,ou=Users,dc=example,dc=com
        '''
        self.bindpass = bindpass if bindpass is not None else ''
        '''
         Password to use along with binddn when performing user search.
        '''
        self.certificate = certificate if certificate is not None else ''
        '''
         CA certificate to use when verifying LDAP server certificate, must be x509 PEM encoded.
        '''
        self.connection_timeout = connection_timeout if connection_timeout is not None else 0
        '''
         Timeout, in seconds, when attempting to connect to the LDAP server before trying the next URL in the configuration.
        '''
        self.do_not_validate_timestamps = do_not_validate_timestamps if do_not_validate_timestamps is not None else False
        '''
         If set to true this will prevent password change timestamp validation in Active Directory when validating credentials
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Secret Engine.
        '''
        self.insecure_tls = insecure_tls if insecure_tls is not None else False
        '''
         If true, skips LDAP server SSL certificate verification - insecure, use with caution!
        '''
        self.key_rotation_interval_days = key_rotation_interval_days if key_rotation_interval_days is not None else 0
        '''
         An interval of public/private key rotation for secret engine in days
        '''
        self.max_backoff_duration = max_backoff_duration if max_backoff_duration is not None else None
        '''
         The maximum retry duration in case of automatic failure.
         On failed ttl rotation attempt it will be retried in an increasing intervals until it reaches max_backoff_duration
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Secret Engine.
        '''
        self.policy = policy if policy is not None else None
        '''
         Policy for password creation
        '''
        self.public_key = public_key if public_key is not None else b''
        '''
         Public key linked with a secret engine
        '''
        self.request_timeout = request_timeout if request_timeout is not None else 0
        '''
         Timeout, in seconds, for the connection when making requests against the server before returning back an error.
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         Backing secret store identifier
        '''
        self.secret_store_root_path = secret_store_root_path if secret_store_root_path is not None else ''
        '''
         Backing Secret Store root path where managed secrets are going to be stored
        '''
        self.start_tls = start_tls if start_tls is not None else False
        '''
         If true, issues a StartTLS command after establishing an unencrypted connection.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.ttl = ttl if ttl is not None else None
        '''
         The default password time-to-live duration. Once the ttl has passed, a password will be rotated the next time it's requested.
        '''
        self.upndomain = upndomain if upndomain is not None else ''
        '''
         The domain (userPrincipalDomain) used to construct a UPN string for authentication.
        '''
        self.url = url if url is not None else ''
        '''
         The LDAP server to connect to.
        '''
        self.userdn = userdn if userdn is not None else ''
        '''
         Base DN under which to perform user search. Example: ou=Users,dc=example,dc=com
        '''

    def __repr__(self):
        return '<sdm.ActiveDirectoryEngine ' + \
            'after_read_ttl: ' + repr(self.after_read_ttl) + ' ' +\
            'binddn: ' + repr(self.binddn) + ' ' +\
            'bindpass: ' + repr(self.bindpass) + ' ' +\
            'certificate: ' + repr(self.certificate) + ' ' +\
            'connection_timeout: ' + repr(self.connection_timeout) + ' ' +\
            'do_not_validate_timestamps: ' + repr(self.do_not_validate_timestamps) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'insecure_tls: ' + repr(self.insecure_tls) + ' ' +\
            'key_rotation_interval_days: ' + repr(self.key_rotation_interval_days) + ' ' +\
            'max_backoff_duration: ' + repr(self.max_backoff_duration) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'policy: ' + repr(self.policy) + ' ' +\
            'public_key: ' + repr(self.public_key) + ' ' +\
            'request_timeout: ' + repr(self.request_timeout) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'secret_store_root_path: ' + repr(self.secret_store_root_path) + ' ' +\
            'start_tls: ' + repr(self.start_tls) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'ttl: ' + repr(self.ttl) + ' ' +\
            'upndomain: ' + repr(self.upndomain) + ' ' +\
            'url: ' + repr(self.url) + ' ' +\
            'userdn: ' + repr(self.userdn) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'after_read_ttl': self.after_read_ttl,
            'binddn': self.binddn,
            'bindpass': self.bindpass,
            'certificate': self.certificate,
            'connection_timeout': self.connection_timeout,
            'do_not_validate_timestamps': self.do_not_validate_timestamps,
            'id': self.id,
            'insecure_tls': self.insecure_tls,
            'key_rotation_interval_days': self.key_rotation_interval_days,
            'max_backoff_duration': self.max_backoff_duration,
            'name': self.name,
            'policy': self.policy,
            'public_key': self.public_key,
            'request_timeout': self.request_timeout,
            'secret_store_id': self.secret_store_id,
            'secret_store_root_path': self.secret_store_root_path,
            'start_tls': self.start_tls,
            'tags': self.tags,
            'ttl': self.ttl,
            'upndomain': self.upndomain,
            'url': self.url,
            'userdn': self.userdn,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            after_read_ttl=d.get('after_read_ttl'),
            binddn=d.get('binddn'),
            bindpass=d.get('bindpass'),
            certificate=d.get('certificate'),
            connection_timeout=d.get('connection_timeout'),
            do_not_validate_timestamps=d.get('do_not_validate_timestamps'),
            id=d.get('id'),
            insecure_tls=d.get('insecure_tls'),
            key_rotation_interval_days=d.get('key_rotation_interval_days'),
            max_backoff_duration=d.get('max_backoff_duration'),
            name=d.get('name'),
            policy=d.get('policy'),
            public_key=d.get('public_key'),
            request_timeout=d.get('request_timeout'),
            secret_store_id=d.get('secret_store_id'),
            secret_store_root_path=d.get('secret_store_root_path'),
            start_tls=d.get('start_tls'),
            tags=d.get('tags'),
            ttl=d.get('ttl'),
            upndomain=d.get('upndomain'),
            url=d.get('url'),
            userdn=d.get('userdn'),
        )


class ActiveDirectoryStore:
    __slots__ = [
        'id',
        'name',
        'server_address',
        'tags',
    ]

    def __init__(
        self,
        id=None,
        name=None,
        server_address=None,
        tags=None,
    ):
        self.id = id if id is not None else ''
        '''
         Unique identifier of the SecretStore.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the SecretStore.
        '''
        self.server_address = server_address if server_address is not None else ''
        '''
         Hostname of server that is hosting NDES (Network Device Enrollment Services).
         Often this is the same host as Active Directory Certificate Services
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''

    def __repr__(self):
        return '<sdm.ActiveDirectoryStore ' + \
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'server_address: ' + repr(self.server_address) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'id': self.id,
            'name': self.name,
            'server_address': self.server_address,
            'tags': self.tags,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            id=d.get('id'),
            name=d.get('name'),
            server_address=d.get('server_address'),
            tags=d.get('tags'),
        )


class Activity:
    '''
         An Activity is a record of an action taken against a strongDM deployment, e.g.
     a user creation, resource deletion, sso configuration change, etc.
    '''
    __slots__ = [
        'actor',
        'completed_at',
        'description',
        'entities',
        'id',
        'ip_address',
        'user_agent',
        'verb',
    ]

    def __init__(
        self,
        actor=None,
        completed_at=None,
        description=None,
        entities=None,
        id=None,
        ip_address=None,
        user_agent=None,
        verb=None,
    ):
        self.actor = actor if actor is not None else None
        '''
         The account who executed this activity. If the actor later has a name or email change,
         that change is not reflected here. Actor is a snapshot of the executing account at
         the time an activity took place.
        '''
        self.completed_at = completed_at if completed_at is not None else None
        '''
         The time this activity took effect.
        '''
        self.description = description if description is not None else ''
        '''
         A humanized description of the activity.
        '''
        self.entities = entities if entities is not None else []
        '''
         The entities involved in this activity. These entities can be any first class
         entity in the strongDM system, eg. a user, a role, a node, an account grant. Not
         every activity affects explicit entities.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Activity.
        '''
        self.ip_address = ip_address if ip_address is not None else ''
        '''
         The IP from which this action was taken.
        '''
        self.user_agent = user_agent if user_agent is not None else ''
        '''
         The User Agent present when this request was executed. Generally a client type and version
         like strongdm-cli/55.66.77
        '''
        self.verb = verb if verb is not None else ''
        '''
         The kind of activity which has taken place, one of the ActivityVerb constants.
        '''

    def __repr__(self):
        return '<sdm.Activity ' + \
            'actor: ' + repr(self.actor) + ' ' +\
            'completed_at: ' + repr(self.completed_at) + ' ' +\
            'description: ' + repr(self.description) + ' ' +\
            'entities: ' + repr(self.entities) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'ip_address: ' + repr(self.ip_address) + ' ' +\
            'user_agent: ' + repr(self.user_agent) + ' ' +\
            'verb: ' + repr(self.verb) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'actor': self.actor,
            'completed_at': self.completed_at,
            'description': self.description,
            'entities': self.entities,
            'id': self.id,
            'ip_address': self.ip_address,
            'user_agent': self.user_agent,
            'verb': self.verb,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            actor=d.get('actor'),
            completed_at=d.get('completed_at'),
            description=d.get('description'),
            entities=d.get('entities'),
            id=d.get('id'),
            ip_address=d.get('ip_address'),
            user_agent=d.get('user_agent'),
            verb=d.get('verb'),
        )


class ActivityActor:
    __slots__ = [
        'activity_external_id',
        'email',
        'first_name',
        'id',
        'last_name',
    ]

    def __init__(
        self,
        activity_external_id=None,
        email=None,
        first_name=None,
        id=None,
        last_name=None,
    ):
        self.activity_external_id = activity_external_id if activity_external_id is not None else ''
        '''
         The external ID of the actor at the time this activity occurred.
        '''
        self.email = email if email is not None else ''
        '''
         The email of the actor at the time this activity occurred.
        '''
        self.first_name = first_name if first_name is not None else ''
        '''
         The first name of the actor at the time this activity occurred.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the actor. Immutable.
        '''
        self.last_name = last_name if last_name is not None else ''
        '''
         The last name of the actor at the time this activity occurred.
        '''

    def __repr__(self):
        return '<sdm.ActivityActor ' + \
            'activity_external_id: ' + repr(self.activity_external_id) + ' ' +\
            'email: ' + repr(self.email) + ' ' +\
            'first_name: ' + repr(self.first_name) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'last_name: ' + repr(self.last_name) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'activity_external_id': self.activity_external_id,
            'email': self.email,
            'first_name': self.first_name,
            'id': self.id,
            'last_name': self.last_name,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            activity_external_id=d.get('activity_external_id'),
            email=d.get('email'),
            first_name=d.get('first_name'),
            id=d.get('id'),
            last_name=d.get('last_name'),
        )


class ActivityEntity:
    __slots__ = [
        'email',
        'external_id',
        'id',
        'name',
        'type',
    ]

    def __init__(
        self,
        email=None,
        external_id=None,
        id=None,
        name=None,
        type=None,
    ):
        self.email = email if email is not None else ''
        '''
         The email of the affected entity, if it has one (for example, if it is an account).
        '''
        self.external_id = external_id if external_id is not None else ''
        '''
         The external ID of the affected entity, if it has one (for example, if it is an account).
        '''
        self.id = id if id is not None else ''
        '''
         The unique identifier of the entity this activity affected.
        '''
        self.name = name if name is not None else ''
        '''
         A display name representing the affected entity.
        '''
        self.type = type if type is not None else ''
        '''
         The type of entity affected, one of the ActivityEntityType constants.
        '''

    def __repr__(self):
        return '<sdm.ActivityEntity ' + \
            'email: ' + repr(self.email) + ' ' +\
            'external_id: ' + repr(self.external_id) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'type: ' + repr(self.type) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'email': self.email,
            'external_id': self.external_id,
            'id': self.id,
            'name': self.name,
            'type': self.type,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            email=d.get('email'),
            external_id=d.get('external_id'),
            id=d.get('id'),
            name=d.get('name'),
            type=d.get('type'),
        )


class ActivityGetResponse:
    '''
         ActivityGetResponse returns a requested Activity.
    '''
    __slots__ = [
        'activity',
        'meta',
        'rate_limit',
    ]

    def __init__(
        self,
        activity=None,
        meta=None,
        rate_limit=None,
    ):
        self.activity = activity if activity is not None else None
        '''
         The requested Activity.
        '''
        self.meta = meta if meta is not None else None
        '''
         Reserved for future use.
        '''
        self.rate_limit = rate_limit if rate_limit is not None else None
        '''
         Rate limit information.
        '''

    def __repr__(self):
        return '<sdm.ActivityGetResponse ' + \
            'activity: ' + repr(self.activity) + ' ' +\
            'meta: ' + repr(self.meta) + ' ' +\
            'rate_limit: ' + repr(self.rate_limit) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'activity': self.activity,
            'meta': self.meta,
            'rate_limit': self.rate_limit,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            activity=d.get('activity'),
            meta=d.get('meta'),
            rate_limit=d.get('rate_limit'),
        )


class Aerospike:
    __slots__ = [
        'bind_interface',
        'egress_filter',
        'healthy',
        'hostname',
        'id',
        'name',
        'password',
        'port',
        'port_override',
        'proxy_cluster_id',
        'secret_store_id',
        'subdomain',
        'tags',
        'use_services_alternate',
        'username',
    ]

    def __init__(
        self,
        bind_interface=None,
        egress_filter=None,
        healthy=None,
        hostname=None,
        id=None,
        name=None,
        password=None,
        port=None,
        port_override=None,
        proxy_cluster_id=None,
        secret_store_id=None,
        subdomain=None,
        tags=None,
        use_services_alternate=None,
        username=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided and may also be set to one of the ResourceIPAllocationMode constants to select between VNM, loopback, or default allocation.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        '''
         The host to dial to initiate a connection from the egress node to this resource.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.password = password if password is not None else ''
        '''
         The password to authenticate with.
        '''
        self.port = port if port is not None else 0
        '''
         The port to dial to initiate a connection from the egress node to this resource.
        '''
        self.port_override = port_override if port_override is not None else 0
        '''
         The local port used by clients to connect to this resource. It is automatically generated if not provided on create and may be re-generated on update by specifying a value of -1.
        '''
        self.proxy_cluster_id = proxy_cluster_id if proxy_cluster_id is not None else ''
        '''
         ID of the proxy cluster for this resource, if any.
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         DNS subdomain through which this resource may be accessed on clients.  (e.g. "app-prod1" allows the resource to be accessed at "app-prod1.your-org-name.sdm-proxy-domain"). Only applicable to HTTP-based resources or resources using virtual networking mode.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.use_services_alternate = use_services_alternate if use_services_alternate is not None else False
        '''
         If true, uses UseServicesAlternates directive for Aerospike connection
        '''
        self.username = username if username is not None else ''
        '''
         The username to authenticate with.
        '''

    def __repr__(self):
        return '<sdm.Aerospike ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'password: ' + repr(self.password) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'proxy_cluster_id: ' + repr(self.proxy_cluster_id) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'use_services_alternate: ' + repr(self.use_services_alternate) + ' ' +\
            'username: ' + repr(self.username) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'egress_filter': self.egress_filter,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'name': self.name,
            'password': self.password,
            'port': self.port,
            'port_override': self.port_override,
            'proxy_cluster_id': self.proxy_cluster_id,
            'secret_store_id': self.secret_store_id,
            'subdomain': self.subdomain,
            'tags': self.tags,
            'use_services_alternate': self.use_services_alternate,
            'username': self.username,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            egress_filter=d.get('egress_filter'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            name=d.get('name'),
            password=d.get('password'),
            port=d.get('port'),
            port_override=d.get('port_override'),
            proxy_cluster_id=d.get('proxy_cluster_id'),
            secret_store_id=d.get('secret_store_id'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
            use_services_alternate=d.get('use_services_alternate'),
            username=d.get('username'),
        )


class AmazonEKS:
    __slots__ = [
        'access_key',
        'allow_resource_role_bypass',
        'bind_interface',
        'certificate_authority',
        'cluster_name',
        'discovery_enabled',
        'discovery_username',
        'egress_filter',
        'endpoint',
        'healthcheck_namespace',
        'healthy',
        'id',
        'identity_alias_healthcheck_username',
        'identity_set_id',
        'name',
        'port_override',
        'proxy_cluster_id',
        'region',
        'role_arn',
        'role_external_id',
        'secret_access_key',
        'secret_store_id',
        'subdomain',
        'tags',
    ]

    def __init__(
        self,
        access_key=None,
        allow_resource_role_bypass=None,
        bind_interface=None,
        certificate_authority=None,
        cluster_name=None,
        discovery_enabled=None,
        discovery_username=None,
        egress_filter=None,
        endpoint=None,
        healthcheck_namespace=None,
        healthy=None,
        id=None,
        identity_alias_healthcheck_username=None,
        identity_set_id=None,
        name=None,
        port_override=None,
        proxy_cluster_id=None,
        region=None,
        role_arn=None,
        role_external_id=None,
        secret_access_key=None,
        secret_store_id=None,
        subdomain=None,
        tags=None,
    ):
        self.access_key = access_key if access_key is not None else ''
        '''
         The Access Key ID to use to authenticate.
        '''
        self.allow_resource_role_bypass = allow_resource_role_bypass if allow_resource_role_bypass is not None else False
        '''
         If true, allows users to fallback to the existing authentication mode (Leased Credential or Identity Set)
         when a resource role is not provided.
        '''
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided and may also be set to one of the ResourceIPAllocationMode constants to select between VNM, loopback, or default allocation.
        '''
        self.certificate_authority = certificate_authority if certificate_authority is not None else ''
        '''
         The CA to authenticate TLS connections with.
        '''
        self.cluster_name = cluster_name if cluster_name is not None else ''
        '''
         The name of the cluster to connect to.
        '''
        self.discovery_enabled = discovery_enabled if discovery_enabled is not None else False
        '''
         If true, configures discovery of a cluster to be run from a node.
        '''
        self.discovery_username = discovery_username if discovery_username is not None else ''
        '''
         If a cluster is configured for user impersonation, this is the user to impersonate when
         running discovery.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.endpoint = endpoint if endpoint is not None else ''
        '''
         The endpoint to dial.
        '''
        self.healthcheck_namespace = healthcheck_namespace if healthcheck_namespace is not None else ''
        '''
         The path used to check the health of your connection.  Defaults to `default`.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.identity_alias_healthcheck_username = identity_alias_healthcheck_username if identity_alias_healthcheck_username is not None else ''
        '''
         The username to use for healthchecks, when clients otherwise connect with their own identity alias username.
        '''
        self.identity_set_id = identity_set_id if identity_set_id is not None else ''
        '''
         The ID of the identity set to use for identity connections.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.port_override = port_override if port_override is not None else 0
        '''
         The local port used by clients to connect to this resource. It is automatically generated if not provided on create and may be re-generated on update by specifying a value of -1.
        '''
        self.proxy_cluster_id = proxy_cluster_id if proxy_cluster_id is not None else ''
        '''
         ID of the proxy cluster for this resource, if any.
        '''
        self.region = region if region is not None else ''
        '''
         The AWS region to connect to e.g. us-east-1.
        '''
        self.role_arn = role_arn if role_arn is not None else ''
        '''
         The role to assume after logging in.
        '''
        self.role_external_id = role_external_id if role_external_id is not None else ''
        '''
         The external ID to associate with assume role requests. Does nothing if a role ARN is not provided.
        '''
        self.secret_access_key = secret_access_key if secret_access_key is not None else ''
        '''
         The Secret Access Key to use to authenticate.
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         DNS subdomain through which this resource may be accessed on clients.  (e.g. "app-prod1" allows the resource to be accessed at "app-prod1.your-org-name.sdm-proxy-domain"). Only applicable to HTTP-based resources or resources using virtual networking mode.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''

    def __repr__(self):
        return '<sdm.AmazonEKS ' + \
            'access_key: ' + repr(self.access_key) + ' ' +\
            'allow_resource_role_bypass: ' + repr(self.allow_resource_role_bypass) + ' ' +\
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'certificate_authority: ' + repr(self.certificate_authority) + ' ' +\
            'cluster_name: ' + repr(self.cluster_name) + ' ' +\
            'discovery_enabled: ' + repr(self.discovery_enabled) + ' ' +\
            'discovery_username: ' + repr(self.discovery_username) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'endpoint: ' + repr(self.endpoint) + ' ' +\
            'healthcheck_namespace: ' + repr(self.healthcheck_namespace) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'identity_alias_healthcheck_username: ' + repr(self.identity_alias_healthcheck_username) + ' ' +\
            'identity_set_id: ' + repr(self.identity_set_id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'proxy_cluster_id: ' + repr(self.proxy_cluster_id) + ' ' +\
            'region: ' + repr(self.region) + ' ' +\
            'role_arn: ' + repr(self.role_arn) + ' ' +\
            'role_external_id: ' + repr(self.role_external_id) + ' ' +\
            'secret_access_key: ' + repr(self.secret_access_key) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'access_key': self.access_key,
            'allow_resource_role_bypass': self.allow_resource_role_bypass,
            'bind_interface': self.bind_interface,
            'certificate_authority': self.certificate_authority,
            'cluster_name': self.cluster_name,
            'discovery_enabled': self.discovery_enabled,
            'discovery_username': self.discovery_username,
            'egress_filter': self.egress_filter,
            'endpoint': self.endpoint,
            'healthcheck_namespace': self.healthcheck_namespace,
            'healthy': self.healthy,
            'id': self.id,
            'identity_alias_healthcheck_username':
            self.identity_alias_healthcheck_username,
            'identity_set_id': self.identity_set_id,
            'name': self.name,
            'port_override': self.port_override,
            'proxy_cluster_id': self.proxy_cluster_id,
            'region': self.region,
            'role_arn': self.role_arn,
            'role_external_id': self.role_external_id,
            'secret_access_key': self.secret_access_key,
            'secret_store_id': self.secret_store_id,
            'subdomain': self.subdomain,
            'tags': self.tags,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            access_key=d.get('access_key'),
            allow_resource_role_bypass=d.get('allow_resource_role_bypass'),
            bind_interface=d.get('bind_interface'),
            certificate_authority=d.get('certificate_authority'),
            cluster_name=d.get('cluster_name'),
            discovery_enabled=d.get('discovery_enabled'),
            discovery_username=d.get('discovery_username'),
            egress_filter=d.get('egress_filter'),
            endpoint=d.get('endpoint'),
            healthcheck_namespace=d.get('healthcheck_namespace'),
            healthy=d.get('healthy'),
            id=d.get('id'),
            identity_alias_healthcheck_username=d.get(
                'identity_alias_healthcheck_username'),
            identity_set_id=d.get('identity_set_id'),
            name=d.get('name'),
            port_override=d.get('port_override'),
            proxy_cluster_id=d.get('proxy_cluster_id'),
            region=d.get('region'),
            role_arn=d.get('role_arn'),
            role_external_id=d.get('role_external_id'),
            secret_access_key=d.get('secret_access_key'),
            secret_store_id=d.get('secret_store_id'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
        )


class AmazonEKSInstanceProfile:
    __slots__ = [
        'allow_resource_role_bypass',
        'bind_interface',
        'certificate_authority',
        'cluster_name',
        'discovery_enabled',
        'discovery_username',
        'egress_filter',
        'endpoint',
        'healthcheck_namespace',
        'healthy',
        'id',
        'identity_alias_healthcheck_username',
        'identity_set_id',
        'name',
        'port_override',
        'proxy_cluster_id',
        'region',
        'role_arn',
        'role_external_id',
        'secret_store_id',
        'subdomain',
        'tags',
    ]

    def __init__(
        self,
        allow_resource_role_bypass=None,
        bind_interface=None,
        certificate_authority=None,
        cluster_name=None,
        discovery_enabled=None,
        discovery_username=None,
        egress_filter=None,
        endpoint=None,
        healthcheck_namespace=None,
        healthy=None,
        id=None,
        identity_alias_healthcheck_username=None,
        identity_set_id=None,
        name=None,
        port_override=None,
        proxy_cluster_id=None,
        region=None,
        role_arn=None,
        role_external_id=None,
        secret_store_id=None,
        subdomain=None,
        tags=None,
    ):
        self.allow_resource_role_bypass = allow_resource_role_bypass if allow_resource_role_bypass is not None else False
        '''
         If true, allows users to fallback to the existing authentication mode (Leased Credential or Identity Set)
         when a resource role is not provided.
        '''
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided and may also be set to one of the ResourceIPAllocationMode constants to select between VNM, loopback, or default allocation.
        '''
        self.certificate_authority = certificate_authority if certificate_authority is not None else ''
        '''
         The CA to authenticate TLS connections with.
        '''
        self.cluster_name = cluster_name if cluster_name is not None else ''
        '''
         The name of the cluster to connect to.
        '''
        self.discovery_enabled = discovery_enabled if discovery_enabled is not None else False
        '''
         If true, configures discovery of a cluster to be run from a node.
        '''
        self.discovery_username = discovery_username if discovery_username is not None else ''
        '''
         If a cluster is configured for user impersonation, this is the user to impersonate when
         running discovery.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.endpoint = endpoint if endpoint is not None else ''
        '''
         The endpoint to dial.
        '''
        self.healthcheck_namespace = healthcheck_namespace if healthcheck_namespace is not None else ''
        '''
         The path used to check the health of your connection.  Defaults to `default`.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.identity_alias_healthcheck_username = identity_alias_healthcheck_username if identity_alias_healthcheck_username is not None else ''
        '''
         The username to use for healthchecks, when clients otherwise connect with their own identity alias username.
        '''
        self.identity_set_id = identity_set_id if identity_set_id is not None else ''
        '''
         The ID of the identity set to use for identity connections.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.port_override = port_override if port_override is not None else 0
        '''
         The local port used by clients to connect to this resource. It is automatically generated if not provided on create and may be re-generated on update by specifying a value of -1.
        '''
        self.proxy_cluster_id = proxy_cluster_id if proxy_cluster_id is not None else ''
        '''
         ID of the proxy cluster for this resource, if any.
        '''
        self.region = region if region is not None else ''
        '''
         The AWS region to connect to e.g. us-east-1.
        '''
        self.role_arn = role_arn if role_arn is not None else ''
        '''
         The role to assume after logging in.
        '''
        self.role_external_id = role_external_id if role_external_id is not None else ''
        '''
         The external ID to associate with assume role requests. Does nothing if a role ARN is not provided.
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         DNS subdomain through which this resource may be accessed on clients.  (e.g. "app-prod1" allows the resource to be accessed at "app-prod1.your-org-name.sdm-proxy-domain"). Only applicable to HTTP-based resources or resources using virtual networking mode.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''

    def __repr__(self):
        return '<sdm.AmazonEKSInstanceProfile ' + \
            'allow_resource_role_bypass: ' + repr(self.allow_resource_role_bypass) + ' ' +\
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'certificate_authority: ' + repr(self.certificate_authority) + ' ' +\
            'cluster_name: ' + repr(self.cluster_name) + ' ' +\
            'discovery_enabled: ' + repr(self.discovery_enabled) + ' ' +\
            'discovery_username: ' + repr(self.discovery_username) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'endpoint: ' + repr(self.endpoint) + ' ' +\
            'healthcheck_namespace: ' + repr(self.healthcheck_namespace) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'identity_alias_healthcheck_username: ' + repr(self.identity_alias_healthcheck_username) + ' ' +\
            'identity_set_id: ' + repr(self.identity_set_id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'proxy_cluster_id: ' + repr(self.proxy_cluster_id) + ' ' +\
            'region: ' + repr(self.region) + ' ' +\
            'role_arn: ' + repr(self.role_arn) + ' ' +\
            'role_external_id: ' + repr(self.role_external_id) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'allow_resource_role_bypass': self.allow_resource_role_bypass,
            'bind_interface': self.bind_interface,
            'certificate_authority': self.certificate_authority,
            'cluster_name': self.cluster_name,
            'discovery_enabled': self.discovery_enabled,
            'discovery_username': self.discovery_username,
            'egress_filter': self.egress_filter,
            'endpoint': self.endpoint,
            'healthcheck_namespace': self.healthcheck_namespace,
            'healthy': self.healthy,
            'id': self.id,
            'identity_alias_healthcheck_username':
            self.identity_alias_healthcheck_username,
            'identity_set_id': self.identity_set_id,
            'name': self.name,
            'port_override': self.port_override,
            'proxy_cluster_id': self.proxy_cluster_id,
            'region': self.region,
            'role_arn': self.role_arn,
            'role_external_id': self.role_external_id,
            'secret_store_id': self.secret_store_id,
            'subdomain': self.subdomain,
            'tags': self.tags,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            allow_resource_role_bypass=d.get('allow_resource_role_bypass'),
            bind_interface=d.get('bind_interface'),
            certificate_authority=d.get('certificate_authority'),
            cluster_name=d.get('cluster_name'),
            discovery_enabled=d.get('discovery_enabled'),
            discovery_username=d.get('discovery_username'),
            egress_filter=d.get('egress_filter'),
            endpoint=d.get('endpoint'),
            healthcheck_namespace=d.get('healthcheck_namespace'),
            healthy=d.get('healthy'),
            id=d.get('id'),
            identity_alias_healthcheck_username=d.get(
                'identity_alias_healthcheck_username'),
            identity_set_id=d.get('identity_set_id'),
            name=d.get('name'),
            port_override=d.get('port_override'),
            proxy_cluster_id=d.get('proxy_cluster_id'),
            region=d.get('region'),
            role_arn=d.get('role_arn'),
            role_external_id=d.get('role_external_id'),
            secret_store_id=d.get('secret_store_id'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
        )


class AmazonEKSInstanceProfileUserImpersonation:
    '''
    AmazonEKSInstanceProfileUserImpersonation is deprecated, see docs for more info.
    '''
    __slots__ = [
        'bind_interface',
        'certificate_authority',
        'cluster_name',
        'egress_filter',
        'endpoint',
        'healthcheck_namespace',
        'healthy',
        'id',
        'name',
        'port_override',
        'proxy_cluster_id',
        'region',
        'role_arn',
        'role_external_id',
        'secret_store_id',
        'subdomain',
        'tags',
    ]

    def __init__(
        self,
        bind_interface=None,
        certificate_authority=None,
        cluster_name=None,
        egress_filter=None,
        endpoint=None,
        healthcheck_namespace=None,
        healthy=None,
        id=None,
        name=None,
        port_override=None,
        proxy_cluster_id=None,
        region=None,
        role_arn=None,
        role_external_id=None,
        secret_store_id=None,
        subdomain=None,
        tags=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided and may also be set to one of the ResourceIPAllocationMode constants to select between VNM, loopback, or default allocation.
        '''
        self.certificate_authority = certificate_authority if certificate_authority is not None else ''
        '''
         The CA to authenticate TLS connections with.
        '''
        self.cluster_name = cluster_name if cluster_name is not None else ''
        '''
         The name of the cluster to connect to.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.endpoint = endpoint if endpoint is not None else ''
        '''
         The endpoint to dial.
        '''
        self.healthcheck_namespace = healthcheck_namespace if healthcheck_namespace is not None else ''
        '''
         The path used to check the health of your connection.  Defaults to `default`.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.port_override = port_override if port_override is not None else 0
        '''
         The local port used by clients to connect to this resource. It is automatically generated if not provided on create and may be re-generated on update by specifying a value of -1.
        '''
        self.proxy_cluster_id = proxy_cluster_id if proxy_cluster_id is not None else ''
        '''
         ID of the proxy cluster for this resource, if any.
        '''
        self.region = region if region is not None else ''
        '''
         The AWS region to connect to e.g. us-east-1.
        '''
        self.role_arn = role_arn if role_arn is not None else ''
        '''
         The role to assume after logging in.
        '''
        self.role_external_id = role_external_id if role_external_id is not None else ''
        '''
         The external ID to associate with assume role requests. Does nothing if a role ARN is not provided.
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         DNS subdomain through which this resource may be accessed on clients.  (e.g. "app-prod1" allows the resource to be accessed at "app-prod1.your-org-name.sdm-proxy-domain"). Only applicable to HTTP-based resources or resources using virtual networking mode.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''

    def __repr__(self):
        return '<sdm.AmazonEKSInstanceProfileUserImpersonation ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'certificate_authority: ' + repr(self.certificate_authority) + ' ' +\
            'cluster_name: ' + repr(self.cluster_name) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'endpoint: ' + repr(self.endpoint) + ' ' +\
            'healthcheck_namespace: ' + repr(self.healthcheck_namespace) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'proxy_cluster_id: ' + repr(self.proxy_cluster_id) + ' ' +\
            'region: ' + repr(self.region) + ' ' +\
            'role_arn: ' + repr(self.role_arn) + ' ' +\
            'role_external_id: ' + repr(self.role_external_id) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'certificate_authority': self.certificate_authority,
            'cluster_name': self.cluster_name,
            'egress_filter': self.egress_filter,
            'endpoint': self.endpoint,
            'healthcheck_namespace': self.healthcheck_namespace,
            'healthy': self.healthy,
            'id': self.id,
            'name': self.name,
            'port_override': self.port_override,
            'proxy_cluster_id': self.proxy_cluster_id,
            'region': self.region,
            'role_arn': self.role_arn,
            'role_external_id': self.role_external_id,
            'secret_store_id': self.secret_store_id,
            'subdomain': self.subdomain,
            'tags': self.tags,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            certificate_authority=d.get('certificate_authority'),
            cluster_name=d.get('cluster_name'),
            egress_filter=d.get('egress_filter'),
            endpoint=d.get('endpoint'),
            healthcheck_namespace=d.get('healthcheck_namespace'),
            healthy=d.get('healthy'),
            id=d.get('id'),
            name=d.get('name'),
            port_override=d.get('port_override'),
            proxy_cluster_id=d.get('proxy_cluster_id'),
            region=d.get('region'),
            role_arn=d.get('role_arn'),
            role_external_id=d.get('role_external_id'),
            secret_store_id=d.get('secret_store_id'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
        )


class AmazonEKSUserImpersonation:
    '''
    AmazonEKSUserImpersonation is deprecated, see docs for more info.
    '''
    __slots__ = [
        'access_key',
        'bind_interface',
        'certificate_authority',
        'cluster_name',
        'egress_filter',
        'endpoint',
        'healthcheck_namespace',
        'healthy',
        'id',
        'name',
        'port_override',
        'proxy_cluster_id',
        'region',
        'role_arn',
        'role_external_id',
        'secret_access_key',
        'secret_store_id',
        'subdomain',
        'tags',
    ]

    def __init__(
        self,
        access_key=None,
        bind_interface=None,
        certificate_authority=None,
        cluster_name=None,
        egress_filter=None,
        endpoint=None,
        healthcheck_namespace=None,
        healthy=None,
        id=None,
        name=None,
        port_override=None,
        proxy_cluster_id=None,
        region=None,
        role_arn=None,
        role_external_id=None,
        secret_access_key=None,
        secret_store_id=None,
        subdomain=None,
        tags=None,
    ):
        self.access_key = access_key if access_key is not None else ''
        '''
         The Access Key ID to use to authenticate.
        '''
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided and may also be set to one of the ResourceIPAllocationMode constants to select between VNM, loopback, or default allocation.
        '''
        self.certificate_authority = certificate_authority if certificate_authority is not None else ''
        '''
         The CA to authenticate TLS connections with.
        '''
        self.cluster_name = cluster_name if cluster_name is not None else ''
        '''
         The name of the cluster to connect to.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.endpoint = endpoint if endpoint is not None else ''
        '''
         The endpoint to dial.
        '''
        self.healthcheck_namespace = healthcheck_namespace if healthcheck_namespace is not None else ''
        '''
         The path used to check the health of your connection.  Defaults to `default`.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.port_override = port_override if port_override is not None else 0
        '''
         The local port used by clients to connect to this resource. It is automatically generated if not provided on create and may be re-generated on update by specifying a value of -1.
        '''
        self.proxy_cluster_id = proxy_cluster_id if proxy_cluster_id is not None else ''
        '''
         ID of the proxy cluster for this resource, if any.
        '''
        self.region = region if region is not None else ''
        '''
         The AWS region to connect to e.g. us-east-1.
        '''
        self.role_arn = role_arn if role_arn is not None else ''
        '''
         The role to assume after logging in.
        '''
        self.role_external_id = role_external_id if role_external_id is not None else ''
        '''
         The external ID to associate with assume role requests. Does nothing if a role ARN is not provided.
        '''
        self.secret_access_key = secret_access_key if secret_access_key is not None else ''
        '''
         The Secret Access Key to use to authenticate.
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         DNS subdomain through which this resource may be accessed on clients.  (e.g. "app-prod1" allows the resource to be accessed at "app-prod1.your-org-name.sdm-proxy-domain"). Only applicable to HTTP-based resources or resources using virtual networking mode.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''

    def __repr__(self):
        return '<sdm.AmazonEKSUserImpersonation ' + \
            'access_key: ' + repr(self.access_key) + ' ' +\
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'certificate_authority: ' + repr(self.certificate_authority) + ' ' +\
            'cluster_name: ' + repr(self.cluster_name) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'endpoint: ' + repr(self.endpoint) + ' ' +\
            'healthcheck_namespace: ' + repr(self.healthcheck_namespace) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'proxy_cluster_id: ' + repr(self.proxy_cluster_id) + ' ' +\
            'region: ' + repr(self.region) + ' ' +\
            'role_arn: ' + repr(self.role_arn) + ' ' +\
            'role_external_id: ' + repr(self.role_external_id) + ' ' +\
            'secret_access_key: ' + repr(self.secret_access_key) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'access_key': self.access_key,
            'bind_interface': self.bind_interface,
            'certificate_authority': self.certificate_authority,
            'cluster_name': self.cluster_name,
            'egress_filter': self.egress_filter,
            'endpoint': self.endpoint,
            'healthcheck_namespace': self.healthcheck_namespace,
            'healthy': self.healthy,
            'id': self.id,
            'name': self.name,
            'port_override': self.port_override,
            'proxy_cluster_id': self.proxy_cluster_id,
            'region': self.region,
            'role_arn': self.role_arn,
            'role_external_id': self.role_external_id,
            'secret_access_key': self.secret_access_key,
            'secret_store_id': self.secret_store_id,
            'subdomain': self.subdomain,
            'tags': self.tags,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            access_key=d.get('access_key'),
            bind_interface=d.get('bind_interface'),
            certificate_authority=d.get('certificate_authority'),
            cluster_name=d.get('cluster_name'),
            egress_filter=d.get('egress_filter'),
            endpoint=d.get('endpoint'),
            healthcheck_namespace=d.get('healthcheck_namespace'),
            healthy=d.get('healthy'),
            id=d.get('id'),
            name=d.get('name'),
            port_override=d.get('port_override'),
            proxy_cluster_id=d.get('proxy_cluster_id'),
            region=d.get('region'),
            role_arn=d.get('role_arn'),
            role_external_id=d.get('role_external_id'),
            secret_access_key=d.get('secret_access_key'),
            secret_store_id=d.get('secret_store_id'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
        )


class AmazonES:
    __slots__ = [
        'access_key',
        'bind_interface',
        'egress_filter',
        'endpoint',
        'healthy',
        'id',
        'name',
        'port_override',
        'proxy_cluster_id',
        'region',
        'role_arn',
        'role_external_id',
        'secret_access_key',
        'secret_store_id',
        'subdomain',
        'tags',
    ]

    def __init__(
        self,
        access_key=None,
        bind_interface=None,
        egress_filter=None,
        endpoint=None,
        healthy=None,
        id=None,
        name=None,
        port_override=None,
        proxy_cluster_id=None,
        region=None,
        role_arn=None,
        role_external_id=None,
        secret_access_key=None,
        secret_store_id=None,
        subdomain=None,
        tags=None,
    ):
        self.access_key = access_key if access_key is not None else ''
        '''
         The Access Key ID to use to authenticate.
        '''
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided and may also be set to one of the ResourceIPAllocationMode constants to select between VNM, loopback, or default allocation.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.endpoint = endpoint if endpoint is not None else ''
        '''
         The endpoint to dial e.g. search-?.region.es.amazonaws.com"
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.port_override = port_override if port_override is not None else 0
        '''
         The local port used by clients to connect to this resource. It is automatically generated if not provided on create and may be re-generated on update by specifying a value of -1.
        '''
        self.proxy_cluster_id = proxy_cluster_id if proxy_cluster_id is not None else ''
        '''
         ID of the proxy cluster for this resource, if any.
        '''
        self.region = region if region is not None else ''
        '''
         The AWS region to connect to e.g. us-east-1.
        '''
        self.role_arn = role_arn if role_arn is not None else ''
        '''
         The role to assume after logging in.
        '''
        self.role_external_id = role_external_id if role_external_id is not None else ''
        '''
         The external ID to associate with assume role requests. Does nothing if a role ARN is not provided.
        '''
        self.secret_access_key = secret_access_key if secret_access_key is not None else ''
        '''
         The Secret Access Key to use to authenticate.
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         DNS subdomain through which this resource may be accessed on clients.  (e.g. "app-prod1" allows the resource to be accessed at "app-prod1.your-org-name.sdm-proxy-domain"). Only applicable to HTTP-based resources or resources using virtual networking mode.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''

    def __repr__(self):
        return '<sdm.AmazonES ' + \
            'access_key: ' + repr(self.access_key) + ' ' +\
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'endpoint: ' + repr(self.endpoint) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'proxy_cluster_id: ' + repr(self.proxy_cluster_id) + ' ' +\
            'region: ' + repr(self.region) + ' ' +\
            'role_arn: ' + repr(self.role_arn) + ' ' +\
            'role_external_id: ' + repr(self.role_external_id) + ' ' +\
            'secret_access_key: ' + repr(self.secret_access_key) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'access_key': self.access_key,
            'bind_interface': self.bind_interface,
            'egress_filter': self.egress_filter,
            'endpoint': self.endpoint,
            'healthy': self.healthy,
            'id': self.id,
            'name': self.name,
            'port_override': self.port_override,
            'proxy_cluster_id': self.proxy_cluster_id,
            'region': self.region,
            'role_arn': self.role_arn,
            'role_external_id': self.role_external_id,
            'secret_access_key': self.secret_access_key,
            'secret_store_id': self.secret_store_id,
            'subdomain': self.subdomain,
            'tags': self.tags,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            access_key=d.get('access_key'),
            bind_interface=d.get('bind_interface'),
            egress_filter=d.get('egress_filter'),
            endpoint=d.get('endpoint'),
            healthy=d.get('healthy'),
            id=d.get('id'),
            name=d.get('name'),
            port_override=d.get('port_override'),
            proxy_cluster_id=d.get('proxy_cluster_id'),
            region=d.get('region'),
            role_arn=d.get('role_arn'),
            role_external_id=d.get('role_external_id'),
            secret_access_key=d.get('secret_access_key'),
            secret_store_id=d.get('secret_store_id'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
        )


class AmazonESIAM:
    __slots__ = [
        'bind_interface',
        'egress_filter',
        'endpoint',
        'healthy',
        'id',
        'name',
        'port_override',
        'proxy_cluster_id',
        'region',
        'role_arn',
        'role_external_id',
        'secret_store_id',
        'subdomain',
        'tags',
        'tlsrequired',
    ]

    def __init__(
        self,
        bind_interface=None,
        egress_filter=None,
        endpoint=None,
        healthy=None,
        id=None,
        name=None,
        port_override=None,
        proxy_cluster_id=None,
        region=None,
        role_arn=None,
        role_external_id=None,
        secret_store_id=None,
        subdomain=None,
        tags=None,
        tlsrequired=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided and may also be set to one of the ResourceIPAllocationMode constants to select between VNM, loopback, or default allocation.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.endpoint = endpoint if endpoint is not None else ''
        '''
         The endpoint to dial e.g. search-?.region.es.amazonaws.com"
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.port_override = port_override if port_override is not None else 0
        '''
         The local port used by clients to connect to this resource. It is automatically generated if not provided on create and may be re-generated on update by specifying a value of -1.
        '''
        self.proxy_cluster_id = proxy_cluster_id if proxy_cluster_id is not None else ''
        '''
         ID of the proxy cluster for this resource, if any.
        '''
        self.region = region if region is not None else ''
        '''
         The AWS region to connect to.
        '''
        self.role_arn = role_arn if role_arn is not None else ''
        '''
         The role to assume after logging in.
        '''
        self.role_external_id = role_external_id if role_external_id is not None else ''
        '''
         The external ID to associate with assume role requests. Does nothing if a role ARN is not provided.
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         DNS subdomain through which this resource may be accessed on clients.  (e.g. "app-prod1" allows the resource to be accessed at "app-prod1.your-org-name.sdm-proxy-domain"). Only applicable to HTTP-based resources or resources using virtual networking mode.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.tlsrequired = tlsrequired if tlsrequired is not None else False
        '''
         Use TLS to connect to the OpenSearch server
        '''

    def __repr__(self):
        return '<sdm.AmazonESIAM ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'endpoint: ' + repr(self.endpoint) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'proxy_cluster_id: ' + repr(self.proxy_cluster_id) + ' ' +\
            'region: ' + repr(self.region) + ' ' +\
            'role_arn: ' + repr(self.role_arn) + ' ' +\
            'role_external_id: ' + repr(self.role_external_id) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'tlsrequired: ' + repr(self.tlsrequired) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'egress_filter': self.egress_filter,
            'endpoint': self.endpoint,
            'healthy': self.healthy,
            'id': self.id,
            'name': self.name,
            'port_override': self.port_override,
            'proxy_cluster_id': self.proxy_cluster_id,
            'region': self.region,
            'role_arn': self.role_arn,
            'role_external_id': self.role_external_id,
            'secret_store_id': self.secret_store_id,
            'subdomain': self.subdomain,
            'tags': self.tags,
            'tlsrequired': self.tlsrequired,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            egress_filter=d.get('egress_filter'),
            endpoint=d.get('endpoint'),
            healthy=d.get('healthy'),
            id=d.get('id'),
            name=d.get('name'),
            port_override=d.get('port_override'),
            proxy_cluster_id=d.get('proxy_cluster_id'),
            region=d.get('region'),
            role_arn=d.get('role_arn'),
            role_external_id=d.get('role_external_id'),
            secret_store_id=d.get('secret_store_id'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
            tlsrequired=d.get('tlsrequired'),
        )


class AmazonMQAMQP091:
    __slots__ = [
        'bind_interface',
        'egress_filter',
        'healthy',
        'hostname',
        'id',
        'name',
        'password',
        'port',
        'port_override',
        'proxy_cluster_id',
        'secret_store_id',
        'subdomain',
        'tags',
        'tls_required',
        'username',
    ]

    def __init__(
        self,
        bind_interface=None,
        egress_filter=None,
        healthy=None,
        hostname=None,
        id=None,
        name=None,
        password=None,
        port=None,
        port_override=None,
        proxy_cluster_id=None,
        secret_store_id=None,
        subdomain=None,
        tags=None,
        tls_required=None,
        username=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided and may also be set to one of the ResourceIPAllocationMode constants to select between VNM, loopback, or default allocation.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        '''
         The host to dial to initiate a connection from the egress node to this resource.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.password = password if password is not None else ''
        '''
         The password to authenticate with.
        '''
        self.port = port if port is not None else 0
        '''
         The port to dial to initiate a connection from the egress node to this resource.
        '''
        self.port_override = port_override if port_override is not None else 0
        '''
         The local port used by clients to connect to this resource. It is automatically generated if not provided on create and may be re-generated on update by specifying a value of -1.
        '''
        self.proxy_cluster_id = proxy_cluster_id if proxy_cluster_id is not None else ''
        '''
         ID of the proxy cluster for this resource, if any.
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         DNS subdomain through which this resource may be accessed on clients.  (e.g. "app-prod1" allows the resource to be accessed at "app-prod1.your-org-name.sdm-proxy-domain"). Only applicable to HTTP-based resources or resources using virtual networking mode.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.tls_required = tls_required if tls_required is not None else False
        '''
         If set, TLS must be used to connect to this resource.
        '''
        self.username = username if username is not None else ''
        '''
         The username to authenticate with.
        '''

    def __repr__(self):
        return '<sdm.AmazonMQAMQP091 ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'password: ' + repr(self.password) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'proxy_cluster_id: ' + repr(self.proxy_cluster_id) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'tls_required: ' + repr(self.tls_required) + ' ' +\
            'username: ' + repr(self.username) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'egress_filter': self.egress_filter,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'name': self.name,
            'password': self.password,
            'port': self.port,
            'port_override': self.port_override,
            'proxy_cluster_id': self.proxy_cluster_id,
            'secret_store_id': self.secret_store_id,
            'subdomain': self.subdomain,
            'tags': self.tags,
            'tls_required': self.tls_required,
            'username': self.username,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            egress_filter=d.get('egress_filter'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            name=d.get('name'),
            password=d.get('password'),
            port=d.get('port'),
            port_override=d.get('port_override'),
            proxy_cluster_id=d.get('proxy_cluster_id'),
            secret_store_id=d.get('secret_store_id'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
            tls_required=d.get('tls_required'),
            username=d.get('username'),
        )


class ApprovalFlowApprover:
    '''
         An approver for an approval workflow step. Each approver can specify exactly one of: account_id, role_id, or reference
    '''
    __slots__ = [
        'account_id',
        'group_id',
        'reference',
        'role_id',
    ]

    def __init__(
        self,
        account_id=None,
        group_id=None,
        reference=None,
        role_id=None,
    ):
        self.account_id = account_id if account_id is not None else ''
        '''
         The approver account id.
        '''
        self.group_id = group_id if group_id is not None else ''
        '''
         The approver group id
        '''
        self.reference = reference if reference is not None else ''
        '''
         A reference to an approver. Must be one of ApproverReference constants.
         If set, the account_id and role_id must be empty.
        '''
        self.role_id = role_id if role_id is not None else ''
        '''
         The approver role id
        '''

    def __repr__(self):
        return '<sdm.ApprovalFlowApprover ' + \
            'account_id: ' + repr(self.account_id) + ' ' +\
            'group_id: ' + repr(self.group_id) + ' ' +\
            'reference: ' + repr(self.reference) + ' ' +\
            'role_id: ' + repr(self.role_id) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'account_id': self.account_id,
            'group_id': self.group_id,
            'reference': self.reference,
            'role_id': self.role_id,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            account_id=d.get('account_id'),
            group_id=d.get('group_id'),
            reference=d.get('reference'),
            role_id=d.get('role_id'),
        )


class ApprovalFlowStep:
    '''
         An approval step for an approval workflow. Specifies approvers and conditions for approval to be granted.
    '''
    __slots__ = [
        'approvers',
        'quantifier',
        'skip_after',
    ]

    def __init__(
        self,
        approvers=None,
        quantifier=None,
        skip_after=None,
    ):
        self.approvers = approvers if approvers is not None else []
        '''
         The approvers for this approval step
        '''
        self.quantifier = quantifier if quantifier is not None else ''
        '''
         Whether "any" or "all" approvers must approve for this approval step to pass. Optional, defaults to "any".
        '''
        self.skip_after = skip_after if skip_after is not None else None
        '''
         Duration after which this approval step will be skipped if no approval is given. Optional, if not provided an approver must approve before the step passes.
        '''

    def __repr__(self):
        return '<sdm.ApprovalFlowStep ' + \
            'approvers: ' + repr(self.approvers) + ' ' +\
            'quantifier: ' + repr(self.quantifier) + ' ' +\
            'skip_after: ' + repr(self.skip_after) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'approvers': self.approvers,
            'quantifier': self.quantifier,
            'skip_after': self.skip_after,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            approvers=d.get('approvers'),
            quantifier=d.get('quantifier'),
            skip_after=d.get('skip_after'),
        )


class ApprovalWorkflow:
    '''
         ApprovalWorkflows are the mechanism by which requests for access can be viewed by authorized
     approvers and be approved or denied.
    '''
    __slots__ = [
        'approval_mode',
        'approval_workflow_steps',
        'description',
        'id',
        'name',
    ]

    def __init__(
        self,
        approval_mode=None,
        approval_workflow_steps=None,
        description=None,
        id=None,
        name=None,
    ):
        self.approval_mode = approval_mode if approval_mode is not None else ''
        '''
         Approval mode of the ApprovalWorkflow
        '''
        self.approval_workflow_steps = approval_workflow_steps if approval_workflow_steps is not None else []
        '''
         The approval steps of this approval workflow
        '''
        self.description = description if description is not None else ''
        '''
         Optional description of the ApprovalWorkflow.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the ApprovalWorkflow.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the ApprovalWorkflow.
        '''

    def __repr__(self):
        return '<sdm.ApprovalWorkflow ' + \
            'approval_mode: ' + repr(self.approval_mode) + ' ' +\
            'approval_workflow_steps: ' + repr(self.approval_workflow_steps) + ' ' +\
            'description: ' + repr(self.description) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'approval_mode': self.approval_mode,
            'approval_workflow_steps': self.approval_workflow_steps,
            'description': self.description,
            'id': self.id,
            'name': self.name,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            approval_mode=d.get('approval_mode'),
            approval_workflow_steps=d.get('approval_workflow_steps'),
            description=d.get('description'),
            id=d.get('id'),
            name=d.get('name'),
        )


class ApprovalWorkflowApprover:
    '''
         ApprovalWorkflowApprover links an approval workflow approver to an ApprovalWorkflowStep
    ApprovalWorkflowApprover is deprecated, see docs for more info.
    '''
    __slots__ = [
        'account_id',
        'approval_flow_id',
        'approval_step_id',
        'id',
        'reference',
        'role_id',
    ]

    def __init__(
        self,
        account_id=None,
        approval_flow_id=None,
        approval_step_id=None,
        id=None,
        reference=None,
        role_id=None,
    ):
        self.account_id = account_id if account_id is not None else ''
        '''
         The approver account id.
        '''
        self.approval_flow_id = approval_flow_id if approval_flow_id is not None else ''
        '''
         The approval flow id specified the approval workflow that this approver belongs to
        '''
        self.approval_step_id = approval_step_id if approval_step_id is not None else ''
        '''
         The approval step id specified the approval flow step that this approver belongs to
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the ApprovalWorkflowApprover.
        '''
        self.reference = reference if reference is not None else ''
        '''
         A reference to an approver. Will be one of ApproverReference constants.
         This field is only populated when reading historical Approval Workflow Approvers data through the Approval Workflows History API.
         For the deprecated Approval Workflow Approvers API no value is returned for this field and it is non-settable.
        '''
        self.role_id = role_id if role_id is not None else ''
        '''
         The approver role id
        '''

    def __repr__(self):
        return '<sdm.ApprovalWorkflowApprover ' + \
            'account_id: ' + repr(self.account_id) + ' ' +\
            'approval_flow_id: ' + repr(self.approval_flow_id) + ' ' +\
            'approval_step_id: ' + repr(self.approval_step_id) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'reference: ' + repr(self.reference) + ' ' +\
            'role_id: ' + repr(self.role_id) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'account_id': self.account_id,
            'approval_flow_id': self.approval_flow_id,
            'approval_step_id': self.approval_step_id,
            'id': self.id,
            'reference': self.reference,
            'role_id': self.role_id,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            account_id=d.get('account_id'),
            approval_flow_id=d.get('approval_flow_id'),
            approval_step_id=d.get('approval_step_id'),
            id=d.get('id'),
            reference=d.get('reference'),
            role_id=d.get('role_id'),
        )


class ApprovalWorkflowApproverCreateResponse:
    '''
         ApprovalWorkflowApproverCreateResponse reports how the ApprovalWorkflowApprover was created in the system.
    '''
    __slots__ = [
        'approval_workflow_approver',
        'rate_limit',
    ]

    def __init__(
        self,
        approval_workflow_approver=None,
        rate_limit=None,
    ):
        self.approval_workflow_approver = approval_workflow_approver if approval_workflow_approver is not None else None
        '''
         The created approval workflow approver.
        '''
        self.rate_limit = rate_limit if rate_limit is not None else None
        '''
         Rate limit information.
        '''

    def __repr__(self):
        return '<sdm.ApprovalWorkflowApproverCreateResponse ' + \
            'approval_workflow_approver: ' + repr(self.approval_workflow_approver) + ' ' +\
            'rate_limit: ' + repr(self.rate_limit) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'approval_workflow_approver': self.approval_workflow_approver,
            'rate_limit': self.rate_limit,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            approval_workflow_approver=d.get('approval_workflow_approver'),
            rate_limit=d.get('rate_limit'),
        )


class ApprovalWorkflowApproverDeleteResponse:
    '''
         ApprovalWorkflowApproverDeleteResponse returns information about an ApprovalWorkflowApprover that was deleted.
    '''
    __slots__ = [
        'id',
        'rate_limit',
    ]

    def __init__(
        self,
        id=None,
        rate_limit=None,
    ):
        self.id = id if id is not None else ''
        '''
         The deleted approval workflow approver id.
        '''
        self.rate_limit = rate_limit if rate_limit is not None else None
        '''
         Rate limit information.
        '''

    def __repr__(self):
        return '<sdm.ApprovalWorkflowApproverDeleteResponse ' + \
            'id: ' + repr(self.id) + ' ' +\
            'rate_limit: ' + repr(self.rate_limit) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'id': self.id,
            'rate_limit': self.rate_limit,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            id=d.get('id'),
            rate_limit=d.get('rate_limit'),
        )


class ApprovalWorkflowApproverGetResponse:
    '''
         ApprovalWorkflowApproverGetResponse returns a requested ApprovalWorkflowApprover.
    '''
    __slots__ = [
        'approval_workflow_approver',
        'meta',
        'rate_limit',
    ]

    def __init__(
        self,
        approval_workflow_approver=None,
        meta=None,
        rate_limit=None,
    ):
        self.approval_workflow_approver = approval_workflow_approver if approval_workflow_approver is not None else None
        '''
         The requested ApprovalWorkflowApprover.
        '''
        self.meta = meta if meta is not None else None
        '''
         Reserved for future use.
        '''
        self.rate_limit = rate_limit if rate_limit is not None else None
        '''
         Rate limit information.
        '''

    def __repr__(self):
        return '<sdm.ApprovalWorkflowApproverGetResponse ' + \
            'approval_workflow_approver: ' + repr(self.approval_workflow_approver) + ' ' +\
            'meta: ' + repr(self.meta) + ' ' +\
            'rate_limit: ' + repr(self.rate_limit) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'approval_workflow_approver': self.approval_workflow_approver,
            'meta': self.meta,
            'rate_limit': self.rate_limit,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            approval_workflow_approver=d.get('approval_workflow_approver'),
            meta=d.get('meta'),
            rate_limit=d.get('rate_limit'),
        )


class ApprovalWorkflowApproverHistory:
    '''
         ApprovalWorkflowApproverHistory records the state of an ApprovalWorkflowApprover at a given point in time,
     where every change (create or delete) to an ApprovalWorkflowApprover produces an
     ApprovalWorkflowApproverHistory record.
    '''
    __slots__ = [
        'activity_id',
        'approval_workflow_approver',
        'deleted_at',
        'timestamp',
    ]

    def __init__(
        self,
        activity_id=None,
        approval_workflow_approver=None,
        deleted_at=None,
        timestamp=None,
    ):
        self.activity_id = activity_id if activity_id is not None else ''
        '''
         The unique identifier of the Activity that produced this change to the ApprovalWorkflowApprover.
         May be empty for some system-initiated updates.
        '''
        self.approval_workflow_approver = approval_workflow_approver if approval_workflow_approver is not None else None
        '''
         The complete ApprovalWorkflowApprover state at this time.
        '''
        self.deleted_at = deleted_at if deleted_at is not None else None
        '''
         If this ApprovalWorkflowApprover was deleted, the time it was deleted.
        '''
        self.timestamp = timestamp if timestamp is not None else None
        '''
         The time at which the ApprovalWorkflowApprover state was recorded.
        '''

    def __repr__(self):
        return '<sdm.ApprovalWorkflowApproverHistory ' + \
            'activity_id: ' + repr(self.activity_id) + ' ' +\
            'approval_workflow_approver: ' + repr(self.approval_workflow_approver) + ' ' +\
            'deleted_at: ' + repr(self.deleted_at) + ' ' +\
            'timestamp: ' + repr(self.timestamp) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'activity_id': self.activity_id,
            'approval_workflow_approver': self.approval_workflow_approver,
            'deleted_at': self.deleted_at,
            'timestamp': self.timestamp,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            activity_id=d.get('activity_id'),
            approval_workflow_approver=d.get('approval_workflow_approver'),
            deleted_at=d.get('deleted_at'),
            timestamp=d.get('timestamp'),
        )


class ApprovalWorkflowApproverListResponse:
    '''
         ApprovalWorkflowApproverListResponse returns a list of ApprovalWorkflowApprover records that meet
     the criteria of an ApprovalWorkflowApproverListRequest.
    '''
    __slots__ = [
        'rate_limit',
    ]

    def __init__(
        self,
        rate_limit=None,
    ):
        self.rate_limit = rate_limit if rate_limit is not None else None
        '''
         Rate limit information.
        '''

    def __repr__(self):
        return '<sdm.ApprovalWorkflowApproverListResponse ' + \
            'rate_limit: ' + repr(self.rate_limit) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'rate_limit': self.rate_limit,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(rate_limit=d.get('rate_limit'), )


class ApprovalWorkflowCreateResponse:
    '''
         ApprovalWorkflowCreateResponse reports how the ApprovalWorkflow was created in the system.
    '''
    __slots__ = [
        'approval_workflow',
        'rate_limit',
    ]

    def __init__(
        self,
        approval_workflow=None,
        rate_limit=None,
    ):
        self.approval_workflow = approval_workflow if approval_workflow is not None else None
        '''
         The created approval workflow.
        '''
        self.rate_limit = rate_limit if rate_limit is not None else None
        '''
         Rate limit information.
        '''

    def __repr__(self):
        return '<sdm.ApprovalWorkflowCreateResponse ' + \
            'approval_workflow: ' + repr(self.approval_workflow) + ' ' +\
            'rate_limit: ' + repr(self.rate_limit) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'approval_workflow': self.approval_workflow,
            'rate_limit': self.rate_limit,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            approval_workflow=d.get('approval_workflow'),
            rate_limit=d.get('rate_limit'),
        )


class ApprovalWorkflowDeleteResponse:
    '''
         ApprovalWorkflowDeleteResponse returns information about an ApprovalWorkflow that was deleted.
    '''
    __slots__ = [
        'id',
        'rate_limit',
    ]

    def __init__(
        self,
        id=None,
        rate_limit=None,
    ):
        self.id = id if id is not None else ''
        '''
         The deleted approval workflow id.
        '''
        self.rate_limit = rate_limit if rate_limit is not None else None
        '''
         Rate limit information.
        '''

    def __repr__(self):
        return '<sdm.ApprovalWorkflowDeleteResponse ' + \
            'id: ' + repr(self.id) + ' ' +\
            'rate_limit: ' + repr(self.rate_limit) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'id': self.id,
            'rate_limit': self.rate_limit,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            id=d.get('id'),
            rate_limit=d.get('rate_limit'),
        )


class ApprovalWorkflowGetResponse:
    '''
         ApprovalWorkflowGetResponse returns a requested ApprovalWorkflow.
    '''
    __slots__ = [
        'approval_workflow',
        'meta',
        'rate_limit',
    ]

    def __init__(
        self,
        approval_workflow=None,
        meta=None,
        rate_limit=None,
    ):
        self.approval_workflow = approval_workflow if approval_workflow is not None else None
        '''
         The requested ApprovalWorkflow.
        '''
        self.meta = meta if meta is not None else None
        '''
         Reserved for future use.
        '''
        self.rate_limit = rate_limit if rate_limit is not None else None
        '''
         Rate limit information.
        '''

    def __repr__(self):
        return '<sdm.ApprovalWorkflowGetResponse ' + \
            'approval_workflow: ' + repr(self.approval_workflow) + ' ' +\
            'meta: ' + repr(self.meta) + ' ' +\
            'rate_limit: ' + repr(self.rate_limit) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'approval_workflow': self.approval_workflow,
            'meta': self.meta,
            'rate_limit': self.rate_limit,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            approval_workflow=d.get('approval_workflow'),
            meta=d.get('meta'),
            rate_limit=d.get('rate_limit'),
        )


class ApprovalWorkflowHistory:
    '''
         ApprovalWorkflowHistory records the state of an ApprovalWorkflow at a given point in time,
     where every change (create, update and delete) to an ApprovalWorkflow produces an
     ApprovalWorkflowHistory record.
    '''
    __slots__ = [
        'activity_id',
        'approval_workflow',
        'deleted_at',
        'timestamp',
    ]

    def __init__(
        self,
        activity_id=None,
        approval_workflow=None,
        deleted_at=None,
        timestamp=None,
    ):
        self.activity_id = activity_id if activity_id is not None else ''
        '''
         The unique identifier of the Activity that produced this change to the ApprovalWorkflow.
         May be empty for some system-initiated updates.
        '''
        self.approval_workflow = approval_workflow if approval_workflow is not None else None
        '''
         The complete ApprovalWorkflow state at this time.
        '''
        self.deleted_at = deleted_at if deleted_at is not None else None
        '''
         If this ApprovalWorkflow was deleted, the time it was deleted.
        '''
        self.timestamp = timestamp if timestamp is not None else None
        '''
         The time at which the ApprovalWorkflow state was recorded.
        '''

    def __repr__(self):
        return '<sdm.ApprovalWorkflowHistory ' + \
            'activity_id: ' + repr(self.activity_id) + ' ' +\
            'approval_workflow: ' + repr(self.approval_workflow) + ' ' +\
            'deleted_at: ' + repr(self.deleted_at) + ' ' +\
            'timestamp: ' + repr(self.timestamp) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'activity_id': self.activity_id,
            'approval_workflow': self.approval_workflow,
            'deleted_at': self.deleted_at,
            'timestamp': self.timestamp,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            activity_id=d.get('activity_id'),
            approval_workflow=d.get('approval_workflow'),
            deleted_at=d.get('deleted_at'),
            timestamp=d.get('timestamp'),
        )


class ApprovalWorkflowListResponse:
    '''
         ApprovalWorkflowListResponse returns a list of ApprovalWorkflow records that meet
     the criteria of an ApprovalWorkflowListRequest.
    '''
    __slots__ = [
        'rate_limit',
    ]

    def __init__(
        self,
        rate_limit=None,
    ):
        self.rate_limit = rate_limit if rate_limit is not None else None
        '''
         Rate limit information.
        '''

    def __repr__(self):
        return '<sdm.ApprovalWorkflowListResponse ' + \
            'rate_limit: ' + repr(self.rate_limit) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'rate_limit': self.rate_limit,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(rate_limit=d.get('rate_limit'), )


class ApprovalWorkflowStep:
    '''
         ApprovalWorkflowStep links an approval workflow step to an ApprovalWorkflow
    ApprovalWorkflowStep is deprecated, see docs for more info.
    '''
    __slots__ = [
        'approval_flow_id',
        'id',
        'quantifier',
        'skip_after',
        'step_order',
    ]

    def __init__(
        self,
        approval_flow_id=None,
        id=None,
        quantifier=None,
        skip_after=None,
        step_order=None,
    ):
        self.approval_flow_id = approval_flow_id if approval_flow_id is not None else ''
        '''
         The approval flow id specified the approval workflow that this step belongs to
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the ApprovalWorkflowStep.
        '''
        self.quantifier = quantifier if quantifier is not None else ''
        '''
         Whether "any" or "all" approvers must approve for this approval step to pass. Read only field for history commands.
        '''
        self.skip_after = skip_after if skip_after is not None else None
        '''
         Duration after which this approval step will be skipped if no approval is given. Read only field for history commands.
        '''
        self.step_order = step_order if step_order is not None else 0
        '''
         The position of the approval step in a sequence of approval steps for an approval workflow. Read only field for history commands.
        '''

    def __repr__(self):
        return '<sdm.ApprovalWorkflowStep ' + \
            'approval_flow_id: ' + repr(self.approval_flow_id) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'quantifier: ' + repr(self.quantifier) + ' ' +\
            'skip_after: ' + repr(self.skip_after) + ' ' +\
            'step_order: ' + repr(self.step_order) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'approval_flow_id': self.approval_flow_id,
            'id': self.id,
            'quantifier': self.quantifier,
            'skip_after': self.skip_after,
            'step_order': self.step_order,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            approval_flow_id=d.get('approval_flow_id'),
            id=d.get('id'),
            quantifier=d.get('quantifier'),
            skip_after=d.get('skip_after'),
            step_order=d.get('step_order'),
        )


class ApprovalWorkflowStepCreateResponse:
    '''
         ApprovalWorkflowStepCreateResponse reports how the ApprovalWorkflowStep was created in the system.
    '''
    __slots__ = [
        'approval_workflow_step',
        'rate_limit',
    ]

    def __init__(
        self,
        approval_workflow_step=None,
        rate_limit=None,
    ):
        self.approval_workflow_step = approval_workflow_step if approval_workflow_step is not None else None
        '''
         The created approval workflow step.
        '''
        self.rate_limit = rate_limit if rate_limit is not None else None
        '''
         Rate limit information.
        '''

    def __repr__(self):
        return '<sdm.ApprovalWorkflowStepCreateResponse ' + \
            'approval_workflow_step: ' + repr(self.approval_workflow_step) + ' ' +\
            'rate_limit: ' + repr(self.rate_limit) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'approval_workflow_step': self.approval_workflow_step,
            'rate_limit': self.rate_limit,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            approval_workflow_step=d.get('approval_workflow_step'),
            rate_limit=d.get('rate_limit'),
        )


class ApprovalWorkflowStepDeleteResponse:
    '''
         ApprovalWorkflowStepDeleteResponse returns information about an ApprovalWorkflowStep that was deleted.
    '''
    __slots__ = [
        'id',
        'rate_limit',
    ]

    def __init__(
        self,
        id=None,
        rate_limit=None,
    ):
        self.id = id if id is not None else ''
        '''
         The deleted approval workflow step id.
        '''
        self.rate_limit = rate_limit if rate_limit is not None else None
        '''
         Rate limit information.
        '''

    def __repr__(self):
        return '<sdm.ApprovalWorkflowStepDeleteResponse ' + \
            'id: ' + repr(self.id) + ' ' +\
            'rate_limit: ' + repr(self.rate_limit) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'id': self.id,
            'rate_limit': self.rate_limit,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            id=d.get('id'),
            rate_limit=d.get('rate_limit'),
        )


class ApprovalWorkflowStepGetResponse:
    '''
         ApprovalWorkflowStepGetResponse returns a requested ApprovalWorkflowStep.
    '''
    __slots__ = [
        'approval_workflow_step',
        'meta',
        'rate_limit',
    ]

    def __init__(
        self,
        approval_workflow_step=None,
        meta=None,
        rate_limit=None,
    ):
        self.approval_workflow_step = approval_workflow_step if approval_workflow_step is not None else None
        '''
         The requested ApprovalWorkflowStep.
        '''
        self.meta = meta if meta is not None else None
        '''
         Reserved for future use.
        '''
        self.rate_limit = rate_limit if rate_limit is not None else None
        '''
         Rate limit information.
        '''

    def __repr__(self):
        return '<sdm.ApprovalWorkflowStepGetResponse ' + \
            'approval_workflow_step: ' + repr(self.approval_workflow_step) + ' ' +\
            'meta: ' + repr(self.meta) + ' ' +\
            'rate_limit: ' + repr(self.rate_limit) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'approval_workflow_step': self.approval_workflow_step,
            'meta': self.meta,
            'rate_limit': self.rate_limit,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            approval_workflow_step=d.get('approval_workflow_step'),
            meta=d.get('meta'),
            rate_limit=d.get('rate_limit'),
        )


class ApprovalWorkflowStepHistory:
    '''
         ApprovalWorkflowStepHistory records the state of an ApprovalWorkflowStep at a given point in time,
     where every change (create or delete) to an ApprovalWorkflowStep produces an
     ApprovalWorkflowStepHistory record.
    '''
    __slots__ = [
        'activity_id',
        'approval_workflow_step',
        'deleted_at',
        'timestamp',
    ]

    def __init__(
        self,
        activity_id=None,
        approval_workflow_step=None,
        deleted_at=None,
        timestamp=None,
    ):
        self.activity_id = activity_id if activity_id is not None else ''
        '''
         The unique identifier of the Activity that produced this change to the ApprovalWorkflowStep.
         May be empty for some system-initiated updates.
        '''
        self.approval_workflow_step = approval_workflow_step if approval_workflow_step is not None else None
        '''
         The complete ApprovalWorkflowStep state at this time.
        '''
        self.deleted_at = deleted_at if deleted_at is not None else None
        '''
         If this ApprovalWorkflowStep was deleted, the time it was deleted.
        '''
        self.timestamp = timestamp if timestamp is not None else None
        '''
         The time at which the ApprovalWorkflowStep state was recorded.
        '''

    def __repr__(self):
        return '<sdm.ApprovalWorkflowStepHistory ' + \
            'activity_id: ' + repr(self.activity_id) + ' ' +\
            'approval_workflow_step: ' + repr(self.approval_workflow_step) + ' ' +\
            'deleted_at: ' + repr(self.deleted_at) + ' ' +\
            'timestamp: ' + repr(self.timestamp) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'activity_id': self.activity_id,
            'approval_workflow_step': self.approval_workflow_step,
            'deleted_at': self.deleted_at,
            'timestamp': self.timestamp,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            activity_id=d.get('activity_id'),
            approval_workflow_step=d.get('approval_workflow_step'),
            deleted_at=d.get('deleted_at'),
            timestamp=d.get('timestamp'),
        )


class ApprovalWorkflowStepListResponse:
    '''
         ApprovalWorkflowStepListResponse returns a list of ApprovalWorkflowStep records that meet
     the criteria of an ApprovalWorkflowStepListRequest.
    '''
    __slots__ = [
        'rate_limit',
    ]

    def __init__(
        self,
        rate_limit=None,
    ):
        self.rate_limit = rate_limit if rate_limit is not None else None
        '''
         Rate limit information.
        '''

    def __repr__(self):
        return '<sdm.ApprovalWorkflowStepListResponse ' + \
            'rate_limit: ' + repr(self.rate_limit) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'rate_limit': self.rate_limit,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(rate_limit=d.get('rate_limit'), )


class ApprovalWorkflowUpdateResponse:
    '''
         ApprovalWorkflowUpdateResponse returns the fields of an ApprovalWorkflow after it has been updated by
     an ApprovalWorkflowUpdateRequest.
    '''
    __slots__ = [
        'approval_workflow',
        'rate_limit',
    ]

    def __init__(
        self,
        approval_workflow=None,
        rate_limit=None,
    ):
        self.approval_workflow = approval_workflow if approval_workflow is not None else None
        '''
         The updated approval workflow.
        '''
        self.rate_limit = rate_limit if rate_limit is not None else None
        '''
         Rate limit information.
        '''

    def __repr__(self):
        return '<sdm.ApprovalWorkflowUpdateResponse ' + \
            'approval_workflow: ' + repr(self.approval_workflow) + ' ' +\
            'rate_limit: ' + repr(self.rate_limit) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'approval_workflow': self.approval_workflow,
            'rate_limit': self.rate_limit,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            approval_workflow=d.get('approval_workflow'),
            rate_limit=d.get('rate_limit'),
        )


class Athena:
    __slots__ = [
        'access_key',
        'bind_interface',
        'egress_filter',
        'healthy',
        'id',
        'name',
        'output',
        'port_override',
        'proxy_cluster_id',
        'region',
        'role_arn',
        'role_external_id',
        'secret_access_key',
        'secret_store_id',
        'subdomain',
        'tags',
    ]

    def __init__(
        self,
        access_key=None,
        bind_interface=None,
        egress_filter=None,
        healthy=None,
        id=None,
        name=None,
        output=None,
        port_override=None,
        proxy_cluster_id=None,
        region=None,
        role_arn=None,
        role_external_id=None,
        secret_access_key=None,
        secret_store_id=None,
        subdomain=None,
        tags=None,
    ):
        self.access_key = access_key if access_key is not None else ''
        '''
         The Access Key ID to use to authenticate.
        '''
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided and may also be set to one of the ResourceIPAllocationMode constants to select between VNM, loopback, or default allocation.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.output = output if output is not None else ''
        '''
         The AWS S3 output location.
        '''
        self.port_override = port_override if port_override is not None else 0
        '''
         The local port used by clients to connect to this resource. It is automatically generated if not provided on create and may be re-generated on update by specifying a value of -1.
        '''
        self.proxy_cluster_id = proxy_cluster_id if proxy_cluster_id is not None else ''
        '''
         ID of the proxy cluster for this resource, if any.
        '''
        self.region = region if region is not None else ''
        '''
         The AWS region to connect to e.g. us-east-1.
        '''
        self.role_arn = role_arn if role_arn is not None else ''
        '''
         The role to assume after logging in.
        '''
        self.role_external_id = role_external_id if role_external_id is not None else ''
        '''
         The external ID to associate with assume role requests. Does nothing if a role ARN is not provided.
        '''
        self.secret_access_key = secret_access_key if secret_access_key is not None else ''
        '''
         The Secret Access Key to use to authenticate.
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         DNS subdomain through which this resource may be accessed on clients.  (e.g. "app-prod1" allows the resource to be accessed at "app-prod1.your-org-name.sdm-proxy-domain"). Only applicable to HTTP-based resources or resources using virtual networking mode.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''

    def __repr__(self):
        return '<sdm.Athena ' + \
            'access_key: ' + repr(self.access_key) + ' ' +\
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'output: ' + repr(self.output) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'proxy_cluster_id: ' + repr(self.proxy_cluster_id) + ' ' +\
            'region: ' + repr(self.region) + ' ' +\
            'role_arn: ' + repr(self.role_arn) + ' ' +\
            'role_external_id: ' + repr(self.role_external_id) + ' ' +\
            'secret_access_key: ' + repr(self.secret_access_key) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'access_key': self.access_key,
            'bind_interface': self.bind_interface,
            'egress_filter': self.egress_filter,
            'healthy': self.healthy,
            'id': self.id,
            'name': self.name,
            'output': self.output,
            'port_override': self.port_override,
            'proxy_cluster_id': self.proxy_cluster_id,
            'region': self.region,
            'role_arn': self.role_arn,
            'role_external_id': self.role_external_id,
            'secret_access_key': self.secret_access_key,
            'secret_store_id': self.secret_store_id,
            'subdomain': self.subdomain,
            'tags': self.tags,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            access_key=d.get('access_key'),
            bind_interface=d.get('bind_interface'),
            egress_filter=d.get('egress_filter'),
            healthy=d.get('healthy'),
            id=d.get('id'),
            name=d.get('name'),
            output=d.get('output'),
            port_override=d.get('port_override'),
            proxy_cluster_id=d.get('proxy_cluster_id'),
            region=d.get('region'),
            role_arn=d.get('role_arn'),
            role_external_id=d.get('role_external_id'),
            secret_access_key=d.get('secret_access_key'),
            secret_store_id=d.get('secret_store_id'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
        )


class AthenaIAM:
    __slots__ = [
        'bind_interface',
        'egress_filter',
        'healthy',
        'id',
        'name',
        'output',
        'port_override',
        'proxy_cluster_id',
        'region',
        'role_arn',
        'role_external_id',
        'secret_store_id',
        'subdomain',
        'tags',
    ]

    def __init__(
        self,
        bind_interface=None,
        egress_filter=None,
        healthy=None,
        id=None,
        name=None,
        output=None,
        port_override=None,
        proxy_cluster_id=None,
        region=None,
        role_arn=None,
        role_external_id=None,
        secret_store_id=None,
        subdomain=None,
        tags=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided and may also be set to one of the ResourceIPAllocationMode constants to select between VNM, loopback, or default allocation.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.output = output if output is not None else ''
        '''
         The AWS S3 output location.
        '''
        self.port_override = port_override if port_override is not None else 0
        '''
         The local port used by clients to connect to this resource. It is automatically generated if not provided on create and may be re-generated on update by specifying a value of -1.
        '''
        self.proxy_cluster_id = proxy_cluster_id if proxy_cluster_id is not None else ''
        '''
         ID of the proxy cluster for this resource, if any.
        '''
        self.region = region if region is not None else ''
        '''
         The AWS region to connect to e.g. us-east-1.
        '''
        self.role_arn = role_arn if role_arn is not None else ''
        '''
         The role to assume after logging in.
        '''
        self.role_external_id = role_external_id if role_external_id is not None else ''
        '''
         The external ID to associate with assume role requests. Does nothing if a role ARN is not provided.
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         DNS subdomain through which this resource may be accessed on clients.  (e.g. "app-prod1" allows the resource to be accessed at "app-prod1.your-org-name.sdm-proxy-domain"). Only applicable to HTTP-based resources or resources using virtual networking mode.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''

    def __repr__(self):
        return '<sdm.AthenaIAM ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'output: ' + repr(self.output) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'proxy_cluster_id: ' + repr(self.proxy_cluster_id) + ' ' +\
            'region: ' + repr(self.region) + ' ' +\
            'role_arn: ' + repr(self.role_arn) + ' ' +\
            'role_external_id: ' + repr(self.role_external_id) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'egress_filter': self.egress_filter,
            'healthy': self.healthy,
            'id': self.id,
            'name': self.name,
            'output': self.output,
            'port_override': self.port_override,
            'proxy_cluster_id': self.proxy_cluster_id,
            'region': self.region,
            'role_arn': self.role_arn,
            'role_external_id': self.role_external_id,
            'secret_store_id': self.secret_store_id,
            'subdomain': self.subdomain,
            'tags': self.tags,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            egress_filter=d.get('egress_filter'),
            healthy=d.get('healthy'),
            id=d.get('id'),
            name=d.get('name'),
            output=d.get('output'),
            port_override=d.get('port_override'),
            proxy_cluster_id=d.get('proxy_cluster_id'),
            region=d.get('region'),
            role_arn=d.get('role_arn'),
            role_external_id=d.get('role_external_id'),
            secret_store_id=d.get('secret_store_id'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
        )


class AuroraMysql:
    __slots__ = [
        'bind_interface',
        'database',
        'egress_filter',
        'healthy',
        'hostname',
        'id',
        'name',
        'password',
        'port',
        'port_override',
        'proxy_cluster_id',
        'require_native_auth',
        'secret_store_id',
        'subdomain',
        'tags',
        'use_azure_single_server_usernames',
        'username',
    ]

    def __init__(
        self,
        bind_interface=None,
        database=None,
        egress_filter=None,
        healthy=None,
        hostname=None,
        id=None,
        name=None,
        password=None,
        port=None,
        port_override=None,
        proxy_cluster_id=None,
        require_native_auth=None,
        secret_store_id=None,
        subdomain=None,
        tags=None,
        use_azure_single_server_usernames=None,
        username=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided and may also be set to one of the ResourceIPAllocationMode constants to select between VNM, loopback, or default allocation.
        '''
        self.database = database if database is not None else ''
        '''
         The database for healthchecks. Does not affect client requests
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        '''
         The host to dial to initiate a connection from the egress node to this resource.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.password = password if password is not None else ''
        '''
         The password to authenticate with.
        '''
        self.port = port if port is not None else 0
        '''
         The port to dial to initiate a connection from the egress node to this resource.
        '''
        self.port_override = port_override if port_override is not None else 0
        '''
         The local port used by clients to connect to this resource. It is automatically generated if not provided on create and may be re-generated on update by specifying a value of -1.
        '''
        self.proxy_cluster_id = proxy_cluster_id if proxy_cluster_id is not None else ''
        '''
         ID of the proxy cluster for this resource, if any.
        '''
        self.require_native_auth = require_native_auth if require_native_auth is not None else False
        '''
         Whether native auth (mysql_native_password) is used for all connections (for backwards compatibility)
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         DNS subdomain through which this resource may be accessed on clients.  (e.g. "app-prod1" allows the resource to be accessed at "app-prod1.your-org-name.sdm-proxy-domain"). Only applicable to HTTP-based resources or resources using virtual networking mode.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.use_azure_single_server_usernames = use_azure_single_server_usernames if use_azure_single_server_usernames is not None else False
        '''
         If true, appends the hostname to the username when hitting a database.azure.com address
        '''
        self.username = username if username is not None else ''
        '''
         The username to authenticate with.
        '''

    def __repr__(self):
        return '<sdm.AuroraMysql ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'database: ' + repr(self.database) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'password: ' + repr(self.password) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'proxy_cluster_id: ' + repr(self.proxy_cluster_id) + ' ' +\
            'require_native_auth: ' + repr(self.require_native_auth) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'use_azure_single_server_usernames: ' + repr(self.use_azure_single_server_usernames) + ' ' +\
            'username: ' + repr(self.username) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'database': self.database,
            'egress_filter': self.egress_filter,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'name': self.name,
            'password': self.password,
            'port': self.port,
            'port_override': self.port_override,
            'proxy_cluster_id': self.proxy_cluster_id,
            'require_native_auth': self.require_native_auth,
            'secret_store_id': self.secret_store_id,
            'subdomain': self.subdomain,
            'tags': self.tags,
            'use_azure_single_server_usernames':
            self.use_azure_single_server_usernames,
            'username': self.username,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            database=d.get('database'),
            egress_filter=d.get('egress_filter'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            name=d.get('name'),
            password=d.get('password'),
            port=d.get('port'),
            port_override=d.get('port_override'),
            proxy_cluster_id=d.get('proxy_cluster_id'),
            require_native_auth=d.get('require_native_auth'),
            secret_store_id=d.get('secret_store_id'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
            use_azure_single_server_usernames=d.get(
                'use_azure_single_server_usernames'),
            username=d.get('username'),
        )


class AuroraMysqlIAM:
    __slots__ = [
        'bind_interface',
        'database',
        'egress_filter',
        'healthy',
        'hostname',
        'id',
        'name',
        'port',
        'port_override',
        'proxy_cluster_id',
        'region',
        'role_assumption_arn',
        'secret_store_id',
        'subdomain',
        'tags',
        'username',
    ]

    def __init__(
        self,
        bind_interface=None,
        database=None,
        egress_filter=None,
        healthy=None,
        hostname=None,
        id=None,
        name=None,
        port=None,
        port_override=None,
        proxy_cluster_id=None,
        region=None,
        role_assumption_arn=None,
        secret_store_id=None,
        subdomain=None,
        tags=None,
        username=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided and may also be set to one of the ResourceIPAllocationMode constants to select between VNM, loopback, or default allocation.
        '''
        self.database = database if database is not None else ''
        '''
         The database for healthchecks. Does not affect client requests
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        '''
         The host to dial to initiate a connection from the egress node to this resource.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.port = port if port is not None else 0
        '''
         The port to dial to initiate a connection from the egress node to this resource.
        '''
        self.port_override = port_override if port_override is not None else 0
        '''
         The local port used by clients to connect to this resource. It is automatically generated if not provided on create and may be re-generated on update by specifying a value of -1.
        '''
        self.proxy_cluster_id = proxy_cluster_id if proxy_cluster_id is not None else ''
        '''
         ID of the proxy cluster for this resource, if any.
        '''
        self.region = region if region is not None else ''
        '''
         The AWS region to connect to.
        '''
        self.role_assumption_arn = role_assumption_arn if role_assumption_arn is not None else ''
        '''
         If provided, the gateway/relay will try to assume this role instead of the underlying compute's role.
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         DNS subdomain through which this resource may be accessed on clients.  (e.g. "app-prod1" allows the resource to be accessed at "app-prod1.your-org-name.sdm-proxy-domain"). Only applicable to HTTP-based resources or resources using virtual networking mode.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.username = username if username is not None else ''
        '''
         The username to authenticate with.
        '''

    def __repr__(self):
        return '<sdm.AuroraMysqlIAM ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'database: ' + repr(self.database) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'proxy_cluster_id: ' + repr(self.proxy_cluster_id) + ' ' +\
            'region: ' + repr(self.region) + ' ' +\
            'role_assumption_arn: ' + repr(self.role_assumption_arn) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'username: ' + repr(self.username) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'database': self.database,
            'egress_filter': self.egress_filter,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'name': self.name,
            'port': self.port,
            'port_override': self.port_override,
            'proxy_cluster_id': self.proxy_cluster_id,
            'region': self.region,
            'role_assumption_arn': self.role_assumption_arn,
            'secret_store_id': self.secret_store_id,
            'subdomain': self.subdomain,
            'tags': self.tags,
            'username': self.username,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            database=d.get('database'),
            egress_filter=d.get('egress_filter'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            name=d.get('name'),
            port=d.get('port'),
            port_override=d.get('port_override'),
            proxy_cluster_id=d.get('proxy_cluster_id'),
            region=d.get('region'),
            role_assumption_arn=d.get('role_assumption_arn'),
            secret_store_id=d.get('secret_store_id'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
            username=d.get('username'),
        )


class AuroraPostgres:
    __slots__ = [
        'bind_interface',
        'database',
        'egress_filter',
        'healthy',
        'hostname',
        'id',
        'name',
        'override_database',
        'password',
        'port',
        'port_override',
        'proxy_cluster_id',
        'secret_store_id',
        'subdomain',
        'tags',
        'username',
    ]

    def __init__(
        self,
        bind_interface=None,
        database=None,
        egress_filter=None,
        healthy=None,
        hostname=None,
        id=None,
        name=None,
        override_database=None,
        password=None,
        port=None,
        port_override=None,
        proxy_cluster_id=None,
        secret_store_id=None,
        subdomain=None,
        tags=None,
        username=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided and may also be set to one of the ResourceIPAllocationMode constants to select between VNM, loopback, or default allocation.
        '''
        self.database = database if database is not None else ''
        '''
         The initial database to connect to. This setting does not by itself prevent switching to another database after connecting.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        '''
         The host to dial to initiate a connection from the egress node to this resource.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.override_database = override_database if override_database is not None else False
        '''
         If set, the database configured cannot be changed by users. This setting is not recommended for most use cases, as some clients will insist their database has changed when it has not, leading to user confusion.
        '''
        self.password = password if password is not None else ''
        '''
         The password to authenticate with.
        '''
        self.port = port if port is not None else 0
        '''
         The port to dial to initiate a connection from the egress node to this resource.
        '''
        self.port_override = port_override if port_override is not None else 0
        '''
         The local port used by clients to connect to this resource. It is automatically generated if not provided on create and may be re-generated on update by specifying a value of -1.
        '''
        self.proxy_cluster_id = proxy_cluster_id if proxy_cluster_id is not None else ''
        '''
         ID of the proxy cluster for this resource, if any.
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         DNS subdomain through which this resource may be accessed on clients.  (e.g. "app-prod1" allows the resource to be accessed at "app-prod1.your-org-name.sdm-proxy-domain"). Only applicable to HTTP-based resources or resources using virtual networking mode.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.username = username if username is not None else ''
        '''
         The username to authenticate with.
        '''

    def __repr__(self):
        return '<sdm.AuroraPostgres ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'database: ' + repr(self.database) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'override_database: ' + repr(self.override_database) + ' ' +\
            'password: ' + repr(self.password) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'proxy_cluster_id: ' + repr(self.proxy_cluster_id) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'username: ' + repr(self.username) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'database': self.database,
            'egress_filter': self.egress_filter,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'name': self.name,
            'override_database': self.override_database,
            'password': self.password,
            'port': self.port,
            'port_override': self.port_override,
            'proxy_cluster_id': self.proxy_cluster_id,
            'secret_store_id': self.secret_store_id,
            'subdomain': self.subdomain,
            'tags': self.tags,
            'username': self.username,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            database=d.get('database'),
            egress_filter=d.get('egress_filter'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            name=d.get('name'),
            override_database=d.get('override_database'),
            password=d.get('password'),
            port=d.get('port'),
            port_override=d.get('port_override'),
            proxy_cluster_id=d.get('proxy_cluster_id'),
            secret_store_id=d.get('secret_store_id'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
            username=d.get('username'),
        )


class AuroraPostgresIAM:
    __slots__ = [
        'bind_interface',
        'database',
        'egress_filter',
        'healthy',
        'hostname',
        'id',
        'name',
        'override_database',
        'port',
        'port_override',
        'proxy_cluster_id',
        'region',
        'role_assumption_arn',
        'secret_store_id',
        'subdomain',
        'tags',
        'username',
    ]

    def __init__(
        self,
        bind_interface=None,
        database=None,
        egress_filter=None,
        healthy=None,
        hostname=None,
        id=None,
        name=None,
        override_database=None,
        port=None,
        port_override=None,
        proxy_cluster_id=None,
        region=None,
        role_assumption_arn=None,
        secret_store_id=None,
        subdomain=None,
        tags=None,
        username=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided and may also be set to one of the ResourceIPAllocationMode constants to select between VNM, loopback, or default allocation.
        '''
        self.database = database if database is not None else ''
        '''
         The initial database to connect to. This setting does not by itself prevent switching to another database after connecting.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        '''
         The host to dial to initiate a connection from the egress node to this resource.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.override_database = override_database if override_database is not None else False
        '''
         If set, the database configured cannot be changed by users. This setting is not recommended for most use cases, as some clients will insist their database has changed when it has not, leading to user confusion.
        '''
        self.port = port if port is not None else 0
        '''
         The port to dial to initiate a connection from the egress node to this resource.
        '''
        self.port_override = port_override if port_override is not None else 0
        '''
         The local port used by clients to connect to this resource. It is automatically generated if not provided on create and may be re-generated on update by specifying a value of -1.
        '''
        self.proxy_cluster_id = proxy_cluster_id if proxy_cluster_id is not None else ''
        '''
         ID of the proxy cluster for this resource, if any.
        '''
        self.region = region if region is not None else ''
        '''
         The AWS region to connect to.
        '''
        self.role_assumption_arn = role_assumption_arn if role_assumption_arn is not None else ''
        '''
         If provided, the gateway/relay will try to assume this role instead of the underlying compute's role.
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         DNS subdomain through which this resource may be accessed on clients.  (e.g. "app-prod1" allows the resource to be accessed at "app-prod1.your-org-name.sdm-proxy-domain"). Only applicable to HTTP-based resources or resources using virtual networking mode.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.username = username if username is not None else ''
        '''
         The username to authenticate with.
        '''

    def __repr__(self):
        return '<sdm.AuroraPostgresIAM ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'database: ' + repr(self.database) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'override_database: ' + repr(self.override_database) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'proxy_cluster_id: ' + repr(self.proxy_cluster_id) + ' ' +\
            'region: ' + repr(self.region) + ' ' +\
            'role_assumption_arn: ' + repr(self.role_assumption_arn) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'username: ' + repr(self.username) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'database': self.database,
            'egress_filter': self.egress_filter,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'name': self.name,
            'override_database': self.override_database,
            'port': self.port,
            'port_override': self.port_override,
            'proxy_cluster_id': self.proxy_cluster_id,
            'region': self.region,
            'role_assumption_arn': self.role_assumption_arn,
            'secret_store_id': self.secret_store_id,
            'subdomain': self.subdomain,
            'tags': self.tags,
            'username': self.username,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            database=d.get('database'),
            egress_filter=d.get('egress_filter'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            name=d.get('name'),
            override_database=d.get('override_database'),
            port=d.get('port'),
            port_override=d.get('port_override'),
            proxy_cluster_id=d.get('proxy_cluster_id'),
            region=d.get('region'),
            role_assumption_arn=d.get('role_assumption_arn'),
            secret_store_id=d.get('secret_store_id'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
            username=d.get('username'),
        )


class Azure:
    __slots__ = [
        'app_id',
        'bind_interface',
        'egress_filter',
        'healthy',
        'id',
        'name',
        'password',
        'port_override',
        'proxy_cluster_id',
        'secret_store_id',
        'subdomain',
        'tags',
        'tenant_id',
    ]

    def __init__(
        self,
        app_id=None,
        bind_interface=None,
        egress_filter=None,
        healthy=None,
        id=None,
        name=None,
        password=None,
        port_override=None,
        proxy_cluster_id=None,
        secret_store_id=None,
        subdomain=None,
        tags=None,
        tenant_id=None,
    ):
        self.app_id = app_id if app_id is not None else ''
        '''
         The application ID to authenticate with.
        '''
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided and may also be set to one of the ResourceIPAllocationMode constants to select between VNM, loopback, or default allocation.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.password = password if password is not None else ''
        '''
         The password to authenticate with.
        '''
        self.port_override = port_override if port_override is not None else 0
        '''
         The local port used by clients to connect to this resource. It is automatically generated if not provided on create and may be re-generated on update by specifying a value of -1.
        '''
        self.proxy_cluster_id = proxy_cluster_id if proxy_cluster_id is not None else ''
        '''
         ID of the proxy cluster for this resource, if any.
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         DNS subdomain through which this resource may be accessed on clients.  (e.g. "app-prod1" allows the resource to be accessed at "app-prod1.your-org-name.sdm-proxy-domain"). Only applicable to HTTP-based resources or resources using virtual networking mode.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.tenant_id = tenant_id if tenant_id is not None else ''
        '''
         The tenant ID to authenticate to.
        '''

    def __repr__(self):
        return '<sdm.Azure ' + \
            'app_id: ' + repr(self.app_id) + ' ' +\
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'password: ' + repr(self.password) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'proxy_cluster_id: ' + repr(self.proxy_cluster_id) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'tenant_id: ' + repr(self.tenant_id) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'app_id': self.app_id,
            'bind_interface': self.bind_interface,
            'egress_filter': self.egress_filter,
            'healthy': self.healthy,
            'id': self.id,
            'name': self.name,
            'password': self.password,
            'port_override': self.port_override,
            'proxy_cluster_id': self.proxy_cluster_id,
            'secret_store_id': self.secret_store_id,
            'subdomain': self.subdomain,
            'tags': self.tags,
            'tenant_id': self.tenant_id,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            app_id=d.get('app_id'),
            bind_interface=d.get('bind_interface'),
            egress_filter=d.get('egress_filter'),
            healthy=d.get('healthy'),
            id=d.get('id'),
            name=d.get('name'),
            password=d.get('password'),
            port_override=d.get('port_override'),
            proxy_cluster_id=d.get('proxy_cluster_id'),
            secret_store_id=d.get('secret_store_id'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
            tenant_id=d.get('tenant_id'),
        )


class AzureCertificate:
    __slots__ = [
        'app_id',
        'bind_interface',
        'client_certificate',
        'egress_filter',
        'healthy',
        'id',
        'name',
        'port_override',
        'proxy_cluster_id',
        'secret_store_id',
        'subdomain',
        'tags',
        'tenant_id',
    ]

    def __init__(
        self,
        app_id=None,
        bind_interface=None,
        client_certificate=None,
        egress_filter=None,
        healthy=None,
        id=None,
        name=None,
        port_override=None,
        proxy_cluster_id=None,
        secret_store_id=None,
        subdomain=None,
        tags=None,
        tenant_id=None,
    ):
        self.app_id = app_id if app_id is not None else ''
        '''
         The application ID to authenticate with.
        '''
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided and may also be set to one of the ResourceIPAllocationMode constants to select between VNM, loopback, or default allocation.
        '''
        self.client_certificate = client_certificate if client_certificate is not None else ''
        '''
         The service Principal certificate file, both private and public key included.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.port_override = port_override if port_override is not None else 0
        '''
         The local port used by clients to connect to this resource. It is automatically generated if not provided on create and may be re-generated on update by specifying a value of -1.
        '''
        self.proxy_cluster_id = proxy_cluster_id if proxy_cluster_id is not None else ''
        '''
         ID of the proxy cluster for this resource, if any.
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         DNS subdomain through which this resource may be accessed on clients.  (e.g. "app-prod1" allows the resource to be accessed at "app-prod1.your-org-name.sdm-proxy-domain"). Only applicable to HTTP-based resources or resources using virtual networking mode.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.tenant_id = tenant_id if tenant_id is not None else ''
        '''
         The tenant ID to authenticate to.
        '''

    def __repr__(self):
        return '<sdm.AzureCertificate ' + \
            'app_id: ' + repr(self.app_id) + ' ' +\
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'client_certificate: ' + repr(self.client_certificate) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'proxy_cluster_id: ' + repr(self.proxy_cluster_id) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'tenant_id: ' + repr(self.tenant_id) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'app_id': self.app_id,
            'bind_interface': self.bind_interface,
            'client_certificate': self.client_certificate,
            'egress_filter': self.egress_filter,
            'healthy': self.healthy,
            'id': self.id,
            'name': self.name,
            'port_override': self.port_override,
            'proxy_cluster_id': self.proxy_cluster_id,
            'secret_store_id': self.secret_store_id,
            'subdomain': self.subdomain,
            'tags': self.tags,
            'tenant_id': self.tenant_id,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            app_id=d.get('app_id'),
            bind_interface=d.get('bind_interface'),
            client_certificate=d.get('client_certificate'),
            egress_filter=d.get('egress_filter'),
            healthy=d.get('healthy'),
            id=d.get('id'),
            name=d.get('name'),
            port_override=d.get('port_override'),
            proxy_cluster_id=d.get('proxy_cluster_id'),
            secret_store_id=d.get('secret_store_id'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
            tenant_id=d.get('tenant_id'),
        )


class AzureMysql:
    __slots__ = [
        'bind_interface',
        'database',
        'egress_filter',
        'healthy',
        'hostname',
        'id',
        'name',
        'password',
        'port',
        'port_override',
        'proxy_cluster_id',
        'require_native_auth',
        'secret_store_id',
        'subdomain',
        'tags',
        'use_azure_single_server_usernames',
        'username',
    ]

    def __init__(
        self,
        bind_interface=None,
        database=None,
        egress_filter=None,
        healthy=None,
        hostname=None,
        id=None,
        name=None,
        password=None,
        port=None,
        port_override=None,
        proxy_cluster_id=None,
        require_native_auth=None,
        secret_store_id=None,
        subdomain=None,
        tags=None,
        use_azure_single_server_usernames=None,
        username=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided and may also be set to one of the ResourceIPAllocationMode constants to select between VNM, loopback, or default allocation.
        '''
        self.database = database if database is not None else ''
        '''
         The database for healthchecks. Does not affect client requests.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        '''
         The host to dial to initiate a connection from the egress node to this resource.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.password = password if password is not None else ''
        '''
         The password to authenticate with.
        '''
        self.port = port if port is not None else 0
        '''
         The port to dial to initiate a connection from the egress node to this resource.
        '''
        self.port_override = port_override if port_override is not None else 0
        '''
         The local port used by clients to connect to this resource. It is automatically generated if not provided on create and may be re-generated on update by specifying a value of -1.
        '''
        self.proxy_cluster_id = proxy_cluster_id if proxy_cluster_id is not None else ''
        '''
         ID of the proxy cluster for this resource, if any.
        '''
        self.require_native_auth = require_native_auth if require_native_auth is not None else False
        '''
         Whether native auth (mysql_native_password) is used for all connections (for backwards compatibility)
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         DNS subdomain through which this resource may be accessed on clients.  (e.g. "app-prod1" allows the resource to be accessed at "app-prod1.your-org-name.sdm-proxy-domain"). Only applicable to HTTP-based resources or resources using virtual networking mode.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.use_azure_single_server_usernames = use_azure_single_server_usernames if use_azure_single_server_usernames is not None else False
        '''
         If true, appends the hostname to the username when hitting a database.azure.com address
        '''
        self.username = username if username is not None else ''
        '''
         The username to authenticate with.
        '''

    def __repr__(self):
        return '<sdm.AzureMysql ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'database: ' + repr(self.database) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'password: ' + repr(self.password) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'proxy_cluster_id: ' + repr(self.proxy_cluster_id) + ' ' +\
            'require_native_auth: ' + repr(self.require_native_auth) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'use_azure_single_server_usernames: ' + repr(self.use_azure_single_server_usernames) + ' ' +\
            'username: ' + repr(self.username) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'database': self.database,
            'egress_filter': self.egress_filter,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'name': self.name,
            'password': self.password,
            'port': self.port,
            'port_override': self.port_override,
            'proxy_cluster_id': self.proxy_cluster_id,
            'require_native_auth': self.require_native_auth,
            'secret_store_id': self.secret_store_id,
            'subdomain': self.subdomain,
            'tags': self.tags,
            'use_azure_single_server_usernames':
            self.use_azure_single_server_usernames,
            'username': self.username,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            database=d.get('database'),
            egress_filter=d.get('egress_filter'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            name=d.get('name'),
            password=d.get('password'),
            port=d.get('port'),
            port_override=d.get('port_override'),
            proxy_cluster_id=d.get('proxy_cluster_id'),
            require_native_auth=d.get('require_native_auth'),
            secret_store_id=d.get('secret_store_id'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
            use_azure_single_server_usernames=d.get(
                'use_azure_single_server_usernames'),
            username=d.get('username'),
        )


class AzureMysqlManagedIdentity:
    __slots__ = [
        'bind_interface',
        'database',
        'egress_filter',
        'healthy',
        'hostname',
        'id',
        'name',
        'password',
        'port',
        'port_override',
        'proxy_cluster_id',
        'secret_store_id',
        'subdomain',
        'tags',
        'use_azure_single_server_usernames',
        'username',
    ]

    def __init__(
        self,
        bind_interface=None,
        database=None,
        egress_filter=None,
        healthy=None,
        hostname=None,
        id=None,
        name=None,
        password=None,
        port=None,
        port_override=None,
        proxy_cluster_id=None,
        secret_store_id=None,
        subdomain=None,
        tags=None,
        use_azure_single_server_usernames=None,
        username=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided and may also be set to one of the ResourceIPAllocationMode constants to select between VNM, loopback, or default allocation.
        '''
        self.database = database if database is not None else ''
        '''
         The database for healthchecks. Does not affect client requests.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        '''
         The host to dial to initiate a connection from the egress node to this resource.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.password = password if password is not None else ''
        '''
         The password to authenticate with.
        '''
        self.port = port if port is not None else 0
        '''
         The port to dial to initiate a connection from the egress node to this resource.
        '''
        self.port_override = port_override if port_override is not None else 0
        '''
         The local port used by clients to connect to this resource. It is automatically generated if not provided on create and may be re-generated on update by specifying a value of -1.
        '''
        self.proxy_cluster_id = proxy_cluster_id if proxy_cluster_id is not None else ''
        '''
         ID of the proxy cluster for this resource, if any.
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         DNS subdomain through which this resource may be accessed on clients.  (e.g. "app-prod1" allows the resource to be accessed at "app-prod1.your-org-name.sdm-proxy-domain"). Only applicable to HTTP-based resources or resources using virtual networking mode.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.use_azure_single_server_usernames = use_azure_single_server_usernames if use_azure_single_server_usernames is not None else False
        '''
         If true, appends the hostname to the username when hitting a database.azure.com address
        '''
        self.username = username if username is not None else ''
        '''
         The username to authenticate with.
        '''

    def __repr__(self):
        return '<sdm.AzureMysqlManagedIdentity ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'database: ' + repr(self.database) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'password: ' + repr(self.password) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'proxy_cluster_id: ' + repr(self.proxy_cluster_id) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'use_azure_single_server_usernames: ' + repr(self.use_azure_single_server_usernames) + ' ' +\
            'username: ' + repr(self.username) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'database': self.database,
            'egress_filter': self.egress_filter,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'name': self.name,
            'password': self.password,
            'port': self.port,
            'port_override': self.port_override,
            'proxy_cluster_id': self.proxy_cluster_id,
            'secret_store_id': self.secret_store_id,
            'subdomain': self.subdomain,
            'tags': self.tags,
            'use_azure_single_server_usernames':
            self.use_azure_single_server_usernames,
            'username': self.username,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            database=d.get('database'),
            egress_filter=d.get('egress_filter'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            name=d.get('name'),
            password=d.get('password'),
            port=d.get('port'),
            port_override=d.get('port_override'),
            proxy_cluster_id=d.get('proxy_cluster_id'),
            secret_store_id=d.get('secret_store_id'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
            use_azure_single_server_usernames=d.get(
                'use_azure_single_server_usernames'),
            username=d.get('username'),
        )


class AzurePostgres:
    __slots__ = [
        'bind_interface',
        'database',
        'egress_filter',
        'healthy',
        'hostname',
        'id',
        'name',
        'override_database',
        'password',
        'port',
        'port_override',
        'proxy_cluster_id',
        'secret_store_id',
        'subdomain',
        'tags',
        'username',
    ]

    def __init__(
        self,
        bind_interface=None,
        database=None,
        egress_filter=None,
        healthy=None,
        hostname=None,
        id=None,
        name=None,
        override_database=None,
        password=None,
        port=None,
        port_override=None,
        proxy_cluster_id=None,
        secret_store_id=None,
        subdomain=None,
        tags=None,
        username=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided and may also be set to one of the ResourceIPAllocationMode constants to select between VNM, loopback, or default allocation.
        '''
        self.database = database if database is not None else ''
        '''
         The initial database to connect to. This setting does not by itself prevent switching to another database after connecting.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        '''
         The host to dial to initiate a connection from the egress node to this resource.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.override_database = override_database if override_database is not None else False
        '''
         If set, the database configured cannot be changed by users. This setting is not recommended for most use cases, as some clients will insist their database has changed when it has not, leading to user confusion.
        '''
        self.password = password if password is not None else ''
        '''
         The password to authenticate with.
        '''
        self.port = port if port is not None else 0
        '''
         The port to dial to initiate a connection from the egress node to this resource.
        '''
        self.port_override = port_override if port_override is not None else 0
        '''
         The local port used by clients to connect to this resource. It is automatically generated if not provided on create and may be re-generated on update by specifying a value of -1.
        '''
        self.proxy_cluster_id = proxy_cluster_id if proxy_cluster_id is not None else ''
        '''
         ID of the proxy cluster for this resource, if any.
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         DNS subdomain through which this resource may be accessed on clients.  (e.g. "app-prod1" allows the resource to be accessed at "app-prod1.your-org-name.sdm-proxy-domain"). Only applicable to HTTP-based resources or resources using virtual networking mode.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.username = username if username is not None else ''
        '''
         The username to authenticate with. For Azure Postgres, this also will include the hostname of the target server for Azure Single Server compatibility. For Flexible servers, use the normal Postgres type.
        '''

    def __repr__(self):
        return '<sdm.AzurePostgres ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'database: ' + repr(self.database) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'override_database: ' + repr(self.override_database) + ' ' +\
            'password: ' + repr(self.password) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'proxy_cluster_id: ' + repr(self.proxy_cluster_id) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'username: ' + repr(self.username) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'database': self.database,
            'egress_filter': self.egress_filter,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'name': self.name,
            'override_database': self.override_database,
            'password': self.password,
            'port': self.port,
            'port_override': self.port_override,
            'proxy_cluster_id': self.proxy_cluster_id,
            'secret_store_id': self.secret_store_id,
            'subdomain': self.subdomain,
            'tags': self.tags,
            'username': self.username,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            database=d.get('database'),
            egress_filter=d.get('egress_filter'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            name=d.get('name'),
            override_database=d.get('override_database'),
            password=d.get('password'),
            port=d.get('port'),
            port_override=d.get('port_override'),
            proxy_cluster_id=d.get('proxy_cluster_id'),
            secret_store_id=d.get('secret_store_id'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
            username=d.get('username'),
        )


class AzurePostgresManagedIdentity:
    __slots__ = [
        'bind_interface',
        'database',
        'egress_filter',
        'healthy',
        'hostname',
        'id',
        'name',
        'override_database',
        'password',
        'port',
        'port_override',
        'proxy_cluster_id',
        'secret_store_id',
        'subdomain',
        'tags',
        'use_azure_single_server_usernames',
        'username',
    ]

    def __init__(
        self,
        bind_interface=None,
        database=None,
        egress_filter=None,
        healthy=None,
        hostname=None,
        id=None,
        name=None,
        override_database=None,
        password=None,
        port=None,
        port_override=None,
        proxy_cluster_id=None,
        secret_store_id=None,
        subdomain=None,
        tags=None,
        use_azure_single_server_usernames=None,
        username=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided and may also be set to one of the ResourceIPAllocationMode constants to select between VNM, loopback, or default allocation.
        '''
        self.database = database if database is not None else ''
        '''
         The initial database to connect to. This setting does not by itself prevent switching to another database after connecting.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        '''
         The host to dial to initiate a connection from the egress node to this resource.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.override_database = override_database if override_database is not None else False
        '''
         If set, the database configured cannot be changed by users. This setting is not recommended for most use cases, as some clients will insist their database has changed when it has not, leading to user confusion.
        '''
        self.password = password if password is not None else ''
        '''
         The password to authenticate with.
        '''
        self.port = port if port is not None else 0
        '''
         The port to dial to initiate a connection from the egress node to this resource.
        '''
        self.port_override = port_override if port_override is not None else 0
        '''
         The local port used by clients to connect to this resource. It is automatically generated if not provided on create and may be re-generated on update by specifying a value of -1.
        '''
        self.proxy_cluster_id = proxy_cluster_id if proxy_cluster_id is not None else ''
        '''
         ID of the proxy cluster for this resource, if any.
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         DNS subdomain through which this resource may be accessed on clients.  (e.g. "app-prod1" allows the resource to be accessed at "app-prod1.your-org-name.sdm-proxy-domain"). Only applicable to HTTP-based resources or resources using virtual networking mode.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.use_azure_single_server_usernames = use_azure_single_server_usernames if use_azure_single_server_usernames is not None else False
        '''
         If true, appends the hostname to the username when hitting a database.azure.com address
        '''
        self.username = username if username is not None else ''
        '''
         The username to authenticate with.
        '''

    def __repr__(self):
        return '<sdm.AzurePostgresManagedIdentity ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'database: ' + repr(self.database) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'override_database: ' + repr(self.override_database) + ' ' +\
            'password: ' + repr(self.password) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'proxy_cluster_id: ' + repr(self.proxy_cluster_id) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'use_azure_single_server_usernames: ' + repr(self.use_azure_single_server_usernames) + ' ' +\
            'username: ' + repr(self.username) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'database': self.database,
            'egress_filter': self.egress_filter,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'name': self.name,
            'override_database': self.override_database,
            'password': self.password,
            'port': self.port,
            'port_override': self.port_override,
            'proxy_cluster_id': self.proxy_cluster_id,
            'secret_store_id': self.secret_store_id,
            'subdomain': self.subdomain,
            'tags': self.tags,
            'use_azure_single_server_usernames':
            self.use_azure_single_server_usernames,
            'username': self.username,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            database=d.get('database'),
            egress_filter=d.get('egress_filter'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            name=d.get('name'),
            override_database=d.get('override_database'),
            password=d.get('password'),
            port=d.get('port'),
            port_override=d.get('port_override'),
            proxy_cluster_id=d.get('proxy_cluster_id'),
            secret_store_id=d.get('secret_store_id'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
            use_azure_single_server_usernames=d.get(
                'use_azure_single_server_usernames'),
            username=d.get('username'),
        )


class AzureStore:
    __slots__ = [
        'id',
        'name',
        'tags',
        'vault_uri',
    ]

    def __init__(
        self,
        id=None,
        name=None,
        tags=None,
        vault_uri=None,
    ):
        self.id = id if id is not None else ''
        '''
         Unique identifier of the SecretStore.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the SecretStore.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.vault_uri = vault_uri if vault_uri is not None else ''
        '''
         The URI of the key vault to target e.g. https://myvault.vault.azure.net
        '''

    def __repr__(self):
        return '<sdm.AzureStore ' + \
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'vault_uri: ' + repr(self.vault_uri) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'id': self.id,
            'name': self.name,
            'tags': self.tags,
            'vault_uri': self.vault_uri,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            id=d.get('id'),
            name=d.get('name'),
            tags=d.get('tags'),
            vault_uri=d.get('vault_uri'),
        )


class BigQuery:
    __slots__ = [
        'bind_interface',
        'egress_filter',
        'endpoint',
        'healthy',
        'id',
        'name',
        'port_override',
        'private_key',
        'project',
        'proxy_cluster_id',
        'secret_store_id',
        'subdomain',
        'tags',
        'username',
    ]

    def __init__(
        self,
        bind_interface=None,
        egress_filter=None,
        endpoint=None,
        healthy=None,
        id=None,
        name=None,
        port_override=None,
        private_key=None,
        project=None,
        proxy_cluster_id=None,
        secret_store_id=None,
        subdomain=None,
        tags=None,
        username=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided and may also be set to one of the ResourceIPAllocationMode constants to select between VNM, loopback, or default allocation.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.endpoint = endpoint if endpoint is not None else ''
        '''
         The endpoint to dial.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.port_override = port_override if port_override is not None else 0
        '''
         The local port used by clients to connect to this resource. It is automatically generated if not provided on create and may be re-generated on update by specifying a value of -1.
        '''
        self.private_key = private_key if private_key is not None else ''
        '''
         The JSON Private key to authenticate with.
        '''
        self.project = project if project is not None else ''
        '''
         The project to connect to.
        '''
        self.proxy_cluster_id = proxy_cluster_id if proxy_cluster_id is not None else ''
        '''
         ID of the proxy cluster for this resource, if any.
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         DNS subdomain through which this resource may be accessed on clients.  (e.g. "app-prod1" allows the resource to be accessed at "app-prod1.your-org-name.sdm-proxy-domain"). Only applicable to HTTP-based resources or resources using virtual networking mode.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.username = username if username is not None else ''
        '''
         The username to authenticate with.
        '''

    def __repr__(self):
        return '<sdm.BigQuery ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'endpoint: ' + repr(self.endpoint) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'private_key: ' + repr(self.private_key) + ' ' +\
            'project: ' + repr(self.project) + ' ' +\
            'proxy_cluster_id: ' + repr(self.proxy_cluster_id) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'username: ' + repr(self.username) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'egress_filter': self.egress_filter,
            'endpoint': self.endpoint,
            'healthy': self.healthy,
            'id': self.id,
            'name': self.name,
            'port_override': self.port_override,
            'private_key': self.private_key,
            'project': self.project,
            'proxy_cluster_id': self.proxy_cluster_id,
            'secret_store_id': self.secret_store_id,
            'subdomain': self.subdomain,
            'tags': self.tags,
            'username': self.username,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            egress_filter=d.get('egress_filter'),
            endpoint=d.get('endpoint'),
            healthy=d.get('healthy'),
            id=d.get('id'),
            name=d.get('name'),
            port_override=d.get('port_override'),
            private_key=d.get('private_key'),
            project=d.get('project'),
            proxy_cluster_id=d.get('proxy_cluster_id'),
            secret_store_id=d.get('secret_store_id'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
            username=d.get('username'),
        )


class Cassandra:
    __slots__ = [
        'bind_interface',
        'egress_filter',
        'healthy',
        'hostname',
        'id',
        'name',
        'password',
        'port',
        'port_override',
        'proxy_cluster_id',
        'secret_store_id',
        'subdomain',
        'tags',
        'tls_required',
        'username',
    ]

    def __init__(
        self,
        bind_interface=None,
        egress_filter=None,
        healthy=None,
        hostname=None,
        id=None,
        name=None,
        password=None,
        port=None,
        port_override=None,
        proxy_cluster_id=None,
        secret_store_id=None,
        subdomain=None,
        tags=None,
        tls_required=None,
        username=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided and may also be set to one of the ResourceIPAllocationMode constants to select between VNM, loopback, or default allocation.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        '''
         The host to dial to initiate a connection from the egress node to this resource.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.password = password if password is not None else ''
        '''
         The password to authenticate with.
        '''
        self.port = port if port is not None else 0
        '''
         The port to dial to initiate a connection from the egress node to this resource.
        '''
        self.port_override = port_override if port_override is not None else 0
        '''
         The local port used by clients to connect to this resource. It is automatically generated if not provided on create and may be re-generated on update by specifying a value of -1.
        '''
        self.proxy_cluster_id = proxy_cluster_id if proxy_cluster_id is not None else ''
        '''
         ID of the proxy cluster for this resource, if any.
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         DNS subdomain through which this resource may be accessed on clients.  (e.g. "app-prod1" allows the resource to be accessed at "app-prod1.your-org-name.sdm-proxy-domain"). Only applicable to HTTP-based resources or resources using virtual networking mode.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.tls_required = tls_required if tls_required is not None else False
        '''
         If set, TLS must be used to connect to this resource.
        '''
        self.username = username if username is not None else ''
        '''
         The username to authenticate with.
        '''

    def __repr__(self):
        return '<sdm.Cassandra ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'password: ' + repr(self.password) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'proxy_cluster_id: ' + repr(self.proxy_cluster_id) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'tls_required: ' + repr(self.tls_required) + ' ' +\
            'username: ' + repr(self.username) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'egress_filter': self.egress_filter,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'name': self.name,
            'password': self.password,
            'port': self.port,
            'port_override': self.port_override,
            'proxy_cluster_id': self.proxy_cluster_id,
            'secret_store_id': self.secret_store_id,
            'subdomain': self.subdomain,
            'tags': self.tags,
            'tls_required': self.tls_required,
            'username': self.username,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            egress_filter=d.get('egress_filter'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            name=d.get('name'),
            password=d.get('password'),
            port=d.get('port'),
            port_override=d.get('port_override'),
            proxy_cluster_id=d.get('proxy_cluster_id'),
            secret_store_id=d.get('secret_store_id'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
            tls_required=d.get('tls_required'),
            username=d.get('username'),
        )


class Citus:
    __slots__ = [
        'bind_interface',
        'database',
        'egress_filter',
        'healthy',
        'hostname',
        'id',
        'name',
        'override_database',
        'password',
        'port',
        'port_override',
        'proxy_cluster_id',
        'secret_store_id',
        'subdomain',
        'tags',
        'username',
    ]

    def __init__(
        self,
        bind_interface=None,
        database=None,
        egress_filter=None,
        healthy=None,
        hostname=None,
        id=None,
        name=None,
        override_database=None,
        password=None,
        port=None,
        port_override=None,
        proxy_cluster_id=None,
        secret_store_id=None,
        subdomain=None,
        tags=None,
        username=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided and may also be set to one of the ResourceIPAllocationMode constants to select between VNM, loopback, or default allocation.
        '''
        self.database = database if database is not None else ''
        '''
         The initial database to connect to. This setting does not by itself prevent switching to another database after connecting.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        '''
         The host to dial to initiate a connection from the egress node to this resource.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.override_database = override_database if override_database is not None else False
        '''
         If set, the database configured cannot be changed by users. This setting is not recommended for most use cases, as some clients will insist their database has changed when it has not, leading to user confusion.
        '''
        self.password = password if password is not None else ''
        '''
         The password to authenticate with.
        '''
        self.port = port if port is not None else 0
        '''
         The port to dial to initiate a connection from the egress node to this resource.
        '''
        self.port_override = port_override if port_override is not None else 0
        '''
         The local port used by clients to connect to this resource. It is automatically generated if not provided on create and may be re-generated on update by specifying a value of -1.
        '''
        self.proxy_cluster_id = proxy_cluster_id if proxy_cluster_id is not None else ''
        '''
         ID of the proxy cluster for this resource, if any.
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         DNS subdomain through which this resource may be accessed on clients.  (e.g. "app-prod1" allows the resource to be accessed at "app-prod1.your-org-name.sdm-proxy-domain"). Only applicable to HTTP-based resources or resources using virtual networking mode.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.username = username if username is not None else ''
        '''
         The username to authenticate with.
        '''

    def __repr__(self):
        return '<sdm.Citus ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'database: ' + repr(self.database) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'override_database: ' + repr(self.override_database) + ' ' +\
            'password: ' + repr(self.password) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'proxy_cluster_id: ' + repr(self.proxy_cluster_id) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'username: ' + repr(self.username) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'database': self.database,
            'egress_filter': self.egress_filter,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'name': self.name,
            'override_database': self.override_database,
            'password': self.password,
            'port': self.port,
            'port_override': self.port_override,
            'proxy_cluster_id': self.proxy_cluster_id,
            'secret_store_id': self.secret_store_id,
            'subdomain': self.subdomain,
            'tags': self.tags,
            'username': self.username,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            database=d.get('database'),
            egress_filter=d.get('egress_filter'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            name=d.get('name'),
            override_database=d.get('override_database'),
            password=d.get('password'),
            port=d.get('port'),
            port_override=d.get('port_override'),
            proxy_cluster_id=d.get('proxy_cluster_id'),
            secret_store_id=d.get('secret_store_id'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
            username=d.get('username'),
        )


class ClickHouseHTTP:
    __slots__ = [
        'bind_interface',
        'database',
        'egress_filter',
        'healthy',
        'id',
        'name',
        'password',
        'port_override',
        'proxy_cluster_id',
        'secret_store_id',
        'tags',
        'url',
        'username',
    ]

    def __init__(
        self,
        bind_interface=None,
        database=None,
        egress_filter=None,
        healthy=None,
        id=None,
        name=None,
        password=None,
        port_override=None,
        proxy_cluster_id=None,
        secret_store_id=None,
        tags=None,
        url=None,
        username=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided and may also be set to one of the ResourceIPAllocationMode constants to select between VNM, loopback, or default allocation.
        '''
        self.database = database if database is not None else ''
        '''
         The initial database to connect to. This setting does not by itself prevent switching to another database after connecting.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.password = password if password is not None else ''
        '''
         The password to authenticate with.
        '''
        self.port_override = port_override if port_override is not None else 0
        '''
         The local port used by clients to connect to this resource. It is automatically generated if not provided on create and may be re-generated on update by specifying a value of -1.
        '''
        self.proxy_cluster_id = proxy_cluster_id if proxy_cluster_id is not None else ''
        '''
         ID of the proxy cluster for this resource, if any.
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.url = url if url is not None else ''
        '''
         The URL to dial to initiate a connection from the egress node to this resource.
        '''
        self.username = username if username is not None else ''
        '''
         The username to authenticate with.
        '''

    def __repr__(self):
        return '<sdm.ClickHouseHTTP ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'database: ' + repr(self.database) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'password: ' + repr(self.password) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'proxy_cluster_id: ' + repr(self.proxy_cluster_id) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'url: ' + repr(self.url) + ' ' +\
            'username: ' + repr(self.username) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'database': self.database,
            'egress_filter': self.egress_filter,
            'healthy': self.healthy,
            'id': self.id,
            'name': self.name,
            'password': self.password,
            'port_override': self.port_override,
            'proxy_cluster_id': self.proxy_cluster_id,
            'secret_store_id': self.secret_store_id,
            'tags': self.tags,
            'url': self.url,
            'username': self.username,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            database=d.get('database'),
            egress_filter=d.get('egress_filter'),
            healthy=d.get('healthy'),
            id=d.get('id'),
            name=d.get('name'),
            password=d.get('password'),
            port_override=d.get('port_override'),
            proxy_cluster_id=d.get('proxy_cluster_id'),
            secret_store_id=d.get('secret_store_id'),
            tags=d.get('tags'),
            url=d.get('url'),
            username=d.get('username'),
        )


class ClickHouseMySQL:
    __slots__ = [
        'bind_interface',
        'database',
        'egress_filter',
        'healthy',
        'hostname',
        'id',
        'name',
        'password',
        'port',
        'port_override',
        'proxy_cluster_id',
        'require_native_auth',
        'secret_store_id',
        'subdomain',
        'tags',
        'username',
    ]

    def __init__(
        self,
        bind_interface=None,
        database=None,
        egress_filter=None,
        healthy=None,
        hostname=None,
        id=None,
        name=None,
        password=None,
        port=None,
        port_override=None,
        proxy_cluster_id=None,
        require_native_auth=None,
        secret_store_id=None,
        subdomain=None,
        tags=None,
        username=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided and may also be set to one of the ResourceIPAllocationMode constants to select between VNM, loopback, or default allocation.
        '''
        self.database = database if database is not None else ''
        '''
         The database for healthchecks. Does not affect client requests.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        '''
         The host to dial to initiate a connection from the egress node to this resource.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.password = password if password is not None else ''
        '''
         The password to authenticate with.
        '''
        self.port = port if port is not None else 0
        '''
         The port to dial to initiate a connection from the egress node to this resource.
        '''
        self.port_override = port_override if port_override is not None else 0
        '''
         The local port used by clients to connect to this resource. It is automatically generated if not provided on create and may be re-generated on update by specifying a value of -1.
        '''
        self.proxy_cluster_id = proxy_cluster_id if proxy_cluster_id is not None else ''
        '''
         ID of the proxy cluster for this resource, if any.
        '''
        self.require_native_auth = require_native_auth if require_native_auth is not None else False
        '''
         Whether native auth (mysql_native_password) is used for all connections (for backwards compatibility)
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         DNS subdomain through which this resource may be accessed on clients.  (e.g. "app-prod1" allows the resource to be accessed at "app-prod1.your-org-name.sdm-proxy-domain"). Only applicable to HTTP-based resources or resources using virtual networking mode.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.username = username if username is not None else ''
        '''
         The username to authenticate with.
        '''

    def __repr__(self):
        return '<sdm.ClickHouseMySQL ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'database: ' + repr(self.database) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'password: ' + repr(self.password) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'proxy_cluster_id: ' + repr(self.proxy_cluster_id) + ' ' +\
            'require_native_auth: ' + repr(self.require_native_auth) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'username: ' + repr(self.username) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'database': self.database,
            'egress_filter': self.egress_filter,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'name': self.name,
            'password': self.password,
            'port': self.port,
            'port_override': self.port_override,
            'proxy_cluster_id': self.proxy_cluster_id,
            'require_native_auth': self.require_native_auth,
            'secret_store_id': self.secret_store_id,
            'subdomain': self.subdomain,
            'tags': self.tags,
            'username': self.username,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            database=d.get('database'),
            egress_filter=d.get('egress_filter'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            name=d.get('name'),
            password=d.get('password'),
            port=d.get('port'),
            port_override=d.get('port_override'),
            proxy_cluster_id=d.get('proxy_cluster_id'),
            require_native_auth=d.get('require_native_auth'),
            secret_store_id=d.get('secret_store_id'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
            username=d.get('username'),
        )


class ClickHouseTCP:
    __slots__ = [
        'bind_interface',
        'database',
        'egress_filter',
        'healthy',
        'hostname',
        'id',
        'name',
        'password',
        'port',
        'port_override',
        'proxy_cluster_id',
        'secret_store_id',
        'subdomain',
        'tags',
        'tls_required',
        'username',
    ]

    def __init__(
        self,
        bind_interface=None,
        database=None,
        egress_filter=None,
        healthy=None,
        hostname=None,
        id=None,
        name=None,
        password=None,
        port=None,
        port_override=None,
        proxy_cluster_id=None,
        secret_store_id=None,
        subdomain=None,
        tags=None,
        tls_required=None,
        username=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided and may also be set to one of the ResourceIPAllocationMode constants to select between VNM, loopback, or default allocation.
        '''
        self.database = database if database is not None else ''
        '''
         The initial database to connect to. This setting does not by itself prevent switching to another database after connecting.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        '''
         The host to dial to initiate a connection from the egress node to this resource.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.password = password if password is not None else ''
        '''
         The password to authenticate with.
        '''
        self.port = port if port is not None else 0
        '''
         The port to dial to initiate a connection from the egress node to this resource.
        '''
        self.port_override = port_override if port_override is not None else 0
        '''
         The local port used by clients to connect to this resource. It is automatically generated if not provided on create and may be re-generated on update by specifying a value of -1.
        '''
        self.proxy_cluster_id = proxy_cluster_id if proxy_cluster_id is not None else ''
        '''
         ID of the proxy cluster for this resource, if any.
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         DNS subdomain through which this resource may be accessed on clients.  (e.g. "app-prod1" allows the resource to be accessed at "app-prod1.your-org-name.sdm-proxy-domain"). Only applicable to HTTP-based resources or resources using virtual networking mode.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.tls_required = tls_required if tls_required is not None else False
        '''
         If set, TLS must be used to connect to this resource.
        '''
        self.username = username if username is not None else ''
        '''
         The username to authenticate with.
        '''

    def __repr__(self):
        return '<sdm.ClickHouseTCP ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'database: ' + repr(self.database) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'password: ' + repr(self.password) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'proxy_cluster_id: ' + repr(self.proxy_cluster_id) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'tls_required: ' + repr(self.tls_required) + ' ' +\
            'username: ' + repr(self.username) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'database': self.database,
            'egress_filter': self.egress_filter,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'name': self.name,
            'password': self.password,
            'port': self.port,
            'port_override': self.port_override,
            'proxy_cluster_id': self.proxy_cluster_id,
            'secret_store_id': self.secret_store_id,
            'subdomain': self.subdomain,
            'tags': self.tags,
            'tls_required': self.tls_required,
            'username': self.username,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            database=d.get('database'),
            egress_filter=d.get('egress_filter'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            name=d.get('name'),
            password=d.get('password'),
            port=d.get('port'),
            port_override=d.get('port_override'),
            proxy_cluster_id=d.get('proxy_cluster_id'),
            secret_store_id=d.get('secret_store_id'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
            tls_required=d.get('tls_required'),
            username=d.get('username'),
        )


class Clustrix:
    __slots__ = [
        'bind_interface',
        'database',
        'egress_filter',
        'healthy',
        'hostname',
        'id',
        'name',
        'password',
        'port',
        'port_override',
        'proxy_cluster_id',
        'require_native_auth',
        'secret_store_id',
        'subdomain',
        'tags',
        'use_azure_single_server_usernames',
        'username',
    ]

    def __init__(
        self,
        bind_interface=None,
        database=None,
        egress_filter=None,
        healthy=None,
        hostname=None,
        id=None,
        name=None,
        password=None,
        port=None,
        port_override=None,
        proxy_cluster_id=None,
        require_native_auth=None,
        secret_store_id=None,
        subdomain=None,
        tags=None,
        use_azure_single_server_usernames=None,
        username=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided and may also be set to one of the ResourceIPAllocationMode constants to select between VNM, loopback, or default allocation.
        '''
        self.database = database if database is not None else ''
        '''
         The database for healthchecks. Does not affect client requests.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        '''
         The host to dial to initiate a connection from the egress node to this resource.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.password = password if password is not None else ''
        '''
         The password to authenticate with.
        '''
        self.port = port if port is not None else 0
        '''
         The port to dial to initiate a connection from the egress node to this resource.
        '''
        self.port_override = port_override if port_override is not None else 0
        '''
         The local port used by clients to connect to this resource. It is automatically generated if not provided on create and may be re-generated on update by specifying a value of -1.
        '''
        self.proxy_cluster_id = proxy_cluster_id if proxy_cluster_id is not None else ''
        '''
         ID of the proxy cluster for this resource, if any.
        '''
        self.require_native_auth = require_native_auth if require_native_auth is not None else False
        '''
         Whether native auth (mysql_native_password) is used for all connections (for backwards compatibility)
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         DNS subdomain through which this resource may be accessed on clients.  (e.g. "app-prod1" allows the resource to be accessed at "app-prod1.your-org-name.sdm-proxy-domain"). Only applicable to HTTP-based resources or resources using virtual networking mode.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.use_azure_single_server_usernames = use_azure_single_server_usernames if use_azure_single_server_usernames is not None else False
        '''
         If true, appends the hostname to the username when hitting a database.azure.com address
        '''
        self.username = username if username is not None else ''
        '''
         The username to authenticate with.
        '''

    def __repr__(self):
        return '<sdm.Clustrix ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'database: ' + repr(self.database) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'password: ' + repr(self.password) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'proxy_cluster_id: ' + repr(self.proxy_cluster_id) + ' ' +\
            'require_native_auth: ' + repr(self.require_native_auth) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'use_azure_single_server_usernames: ' + repr(self.use_azure_single_server_usernames) + ' ' +\
            'username: ' + repr(self.username) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'database': self.database,
            'egress_filter': self.egress_filter,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'name': self.name,
            'password': self.password,
            'port': self.port,
            'port_override': self.port_override,
            'proxy_cluster_id': self.proxy_cluster_id,
            'require_native_auth': self.require_native_auth,
            'secret_store_id': self.secret_store_id,
            'subdomain': self.subdomain,
            'tags': self.tags,
            'use_azure_single_server_usernames':
            self.use_azure_single_server_usernames,
            'username': self.username,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            database=d.get('database'),
            egress_filter=d.get('egress_filter'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            name=d.get('name'),
            password=d.get('password'),
            port=d.get('port'),
            port_override=d.get('port_override'),
            proxy_cluster_id=d.get('proxy_cluster_id'),
            require_native_auth=d.get('require_native_auth'),
            secret_store_id=d.get('secret_store_id'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
            use_azure_single_server_usernames=d.get(
                'use_azure_single_server_usernames'),
            username=d.get('username'),
        )


class Cockroach:
    __slots__ = [
        'bind_interface',
        'database',
        'egress_filter',
        'healthy',
        'hostname',
        'id',
        'name',
        'override_database',
        'password',
        'port',
        'port_override',
        'proxy_cluster_id',
        'secret_store_id',
        'subdomain',
        'tags',
        'username',
    ]

    def __init__(
        self,
        bind_interface=None,
        database=None,
        egress_filter=None,
        healthy=None,
        hostname=None,
        id=None,
        name=None,
        override_database=None,
        password=None,
        port=None,
        port_override=None,
        proxy_cluster_id=None,
        secret_store_id=None,
        subdomain=None,
        tags=None,
        username=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided and may also be set to one of the ResourceIPAllocationMode constants to select between VNM, loopback, or default allocation.
        '''
        self.database = database if database is not None else ''
        '''
         The initial database to connect to. This setting does not by itself prevent switching to another database after connecting.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        '''
         The host to dial to initiate a connection from the egress node to this resource.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.override_database = override_database if override_database is not None else False
        '''
         If set, the database configured cannot be changed by users. This setting is not recommended for most use cases, as some clients will insist their database has changed when it has not, leading to user confusion.
        '''
        self.password = password if password is not None else ''
        '''
         The password to authenticate with.
        '''
        self.port = port if port is not None else 0
        '''
         The port to dial to initiate a connection from the egress node to this resource.
        '''
        self.port_override = port_override if port_override is not None else 0
        '''
         The local port used by clients to connect to this resource. It is automatically generated if not provided on create and may be re-generated on update by specifying a value of -1.
        '''
        self.proxy_cluster_id = proxy_cluster_id if proxy_cluster_id is not None else ''
        '''
         ID of the proxy cluster for this resource, if any.
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         DNS subdomain through which this resource may be accessed on clients.  (e.g. "app-prod1" allows the resource to be accessed at "app-prod1.your-org-name.sdm-proxy-domain"). Only applicable to HTTP-based resources or resources using virtual networking mode.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.username = username if username is not None else ''
        '''
         The username to authenticate with.
        '''

    def __repr__(self):
        return '<sdm.Cockroach ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'database: ' + repr(self.database) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'override_database: ' + repr(self.override_database) + ' ' +\
            'password: ' + repr(self.password) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'proxy_cluster_id: ' + repr(self.proxy_cluster_id) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'username: ' + repr(self.username) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'database': self.database,
            'egress_filter': self.egress_filter,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'name': self.name,
            'override_database': self.override_database,
            'password': self.password,
            'port': self.port,
            'port_override': self.port_override,
            'proxy_cluster_id': self.proxy_cluster_id,
            'secret_store_id': self.secret_store_id,
            'subdomain': self.subdomain,
            'tags': self.tags,
            'username': self.username,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            database=d.get('database'),
            egress_filter=d.get('egress_filter'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            name=d.get('name'),
            override_database=d.get('override_database'),
            password=d.get('password'),
            port=d.get('port'),
            port_override=d.get('port_override'),
            proxy_cluster_id=d.get('proxy_cluster_id'),
            secret_store_id=d.get('secret_store_id'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
            username=d.get('username'),
        )


class ControlPanelGetRDPCAPublicKeyResponse:
    '''
         ControlPanelGetRDPCAPublicKeyResponse represents a request for an
     organization's RDP Certificate Authority public key.
    '''
    __slots__ = [
        'meta',
        'public_key',
        'rate_limit',
    ]

    def __init__(
        self,
        meta=None,
        public_key=None,
        rate_limit=None,
    ):
        self.meta = meta if meta is not None else None
        '''
         Reserved for future use.
        '''
        self.public_key = public_key if public_key is not None else ''
        '''
         The public key of the SSH Certificate Authority, in OpenSSH RSA public
         key format.
        '''
        self.rate_limit = rate_limit if rate_limit is not None else None
        '''
         Rate limit information.
        '''

    def __repr__(self):
        return '<sdm.ControlPanelGetRDPCAPublicKeyResponse ' + \
            'meta: ' + repr(self.meta) + ' ' +\
            'public_key: ' + repr(self.public_key) + ' ' +\
            'rate_limit: ' + repr(self.rate_limit) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'meta': self.meta,
            'public_key': self.public_key,
            'rate_limit': self.rate_limit,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            meta=d.get('meta'),
            public_key=d.get('public_key'),
            rate_limit=d.get('rate_limit'),
        )


class ControlPanelGetSSHCAPublicKeyResponse:
    '''
         ControlPanelGetSSHCAPublicKeyResponse represents a request for an
     organization's SSH Certificate Authority public key.
    '''
    __slots__ = [
        'meta',
        'public_key',
        'rate_limit',
    ]

    def __init__(
        self,
        meta=None,
        public_key=None,
        rate_limit=None,
    ):
        self.meta = meta if meta is not None else None
        '''
         Reserved for future use.
        '''
        self.public_key = public_key if public_key is not None else ''
        '''
         The public key of the SSH Certificate Authority, in OpenSSH RSA public
         key format.
        '''
        self.rate_limit = rate_limit if rate_limit is not None else None
        '''
         Rate limit information.
        '''

    def __repr__(self):
        return '<sdm.ControlPanelGetSSHCAPublicKeyResponse ' + \
            'meta: ' + repr(self.meta) + ' ' +\
            'public_key: ' + repr(self.public_key) + ' ' +\
            'rate_limit: ' + repr(self.rate_limit) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'meta': self.meta,
            'public_key': self.public_key,
            'rate_limit': self.rate_limit,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            meta=d.get('meta'),
            public_key=d.get('public_key'),
            rate_limit=d.get('rate_limit'),
        )


class ControlPanelVerifyJWTResponse:
    '''
         ControlPanelVerifyJWTResponse reports whether x-sdm-token is valid.
    '''
    __slots__ = [
        'meta',
        'rate_limit',
        'valid',
    ]

    def __init__(
        self,
        meta=None,
        rate_limit=None,
        valid=None,
    ):
        self.meta = meta if meta is not None else None
        '''
         Reserved for future use.
        '''
        self.rate_limit = rate_limit if rate_limit is not None else None
        '''
         Rate limit information.
        '''
        self.valid = valid if valid is not None else False
        '''
         Reports if the given token is valid.
        '''

    def __repr__(self):
        return '<sdm.ControlPanelVerifyJWTResponse ' + \
            'meta: ' + repr(self.meta) + ' ' +\
            'rate_limit: ' + repr(self.rate_limit) + ' ' +\
            'valid: ' + repr(self.valid) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'meta': self.meta,
            'rate_limit': self.rate_limit,
            'valid': self.valid,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            meta=d.get('meta'),
            rate_limit=d.get('rate_limit'),
            valid=d.get('valid'),
        )


class CouchbaseDatabase:
    __slots__ = [
        'bind_interface',
        'egress_filter',
        'healthy',
        'hostname',
        'id',
        'n1ql_port',
        'name',
        'password',
        'port',
        'port_override',
        'proxy_cluster_id',
        'secret_store_id',
        'subdomain',
        'tags',
        'tls_required',
        'username',
    ]

    def __init__(
        self,
        bind_interface=None,
        egress_filter=None,
        healthy=None,
        hostname=None,
        id=None,
        n1ql_port=None,
        name=None,
        password=None,
        port=None,
        port_override=None,
        proxy_cluster_id=None,
        secret_store_id=None,
        subdomain=None,
        tags=None,
        tls_required=None,
        username=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided and may also be set to one of the ResourceIPAllocationMode constants to select between VNM, loopback, or default allocation.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        '''
         The host to dial to initiate a connection from the egress node to this resource.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.n1ql_port = n1ql_port if n1ql_port is not None else 0
        '''
         The port number for N1QL queries. Default HTTP is 8093. Default HTTPS is 18093.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.password = password if password is not None else ''
        '''
         The password to authenticate with.
        '''
        self.port = port if port is not None else 0
        '''
         The port to dial to initiate a connection from the egress node to this resource.
        '''
        self.port_override = port_override if port_override is not None else 0
        '''
         The local port used by clients to connect to this resource. It is automatically generated if not provided on create and may be re-generated on update by specifying a value of -1.
        '''
        self.proxy_cluster_id = proxy_cluster_id if proxy_cluster_id is not None else ''
        '''
         ID of the proxy cluster for this resource, if any.
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         DNS subdomain through which this resource may be accessed on clients.  (e.g. "app-prod1" allows the resource to be accessed at "app-prod1.your-org-name.sdm-proxy-domain"). Only applicable to HTTP-based resources or resources using virtual networking mode.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.tls_required = tls_required if tls_required is not None else False
        '''
         If set, TLS must be used to connect to this resource.
        '''
        self.username = username if username is not None else ''
        '''
         The username to authenticate with.
        '''

    def __repr__(self):
        return '<sdm.CouchbaseDatabase ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'n1ql_port: ' + repr(self.n1ql_port) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'password: ' + repr(self.password) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'proxy_cluster_id: ' + repr(self.proxy_cluster_id) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'tls_required: ' + repr(self.tls_required) + ' ' +\
            'username: ' + repr(self.username) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'egress_filter': self.egress_filter,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'n1ql_port': self.n1ql_port,
            'name': self.name,
            'password': self.password,
            'port': self.port,
            'port_override': self.port_override,
            'proxy_cluster_id': self.proxy_cluster_id,
            'secret_store_id': self.secret_store_id,
            'subdomain': self.subdomain,
            'tags': self.tags,
            'tls_required': self.tls_required,
            'username': self.username,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            egress_filter=d.get('egress_filter'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            n1ql_port=d.get('n1ql_port'),
            name=d.get('name'),
            password=d.get('password'),
            port=d.get('port'),
            port_override=d.get('port_override'),
            proxy_cluster_id=d.get('proxy_cluster_id'),
            secret_store_id=d.get('secret_store_id'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
            tls_required=d.get('tls_required'),
            username=d.get('username'),
        )


class CouchbaseWebUI:
    __slots__ = [
        'bind_interface',
        'egress_filter',
        'healthy',
        'id',
        'name',
        'password',
        'port_override',
        'proxy_cluster_id',
        'secret_store_id',
        'subdomain',
        'tags',
        'url',
        'username',
    ]

    def __init__(
        self,
        bind_interface=None,
        egress_filter=None,
        healthy=None,
        id=None,
        name=None,
        password=None,
        port_override=None,
        proxy_cluster_id=None,
        secret_store_id=None,
        subdomain=None,
        tags=None,
        url=None,
        username=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided and may also be set to one of the ResourceIPAllocationMode constants to select between VNM, loopback, or default allocation.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.password = password if password is not None else ''
        '''
         The password to authenticate with.
        '''
        self.port_override = port_override if port_override is not None else 0
        '''
         The local port used by clients to connect to this resource. It is automatically generated if not provided on create and may be re-generated on update by specifying a value of -1.
        '''
        self.proxy_cluster_id = proxy_cluster_id if proxy_cluster_id is not None else ''
        '''
         ID of the proxy cluster for this resource, if any.
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         Subdomain is the local DNS address.  (e.g. app-prod1 turns into app-prod1.your-org-name.sdm.network)
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.url = url if url is not None else ''
        '''
         The base address of your website without the path.
        '''
        self.username = username if username is not None else ''
        '''
         The username to authenticate with.
        '''

    def __repr__(self):
        return '<sdm.CouchbaseWebUI ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'password: ' + repr(self.password) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'proxy_cluster_id: ' + repr(self.proxy_cluster_id) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'url: ' + repr(self.url) + ' ' +\
            'username: ' + repr(self.username) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'egress_filter': self.egress_filter,
            'healthy': self.healthy,
            'id': self.id,
            'name': self.name,
            'password': self.password,
            'port_override': self.port_override,
            'proxy_cluster_id': self.proxy_cluster_id,
            'secret_store_id': self.secret_store_id,
            'subdomain': self.subdomain,
            'tags': self.tags,
            'url': self.url,
            'username': self.username,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            egress_filter=d.get('egress_filter'),
            healthy=d.get('healthy'),
            id=d.get('id'),
            name=d.get('name'),
            password=d.get('password'),
            port_override=d.get('port_override'),
            proxy_cluster_id=d.get('proxy_cluster_id'),
            secret_store_id=d.get('secret_store_id'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
            url=d.get('url'),
            username=d.get('username'),
        )


class CreateResponseMetadata:
    '''
         CreateResponseMetadata is reserved for future use.
    '''
    __slots__ = []

    def __init__(self, ):
        pass

    def __repr__(self):
        return '<sdm.CreateResponseMetadata ' + \
            '>'

    def to_dict(self):
        return {}

    @classmethod
    def from_dict(cls, d):
        return cls()


class CyberarkConjurStore:
    __slots__ = [
        'appurl',
        'id',
        'name',
        'tags',
    ]

    def __init__(
        self,
        appurl=None,
        id=None,
        name=None,
        tags=None,
    ):
        self.appurl = appurl if appurl is not None else ''
        '''
         The URL of the Cyberark instance
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the SecretStore.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the SecretStore.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''

    def __repr__(self):
        return '<sdm.CyberarkConjurStore ' + \
            'appurl: ' + repr(self.appurl) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'appurl': self.appurl,
            'id': self.id,
            'name': self.name,
            'tags': self.tags,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            appurl=d.get('appurl'),
            id=d.get('id'),
            name=d.get('name'),
            tags=d.get('tags'),
        )


class CyberarkPAMExperimentalStore:
    '''
    CyberarkPAMExperimentalStore is currently unstable, and its API may change, or it may be removed,
    without a major version bump.
    '''
    __slots__ = [
        'appurl',
        'id',
        'name',
        'tags',
    ]

    def __init__(
        self,
        appurl=None,
        id=None,
        name=None,
        tags=None,
    ):
        self.appurl = appurl if appurl is not None else ''
        '''
         The URL of the Cyberark instance
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the SecretStore.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the SecretStore.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''

    def __repr__(self):
        return '<sdm.CyberarkPAMExperimentalStore ' + \
            'appurl: ' + repr(self.appurl) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'appurl': self.appurl,
            'id': self.id,
            'name': self.name,
            'tags': self.tags,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            appurl=d.get('appurl'),
            id=d.get('id'),
            name=d.get('name'),
            tags=d.get('tags'),
        )


class CyberarkPAMStore:
    __slots__ = [
        'appurl',
        'id',
        'name',
        'tags',
    ]

    def __init__(
        self,
        appurl=None,
        id=None,
        name=None,
        tags=None,
    ):
        self.appurl = appurl if appurl is not None else ''
        '''
         The URL of the Cyberark instance
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the SecretStore.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the SecretStore.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''

    def __repr__(self):
        return '<sdm.CyberarkPAMStore ' + \
            'appurl: ' + repr(self.appurl) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'appurl': self.appurl,
            'id': self.id,
            'name': self.name,
            'tags': self.tags,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            appurl=d.get('appurl'),
            id=d.get('id'),
            name=d.get('name'),
            tags=d.get('tags'),
        )


class DB2I:
    __slots__ = [
        'bind_interface',
        'egress_filter',
        'healthy',
        'hostname',
        'id',
        'name',
        'password',
        'port',
        'port_override',
        'proxy_cluster_id',
        'secret_store_id',
        'subdomain',
        'tags',
        'tls_required',
        'username',
    ]

    def __init__(
        self,
        bind_interface=None,
        egress_filter=None,
        healthy=None,
        hostname=None,
        id=None,
        name=None,
        password=None,
        port=None,
        port_override=None,
        proxy_cluster_id=None,
        secret_store_id=None,
        subdomain=None,
        tags=None,
        tls_required=None,
        username=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided and may also be set to one of the ResourceIPAllocationMode constants to select between VNM, loopback, or default allocation.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        '''
         The host to dial to initiate a connection from the egress node to this resource.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.password = password if password is not None else ''
        '''
         The password to authenticate with.
        '''
        self.port = port if port is not None else 0
        '''
         The port to dial to initiate a connection from the egress node to this resource.
        '''
        self.port_override = port_override if port_override is not None else 0
        '''
         The local port used by clients to connect to this resource. It is automatically generated if not provided on create and may be re-generated on update by specifying a value of -1.
        '''
        self.proxy_cluster_id = proxy_cluster_id if proxy_cluster_id is not None else ''
        '''
         ID of the proxy cluster for this resource, if any.
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         DNS subdomain through which this resource may be accessed on clients.  (e.g. "app-prod1" allows the resource to be accessed at "app-prod1.your-org-name.sdm-proxy-domain"). Only applicable to HTTP-based resources or resources using virtual networking mode.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.tls_required = tls_required if tls_required is not None else False
        '''
         If set, TLS must be used to connect to this resource.
        '''
        self.username = username if username is not None else ''
        '''
         The username to authenticate with.
        '''

    def __repr__(self):
        return '<sdm.DB2I ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'password: ' + repr(self.password) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'proxy_cluster_id: ' + repr(self.proxy_cluster_id) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'tls_required: ' + repr(self.tls_required) + ' ' +\
            'username: ' + repr(self.username) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'egress_filter': self.egress_filter,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'name': self.name,
            'password': self.password,
            'port': self.port,
            'port_override': self.port_override,
            'proxy_cluster_id': self.proxy_cluster_id,
            'secret_store_id': self.secret_store_id,
            'subdomain': self.subdomain,
            'tags': self.tags,
            'tls_required': self.tls_required,
            'username': self.username,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            egress_filter=d.get('egress_filter'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            name=d.get('name'),
            password=d.get('password'),
            port=d.get('port'),
            port_override=d.get('port_override'),
            proxy_cluster_id=d.get('proxy_cluster_id'),
            secret_store_id=d.get('secret_store_id'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
            tls_required=d.get('tls_required'),
            username=d.get('username'),
        )


class DB2LUW:
    __slots__ = [
        'bind_interface',
        'database',
        'egress_filter',
        'healthy',
        'hostname',
        'id',
        'name',
        'password',
        'port',
        'port_override',
        'proxy_cluster_id',
        'secret_store_id',
        'subdomain',
        'tags',
        'tls_required',
        'username',
    ]

    def __init__(
        self,
        bind_interface=None,
        database=None,
        egress_filter=None,
        healthy=None,
        hostname=None,
        id=None,
        name=None,
        password=None,
        port=None,
        port_override=None,
        proxy_cluster_id=None,
        secret_store_id=None,
        subdomain=None,
        tags=None,
        tls_required=None,
        username=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided and may also be set to one of the ResourceIPAllocationMode constants to select between VNM, loopback, or default allocation.
        '''
        self.database = database if database is not None else ''
        '''
         The initial database to connect to. This setting does not by itself prevent switching to another database after connecting.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        '''
         The host to dial to initiate a connection from the egress node to this resource.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.password = password if password is not None else ''
        '''
         The password to authenticate with.
        '''
        self.port = port if port is not None else 0
        '''
         The port to dial to initiate a connection from the egress node to this resource.
        '''
        self.port_override = port_override if port_override is not None else 0
        '''
         The local port used by clients to connect to this resource. It is automatically generated if not provided on create and may be re-generated on update by specifying a value of -1.
        '''
        self.proxy_cluster_id = proxy_cluster_id if proxy_cluster_id is not None else ''
        '''
         ID of the proxy cluster for this resource, if any.
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         DNS subdomain through which this resource may be accessed on clients.  (e.g. "app-prod1" allows the resource to be accessed at "app-prod1.your-org-name.sdm-proxy-domain"). Only applicable to HTTP-based resources or resources using virtual networking mode.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.tls_required = tls_required if tls_required is not None else False
        '''
         If set, TLS must be used to connect to this resource.
        '''
        self.username = username if username is not None else ''
        '''
         The username to authenticate with.
        '''

    def __repr__(self):
        return '<sdm.DB2LUW ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'database: ' + repr(self.database) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'password: ' + repr(self.password) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'proxy_cluster_id: ' + repr(self.proxy_cluster_id) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'tls_required: ' + repr(self.tls_required) + ' ' +\
            'username: ' + repr(self.username) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'database': self.database,
            'egress_filter': self.egress_filter,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'name': self.name,
            'password': self.password,
            'port': self.port,
            'port_override': self.port_override,
            'proxy_cluster_id': self.proxy_cluster_id,
            'secret_store_id': self.secret_store_id,
            'subdomain': self.subdomain,
            'tags': self.tags,
            'tls_required': self.tls_required,
            'username': self.username,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            database=d.get('database'),
            egress_filter=d.get('egress_filter'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            name=d.get('name'),
            password=d.get('password'),
            port=d.get('port'),
            port_override=d.get('port_override'),
            proxy_cluster_id=d.get('proxy_cluster_id'),
            secret_store_id=d.get('secret_store_id'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
            tls_required=d.get('tls_required'),
            username=d.get('username'),
        )


class DeleteResponseMetadata:
    '''
         DeleteResponseMetadata is reserved for future use.
    '''
    __slots__ = []

    def __init__(self, ):
        pass

    def __repr__(self):
        return '<sdm.DeleteResponseMetadata ' + \
            '>'

    def to_dict(self):
        return {}

    @classmethod
    def from_dict(cls, d):
        return cls()


class DelineaStore:
    __slots__ = [
        'id',
        'name',
        'server_url',
        'tags',
        'tenant_name',
    ]

    def __init__(
        self,
        id=None,
        name=None,
        server_url=None,
        tags=None,
        tenant_name=None,
    ):
        self.id = id if id is not None else ''
        '''
         Unique identifier of the SecretStore.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the SecretStore.
        '''
        self.server_url = server_url if server_url is not None else ''
        '''
         The URL of the Delinea instance
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.tenant_name = tenant_name if tenant_name is not None else ''
        '''
         The tenant name to target
        '''

    def __repr__(self):
        return '<sdm.DelineaStore ' + \
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'server_url: ' + repr(self.server_url) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'tenant_name: ' + repr(self.tenant_name) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'id': self.id,
            'name': self.name,
            'server_url': self.server_url,
            'tags': self.tags,
            'tenant_name': self.tenant_name,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            id=d.get('id'),
            name=d.get('name'),
            server_url=d.get('server_url'),
            tags=d.get('tags'),
            tenant_name=d.get('tenant_name'),
        )


class DocumentDBHost:
    __slots__ = [
        'auth_database',
        'bind_interface',
        'egress_filter',
        'healthy',
        'hostname',
        'id',
        'name',
        'password',
        'port',
        'port_override',
        'proxy_cluster_id',
        'secret_store_id',
        'subdomain',
        'tags',
        'username',
    ]

    def __init__(
        self,
        auth_database=None,
        bind_interface=None,
        egress_filter=None,
        healthy=None,
        hostname=None,
        id=None,
        name=None,
        password=None,
        port=None,
        port_override=None,
        proxy_cluster_id=None,
        secret_store_id=None,
        subdomain=None,
        tags=None,
        username=None,
    ):
        self.auth_database = auth_database if auth_database is not None else ''
        '''
         The authentication database to use.
        '''
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided and may also be set to one of the ResourceIPAllocationMode constants to select between VNM, loopback, or default allocation.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        '''
         The host to dial to initiate a connection from the egress node to this resource.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.password = password if password is not None else ''
        '''
         The password to authenticate with.
        '''
        self.port = port if port is not None else 0
        '''
         The port to dial to initiate a connection from the egress node to this resource.
        '''
        self.port_override = port_override if port_override is not None else 0
        '''
         The local port used by clients to connect to this resource. It is automatically generated if not provided on create and may be re-generated on update by specifying a value of -1.
        '''
        self.proxy_cluster_id = proxy_cluster_id if proxy_cluster_id is not None else ''
        '''
         ID of the proxy cluster for this resource, if any.
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         DNS subdomain through which this resource may be accessed on clients.  (e.g. "app-prod1" allows the resource to be accessed at "app-prod1.your-org-name.sdm-proxy-domain"). Only applicable to HTTP-based resources or resources using virtual networking mode.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.username = username if username is not None else ''
        '''
         The username to authenticate with.
        '''

    def __repr__(self):
        return '<sdm.DocumentDBHost ' + \
            'auth_database: ' + repr(self.auth_database) + ' ' +\
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'password: ' + repr(self.password) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'proxy_cluster_id: ' + repr(self.proxy_cluster_id) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'username: ' + repr(self.username) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'auth_database': self.auth_database,
            'bind_interface': self.bind_interface,
            'egress_filter': self.egress_filter,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'name': self.name,
            'password': self.password,
            'port': self.port,
            'port_override': self.port_override,
            'proxy_cluster_id': self.proxy_cluster_id,
            'secret_store_id': self.secret_store_id,
            'subdomain': self.subdomain,
            'tags': self.tags,
            'username': self.username,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            auth_database=d.get('auth_database'),
            bind_interface=d.get('bind_interface'),
            egress_filter=d.get('egress_filter'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            name=d.get('name'),
            password=d.get('password'),
            port=d.get('port'),
            port_override=d.get('port_override'),
            proxy_cluster_id=d.get('proxy_cluster_id'),
            secret_store_id=d.get('secret_store_id'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
            username=d.get('username'),
        )


class DocumentDBHostIAM:
    __slots__ = [
        'bind_interface',
        'egress_filter',
        'healthy',
        'hostname',
        'id',
        'name',
        'port',
        'port_override',
        'proxy_cluster_id',
        'region',
        'secret_store_id',
        'subdomain',
        'tags',
    ]

    def __init__(
        self,
        bind_interface=None,
        egress_filter=None,
        healthy=None,
        hostname=None,
        id=None,
        name=None,
        port=None,
        port_override=None,
        proxy_cluster_id=None,
        region=None,
        secret_store_id=None,
        subdomain=None,
        tags=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided and may also be set to one of the ResourceIPAllocationMode constants to select between VNM, loopback, or default allocation.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        '''
         The host to dial to initiate a connection from the egress node to this resource.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.port = port if port is not None else 0
        '''
         The port to dial to initiate a connection from the egress node to this resource.
        '''
        self.port_override = port_override if port_override is not None else 0
        '''
         The local port used by clients to connect to this resource. It is automatically generated if not provided on create and may be re-generated on update by specifying a value of -1.
        '''
        self.proxy_cluster_id = proxy_cluster_id if proxy_cluster_id is not None else ''
        '''
         ID of the proxy cluster for this resource, if any.
        '''
        self.region = region if region is not None else ''
        '''
         The AWS region to connect to.
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         DNS subdomain through which this resource may be accessed on clients.  (e.g. "app-prod1" allows the resource to be accessed at "app-prod1.your-org-name.sdm-proxy-domain"). Only applicable to HTTP-based resources or resources using virtual networking mode.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''

    def __repr__(self):
        return '<sdm.DocumentDBHostIAM ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'proxy_cluster_id: ' + repr(self.proxy_cluster_id) + ' ' +\
            'region: ' + repr(self.region) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'egress_filter': self.egress_filter,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'name': self.name,
            'port': self.port,
            'port_override': self.port_override,
            'proxy_cluster_id': self.proxy_cluster_id,
            'region': self.region,
            'secret_store_id': self.secret_store_id,
            'subdomain': self.subdomain,
            'tags': self.tags,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            egress_filter=d.get('egress_filter'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            name=d.get('name'),
            port=d.get('port'),
            port_override=d.get('port_override'),
            proxy_cluster_id=d.get('proxy_cluster_id'),
            region=d.get('region'),
            secret_store_id=d.get('secret_store_id'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
        )


class DocumentDBReplicaSet:
    __slots__ = [
        'auth_database',
        'bind_interface',
        'connect_to_replica',
        'egress_filter',
        'healthy',
        'hostname',
        'id',
        'name',
        'password',
        'port_override',
        'proxy_cluster_id',
        'replica_set',
        'secret_store_id',
        'subdomain',
        'tags',
        'username',
    ]

    def __init__(
        self,
        auth_database=None,
        bind_interface=None,
        connect_to_replica=None,
        egress_filter=None,
        healthy=None,
        hostname=None,
        id=None,
        name=None,
        password=None,
        port_override=None,
        proxy_cluster_id=None,
        replica_set=None,
        secret_store_id=None,
        subdomain=None,
        tags=None,
        username=None,
    ):
        self.auth_database = auth_database if auth_database is not None else ''
        '''
         The authentication database to use.
        '''
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided and may also be set to one of the ResourceIPAllocationMode constants to select between VNM, loopback, or default allocation.
        '''
        self.connect_to_replica = connect_to_replica if connect_to_replica is not None else False
        '''
         Set to connect to a replica instead of the primary node.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        '''
         Hostname must contain the hostname/port pairs of all instances in the replica set separated by commas.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.password = password if password is not None else ''
        '''
         The password to authenticate with.
        '''
        self.port_override = port_override if port_override is not None else 0
        '''
         The local port used by clients to connect to this resource. It is automatically generated if not provided on create and may be re-generated on update by specifying a value of -1.
        '''
        self.proxy_cluster_id = proxy_cluster_id if proxy_cluster_id is not None else ''
        '''
         ID of the proxy cluster for this resource, if any.
        '''
        self.replica_set = replica_set if replica_set is not None else ''
        '''
         The name of the mongo replicaset.
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         DNS subdomain through which this resource may be accessed on clients.  (e.g. "app-prod1" allows the resource to be accessed at "app-prod1.your-org-name.sdm-proxy-domain"). Only applicable to HTTP-based resources or resources using virtual networking mode.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.username = username if username is not None else ''
        '''
         The username to authenticate with.
        '''

    def __repr__(self):
        return '<sdm.DocumentDBReplicaSet ' + \
            'auth_database: ' + repr(self.auth_database) + ' ' +\
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'connect_to_replica: ' + repr(self.connect_to_replica) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'password: ' + repr(self.password) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'proxy_cluster_id: ' + repr(self.proxy_cluster_id) + ' ' +\
            'replica_set: ' + repr(self.replica_set) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'username: ' + repr(self.username) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'auth_database': self.auth_database,
            'bind_interface': self.bind_interface,
            'connect_to_replica': self.connect_to_replica,
            'egress_filter': self.egress_filter,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'name': self.name,
            'password': self.password,
            'port_override': self.port_override,
            'proxy_cluster_id': self.proxy_cluster_id,
            'replica_set': self.replica_set,
            'secret_store_id': self.secret_store_id,
            'subdomain': self.subdomain,
            'tags': self.tags,
            'username': self.username,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            auth_database=d.get('auth_database'),
            bind_interface=d.get('bind_interface'),
            connect_to_replica=d.get('connect_to_replica'),
            egress_filter=d.get('egress_filter'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            name=d.get('name'),
            password=d.get('password'),
            port_override=d.get('port_override'),
            proxy_cluster_id=d.get('proxy_cluster_id'),
            replica_set=d.get('replica_set'),
            secret_store_id=d.get('secret_store_id'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
            username=d.get('username'),
        )


class DocumentDBReplicaSetIAM:
    '''
    DocumentDBReplicaSetIAM is currently unstable, and its API may change, or it may be removed,
    without a major version bump.
    '''
    __slots__ = [
        'bind_interface',
        'connect_to_replica',
        'egress_filter',
        'healthy',
        'hostname',
        'id',
        'name',
        'port_override',
        'proxy_cluster_id',
        'region',
        'secret_store_id',
        'subdomain',
        'tags',
    ]

    def __init__(
        self,
        bind_interface=None,
        connect_to_replica=None,
        egress_filter=None,
        healthy=None,
        hostname=None,
        id=None,
        name=None,
        port_override=None,
        proxy_cluster_id=None,
        region=None,
        secret_store_id=None,
        subdomain=None,
        tags=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided and may also be set to one of the ResourceIPAllocationMode constants to select between VNM, loopback, or default allocation.
        '''
        self.connect_to_replica = connect_to_replica if connect_to_replica is not None else False
        '''
         Set to connect to a replica instead of the primary node.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        '''
         Hostname must contain the hostname/port pairs of all instances in the replica set separated by commas.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.port_override = port_override if port_override is not None else 0
        '''
         The local port used by clients to connect to this resource. It is automatically generated if not provided on create and may be re-generated on update by specifying a value of -1.
        '''
        self.proxy_cluster_id = proxy_cluster_id if proxy_cluster_id is not None else ''
        '''
         ID of the proxy cluster for this resource, if any.
        '''
        self.region = region if region is not None else ''
        '''
         The region of the document db cluster
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         DNS subdomain through which this resource may be accessed on clients.  (e.g. "app-prod1" allows the resource to be accessed at "app-prod1.your-org-name.sdm-proxy-domain"). Only applicable to HTTP-based resources or resources using virtual networking mode.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''

    def __repr__(self):
        return '<sdm.DocumentDBReplicaSetIAM ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'connect_to_replica: ' + repr(self.connect_to_replica) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'proxy_cluster_id: ' + repr(self.proxy_cluster_id) + ' ' +\
            'region: ' + repr(self.region) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'connect_to_replica': self.connect_to_replica,
            'egress_filter': self.egress_filter,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'name': self.name,
            'port_override': self.port_override,
            'proxy_cluster_id': self.proxy_cluster_id,
            'region': self.region,
            'secret_store_id': self.secret_store_id,
            'subdomain': self.subdomain,
            'tags': self.tags,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            connect_to_replica=d.get('connect_to_replica'),
            egress_filter=d.get('egress_filter'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            name=d.get('name'),
            port_override=d.get('port_override'),
            proxy_cluster_id=d.get('proxy_cluster_id'),
            region=d.get('region'),
            secret_store_id=d.get('secret_store_id'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
        )


class Druid:
    __slots__ = [
        'bind_interface',
        'egress_filter',
        'healthy',
        'hostname',
        'id',
        'name',
        'password',
        'port',
        'port_override',
        'proxy_cluster_id',
        'secret_store_id',
        'subdomain',
        'tags',
        'username',
    ]

    def __init__(
        self,
        bind_interface=None,
        egress_filter=None,
        healthy=None,
        hostname=None,
        id=None,
        name=None,
        password=None,
        port=None,
        port_override=None,
        proxy_cluster_id=None,
        secret_store_id=None,
        subdomain=None,
        tags=None,
        username=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided and may also be set to one of the ResourceIPAllocationMode constants to select between VNM, loopback, or default allocation.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        '''
         The host to dial to initiate a connection from the egress node to this resource.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.password = password if password is not None else ''
        '''
         The password to authenticate with.
        '''
        self.port = port if port is not None else 0
        '''
         The port to dial to initiate a connection from the egress node to this resource.
        '''
        self.port_override = port_override if port_override is not None else 0
        '''
         The local port used by clients to connect to this resource. It is automatically generated if not provided on create and may be re-generated on update by specifying a value of -1.
        '''
        self.proxy_cluster_id = proxy_cluster_id if proxy_cluster_id is not None else ''
        '''
         ID of the proxy cluster for this resource, if any.
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         DNS subdomain through which this resource may be accessed on clients.  (e.g. "app-prod1" allows the resource to be accessed at "app-prod1.your-org-name.sdm-proxy-domain"). Only applicable to HTTP-based resources or resources using virtual networking mode.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.username = username if username is not None else ''
        '''
         The username to authenticate with.
        '''

    def __repr__(self):
        return '<sdm.Druid ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'password: ' + repr(self.password) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'proxy_cluster_id: ' + repr(self.proxy_cluster_id) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'username: ' + repr(self.username) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'egress_filter': self.egress_filter,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'name': self.name,
            'password': self.password,
            'port': self.port,
            'port_override': self.port_override,
            'proxy_cluster_id': self.proxy_cluster_id,
            'secret_store_id': self.secret_store_id,
            'subdomain': self.subdomain,
            'tags': self.tags,
            'username': self.username,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            egress_filter=d.get('egress_filter'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            name=d.get('name'),
            password=d.get('password'),
            port=d.get('port'),
            port_override=d.get('port_override'),
            proxy_cluster_id=d.get('proxy_cluster_id'),
            secret_store_id=d.get('secret_store_id'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
            username=d.get('username'),
        )


class DynamoDB:
    __slots__ = [
        'access_key',
        'bind_interface',
        'egress_filter',
        'endpoint',
        'healthy',
        'id',
        'name',
        'port_override',
        'proxy_cluster_id',
        'region',
        'role_arn',
        'role_external_id',
        'secret_access_key',
        'secret_store_id',
        'subdomain',
        'tags',
    ]

    def __init__(
        self,
        access_key=None,
        bind_interface=None,
        egress_filter=None,
        endpoint=None,
        healthy=None,
        id=None,
        name=None,
        port_override=None,
        proxy_cluster_id=None,
        region=None,
        role_arn=None,
        role_external_id=None,
        secret_access_key=None,
        secret_store_id=None,
        subdomain=None,
        tags=None,
    ):
        self.access_key = access_key if access_key is not None else ''
        '''
         The Access Key ID to use to authenticate.
        '''
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided and may also be set to one of the ResourceIPAllocationMode constants to select between VNM, loopback, or default allocation.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.endpoint = endpoint if endpoint is not None else ''
        '''
         The endpoint to dial e.g. dynamodb.region.amazonaws.com
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.port_override = port_override if port_override is not None else 0
        '''
         The local port used by clients to connect to this resource. It is automatically generated if not provided on create and may be re-generated on update by specifying a value of -1.
        '''
        self.proxy_cluster_id = proxy_cluster_id if proxy_cluster_id is not None else ''
        '''
         ID of the proxy cluster for this resource, if any.
        '''
        self.region = region if region is not None else ''
        '''
         The region to authenticate requests against e.g. us-east-1
        '''
        self.role_arn = role_arn if role_arn is not None else ''
        '''
         The role to assume after logging in.
        '''
        self.role_external_id = role_external_id if role_external_id is not None else ''
        '''
         The external ID to associate with assume role requests. Does nothing if a role ARN is not provided.
        '''
        self.secret_access_key = secret_access_key if secret_access_key is not None else ''
        '''
         The Secret Access Key to use to authenticate.
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         DNS subdomain through which this resource may be accessed on clients.  (e.g. "app-prod1" allows the resource to be accessed at "app-prod1.your-org-name.sdm-proxy-domain"). Only applicable to HTTP-based resources or resources using virtual networking mode.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''

    def __repr__(self):
        return '<sdm.DynamoDB ' + \
            'access_key: ' + repr(self.access_key) + ' ' +\
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'endpoint: ' + repr(self.endpoint) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'proxy_cluster_id: ' + repr(self.proxy_cluster_id) + ' ' +\
            'region: ' + repr(self.region) + ' ' +\
            'role_arn: ' + repr(self.role_arn) + ' ' +\
            'role_external_id: ' + repr(self.role_external_id) + ' ' +\
            'secret_access_key: ' + repr(self.secret_access_key) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'access_key': self.access_key,
            'bind_interface': self.bind_interface,
            'egress_filter': self.egress_filter,
            'endpoint': self.endpoint,
            'healthy': self.healthy,
            'id': self.id,
            'name': self.name,
            'port_override': self.port_override,
            'proxy_cluster_id': self.proxy_cluster_id,
            'region': self.region,
            'role_arn': self.role_arn,
            'role_external_id': self.role_external_id,
            'secret_access_key': self.secret_access_key,
            'secret_store_id': self.secret_store_id,
            'subdomain': self.subdomain,
            'tags': self.tags,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            access_key=d.get('access_key'),
            bind_interface=d.get('bind_interface'),
            egress_filter=d.get('egress_filter'),
            endpoint=d.get('endpoint'),
            healthy=d.get('healthy'),
            id=d.get('id'),
            name=d.get('name'),
            port_override=d.get('port_override'),
            proxy_cluster_id=d.get('proxy_cluster_id'),
            region=d.get('region'),
            role_arn=d.get('role_arn'),
            role_external_id=d.get('role_external_id'),
            secret_access_key=d.get('secret_access_key'),
            secret_store_id=d.get('secret_store_id'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
        )


class DynamoDBIAM:
    __slots__ = [
        'bind_interface',
        'egress_filter',
        'endpoint',
        'healthy',
        'id',
        'name',
        'port_override',
        'proxy_cluster_id',
        'region',
        'role_arn',
        'role_external_id',
        'secret_store_id',
        'subdomain',
        'tags',
    ]

    def __init__(
        self,
        bind_interface=None,
        egress_filter=None,
        endpoint=None,
        healthy=None,
        id=None,
        name=None,
        port_override=None,
        proxy_cluster_id=None,
        region=None,
        role_arn=None,
        role_external_id=None,
        secret_store_id=None,
        subdomain=None,
        tags=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided and may also be set to one of the ResourceIPAllocationMode constants to select between VNM, loopback, or default allocation.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.endpoint = endpoint if endpoint is not None else ''
        '''
         The endpoint to dial e.g. dynamodb.region.amazonaws.com
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.port_override = port_override if port_override is not None else 0
        '''
         The local port used by clients to connect to this resource. It is automatically generated if not provided on create and may be re-generated on update by specifying a value of -1.
        '''
        self.proxy_cluster_id = proxy_cluster_id if proxy_cluster_id is not None else ''
        '''
         ID of the proxy cluster for this resource, if any.
        '''
        self.region = region if region is not None else ''
        '''
         The region to authenticate requests against e.g. us-east-1
        '''
        self.role_arn = role_arn if role_arn is not None else ''
        '''
         The role to assume after logging in.
        '''
        self.role_external_id = role_external_id if role_external_id is not None else ''
        '''
         The external ID to associate with assume role requests. Does nothing if a role ARN is not provided.
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         DNS subdomain through which this resource may be accessed on clients.  (e.g. "app-prod1" allows the resource to be accessed at "app-prod1.your-org-name.sdm-proxy-domain"). Only applicable to HTTP-based resources or resources using virtual networking mode.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''

    def __repr__(self):
        return '<sdm.DynamoDBIAM ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'endpoint: ' + repr(self.endpoint) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'proxy_cluster_id: ' + repr(self.proxy_cluster_id) + ' ' +\
            'region: ' + repr(self.region) + ' ' +\
            'role_arn: ' + repr(self.role_arn) + ' ' +\
            'role_external_id: ' + repr(self.role_external_id) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'egress_filter': self.egress_filter,
            'endpoint': self.endpoint,
            'healthy': self.healthy,
            'id': self.id,
            'name': self.name,
            'port_override': self.port_override,
            'proxy_cluster_id': self.proxy_cluster_id,
            'region': self.region,
            'role_arn': self.role_arn,
            'role_external_id': self.role_external_id,
            'secret_store_id': self.secret_store_id,
            'subdomain': self.subdomain,
            'tags': self.tags,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            egress_filter=d.get('egress_filter'),
            endpoint=d.get('endpoint'),
            healthy=d.get('healthy'),
            id=d.get('id'),
            name=d.get('name'),
            port_override=d.get('port_override'),
            proxy_cluster_id=d.get('proxy_cluster_id'),
            region=d.get('region'),
            role_arn=d.get('role_arn'),
            role_external_id=d.get('role_external_id'),
            secret_store_id=d.get('secret_store_id'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
        )


class Elastic:
    __slots__ = [
        'bind_interface',
        'egress_filter',
        'healthy',
        'hostname',
        'id',
        'name',
        'password',
        'port',
        'port_override',
        'proxy_cluster_id',
        'secret_store_id',
        'subdomain',
        'tags',
        'tls_required',
        'username',
    ]

    def __init__(
        self,
        bind_interface=None,
        egress_filter=None,
        healthy=None,
        hostname=None,
        id=None,
        name=None,
        password=None,
        port=None,
        port_override=None,
        proxy_cluster_id=None,
        secret_store_id=None,
        subdomain=None,
        tags=None,
        tls_required=None,
        username=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided and may also be set to one of the ResourceIPAllocationMode constants to select between VNM, loopback, or default allocation.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        '''
         The host to dial to initiate a connection from the egress node to this resource.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.password = password if password is not None else ''
        '''
         The password to authenticate with.
        '''
        self.port = port if port is not None else 0
        '''
         The port to dial to initiate a connection from the egress node to this resource.
        '''
        self.port_override = port_override if port_override is not None else 0
        '''
         The local port used by clients to connect to this resource. It is automatically generated if not provided on create and may be re-generated on update by specifying a value of -1.
        '''
        self.proxy_cluster_id = proxy_cluster_id if proxy_cluster_id is not None else ''
        '''
         ID of the proxy cluster for this resource, if any.
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         DNS subdomain through which this resource may be accessed on clients.  (e.g. "app-prod1" allows the resource to be accessed at "app-prod1.your-org-name.sdm-proxy-domain"). Only applicable to HTTP-based resources or resources using virtual networking mode.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.tls_required = tls_required if tls_required is not None else False
        '''
         If set, TLS must be used to connect to this resource.
        '''
        self.username = username if username is not None else ''
        '''
         The username to authenticate with.
        '''

    def __repr__(self):
        return '<sdm.Elastic ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'password: ' + repr(self.password) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'proxy_cluster_id: ' + repr(self.proxy_cluster_id) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'tls_required: ' + repr(self.tls_required) + ' ' +\
            'username: ' + repr(self.username) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'egress_filter': self.egress_filter,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'name': self.name,
            'password': self.password,
            'port': self.port,
            'port_override': self.port_override,
            'proxy_cluster_id': self.proxy_cluster_id,
            'secret_store_id': self.secret_store_id,
            'subdomain': self.subdomain,
            'tags': self.tags,
            'tls_required': self.tls_required,
            'username': self.username,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            egress_filter=d.get('egress_filter'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            name=d.get('name'),
            password=d.get('password'),
            port=d.get('port'),
            port_override=d.get('port_override'),
            proxy_cluster_id=d.get('proxy_cluster_id'),
            secret_store_id=d.get('secret_store_id'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
            tls_required=d.get('tls_required'),
            username=d.get('username'),
        )


class ElasticacheRedis:
    __slots__ = [
        'bind_interface',
        'egress_filter',
        'healthy',
        'hostname',
        'id',
        'name',
        'password',
        'port',
        'port_override',
        'proxy_cluster_id',
        'secret_store_id',
        'subdomain',
        'tags',
        'tls_required',
        'username',
    ]

    def __init__(
        self,
        bind_interface=None,
        egress_filter=None,
        healthy=None,
        hostname=None,
        id=None,
        name=None,
        password=None,
        port=None,
        port_override=None,
        proxy_cluster_id=None,
        secret_store_id=None,
        subdomain=None,
        tags=None,
        tls_required=None,
        username=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided and may also be set to one of the ResourceIPAllocationMode constants to select between VNM, loopback, or default allocation.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        '''
         The host to dial to initiate a connection from the egress node to this resource.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.password = password if password is not None else ''
        '''
         The password to authenticate with.
        '''
        self.port = port if port is not None else 0
        '''
         The port to dial to initiate a connection from the egress node to this resource.
        '''
        self.port_override = port_override if port_override is not None else 0
        '''
         The local port used by clients to connect to this resource. It is automatically generated if not provided on create and may be re-generated on update by specifying a value of -1.
        '''
        self.proxy_cluster_id = proxy_cluster_id if proxy_cluster_id is not None else ''
        '''
         ID of the proxy cluster for this resource, if any.
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         DNS subdomain through which this resource may be accessed on clients.  (e.g. "app-prod1" allows the resource to be accessed at "app-prod1.your-org-name.sdm-proxy-domain"). Only applicable to HTTP-based resources or resources using virtual networking mode.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.tls_required = tls_required if tls_required is not None else False
        '''
         If set, TLS must be used to connect to this resource.
        '''
        self.username = username if username is not None else ''
        '''
         The username to authenticate with.
        '''

    def __repr__(self):
        return '<sdm.ElasticacheRedis ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'password: ' + repr(self.password) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'proxy_cluster_id: ' + repr(self.proxy_cluster_id) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'tls_required: ' + repr(self.tls_required) + ' ' +\
            'username: ' + repr(self.username) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'egress_filter': self.egress_filter,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'name': self.name,
            'password': self.password,
            'port': self.port,
            'port_override': self.port_override,
            'proxy_cluster_id': self.proxy_cluster_id,
            'secret_store_id': self.secret_store_id,
            'subdomain': self.subdomain,
            'tags': self.tags,
            'tls_required': self.tls_required,
            'username': self.username,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            egress_filter=d.get('egress_filter'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            name=d.get('name'),
            password=d.get('password'),
            port=d.get('port'),
            port_override=d.get('port_override'),
            proxy_cluster_id=d.get('proxy_cluster_id'),
            secret_store_id=d.get('secret_store_id'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
            tls_required=d.get('tls_required'),
            username=d.get('username'),
        )


class EntraID:
    __slots__ = [
        'bind_interface',
        'discovery_enabled',
        'egress_filter',
        'group_names',
        'healthy',
        'id',
        'identity_set_id',
        'management_group_id',
        'name',
        'privilege_levels',
        'proxy_cluster_id',
        'resource_group_id',
        'secret_store_id',
        'subdomain',
        'subscription_id',
        'tags',
        'tenant_id',
    ]

    def __init__(
        self,
        bind_interface=None,
        discovery_enabled=None,
        egress_filter=None,
        group_names=None,
        healthy=None,
        id=None,
        identity_set_id=None,
        management_group_id=None,
        name=None,
        privilege_levels=None,
        proxy_cluster_id=None,
        resource_group_id=None,
        secret_store_id=None,
        subdomain=None,
        subscription_id=None,
        tags=None,
        tenant_id=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided and may also be set to one of the ResourceIPAllocationMode constants to select between VNM, loopback, or default allocation.
        '''
        self.discovery_enabled = discovery_enabled if discovery_enabled is not None else False
        '''
         If true, configures discovery of the tenant to be run from a node.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.group_names = group_names if group_names is not None else ''
        '''
         comma separated list of group names to filter by. Supports wildcards (*)
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.identity_set_id = identity_set_id if identity_set_id is not None else ''
        '''
         The ID of the identity set to use for identity connections.
        '''
        self.management_group_id = management_group_id if management_group_id is not None else ''
        '''
         The management group ID to authenticate scope Privileges to.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.privilege_levels = privilege_levels if privilege_levels is not None else ''
        '''
         The privilege levels specify which Groups are managed externally
        '''
        self.proxy_cluster_id = proxy_cluster_id if proxy_cluster_id is not None else ''
        '''
         ID of the proxy cluster for this resource, if any.
        '''
        self.resource_group_id = resource_group_id if resource_group_id is not None else ''
        '''
         filters discovered groups to the specified Resource Group
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         DNS subdomain through which this resource may be accessed on clients.  (e.g. "app-prod1" allows the resource to be accessed at "app-prod1.your-org-name.sdm-proxy-domain"). Only applicable to HTTP-based resources or resources using virtual networking mode.
        '''
        self.subscription_id = subscription_id if subscription_id is not None else ''
        '''
         The subscription ID to authenticate scope Privileges to.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.tenant_id = tenant_id if tenant_id is not None else ''
        '''
         The connector ID to authenticate through.
        '''

    def __repr__(self):
        return '<sdm.EntraID ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'discovery_enabled: ' + repr(self.discovery_enabled) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'group_names: ' + repr(self.group_names) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'identity_set_id: ' + repr(self.identity_set_id) + ' ' +\
            'management_group_id: ' + repr(self.management_group_id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'privilege_levels: ' + repr(self.privilege_levels) + ' ' +\
            'proxy_cluster_id: ' + repr(self.proxy_cluster_id) + ' ' +\
            'resource_group_id: ' + repr(self.resource_group_id) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'subscription_id: ' + repr(self.subscription_id) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'tenant_id: ' + repr(self.tenant_id) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'discovery_enabled': self.discovery_enabled,
            'egress_filter': self.egress_filter,
            'group_names': self.group_names,
            'healthy': self.healthy,
            'id': self.id,
            'identity_set_id': self.identity_set_id,
            'management_group_id': self.management_group_id,
            'name': self.name,
            'privilege_levels': self.privilege_levels,
            'proxy_cluster_id': self.proxy_cluster_id,
            'resource_group_id': self.resource_group_id,
            'secret_store_id': self.secret_store_id,
            'subdomain': self.subdomain,
            'subscription_id': self.subscription_id,
            'tags': self.tags,
            'tenant_id': self.tenant_id,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            discovery_enabled=d.get('discovery_enabled'),
            egress_filter=d.get('egress_filter'),
            group_names=d.get('group_names'),
            healthy=d.get('healthy'),
            id=d.get('id'),
            identity_set_id=d.get('identity_set_id'),
            management_group_id=d.get('management_group_id'),
            name=d.get('name'),
            privilege_levels=d.get('privilege_levels'),
            proxy_cluster_id=d.get('proxy_cluster_id'),
            resource_group_id=d.get('resource_group_id'),
            secret_store_id=d.get('secret_store_id'),
            subdomain=d.get('subdomain'),
            subscription_id=d.get('subscription_id'),
            tags=d.get('tags'),
            tenant_id=d.get('tenant_id'),
        )


class GCP:
    __slots__ = [
        'bind_interface',
        'egress_filter',
        'healthy',
        'id',
        'keyfile',
        'name',
        'port_override',
        'proxy_cluster_id',
        'scopes',
        'secret_store_id',
        'subdomain',
        'tags',
    ]

    def __init__(
        self,
        bind_interface=None,
        egress_filter=None,
        healthy=None,
        id=None,
        keyfile=None,
        name=None,
        port_override=None,
        proxy_cluster_id=None,
        scopes=None,
        secret_store_id=None,
        subdomain=None,
        tags=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided and may also be set to one of the ResourceIPAllocationMode constants to select between VNM, loopback, or default allocation.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.keyfile = keyfile if keyfile is not None else ''
        '''
         The service account keyfile to authenticate with.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.port_override = port_override if port_override is not None else 0
        '''
         The local port used by clients to connect to this resource. It is automatically generated if not provided on create and may be re-generated on update by specifying a value of -1.
        '''
        self.proxy_cluster_id = proxy_cluster_id if proxy_cluster_id is not None else ''
        '''
         ID of the proxy cluster for this resource, if any.
        '''
        self.scopes = scopes if scopes is not None else ''
        '''
         Space separated scopes that this login should assume into when authenticating.
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         DNS subdomain through which this resource may be accessed on clients.  (e.g. "app-prod1" allows the resource to be accessed at "app-prod1.your-org-name.sdm-proxy-domain"). Only applicable to HTTP-based resources or resources using virtual networking mode.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''

    def __repr__(self):
        return '<sdm.GCP ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'keyfile: ' + repr(self.keyfile) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'proxy_cluster_id: ' + repr(self.proxy_cluster_id) + ' ' +\
            'scopes: ' + repr(self.scopes) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'egress_filter': self.egress_filter,
            'healthy': self.healthy,
            'id': self.id,
            'keyfile': self.keyfile,
            'name': self.name,
            'port_override': self.port_override,
            'proxy_cluster_id': self.proxy_cluster_id,
            'scopes': self.scopes,
            'secret_store_id': self.secret_store_id,
            'subdomain': self.subdomain,
            'tags': self.tags,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            egress_filter=d.get('egress_filter'),
            healthy=d.get('healthy'),
            id=d.get('id'),
            keyfile=d.get('keyfile'),
            name=d.get('name'),
            port_override=d.get('port_override'),
            proxy_cluster_id=d.get('proxy_cluster_id'),
            scopes=d.get('scopes'),
            secret_store_id=d.get('secret_store_id'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
        )


class GCPCertX509Store:
    __slots__ = [
        'caid',
        'capoolid',
        'id',
        'issuedcertttlminutes',
        'location',
        'name',
        'projectid',
        'tags',
    ]

    def __init__(
        self,
        caid=None,
        capoolid=None,
        id=None,
        issuedcertttlminutes=None,
        location=None,
        name=None,
        projectid=None,
        tags=None,
    ):
        self.caid = caid if caid is not None else ''
        '''
         The ID of the target CA
        '''
        self.capoolid = capoolid if capoolid is not None else ''
        '''
         The ID of the target CA pool
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the SecretStore.
        '''
        self.issuedcertttlminutes = issuedcertttlminutes if issuedcertttlminutes is not None else 0
        '''
         The lifetime of certificates issued by this CA represented in minutes.
        '''
        self.location = location if location is not None else ''
        '''
         The Region for the CA in GCP format e.g. us-west1
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the SecretStore.
        '''
        self.projectid = projectid if projectid is not None else ''
        '''
         The GCP project ID to target.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''

    def __repr__(self):
        return '<sdm.GCPCertX509Store ' + \
            'caid: ' + repr(self.caid) + ' ' +\
            'capoolid: ' + repr(self.capoolid) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'issuedcertttlminutes: ' + repr(self.issuedcertttlminutes) + ' ' +\
            'location: ' + repr(self.location) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'projectid: ' + repr(self.projectid) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'caid': self.caid,
            'capoolid': self.capoolid,
            'id': self.id,
            'issuedcertttlminutes': self.issuedcertttlminutes,
            'location': self.location,
            'name': self.name,
            'projectid': self.projectid,
            'tags': self.tags,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            caid=d.get('caid'),
            capoolid=d.get('capoolid'),
            id=d.get('id'),
            issuedcertttlminutes=d.get('issuedcertttlminutes'),
            location=d.get('location'),
            name=d.get('name'),
            projectid=d.get('projectid'),
            tags=d.get('tags'),
        )


class GCPConsole:
    __slots__ = [
        'bind_interface',
        'egress_filter',
        'healthy',
        'id',
        'identity_alias_healthcheck_username',
        'identity_set_id',
        'name',
        'port_override',
        'proxy_cluster_id',
        'secret_store_id',
        'session_expiry',
        'subdomain',
        'tags',
        'workforce_pool_id',
        'workforce_provider_id',
    ]

    def __init__(
        self,
        bind_interface=None,
        egress_filter=None,
        healthy=None,
        id=None,
        identity_alias_healthcheck_username=None,
        identity_set_id=None,
        name=None,
        port_override=None,
        proxy_cluster_id=None,
        secret_store_id=None,
        session_expiry=None,
        subdomain=None,
        tags=None,
        workforce_pool_id=None,
        workforce_provider_id=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided and may also be set to one of the ResourceIPAllocationMode constants to select between VNM, loopback, or default allocation.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.identity_alias_healthcheck_username = identity_alias_healthcheck_username if identity_alias_healthcheck_username is not None else ''
        '''
         The username to use for healthchecks, when clients otherwise connect with their own identity alias username.
        '''
        self.identity_set_id = identity_set_id if identity_set_id is not None else ''
        '''
         The ID of the identity set to use for identity connections.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.port_override = port_override if port_override is not None else 0
        '''
         The local port used by clients to connect to this resource. It is automatically generated if not provided on create and may be re-generated on update by specifying a value of -1.
        '''
        self.proxy_cluster_id = proxy_cluster_id if proxy_cluster_id is not None else ''
        '''
         ID of the proxy cluster for this resource, if any.
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.session_expiry = session_expiry if session_expiry is not None else 0
        '''
         The length of time in seconds console sessions will live before needing to reauthenticate.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         Subdomain is the local DNS address.  (e.g. app-prod1 turns into app-prod1.your-org-name.sdm.network)
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.workforce_pool_id = workforce_pool_id if workforce_pool_id is not None else ''
        '''
         The ID of the Workforce Identity Pool in GCP to use for federated authentication.
        '''
        self.workforce_provider_id = workforce_provider_id if workforce_provider_id is not None else ''
        '''
         The ID of the Workforce Identity Provider in GCP to use for federated authentication.
        '''

    def __repr__(self):
        return '<sdm.GCPConsole ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'identity_alias_healthcheck_username: ' + repr(self.identity_alias_healthcheck_username) + ' ' +\
            'identity_set_id: ' + repr(self.identity_set_id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'proxy_cluster_id: ' + repr(self.proxy_cluster_id) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'session_expiry: ' + repr(self.session_expiry) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'workforce_pool_id: ' + repr(self.workforce_pool_id) + ' ' +\
            'workforce_provider_id: ' + repr(self.workforce_provider_id) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'egress_filter': self.egress_filter,
            'healthy': self.healthy,
            'id': self.id,
            'identity_alias_healthcheck_username':
            self.identity_alias_healthcheck_username,
            'identity_set_id': self.identity_set_id,
            'name': self.name,
            'port_override': self.port_override,
            'proxy_cluster_id': self.proxy_cluster_id,
            'secret_store_id': self.secret_store_id,
            'session_expiry': self.session_expiry,
            'subdomain': self.subdomain,
            'tags': self.tags,
            'workforce_pool_id': self.workforce_pool_id,
            'workforce_provider_id': self.workforce_provider_id,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            egress_filter=d.get('egress_filter'),
            healthy=d.get('healthy'),
            id=d.get('id'),
            identity_alias_healthcheck_username=d.get(
                'identity_alias_healthcheck_username'),
            identity_set_id=d.get('identity_set_id'),
            name=d.get('name'),
            port_override=d.get('port_override'),
            proxy_cluster_id=d.get('proxy_cluster_id'),
            secret_store_id=d.get('secret_store_id'),
            session_expiry=d.get('session_expiry'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
            workforce_pool_id=d.get('workforce_pool_id'),
            workforce_provider_id=d.get('workforce_provider_id'),
        )


class GCPStore:
    __slots__ = [
        'id',
        'name',
        'projectid',
        'tags',
    ]

    def __init__(
        self,
        id=None,
        name=None,
        projectid=None,
        tags=None,
    ):
        self.id = id if id is not None else ''
        '''
         Unique identifier of the SecretStore.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the SecretStore.
        '''
        self.projectid = projectid if projectid is not None else ''
        '''
         The GCP project ID to target.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''

    def __repr__(self):
        return '<sdm.GCPStore ' + \
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'projectid: ' + repr(self.projectid) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'id': self.id,
            'name': self.name,
            'projectid': self.projectid,
            'tags': self.tags,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            id=d.get('id'),
            name=d.get('name'),
            projectid=d.get('projectid'),
            tags=d.get('tags'),
        )


class GCPWIF:
    __slots__ = [
        'bind_interface',
        'egress_filter',
        'healthy',
        'id',
        'identity_alias_healthcheck_username',
        'identity_set_id',
        'name',
        'port_override',
        'project_id',
        'proxy_cluster_id',
        'scopes',
        'secret_store_id',
        'session_expiry',
        'subdomain',
        'tags',
        'workforce_pool_id',
        'workforce_provider_id',
    ]

    def __init__(
        self,
        bind_interface=None,
        egress_filter=None,
        healthy=None,
        id=None,
        identity_alias_healthcheck_username=None,
        identity_set_id=None,
        name=None,
        port_override=None,
        project_id=None,
        proxy_cluster_id=None,
        scopes=None,
        secret_store_id=None,
        session_expiry=None,
        subdomain=None,
        tags=None,
        workforce_pool_id=None,
        workforce_provider_id=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided and may also be set to one of the ResourceIPAllocationMode constants to select between VNM, loopback, or default allocation.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.identity_alias_healthcheck_username = identity_alias_healthcheck_username if identity_alias_healthcheck_username is not None else ''
        '''
         The username to use for healthchecks, when clients otherwise connect with their own identity alias username.
        '''
        self.identity_set_id = identity_set_id if identity_set_id is not None else ''
        '''
         The ID of the identity set to use for identity connections.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.port_override = port_override if port_override is not None else 0
        '''
         The local port used by clients to connect to this resource. It is automatically generated if not provided on create and may be re-generated on update by specifying a value of -1.
        '''
        self.project_id = project_id if project_id is not None else ''
        '''
         When specified, all project scoped requests will use this Project ID, overriding the project ID specified by clients
        '''
        self.proxy_cluster_id = proxy_cluster_id if proxy_cluster_id is not None else ''
        '''
         ID of the proxy cluster for this resource, if any.
        '''
        self.scopes = scopes if scopes is not None else ''
        '''
         Space separated scopes that this login should assume into when authenticating.
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.session_expiry = session_expiry if session_expiry is not None else 0
        '''
         The length of time in seconds console sessions will live before needing to reauthenticate.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         DNS subdomain through which this resource may be accessed on clients.  (e.g. "app-prod1" allows the resource to be accessed at "app-prod1.your-org-name.sdm-proxy-domain"). Only applicable to HTTP-based resources or resources using virtual networking mode.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.workforce_pool_id = workforce_pool_id if workforce_pool_id is not None else ''
        '''
         The ID of the Workforce Identity Pool in GCP to use for federated authentication.
        '''
        self.workforce_provider_id = workforce_provider_id if workforce_provider_id is not None else ''
        '''
         The ID of the Workforce Identity Provider in GCP to use for federated authentication.
        '''

    def __repr__(self):
        return '<sdm.GCPWIF ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'identity_alias_healthcheck_username: ' + repr(self.identity_alias_healthcheck_username) + ' ' +\
            'identity_set_id: ' + repr(self.identity_set_id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'project_id: ' + repr(self.project_id) + ' ' +\
            'proxy_cluster_id: ' + repr(self.proxy_cluster_id) + ' ' +\
            'scopes: ' + repr(self.scopes) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'session_expiry: ' + repr(self.session_expiry) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'workforce_pool_id: ' + repr(self.workforce_pool_id) + ' ' +\
            'workforce_provider_id: ' + repr(self.workforce_provider_id) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'egress_filter': self.egress_filter,
            'healthy': self.healthy,
            'id': self.id,
            'identity_alias_healthcheck_username':
            self.identity_alias_healthcheck_username,
            'identity_set_id': self.identity_set_id,
            'name': self.name,
            'port_override': self.port_override,
            'project_id': self.project_id,
            'proxy_cluster_id': self.proxy_cluster_id,
            'scopes': self.scopes,
            'secret_store_id': self.secret_store_id,
            'session_expiry': self.session_expiry,
            'subdomain': self.subdomain,
            'tags': self.tags,
            'workforce_pool_id': self.workforce_pool_id,
            'workforce_provider_id': self.workforce_provider_id,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            egress_filter=d.get('egress_filter'),
            healthy=d.get('healthy'),
            id=d.get('id'),
            identity_alias_healthcheck_username=d.get(
                'identity_alias_healthcheck_username'),
            identity_set_id=d.get('identity_set_id'),
            name=d.get('name'),
            port_override=d.get('port_override'),
            project_id=d.get('project_id'),
            proxy_cluster_id=d.get('proxy_cluster_id'),
            scopes=d.get('scopes'),
            secret_store_id=d.get('secret_store_id'),
            session_expiry=d.get('session_expiry'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
            workforce_pool_id=d.get('workforce_pool_id'),
            workforce_provider_id=d.get('workforce_provider_id'),
        )


class Gateway:
    '''
         Gateway represents a StrongDM CLI installation running in gateway mode.
    '''
    __slots__ = [
        'bind_address',
        'device',
        'gateway_filter',
        'id',
        'listen_address',
        'location',
        'maintenance_windows',
        'name',
        'state',
        'tags',
        'version',
    ]

    def __init__(
        self,
        bind_address=None,
        device=None,
        gateway_filter=None,
        id=None,
        listen_address=None,
        location=None,
        maintenance_windows=None,
        name=None,
        state=None,
        tags=None,
        version=None,
    ):
        self.bind_address = bind_address if bind_address is not None else ''
        '''
         The hostname/port tuple which the gateway daemon will bind to.
         If not provided on create, set to "0.0.0.0:listen_address_port".
        '''
        self.device = device if device is not None else ''
        '''
         Device is a read only device name uploaded by the gateway process when
         it comes online.
        '''
        self.gateway_filter = gateway_filter if gateway_filter is not None else ''
        '''
         GatewayFilter can be used to restrict the peering between relays and
         gateways. Deprecated.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Gateway.
        '''
        self.listen_address = listen_address if listen_address is not None else ''
        '''
         The public hostname/port tuple at which the gateway will be accessible to clients.
        '''
        self.location = location if location is not None else ''
        '''
         Location is a read only network location uploaded by the gateway process
         when it comes online.
        '''
        self.maintenance_windows = maintenance_windows if maintenance_windows is not None else []
        '''
         Maintenance Windows define when this node is allowed to restart. If a node
         is requested to restart, it will check each window to determine if any of
         them permit it to restart, and if any do, it will. This check is repeated
         per window until the restart is successfully completed.
         
         If not set here, may be set on the command line or via an environment variable
         on the process itself; any server setting will take precedence over local
         settings. This setting is ineffective for nodes below version 38.44.0.
         
         If this setting is not applied via this remote configuration or via local
         configuration, the default setting is used: always allow restarts if serving
         no connections, and allow a restart even if serving connections between 7-8 UTC, any day.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Gateway. Node names must include only letters, numbers, and hyphens (no spaces, underscores, or other special characters). Generated if not provided on create.
        '''
        self.state = state if state is not None else ''
        '''
         The current state of the gateway. One of: "new", "verifying_restart",
         "restarting", "started", "stopped", "dead", "unknown"
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.version = version if version is not None else ''
        '''
         Version is a read only sdm binary version uploaded by the gateway process
         when it comes online.
        '''

    def __repr__(self):
        return '<sdm.Gateway ' + \
            'bind_address: ' + repr(self.bind_address) + ' ' +\
            'device: ' + repr(self.device) + ' ' +\
            'gateway_filter: ' + repr(self.gateway_filter) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'listen_address: ' + repr(self.listen_address) + ' ' +\
            'location: ' + repr(self.location) + ' ' +\
            'maintenance_windows: ' + repr(self.maintenance_windows) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'state: ' + repr(self.state) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'version: ' + repr(self.version) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_address': self.bind_address,
            'device': self.device,
            'gateway_filter': self.gateway_filter,
            'id': self.id,
            'listen_address': self.listen_address,
            'location': self.location,
            'maintenance_windows': self.maintenance_windows,
            'name': self.name,
            'state': self.state,
            'tags': self.tags,
            'version': self.version,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_address=d.get('bind_address'),
            device=d.get('device'),
            gateway_filter=d.get('gateway_filter'),
            id=d.get('id'),
            listen_address=d.get('listen_address'),
            location=d.get('location'),
            maintenance_windows=d.get('maintenance_windows'),
            name=d.get('name'),
            state=d.get('state'),
            tags=d.get('tags'),
            version=d.get('version'),
        )


class GenerateKeysRequest:
    __slots__ = [
        'secret_engine_id',
    ]

    def __init__(
        self,
        secret_engine_id=None,
    ):
        self.secret_engine_id = secret_engine_id if secret_engine_id is not None else ''
        '''
         required
        '''

    def __repr__(self):
        return '<sdm.GenerateKeysRequest ' + \
            'secret_engine_id: ' + repr(self.secret_engine_id) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'secret_engine_id': self.secret_engine_id,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(secret_engine_id=d.get('secret_engine_id'), )


class GenerateKeysResponse:
    __slots__ = [
        'rate_limit',
    ]

    def __init__(
        self,
        rate_limit=None,
    ):
        self.rate_limit = rate_limit if rate_limit is not None else None
        '''
         Rate limit information.
        '''

    def __repr__(self):
        return '<sdm.GenerateKeysResponse ' + \
            'rate_limit: ' + repr(self.rate_limit) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'rate_limit': self.rate_limit,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(rate_limit=d.get('rate_limit'), )


class GenericResponseMetadata:
    '''
         GenericResponseMetadata contains common headers for generic request
     responses.
    '''
    __slots__ = []

    def __init__(self, ):
        pass

    def __repr__(self):
        return '<sdm.GenericResponseMetadata ' + \
            '>'

    def to_dict(self):
        return {}

    @classmethod
    def from_dict(cls, d):
        return cls()


class GetResponseMetadata:
    '''
         GetResponseMetadata is reserved for future use.
    '''
    __slots__ = []

    def __init__(self, ):
        pass

    def __repr__(self):
        return '<sdm.GetResponseMetadata ' + \
            '>'

    def to_dict(self):
        return {}

    @classmethod
    def from_dict(cls, d):
        return cls()


class GoogleGKE:
    __slots__ = [
        'allow_resource_role_bypass',
        'bind_interface',
        'certificate_authority',
        'discovery_enabled',
        'discovery_username',
        'egress_filter',
        'endpoint',
        'healthcheck_namespace',
        'healthy',
        'id',
        'identity_alias_healthcheck_username',
        'identity_set_id',
        'name',
        'port_override',
        'proxy_cluster_id',
        'secret_store_id',
        'service_account_key',
        'subdomain',
        'tags',
    ]

    def __init__(
        self,
        allow_resource_role_bypass=None,
        bind_interface=None,
        certificate_authority=None,
        discovery_enabled=None,
        discovery_username=None,
        egress_filter=None,
        endpoint=None,
        healthcheck_namespace=None,
        healthy=None,
        id=None,
        identity_alias_healthcheck_username=None,
        identity_set_id=None,
        name=None,
        port_override=None,
        proxy_cluster_id=None,
        secret_store_id=None,
        service_account_key=None,
        subdomain=None,
        tags=None,
    ):
        self.allow_resource_role_bypass = allow_resource_role_bypass if allow_resource_role_bypass is not None else False
        '''
         If true, allows users to fallback to the existing authentication mode (Leased Credential or Identity Set)
         when a resource role is not provided.
        '''
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided and may also be set to one of the ResourceIPAllocationMode constants to select between VNM, loopback, or default allocation.
        '''
        self.certificate_authority = certificate_authority if certificate_authority is not None else ''
        '''
         The CA to authenticate TLS connections with.
        '''
        self.discovery_enabled = discovery_enabled if discovery_enabled is not None else False
        '''
         If true, configures discovery of a cluster to be run from a node.
        '''
        self.discovery_username = discovery_username if discovery_username is not None else ''
        '''
         If a cluster is configured for user impersonation, this is the user to impersonate when
         running discovery.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.endpoint = endpoint if endpoint is not None else ''
        '''
         The endpoint to dial.
        '''
        self.healthcheck_namespace = healthcheck_namespace if healthcheck_namespace is not None else ''
        '''
         The path used to check the health of your connection.  Defaults to `default`.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.identity_alias_healthcheck_username = identity_alias_healthcheck_username if identity_alias_healthcheck_username is not None else ''
        '''
         The username to use for healthchecks, when clients otherwise connect with their own identity alias username.
        '''
        self.identity_set_id = identity_set_id if identity_set_id is not None else ''
        '''
         The ID of the identity set to use for identity connections.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.port_override = port_override if port_override is not None else 0
        '''
         The local port used by clients to connect to this resource. It is automatically generated if not provided on create and may be re-generated on update by specifying a value of -1.
        '''
        self.proxy_cluster_id = proxy_cluster_id if proxy_cluster_id is not None else ''
        '''
         ID of the proxy cluster for this resource, if any.
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.service_account_key = service_account_key if service_account_key is not None else ''
        '''
         The service account key to authenticate with.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         DNS subdomain through which this resource may be accessed on clients.  (e.g. "app-prod1" allows the resource to be accessed at "app-prod1.your-org-name.sdm-proxy-domain"). Only applicable to HTTP-based resources or resources using virtual networking mode.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''

    def __repr__(self):
        return '<sdm.GoogleGKE ' + \
            'allow_resource_role_bypass: ' + repr(self.allow_resource_role_bypass) + ' ' +\
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'certificate_authority: ' + repr(self.certificate_authority) + ' ' +\
            'discovery_enabled: ' + repr(self.discovery_enabled) + ' ' +\
            'discovery_username: ' + repr(self.discovery_username) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'endpoint: ' + repr(self.endpoint) + ' ' +\
            'healthcheck_namespace: ' + repr(self.healthcheck_namespace) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'identity_alias_healthcheck_username: ' + repr(self.identity_alias_healthcheck_username) + ' ' +\
            'identity_set_id: ' + repr(self.identity_set_id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'proxy_cluster_id: ' + repr(self.proxy_cluster_id) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'service_account_key: ' + repr(self.service_account_key) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'allow_resource_role_bypass': self.allow_resource_role_bypass,
            'bind_interface': self.bind_interface,
            'certificate_authority': self.certificate_authority,
            'discovery_enabled': self.discovery_enabled,
            'discovery_username': self.discovery_username,
            'egress_filter': self.egress_filter,
            'endpoint': self.endpoint,
            'healthcheck_namespace': self.healthcheck_namespace,
            'healthy': self.healthy,
            'id': self.id,
            'identity_alias_healthcheck_username':
            self.identity_alias_healthcheck_username,
            'identity_set_id': self.identity_set_id,
            'name': self.name,
            'port_override': self.port_override,
            'proxy_cluster_id': self.proxy_cluster_id,
            'secret_store_id': self.secret_store_id,
            'service_account_key': self.service_account_key,
            'subdomain': self.subdomain,
            'tags': self.tags,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            allow_resource_role_bypass=d.get('allow_resource_role_bypass'),
            bind_interface=d.get('bind_interface'),
            certificate_authority=d.get('certificate_authority'),
            discovery_enabled=d.get('discovery_enabled'),
            discovery_username=d.get('discovery_username'),
            egress_filter=d.get('egress_filter'),
            endpoint=d.get('endpoint'),
            healthcheck_namespace=d.get('healthcheck_namespace'),
            healthy=d.get('healthy'),
            id=d.get('id'),
            identity_alias_healthcheck_username=d.get(
                'identity_alias_healthcheck_username'),
            identity_set_id=d.get('identity_set_id'),
            name=d.get('name'),
            port_override=d.get('port_override'),
            proxy_cluster_id=d.get('proxy_cluster_id'),
            secret_store_id=d.get('secret_store_id'),
            service_account_key=d.get('service_account_key'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
        )


class GoogleGKEUserImpersonation:
    '''
    GoogleGKEUserImpersonation is deprecated, see docs for more info.
    '''
    __slots__ = [
        'bind_interface',
        'certificate_authority',
        'egress_filter',
        'endpoint',
        'healthcheck_namespace',
        'healthy',
        'id',
        'name',
        'port_override',
        'proxy_cluster_id',
        'secret_store_id',
        'service_account_key',
        'subdomain',
        'tags',
    ]

    def __init__(
        self,
        bind_interface=None,
        certificate_authority=None,
        egress_filter=None,
        endpoint=None,
        healthcheck_namespace=None,
        healthy=None,
        id=None,
        name=None,
        port_override=None,
        proxy_cluster_id=None,
        secret_store_id=None,
        service_account_key=None,
        subdomain=None,
        tags=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided and may also be set to one of the ResourceIPAllocationMode constants to select between VNM, loopback, or default allocation.
        '''
        self.certificate_authority = certificate_authority if certificate_authority is not None else ''
        '''
         The CA to authenticate TLS connections with.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.endpoint = endpoint if endpoint is not None else ''
        '''
         The endpoint to dial.
        '''
        self.healthcheck_namespace = healthcheck_namespace if healthcheck_namespace is not None else ''
        '''
         The path used to check the health of your connection.  Defaults to `default`.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.port_override = port_override if port_override is not None else 0
        '''
         The local port used by clients to connect to this resource. It is automatically generated if not provided on create and may be re-generated on update by specifying a value of -1.
        '''
        self.proxy_cluster_id = proxy_cluster_id if proxy_cluster_id is not None else ''
        '''
         ID of the proxy cluster for this resource, if any.
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.service_account_key = service_account_key if service_account_key is not None else ''
        '''
         The service account key to authenticate with.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         DNS subdomain through which this resource may be accessed on clients.  (e.g. "app-prod1" allows the resource to be accessed at "app-prod1.your-org-name.sdm-proxy-domain"). Only applicable to HTTP-based resources or resources using virtual networking mode.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''

    def __repr__(self):
        return '<sdm.GoogleGKEUserImpersonation ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'certificate_authority: ' + repr(self.certificate_authority) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'endpoint: ' + repr(self.endpoint) + ' ' +\
            'healthcheck_namespace: ' + repr(self.healthcheck_namespace) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'proxy_cluster_id: ' + repr(self.proxy_cluster_id) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'service_account_key: ' + repr(self.service_account_key) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'certificate_authority': self.certificate_authority,
            'egress_filter': self.egress_filter,
            'endpoint': self.endpoint,
            'healthcheck_namespace': self.healthcheck_namespace,
            'healthy': self.healthy,
            'id': self.id,
            'name': self.name,
            'port_override': self.port_override,
            'proxy_cluster_id': self.proxy_cluster_id,
            'secret_store_id': self.secret_store_id,
            'service_account_key': self.service_account_key,
            'subdomain': self.subdomain,
            'tags': self.tags,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            certificate_authority=d.get('certificate_authority'),
            egress_filter=d.get('egress_filter'),
            endpoint=d.get('endpoint'),
            healthcheck_namespace=d.get('healthcheck_namespace'),
            healthy=d.get('healthy'),
            id=d.get('id'),
            name=d.get('name'),
            port_override=d.get('port_override'),
            proxy_cluster_id=d.get('proxy_cluster_id'),
            secret_store_id=d.get('secret_store_id'),
            service_account_key=d.get('service_account_key'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
        )


class Greenplum:
    __slots__ = [
        'bind_interface',
        'database',
        'egress_filter',
        'healthy',
        'hostname',
        'id',
        'name',
        'override_database',
        'password',
        'port',
        'port_override',
        'proxy_cluster_id',
        'secret_store_id',
        'subdomain',
        'tags',
        'username',
    ]

    def __init__(
        self,
        bind_interface=None,
        database=None,
        egress_filter=None,
        healthy=None,
        hostname=None,
        id=None,
        name=None,
        override_database=None,
        password=None,
        port=None,
        port_override=None,
        proxy_cluster_id=None,
        secret_store_id=None,
        subdomain=None,
        tags=None,
        username=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided and may also be set to one of the ResourceIPAllocationMode constants to select between VNM, loopback, or default allocation.
        '''
        self.database = database if database is not None else ''
        '''
         The initial database to connect to. This setting does not by itself prevent switching to another database after connecting.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        '''
         The host to dial to initiate a connection from the egress node to this resource.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.override_database = override_database if override_database is not None else False
        '''
         If set, the database configured cannot be changed by users. This setting is not recommended for most use cases, as some clients will insist their database has changed when it has not, leading to user confusion.
        '''
        self.password = password if password is not None else ''
        '''
         The password to authenticate with.
        '''
        self.port = port if port is not None else 0
        '''
         The port to dial to initiate a connection from the egress node to this resource.
        '''
        self.port_override = port_override if port_override is not None else 0
        '''
         The local port used by clients to connect to this resource. It is automatically generated if not provided on create and may be re-generated on update by specifying a value of -1.
        '''
        self.proxy_cluster_id = proxy_cluster_id if proxy_cluster_id is not None else ''
        '''
         ID of the proxy cluster for this resource, if any.
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         DNS subdomain through which this resource may be accessed on clients.  (e.g. "app-prod1" allows the resource to be accessed at "app-prod1.your-org-name.sdm-proxy-domain"). Only applicable to HTTP-based resources or resources using virtual networking mode.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.username = username if username is not None else ''
        '''
         The username to authenticate with.
        '''

    def __repr__(self):
        return '<sdm.Greenplum ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'database: ' + repr(self.database) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'override_database: ' + repr(self.override_database) + ' ' +\
            'password: ' + repr(self.password) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'proxy_cluster_id: ' + repr(self.proxy_cluster_id) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'username: ' + repr(self.username) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'database': self.database,
            'egress_filter': self.egress_filter,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'name': self.name,
            'override_database': self.override_database,
            'password': self.password,
            'port': self.port,
            'port_override': self.port_override,
            'proxy_cluster_id': self.proxy_cluster_id,
            'secret_store_id': self.secret_store_id,
            'subdomain': self.subdomain,
            'tags': self.tags,
            'username': self.username,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            database=d.get('database'),
            egress_filter=d.get('egress_filter'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            name=d.get('name'),
            override_database=d.get('override_database'),
            password=d.get('password'),
            port=d.get('port'),
            port_override=d.get('port_override'),
            proxy_cluster_id=d.get('proxy_cluster_id'),
            secret_store_id=d.get('secret_store_id'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
            username=d.get('username'),
        )


class Group:
    '''
         A Group is a named set of principals.
    '''
    __slots__ = [
        'description',
        'id',
        'name',
        'source',
        'tags',
    ]

    def __init__(
        self,
        description=None,
        id=None,
        name=None,
        source=None,
        tags=None,
    ):
        self.description = description if description is not None else ''
        '''
         Description of the Group.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Group.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Group.
        '''
        self.source = source if source is not None else ''
        '''
         Source is a read only field for what service manages this group, e.g. StrongDM, Okta, Azure.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key/value pairs that can be attached to a Group.
        '''

    def __repr__(self):
        return '<sdm.Group ' + \
            'description: ' + repr(self.description) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'source: ' + repr(self.source) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'description': self.description,
            'id': self.id,
            'name': self.name,
            'source': self.source,
            'tags': self.tags,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            description=d.get('description'),
            id=d.get('id'),
            name=d.get('name'),
            source=d.get('source'),
            tags=d.get('tags'),
        )


class GroupCreateFromRolesRequest:
    __slots__ = [
        'commit',
        'role_ids',
    ]

    def __init__(
        self,
        commit=None,
        role_ids=None,
    ):
        self.commit = commit if commit is not None else False
        '''
         Commit
        '''
        self.role_ids = role_ids if role_ids is not None else []
        '''
         The unique identifiers of the roles create groups from.
        '''

    def __repr__(self):
        return '<sdm.GroupCreateFromRolesRequest ' + \
            'commit: ' + repr(self.commit) + ' ' +\
            'role_ids: ' + repr(self.role_ids) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'commit': self.commit,
            'role_ids': self.role_ids,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            commit=d.get('commit'),
            role_ids=d.get('role_ids'),
        )


class GroupCreateFromRolesResponse:
    __slots__ = [
        'group_from_role',
        'rate_limit',
    ]

    def __init__(
        self,
        group_from_role=None,
        rate_limit=None,
    ):
        self.group_from_role = group_from_role if group_from_role is not None else []
        '''
         The created Group.
        '''
        self.rate_limit = rate_limit if rate_limit is not None else None
        '''
         Rate limit information.
        '''

    def __repr__(self):
        return '<sdm.GroupCreateFromRolesResponse ' + \
            'group_from_role: ' + repr(self.group_from_role) + ' ' +\
            'rate_limit: ' + repr(self.rate_limit) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'group_from_role': self.group_from_role,
            'rate_limit': self.rate_limit,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            group_from_role=d.get('group_from_role'),
            rate_limit=d.get('rate_limit'),
        )


class GroupCreateRequest:
    '''
         GroupCreateRequest specifies a group to create.
    '''
    __slots__ = [
        'group',
    ]

    def __init__(
        self,
        group=None,
    ):
        self.group = group if group is not None else None
        '''
         Parameters to define the new Group.
        '''

    def __repr__(self):
        return '<sdm.GroupCreateRequest ' + \
            'group: ' + repr(self.group) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'group': self.group,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(group=d.get('group'), )


class GroupCreateResponse:
    '''
         GroupCreateResponse reports the result of a create.
    '''
    __slots__ = [
        'group',
        'rate_limit',
    ]

    def __init__(
        self,
        group=None,
        rate_limit=None,
    ):
        self.group = group if group is not None else None
        '''
         The created Group.
        '''
        self.rate_limit = rate_limit if rate_limit is not None else None
        '''
         Rate limit information.
        '''

    def __repr__(self):
        return '<sdm.GroupCreateResponse ' + \
            'group: ' + repr(self.group) + ' ' +\
            'rate_limit: ' + repr(self.rate_limit) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'group': self.group,
            'rate_limit': self.rate_limit,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            group=d.get('group'),
            rate_limit=d.get('rate_limit'),
        )


class GroupDeleteRequest:
    '''
         groupDeleteRequest identifies a group by ID to delete.
    '''
    __slots__ = [
        'id',
    ]

    def __init__(
        self,
        id=None,
    ):
        self.id = id if id is not None else ''
        '''
         The unique identifier of the group to delete.
        '''

    def __repr__(self):
        return '<sdm.GroupDeleteRequest ' + \
            'id: ' + repr(self.id) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'id': self.id,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(id=d.get('id'), )


class GroupDeleteResponse:
    '''
         groupDeleteResponse returns information about a group that was deleted.
    '''
    __slots__ = [
        'meta',
        'rate_limit',
    ]

    def __init__(
        self,
        meta=None,
        rate_limit=None,
    ):
        self.meta = meta if meta is not None else None
        '''
         Reserved for future use.
        '''
        self.rate_limit = rate_limit if rate_limit is not None else None
        '''
         Rate limit information.
        '''

    def __repr__(self):
        return '<sdm.GroupDeleteResponse ' + \
            'meta: ' + repr(self.meta) + ' ' +\
            'rate_limit: ' + repr(self.rate_limit) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'meta': self.meta,
            'rate_limit': self.rate_limit,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            meta=d.get('meta'),
            rate_limit=d.get('rate_limit'),
        )


class GroupFromRole:
    __slots__ = [
        'accounts',
        'approval_flows',
        'group',
        'rate_limit',
        'role',
    ]

    def __init__(
        self,
        accounts=None,
        approval_flows=None,
        group=None,
        rate_limit=None,
        role=None,
    ):
        self.accounts = accounts if accounts is not None else []
        '''
         The migrated Accounts.
        '''
        self.approval_flows = approval_flows if approval_flows is not None else []
        '''
         The affected approval flows.
        '''
        self.group = group if group is not None else None
        '''
         The group created from the source role.
        '''
        self.rate_limit = rate_limit if rate_limit is not None else None
        '''
         Rate limit information.
        '''
        self.role = role if role is not None else None
        '''
         The source role.
        '''

    def __repr__(self):
        return '<sdm.GroupFromRole ' + \
            'accounts: ' + repr(self.accounts) + ' ' +\
            'approval_flows: ' + repr(self.approval_flows) + ' ' +\
            'group: ' + repr(self.group) + ' ' +\
            'rate_limit: ' + repr(self.rate_limit) + ' ' +\
            'role: ' + repr(self.role) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'accounts': self.accounts,
            'approval_flows': self.approval_flows,
            'group': self.group,
            'rate_limit': self.rate_limit,
            'role': self.role,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            accounts=d.get('accounts'),
            approval_flows=d.get('approval_flows'),
            group=d.get('group'),
            rate_limit=d.get('rate_limit'),
            role=d.get('role'),
        )


class GroupGetRequest:
    '''
         GroupGetRequest specifies which Group to retrieve.
    '''
    __slots__ = [
        'id',
    ]

    def __init__(
        self,
        id=None,
    ):
        self.id = id if id is not None else ''
        '''
         The unique identifier of the Group to retrieve.
        '''

    def __repr__(self):
        return '<sdm.GroupGetRequest ' + \
            'id: ' + repr(self.id) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'id': self.id,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(id=d.get('id'), )


class GroupGetResponse:
    '''
         GroupGetResponse returns a requested Group.
    '''
    __slots__ = [
        'group',
        'meta',
        'rate_limit',
    ]

    def __init__(
        self,
        group=None,
        meta=None,
        rate_limit=None,
    ):
        self.group = group if group is not None else None
        '''
         The requested Group.
        '''
        self.meta = meta if meta is not None else None
        '''
         Reserved for future use.
        '''
        self.rate_limit = rate_limit if rate_limit is not None else None
        '''
         Rate limit information.
        '''

    def __repr__(self):
        return '<sdm.GroupGetResponse ' + \
            'group: ' + repr(self.group) + ' ' +\
            'meta: ' + repr(self.meta) + ' ' +\
            'rate_limit: ' + repr(self.rate_limit) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'group': self.group,
            'meta': self.meta,
            'rate_limit': self.rate_limit,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            group=d.get('group'),
            meta=d.get('meta'),
            rate_limit=d.get('rate_limit'),
        )


class GroupHistory:
    '''
         GroupHistory records the state of a Group at a given point in time,
     where every change (create, update and delete) to a Group produces a
     GroupHistory record.
    '''
    __slots__ = [
        'activity_id',
        'deleted_at',
        'group',
        'timestamp',
    ]

    def __init__(
        self,
        activity_id=None,
        deleted_at=None,
        group=None,
        timestamp=None,
    ):
        self.activity_id = activity_id if activity_id is not None else ''
        '''
         The unique identifier of the Activity that produced this change to the Group.
         May be empty for some system-initiated updates.
        '''
        self.deleted_at = deleted_at if deleted_at is not None else None
        '''
         If this Group was deleted, the time it was deleted.
        '''
        self.group = group if group is not None else None
        '''
         The complete Group state at this time.
        '''
        self.timestamp = timestamp if timestamp is not None else None
        '''
         The time at which the Group state was recorded.
        '''

    def __repr__(self):
        return '<sdm.GroupHistory ' + \
            'activity_id: ' + repr(self.activity_id) + ' ' +\
            'deleted_at: ' + repr(self.deleted_at) + ' ' +\
            'group: ' + repr(self.group) + ' ' +\
            'timestamp: ' + repr(self.timestamp) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'activity_id': self.activity_id,
            'deleted_at': self.deleted_at,
            'group': self.group,
            'timestamp': self.timestamp,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            activity_id=d.get('activity_id'),
            deleted_at=d.get('deleted_at'),
            group=d.get('group'),
            timestamp=d.get('timestamp'),
        )


class GroupListRequest:
    '''
         groupListRequest specifies criteria for retrieving a list of groups.
    '''
    __slots__ = [
        'filter',
    ]

    def __init__(
        self,
        filter=None,
    ):
        self.filter = filter if filter is not None else ''
        '''
         A human-readable filter query string.
        '''

    def __repr__(self):
        return '<sdm.GroupListRequest ' + \
            'filter: ' + repr(self.filter) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'filter': self.filter,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(filter=d.get('filter'), )


class GroupListResponse:
    '''
         groupListResponse returns a list of groups that meet the criteria of a
     groupListRequest.
    '''
    __slots__ = [
        'rate_limit',
    ]

    def __init__(
        self,
        rate_limit=None,
    ):
        self.rate_limit = rate_limit if rate_limit is not None else None
        '''
         Rate limit information.
        '''

    def __repr__(self):
        return '<sdm.GroupListResponse ' + \
            'rate_limit: ' + repr(self.rate_limit) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'rate_limit': self.rate_limit,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(rate_limit=d.get('rate_limit'), )


class GroupRole:
    '''
         A GroupRole assigns a Group to a Role.
    '''
    __slots__ = [
        'group_id',
        'id',
        'role_id',
    ]

    def __init__(
        self,
        group_id=None,
        id=None,
        role_id=None,
    ):
        self.group_id = group_id if group_id is not None else ''
        '''
         The assigned Group ID.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the GroupRole.
        '''
        self.role_id = role_id if role_id is not None else ''
        '''
         The assigned Role ID.
        '''

    def __repr__(self):
        return '<sdm.GroupRole ' + \
            'group_id: ' + repr(self.group_id) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'role_id: ' + repr(self.role_id) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'group_id': self.group_id,
            'id': self.id,
            'role_id': self.role_id,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            group_id=d.get('group_id'),
            id=d.get('id'),
            role_id=d.get('role_id'),
        )


class GroupRoleCreateRequest:
    '''
         GroupRoleCreateRequest specifies a group role to create.
    '''
    __slots__ = [
        'group_role',
    ]

    def __init__(
        self,
        group_role=None,
    ):
        self.group_role = group_role if group_role is not None else None
        '''
         Parameters to define the new GroupRole.
        '''

    def __repr__(self):
        return '<sdm.GroupRoleCreateRequest ' + \
            'group_role: ' + repr(self.group_role) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'group_role': self.group_role,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(group_role=d.get('group_role'), )


class GroupRoleCreateResponse:
    '''
         GroupRoleCreateResponse reports the result of a create.
    '''
    __slots__ = [
        'group_role',
        'rate_limit',
    ]

    def __init__(
        self,
        group_role=None,
        rate_limit=None,
    ):
        self.group_role = group_role if group_role is not None else None
        '''
         The created GroupRole.
        '''
        self.rate_limit = rate_limit if rate_limit is not None else None
        '''
         Rate limit information.
        '''

    def __repr__(self):
        return '<sdm.GroupRoleCreateResponse ' + \
            'group_role: ' + repr(self.group_role) + ' ' +\
            'rate_limit: ' + repr(self.rate_limit) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'group_role': self.group_role,
            'rate_limit': self.rate_limit,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            group_role=d.get('group_role'),
            rate_limit=d.get('rate_limit'),
        )


class GroupRoleDeleteRequest:
    '''
         GroupRoleDeleteRequest identifies a group role by ID to delete.
    '''
    __slots__ = [
        'id',
    ]

    def __init__(
        self,
        id=None,
    ):
        self.id = id if id is not None else ''
        '''
         The unique identifier of the group to delete.
        '''

    def __repr__(self):
        return '<sdm.GroupRoleDeleteRequest ' + \
            'id: ' + repr(self.id) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'id': self.id,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(id=d.get('id'), )


class GroupRoleDeleteResponse:
    '''
         GroupRoleDeleteResponse returns information about a group that was deleted.
    '''
    __slots__ = [
        'group_role',
        'meta',
        'rate_limit',
    ]

    def __init__(
        self,
        group_role=None,
        meta=None,
        rate_limit=None,
    ):
        self.group_role = group_role if group_role is not None else None
        '''
         The deleted GroupRole.
        '''
        self.meta = meta if meta is not None else None
        '''
         Reserved for future use.
        '''
        self.rate_limit = rate_limit if rate_limit is not None else None
        '''
         Rate limit information.
        '''

    def __repr__(self):
        return '<sdm.GroupRoleDeleteResponse ' + \
            'group_role: ' + repr(self.group_role) + ' ' +\
            'meta: ' + repr(self.meta) + ' ' +\
            'rate_limit: ' + repr(self.rate_limit) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'group_role': self.group_role,
            'meta': self.meta,
            'rate_limit': self.rate_limit,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            group_role=d.get('group_role'),
            meta=d.get('meta'),
            rate_limit=d.get('rate_limit'),
        )


class GroupRoleGetRequest:
    '''
         GroupRoleGetRequest specifies which GroupRole to retrieve.
    '''
    __slots__ = [
        'id',
    ]

    def __init__(
        self,
        id=None,
    ):
        self.id = id if id is not None else ''
        '''
         The unique identifier of the GroupRole to retrieve.
        '''

    def __repr__(self):
        return '<sdm.GroupRoleGetRequest ' + \
            'id: ' + repr(self.id) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'id': self.id,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(id=d.get('id'), )


class GroupRoleGetResponse:
    '''
         GroupRoleGetResponse returns a requested GroupRole.
    '''
    __slots__ = [
        'group_role',
        'meta',
        'rate_limit',
    ]

    def __init__(
        self,
        group_role=None,
        meta=None,
        rate_limit=None,
    ):
        self.group_role = group_role if group_role is not None else None
        '''
         The requested GroupRole.
        '''
        self.meta = meta if meta is not None else None
        '''
         Reserved for future use.
        '''
        self.rate_limit = rate_limit if rate_limit is not None else None
        '''
         Rate limit information.
        '''

    def __repr__(self):
        return '<sdm.GroupRoleGetResponse ' + \
            'group_role: ' + repr(self.group_role) + ' ' +\
            'meta: ' + repr(self.meta) + ' ' +\
            'rate_limit: ' + repr(self.rate_limit) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'group_role': self.group_role,
            'meta': self.meta,
            'rate_limit': self.rate_limit,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            group_role=d.get('group_role'),
            meta=d.get('meta'),
            rate_limit=d.get('rate_limit'),
        )


class GroupRoleHistory:
    '''
         GroupRoleHistory records the state of a GroupRole at a given point in time,
     where every change (create, update and delete) to a GroupRole produces a
     GroupRoleHistory record.
    '''
    __slots__ = [
        'activity_id',
        'deleted_at',
        'group_role',
        'timestamp',
    ]

    def __init__(
        self,
        activity_id=None,
        deleted_at=None,
        group_role=None,
        timestamp=None,
    ):
        self.activity_id = activity_id if activity_id is not None else ''
        '''
         The unique identifier of the Activity that produced this change to the GroupRole.
         May be empty for some system-initiated updates.
        '''
        self.deleted_at = deleted_at if deleted_at is not None else None
        '''
         If this GroupRole was deleted, the time it was deleted.
        '''
        self.group_role = group_role if group_role is not None else None
        '''
         The complete GroupRole state at this time.
        '''
        self.timestamp = timestamp if timestamp is not None else None
        '''
         The time at which the GroupRole state was recorded.
        '''

    def __repr__(self):
        return '<sdm.GroupRoleHistory ' + \
            'activity_id: ' + repr(self.activity_id) + ' ' +\
            'deleted_at: ' + repr(self.deleted_at) + ' ' +\
            'group_role: ' + repr(self.group_role) + ' ' +\
            'timestamp: ' + repr(self.timestamp) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'activity_id': self.activity_id,
            'deleted_at': self.deleted_at,
            'group_role': self.group_role,
            'timestamp': self.timestamp,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            activity_id=d.get('activity_id'),
            deleted_at=d.get('deleted_at'),
            group_role=d.get('group_role'),
            timestamp=d.get('timestamp'),
        )


class GroupRoleListRequest:
    '''
         GroupRoleListRequest specifies criteria for retrieving a list of groups.
    '''
    __slots__ = [
        'filter',
    ]

    def __init__(
        self,
        filter=None,
    ):
        self.filter = filter if filter is not None else ''
        '''
         A human-readable filter query string.
        '''

    def __repr__(self):
        return '<sdm.GroupRoleListRequest ' + \
            'filter: ' + repr(self.filter) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'filter': self.filter,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(filter=d.get('filter'), )


class GroupRoleListResponse:
    '''
         GroupRoleListResponse returns a list of group roles that meet the criteria of a
     GroupRoleListRequest.
    '''
    __slots__ = [
        'rate_limit',
    ]

    def __init__(
        self,
        rate_limit=None,
    ):
        self.rate_limit = rate_limit if rate_limit is not None else None
        '''
         Rate limit information.
        '''

    def __repr__(self):
        return '<sdm.GroupRoleListResponse ' + \
            'rate_limit: ' + repr(self.rate_limit) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'rate_limit': self.rate_limit,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(rate_limit=d.get('rate_limit'), )


class GroupUpdateRequest:
    '''
         GroupUpdateRequest updates a group.
    '''
    __slots__ = [
        'group',
    ]

    def __init__(
        self,
        group=None,
    ):
        self.group = group if group is not None else None
        '''
         Parameters to overwrite the specified group.
        '''

    def __repr__(self):
        return '<sdm.GroupUpdateRequest ' + \
            'group: ' + repr(self.group) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'group': self.group,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(group=d.get('group'), )


class GroupUpdateResponse:
    '''
         groupUpdateResponse returns the fields of a group after it has been updated by
     a groupUpdateRequest.
    '''
    __slots__ = [
        'group',
        'rate_limit',
    ]

    def __init__(
        self,
        group=None,
        rate_limit=None,
    ):
        self.group = group if group is not None else None
        '''
         The updated group.
        '''
        self.rate_limit = rate_limit if rate_limit is not None else None
        '''
         Rate limit information.
        '''

    def __repr__(self):
        return '<sdm.GroupUpdateResponse ' + \
            'group: ' + repr(self.group) + ' ' +\
            'rate_limit: ' + repr(self.rate_limit) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'group': self.group,
            'rate_limit': self.rate_limit,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            group=d.get('group'),
            rate_limit=d.get('rate_limit'),
        )


class HTTPAuth:
    __slots__ = [
        'auth_header',
        'bind_interface',
        'default_path',
        'egress_filter',
        'headers_blacklist',
        'healthcheck_path',
        'healthy',
        'host_override',
        'id',
        'name',
        'port_override',
        'proxy_cluster_id',
        'secret_store_id',
        'subdomain',
        'tags',
        'url',
    ]

    def __init__(
        self,
        auth_header=None,
        bind_interface=None,
        default_path=None,
        egress_filter=None,
        headers_blacklist=None,
        healthcheck_path=None,
        healthy=None,
        host_override=None,
        id=None,
        name=None,
        port_override=None,
        proxy_cluster_id=None,
        secret_store_id=None,
        subdomain=None,
        tags=None,
        url=None,
    ):
        self.auth_header = auth_header if auth_header is not None else ''
        '''
         The content to set as the authorization header.
        '''
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided and may also be set to one of the ResourceIPAllocationMode constants to select between VNM, loopback, or default allocation.
        '''
        self.default_path = default_path if default_path is not None else ''
        '''
         Automatically redirect to this path upon connecting.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.headers_blacklist = headers_blacklist if headers_blacklist is not None else ''
        '''
         Header names (e.g. Authorization), to omit from logs.
        '''
        self.healthcheck_path = healthcheck_path if healthcheck_path is not None else ''
        '''
         This path will be used to check the health of your site.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.host_override = host_override if host_override is not None else ''
        '''
         The host header will be overwritten with this field if provided.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.port_override = port_override if port_override is not None else 0
        '''
         The local port used by clients to connect to this resource. It is automatically generated if not provided on create and may be re-generated on update by specifying a value of -1.
        '''
        self.proxy_cluster_id = proxy_cluster_id if proxy_cluster_id is not None else ''
        '''
         ID of the proxy cluster for this resource, if any.
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         Subdomain is the local DNS address.  (e.g. app-prod1 turns into app-prod1.your-org-name.sdm.network)
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.url = url if url is not None else ''
        '''
         The base address of your website without the path.
        '''

    def __repr__(self):
        return '<sdm.HTTPAuth ' + \
            'auth_header: ' + repr(self.auth_header) + ' ' +\
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'default_path: ' + repr(self.default_path) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'headers_blacklist: ' + repr(self.headers_blacklist) + ' ' +\
            'healthcheck_path: ' + repr(self.healthcheck_path) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'host_override: ' + repr(self.host_override) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'proxy_cluster_id: ' + repr(self.proxy_cluster_id) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'url: ' + repr(self.url) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'auth_header': self.auth_header,
            'bind_interface': self.bind_interface,
            'default_path': self.default_path,
            'egress_filter': self.egress_filter,
            'headers_blacklist': self.headers_blacklist,
            'healthcheck_path': self.healthcheck_path,
            'healthy': self.healthy,
            'host_override': self.host_override,
            'id': self.id,
            'name': self.name,
            'port_override': self.port_override,
            'proxy_cluster_id': self.proxy_cluster_id,
            'secret_store_id': self.secret_store_id,
            'subdomain': self.subdomain,
            'tags': self.tags,
            'url': self.url,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            auth_header=d.get('auth_header'),
            bind_interface=d.get('bind_interface'),
            default_path=d.get('default_path'),
            egress_filter=d.get('egress_filter'),
            headers_blacklist=d.get('headers_blacklist'),
            healthcheck_path=d.get('healthcheck_path'),
            healthy=d.get('healthy'),
            host_override=d.get('host_override'),
            id=d.get('id'),
            name=d.get('name'),
            port_override=d.get('port_override'),
            proxy_cluster_id=d.get('proxy_cluster_id'),
            secret_store_id=d.get('secret_store_id'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
            url=d.get('url'),
        )


class HTTPBasicAuth:
    __slots__ = [
        'bind_interface',
        'default_path',
        'egress_filter',
        'headers_blacklist',
        'healthcheck_path',
        'healthy',
        'host_override',
        'id',
        'name',
        'password',
        'port_override',
        'proxy_cluster_id',
        'secret_store_id',
        'subdomain',
        'tags',
        'url',
        'username',
    ]

    def __init__(
        self,
        bind_interface=None,
        default_path=None,
        egress_filter=None,
        headers_blacklist=None,
        healthcheck_path=None,
        healthy=None,
        host_override=None,
        id=None,
        name=None,
        password=None,
        port_override=None,
        proxy_cluster_id=None,
        secret_store_id=None,
        subdomain=None,
        tags=None,
        url=None,
        username=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided and may also be set to one of the ResourceIPAllocationMode constants to select between VNM, loopback, or default allocation.
        '''
        self.default_path = default_path if default_path is not None else ''
        '''
         Automatically redirect to this path upon connecting.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.headers_blacklist = headers_blacklist if headers_blacklist is not None else ''
        '''
         Header names (e.g. Authorization), to omit from logs.
        '''
        self.healthcheck_path = healthcheck_path if healthcheck_path is not None else ''
        '''
         This path will be used to check the health of your site.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.host_override = host_override if host_override is not None else ''
        '''
         The host header will be overwritten with this field if provided.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.password = password if password is not None else ''
        '''
         The password to authenticate with.
        '''
        self.port_override = port_override if port_override is not None else 0
        '''
         The local port used by clients to connect to this resource. It is automatically generated if not provided on create and may be re-generated on update by specifying a value of -1.
        '''
        self.proxy_cluster_id = proxy_cluster_id if proxy_cluster_id is not None else ''
        '''
         ID of the proxy cluster for this resource, if any.
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         Subdomain is the local DNS address.  (e.g. app-prod1 turns into app-prod1.your-org-name.sdm.network)
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.url = url if url is not None else ''
        '''
         The base address of your website without the path.
        '''
        self.username = username if username is not None else ''
        '''
         The username to authenticate with.
        '''

    def __repr__(self):
        return '<sdm.HTTPBasicAuth ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'default_path: ' + repr(self.default_path) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'headers_blacklist: ' + repr(self.headers_blacklist) + ' ' +\
            'healthcheck_path: ' + repr(self.healthcheck_path) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'host_override: ' + repr(self.host_override) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'password: ' + repr(self.password) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'proxy_cluster_id: ' + repr(self.proxy_cluster_id) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'url: ' + repr(self.url) + ' ' +\
            'username: ' + repr(self.username) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'default_path': self.default_path,
            'egress_filter': self.egress_filter,
            'headers_blacklist': self.headers_blacklist,
            'healthcheck_path': self.healthcheck_path,
            'healthy': self.healthy,
            'host_override': self.host_override,
            'id': self.id,
            'name': self.name,
            'password': self.password,
            'port_override': self.port_override,
            'proxy_cluster_id': self.proxy_cluster_id,
            'secret_store_id': self.secret_store_id,
            'subdomain': self.subdomain,
            'tags': self.tags,
            'url': self.url,
            'username': self.username,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            default_path=d.get('default_path'),
            egress_filter=d.get('egress_filter'),
            headers_blacklist=d.get('headers_blacklist'),
            healthcheck_path=d.get('healthcheck_path'),
            healthy=d.get('healthy'),
            host_override=d.get('host_override'),
            id=d.get('id'),
            name=d.get('name'),
            password=d.get('password'),
            port_override=d.get('port_override'),
            proxy_cluster_id=d.get('proxy_cluster_id'),
            secret_store_id=d.get('secret_store_id'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
            url=d.get('url'),
            username=d.get('username'),
        )


class HTTPNoAuth:
    __slots__ = [
        'bind_interface',
        'default_path',
        'egress_filter',
        'headers_blacklist',
        'healthcheck_path',
        'healthy',
        'host_override',
        'id',
        'name',
        'port_override',
        'proxy_cluster_id',
        'secret_store_id',
        'subdomain',
        'tags',
        'url',
    ]

    def __init__(
        self,
        bind_interface=None,
        default_path=None,
        egress_filter=None,
        headers_blacklist=None,
        healthcheck_path=None,
        healthy=None,
        host_override=None,
        id=None,
        name=None,
        port_override=None,
        proxy_cluster_id=None,
        secret_store_id=None,
        subdomain=None,
        tags=None,
        url=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided and may also be set to one of the ResourceIPAllocationMode constants to select between VNM, loopback, or default allocation.
        '''
        self.default_path = default_path if default_path is not None else ''
        '''
         Automatically redirect to this path upon connecting.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.headers_blacklist = headers_blacklist if headers_blacklist is not None else ''
        '''
         Header names (e.g. Authorization), to omit from logs.
        '''
        self.healthcheck_path = healthcheck_path if healthcheck_path is not None else ''
        '''
         This path will be used to check the health of your site.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.host_override = host_override if host_override is not None else ''
        '''
         The host header will be overwritten with this field if provided.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.port_override = port_override if port_override is not None else 0
        '''
         The local port used by clients to connect to this resource. It is automatically generated if not provided on create and may be re-generated on update by specifying a value of -1.
        '''
        self.proxy_cluster_id = proxy_cluster_id if proxy_cluster_id is not None else ''
        '''
         ID of the proxy cluster for this resource, if any.
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         Subdomain is the local DNS address.  (e.g. app-prod1 turns into app-prod1.your-org-name.sdm.network)
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.url = url if url is not None else ''
        '''
         The base address of your website without the path.
        '''

    def __repr__(self):
        return '<sdm.HTTPNoAuth ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'default_path: ' + repr(self.default_path) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'headers_blacklist: ' + repr(self.headers_blacklist) + ' ' +\
            'healthcheck_path: ' + repr(self.healthcheck_path) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'host_override: ' + repr(self.host_override) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'proxy_cluster_id: ' + repr(self.proxy_cluster_id) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'url: ' + repr(self.url) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'default_path': self.default_path,
            'egress_filter': self.egress_filter,
            'headers_blacklist': self.headers_blacklist,
            'healthcheck_path': self.healthcheck_path,
            'healthy': self.healthy,
            'host_override': self.host_override,
            'id': self.id,
            'name': self.name,
            'port_override': self.port_override,
            'proxy_cluster_id': self.proxy_cluster_id,
            'secret_store_id': self.secret_store_id,
            'subdomain': self.subdomain,
            'tags': self.tags,
            'url': self.url,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            default_path=d.get('default_path'),
            egress_filter=d.get('egress_filter'),
            headers_blacklist=d.get('headers_blacklist'),
            healthcheck_path=d.get('healthcheck_path'),
            healthy=d.get('healthy'),
            host_override=d.get('host_override'),
            id=d.get('id'),
            name=d.get('name'),
            port_override=d.get('port_override'),
            proxy_cluster_id=d.get('proxy_cluster_id'),
            secret_store_id=d.get('secret_store_id'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
            url=d.get('url'),
        )


class Healthcheck:
    '''
         Healthcheck defines the status of the link between a node and a resource
    '''
    __slots__ = [
        'error_msg',
        'healthy',
        'id',
        'node_id',
        'node_name',
        'resource_id',
        'resource_name',
        'timestamp',
    ]

    def __init__(
        self,
        error_msg=None,
        healthy=None,
        id=None,
        node_id=None,
        node_name=None,
        resource_id=None,
        resource_name=None,
        timestamp=None,
    ):
        self.error_msg = error_msg if error_msg is not None else ''
        '''
         The error if unhealthy
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         Whether the healthcheck succeeded.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the healthcheck.
        '''
        self.node_id = node_id if node_id is not None else ''
        '''
         Unique identifier of the healthcheck node.
        '''
        self.node_name = node_name if node_name is not None else ''
        '''
         The name of the node.
        '''
        self.resource_id = resource_id if resource_id is not None else ''
        '''
         Unique identifier of the healthcheck resource.
        '''
        self.resource_name = resource_name if resource_name is not None else ''
        '''
         The name of the resource.
        '''
        self.timestamp = timestamp if timestamp is not None else None
        '''
         The time at which the healthcheck state was recorded.
        '''

    def __repr__(self):
        return '<sdm.Healthcheck ' + \
            'error_msg: ' + repr(self.error_msg) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'node_id: ' + repr(self.node_id) + ' ' +\
            'node_name: ' + repr(self.node_name) + ' ' +\
            'resource_id: ' + repr(self.resource_id) + ' ' +\
            'resource_name: ' + repr(self.resource_name) + ' ' +\
            'timestamp: ' + repr(self.timestamp) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'error_msg': self.error_msg,
            'healthy': self.healthy,
            'id': self.id,
            'node_id': self.node_id,
            'node_name': self.node_name,
            'resource_id': self.resource_id,
            'resource_name': self.resource_name,
            'timestamp': self.timestamp,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            error_msg=d.get('error_msg'),
            healthy=d.get('healthy'),
            id=d.get('id'),
            node_id=d.get('node_id'),
            node_name=d.get('node_name'),
            resource_id=d.get('resource_id'),
            resource_name=d.get('resource_name'),
            timestamp=d.get('timestamp'),
        )


class HealthcheckListResponse:
    '''
         HealthcheckListResponse returns a list of Healthchecks that meet the criteria of a
     HealthcheckListRequest.
    '''
    __slots__ = [
        'rate_limit',
    ]

    def __init__(
        self,
        rate_limit=None,
    ):
        self.rate_limit = rate_limit if rate_limit is not None else None
        '''
         Rate limit information.
        '''

    def __repr__(self):
        return '<sdm.HealthcheckListResponse ' + \
            'rate_limit: ' + repr(self.rate_limit) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'rate_limit': self.rate_limit,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(rate_limit=d.get('rate_limit'), )


class HealthcheckRequest:
    __slots__ = [
        'secret_engine_id',
    ]

    def __init__(
        self,
        secret_engine_id=None,
    ):
        self.secret_engine_id = secret_engine_id if secret_engine_id is not None else ''
        '''
         required
        '''

    def __repr__(self):
        return '<sdm.HealthcheckRequest ' + \
            'secret_engine_id: ' + repr(self.secret_engine_id) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'secret_engine_id': self.secret_engine_id,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(secret_engine_id=d.get('secret_engine_id'), )


class HealthcheckResponse:
    __slots__ = [
        'rate_limit',
        'status',
    ]

    def __init__(
        self,
        rate_limit=None,
        status=None,
    ):
        self.rate_limit = rate_limit if rate_limit is not None else None
        '''
         Rate limit information.
        '''
        self.status = status if status is not None else []
        '''
         Array of statuses of all nodes serving a secret engine
        '''

    def __repr__(self):
        return '<sdm.HealthcheckResponse ' + \
            'rate_limit: ' + repr(self.rate_limit) + ' ' +\
            'status: ' + repr(self.status) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'rate_limit': self.rate_limit,
            'status': self.status,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            rate_limit=d.get('rate_limit'),
            status=d.get('status'),
        )


class HealthcheckStatus:
    '''
         HealthcheckStatus contains status of a node health
    '''
    __slots__ = [
        'node_id',
        'status',
    ]

    def __init__(
        self,
        node_id=None,
        status=None,
    ):
        self.node_id = node_id if node_id is not None else ''
        '''
         ID of node
        '''
        self.status = status if status is not None else ''
        '''
         Status of node's health
        '''

    def __repr__(self):
        return '<sdm.HealthcheckStatus ' + \
            'node_id: ' + repr(self.node_id) + ' ' +\
            'status: ' + repr(self.status) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'node_id': self.node_id,
            'status': self.status,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            node_id=d.get('node_id'),
            status=d.get('status'),
        )


class IdentityAlias:
    '''
         IdentityAliases define the username to be used for a specific account
     when connecting to a remote resource using that identity set.
    '''
    __slots__ = [
        'account_id',
        'id',
        'identity_set_id',
        'username',
    ]

    def __init__(
        self,
        account_id=None,
        id=None,
        identity_set_id=None,
        username=None,
    ):
        self.account_id = account_id if account_id is not None else ''
        '''
         The account for this identity alias.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the IdentityAlias.
        '''
        self.identity_set_id = identity_set_id if identity_set_id is not None else ''
        '''
         The identity set.
        '''
        self.username = username if username is not None else ''
        '''
         The username to be used as the identity alias for this account.
        '''

    def __repr__(self):
        return '<sdm.IdentityAlias ' + \
            'account_id: ' + repr(self.account_id) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'identity_set_id: ' + repr(self.identity_set_id) + ' ' +\
            'username: ' + repr(self.username) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'account_id': self.account_id,
            'id': self.id,
            'identity_set_id': self.identity_set_id,
            'username': self.username,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            account_id=d.get('account_id'),
            id=d.get('id'),
            identity_set_id=d.get('identity_set_id'),
            username=d.get('username'),
        )


class IdentityAliasCreateResponse:
    '''
         IdentityAliasCreateResponse reports how the IdentityAliases were created in the system.
    '''
    __slots__ = [
        'identity_alias',
        'meta',
        'rate_limit',
    ]

    def __init__(
        self,
        identity_alias=None,
        meta=None,
        rate_limit=None,
    ):
        self.identity_alias = identity_alias if identity_alias is not None else None
        '''
         The created IdentityAlias.
        '''
        self.meta = meta if meta is not None else None
        '''
         Reserved for future use.
        '''
        self.rate_limit = rate_limit if rate_limit is not None else None
        '''
         Rate limit information.
        '''

    def __repr__(self):
        return '<sdm.IdentityAliasCreateResponse ' + \
            'identity_alias: ' + repr(self.identity_alias) + ' ' +\
            'meta: ' + repr(self.meta) + ' ' +\
            'rate_limit: ' + repr(self.rate_limit) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'identity_alias': self.identity_alias,
            'meta': self.meta,
            'rate_limit': self.rate_limit,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            identity_alias=d.get('identity_alias'),
            meta=d.get('meta'),
            rate_limit=d.get('rate_limit'),
        )


class IdentityAliasDeleteResponse:
    '''
         IdentityAliasDeleteResponse returns information about a IdentityAlias that was deleted.
    '''
    __slots__ = [
        'meta',
        'rate_limit',
    ]

    def __init__(
        self,
        meta=None,
        rate_limit=None,
    ):
        self.meta = meta if meta is not None else None
        '''
         Reserved for future use.
        '''
        self.rate_limit = rate_limit if rate_limit is not None else None
        '''
         Rate limit information.
        '''

    def __repr__(self):
        return '<sdm.IdentityAliasDeleteResponse ' + \
            'meta: ' + repr(self.meta) + ' ' +\
            'rate_limit: ' + repr(self.rate_limit) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'meta': self.meta,
            'rate_limit': self.rate_limit,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            meta=d.get('meta'),
            rate_limit=d.get('rate_limit'),
        )


class IdentityAliasGetResponse:
    '''
         IdentityAliasGetResponse returns a requested IdentityAlias.
    '''
    __slots__ = [
        'identity_alias',
        'meta',
        'rate_limit',
    ]

    def __init__(
        self,
        identity_alias=None,
        meta=None,
        rate_limit=None,
    ):
        self.identity_alias = identity_alias if identity_alias is not None else None
        '''
         The requested IdentityAlias.
        '''
        self.meta = meta if meta is not None else None
        '''
         Reserved for future use.
        '''
        self.rate_limit = rate_limit if rate_limit is not None else None
        '''
         Rate limit information.
        '''

    def __repr__(self):
        return '<sdm.IdentityAliasGetResponse ' + \
            'identity_alias: ' + repr(self.identity_alias) + ' ' +\
            'meta: ' + repr(self.meta) + ' ' +\
            'rate_limit: ' + repr(self.rate_limit) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'identity_alias': self.identity_alias,
            'meta': self.meta,
            'rate_limit': self.rate_limit,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            identity_alias=d.get('identity_alias'),
            meta=d.get('meta'),
            rate_limit=d.get('rate_limit'),
        )


class IdentityAliasHistory:
    '''
         IdentityAliasHistory records the state of a IdentityAlias at a given point in time,
     where every change (create, update and delete) to a IdentityAlias produces an
     IdentityAliasHistory record.
    '''
    __slots__ = [
        'activity_id',
        'deleted_at',
        'identity_alias',
        'timestamp',
    ]

    def __init__(
        self,
        activity_id=None,
        deleted_at=None,
        identity_alias=None,
        timestamp=None,
    ):
        self.activity_id = activity_id if activity_id is not None else ''
        '''
         The unique identifier of the Activity that produced this change to the IdentityAlias.
         May be empty for some system-initiated updates.
        '''
        self.deleted_at = deleted_at if deleted_at is not None else None
        '''
         If this IdentityAlias was deleted, the time it was deleted.
        '''
        self.identity_alias = identity_alias if identity_alias is not None else None
        '''
         The complete IdentityAlias state at this time.
        '''
        self.timestamp = timestamp if timestamp is not None else None
        '''
         The time at which the IdentityAlias state was recorded.
        '''

    def __repr__(self):
        return '<sdm.IdentityAliasHistory ' + \
            'activity_id: ' + repr(self.activity_id) + ' ' +\
            'deleted_at: ' + repr(self.deleted_at) + ' ' +\
            'identity_alias: ' + repr(self.identity_alias) + ' ' +\
            'timestamp: ' + repr(self.timestamp) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'activity_id': self.activity_id,
            'deleted_at': self.deleted_at,
            'identity_alias': self.identity_alias,
            'timestamp': self.timestamp,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            activity_id=d.get('activity_id'),
            deleted_at=d.get('deleted_at'),
            identity_alias=d.get('identity_alias'),
            timestamp=d.get('timestamp'),
        )


class IdentityAliasUpdateResponse:
    '''
         IdentityAliasUpdateResponse returns the fields of a IdentityAlias after it has been updated by
     a IdentityAliasUpdateRequest.
    '''
    __slots__ = [
        'identity_alias',
        'meta',
        'rate_limit',
    ]

    def __init__(
        self,
        identity_alias=None,
        meta=None,
        rate_limit=None,
    ):
        self.identity_alias = identity_alias if identity_alias is not None else None
        '''
         The updated IdentityAlias.
        '''
        self.meta = meta if meta is not None else None
        '''
         Reserved for future use.
        '''
        self.rate_limit = rate_limit if rate_limit is not None else None
        '''
         Rate limit information.
        '''

    def __repr__(self):
        return '<sdm.IdentityAliasUpdateResponse ' + \
            'identity_alias: ' + repr(self.identity_alias) + ' ' +\
            'meta: ' + repr(self.meta) + ' ' +\
            'rate_limit: ' + repr(self.rate_limit) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'identity_alias': self.identity_alias,
            'meta': self.meta,
            'rate_limit': self.rate_limit,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            identity_alias=d.get('identity_alias'),
            meta=d.get('meta'),
            rate_limit=d.get('rate_limit'),
        )


class IdentitySet:
    '''
         A IdentitySet defines a group of identity aliases.
    '''
    __slots__ = [
        'id',
        'name',
    ]

    def __init__(
        self,
        id=None,
        name=None,
    ):
        self.id = id if id is not None else ''
        '''
         Unique identifier of the IdentitySet.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the IdentitySet.
        '''

    def __repr__(self):
        return '<sdm.IdentitySet ' + \
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'id': self.id,
            'name': self.name,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            id=d.get('id'),
            name=d.get('name'),
        )


class IdentitySetCreateResponse:
    '''
         IdentitySetCreateResponse reports how the IdentitySets were created in the system. It can
     communicate partial successes or failures.
    '''
    __slots__ = [
        'identity_set',
        'meta',
        'rate_limit',
    ]

    def __init__(
        self,
        identity_set=None,
        meta=None,
        rate_limit=None,
    ):
        self.identity_set = identity_set if identity_set is not None else None
        '''
         The created IdentitySet.
        '''
        self.meta = meta if meta is not None else None
        '''
         Reserved for future use.
        '''
        self.rate_limit = rate_limit if rate_limit is not None else None
        '''
         Rate limit information.
        '''

    def __repr__(self):
        return '<sdm.IdentitySetCreateResponse ' + \
            'identity_set: ' + repr(self.identity_set) + ' ' +\
            'meta: ' + repr(self.meta) + ' ' +\
            'rate_limit: ' + repr(self.rate_limit) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'identity_set': self.identity_set,
            'meta': self.meta,
            'rate_limit': self.rate_limit,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            identity_set=d.get('identity_set'),
            meta=d.get('meta'),
            rate_limit=d.get('rate_limit'),
        )


class IdentitySetDeleteResponse:
    '''
         IdentitySetDeleteResponse returns information about a IdentitySet that was deleted.
    '''
    __slots__ = [
        'meta',
        'rate_limit',
    ]

    def __init__(
        self,
        meta=None,
        rate_limit=None,
    ):
        self.meta = meta if meta is not None else None
        '''
         Reserved for future use.
        '''
        self.rate_limit = rate_limit if rate_limit is not None else None
        '''
         Rate limit information.
        '''

    def __repr__(self):
        return '<sdm.IdentitySetDeleteResponse ' + \
            'meta: ' + repr(self.meta) + ' ' +\
            'rate_limit: ' + repr(self.rate_limit) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'meta': self.meta,
            'rate_limit': self.rate_limit,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            meta=d.get('meta'),
            rate_limit=d.get('rate_limit'),
        )


class IdentitySetGetResponse:
    '''
         IdentitySetGetResponse returns a requested IdentitySet.
    '''
    __slots__ = [
        'identity_set',
        'meta',
        'rate_limit',
    ]

    def __init__(
        self,
        identity_set=None,
        meta=None,
        rate_limit=None,
    ):
        self.identity_set = identity_set if identity_set is not None else None
        '''
         The requested IdentitySet.
        '''
        self.meta = meta if meta is not None else None
        '''
         Reserved for future use.
        '''
        self.rate_limit = rate_limit if rate_limit is not None else None
        '''
         Rate limit information.
        '''

    def __repr__(self):
        return '<sdm.IdentitySetGetResponse ' + \
            'identity_set: ' + repr(self.identity_set) + ' ' +\
            'meta: ' + repr(self.meta) + ' ' +\
            'rate_limit: ' + repr(self.rate_limit) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'identity_set': self.identity_set,
            'meta': self.meta,
            'rate_limit': self.rate_limit,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            identity_set=d.get('identity_set'),
            meta=d.get('meta'),
            rate_limit=d.get('rate_limit'),
        )


class IdentitySetHistory:
    '''
         IdentitySetHistory records the state of a IdentitySet at a given point in time,
     where every change (create, update and delete) to a IdentitySet produces an
     IdentitySetHistory record.
    '''
    __slots__ = [
        'activity_id',
        'deleted_at',
        'identity_set',
        'timestamp',
    ]

    def __init__(
        self,
        activity_id=None,
        deleted_at=None,
        identity_set=None,
        timestamp=None,
    ):
        self.activity_id = activity_id if activity_id is not None else ''
        '''
         The unique identifier of the Activity that produced this change to the IdentitySet.
         May be empty for some system-initiated updates.
        '''
        self.deleted_at = deleted_at if deleted_at is not None else None
        '''
         If this IdentitySet was deleted, the time it was deleted.
        '''
        self.identity_set = identity_set if identity_set is not None else None
        '''
         The complete IdentitySet state at this time.
        '''
        self.timestamp = timestamp if timestamp is not None else None
        '''
         The time at which the IdentitySet state was recorded.
        '''

    def __repr__(self):
        return '<sdm.IdentitySetHistory ' + \
            'activity_id: ' + repr(self.activity_id) + ' ' +\
            'deleted_at: ' + repr(self.deleted_at) + ' ' +\
            'identity_set: ' + repr(self.identity_set) + ' ' +\
            'timestamp: ' + repr(self.timestamp) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'activity_id': self.activity_id,
            'deleted_at': self.deleted_at,
            'identity_set': self.identity_set,
            'timestamp': self.timestamp,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            activity_id=d.get('activity_id'),
            deleted_at=d.get('deleted_at'),
            identity_set=d.get('identity_set'),
            timestamp=d.get('timestamp'),
        )


class IdentitySetUpdateResponse:
    '''
         IdentitySetUpdateResponse returns the fields of a IdentitySet after it has been updated by
     a IdentitySetUpdateRequest.
    '''
    __slots__ = [
        'identity_set',
        'meta',
        'rate_limit',
    ]

    def __init__(
        self,
        identity_set=None,
        meta=None,
        rate_limit=None,
    ):
        self.identity_set = identity_set if identity_set is not None else None
        '''
         The updated IdentitySet.
        '''
        self.meta = meta if meta is not None else None
        '''
         Reserved for future use.
        '''
        self.rate_limit = rate_limit if rate_limit is not None else None
        '''
         Rate limit information.
        '''

    def __repr__(self):
        return '<sdm.IdentitySetUpdateResponse ' + \
            'identity_set: ' + repr(self.identity_set) + ' ' +\
            'meta: ' + repr(self.meta) + ' ' +\
            'rate_limit: ' + repr(self.rate_limit) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'identity_set': self.identity_set,
            'meta': self.meta,
            'rate_limit': self.rate_limit,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            identity_set=d.get('identity_set'),
            meta=d.get('meta'),
            rate_limit=d.get('rate_limit'),
        )


class KeyValueEngine:
    __slots__ = [
        'id',
        'key_rotation_interval_days',
        'name',
        'public_key',
        'secret_store_id',
        'secret_store_root_path',
        'tags',
    ]

    def __init__(
        self,
        id=None,
        key_rotation_interval_days=None,
        name=None,
        public_key=None,
        secret_store_id=None,
        secret_store_root_path=None,
        tags=None,
    ):
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Secret Engine.
        '''
        self.key_rotation_interval_days = key_rotation_interval_days if key_rotation_interval_days is not None else 0
        '''
         An interval of public/private key rotation for secret engine in days
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Secret Engine.
        '''
        self.public_key = public_key if public_key is not None else b''
        '''
         Public key linked with a secret engine
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         Backing secret store identifier
        '''
        self.secret_store_root_path = secret_store_root_path if secret_store_root_path is not None else ''
        '''
         Backing Secret Store root path where managed secrets are going to be stored
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''

    def __repr__(self):
        return '<sdm.KeyValueEngine ' + \
            'id: ' + repr(self.id) + ' ' +\
            'key_rotation_interval_days: ' + repr(self.key_rotation_interval_days) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'public_key: ' + repr(self.public_key) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'secret_store_root_path: ' + repr(self.secret_store_root_path) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'id': self.id,
            'key_rotation_interval_days': self.key_rotation_interval_days,
            'name': self.name,
            'public_key': self.public_key,
            'secret_store_id': self.secret_store_id,
            'secret_store_root_path': self.secret_store_root_path,
            'tags': self.tags,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            id=d.get('id'),
            key_rotation_interval_days=d.get('key_rotation_interval_days'),
            name=d.get('name'),
            public_key=d.get('public_key'),
            secret_store_id=d.get('secret_store_id'),
            secret_store_root_path=d.get('secret_store_root_path'),
            tags=d.get('tags'),
        )


class KeyfactorSSHStore:
    __slots__ = [
        'ca_file_path',
        'certificate_file_path',
        'default_certificate_authority_name',
        'default_certificate_profile_name',
        'default_end_entity_profile_name',
        'enrollment_code_env_var',
        'enrollment_username_env_var',
        'id',
        'key_file_path',
        'name',
        'server_address',
        'tags',
    ]

    def __init__(
        self,
        ca_file_path=None,
        certificate_file_path=None,
        default_certificate_authority_name=None,
        default_certificate_profile_name=None,
        default_end_entity_profile_name=None,
        enrollment_code_env_var=None,
        enrollment_username_env_var=None,
        id=None,
        key_file_path=None,
        name=None,
        server_address=None,
        tags=None,
    ):
        self.ca_file_path = ca_file_path if ca_file_path is not None else ''
        '''
         Path to the root CA that signed the certificate passed to the client for HTTPS connection.
         This is not required if the CA is trusted by the host operating system. This should be a PEM
         formatted certificate, and doesn't necessarily have to be the CA that signed CertificateFile.
        '''
        self.certificate_file_path = certificate_file_path if certificate_file_path is not None else ''
        '''
         Path to client certificate in PEM format. This certificate must contain a client certificate that
         is recognized by the EJBCA instance represented by Hostname. This PEM file may also contain the private
         key associated with the certificate, but KeyFile can also be set to configure the private key.
        '''
        self.default_certificate_authority_name = default_certificate_authority_name if default_certificate_authority_name is not None else ''
        '''
         Name of EJBCA certificate authority that will enroll CSR.
        '''
        self.default_certificate_profile_name = default_certificate_profile_name if default_certificate_profile_name is not None else ''
        '''
         Certificate profile name that EJBCA will enroll the CSR with.
        '''
        self.default_end_entity_profile_name = default_end_entity_profile_name if default_end_entity_profile_name is not None else ''
        '''
         End entity profile that EJBCA will enroll the CSR with.
        '''
        self.enrollment_code_env_var = enrollment_code_env_var if enrollment_code_env_var is not None else ''
        '''
         code used by EJBCA during enrollment. May be left blank if no code is required.
        '''
        self.enrollment_username_env_var = enrollment_username_env_var if enrollment_username_env_var is not None else ''
        '''
         username that used by the EJBCA during enrollment. This can be left out. 
         If so, the username must be auto-generated on the Keyfactor side.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the SecretStore.
        '''
        self.key_file_path = key_file_path if key_file_path is not None else ''
        '''
         Path to private key in PEM format. This file should contain the private key associated with the
         client certificate configured in CertificateFile.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the SecretStore.
        '''
        self.server_address = server_address if server_address is not None else ''
        '''
         the host of the Key Factor CA
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''

    def __repr__(self):
        return '<sdm.KeyfactorSSHStore ' + \
            'ca_file_path: ' + repr(self.ca_file_path) + ' ' +\
            'certificate_file_path: ' + repr(self.certificate_file_path) + ' ' +\
            'default_certificate_authority_name: ' + repr(self.default_certificate_authority_name) + ' ' +\
            'default_certificate_profile_name: ' + repr(self.default_certificate_profile_name) + ' ' +\
            'default_end_entity_profile_name: ' + repr(self.default_end_entity_profile_name) + ' ' +\
            'enrollment_code_env_var: ' + repr(self.enrollment_code_env_var) + ' ' +\
            'enrollment_username_env_var: ' + repr(self.enrollment_username_env_var) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'key_file_path: ' + repr(self.key_file_path) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'server_address: ' + repr(self.server_address) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'ca_file_path': self.ca_file_path,
            'certificate_file_path': self.certificate_file_path,
            'default_certificate_authority_name':
            self.default_certificate_authority_name,
            'default_certificate_profile_name':
            self.default_certificate_profile_name,
            'default_end_entity_profile_name':
            self.default_end_entity_profile_name,
            'enrollment_code_env_var': self.enrollment_code_env_var,
            'enrollment_username_env_var': self.enrollment_username_env_var,
            'id': self.id,
            'key_file_path': self.key_file_path,
            'name': self.name,
            'server_address': self.server_address,
            'tags': self.tags,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            ca_file_path=d.get('ca_file_path'),
            certificate_file_path=d.get('certificate_file_path'),
            default_certificate_authority_name=d.get(
                'default_certificate_authority_name'),
            default_certificate_profile_name=d.get(
                'default_certificate_profile_name'),
            default_end_entity_profile_name=d.get(
                'default_end_entity_profile_name'),
            enrollment_code_env_var=d.get('enrollment_code_env_var'),
            enrollment_username_env_var=d.get('enrollment_username_env_var'),
            id=d.get('id'),
            key_file_path=d.get('key_file_path'),
            name=d.get('name'),
            server_address=d.get('server_address'),
            tags=d.get('tags'),
        )


class KeyfactorX509Store:
    __slots__ = [
        'ca_file_path',
        'certificate_file_path',
        'default_certificate_authority_name',
        'default_certificate_profile_name',
        'default_end_entity_profile_name',
        'enrollment_code_env_var',
        'enrollment_username_env_var',
        'id',
        'key_file_path',
        'name',
        'server_address',
        'tags',
    ]

    def __init__(
        self,
        ca_file_path=None,
        certificate_file_path=None,
        default_certificate_authority_name=None,
        default_certificate_profile_name=None,
        default_end_entity_profile_name=None,
        enrollment_code_env_var=None,
        enrollment_username_env_var=None,
        id=None,
        key_file_path=None,
        name=None,
        server_address=None,
        tags=None,
    ):
        self.ca_file_path = ca_file_path if ca_file_path is not None else ''
        '''
         Path to the root CA that signed the certificate passed to the client for HTTPS connection.
         This is not required if the CA is trusted by the host operating system. This should be a PEM
         formatted certificate, and doesn't necessarily have to be the CA that signed CertificateFile.
        '''
        self.certificate_file_path = certificate_file_path if certificate_file_path is not None else ''
        '''
         Path to client certificate in PEM format. This certificate must contain a client certificate that
         is recognized by the EJBCA instance represented by Hostname. This PEM file may also contain the private
         key associated with the certificate, but KeyFile can also be set to configure the private key.
        '''
        self.default_certificate_authority_name = default_certificate_authority_name if default_certificate_authority_name is not None else ''
        '''
         Name of EJBCA certificate authority that will enroll CSR.
        '''
        self.default_certificate_profile_name = default_certificate_profile_name if default_certificate_profile_name is not None else ''
        '''
         Certificate profile name that EJBCA will enroll the CSR with.
        '''
        self.default_end_entity_profile_name = default_end_entity_profile_name if default_end_entity_profile_name is not None else ''
        '''
         End entity profile that EJBCA will enroll the CSR with.
        '''
        self.enrollment_code_env_var = enrollment_code_env_var if enrollment_code_env_var is not None else ''
        '''
         code used by EJBCA during enrollment. May be left blank if no code is required.
        '''
        self.enrollment_username_env_var = enrollment_username_env_var if enrollment_username_env_var is not None else ''
        '''
         username that used by the EJBCA during enrollment. This can be left out. 
         If so, the username must be auto-generated on the Keyfactor side.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the SecretStore.
        '''
        self.key_file_path = key_file_path if key_file_path is not None else ''
        '''
         Path to private key in PEM format. This file should contain the private key associated with the
         client certificate configured in CertificateFile.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the SecretStore.
        '''
        self.server_address = server_address if server_address is not None else ''
        '''
         the host of the Key Factor CA
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''

    def __repr__(self):
        return '<sdm.KeyfactorX509Store ' + \
            'ca_file_path: ' + repr(self.ca_file_path) + ' ' +\
            'certificate_file_path: ' + repr(self.certificate_file_path) + ' ' +\
            'default_certificate_authority_name: ' + repr(self.default_certificate_authority_name) + ' ' +\
            'default_certificate_profile_name: ' + repr(self.default_certificate_profile_name) + ' ' +\
            'default_end_entity_profile_name: ' + repr(self.default_end_entity_profile_name) + ' ' +\
            'enrollment_code_env_var: ' + repr(self.enrollment_code_env_var) + ' ' +\
            'enrollment_username_env_var: ' + repr(self.enrollment_username_env_var) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'key_file_path: ' + repr(self.key_file_path) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'server_address: ' + repr(self.server_address) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'ca_file_path': self.ca_file_path,
            'certificate_file_path': self.certificate_file_path,
            'default_certificate_authority_name':
            self.default_certificate_authority_name,
            'default_certificate_profile_name':
            self.default_certificate_profile_name,
            'default_end_entity_profile_name':
            self.default_end_entity_profile_name,
            'enrollment_code_env_var': self.enrollment_code_env_var,
            'enrollment_username_env_var': self.enrollment_username_env_var,
            'id': self.id,
            'key_file_path': self.key_file_path,
            'name': self.name,
            'server_address': self.server_address,
            'tags': self.tags,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            ca_file_path=d.get('ca_file_path'),
            certificate_file_path=d.get('certificate_file_path'),
            default_certificate_authority_name=d.get(
                'default_certificate_authority_name'),
            default_certificate_profile_name=d.get(
                'default_certificate_profile_name'),
            default_end_entity_profile_name=d.get(
                'default_end_entity_profile_name'),
            enrollment_code_env_var=d.get('enrollment_code_env_var'),
            enrollment_username_env_var=d.get('enrollment_username_env_var'),
            id=d.get('id'),
            key_file_path=d.get('key_file_path'),
            name=d.get('name'),
            server_address=d.get('server_address'),
            tags=d.get('tags'),
        )


class Kubernetes:
    __slots__ = [
        'allow_resource_role_bypass',
        'bind_interface',
        'certificate_authority',
        'client_certificate',
        'client_key',
        'discovery_enabled',
        'discovery_username',
        'egress_filter',
        'healthcheck_namespace',
        'healthy',
        'hostname',
        'id',
        'identity_alias_healthcheck_username',
        'identity_set_id',
        'name',
        'port',
        'port_override',
        'proxy_cluster_id',
        'secret_store_id',
        'subdomain',
        'tags',
    ]

    def __init__(
        self,
        allow_resource_role_bypass=None,
        bind_interface=None,
        certificate_authority=None,
        client_certificate=None,
        client_key=None,
        discovery_enabled=None,
        discovery_username=None,
        egress_filter=None,
        healthcheck_namespace=None,
        healthy=None,
        hostname=None,
        id=None,
        identity_alias_healthcheck_username=None,
        identity_set_id=None,
        name=None,
        port=None,
        port_override=None,
        proxy_cluster_id=None,
        secret_store_id=None,
        subdomain=None,
        tags=None,
    ):
        self.allow_resource_role_bypass = allow_resource_role_bypass if allow_resource_role_bypass is not None else False
        '''
         If true, allows users to fallback to the existing authentication mode (Leased Credential or Identity Set)
         when a resource role is not provided.
        '''
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided and may also be set to one of the ResourceIPAllocationMode constants to select between VNM, loopback, or default allocation.
        '''
        self.certificate_authority = certificate_authority if certificate_authority is not None else ''
        '''
         The CA to authenticate TLS connections with.
        '''
        self.client_certificate = client_certificate if client_certificate is not None else ''
        '''
         The certificate to authenticate TLS connections with.
        '''
        self.client_key = client_key if client_key is not None else ''
        '''
         The key to authenticate TLS connections with.
        '''
        self.discovery_enabled = discovery_enabled if discovery_enabled is not None else False
        '''
         If true, configures discovery of a cluster to be run from a node.
        '''
        self.discovery_username = discovery_username if discovery_username is not None else ''
        '''
         If a cluster is configured for user impersonation, this is the user to impersonate when
         running discovery.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthcheck_namespace = healthcheck_namespace if healthcheck_namespace is not None else ''
        '''
         The path used to check the health of your connection.  Defaults to `default`.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        '''
         The host to dial to initiate a connection from the egress node to this resource.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.identity_alias_healthcheck_username = identity_alias_healthcheck_username if identity_alias_healthcheck_username is not None else ''
        '''
         The username to use for healthchecks, when clients otherwise connect with their own identity alias username.
        '''
        self.identity_set_id = identity_set_id if identity_set_id is not None else ''
        '''
         The ID of the identity set to use for identity connections.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.port = port if port is not None else 0
        '''
         The port to dial to initiate a connection from the egress node to this resource.
        '''
        self.port_override = port_override if port_override is not None else 0
        '''
         The local port used by clients to connect to this resource. It is automatically generated if not provided on create and may be re-generated on update by specifying a value of -1.
        '''
        self.proxy_cluster_id = proxy_cluster_id if proxy_cluster_id is not None else ''
        '''
         ID of the proxy cluster for this resource, if any.
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         DNS subdomain through which this resource may be accessed on clients.  (e.g. "app-prod1" allows the resource to be accessed at "app-prod1.your-org-name.sdm-proxy-domain"). Only applicable to HTTP-based resources or resources using virtual networking mode.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''

    def __repr__(self):
        return '<sdm.Kubernetes ' + \
            'allow_resource_role_bypass: ' + repr(self.allow_resource_role_bypass) + ' ' +\
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'certificate_authority: ' + repr(self.certificate_authority) + ' ' +\
            'client_certificate: ' + repr(self.client_certificate) + ' ' +\
            'client_key: ' + repr(self.client_key) + ' ' +\
            'discovery_enabled: ' + repr(self.discovery_enabled) + ' ' +\
            'discovery_username: ' + repr(self.discovery_username) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthcheck_namespace: ' + repr(self.healthcheck_namespace) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'identity_alias_healthcheck_username: ' + repr(self.identity_alias_healthcheck_username) + ' ' +\
            'identity_set_id: ' + repr(self.identity_set_id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'proxy_cluster_id: ' + repr(self.proxy_cluster_id) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'allow_resource_role_bypass': self.allow_resource_role_bypass,
            'bind_interface': self.bind_interface,
            'certificate_authority': self.certificate_authority,
            'client_certificate': self.client_certificate,
            'client_key': self.client_key,
            'discovery_enabled': self.discovery_enabled,
            'discovery_username': self.discovery_username,
            'egress_filter': self.egress_filter,
            'healthcheck_namespace': self.healthcheck_namespace,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'identity_alias_healthcheck_username':
            self.identity_alias_healthcheck_username,
            'identity_set_id': self.identity_set_id,
            'name': self.name,
            'port': self.port,
            'port_override': self.port_override,
            'proxy_cluster_id': self.proxy_cluster_id,
            'secret_store_id': self.secret_store_id,
            'subdomain': self.subdomain,
            'tags': self.tags,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            allow_resource_role_bypass=d.get('allow_resource_role_bypass'),
            bind_interface=d.get('bind_interface'),
            certificate_authority=d.get('certificate_authority'),
            client_certificate=d.get('client_certificate'),
            client_key=d.get('client_key'),
            discovery_enabled=d.get('discovery_enabled'),
            discovery_username=d.get('discovery_username'),
            egress_filter=d.get('egress_filter'),
            healthcheck_namespace=d.get('healthcheck_namespace'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            identity_alias_healthcheck_username=d.get(
                'identity_alias_healthcheck_username'),
            identity_set_id=d.get('identity_set_id'),
            name=d.get('name'),
            port=d.get('port'),
            port_override=d.get('port_override'),
            proxy_cluster_id=d.get('proxy_cluster_id'),
            secret_store_id=d.get('secret_store_id'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
        )


class KubernetesBasicAuth:
    '''
    KubernetesBasicAuth is currently unstable, and its API may change, or it may be removed,
    without a major version bump.
    '''
    __slots__ = [
        'bind_interface',
        'egress_filter',
        'healthcheck_namespace',
        'healthy',
        'hostname',
        'id',
        'name',
        'password',
        'port',
        'port_override',
        'proxy_cluster_id',
        'secret_store_id',
        'subdomain',
        'tags',
        'username',
    ]

    def __init__(
        self,
        bind_interface=None,
        egress_filter=None,
        healthcheck_namespace=None,
        healthy=None,
        hostname=None,
        id=None,
        name=None,
        password=None,
        port=None,
        port_override=None,
        proxy_cluster_id=None,
        secret_store_id=None,
        subdomain=None,
        tags=None,
        username=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided and may also be set to one of the ResourceIPAllocationMode constants to select between VNM, loopback, or default allocation.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthcheck_namespace = healthcheck_namespace if healthcheck_namespace is not None else ''
        '''
         The path used to check the health of your connection.  Defaults to `default`.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        '''
         The host to dial to initiate a connection from the egress node to this resource.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.password = password if password is not None else ''
        '''
         The password to authenticate with.
        '''
        self.port = port if port is not None else 0
        '''
         The port to dial to initiate a connection from the egress node to this resource.
        '''
        self.port_override = port_override if port_override is not None else 0
        '''
         The local port used by clients to connect to this resource. It is automatically generated if not provided on create and may be re-generated on update by specifying a value of -1.
        '''
        self.proxy_cluster_id = proxy_cluster_id if proxy_cluster_id is not None else ''
        '''
         ID of the proxy cluster for this resource, if any.
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         DNS subdomain through which this resource may be accessed on clients.  (e.g. "app-prod1" allows the resource to be accessed at "app-prod1.your-org-name.sdm-proxy-domain"). Only applicable to HTTP-based resources or resources using virtual networking mode.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.username = username if username is not None else ''
        '''
         The username to authenticate with.
        '''

    def __repr__(self):
        return '<sdm.KubernetesBasicAuth ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthcheck_namespace: ' + repr(self.healthcheck_namespace) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'password: ' + repr(self.password) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'proxy_cluster_id: ' + repr(self.proxy_cluster_id) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'username: ' + repr(self.username) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'egress_filter': self.egress_filter,
            'healthcheck_namespace': self.healthcheck_namespace,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'name': self.name,
            'password': self.password,
            'port': self.port,
            'port_override': self.port_override,
            'proxy_cluster_id': self.proxy_cluster_id,
            'secret_store_id': self.secret_store_id,
            'subdomain': self.subdomain,
            'tags': self.tags,
            'username': self.username,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            egress_filter=d.get('egress_filter'),
            healthcheck_namespace=d.get('healthcheck_namespace'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            name=d.get('name'),
            password=d.get('password'),
            port=d.get('port'),
            port_override=d.get('port_override'),
            proxy_cluster_id=d.get('proxy_cluster_id'),
            secret_store_id=d.get('secret_store_id'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
            username=d.get('username'),
        )


class KubernetesPodIdentity:
    __slots__ = [
        'allow_resource_role_bypass',
        'bind_interface',
        'certificate_authority',
        'discovery_enabled',
        'discovery_username',
        'egress_filter',
        'healthcheck_namespace',
        'healthy',
        'id',
        'identity_alias_healthcheck_username',
        'identity_set_id',
        'name',
        'port_override',
        'proxy_cluster_id',
        'secret_store_id',
        'subdomain',
        'tags',
    ]

    def __init__(
        self,
        allow_resource_role_bypass=None,
        bind_interface=None,
        certificate_authority=None,
        discovery_enabled=None,
        discovery_username=None,
        egress_filter=None,
        healthcheck_namespace=None,
        healthy=None,
        id=None,
        identity_alias_healthcheck_username=None,
        identity_set_id=None,
        name=None,
        port_override=None,
        proxy_cluster_id=None,
        secret_store_id=None,
        subdomain=None,
        tags=None,
    ):
        self.allow_resource_role_bypass = allow_resource_role_bypass if allow_resource_role_bypass is not None else False
        '''
         If true, allows users to fallback to the existing authentication mode (Leased Credential or Identity Set)
         when a resource role is not provided.
        '''
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided and may also be set to one of the ResourceIPAllocationMode constants to select between VNM, loopback, or default allocation.
        '''
        self.certificate_authority = certificate_authority if certificate_authority is not None else ''
        '''
         The CA to authenticate TLS connections with.
        '''
        self.discovery_enabled = discovery_enabled if discovery_enabled is not None else False
        '''
         If true, configures discovery of a cluster to be run from a node.
        '''
        self.discovery_username = discovery_username if discovery_username is not None else ''
        '''
         If a cluster is configured for user impersonation, this is the user to impersonate when
         running discovery.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthcheck_namespace = healthcheck_namespace if healthcheck_namespace is not None else ''
        '''
         The path used to check the health of your connection.  Defaults to `default`.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.identity_alias_healthcheck_username = identity_alias_healthcheck_username if identity_alias_healthcheck_username is not None else ''
        '''
         The username to use for healthchecks, when clients otherwise connect with their own identity alias username.
        '''
        self.identity_set_id = identity_set_id if identity_set_id is not None else ''
        '''
         The ID of the identity set to use for identity connections.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.port_override = port_override if port_override is not None else 0
        '''
         The local port used by clients to connect to this resource. It is automatically generated if not provided on create and may be re-generated on update by specifying a value of -1.
        '''
        self.proxy_cluster_id = proxy_cluster_id if proxy_cluster_id is not None else ''
        '''
         ID of the proxy cluster for this resource, if any.
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         DNS subdomain through which this resource may be accessed on clients.  (e.g. "app-prod1" allows the resource to be accessed at "app-prod1.your-org-name.sdm-proxy-domain"). Only applicable to HTTP-based resources or resources using virtual networking mode.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''

    def __repr__(self):
        return '<sdm.KubernetesPodIdentity ' + \
            'allow_resource_role_bypass: ' + repr(self.allow_resource_role_bypass) + ' ' +\
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'certificate_authority: ' + repr(self.certificate_authority) + ' ' +\
            'discovery_enabled: ' + repr(self.discovery_enabled) + ' ' +\
            'discovery_username: ' + repr(self.discovery_username) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthcheck_namespace: ' + repr(self.healthcheck_namespace) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'identity_alias_healthcheck_username: ' + repr(self.identity_alias_healthcheck_username) + ' ' +\
            'identity_set_id: ' + repr(self.identity_set_id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'proxy_cluster_id: ' + repr(self.proxy_cluster_id) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'allow_resource_role_bypass': self.allow_resource_role_bypass,
            'bind_interface': self.bind_interface,
            'certificate_authority': self.certificate_authority,
            'discovery_enabled': self.discovery_enabled,
            'discovery_username': self.discovery_username,
            'egress_filter': self.egress_filter,
            'healthcheck_namespace': self.healthcheck_namespace,
            'healthy': self.healthy,
            'id': self.id,
            'identity_alias_healthcheck_username':
            self.identity_alias_healthcheck_username,
            'identity_set_id': self.identity_set_id,
            'name': self.name,
            'port_override': self.port_override,
            'proxy_cluster_id': self.proxy_cluster_id,
            'secret_store_id': self.secret_store_id,
            'subdomain': self.subdomain,
            'tags': self.tags,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            allow_resource_role_bypass=d.get('allow_resource_role_bypass'),
            bind_interface=d.get('bind_interface'),
            certificate_authority=d.get('certificate_authority'),
            discovery_enabled=d.get('discovery_enabled'),
            discovery_username=d.get('discovery_username'),
            egress_filter=d.get('egress_filter'),
            healthcheck_namespace=d.get('healthcheck_namespace'),
            healthy=d.get('healthy'),
            id=d.get('id'),
            identity_alias_healthcheck_username=d.get(
                'identity_alias_healthcheck_username'),
            identity_set_id=d.get('identity_set_id'),
            name=d.get('name'),
            port_override=d.get('port_override'),
            proxy_cluster_id=d.get('proxy_cluster_id'),
            secret_store_id=d.get('secret_store_id'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
        )


class KubernetesServiceAccount:
    __slots__ = [
        'allow_resource_role_bypass',
        'bind_interface',
        'discovery_enabled',
        'discovery_username',
        'egress_filter',
        'healthcheck_namespace',
        'healthy',
        'hostname',
        'id',
        'identity_alias_healthcheck_username',
        'identity_set_id',
        'name',
        'port',
        'port_override',
        'proxy_cluster_id',
        'secret_store_id',
        'subdomain',
        'tags',
        'token',
    ]

    def __init__(
        self,
        allow_resource_role_bypass=None,
        bind_interface=None,
        discovery_enabled=None,
        discovery_username=None,
        egress_filter=None,
        healthcheck_namespace=None,
        healthy=None,
        hostname=None,
        id=None,
        identity_alias_healthcheck_username=None,
        identity_set_id=None,
        name=None,
        port=None,
        port_override=None,
        proxy_cluster_id=None,
        secret_store_id=None,
        subdomain=None,
        tags=None,
        token=None,
    ):
        self.allow_resource_role_bypass = allow_resource_role_bypass if allow_resource_role_bypass is not None else False
        '''
         If true, allows users to fallback to the existing authentication mode (Leased Credential or Identity Set)
         when a resource role is not provided.
        '''
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided and may also be set to one of the ResourceIPAllocationMode constants to select between VNM, loopback, or default allocation.
        '''
        self.discovery_enabled = discovery_enabled if discovery_enabled is not None else False
        '''
         If true, configures discovery of a cluster to be run from a node.
        '''
        self.discovery_username = discovery_username if discovery_username is not None else ''
        '''
         If a cluster is configured for user impersonation, this is the user to impersonate when
         running discovery.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthcheck_namespace = healthcheck_namespace if healthcheck_namespace is not None else ''
        '''
         The path used to check the health of your connection.  Defaults to `default`.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        '''
         The host to dial to initiate a connection from the egress node to this resource.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.identity_alias_healthcheck_username = identity_alias_healthcheck_username if identity_alias_healthcheck_username is not None else ''
        '''
         The username to use for healthchecks, when clients otherwise connect with their own identity alias username.
        '''
        self.identity_set_id = identity_set_id if identity_set_id is not None else ''
        '''
         The ID of the identity set to use for identity connections.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.port = port if port is not None else 0
        '''
         The port to dial to initiate a connection from the egress node to this resource.
        '''
        self.port_override = port_override if port_override is not None else 0
        '''
         The local port used by clients to connect to this resource. It is automatically generated if not provided on create and may be re-generated on update by specifying a value of -1.
        '''
        self.proxy_cluster_id = proxy_cluster_id if proxy_cluster_id is not None else ''
        '''
         ID of the proxy cluster for this resource, if any.
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         DNS subdomain through which this resource may be accessed on clients.  (e.g. "app-prod1" allows the resource to be accessed at "app-prod1.your-org-name.sdm-proxy-domain"). Only applicable to HTTP-based resources or resources using virtual networking mode.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.token = token if token is not None else ''
        '''
         The API token to authenticate with.
        '''

    def __repr__(self):
        return '<sdm.KubernetesServiceAccount ' + \
            'allow_resource_role_bypass: ' + repr(self.allow_resource_role_bypass) + ' ' +\
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'discovery_enabled: ' + repr(self.discovery_enabled) + ' ' +\
            'discovery_username: ' + repr(self.discovery_username) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthcheck_namespace: ' + repr(self.healthcheck_namespace) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'identity_alias_healthcheck_username: ' + repr(self.identity_alias_healthcheck_username) + ' ' +\
            'identity_set_id: ' + repr(self.identity_set_id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'proxy_cluster_id: ' + repr(self.proxy_cluster_id) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'token: ' + repr(self.token) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'allow_resource_role_bypass': self.allow_resource_role_bypass,
            'bind_interface': self.bind_interface,
            'discovery_enabled': self.discovery_enabled,
            'discovery_username': self.discovery_username,
            'egress_filter': self.egress_filter,
            'healthcheck_namespace': self.healthcheck_namespace,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'identity_alias_healthcheck_username':
            self.identity_alias_healthcheck_username,
            'identity_set_id': self.identity_set_id,
            'name': self.name,
            'port': self.port,
            'port_override': self.port_override,
            'proxy_cluster_id': self.proxy_cluster_id,
            'secret_store_id': self.secret_store_id,
            'subdomain': self.subdomain,
            'tags': self.tags,
            'token': self.token,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            allow_resource_role_bypass=d.get('allow_resource_role_bypass'),
            bind_interface=d.get('bind_interface'),
            discovery_enabled=d.get('discovery_enabled'),
            discovery_username=d.get('discovery_username'),
            egress_filter=d.get('egress_filter'),
            healthcheck_namespace=d.get('healthcheck_namespace'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            identity_alias_healthcheck_username=d.get(
                'identity_alias_healthcheck_username'),
            identity_set_id=d.get('identity_set_id'),
            name=d.get('name'),
            port=d.get('port'),
            port_override=d.get('port_override'),
            proxy_cluster_id=d.get('proxy_cluster_id'),
            secret_store_id=d.get('secret_store_id'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
            token=d.get('token'),
        )


class KubernetesServiceAccountUserImpersonation:
    '''
    KubernetesServiceAccountUserImpersonation is deprecated, see docs for more info.
    '''
    __slots__ = [
        'bind_interface',
        'egress_filter',
        'healthcheck_namespace',
        'healthy',
        'hostname',
        'id',
        'name',
        'port',
        'port_override',
        'proxy_cluster_id',
        'secret_store_id',
        'subdomain',
        'tags',
        'token',
    ]

    def __init__(
        self,
        bind_interface=None,
        egress_filter=None,
        healthcheck_namespace=None,
        healthy=None,
        hostname=None,
        id=None,
        name=None,
        port=None,
        port_override=None,
        proxy_cluster_id=None,
        secret_store_id=None,
        subdomain=None,
        tags=None,
        token=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided and may also be set to one of the ResourceIPAllocationMode constants to select between VNM, loopback, or default allocation.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthcheck_namespace = healthcheck_namespace if healthcheck_namespace is not None else ''
        '''
         The path used to check the health of your connection.  Defaults to `default`.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        '''
         The host to dial to initiate a connection from the egress node to this resource.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.port = port if port is not None else 0
        '''
         The port to dial to initiate a connection from the egress node to this resource.
        '''
        self.port_override = port_override if port_override is not None else 0
        '''
         The local port used by clients to connect to this resource. It is automatically generated if not provided on create and may be re-generated on update by specifying a value of -1.
        '''
        self.proxy_cluster_id = proxy_cluster_id if proxy_cluster_id is not None else ''
        '''
         ID of the proxy cluster for this resource, if any.
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         DNS subdomain through which this resource may be accessed on clients.  (e.g. "app-prod1" allows the resource to be accessed at "app-prod1.your-org-name.sdm-proxy-domain"). Only applicable to HTTP-based resources or resources using virtual networking mode.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.token = token if token is not None else ''
        '''
         The API token to authenticate with.
        '''

    def __repr__(self):
        return '<sdm.KubernetesServiceAccountUserImpersonation ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthcheck_namespace: ' + repr(self.healthcheck_namespace) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'proxy_cluster_id: ' + repr(self.proxy_cluster_id) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'token: ' + repr(self.token) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'egress_filter': self.egress_filter,
            'healthcheck_namespace': self.healthcheck_namespace,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'name': self.name,
            'port': self.port,
            'port_override': self.port_override,
            'proxy_cluster_id': self.proxy_cluster_id,
            'secret_store_id': self.secret_store_id,
            'subdomain': self.subdomain,
            'tags': self.tags,
            'token': self.token,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            egress_filter=d.get('egress_filter'),
            healthcheck_namespace=d.get('healthcheck_namespace'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            name=d.get('name'),
            port=d.get('port'),
            port_override=d.get('port_override'),
            proxy_cluster_id=d.get('proxy_cluster_id'),
            secret_store_id=d.get('secret_store_id'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
            token=d.get('token'),
        )


class KubernetesUserImpersonation:
    '''
    KubernetesUserImpersonation is deprecated, see docs for more info.
    '''
    __slots__ = [
        'bind_interface',
        'certificate_authority',
        'client_certificate',
        'client_key',
        'egress_filter',
        'healthcheck_namespace',
        'healthy',
        'hostname',
        'id',
        'name',
        'port',
        'port_override',
        'proxy_cluster_id',
        'secret_store_id',
        'subdomain',
        'tags',
    ]

    def __init__(
        self,
        bind_interface=None,
        certificate_authority=None,
        client_certificate=None,
        client_key=None,
        egress_filter=None,
        healthcheck_namespace=None,
        healthy=None,
        hostname=None,
        id=None,
        name=None,
        port=None,
        port_override=None,
        proxy_cluster_id=None,
        secret_store_id=None,
        subdomain=None,
        tags=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided and may also be set to one of the ResourceIPAllocationMode constants to select between VNM, loopback, or default allocation.
        '''
        self.certificate_authority = certificate_authority if certificate_authority is not None else ''
        '''
         The CA to authenticate TLS connections with.
        '''
        self.client_certificate = client_certificate if client_certificate is not None else ''
        '''
         The certificate to authenticate TLS connections with.
        '''
        self.client_key = client_key if client_key is not None else ''
        '''
         The key to authenticate TLS connections with.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthcheck_namespace = healthcheck_namespace if healthcheck_namespace is not None else ''
        '''
         The path used to check the health of your connection.  Defaults to `default`.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        '''
         The host to dial to initiate a connection from the egress node to this resource.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.port = port if port is not None else 0
        '''
         The port to dial to initiate a connection from the egress node to this resource.
        '''
        self.port_override = port_override if port_override is not None else 0
        '''
         The local port used by clients to connect to this resource. It is automatically generated if not provided on create and may be re-generated on update by specifying a value of -1.
        '''
        self.proxy_cluster_id = proxy_cluster_id if proxy_cluster_id is not None else ''
        '''
         ID of the proxy cluster for this resource, if any.
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         DNS subdomain through which this resource may be accessed on clients.  (e.g. "app-prod1" allows the resource to be accessed at "app-prod1.your-org-name.sdm-proxy-domain"). Only applicable to HTTP-based resources or resources using virtual networking mode.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''

    def __repr__(self):
        return '<sdm.KubernetesUserImpersonation ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'certificate_authority: ' + repr(self.certificate_authority) + ' ' +\
            'client_certificate: ' + repr(self.client_certificate) + ' ' +\
            'client_key: ' + repr(self.client_key) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthcheck_namespace: ' + repr(self.healthcheck_namespace) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'proxy_cluster_id: ' + repr(self.proxy_cluster_id) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'certificate_authority': self.certificate_authority,
            'client_certificate': self.client_certificate,
            'client_key': self.client_key,
            'egress_filter': self.egress_filter,
            'healthcheck_namespace': self.healthcheck_namespace,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'name': self.name,
            'port': self.port,
            'port_override': self.port_override,
            'proxy_cluster_id': self.proxy_cluster_id,
            'secret_store_id': self.secret_store_id,
            'subdomain': self.subdomain,
            'tags': self.tags,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            certificate_authority=d.get('certificate_authority'),
            client_certificate=d.get('client_certificate'),
            client_key=d.get('client_key'),
            egress_filter=d.get('egress_filter'),
            healthcheck_namespace=d.get('healthcheck_namespace'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            name=d.get('name'),
            port=d.get('port'),
            port_override=d.get('port_override'),
            proxy_cluster_id=d.get('proxy_cluster_id'),
            secret_store_id=d.get('secret_store_id'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
        )


class LogCategoryConfig:
    __slots__ = [
        'remote_discard_replays',
        'remote_encoder',
    ]

    def __init__(
        self,
        remote_discard_replays=None,
        remote_encoder=None,
    ):
        self.remote_discard_replays = remote_discard_replays if remote_discard_replays is not None else False
        '''
         Indicates if the Organization should exclude replay data from remote logging for the log category.
        '''
        self.remote_encoder = remote_encoder if remote_encoder is not None else ''
        '''
         The Organization's remote log encryption encoder, one of the LogRemoteEncoder constants.
        '''

    def __repr__(self):
        return '<sdm.LogCategoryConfig ' + \
            'remote_discard_replays: ' + repr(self.remote_discard_replays) + ' ' +\
            'remote_encoder: ' + repr(self.remote_encoder) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'remote_discard_replays': self.remote_discard_replays,
            'remote_encoder': self.remote_encoder,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            remote_discard_replays=d.get('remote_discard_replays'),
            remote_encoder=d.get('remote_encoder'),
        )


class LogConfig:
    __slots__ = [
        'categories',
        'local_encoder',
        'local_format',
        'local_socket_path',
        'local_storage',
        'local_tcp_address',
        'public_key',
    ]

    def __init__(
        self,
        categories=None,
        local_encoder=None,
        local_format=None,
        local_socket_path=None,
        local_storage=None,
        local_tcp_address=None,
        public_key=None,
    ):
        self.categories = categories if categories is not None else _porcelain_zero_value_log_category_config_map(
        )
        '''
         The Organization's log category configuration settings.
        '''
        self.local_encoder = local_encoder if local_encoder is not None else ''
        '''
         The Organization's local log encryption encoder, one of the LogLocalEncoder constants.
        '''
        self.local_format = local_format if local_format is not None else ''
        '''
         The Organization's local log format, one of the LogLocalFormat constants.
        '''
        self.local_socket_path = local_socket_path if local_socket_path is not None else ''
        '''
         The Organization's local log socket path.
        '''
        self.local_storage = local_storage if local_storage is not None else ''
        '''
         The Organization's local log storage, one of the LogLocalStorage constants.
        '''
        self.local_tcp_address = local_tcp_address if local_tcp_address is not None else ''
        '''
         The Organization's local log TCP address.
        '''
        self.public_key = public_key if public_key is not None else ''
        '''
         The Organization's public key in PEM format for encrypting logs.
        '''

    def __repr__(self):
        return '<sdm.LogConfig ' + \
            'categories: ' + repr(self.categories) + ' ' +\
            'local_encoder: ' + repr(self.local_encoder) + ' ' +\
            'local_format: ' + repr(self.local_format) + ' ' +\
            'local_socket_path: ' + repr(self.local_socket_path) + ' ' +\
            'local_storage: ' + repr(self.local_storage) + ' ' +\
            'local_tcp_address: ' + repr(self.local_tcp_address) + ' ' +\
            'public_key: ' + repr(self.public_key) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'categories': self.categories,
            'local_encoder': self.local_encoder,
            'local_format': self.local_format,
            'local_socket_path': self.local_socket_path,
            'local_storage': self.local_storage,
            'local_tcp_address': self.local_tcp_address,
            'public_key': self.public_key,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            categories=d.get('categories'),
            local_encoder=d.get('local_encoder'),
            local_format=d.get('local_format'),
            local_socket_path=d.get('local_socket_path'),
            local_storage=d.get('local_storage'),
            local_tcp_address=d.get('local_tcp_address'),
            public_key=d.get('public_key'),
        )


class MCP:
    '''
    MCP is currently unstable, and its API may change, or it may be removed,
    without a major version bump.
    '''
    __slots__ = [
        'bind_interface',
        'egress_filter',
        'healthy',
        'hostname',
        'id',
        'name',
        'password',
        'port',
        'port_override',
        'proxy_cluster_id',
        'secret_store_id',
        'subdomain',
        'tags',
    ]

    def __init__(
        self,
        bind_interface=None,
        egress_filter=None,
        healthy=None,
        hostname=None,
        id=None,
        name=None,
        password=None,
        port=None,
        port_override=None,
        proxy_cluster_id=None,
        secret_store_id=None,
        subdomain=None,
        tags=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided and may also be set to one of the ResourceIPAllocationMode constants to select between VNM, loopback, or default allocation.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        '''
         The host to dial to initiate a connection from the egress node to this resource.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.password = password if password is not None else ''
        '''
         The password to authenticate with.
        '''
        self.port = port if port is not None else 0
        '''
         The port to dial to initiate a connection from the egress node to this resource.
        '''
        self.port_override = port_override if port_override is not None else 0
        '''
         The local port used by clients to connect to this resource. It is automatically generated if not provided on create and may be re-generated on update by specifying a value of -1.
        '''
        self.proxy_cluster_id = proxy_cluster_id if proxy_cluster_id is not None else ''
        '''
         ID of the proxy cluster for this resource, if any.
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         DNS subdomain through which this resource may be accessed on clients.  (e.g. "app-prod1" allows the resource to be accessed at "app-prod1.your-org-name.sdm-proxy-domain"). Only applicable to HTTP-based resources or resources using virtual networking mode.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''

    def __repr__(self):
        return '<sdm.MCP ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'password: ' + repr(self.password) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'proxy_cluster_id: ' + repr(self.proxy_cluster_id) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'egress_filter': self.egress_filter,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'name': self.name,
            'password': self.password,
            'port': self.port,
            'port_override': self.port_override,
            'proxy_cluster_id': self.proxy_cluster_id,
            'secret_store_id': self.secret_store_id,
            'subdomain': self.subdomain,
            'tags': self.tags,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            egress_filter=d.get('egress_filter'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            name=d.get('name'),
            password=d.get('password'),
            port=d.get('port'),
            port_override=d.get('port_override'),
            proxy_cluster_id=d.get('proxy_cluster_id'),
            secret_store_id=d.get('secret_store_id'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
        )


class MTLSMysql:
    __slots__ = [
        'bind_interface',
        'certificate_authority',
        'client_certificate',
        'client_key',
        'database',
        'egress_filter',
        'healthy',
        'hostname',
        'id',
        'name',
        'password',
        'port',
        'port_override',
        'proxy_cluster_id',
        'require_native_auth',
        'secret_store_id',
        'server_name',
        'subdomain',
        'tags',
        'use_azure_single_server_usernames',
        'username',
    ]

    def __init__(
        self,
        bind_interface=None,
        certificate_authority=None,
        client_certificate=None,
        client_key=None,
        database=None,
        egress_filter=None,
        healthy=None,
        hostname=None,
        id=None,
        name=None,
        password=None,
        port=None,
        port_override=None,
        proxy_cluster_id=None,
        require_native_auth=None,
        secret_store_id=None,
        server_name=None,
        subdomain=None,
        tags=None,
        use_azure_single_server_usernames=None,
        username=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided and may also be set to one of the ResourceIPAllocationMode constants to select between VNM, loopback, or default allocation.
        '''
        self.certificate_authority = certificate_authority if certificate_authority is not None else ''
        '''
         The CA to authenticate TLS connections with.
        '''
        self.client_certificate = client_certificate if client_certificate is not None else ''
        '''
         The certificate to authenticate TLS connections with.
        '''
        self.client_key = client_key if client_key is not None else ''
        '''
         The key to authenticate TLS connections with.
        '''
        self.database = database if database is not None else ''
        '''
         The database for healthchecks. Does not affect client requests.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        '''
         The host to dial to initiate a connection from the egress node to this resource.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.password = password if password is not None else ''
        '''
         The password to authenticate with.
        '''
        self.port = port if port is not None else 0
        '''
         The port to dial to initiate a connection from the egress node to this resource.
        '''
        self.port_override = port_override if port_override is not None else 0
        '''
         The local port used by clients to connect to this resource. It is automatically generated if not provided on create and may be re-generated on update by specifying a value of -1.
        '''
        self.proxy_cluster_id = proxy_cluster_id if proxy_cluster_id is not None else ''
        '''
         ID of the proxy cluster for this resource, if any.
        '''
        self.require_native_auth = require_native_auth if require_native_auth is not None else False
        '''
         Whether native auth (mysql_native_password) is used for all connections (for backwards compatibility)
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.server_name = server_name if server_name is not None else ''
        '''
         Server name for TLS verification (unverified by StrongDM if empty)
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         DNS subdomain through which this resource may be accessed on clients.  (e.g. "app-prod1" allows the resource to be accessed at "app-prod1.your-org-name.sdm-proxy-domain"). Only applicable to HTTP-based resources or resources using virtual networking mode.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.use_azure_single_server_usernames = use_azure_single_server_usernames if use_azure_single_server_usernames is not None else False
        '''
         If true, appends the hostname to the username when hitting a database.azure.com address
        '''
        self.username = username if username is not None else ''
        '''
         The username to authenticate with.
        '''

    def __repr__(self):
        return '<sdm.MTLSMysql ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'certificate_authority: ' + repr(self.certificate_authority) + ' ' +\
            'client_certificate: ' + repr(self.client_certificate) + ' ' +\
            'client_key: ' + repr(self.client_key) + ' ' +\
            'database: ' + repr(self.database) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'password: ' + repr(self.password) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'proxy_cluster_id: ' + repr(self.proxy_cluster_id) + ' ' +\
            'require_native_auth: ' + repr(self.require_native_auth) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'server_name: ' + repr(self.server_name) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'use_azure_single_server_usernames: ' + repr(self.use_azure_single_server_usernames) + ' ' +\
            'username: ' + repr(self.username) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'certificate_authority': self.certificate_authority,
            'client_certificate': self.client_certificate,
            'client_key': self.client_key,
            'database': self.database,
            'egress_filter': self.egress_filter,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'name': self.name,
            'password': self.password,
            'port': self.port,
            'port_override': self.port_override,
            'proxy_cluster_id': self.proxy_cluster_id,
            'require_native_auth': self.require_native_auth,
            'secret_store_id': self.secret_store_id,
            'server_name': self.server_name,
            'subdomain': self.subdomain,
            'tags': self.tags,
            'use_azure_single_server_usernames':
            self.use_azure_single_server_usernames,
            'username': self.username,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            certificate_authority=d.get('certificate_authority'),
            client_certificate=d.get('client_certificate'),
            client_key=d.get('client_key'),
            database=d.get('database'),
            egress_filter=d.get('egress_filter'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            name=d.get('name'),
            password=d.get('password'),
            port=d.get('port'),
            port_override=d.get('port_override'),
            proxy_cluster_id=d.get('proxy_cluster_id'),
            require_native_auth=d.get('require_native_auth'),
            secret_store_id=d.get('secret_store_id'),
            server_name=d.get('server_name'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
            use_azure_single_server_usernames=d.get(
                'use_azure_single_server_usernames'),
            username=d.get('username'),
        )


class MTLSPostgres:
    __slots__ = [
        'bind_interface',
        'certificate_authority',
        'client_certificate',
        'client_key',
        'database',
        'egress_filter',
        'healthy',
        'hostname',
        'id',
        'name',
        'override_database',
        'password',
        'port',
        'port_override',
        'proxy_cluster_id',
        'secret_store_id',
        'server_name',
        'subdomain',
        'tags',
        'username',
    ]

    def __init__(
        self,
        bind_interface=None,
        certificate_authority=None,
        client_certificate=None,
        client_key=None,
        database=None,
        egress_filter=None,
        healthy=None,
        hostname=None,
        id=None,
        name=None,
        override_database=None,
        password=None,
        port=None,
        port_override=None,
        proxy_cluster_id=None,
        secret_store_id=None,
        server_name=None,
        subdomain=None,
        tags=None,
        username=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided and may also be set to one of the ResourceIPAllocationMode constants to select between VNM, loopback, or default allocation.
        '''
        self.certificate_authority = certificate_authority if certificate_authority is not None else ''
        '''
         The CA to authenticate TLS connections with.
        '''
        self.client_certificate = client_certificate if client_certificate is not None else ''
        '''
         The certificate to authenticate TLS connections with.
        '''
        self.client_key = client_key if client_key is not None else ''
        '''
         The key to authenticate TLS connections with.
        '''
        self.database = database if database is not None else ''
        '''
         The initial database to connect to. This setting does not by itself prevent switching to another database after connecting.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        '''
         The host to dial to initiate a connection from the egress node to this resource.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.override_database = override_database if override_database is not None else False
        '''
         If set, the database configured cannot be changed by users. This setting is not recommended for most use cases, as some clients will insist their database has changed when it has not, leading to user confusion.
        '''
        self.password = password if password is not None else ''
        '''
         The password to authenticate with.
        '''
        self.port = port if port is not None else 0
        '''
         The port to dial to initiate a connection from the egress node to this resource.
        '''
        self.port_override = port_override if port_override is not None else 0
        '''
         The local port used by clients to connect to this resource. It is automatically generated if not provided on create and may be re-generated on update by specifying a value of -1.
        '''
        self.proxy_cluster_id = proxy_cluster_id if proxy_cluster_id is not None else ''
        '''
         ID of the proxy cluster for this resource, if any.
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.server_name = server_name if server_name is not None else ''
        '''
         Server name for TLS verification (unverified by StrongDM if empty)
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         DNS subdomain through which this resource may be accessed on clients.  (e.g. "app-prod1" allows the resource to be accessed at "app-prod1.your-org-name.sdm-proxy-domain"). Only applicable to HTTP-based resources or resources using virtual networking mode.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.username = username if username is not None else ''
        '''
         The username to authenticate with.
        '''

    def __repr__(self):
        return '<sdm.MTLSPostgres ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'certificate_authority: ' + repr(self.certificate_authority) + ' ' +\
            'client_certificate: ' + repr(self.client_certificate) + ' ' +\
            'client_key: ' + repr(self.client_key) + ' ' +\
            'database: ' + repr(self.database) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'override_database: ' + repr(self.override_database) + ' ' +\
            'password: ' + repr(self.password) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'proxy_cluster_id: ' + repr(self.proxy_cluster_id) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'server_name: ' + repr(self.server_name) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'username: ' + repr(self.username) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'certificate_authority': self.certificate_authority,
            'client_certificate': self.client_certificate,
            'client_key': self.client_key,
            'database': self.database,
            'egress_filter': self.egress_filter,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'name': self.name,
            'override_database': self.override_database,
            'password': self.password,
            'port': self.port,
            'port_override': self.port_override,
            'proxy_cluster_id': self.proxy_cluster_id,
            'secret_store_id': self.secret_store_id,
            'server_name': self.server_name,
            'subdomain': self.subdomain,
            'tags': self.tags,
            'username': self.username,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            certificate_authority=d.get('certificate_authority'),
            client_certificate=d.get('client_certificate'),
            client_key=d.get('client_key'),
            database=d.get('database'),
            egress_filter=d.get('egress_filter'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            name=d.get('name'),
            override_database=d.get('override_database'),
            password=d.get('password'),
            port=d.get('port'),
            port_override=d.get('port_override'),
            proxy_cluster_id=d.get('proxy_cluster_id'),
            secret_store_id=d.get('secret_store_id'),
            server_name=d.get('server_name'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
            username=d.get('username'),
        )


class ManagedSecret:
    '''
         ManagedSecret contains details about managed secret
    '''
    __slots__ = [
        'config',
        'expires_at',
        'id',
        'last_rotated_at',
        'name',
        'policy',
        'secret_engine_id',
        'secret_store_path',
        'tags',
        'value',
    ]

    def __init__(
        self,
        config=None,
        expires_at=None,
        id=None,
        last_rotated_at=None,
        name=None,
        policy=None,
        secret_engine_id=None,
        secret_store_path=None,
        tags=None,
        value=None,
    ):
        self.config = config if config is not None else ''
        '''
         public part of the secret value
        '''
        self.expires_at = expires_at if expires_at is not None else None
        '''
         Timestamp of when secret is going to be rotated
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Managed Secret.
        '''
        self.last_rotated_at = last_rotated_at if last_rotated_at is not None else None
        '''
         Timestamp of when secret was last rotated
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Managed Secret.
        '''
        self.policy = policy if policy is not None else None
        '''
         Password and rotation policy for the secret
        '''
        self.secret_engine_id = secret_engine_id if secret_engine_id is not None else ''
        '''
         An ID of a Secret Engine linked with the Managed Secret.
        '''
        self.secret_store_path = secret_store_path if secret_store_path is not None else ''
        '''
         Path in a secret store.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.value = value if value is not None else b''
        '''
         Sensitive value of the secret.
        '''

    def __repr__(self):
        return '<sdm.ManagedSecret ' + \
            'config: ' + repr(self.config) + ' ' +\
            'expires_at: ' + repr(self.expires_at) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'last_rotated_at: ' + repr(self.last_rotated_at) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'policy: ' + repr(self.policy) + ' ' +\
            'secret_engine_id: ' + repr(self.secret_engine_id) + ' ' +\
            'secret_store_path: ' + repr(self.secret_store_path) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'value: ' + repr(self.value) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'config': self.config,
            'expires_at': self.expires_at,
            'id': self.id,
            'last_rotated_at': self.last_rotated_at,
            'name': self.name,
            'policy': self.policy,
            'secret_engine_id': self.secret_engine_id,
            'secret_store_path': self.secret_store_path,
            'tags': self.tags,
            'value': self.value,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            config=d.get('config'),
            expires_at=d.get('expires_at'),
            id=d.get('id'),
            last_rotated_at=d.get('last_rotated_at'),
            name=d.get('name'),
            policy=d.get('policy'),
            secret_engine_id=d.get('secret_engine_id'),
            secret_store_path=d.get('secret_store_path'),
            tags=d.get('tags'),
            value=d.get('value'),
        )


class ManagedSecretCreateRequest:
    '''
         ManagedSecretCreateRequest specifies a Managed Secret to create.
    '''
    __slots__ = [
        'managed_secret',
    ]

    def __init__(
        self,
        managed_secret=None,
    ):
        self.managed_secret = managed_secret if managed_secret is not None else None
        '''
         Parameters to define the new Managed Secret.
        '''

    def __repr__(self):
        return '<sdm.ManagedSecretCreateRequest ' + \
            'managed_secret: ' + repr(self.managed_secret) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'managed_secret': self.managed_secret,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(managed_secret=d.get('managed_secret'), )


class ManagedSecretCreateResponse:
    '''
         ManagedSecretCreateResponse contains information about a Managed Secret after
     successful creation.
    '''
    __slots__ = [
        'managed_secret',
        'meta',
        'rate_limit',
    ]

    def __init__(
        self,
        managed_secret=None,
        meta=None,
        rate_limit=None,
    ):
        self.managed_secret = managed_secret if managed_secret is not None else None
        '''
         The requested Managed Secret.
        '''
        self.meta = meta if meta is not None else None
        '''
         Reserved for future use.
        '''
        self.rate_limit = rate_limit if rate_limit is not None else None
        '''
         Rate limit information.
        '''

    def __repr__(self):
        return '<sdm.ManagedSecretCreateResponse ' + \
            'managed_secret: ' + repr(self.managed_secret) + ' ' +\
            'meta: ' + repr(self.meta) + ' ' +\
            'rate_limit: ' + repr(self.rate_limit) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'managed_secret': self.managed_secret,
            'meta': self.meta,
            'rate_limit': self.rate_limit,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            managed_secret=d.get('managed_secret'),
            meta=d.get('meta'),
            rate_limit=d.get('rate_limit'),
        )


class ManagedSecretDeleteRequest:
    '''
         ManagedSecretDeleteRequest specified the ID of a Managed Secret to be
     deleted.
    '''
    __slots__ = [
        'id',
    ]

    def __init__(
        self,
        id=None,
    ):
        self.id = id if id is not None else ''
        '''
         The unique identifier of the Managed Secret to delete.
        '''

    def __repr__(self):
        return '<sdm.ManagedSecretDeleteRequest ' + \
            'id: ' + repr(self.id) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'id': self.id,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(id=d.get('id'), )


class ManagedSecretDeleteResponse:
    '''
         ManagedSecretDeleteResponse contains information about a Managed Secret after
     it was deleted.
    '''
    __slots__ = [
        'rate_limit',
    ]

    def __init__(
        self,
        rate_limit=None,
    ):
        self.rate_limit = rate_limit if rate_limit is not None else None
        '''
         Rate limit information.
        '''

    def __repr__(self):
        return '<sdm.ManagedSecretDeleteResponse ' + \
            'rate_limit: ' + repr(self.rate_limit) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'rate_limit': self.rate_limit,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(rate_limit=d.get('rate_limit'), )


class ManagedSecretGetRequest:
    '''
         ManagedSecretGetRequest specifies which Managed Secret to retrieve
    '''
    __slots__ = [
        'id',
    ]

    def __init__(
        self,
        id=None,
    ):
        self.id = id if id is not None else ''
        '''
         The unique identifier of the Managed Secret to retrieve.
        '''

    def __repr__(self):
        return '<sdm.ManagedSecretGetRequest ' + \
            'id: ' + repr(self.id) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'id': self.id,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(id=d.get('id'), )


class ManagedSecretGetResponse:
    '''
         ManagedSecretGetResponse contains information about requested Managed Secret
    '''
    __slots__ = [
        'managed_secret',
        'meta',
        'rate_limit',
    ]

    def __init__(
        self,
        managed_secret=None,
        meta=None,
        rate_limit=None,
    ):
        self.managed_secret = managed_secret if managed_secret is not None else None
        '''
         The requested Managed Secret.
        '''
        self.meta = meta if meta is not None else None
        '''
         Reserved for future use.
        '''
        self.rate_limit = rate_limit if rate_limit is not None else None
        '''
         Rate limit information.
        '''

    def __repr__(self):
        return '<sdm.ManagedSecretGetResponse ' + \
            'managed_secret: ' + repr(self.managed_secret) + ' ' +\
            'meta: ' + repr(self.meta) + ' ' +\
            'rate_limit: ' + repr(self.rate_limit) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'managed_secret': self.managed_secret,
            'meta': self.meta,
            'rate_limit': self.rate_limit,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            managed_secret=d.get('managed_secret'),
            meta=d.get('meta'),
            rate_limit=d.get('rate_limit'),
        )


class ManagedSecretListRequest:
    '''
         ManagedSecretListRequest specifies criteria for retrieving a list of Managed
     Secrets.
    '''
    __slots__ = [
        'filter',
    ]

    def __init__(
        self,
        filter=None,
    ):
        self.filter = filter if filter is not None else ''
        '''
         A human-readable filter query string.
        '''

    def __repr__(self):
        return '<sdm.ManagedSecretListRequest ' + \
            'filter: ' + repr(self.filter) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'filter': self.filter,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(filter=d.get('filter'), )


class ManagedSecretListResponse:
    '''
         ManagedSecretListResponse contains a list of requested Managed Secrets
    '''
    __slots__ = [
        'rate_limit',
    ]

    def __init__(
        self,
        rate_limit=None,
    ):
        self.rate_limit = rate_limit if rate_limit is not None else None
        '''
         Rate limit information.
        '''

    def __repr__(self):
        return '<sdm.ManagedSecretListResponse ' + \
            'rate_limit: ' + repr(self.rate_limit) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'rate_limit': self.rate_limit,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(rate_limit=d.get('rate_limit'), )


class ManagedSecretLog:
    '''
         ManagedSecretLog contains details about action performed against a managed
     secret
    '''
    __slots__ = [
        'account_id',
        'action',
        'created_at',
        'debug',
        'id',
        'managed_secret_id',
        'secret_engine_id',
    ]

    def __init__(
        self,
        account_id=None,
        action=None,
        created_at=None,
        debug=None,
        id=None,
        managed_secret_id=None,
        secret_engine_id=None,
    ):
        self.account_id = account_id if account_id is not None else ''
        '''
         An ID of the account the action was performed by.
        '''
        self.action = action if action is not None else ''
        '''
         The action performed by the account against the managed secret.
        '''
        self.created_at = created_at if created_at is not None else None
        '''
         Timestamp of when action was performed.
        '''
        self.debug = debug if debug is not None else ''
        '''
         Any debug logs associated with the action.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Managed Secret Log.
        '''
        self.managed_secret_id = managed_secret_id if managed_secret_id is not None else ''
        '''
         An ID of the Managed Secret the action was performed against.
        '''
        self.secret_engine_id = secret_engine_id if secret_engine_id is not None else ''
        '''
         An ID of the Secret Engine linked with the Managed Secret.
        '''

    def __repr__(self):
        return '<sdm.ManagedSecretLog ' + \
            'account_id: ' + repr(self.account_id) + ' ' +\
            'action: ' + repr(self.action) + ' ' +\
            'created_at: ' + repr(self.created_at) + ' ' +\
            'debug: ' + repr(self.debug) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'managed_secret_id: ' + repr(self.managed_secret_id) + ' ' +\
            'secret_engine_id: ' + repr(self.secret_engine_id) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'account_id': self.account_id,
            'action': self.action,
            'created_at': self.created_at,
            'debug': self.debug,
            'id': self.id,
            'managed_secret_id': self.managed_secret_id,
            'secret_engine_id': self.secret_engine_id,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            account_id=d.get('account_id'),
            action=d.get('action'),
            created_at=d.get('created_at'),
            debug=d.get('debug'),
            id=d.get('id'),
            managed_secret_id=d.get('managed_secret_id'),
            secret_engine_id=d.get('secret_engine_id'),
        )


class ManagedSecretLogsRequest:
    '''
         ManagedSecretLogsRequest specifies criteria for retrieving a log of Managed
     Secrets actions.
    '''
    __slots__ = [
        'filter',
    ]

    def __init__(
        self,
        filter=None,
    ):
        self.filter = filter if filter is not None else ''
        '''
         A human-readable filter query string.
        '''

    def __repr__(self):
        return '<sdm.ManagedSecretLogsRequest ' + \
            'filter: ' + repr(self.filter) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'filter': self.filter,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(filter=d.get('filter'), )


class ManagedSecretLogsResponse:
    '''
         ManagedSecretLogsResponse contains a list of requested Managed Secrets
    '''
    __slots__ = [
        'rate_limit',
    ]

    def __init__(
        self,
        rate_limit=None,
    ):
        self.rate_limit = rate_limit if rate_limit is not None else None
        '''
         Rate limit information.
        '''

    def __repr__(self):
        return '<sdm.ManagedSecretLogsResponse ' + \
            'rate_limit: ' + repr(self.rate_limit) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'rate_limit': self.rate_limit,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(rate_limit=d.get('rate_limit'), )


class ManagedSecretPasswordPolicy:
    __slots__ = [
        'allow_repeat',
        'exclude_characters',
        'exclude_upper_case',
        'length',
        'num_digits',
        'num_symbols',
    ]

    def __init__(
        self,
        allow_repeat=None,
        exclude_characters=None,
        exclude_upper_case=None,
        length=None,
        num_digits=None,
        num_symbols=None,
    ):
        self.allow_repeat = allow_repeat if allow_repeat is not None else False
        '''
         If set to true allows for consecutive characters to repeat itself
        '''
        self.exclude_characters = exclude_characters if exclude_characters is not None else ''
        '''
         Characters to exclude when generating password
        '''
        self.exclude_upper_case = exclude_upper_case if exclude_upper_case is not None else False
        '''
         If set to true do not include upper case letters when generating password
        '''
        self.length = length if length is not None else 0
        '''
         Password length
        '''
        self.num_digits = num_digits if num_digits is not None else 0
        '''
         Numbers of digits to use when generating password
        '''
        self.num_symbols = num_symbols if num_symbols is not None else 0
        '''
         Number of symbols to use when generating password
        '''

    def __repr__(self):
        return '<sdm.ManagedSecretPasswordPolicy ' + \
            'allow_repeat: ' + repr(self.allow_repeat) + ' ' +\
            'exclude_characters: ' + repr(self.exclude_characters) + ' ' +\
            'exclude_upper_case: ' + repr(self.exclude_upper_case) + ' ' +\
            'length: ' + repr(self.length) + ' ' +\
            'num_digits: ' + repr(self.num_digits) + ' ' +\
            'num_symbols: ' + repr(self.num_symbols) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'allow_repeat': self.allow_repeat,
            'exclude_characters': self.exclude_characters,
            'exclude_upper_case': self.exclude_upper_case,
            'length': self.length,
            'num_digits': self.num_digits,
            'num_symbols': self.num_symbols,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            allow_repeat=d.get('allow_repeat'),
            exclude_characters=d.get('exclude_characters'),
            exclude_upper_case=d.get('exclude_upper_case'),
            length=d.get('length'),
            num_digits=d.get('num_digits'),
            num_symbols=d.get('num_symbols'),
        )


class ManagedSecretPolicy:
    '''
         ManagedSecretPolicy contains password and rotation policy for managed secret
    '''
    __slots__ = [
        'password_policy',
        'rotation_policy',
    ]

    def __init__(
        self,
        password_policy=None,
        rotation_policy=None,
    ):
        self.password_policy = password_policy if password_policy is not None else None
        '''
         Password policy for a managed secret
        '''
        self.rotation_policy = rotation_policy if rotation_policy is not None else None
        '''
         Rotation policy for a managed secret
        '''

    def __repr__(self):
        return '<sdm.ManagedSecretPolicy ' + \
            'password_policy: ' + repr(self.password_policy) + ' ' +\
            'rotation_policy: ' + repr(self.rotation_policy) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'password_policy': self.password_policy,
            'rotation_policy': self.rotation_policy,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            password_policy=d.get('password_policy'),
            rotation_policy=d.get('rotation_policy'),
        )


class ManagedSecretRetrieveRequest:
    '''
         ManagedSecretRetrieveRequest specifies which Managed Secret to retrieve
    '''
    __slots__ = [
        'id',
        'public_key',
    ]

    def __init__(
        self,
        id=None,
        public_key=None,
    ):
        self.id = id if id is not None else ''
        '''
         The unique identifier of the Managed Secret to retrieve.
        '''
        self.public_key = public_key if public_key is not None else b''
        '''
         Public key to encrypt a sensitive value with
        '''

    def __repr__(self):
        return '<sdm.ManagedSecretRetrieveRequest ' + \
            'id: ' + repr(self.id) + ' ' +\
            'public_key: ' + repr(self.public_key) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'id': self.id,
            'public_key': self.public_key,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            id=d.get('id'),
            public_key=d.get('public_key'),
        )


class ManagedSecretRetrieveResponse:
    '''
         ManagedSecretRetrieveResponse contains information about requested Managed
     Secret
    '''
    __slots__ = [
        'managed_secret',
        'meta',
        'rate_limit',
    ]

    def __init__(
        self,
        managed_secret=None,
        meta=None,
        rate_limit=None,
    ):
        self.managed_secret = managed_secret if managed_secret is not None else None
        '''
         The requested Managed Secret.
        '''
        self.meta = meta if meta is not None else None
        '''
         Reserved for future use.
        '''
        self.rate_limit = rate_limit if rate_limit is not None else None
        '''
         Rate limit information.
        '''

    def __repr__(self):
        return '<sdm.ManagedSecretRetrieveResponse ' + \
            'managed_secret: ' + repr(self.managed_secret) + ' ' +\
            'meta: ' + repr(self.meta) + ' ' +\
            'rate_limit: ' + repr(self.rate_limit) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'managed_secret': self.managed_secret,
            'meta': self.meta,
            'rate_limit': self.rate_limit,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            managed_secret=d.get('managed_secret'),
            meta=d.get('meta'),
            rate_limit=d.get('rate_limit'),
        )


class ManagedSecretRotateRequest:
    '''
         ManagedSecretRotateRequest specifies Managed Secret to rotate
    '''
    __slots__ = [
        'id',
    ]

    def __init__(
        self,
        id=None,
    ):
        self.id = id if id is not None else ''
        '''
         The unique identifier of the Managed Secret to rotate.
        '''

    def __repr__(self):
        return '<sdm.ManagedSecretRotateRequest ' + \
            'id: ' + repr(self.id) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'id': self.id,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(id=d.get('id'), )


class ManagedSecretRotateResponse:
    '''
         ManagedSecretRotateResponse contains information about Secret Engine after
     successful rotation.
    '''
    __slots__ = [
        'meta',
        'rate_limit',
    ]

    def __init__(
        self,
        meta=None,
        rate_limit=None,
    ):
        self.meta = meta if meta is not None else None
        '''
         Reserved for future use.
        '''
        self.rate_limit = rate_limit if rate_limit is not None else None
        '''
         Rate limit information.
        '''

    def __repr__(self):
        return '<sdm.ManagedSecretRotateResponse ' + \
            'meta: ' + repr(self.meta) + ' ' +\
            'rate_limit: ' + repr(self.rate_limit) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'meta': self.meta,
            'rate_limit': self.rate_limit,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            meta=d.get('meta'),
            rate_limit=d.get('rate_limit'),
        )


class ManagedSecretRotationPolicy:
    __slots__ = []

    def __init__(self, ):
        pass

    def __repr__(self):
        return '<sdm.ManagedSecretRotationPolicy ' + \
            '>'

    def to_dict(self):
        return {}

    @classmethod
    def from_dict(cls, d):
        return cls()


class ManagedSecretUpdateRequest:
    '''
         ManagedSecretUpdateRequest specifies Managed Secret to update
    '''
    __slots__ = [
        'managed_secret',
    ]

    def __init__(
        self,
        managed_secret=None,
    ):
        self.managed_secret = managed_secret if managed_secret is not None else None
        '''
         Managed Secret to update
        '''

    def __repr__(self):
        return '<sdm.ManagedSecretUpdateRequest ' + \
            'managed_secret: ' + repr(self.managed_secret) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'managed_secret': self.managed_secret,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(managed_secret=d.get('managed_secret'), )


class ManagedSecretUpdateResponse:
    '''
         ManagedSecretUpdateResponse contains information about Secret Engine after
     successful update.
    '''
    __slots__ = [
        'managed_secret',
        'meta',
        'rate_limit',
    ]

    def __init__(
        self,
        managed_secret=None,
        meta=None,
        rate_limit=None,
    ):
        self.managed_secret = managed_secret if managed_secret is not None else None
        '''
         The requested Managed Secret.
        '''
        self.meta = meta if meta is not None else None
        '''
         Reserved for future use.
        '''
        self.rate_limit = rate_limit if rate_limit is not None else None
        '''
         Rate limit information.
        '''

    def __repr__(self):
        return '<sdm.ManagedSecretUpdateResponse ' + \
            'managed_secret: ' + repr(self.managed_secret) + ' ' +\
            'meta: ' + repr(self.meta) + ' ' +\
            'rate_limit: ' + repr(self.rate_limit) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'managed_secret': self.managed_secret,
            'meta': self.meta,
            'rate_limit': self.rate_limit,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            managed_secret=d.get('managed_secret'),
            meta=d.get('meta'),
            rate_limit=d.get('rate_limit'),
        )


class ManagedSecretValidateRequest:
    '''
         ManagedSecretValidateRequest specifies which Managed Secret to validate
    '''
    __slots__ = [
        'id',
    ]

    def __init__(
        self,
        id=None,
    ):
        self.id = id if id is not None else ''
        '''
         The unique identifier of the Managed Secret to validate.
        '''

    def __repr__(self):
        return '<sdm.ManagedSecretValidateRequest ' + \
            'id: ' + repr(self.id) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'id': self.id,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(id=d.get('id'), )


class ManagedSecretValidateResponse:
    '''
         ManagedSecretValidateResponse contains validity of requested Managed
     Secret
    '''
    __slots__ = [
        'invalid_info',
        'meta',
        'rate_limit',
        'valid',
    ]

    def __init__(
        self,
        invalid_info=None,
        meta=None,
        rate_limit=None,
        valid=None,
    ):
        self.invalid_info = invalid_info if invalid_info is not None else ''
        '''
         Information about why secret is invalid
        '''
        self.meta = meta if meta is not None else None
        '''
         Reserved for future use.
        '''
        self.rate_limit = rate_limit if rate_limit is not None else None
        '''
         Rate limit information.
        '''
        self.valid = valid if valid is not None else False
        '''
         Whether the secret is valid
        '''

    def __repr__(self):
        return '<sdm.ManagedSecretValidateResponse ' + \
            'invalid_info: ' + repr(self.invalid_info) + ' ' +\
            'meta: ' + repr(self.meta) + ' ' +\
            'rate_limit: ' + repr(self.rate_limit) + ' ' +\
            'valid: ' + repr(self.valid) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'invalid_info': self.invalid_info,
            'meta': self.meta,
            'rate_limit': self.rate_limit,
            'valid': self.valid,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            invalid_info=d.get('invalid_info'),
            meta=d.get('meta'),
            rate_limit=d.get('rate_limit'),
            valid=d.get('valid'),
        )


class Maria:
    __slots__ = [
        'bind_interface',
        'database',
        'egress_filter',
        'healthy',
        'hostname',
        'id',
        'name',
        'password',
        'port',
        'port_override',
        'proxy_cluster_id',
        'require_native_auth',
        'secret_store_id',
        'subdomain',
        'tags',
        'use_azure_single_server_usernames',
        'username',
    ]

    def __init__(
        self,
        bind_interface=None,
        database=None,
        egress_filter=None,
        healthy=None,
        hostname=None,
        id=None,
        name=None,
        password=None,
        port=None,
        port_override=None,
        proxy_cluster_id=None,
        require_native_auth=None,
        secret_store_id=None,
        subdomain=None,
        tags=None,
        use_azure_single_server_usernames=None,
        username=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided and may also be set to one of the ResourceIPAllocationMode constants to select between VNM, loopback, or default allocation.
        '''
        self.database = database if database is not None else ''
        '''
         The database for healthchecks. Does not affect client requests.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        '''
         The host to dial to initiate a connection from the egress node to this resource.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.password = password if password is not None else ''
        '''
         The password to authenticate with.
        '''
        self.port = port if port is not None else 0
        '''
         The port to dial to initiate a connection from the egress node to this resource.
        '''
        self.port_override = port_override if port_override is not None else 0
        '''
         The local port used by clients to connect to this resource. It is automatically generated if not provided on create and may be re-generated on update by specifying a value of -1.
        '''
        self.proxy_cluster_id = proxy_cluster_id if proxy_cluster_id is not None else ''
        '''
         ID of the proxy cluster for this resource, if any.
        '''
        self.require_native_auth = require_native_auth if require_native_auth is not None else False
        '''
         Whether native auth (mysql_native_password) is used for all connections (for backwards compatibility)
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         DNS subdomain through which this resource may be accessed on clients.  (e.g. "app-prod1" allows the resource to be accessed at "app-prod1.your-org-name.sdm-proxy-domain"). Only applicable to HTTP-based resources or resources using virtual networking mode.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.use_azure_single_server_usernames = use_azure_single_server_usernames if use_azure_single_server_usernames is not None else False
        '''
         If true, appends the hostname to the username when hitting a database.azure.com address
        '''
        self.username = username if username is not None else ''
        '''
         The username to authenticate with.
        '''

    def __repr__(self):
        return '<sdm.Maria ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'database: ' + repr(self.database) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'password: ' + repr(self.password) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'proxy_cluster_id: ' + repr(self.proxy_cluster_id) + ' ' +\
            'require_native_auth: ' + repr(self.require_native_auth) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'use_azure_single_server_usernames: ' + repr(self.use_azure_single_server_usernames) + ' ' +\
            'username: ' + repr(self.username) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'database': self.database,
            'egress_filter': self.egress_filter,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'name': self.name,
            'password': self.password,
            'port': self.port,
            'port_override': self.port_override,
            'proxy_cluster_id': self.proxy_cluster_id,
            'require_native_auth': self.require_native_auth,
            'secret_store_id': self.secret_store_id,
            'subdomain': self.subdomain,
            'tags': self.tags,
            'use_azure_single_server_usernames':
            self.use_azure_single_server_usernames,
            'username': self.username,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            database=d.get('database'),
            egress_filter=d.get('egress_filter'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            name=d.get('name'),
            password=d.get('password'),
            port=d.get('port'),
            port_override=d.get('port_override'),
            proxy_cluster_id=d.get('proxy_cluster_id'),
            require_native_auth=d.get('require_native_auth'),
            secret_store_id=d.get('secret_store_id'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
            use_azure_single_server_usernames=d.get(
                'use_azure_single_server_usernames'),
            username=d.get('username'),
        )


class Memcached:
    __slots__ = [
        'bind_interface',
        'egress_filter',
        'healthy',
        'hostname',
        'id',
        'name',
        'port',
        'port_override',
        'proxy_cluster_id',
        'secret_store_id',
        'subdomain',
        'tags',
    ]

    def __init__(
        self,
        bind_interface=None,
        egress_filter=None,
        healthy=None,
        hostname=None,
        id=None,
        name=None,
        port=None,
        port_override=None,
        proxy_cluster_id=None,
        secret_store_id=None,
        subdomain=None,
        tags=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided and may also be set to one of the ResourceIPAllocationMode constants to select between VNM, loopback, or default allocation.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        '''
         The host to dial to initiate a connection from the egress node to this resource.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.port = port if port is not None else 0
        '''
         The port to dial to initiate a connection from the egress node to this resource.
        '''
        self.port_override = port_override if port_override is not None else 0
        '''
         The local port used by clients to connect to this resource. It is automatically generated if not provided on create and may be re-generated on update by specifying a value of -1.
        '''
        self.proxy_cluster_id = proxy_cluster_id if proxy_cluster_id is not None else ''
        '''
         ID of the proxy cluster for this resource, if any.
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         DNS subdomain through which this resource may be accessed on clients.  (e.g. "app-prod1" allows the resource to be accessed at "app-prod1.your-org-name.sdm-proxy-domain"). Only applicable to HTTP-based resources or resources using virtual networking mode.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''

    def __repr__(self):
        return '<sdm.Memcached ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'proxy_cluster_id: ' + repr(self.proxy_cluster_id) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'egress_filter': self.egress_filter,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'name': self.name,
            'port': self.port,
            'port_override': self.port_override,
            'proxy_cluster_id': self.proxy_cluster_id,
            'secret_store_id': self.secret_store_id,
            'subdomain': self.subdomain,
            'tags': self.tags,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            egress_filter=d.get('egress_filter'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            name=d.get('name'),
            port=d.get('port'),
            port_override=d.get('port_override'),
            proxy_cluster_id=d.get('proxy_cluster_id'),
            secret_store_id=d.get('secret_store_id'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
        )


class Memsql:
    __slots__ = [
        'bind_interface',
        'database',
        'egress_filter',
        'healthy',
        'hostname',
        'id',
        'name',
        'password',
        'port',
        'port_override',
        'proxy_cluster_id',
        'require_native_auth',
        'secret_store_id',
        'subdomain',
        'tags',
        'use_azure_single_server_usernames',
        'username',
    ]

    def __init__(
        self,
        bind_interface=None,
        database=None,
        egress_filter=None,
        healthy=None,
        hostname=None,
        id=None,
        name=None,
        password=None,
        port=None,
        port_override=None,
        proxy_cluster_id=None,
        require_native_auth=None,
        secret_store_id=None,
        subdomain=None,
        tags=None,
        use_azure_single_server_usernames=None,
        username=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided and may also be set to one of the ResourceIPAllocationMode constants to select between VNM, loopback, or default allocation.
        '''
        self.database = database if database is not None else ''
        '''
         The database for healthchecks. Does not affect client requests.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        '''
         The host to dial to initiate a connection from the egress node to this resource.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.password = password if password is not None else ''
        '''
         The password to authenticate with.
        '''
        self.port = port if port is not None else 0
        '''
         The port to dial to initiate a connection from the egress node to this resource.
        '''
        self.port_override = port_override if port_override is not None else 0
        '''
         The local port used by clients to connect to this resource. It is automatically generated if not provided on create and may be re-generated on update by specifying a value of -1.
        '''
        self.proxy_cluster_id = proxy_cluster_id if proxy_cluster_id is not None else ''
        '''
         ID of the proxy cluster for this resource, if any.
        '''
        self.require_native_auth = require_native_auth if require_native_auth is not None else False
        '''
         Whether native auth (mysql_native_password) is used for all connections (for backwards compatibility)
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         DNS subdomain through which this resource may be accessed on clients.  (e.g. "app-prod1" allows the resource to be accessed at "app-prod1.your-org-name.sdm-proxy-domain"). Only applicable to HTTP-based resources or resources using virtual networking mode.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.use_azure_single_server_usernames = use_azure_single_server_usernames if use_azure_single_server_usernames is not None else False
        '''
         If true, appends the hostname to the username when hitting a database.azure.com address
        '''
        self.username = username if username is not None else ''
        '''
         The username to authenticate with.
        '''

    def __repr__(self):
        return '<sdm.Memsql ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'database: ' + repr(self.database) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'password: ' + repr(self.password) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'proxy_cluster_id: ' + repr(self.proxy_cluster_id) + ' ' +\
            'require_native_auth: ' + repr(self.require_native_auth) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'use_azure_single_server_usernames: ' + repr(self.use_azure_single_server_usernames) + ' ' +\
            'username: ' + repr(self.username) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'database': self.database,
            'egress_filter': self.egress_filter,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'name': self.name,
            'password': self.password,
            'port': self.port,
            'port_override': self.port_override,
            'proxy_cluster_id': self.proxy_cluster_id,
            'require_native_auth': self.require_native_auth,
            'secret_store_id': self.secret_store_id,
            'subdomain': self.subdomain,
            'tags': self.tags,
            'use_azure_single_server_usernames':
            self.use_azure_single_server_usernames,
            'username': self.username,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            database=d.get('database'),
            egress_filter=d.get('egress_filter'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            name=d.get('name'),
            password=d.get('password'),
            port=d.get('port'),
            port_override=d.get('port_override'),
            proxy_cluster_id=d.get('proxy_cluster_id'),
            require_native_auth=d.get('require_native_auth'),
            secret_store_id=d.get('secret_store_id'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
            use_azure_single_server_usernames=d.get(
                'use_azure_single_server_usernames'),
            username=d.get('username'),
        )


class MongoHost:
    __slots__ = [
        'auth_database',
        'bind_interface',
        'egress_filter',
        'healthy',
        'hostname',
        'id',
        'name',
        'password',
        'port',
        'port_override',
        'proxy_cluster_id',
        'secret_store_id',
        'subdomain',
        'tags',
        'tls_required',
        'username',
    ]

    def __init__(
        self,
        auth_database=None,
        bind_interface=None,
        egress_filter=None,
        healthy=None,
        hostname=None,
        id=None,
        name=None,
        password=None,
        port=None,
        port_override=None,
        proxy_cluster_id=None,
        secret_store_id=None,
        subdomain=None,
        tags=None,
        tls_required=None,
        username=None,
    ):
        self.auth_database = auth_database if auth_database is not None else ''
        '''
         The authentication database to use.
        '''
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided and may also be set to one of the ResourceIPAllocationMode constants to select between VNM, loopback, or default allocation.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        '''
         The host to dial to initiate a connection from the egress node to this resource.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.password = password if password is not None else ''
        '''
         The password to authenticate with.
        '''
        self.port = port if port is not None else 0
        '''
         The port to dial to initiate a connection from the egress node to this resource.
        '''
        self.port_override = port_override if port_override is not None else 0
        '''
         The local port used by clients to connect to this resource. It is automatically generated if not provided on create and may be re-generated on update by specifying a value of -1.
        '''
        self.proxy_cluster_id = proxy_cluster_id if proxy_cluster_id is not None else ''
        '''
         ID of the proxy cluster for this resource, if any.
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         DNS subdomain through which this resource may be accessed on clients.  (e.g. "app-prod1" allows the resource to be accessed at "app-prod1.your-org-name.sdm-proxy-domain"). Only applicable to HTTP-based resources or resources using virtual networking mode.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.tls_required = tls_required if tls_required is not None else False
        '''
         If set, TLS must be used to connect to this resource.
        '''
        self.username = username if username is not None else ''
        '''
         The username to authenticate with.
        '''

    def __repr__(self):
        return '<sdm.MongoHost ' + \
            'auth_database: ' + repr(self.auth_database) + ' ' +\
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'password: ' + repr(self.password) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'proxy_cluster_id: ' + repr(self.proxy_cluster_id) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'tls_required: ' + repr(self.tls_required) + ' ' +\
            'username: ' + repr(self.username) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'auth_database': self.auth_database,
            'bind_interface': self.bind_interface,
            'egress_filter': self.egress_filter,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'name': self.name,
            'password': self.password,
            'port': self.port,
            'port_override': self.port_override,
            'proxy_cluster_id': self.proxy_cluster_id,
            'secret_store_id': self.secret_store_id,
            'subdomain': self.subdomain,
            'tags': self.tags,
            'tls_required': self.tls_required,
            'username': self.username,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            auth_database=d.get('auth_database'),
            bind_interface=d.get('bind_interface'),
            egress_filter=d.get('egress_filter'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            name=d.get('name'),
            password=d.get('password'),
            port=d.get('port'),
            port_override=d.get('port_override'),
            proxy_cluster_id=d.get('proxy_cluster_id'),
            secret_store_id=d.get('secret_store_id'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
            tls_required=d.get('tls_required'),
            username=d.get('username'),
        )


class MongoLegacyHost:
    '''
    MongoLegacyHost is currently unstable, and its API may change, or it may be removed,
    without a major version bump.
    '''
    __slots__ = [
        'auth_database',
        'bind_interface',
        'egress_filter',
        'healthy',
        'hostname',
        'id',
        'name',
        'password',
        'port',
        'port_override',
        'proxy_cluster_id',
        'secret_store_id',
        'subdomain',
        'tags',
        'tls_required',
        'username',
    ]

    def __init__(
        self,
        auth_database=None,
        bind_interface=None,
        egress_filter=None,
        healthy=None,
        hostname=None,
        id=None,
        name=None,
        password=None,
        port=None,
        port_override=None,
        proxy_cluster_id=None,
        secret_store_id=None,
        subdomain=None,
        tags=None,
        tls_required=None,
        username=None,
    ):
        self.auth_database = auth_database if auth_database is not None else ''
        '''
         The authentication database to use.
        '''
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided and may also be set to one of the ResourceIPAllocationMode constants to select between VNM, loopback, or default allocation.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        '''
         The host to dial to initiate a connection from the egress node to this resource.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.password = password if password is not None else ''
        '''
         The password to authenticate with.
        '''
        self.port = port if port is not None else 0
        '''
         The port to dial to initiate a connection from the egress node to this resource.
        '''
        self.port_override = port_override if port_override is not None else 0
        '''
         The local port used by clients to connect to this resource. It is automatically generated if not provided on create and may be re-generated on update by specifying a value of -1.
        '''
        self.proxy_cluster_id = proxy_cluster_id if proxy_cluster_id is not None else ''
        '''
         ID of the proxy cluster for this resource, if any.
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         DNS subdomain through which this resource may be accessed on clients.  (e.g. "app-prod1" allows the resource to be accessed at "app-prod1.your-org-name.sdm-proxy-domain"). Only applicable to HTTP-based resources or resources using virtual networking mode.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.tls_required = tls_required if tls_required is not None else False
        '''
         If set, TLS must be used to connect to this resource.
        '''
        self.username = username if username is not None else ''
        '''
         The username to authenticate with.
        '''

    def __repr__(self):
        return '<sdm.MongoLegacyHost ' + \
            'auth_database: ' + repr(self.auth_database) + ' ' +\
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'password: ' + repr(self.password) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'proxy_cluster_id: ' + repr(self.proxy_cluster_id) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'tls_required: ' + repr(self.tls_required) + ' ' +\
            'username: ' + repr(self.username) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'auth_database': self.auth_database,
            'bind_interface': self.bind_interface,
            'egress_filter': self.egress_filter,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'name': self.name,
            'password': self.password,
            'port': self.port,
            'port_override': self.port_override,
            'proxy_cluster_id': self.proxy_cluster_id,
            'secret_store_id': self.secret_store_id,
            'subdomain': self.subdomain,
            'tags': self.tags,
            'tls_required': self.tls_required,
            'username': self.username,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            auth_database=d.get('auth_database'),
            bind_interface=d.get('bind_interface'),
            egress_filter=d.get('egress_filter'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            name=d.get('name'),
            password=d.get('password'),
            port=d.get('port'),
            port_override=d.get('port_override'),
            proxy_cluster_id=d.get('proxy_cluster_id'),
            secret_store_id=d.get('secret_store_id'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
            tls_required=d.get('tls_required'),
            username=d.get('username'),
        )


class MongoLegacyReplicaset:
    '''
    MongoLegacyReplicaset is currently unstable, and its API may change, or it may be removed,
    without a major version bump.
    '''
    __slots__ = [
        'auth_database',
        'bind_interface',
        'connect_to_replica',
        'egress_filter',
        'healthy',
        'hostname',
        'id',
        'name',
        'password',
        'port',
        'port_override',
        'proxy_cluster_id',
        'replica_set',
        'secret_store_id',
        'subdomain',
        'tags',
        'tls_required',
        'username',
    ]

    def __init__(
        self,
        auth_database=None,
        bind_interface=None,
        connect_to_replica=None,
        egress_filter=None,
        healthy=None,
        hostname=None,
        id=None,
        name=None,
        password=None,
        port=None,
        port_override=None,
        proxy_cluster_id=None,
        replica_set=None,
        secret_store_id=None,
        subdomain=None,
        tags=None,
        tls_required=None,
        username=None,
    ):
        self.auth_database = auth_database if auth_database is not None else ''
        '''
         The authentication database to use.
        '''
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided and may also be set to one of the ResourceIPAllocationMode constants to select between VNM, loopback, or default allocation.
        '''
        self.connect_to_replica = connect_to_replica if connect_to_replica is not None else False
        '''
         Set to connect to a replica instead of the primary node.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        '''
         The host to dial to initiate a connection from the egress node to this resource.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.password = password if password is not None else ''
        '''
         The password to authenticate with.
        '''
        self.port = port if port is not None else 0
        '''
         The port to dial to initiate a connection from the egress node to this resource.
        '''
        self.port_override = port_override if port_override is not None else 0
        '''
         The local port used by clients to connect to this resource. It is automatically generated if not provided on create and may be re-generated on update by specifying a value of -1.
        '''
        self.proxy_cluster_id = proxy_cluster_id if proxy_cluster_id is not None else ''
        '''
         ID of the proxy cluster for this resource, if any.
        '''
        self.replica_set = replica_set if replica_set is not None else ''
        '''
         The name of the mongo replicaset.
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         DNS subdomain through which this resource may be accessed on clients.  (e.g. "app-prod1" allows the resource to be accessed at "app-prod1.your-org-name.sdm-proxy-domain"). Only applicable to HTTP-based resources or resources using virtual networking mode.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.tls_required = tls_required if tls_required is not None else False
        '''
         If set, TLS must be used to connect to this resource.
        '''
        self.username = username if username is not None else ''
        '''
         The username to authenticate with.
        '''

    def __repr__(self):
        return '<sdm.MongoLegacyReplicaset ' + \
            'auth_database: ' + repr(self.auth_database) + ' ' +\
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'connect_to_replica: ' + repr(self.connect_to_replica) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'password: ' + repr(self.password) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'proxy_cluster_id: ' + repr(self.proxy_cluster_id) + ' ' +\
            'replica_set: ' + repr(self.replica_set) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'tls_required: ' + repr(self.tls_required) + ' ' +\
            'username: ' + repr(self.username) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'auth_database': self.auth_database,
            'bind_interface': self.bind_interface,
            'connect_to_replica': self.connect_to_replica,
            'egress_filter': self.egress_filter,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'name': self.name,
            'password': self.password,
            'port': self.port,
            'port_override': self.port_override,
            'proxy_cluster_id': self.proxy_cluster_id,
            'replica_set': self.replica_set,
            'secret_store_id': self.secret_store_id,
            'subdomain': self.subdomain,
            'tags': self.tags,
            'tls_required': self.tls_required,
            'username': self.username,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            auth_database=d.get('auth_database'),
            bind_interface=d.get('bind_interface'),
            connect_to_replica=d.get('connect_to_replica'),
            egress_filter=d.get('egress_filter'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            name=d.get('name'),
            password=d.get('password'),
            port=d.get('port'),
            port_override=d.get('port_override'),
            proxy_cluster_id=d.get('proxy_cluster_id'),
            replica_set=d.get('replica_set'),
            secret_store_id=d.get('secret_store_id'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
            tls_required=d.get('tls_required'),
            username=d.get('username'),
        )


class MongoReplicaSet:
    __slots__ = [
        'auth_database',
        'bind_interface',
        'connect_to_replica',
        'egress_filter',
        'healthy',
        'hostname',
        'id',
        'name',
        'password',
        'port',
        'port_override',
        'proxy_cluster_id',
        'replica_set',
        'secret_store_id',
        'subdomain',
        'tags',
        'tls_required',
        'username',
    ]

    def __init__(
        self,
        auth_database=None,
        bind_interface=None,
        connect_to_replica=None,
        egress_filter=None,
        healthy=None,
        hostname=None,
        id=None,
        name=None,
        password=None,
        port=None,
        port_override=None,
        proxy_cluster_id=None,
        replica_set=None,
        secret_store_id=None,
        subdomain=None,
        tags=None,
        tls_required=None,
        username=None,
    ):
        self.auth_database = auth_database if auth_database is not None else ''
        '''
         The authentication database to use.
        '''
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided and may also be set to one of the ResourceIPAllocationMode constants to select between VNM, loopback, or default allocation.
        '''
        self.connect_to_replica = connect_to_replica if connect_to_replica is not None else False
        '''
         Set to connect to a replica instead of the primary node.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        '''
         The host to dial to initiate a connection from the egress node to this resource.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.password = password if password is not None else ''
        '''
         The password to authenticate with.
        '''
        self.port = port if port is not None else 0
        '''
         The port to dial to initiate a connection from the egress node to this resource.
        '''
        self.port_override = port_override if port_override is not None else 0
        '''
         The local port used by clients to connect to this resource. It is automatically generated if not provided on create and may be re-generated on update by specifying a value of -1.
        '''
        self.proxy_cluster_id = proxy_cluster_id if proxy_cluster_id is not None else ''
        '''
         ID of the proxy cluster for this resource, if any.
        '''
        self.replica_set = replica_set if replica_set is not None else ''
        '''
         The name of the mongo replicaset.
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         DNS subdomain through which this resource may be accessed on clients.  (e.g. "app-prod1" allows the resource to be accessed at "app-prod1.your-org-name.sdm-proxy-domain"). Only applicable to HTTP-based resources or resources using virtual networking mode.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.tls_required = tls_required if tls_required is not None else False
        '''
         If set, TLS must be used to connect to this resource.
        '''
        self.username = username if username is not None else ''
        '''
         The username to authenticate with.
        '''

    def __repr__(self):
        return '<sdm.MongoReplicaSet ' + \
            'auth_database: ' + repr(self.auth_database) + ' ' +\
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'connect_to_replica: ' + repr(self.connect_to_replica) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'password: ' + repr(self.password) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'proxy_cluster_id: ' + repr(self.proxy_cluster_id) + ' ' +\
            'replica_set: ' + repr(self.replica_set) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'tls_required: ' + repr(self.tls_required) + ' ' +\
            'username: ' + repr(self.username) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'auth_database': self.auth_database,
            'bind_interface': self.bind_interface,
            'connect_to_replica': self.connect_to_replica,
            'egress_filter': self.egress_filter,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'name': self.name,
            'password': self.password,
            'port': self.port,
            'port_override': self.port_override,
            'proxy_cluster_id': self.proxy_cluster_id,
            'replica_set': self.replica_set,
            'secret_store_id': self.secret_store_id,
            'subdomain': self.subdomain,
            'tags': self.tags,
            'tls_required': self.tls_required,
            'username': self.username,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            auth_database=d.get('auth_database'),
            bind_interface=d.get('bind_interface'),
            connect_to_replica=d.get('connect_to_replica'),
            egress_filter=d.get('egress_filter'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            name=d.get('name'),
            password=d.get('password'),
            port=d.get('port'),
            port_override=d.get('port_override'),
            proxy_cluster_id=d.get('proxy_cluster_id'),
            replica_set=d.get('replica_set'),
            secret_store_id=d.get('secret_store_id'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
            tls_required=d.get('tls_required'),
            username=d.get('username'),
        )


class MongoShardedCluster:
    __slots__ = [
        'auth_database',
        'bind_interface',
        'egress_filter',
        'healthy',
        'hostname',
        'id',
        'name',
        'password',
        'port_override',
        'proxy_cluster_id',
        'secret_store_id',
        'subdomain',
        'tags',
        'tls_required',
        'username',
    ]

    def __init__(
        self,
        auth_database=None,
        bind_interface=None,
        egress_filter=None,
        healthy=None,
        hostname=None,
        id=None,
        name=None,
        password=None,
        port_override=None,
        proxy_cluster_id=None,
        secret_store_id=None,
        subdomain=None,
        tags=None,
        tls_required=None,
        username=None,
    ):
        self.auth_database = auth_database if auth_database is not None else ''
        '''
         The authentication database to use.
        '''
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided and may also be set to one of the ResourceIPAllocationMode constants to select between VNM, loopback, or default allocation.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        '''
         The host to dial to initiate a connection from the egress node to this resource.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.password = password if password is not None else ''
        '''
         The password to authenticate with.
        '''
        self.port_override = port_override if port_override is not None else 0
        '''
         The local port used by clients to connect to this resource. It is automatically generated if not provided on create and may be re-generated on update by specifying a value of -1.
        '''
        self.proxy_cluster_id = proxy_cluster_id if proxy_cluster_id is not None else ''
        '''
         ID of the proxy cluster for this resource, if any.
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         DNS subdomain through which this resource may be accessed on clients.  (e.g. "app-prod1" allows the resource to be accessed at "app-prod1.your-org-name.sdm-proxy-domain"). Only applicable to HTTP-based resources or resources using virtual networking mode.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.tls_required = tls_required if tls_required is not None else False
        '''
         If set, TLS must be used to connect to this resource.
        '''
        self.username = username if username is not None else ''
        '''
         The username to authenticate with.
        '''

    def __repr__(self):
        return '<sdm.MongoShardedCluster ' + \
            'auth_database: ' + repr(self.auth_database) + ' ' +\
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'password: ' + repr(self.password) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'proxy_cluster_id: ' + repr(self.proxy_cluster_id) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'tls_required: ' + repr(self.tls_required) + ' ' +\
            'username: ' + repr(self.username) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'auth_database': self.auth_database,
            'bind_interface': self.bind_interface,
            'egress_filter': self.egress_filter,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'name': self.name,
            'password': self.password,
            'port_override': self.port_override,
            'proxy_cluster_id': self.proxy_cluster_id,
            'secret_store_id': self.secret_store_id,
            'subdomain': self.subdomain,
            'tags': self.tags,
            'tls_required': self.tls_required,
            'username': self.username,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            auth_database=d.get('auth_database'),
            bind_interface=d.get('bind_interface'),
            egress_filter=d.get('egress_filter'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            name=d.get('name'),
            password=d.get('password'),
            port_override=d.get('port_override'),
            proxy_cluster_id=d.get('proxy_cluster_id'),
            secret_store_id=d.get('secret_store_id'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
            tls_required=d.get('tls_required'),
            username=d.get('username'),
        )


class Mysql:
    __slots__ = [
        'bind_interface',
        'database',
        'egress_filter',
        'healthy',
        'hostname',
        'id',
        'name',
        'password',
        'port',
        'port_override',
        'proxy_cluster_id',
        'require_native_auth',
        'secret_store_id',
        'subdomain',
        'tags',
        'use_azure_single_server_usernames',
        'username',
    ]

    def __init__(
        self,
        bind_interface=None,
        database=None,
        egress_filter=None,
        healthy=None,
        hostname=None,
        id=None,
        name=None,
        password=None,
        port=None,
        port_override=None,
        proxy_cluster_id=None,
        require_native_auth=None,
        secret_store_id=None,
        subdomain=None,
        tags=None,
        use_azure_single_server_usernames=None,
        username=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided and may also be set to one of the ResourceIPAllocationMode constants to select between VNM, loopback, or default allocation.
        '''
        self.database = database if database is not None else ''
        '''
         The database for healthchecks. Does not affect client requests.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        '''
         The host to dial to initiate a connection from the egress node to this resource.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.password = password if password is not None else ''
        '''
         The password to authenticate with.
        '''
        self.port = port if port is not None else 0
        '''
         The port to dial to initiate a connection from the egress node to this resource.
        '''
        self.port_override = port_override if port_override is not None else 0
        '''
         The local port used by clients to connect to this resource. It is automatically generated if not provided on create and may be re-generated on update by specifying a value of -1.
        '''
        self.proxy_cluster_id = proxy_cluster_id if proxy_cluster_id is not None else ''
        '''
         ID of the proxy cluster for this resource, if any.
        '''
        self.require_native_auth = require_native_auth if require_native_auth is not None else False
        '''
         Whether native auth (mysql_native_password) is used for all connections (for backwards compatibility)
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         DNS subdomain through which this resource may be accessed on clients.  (e.g. "app-prod1" allows the resource to be accessed at "app-prod1.your-org-name.sdm-proxy-domain"). Only applicable to HTTP-based resources or resources using virtual networking mode.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.use_azure_single_server_usernames = use_azure_single_server_usernames if use_azure_single_server_usernames is not None else False
        '''
         If true, appends the hostname to the username when hitting a database.azure.com address
        '''
        self.username = username if username is not None else ''
        '''
         The username to authenticate with.
        '''

    def __repr__(self):
        return '<sdm.Mysql ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'database: ' + repr(self.database) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'password: ' + repr(self.password) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'proxy_cluster_id: ' + repr(self.proxy_cluster_id) + ' ' +\
            'require_native_auth: ' + repr(self.require_native_auth) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'use_azure_single_server_usernames: ' + repr(self.use_azure_single_server_usernames) + ' ' +\
            'username: ' + repr(self.username) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'database': self.database,
            'egress_filter': self.egress_filter,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'name': self.name,
            'password': self.password,
            'port': self.port,
            'port_override': self.port_override,
            'proxy_cluster_id': self.proxy_cluster_id,
            'require_native_auth': self.require_native_auth,
            'secret_store_id': self.secret_store_id,
            'subdomain': self.subdomain,
            'tags': self.tags,
            'use_azure_single_server_usernames':
            self.use_azure_single_server_usernames,
            'username': self.username,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            database=d.get('database'),
            egress_filter=d.get('egress_filter'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            name=d.get('name'),
            password=d.get('password'),
            port=d.get('port'),
            port_override=d.get('port_override'),
            proxy_cluster_id=d.get('proxy_cluster_id'),
            require_native_auth=d.get('require_native_auth'),
            secret_store_id=d.get('secret_store_id'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
            use_azure_single_server_usernames=d.get(
                'use_azure_single_server_usernames'),
            username=d.get('username'),
        )


class Neptune:
    __slots__ = [
        'bind_interface',
        'egress_filter',
        'endpoint',
        'healthy',
        'id',
        'name',
        'port',
        'port_override',
        'proxy_cluster_id',
        'secret_store_id',
        'subdomain',
        'tags',
    ]

    def __init__(
        self,
        bind_interface=None,
        egress_filter=None,
        endpoint=None,
        healthy=None,
        id=None,
        name=None,
        port=None,
        port_override=None,
        proxy_cluster_id=None,
        secret_store_id=None,
        subdomain=None,
        tags=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided and may also be set to one of the ResourceIPAllocationMode constants to select between VNM, loopback, or default allocation.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.endpoint = endpoint if endpoint is not None else ''
        '''
         The neptune endpoint to connect to as in endpoint.region.neptune.amazonaws.com
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.port = port if port is not None else 0
        '''
         The port to dial to initiate a connection from the egress node to this resource.
        '''
        self.port_override = port_override if port_override is not None else 0
        '''
         The local port used by clients to connect to this resource. It is automatically generated if not provided on create and may be re-generated on update by specifying a value of -1.
        '''
        self.proxy_cluster_id = proxy_cluster_id if proxy_cluster_id is not None else ''
        '''
         ID of the proxy cluster for this resource, if any.
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         DNS subdomain through which this resource may be accessed on clients.  (e.g. "app-prod1" allows the resource to be accessed at "app-prod1.your-org-name.sdm-proxy-domain"). Only applicable to HTTP-based resources or resources using virtual networking mode.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''

    def __repr__(self):
        return '<sdm.Neptune ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'endpoint: ' + repr(self.endpoint) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'proxy_cluster_id: ' + repr(self.proxy_cluster_id) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'egress_filter': self.egress_filter,
            'endpoint': self.endpoint,
            'healthy': self.healthy,
            'id': self.id,
            'name': self.name,
            'port': self.port,
            'port_override': self.port_override,
            'proxy_cluster_id': self.proxy_cluster_id,
            'secret_store_id': self.secret_store_id,
            'subdomain': self.subdomain,
            'tags': self.tags,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            egress_filter=d.get('egress_filter'),
            endpoint=d.get('endpoint'),
            healthy=d.get('healthy'),
            id=d.get('id'),
            name=d.get('name'),
            port=d.get('port'),
            port_override=d.get('port_override'),
            proxy_cluster_id=d.get('proxy_cluster_id'),
            secret_store_id=d.get('secret_store_id'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
        )


class NeptuneIAM:
    __slots__ = [
        'access_key',
        'bind_interface',
        'egress_filter',
        'endpoint',
        'healthy',
        'id',
        'name',
        'port',
        'port_override',
        'proxy_cluster_id',
        'region',
        'role_arn',
        'role_external_id',
        'secret_access_key',
        'secret_store_id',
        'subdomain',
        'tags',
    ]

    def __init__(
        self,
        access_key=None,
        bind_interface=None,
        egress_filter=None,
        endpoint=None,
        healthy=None,
        id=None,
        name=None,
        port=None,
        port_override=None,
        proxy_cluster_id=None,
        region=None,
        role_arn=None,
        role_external_id=None,
        secret_access_key=None,
        secret_store_id=None,
        subdomain=None,
        tags=None,
    ):
        self.access_key = access_key if access_key is not None else ''
        '''
         The Access Key ID to use to authenticate.
        '''
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided and may also be set to one of the ResourceIPAllocationMode constants to select between VNM, loopback, or default allocation.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.endpoint = endpoint if endpoint is not None else ''
        '''
         The neptune endpoint to connect to as in endpoint.region.neptune.amazonaws.com
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.port = port if port is not None else 0
        '''
         The port to dial to initiate a connection from the egress node to this resource.
        '''
        self.port_override = port_override if port_override is not None else 0
        '''
         The local port used by clients to connect to this resource. It is automatically generated if not provided on create and may be re-generated on update by specifying a value of -1.
        '''
        self.proxy_cluster_id = proxy_cluster_id if proxy_cluster_id is not None else ''
        '''
         ID of the proxy cluster for this resource, if any.
        '''
        self.region = region if region is not None else ''
        '''
         The AWS region to connect to.
        '''
        self.role_arn = role_arn if role_arn is not None else ''
        '''
         The role to assume after logging in.
        '''
        self.role_external_id = role_external_id if role_external_id is not None else ''
        '''
         The external ID to associate with assume role requests. Does nothing if a role ARN is not provided.
        '''
        self.secret_access_key = secret_access_key if secret_access_key is not None else ''
        '''
         The Secret Access Key to use to authenticate.
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         DNS subdomain through which this resource may be accessed on clients.  (e.g. "app-prod1" allows the resource to be accessed at "app-prod1.your-org-name.sdm-proxy-domain"). Only applicable to HTTP-based resources or resources using virtual networking mode.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''

    def __repr__(self):
        return '<sdm.NeptuneIAM ' + \
            'access_key: ' + repr(self.access_key) + ' ' +\
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'endpoint: ' + repr(self.endpoint) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'proxy_cluster_id: ' + repr(self.proxy_cluster_id) + ' ' +\
            'region: ' + repr(self.region) + ' ' +\
            'role_arn: ' + repr(self.role_arn) + ' ' +\
            'role_external_id: ' + repr(self.role_external_id) + ' ' +\
            'secret_access_key: ' + repr(self.secret_access_key) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'access_key': self.access_key,
            'bind_interface': self.bind_interface,
            'egress_filter': self.egress_filter,
            'endpoint': self.endpoint,
            'healthy': self.healthy,
            'id': self.id,
            'name': self.name,
            'port': self.port,
            'port_override': self.port_override,
            'proxy_cluster_id': self.proxy_cluster_id,
            'region': self.region,
            'role_arn': self.role_arn,
            'role_external_id': self.role_external_id,
            'secret_access_key': self.secret_access_key,
            'secret_store_id': self.secret_store_id,
            'subdomain': self.subdomain,
            'tags': self.tags,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            access_key=d.get('access_key'),
            bind_interface=d.get('bind_interface'),
            egress_filter=d.get('egress_filter'),
            endpoint=d.get('endpoint'),
            healthy=d.get('healthy'),
            id=d.get('id'),
            name=d.get('name'),
            port=d.get('port'),
            port_override=d.get('port_override'),
            proxy_cluster_id=d.get('proxy_cluster_id'),
            region=d.get('region'),
            role_arn=d.get('role_arn'),
            role_external_id=d.get('role_external_id'),
            secret_access_key=d.get('secret_access_key'),
            secret_store_id=d.get('secret_store_id'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
        )


class NodeCreateResponse:
    '''
         NodeCreateResponse reports how the Nodes were created in the system.
    '''
    __slots__ = [
        'meta',
        'node',
        'rate_limit',
        'token',
    ]

    def __init__(
        self,
        meta=None,
        node=None,
        rate_limit=None,
        token=None,
    ):
        self.meta = meta if meta is not None else None
        '''
         Reserved for future use.
        '''
        self.node = node if node is not None else None
        '''
         The created Node.
        '''
        self.rate_limit = rate_limit if rate_limit is not None else None
        '''
         Rate limit information.
        '''
        self.token = token if token is not None else ''
        '''
         The auth token generated for the Node. The Node will use this token to
         authenticate with the strongDM API.
        '''

    def __repr__(self):
        return '<sdm.NodeCreateResponse ' + \
            'meta: ' + repr(self.meta) + ' ' +\
            'node: ' + repr(self.node) + ' ' +\
            'rate_limit: ' + repr(self.rate_limit) + ' ' +\
            'token: ' + repr(self.token) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'meta': self.meta,
            'node': self.node,
            'rate_limit': self.rate_limit,
            'token': self.token,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            meta=d.get('meta'),
            node=d.get('node'),
            rate_limit=d.get('rate_limit'),
            token=d.get('token'),
        )


class NodeDeleteResponse:
    '''
         NodeDeleteResponse returns information about a Node that was deleted.
    '''
    __slots__ = [
        'meta',
        'rate_limit',
    ]

    def __init__(
        self,
        meta=None,
        rate_limit=None,
    ):
        self.meta = meta if meta is not None else None
        '''
         Reserved for future use.
        '''
        self.rate_limit = rate_limit if rate_limit is not None else None
        '''
         Rate limit information.
        '''

    def __repr__(self):
        return '<sdm.NodeDeleteResponse ' + \
            'meta: ' + repr(self.meta) + ' ' +\
            'rate_limit: ' + repr(self.rate_limit) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'meta': self.meta,
            'rate_limit': self.rate_limit,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            meta=d.get('meta'),
            rate_limit=d.get('rate_limit'),
        )


class NodeGetResponse:
    '''
         NodeGetResponse returns a requested Node.
    '''
    __slots__ = [
        'meta',
        'node',
        'rate_limit',
    ]

    def __init__(
        self,
        meta=None,
        node=None,
        rate_limit=None,
    ):
        self.meta = meta if meta is not None else None
        '''
         Reserved for future use.
        '''
        self.node = node if node is not None else None
        '''
         The requested Node.
        '''
        self.rate_limit = rate_limit if rate_limit is not None else None
        '''
         Rate limit information.
        '''

    def __repr__(self):
        return '<sdm.NodeGetResponse ' + \
            'meta: ' + repr(self.meta) + ' ' +\
            'node: ' + repr(self.node) + ' ' +\
            'rate_limit: ' + repr(self.rate_limit) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'meta': self.meta,
            'node': self.node,
            'rate_limit': self.rate_limit,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            meta=d.get('meta'),
            node=d.get('node'),
            rate_limit=d.get('rate_limit'),
        )


class NodeHistory:
    '''
         NodeHistory records the state of a Node at a given point in time,
     where every change (create, update and delete) to a Node produces an
     NodeHistory record.
    '''
    __slots__ = [
        'activity_id',
        'deleted_at',
        'node',
        'timestamp',
    ]

    def __init__(
        self,
        activity_id=None,
        deleted_at=None,
        node=None,
        timestamp=None,
    ):
        self.activity_id = activity_id if activity_id is not None else ''
        '''
         The unique identifier of the Activity that produced this change to the Node.
         May be empty for some system-initiated updates.
        '''
        self.deleted_at = deleted_at if deleted_at is not None else None
        '''
         If this Node was deleted, the time it was deleted.
        '''
        self.node = node if node is not None else None
        '''
         The complete Node state at this time.
        '''
        self.timestamp = timestamp if timestamp is not None else None
        '''
         The time at which the Node state was recorded.
        '''

    def __repr__(self):
        return '<sdm.NodeHistory ' + \
            'activity_id: ' + repr(self.activity_id) + ' ' +\
            'deleted_at: ' + repr(self.deleted_at) + ' ' +\
            'node: ' + repr(self.node) + ' ' +\
            'timestamp: ' + repr(self.timestamp) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'activity_id': self.activity_id,
            'deleted_at': self.deleted_at,
            'node': self.node,
            'timestamp': self.timestamp,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            activity_id=d.get('activity_id'),
            deleted_at=d.get('deleted_at'),
            node=d.get('node'),
            timestamp=d.get('timestamp'),
        )


class NodeMaintenanceWindow:
    __slots__ = [
        'cron_schedule',
        'require_idleness',
    ]

    def __init__(
        self,
        cron_schedule=None,
        require_idleness=None,
    ):
        self.cron_schedule = cron_schedule if cron_schedule is not None else ''
        '''
         Cron job syntax for when this maintenance window is active. On this schedule, associated
         nodes will restart if requested, provided other checks allow the restart to proceed. Times
         are represented in UTC.
         e.g. * 7 * * 0,6 to check for a restart at every minute from 7:00 to 8:00 UTC on Sunday and
         Saturday. Not all possible inputs are supported: the month and day of month selections
         must be '*'.
        '''
        self.require_idleness = require_idleness if require_idleness is not None else False
        '''
         Require Idleness defines whether this window can sever live connections. If true,
         this window will not allow a node to be restarted unless it is serving no connections.
         If false, given a restart of the node has been requested (for an update, usually), the
         node will restart as soon as it enters an allowed day / hour combination. At least one
         maintenance window, out of all configured windows for a node, must have this as false.
        '''

    def __repr__(self):
        return '<sdm.NodeMaintenanceWindow ' + \
            'cron_schedule: ' + repr(self.cron_schedule) + ' ' +\
            'require_idleness: ' + repr(self.require_idleness) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'cron_schedule': self.cron_schedule,
            'require_idleness': self.require_idleness,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            cron_schedule=d.get('cron_schedule'),
            require_idleness=d.get('require_idleness'),
        )


class NodeUpdateResponse:
    '''
         NodeUpdateResponse returns the fields of a Node after it has been updated by
     a NodeUpdateRequest.
    '''
    __slots__ = [
        'meta',
        'node',
        'rate_limit',
    ]

    def __init__(
        self,
        meta=None,
        node=None,
        rate_limit=None,
    ):
        self.meta = meta if meta is not None else None
        '''
         Reserved for future use.
        '''
        self.node = node if node is not None else None
        '''
         The updated Node.
        '''
        self.rate_limit = rate_limit if rate_limit is not None else None
        '''
         Rate limit information.
        '''

    def __repr__(self):
        return '<sdm.NodeUpdateResponse ' + \
            'meta: ' + repr(self.meta) + ' ' +\
            'node: ' + repr(self.node) + ' ' +\
            'rate_limit: ' + repr(self.rate_limit) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'meta': self.meta,
            'node': self.node,
            'rate_limit': self.rate_limit,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            meta=d.get('meta'),
            node=d.get('node'),
            rate_limit=d.get('rate_limit'),
        )


class Oracle:
    __slots__ = [
        'bind_interface',
        'database',
        'egress_filter',
        'healthy',
        'hostname',
        'id',
        'name',
        'password',
        'port',
        'port_override',
        'proxy_cluster_id',
        'secret_store_id',
        'subdomain',
        'tags',
        'tls_required',
        'username',
    ]

    def __init__(
        self,
        bind_interface=None,
        database=None,
        egress_filter=None,
        healthy=None,
        hostname=None,
        id=None,
        name=None,
        password=None,
        port=None,
        port_override=None,
        proxy_cluster_id=None,
        secret_store_id=None,
        subdomain=None,
        tags=None,
        tls_required=None,
        username=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided and may also be set to one of the ResourceIPAllocationMode constants to select between VNM, loopback, or default allocation.
        '''
        self.database = database if database is not None else ''
        '''
         Oracle service name to connect to
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        '''
         The host to dial to initiate a connection from the egress node to this resource.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.password = password if password is not None else ''
        '''
         The password to authenticate with.
        '''
        self.port = port if port is not None else 0
        '''
         The port to dial to initiate a connection from the egress node to this resource.
        '''
        self.port_override = port_override if port_override is not None else 0
        '''
         The local port used by clients to connect to this resource. It is automatically generated if not provided on create and may be re-generated on update by specifying a value of -1.
        '''
        self.proxy_cluster_id = proxy_cluster_id if proxy_cluster_id is not None else ''
        '''
         ID of the proxy cluster for this resource, if any.
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         DNS subdomain through which this resource may be accessed on clients.  (e.g. "app-prod1" allows the resource to be accessed at "app-prod1.your-org-name.sdm-proxy-domain"). Only applicable to HTTP-based resources or resources using virtual networking mode.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.tls_required = tls_required if tls_required is not None else False
        '''
         If set, TLS must be used to connect to this resource.
        '''
        self.username = username if username is not None else ''
        '''
         The username to authenticate with.
        '''

    def __repr__(self):
        return '<sdm.Oracle ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'database: ' + repr(self.database) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'password: ' + repr(self.password) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'proxy_cluster_id: ' + repr(self.proxy_cluster_id) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'tls_required: ' + repr(self.tls_required) + ' ' +\
            'username: ' + repr(self.username) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'database': self.database,
            'egress_filter': self.egress_filter,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'name': self.name,
            'password': self.password,
            'port': self.port,
            'port_override': self.port_override,
            'proxy_cluster_id': self.proxy_cluster_id,
            'secret_store_id': self.secret_store_id,
            'subdomain': self.subdomain,
            'tags': self.tags,
            'tls_required': self.tls_required,
            'username': self.username,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            database=d.get('database'),
            egress_filter=d.get('egress_filter'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            name=d.get('name'),
            password=d.get('password'),
            port=d.get('port'),
            port_override=d.get('port_override'),
            proxy_cluster_id=d.get('proxy_cluster_id'),
            secret_store_id=d.get('secret_store_id'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
            tls_required=d.get('tls_required'),
            username=d.get('username'),
        )


class OracleNNE:
    __slots__ = [
        'bind_interface',
        'database',
        'egress_filter',
        'healthy',
        'hostname',
        'id',
        'name',
        'password',
        'port',
        'port_override',
        'proxy_cluster_id',
        'secret_store_id',
        'subdomain',
        'tags',
        'tls_required',
        'username',
    ]

    def __init__(
        self,
        bind_interface=None,
        database=None,
        egress_filter=None,
        healthy=None,
        hostname=None,
        id=None,
        name=None,
        password=None,
        port=None,
        port_override=None,
        proxy_cluster_id=None,
        secret_store_id=None,
        subdomain=None,
        tags=None,
        tls_required=None,
        username=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided and may also be set to one of the ResourceIPAllocationMode constants to select between VNM, loopback, or default allocation.
        '''
        self.database = database if database is not None else ''
        '''
         Oracle service name to connect to
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        '''
         The host to dial to initiate a connection from the egress node to this resource.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.password = password if password is not None else ''
        '''
         The password to authenticate with.
        '''
        self.port = port if port is not None else 0
        '''
         The port to dial to initiate a connection from the egress node to this resource.
        '''
        self.port_override = port_override if port_override is not None else 0
        '''
         The local port used by clients to connect to this resource. It is automatically generated if not provided on create and may be re-generated on update by specifying a value of -1.
        '''
        self.proxy_cluster_id = proxy_cluster_id if proxy_cluster_id is not None else ''
        '''
         ID of the proxy cluster for this resource, if any.
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         DNS subdomain through which this resource may be accessed on clients.  (e.g. "app-prod1" allows the resource to be accessed at "app-prod1.your-org-name.sdm-proxy-domain"). Only applicable to HTTP-based resources or resources using virtual networking mode.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.tls_required = tls_required if tls_required is not None else False
        '''
         If set, TLS must be used to connect to this resource.
        '''
        self.username = username if username is not None else ''
        '''
         The username to authenticate with.
        '''

    def __repr__(self):
        return '<sdm.OracleNNE ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'database: ' + repr(self.database) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'password: ' + repr(self.password) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'proxy_cluster_id: ' + repr(self.proxy_cluster_id) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'tls_required: ' + repr(self.tls_required) + ' ' +\
            'username: ' + repr(self.username) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'database': self.database,
            'egress_filter': self.egress_filter,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'name': self.name,
            'password': self.password,
            'port': self.port,
            'port_override': self.port_override,
            'proxy_cluster_id': self.proxy_cluster_id,
            'secret_store_id': self.secret_store_id,
            'subdomain': self.subdomain,
            'tags': self.tags,
            'tls_required': self.tls_required,
            'username': self.username,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            database=d.get('database'),
            egress_filter=d.get('egress_filter'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            name=d.get('name'),
            password=d.get('password'),
            port=d.get('port'),
            port_override=d.get('port_override'),
            proxy_cluster_id=d.get('proxy_cluster_id'),
            secret_store_id=d.get('secret_store_id'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
            tls_required=d.get('tls_required'),
            username=d.get('username'),
        )


class Organization:
    __slots__ = [
        'auth_provider',
        'created_at',
        'device_trust_enabled',
        'device_trust_provider',
        'discard_replays',
        'enforce_single_session',
        'idle_timeout',
        'idle_timeout_enabled',
        'kind',
        'log_config',
        'log_local_encoder',
        'log_local_format',
        'log_local_storage',
        'log_remote_encoder',
        'log_socket_path',
        'log_tcp_address',
        'loopback_range',
        'mfa_enabled',
        'mfa_provider',
        'name',
        'public_key_pem',
        'require_secret_store',
        'saml_metadata_url',
        'scim_provider',
        'sensitive_label',
        'session_timeout',
        'session_timeout_enabled',
        'ssh_certificate_authority_public_key',
        'ssh_certificate_authority_updated_at',
        'updated_at',
        'websites_subdomain',
    ]

    def __init__(
        self,
        auth_provider=None,
        created_at=None,
        device_trust_enabled=None,
        device_trust_provider=None,
        discard_replays=None,
        enforce_single_session=None,
        idle_timeout=None,
        idle_timeout_enabled=None,
        kind=None,
        log_config=None,
        log_local_encoder=None,
        log_local_format=None,
        log_local_storage=None,
        log_remote_encoder=None,
        log_socket_path=None,
        log_tcp_address=None,
        loopback_range=None,
        mfa_enabled=None,
        mfa_provider=None,
        name=None,
        public_key_pem=None,
        require_secret_store=None,
        saml_metadata_url=None,
        scim_provider=None,
        sensitive_label=None,
        session_timeout=None,
        session_timeout_enabled=None,
        ssh_certificate_authority_public_key=None,
        ssh_certificate_authority_updated_at=None,
        updated_at=None,
        websites_subdomain=None,
    ):
        self.auth_provider = auth_provider if auth_provider is not None else ''
        '''
         The Organization's authentication provider, one of the AuthProvider constants.
        '''
        self.created_at = created_at if created_at is not None else None
        '''
         The time at which the Organization was created.
        '''
        self.device_trust_enabled = device_trust_enabled if device_trust_enabled is not None else False
        '''
         Indicates if the Organization has device trust enabled.
        '''
        self.device_trust_provider = device_trust_provider if device_trust_provider is not None else ''
        '''
         The Organization's device trust provider, one of the DeviceTrustProvider constants.
        '''
        self.discard_replays = discard_replays if discard_replays is not None else False
        '''
         Indicates if the Organization should drop replay data for SSH, RDP, and K8s logs.
         Deprecated: use categories specific log_config.categories[].remote_discard_replays instead
        '''
        self.enforce_single_session = enforce_single_session if enforce_single_session is not None else False
        '''
         Indicates if the Organization enforces a single session per user for the CLI and AdminUI.
        '''
        self.idle_timeout = idle_timeout if idle_timeout is not None else None
        '''
         The Organization's idle timeout, if enabled.
        '''
        self.idle_timeout_enabled = idle_timeout_enabled if idle_timeout_enabled is not None else False
        '''
         Indicates if the Organization has idle timeouts enabled.
        '''
        self.kind = kind if kind is not None else ''
        '''
         The Organization's type, one of the OrgKind constants.
        '''
        self.log_config = log_config if log_config is not None else None
        '''
         The Organization's logging settings
        '''
        self.log_local_encoder = log_local_encoder if log_local_encoder is not None else ''
        '''
         The Organization's local log encryption encoder, one of the LogLocalEncoder constants.
         Deprecated: use log_config.local_encoder instead
        '''
        self.log_local_format = log_local_format if log_local_format is not None else ''
        '''
         The Organization's local log format, one of the LogLocalFormat constants.
         Deprecated: use log_config.local_format instead
        '''
        self.log_local_storage = log_local_storage if log_local_storage is not None else ''
        '''
         The Organization's local log storage, one of the LogLocalStorage constants.
         Deprecated: use log_config.local_storage instead
        '''
        self.log_remote_encoder = log_remote_encoder if log_remote_encoder is not None else ''
        '''
         The Organization's remote log encryption encoder, one of the LogRemoteEncoder constants.
         Deprecated: use categories specific log_config.categories[].remote_encoder instead
        '''
        self.log_socket_path = log_socket_path if log_socket_path is not None else ''
        '''
         The Organization's socket path for Socket local log storage.
         Deprecated: use log_config.local_socket_path instead
        '''
        self.log_tcp_address = log_tcp_address if log_tcp_address is not None else ''
        '''
         The Organization's TCP address for TCP or Syslog local log storage.
         Deprecated: use log_config.local_tcp_address instead
        '''
        self.loopback_range = loopback_range if loopback_range is not None else ''
        '''
         The Organization's loopback range.
        '''
        self.mfa_enabled = mfa_enabled if mfa_enabled is not None else False
        '''
         Indicates if the Organization has multi-factor authentication enabled.
        '''
        self.mfa_provider = mfa_provider if mfa_provider is not None else ''
        '''
         The Organization's multi-factor authentication provider, one of the MFAProvider constants.
        '''
        self.name = name if name is not None else ''
        '''
         The Organization's name.
        '''
        self.public_key_pem = public_key_pem if public_key_pem is not None else ''
        '''
         The Organization's public key PEM for encrypting remote logs.
         Deprecated: use log_config.public_key instead
        '''
        self.require_secret_store = require_secret_store if require_secret_store is not None else False
        '''
         Indicates if the Organization requires secret stores.
        '''
        self.saml_metadata_url = saml_metadata_url if saml_metadata_url is not None else ''
        '''
         The Organization's URL for SAML metadata.
        '''
        self.scim_provider = scim_provider if scim_provider is not None else ''
        '''
         The Organization's SCIM provider, one of the SCIMProvider constants.
        '''
        self.sensitive_label = sensitive_label if sensitive_label is not None else ''
        '''
         The Organization's label for sensitive resources.
        '''
        self.session_timeout = session_timeout if session_timeout is not None else None
        '''
         The Organization's session timeout, if enabled.
        '''
        self.session_timeout_enabled = session_timeout_enabled if session_timeout_enabled is not None else False
        '''
         Indicates if the Organization has session timeouts enabled.
        '''
        self.ssh_certificate_authority_public_key = ssh_certificate_authority_public_key if ssh_certificate_authority_public_key is not None else ''
        '''
         The Organization's SSH certificate authority public key.
        '''
        self.ssh_certificate_authority_updated_at = ssh_certificate_authority_updated_at if ssh_certificate_authority_updated_at is not None else None
        '''
         The time at which the Organization's SSH certificate authority was last updated.
        '''
        self.updated_at = updated_at if updated_at is not None else None
        '''
         The time at which the Organization was last updated.
        '''
        self.websites_subdomain = websites_subdomain if websites_subdomain is not None else ''
        '''
         The Organization's web site domain.
        '''

    def __repr__(self):
        return '<sdm.Organization ' + \
            'auth_provider: ' + repr(self.auth_provider) + ' ' +\
            'created_at: ' + repr(self.created_at) + ' ' +\
            'device_trust_enabled: ' + repr(self.device_trust_enabled) + ' ' +\
            'device_trust_provider: ' + repr(self.device_trust_provider) + ' ' +\
            'discard_replays: ' + repr(self.discard_replays) + ' ' +\
            'enforce_single_session: ' + repr(self.enforce_single_session) + ' ' +\
            'idle_timeout: ' + repr(self.idle_timeout) + ' ' +\
            'idle_timeout_enabled: ' + repr(self.idle_timeout_enabled) + ' ' +\
            'kind: ' + repr(self.kind) + ' ' +\
            'log_config: ' + repr(self.log_config) + ' ' +\
            'log_local_encoder: ' + repr(self.log_local_encoder) + ' ' +\
            'log_local_format: ' + repr(self.log_local_format) + ' ' +\
            'log_local_storage: ' + repr(self.log_local_storage) + ' ' +\
            'log_remote_encoder: ' + repr(self.log_remote_encoder) + ' ' +\
            'log_socket_path: ' + repr(self.log_socket_path) + ' ' +\
            'log_tcp_address: ' + repr(self.log_tcp_address) + ' ' +\
            'loopback_range: ' + repr(self.loopback_range) + ' ' +\
            'mfa_enabled: ' + repr(self.mfa_enabled) + ' ' +\
            'mfa_provider: ' + repr(self.mfa_provider) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'public_key_pem: ' + repr(self.public_key_pem) + ' ' +\
            'require_secret_store: ' + repr(self.require_secret_store) + ' ' +\
            'saml_metadata_url: ' + repr(self.saml_metadata_url) + ' ' +\
            'scim_provider: ' + repr(self.scim_provider) + ' ' +\
            'sensitive_label: ' + repr(self.sensitive_label) + ' ' +\
            'session_timeout: ' + repr(self.session_timeout) + ' ' +\
            'session_timeout_enabled: ' + repr(self.session_timeout_enabled) + ' ' +\
            'ssh_certificate_authority_public_key: ' + repr(self.ssh_certificate_authority_public_key) + ' ' +\
            'ssh_certificate_authority_updated_at: ' + repr(self.ssh_certificate_authority_updated_at) + ' ' +\
            'updated_at: ' + repr(self.updated_at) + ' ' +\
            'websites_subdomain: ' + repr(self.websites_subdomain) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'auth_provider': self.auth_provider,
            'created_at': self.created_at,
            'device_trust_enabled': self.device_trust_enabled,
            'device_trust_provider': self.device_trust_provider,
            'discard_replays': self.discard_replays,
            'enforce_single_session': self.enforce_single_session,
            'idle_timeout': self.idle_timeout,
            'idle_timeout_enabled': self.idle_timeout_enabled,
            'kind': self.kind,
            'log_config': self.log_config,
            'log_local_encoder': self.log_local_encoder,
            'log_local_format': self.log_local_format,
            'log_local_storage': self.log_local_storage,
            'log_remote_encoder': self.log_remote_encoder,
            'log_socket_path': self.log_socket_path,
            'log_tcp_address': self.log_tcp_address,
            'loopback_range': self.loopback_range,
            'mfa_enabled': self.mfa_enabled,
            'mfa_provider': self.mfa_provider,
            'name': self.name,
            'public_key_pem': self.public_key_pem,
            'require_secret_store': self.require_secret_store,
            'saml_metadata_url': self.saml_metadata_url,
            'scim_provider': self.scim_provider,
            'sensitive_label': self.sensitive_label,
            'session_timeout': self.session_timeout,
            'session_timeout_enabled': self.session_timeout_enabled,
            'ssh_certificate_authority_public_key':
            self.ssh_certificate_authority_public_key,
            'ssh_certificate_authority_updated_at':
            self.ssh_certificate_authority_updated_at,
            'updated_at': self.updated_at,
            'websites_subdomain': self.websites_subdomain,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            auth_provider=d.get('auth_provider'),
            created_at=d.get('created_at'),
            device_trust_enabled=d.get('device_trust_enabled'),
            device_trust_provider=d.get('device_trust_provider'),
            discard_replays=d.get('discard_replays'),
            enforce_single_session=d.get('enforce_single_session'),
            idle_timeout=d.get('idle_timeout'),
            idle_timeout_enabled=d.get('idle_timeout_enabled'),
            kind=d.get('kind'),
            log_config=d.get('log_config'),
            log_local_encoder=d.get('log_local_encoder'),
            log_local_format=d.get('log_local_format'),
            log_local_storage=d.get('log_local_storage'),
            log_remote_encoder=d.get('log_remote_encoder'),
            log_socket_path=d.get('log_socket_path'),
            log_tcp_address=d.get('log_tcp_address'),
            loopback_range=d.get('loopback_range'),
            mfa_enabled=d.get('mfa_enabled'),
            mfa_provider=d.get('mfa_provider'),
            name=d.get('name'),
            public_key_pem=d.get('public_key_pem'),
            require_secret_store=d.get('require_secret_store'),
            saml_metadata_url=d.get('saml_metadata_url'),
            scim_provider=d.get('scim_provider'),
            sensitive_label=d.get('sensitive_label'),
            session_timeout=d.get('session_timeout'),
            session_timeout_enabled=d.get('session_timeout_enabled'),
            ssh_certificate_authority_public_key=d.get(
                'ssh_certificate_authority_public_key'),
            ssh_certificate_authority_updated_at=d.get(
                'ssh_certificate_authority_updated_at'),
            updated_at=d.get('updated_at'),
            websites_subdomain=d.get('websites_subdomain'),
        )


class OrganizationHistoryRecord:
    '''
         OrganizationHistoryRecord records the state of an Organization at a given point in time,
     where every change to an Organization produces an OrganizationHistoryRecord.
    '''
    __slots__ = [
        'activity_id',
        'organization',
        'timestamp',
    ]

    def __init__(
        self,
        activity_id=None,
        organization=None,
        timestamp=None,
    ):
        self.activity_id = activity_id if activity_id is not None else ''
        '''
         The unique identifier of the Activity that produced this change to the Organization.
         May be empty for some system-initiated organization updates.
        '''
        self.organization = organization if organization is not None else None
        '''
         The complete Organization state at this time.
        '''
        self.timestamp = timestamp if timestamp is not None else None
        '''
         The time at which the Organization state was recorded.
        '''

    def __repr__(self):
        return '<sdm.OrganizationHistoryRecord ' + \
            'activity_id: ' + repr(self.activity_id) + ' ' +\
            'organization: ' + repr(self.organization) + ' ' +\
            'timestamp: ' + repr(self.timestamp) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'activity_id': self.activity_id,
            'organization': self.organization,
            'timestamp': self.timestamp,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            activity_id=d.get('activity_id'),
            organization=d.get('organization'),
            timestamp=d.get('timestamp'),
        )


class PeeringGroup:
    '''
         PeeringGroups are the building blocks used for explicit network topology making.
     They may be linked to other peering groups. Sets of PeeringGroupResource and PeeringGroupNode can be attached to a peering group.
    '''
    __slots__ = [
        'id',
        'name',
    ]

    def __init__(
        self,
        id=None,
        name=None,
    ):
        self.id = id if id is not None else ''
        '''
         Unique identifier of the PeeringGroup.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the PeeringGroup.
        '''

    def __repr__(self):
        return '<sdm.PeeringGroup ' + \
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'id': self.id,
            'name': self.name,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            id=d.get('id'),
            name=d.get('name'),
        )


class PeeringGroupCreateResponse:
    '''
         PeeringGroupCreateResponse reports how the PeeringGroup was created in the system.
    '''
    __slots__ = [
        'meta',
        'peering_group',
        'rate_limit',
    ]

    def __init__(
        self,
        meta=None,
        peering_group=None,
        rate_limit=None,
    ):
        self.meta = meta if meta is not None else None
        '''
         Reserved for future use.
        '''
        self.peering_group = peering_group if peering_group is not None else None
        '''
         The created PeeringGroup.
        '''
        self.rate_limit = rate_limit if rate_limit is not None else None
        '''
         Rate limit information.
        '''

    def __repr__(self):
        return '<sdm.PeeringGroupCreateResponse ' + \
            'meta: ' + repr(self.meta) + ' ' +\
            'peering_group: ' + repr(self.peering_group) + ' ' +\
            'rate_limit: ' + repr(self.rate_limit) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'meta': self.meta,
            'peering_group': self.peering_group,
            'rate_limit': self.rate_limit,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            meta=d.get('meta'),
            peering_group=d.get('peering_group'),
            rate_limit=d.get('rate_limit'),
        )


class PeeringGroupDeleteResponse:
    '''
         PeeringGroupDeleteResponse returns information about a PeeringGroup that was deleted.
    '''
    __slots__ = [
        'meta',
        'rate_limit',
    ]

    def __init__(
        self,
        meta=None,
        rate_limit=None,
    ):
        self.meta = meta if meta is not None else None
        '''
         Reserved for future use.
        '''
        self.rate_limit = rate_limit if rate_limit is not None else None
        '''
         Rate limit information.
        '''

    def __repr__(self):
        return '<sdm.PeeringGroupDeleteResponse ' + \
            'meta: ' + repr(self.meta) + ' ' +\
            'rate_limit: ' + repr(self.rate_limit) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'meta': self.meta,
            'rate_limit': self.rate_limit,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            meta=d.get('meta'),
            rate_limit=d.get('rate_limit'),
        )


class PeeringGroupGetResponse:
    '''
         PeeringGroupGetResponse returns a requested PeeringGroup.
    '''
    __slots__ = [
        'meta',
        'peering_group',
        'rate_limit',
    ]

    def __init__(
        self,
        meta=None,
        peering_group=None,
        rate_limit=None,
    ):
        self.meta = meta if meta is not None else None
        '''
         Reserved for future use.
        '''
        self.peering_group = peering_group if peering_group is not None else None
        '''
         The requested PeeringGroup.
        '''
        self.rate_limit = rate_limit if rate_limit is not None else None
        '''
         Rate limit information.
        '''

    def __repr__(self):
        return '<sdm.PeeringGroupGetResponse ' + \
            'meta: ' + repr(self.meta) + ' ' +\
            'peering_group: ' + repr(self.peering_group) + ' ' +\
            'rate_limit: ' + repr(self.rate_limit) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'meta': self.meta,
            'peering_group': self.peering_group,
            'rate_limit': self.rate_limit,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            meta=d.get('meta'),
            peering_group=d.get('peering_group'),
            rate_limit=d.get('rate_limit'),
        )


class PeeringGroupNode:
    '''
         PeeringGroupNode represents the attachment between a PeeringGroup and a Node.
    '''
    __slots__ = [
        'group_id',
        'id',
        'node_id',
    ]

    def __init__(
        self,
        group_id=None,
        id=None,
        node_id=None,
    ):
        self.group_id = group_id if group_id is not None else ''
        '''
         Peering Group ID to which the node will be attached to.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Attachment.
        '''
        self.node_id = node_id if node_id is not None else ''
        '''
         Node ID to be attached.
        '''

    def __repr__(self):
        return '<sdm.PeeringGroupNode ' + \
            'group_id: ' + repr(self.group_id) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'node_id: ' + repr(self.node_id) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'group_id': self.group_id,
            'id': self.id,
            'node_id': self.node_id,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            group_id=d.get('group_id'),
            id=d.get('id'),
            node_id=d.get('node_id'),
        )


class PeeringGroupNodeCreateResponse:
    '''
         PeeringGroupNodeCreateResponse reports how the PeeringGroupNode was created in the system.
    '''
    __slots__ = [
        'meta',
        'peering_group_node',
        'rate_limit',
    ]

    def __init__(
        self,
        meta=None,
        peering_group_node=None,
        rate_limit=None,
    ):
        self.meta = meta if meta is not None else None
        '''
         Reserved for future use.
        '''
        self.peering_group_node = peering_group_node if peering_group_node is not None else None
        '''
         The created PeeringGroupNode.
        '''
        self.rate_limit = rate_limit if rate_limit is not None else None
        '''
         Rate limit information.
        '''

    def __repr__(self):
        return '<sdm.PeeringGroupNodeCreateResponse ' + \
            'meta: ' + repr(self.meta) + ' ' +\
            'peering_group_node: ' + repr(self.peering_group_node) + ' ' +\
            'rate_limit: ' + repr(self.rate_limit) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'meta': self.meta,
            'peering_group_node': self.peering_group_node,
            'rate_limit': self.rate_limit,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            meta=d.get('meta'),
            peering_group_node=d.get('peering_group_node'),
            rate_limit=d.get('rate_limit'),
        )


class PeeringGroupNodeDeleteResponse:
    '''
         PeeringGroupNodeDeleteResponse returns information about a PeeringGroupNode that was deleted.
    '''
    __slots__ = [
        'meta',
        'rate_limit',
    ]

    def __init__(
        self,
        meta=None,
        rate_limit=None,
    ):
        self.meta = meta if meta is not None else None
        '''
         Reserved for future use.
        '''
        self.rate_limit = rate_limit if rate_limit is not None else None
        '''
         Rate limit information.
        '''

    def __repr__(self):
        return '<sdm.PeeringGroupNodeDeleteResponse ' + \
            'meta: ' + repr(self.meta) + ' ' +\
            'rate_limit: ' + repr(self.rate_limit) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'meta': self.meta,
            'rate_limit': self.rate_limit,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            meta=d.get('meta'),
            rate_limit=d.get('rate_limit'),
        )


class PeeringGroupNodeGetResponse:
    '''
         PeeringGroupNodeGetResponse returns a requested PeeringGroupNode.
    '''
    __slots__ = [
        'meta',
        'peering_group_node',
        'rate_limit',
    ]

    def __init__(
        self,
        meta=None,
        peering_group_node=None,
        rate_limit=None,
    ):
        self.meta = meta if meta is not None else None
        '''
         Reserved for future use.
        '''
        self.peering_group_node = peering_group_node if peering_group_node is not None else None
        '''
         The requested PeeringGroupNode.
        '''
        self.rate_limit = rate_limit if rate_limit is not None else None
        '''
         Rate limit information.
        '''

    def __repr__(self):
        return '<sdm.PeeringGroupNodeGetResponse ' + \
            'meta: ' + repr(self.meta) + ' ' +\
            'peering_group_node: ' + repr(self.peering_group_node) + ' ' +\
            'rate_limit: ' + repr(self.rate_limit) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'meta': self.meta,
            'peering_group_node': self.peering_group_node,
            'rate_limit': self.rate_limit,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            meta=d.get('meta'),
            peering_group_node=d.get('peering_group_node'),
            rate_limit=d.get('rate_limit'),
        )


class PeeringGroupPeer:
    '''
         PeeringGroupPeer represents the link between two PeeringGroups
    '''
    __slots__ = [
        'group_id',
        'id',
        'peers_with_group_id',
    ]

    def __init__(
        self,
        group_id=None,
        id=None,
        peers_with_group_id=None,
    ):
        self.group_id = group_id if group_id is not None else ''
        '''
         Group ID from which the link will originate.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Attachment.
        '''
        self.peers_with_group_id = peers_with_group_id if peers_with_group_id is not None else ''
        '''
         Peering Group ID to which Group ID will link.
        '''

    def __repr__(self):
        return '<sdm.PeeringGroupPeer ' + \
            'group_id: ' + repr(self.group_id) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'peers_with_group_id: ' + repr(self.peers_with_group_id) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'group_id': self.group_id,
            'id': self.id,
            'peers_with_group_id': self.peers_with_group_id,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            group_id=d.get('group_id'),
            id=d.get('id'),
            peers_with_group_id=d.get('peers_with_group_id'),
        )


class PeeringGroupPeerCreateResponse:
    '''
         PeeringGroupPeerCreateResponse reports how the PeeringGroupPeer was created in the system.
    '''
    __slots__ = [
        'meta',
        'peering_group_peer',
        'rate_limit',
    ]

    def __init__(
        self,
        meta=None,
        peering_group_peer=None,
        rate_limit=None,
    ):
        self.meta = meta if meta is not None else None
        '''
         Reserved for future use.
        '''
        self.peering_group_peer = peering_group_peer if peering_group_peer is not None else None
        '''
         The created PeeringGroupPeer.
        '''
        self.rate_limit = rate_limit if rate_limit is not None else None
        '''
         Rate limit information.
        '''

    def __repr__(self):
        return '<sdm.PeeringGroupPeerCreateResponse ' + \
            'meta: ' + repr(self.meta) + ' ' +\
            'peering_group_peer: ' + repr(self.peering_group_peer) + ' ' +\
            'rate_limit: ' + repr(self.rate_limit) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'meta': self.meta,
            'peering_group_peer': self.peering_group_peer,
            'rate_limit': self.rate_limit,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            meta=d.get('meta'),
            peering_group_peer=d.get('peering_group_peer'),
            rate_limit=d.get('rate_limit'),
        )


class PeeringGroupPeerDeleteResponse:
    '''
         PeeringGroupPeerDeleteResponse returns information about a PeeringGroupPeer that was deleted.
    '''
    __slots__ = [
        'meta',
        'rate_limit',
    ]

    def __init__(
        self,
        meta=None,
        rate_limit=None,
    ):
        self.meta = meta if meta is not None else None
        '''
         Reserved for future use.
        '''
        self.rate_limit = rate_limit if rate_limit is not None else None
        '''
         Rate limit information.
        '''

    def __repr__(self):
        return '<sdm.PeeringGroupPeerDeleteResponse ' + \
            'meta: ' + repr(self.meta) + ' ' +\
            'rate_limit: ' + repr(self.rate_limit) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'meta': self.meta,
            'rate_limit': self.rate_limit,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            meta=d.get('meta'),
            rate_limit=d.get('rate_limit'),
        )


class PeeringGroupPeerGetResponse:
    '''
         PeeringGroupPeerGetResponse returns a requested PeeringGroupPeer.
    '''
    __slots__ = [
        'meta',
        'peering_group_peer',
        'rate_limit',
    ]

    def __init__(
        self,
        meta=None,
        peering_group_peer=None,
        rate_limit=None,
    ):
        self.meta = meta if meta is not None else None
        '''
         Reserved for future use.
        '''
        self.peering_group_peer = peering_group_peer if peering_group_peer is not None else None
        '''
         The requested PeeringGroupPeer.
        '''
        self.rate_limit = rate_limit if rate_limit is not None else None
        '''
         Rate limit information.
        '''

    def __repr__(self):
        return '<sdm.PeeringGroupPeerGetResponse ' + \
            'meta: ' + repr(self.meta) + ' ' +\
            'peering_group_peer: ' + repr(self.peering_group_peer) + ' ' +\
            'rate_limit: ' + repr(self.rate_limit) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'meta': self.meta,
            'peering_group_peer': self.peering_group_peer,
            'rate_limit': self.rate_limit,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            meta=d.get('meta'),
            peering_group_peer=d.get('peering_group_peer'),
            rate_limit=d.get('rate_limit'),
        )


class PeeringGroupResource:
    '''
         PeeringGroupResource represents the attachment between a PeeringGroup and a Resource.
    '''
    __slots__ = [
        'group_id',
        'id',
        'resource_id',
    ]

    def __init__(
        self,
        group_id=None,
        id=None,
        resource_id=None,
    ):
        self.group_id = group_id if group_id is not None else ''
        '''
         Peering Group ID to which the resource will be attached to.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Attachment.
        '''
        self.resource_id = resource_id if resource_id is not None else ''
        '''
         Resource ID to be attached.
        '''

    def __repr__(self):
        return '<sdm.PeeringGroupResource ' + \
            'group_id: ' + repr(self.group_id) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'resource_id: ' + repr(self.resource_id) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'group_id': self.group_id,
            'id': self.id,
            'resource_id': self.resource_id,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            group_id=d.get('group_id'),
            id=d.get('id'),
            resource_id=d.get('resource_id'),
        )


class PeeringGroupResourceCreateResponse:
    '''
         PeeringGroupResourceCreateResponse reports how the attachment was created in the system.
    '''
    __slots__ = [
        'meta',
        'peering_group_resource',
        'rate_limit',
    ]

    def __init__(
        self,
        meta=None,
        peering_group_resource=None,
        rate_limit=None,
    ):
        self.meta = meta if meta is not None else None
        '''
         Reserved for future use.
        '''
        self.peering_group_resource = peering_group_resource if peering_group_resource is not None else None
        '''
         The created PeeringGroupResource.
        '''
        self.rate_limit = rate_limit if rate_limit is not None else None
        '''
         Rate limit information.
        '''

    def __repr__(self):
        return '<sdm.PeeringGroupResourceCreateResponse ' + \
            'meta: ' + repr(self.meta) + ' ' +\
            'peering_group_resource: ' + repr(self.peering_group_resource) + ' ' +\
            'rate_limit: ' + repr(self.rate_limit) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'meta': self.meta,
            'peering_group_resource': self.peering_group_resource,
            'rate_limit': self.rate_limit,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            meta=d.get('meta'),
            peering_group_resource=d.get('peering_group_resource'),
            rate_limit=d.get('rate_limit'),
        )


class PeeringGroupResourceDeleteResponse:
    '''
         PeeringGroupResourceDeleteResponse returns information about a PeeringGroupResource that was deleted.
    '''
    __slots__ = [
        'meta',
        'rate_limit',
    ]

    def __init__(
        self,
        meta=None,
        rate_limit=None,
    ):
        self.meta = meta if meta is not None else None
        '''
         Reserved for future use.
        '''
        self.rate_limit = rate_limit if rate_limit is not None else None
        '''
         Rate limit information.
        '''

    def __repr__(self):
        return '<sdm.PeeringGroupResourceDeleteResponse ' + \
            'meta: ' + repr(self.meta) + ' ' +\
            'rate_limit: ' + repr(self.rate_limit) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'meta': self.meta,
            'rate_limit': self.rate_limit,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            meta=d.get('meta'),
            rate_limit=d.get('rate_limit'),
        )


class PeeringGroupResourceGetResponse:
    '''
         PeeringGroupResourceGetResponse returns a requested PeeringGroupResource.
    '''
    __slots__ = [
        'meta',
        'peering_group_resource',
        'rate_limit',
    ]

    def __init__(
        self,
        meta=None,
        peering_group_resource=None,
        rate_limit=None,
    ):
        self.meta = meta if meta is not None else None
        '''
         Reserved for future use.
        '''
        self.peering_group_resource = peering_group_resource if peering_group_resource is not None else None
        '''
         The requested PeeringGroupResource.
        '''
        self.rate_limit = rate_limit if rate_limit is not None else None
        '''
         Rate limit information.
        '''

    def __repr__(self):
        return '<sdm.PeeringGroupResourceGetResponse ' + \
            'meta: ' + repr(self.meta) + ' ' +\
            'peering_group_resource: ' + repr(self.peering_group_resource) + ' ' +\
            'rate_limit: ' + repr(self.rate_limit) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'meta': self.meta,
            'peering_group_resource': self.peering_group_resource,
            'rate_limit': self.rate_limit,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            meta=d.get('meta'),
            peering_group_resource=d.get('peering_group_resource'),
            rate_limit=d.get('rate_limit'),
        )


class Policy:
    '''
         Policy is a collection of one or more statements that enforce fine-grained access control
     for the users of an organization.
    '''
    __slots__ = [
        'description',
        'id',
        'name',
        'policy',
    ]

    def __init__(
        self,
        description=None,
        id=None,
        name=None,
        policy=None,
    ):
        self.description = description if description is not None else ''
        '''
         Optional description of the Policy.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Policy.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Policy.
        '''
        self.policy = policy if policy is not None else ''
        '''
         The content of the Policy, in Cedar policy language.
        '''

    def __repr__(self):
        return '<sdm.Policy ' + \
            'description: ' + repr(self.description) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'policy: ' + repr(self.policy) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'description': self.description,
            'id': self.id,
            'name': self.name,
            'policy': self.policy,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            description=d.get('description'),
            id=d.get('id'),
            name=d.get('name'),
            policy=d.get('policy'),
        )


class PolicyCreateResponse:
    '''
         PolicyCreateResponse reports how the Policy was created in the system.
    '''
    __slots__ = [
        'policy',
        'rate_limit',
    ]

    def __init__(
        self,
        policy=None,
        rate_limit=None,
    ):
        self.policy = policy if policy is not None else None
        '''
         The created Policy.
        '''
        self.rate_limit = rate_limit if rate_limit is not None else None
        '''
         Rate limit information.
        '''

    def __repr__(self):
        return '<sdm.PolicyCreateResponse ' + \
            'policy: ' + repr(self.policy) + ' ' +\
            'rate_limit: ' + repr(self.rate_limit) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'policy': self.policy,
            'rate_limit': self.rate_limit,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            policy=d.get('policy'),
            rate_limit=d.get('rate_limit'),
        )


class PolicyDeleteResponse:
    '''
         PolicyDeleteResponse returns information about a Policy that was deleted.
    '''
    __slots__ = [
        'rate_limit',
    ]

    def __init__(
        self,
        rate_limit=None,
    ):
        self.rate_limit = rate_limit if rate_limit is not None else None
        '''
         Rate limit information.
        '''

    def __repr__(self):
        return '<sdm.PolicyDeleteResponse ' + \
            'rate_limit: ' + repr(self.rate_limit) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'rate_limit': self.rate_limit,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(rate_limit=d.get('rate_limit'), )


class PolicyGetResponse:
    '''
         PolicyGetResponse returns a requested Policy.
    '''
    __slots__ = [
        'meta',
        'policy',
        'rate_limit',
    ]

    def __init__(
        self,
        meta=None,
        policy=None,
        rate_limit=None,
    ):
        self.meta = meta if meta is not None else None
        '''
         Reserved for future use.
        '''
        self.policy = policy if policy is not None else None
        '''
         The requested Policy.
        '''
        self.rate_limit = rate_limit if rate_limit is not None else None
        '''
         Rate limit information.
        '''

    def __repr__(self):
        return '<sdm.PolicyGetResponse ' + \
            'meta: ' + repr(self.meta) + ' ' +\
            'policy: ' + repr(self.policy) + ' ' +\
            'rate_limit: ' + repr(self.rate_limit) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'meta': self.meta,
            'policy': self.policy,
            'rate_limit': self.rate_limit,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            meta=d.get('meta'),
            policy=d.get('policy'),
            rate_limit=d.get('rate_limit'),
        )


class PolicyHistory:
    '''
         PolicyHistory records the state of a Policy at a given point in time,
     where every change (create, update and delete) to a Policy produces a
     PolicyHistory record.
    '''
    __slots__ = [
        'activity_id',
        'deleted_at',
        'policy',
        'timestamp',
    ]

    def __init__(
        self,
        activity_id=None,
        deleted_at=None,
        policy=None,
        timestamp=None,
    ):
        self.activity_id = activity_id if activity_id is not None else ''
        '''
         The unique identifier of the Activity that produced this change to the Policy.
         May be empty for some system-initiated updates.
        '''
        self.deleted_at = deleted_at if deleted_at is not None else None
        '''
         If this Policy was deleted, the time it was deleted.
        '''
        self.policy = policy if policy is not None else None
        '''
         The complete Policy state at this time.
        '''
        self.timestamp = timestamp if timestamp is not None else None
        '''
         The time at which the Policy state was recorded.
        '''

    def __repr__(self):
        return '<sdm.PolicyHistory ' + \
            'activity_id: ' + repr(self.activity_id) + ' ' +\
            'deleted_at: ' + repr(self.deleted_at) + ' ' +\
            'policy: ' + repr(self.policy) + ' ' +\
            'timestamp: ' + repr(self.timestamp) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'activity_id': self.activity_id,
            'deleted_at': self.deleted_at,
            'policy': self.policy,
            'timestamp': self.timestamp,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            activity_id=d.get('activity_id'),
            deleted_at=d.get('deleted_at'),
            policy=d.get('policy'),
            timestamp=d.get('timestamp'),
        )


class PolicyListResponse:
    '''
         PolicyListResponse returns a list of Policy records that meet
     the criteria of a PolicyListRequest.
    '''
    __slots__ = [
        'rate_limit',
    ]

    def __init__(
        self,
        rate_limit=None,
    ):
        self.rate_limit = rate_limit if rate_limit is not None else None
        '''
         Rate limit information.
        '''

    def __repr__(self):
        return '<sdm.PolicyListResponse ' + \
            'rate_limit: ' + repr(self.rate_limit) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'rate_limit': self.rate_limit,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(rate_limit=d.get('rate_limit'), )


class PolicyUpdateResponse:
    '''
         PolicyUpdateResponse returns the fields of a Policy after it has been updated by
     a PolicyUpdateRequest.
    '''
    __slots__ = [
        'policy',
        'rate_limit',
    ]

    def __init__(
        self,
        policy=None,
        rate_limit=None,
    ):
        self.policy = policy if policy is not None else None
        '''
         The updated Policy.
        '''
        self.rate_limit = rate_limit if rate_limit is not None else None
        '''
         Rate limit information.
        '''

    def __repr__(self):
        return '<sdm.PolicyUpdateResponse ' + \
            'policy: ' + repr(self.policy) + ' ' +\
            'rate_limit: ' + repr(self.rate_limit) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'policy': self.policy,
            'rate_limit': self.rate_limit,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            policy=d.get('policy'),
            rate_limit=d.get('rate_limit'),
        )


class Postgres:
    __slots__ = [
        'bind_interface',
        'database',
        'egress_filter',
        'healthy',
        'hostname',
        'id',
        'name',
        'override_database',
        'password',
        'port',
        'port_override',
        'proxy_cluster_id',
        'secret_store_id',
        'subdomain',
        'tags',
        'username',
    ]

    def __init__(
        self,
        bind_interface=None,
        database=None,
        egress_filter=None,
        healthy=None,
        hostname=None,
        id=None,
        name=None,
        override_database=None,
        password=None,
        port=None,
        port_override=None,
        proxy_cluster_id=None,
        secret_store_id=None,
        subdomain=None,
        tags=None,
        username=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided and may also be set to one of the ResourceIPAllocationMode constants to select between VNM, loopback, or default allocation.
        '''
        self.database = database if database is not None else ''
        '''
         The initial database to connect to. This setting does not by itself prevent switching to another database after connecting.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        '''
         The host to dial to initiate a connection from the egress node to this resource.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.override_database = override_database if override_database is not None else False
        '''
         If set, the database configured cannot be changed by users. This setting is not recommended for most use cases, as some clients will insist their database has changed when it has not, leading to user confusion.
        '''
        self.password = password if password is not None else ''
        '''
         The password to authenticate with.
        '''
        self.port = port if port is not None else 0
        '''
         The port to dial to initiate a connection from the egress node to this resource.
        '''
        self.port_override = port_override if port_override is not None else 0
        '''
         The local port used by clients to connect to this resource. It is automatically generated if not provided on create and may be re-generated on update by specifying a value of -1.
        '''
        self.proxy_cluster_id = proxy_cluster_id if proxy_cluster_id is not None else ''
        '''
         ID of the proxy cluster for this resource, if any.
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         DNS subdomain through which this resource may be accessed on clients.  (e.g. "app-prod1" allows the resource to be accessed at "app-prod1.your-org-name.sdm-proxy-domain"). Only applicable to HTTP-based resources or resources using virtual networking mode.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.username = username if username is not None else ''
        '''
         The username to authenticate with.
        '''

    def __repr__(self):
        return '<sdm.Postgres ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'database: ' + repr(self.database) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'override_database: ' + repr(self.override_database) + ' ' +\
            'password: ' + repr(self.password) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'proxy_cluster_id: ' + repr(self.proxy_cluster_id) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'username: ' + repr(self.username) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'database': self.database,
            'egress_filter': self.egress_filter,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'name': self.name,
            'override_database': self.override_database,
            'password': self.password,
            'port': self.port,
            'port_override': self.port_override,
            'proxy_cluster_id': self.proxy_cluster_id,
            'secret_store_id': self.secret_store_id,
            'subdomain': self.subdomain,
            'tags': self.tags,
            'username': self.username,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            database=d.get('database'),
            egress_filter=d.get('egress_filter'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            name=d.get('name'),
            override_database=d.get('override_database'),
            password=d.get('password'),
            port=d.get('port'),
            port_override=d.get('port_override'),
            proxy_cluster_id=d.get('proxy_cluster_id'),
            secret_store_id=d.get('secret_store_id'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
            username=d.get('username'),
        )


class PostgresEngine:
    '''
    PostgresEngine is currently unstable, and its API may change, or it may be removed,
    without a major version bump.
    '''
    __slots__ = [
        'after_read_ttl',
        'database',
        'hostname',
        'id',
        'key_rotation_interval_days',
        'name',
        'password',
        'policy',
        'port',
        'public_key',
        'secret_store_id',
        'secret_store_root_path',
        'tags',
        'tls',
        'ttl',
        'username',
    ]

    def __init__(
        self,
        after_read_ttl=None,
        database=None,
        hostname=None,
        id=None,
        key_rotation_interval_days=None,
        name=None,
        password=None,
        policy=None,
        port=None,
        public_key=None,
        secret_store_id=None,
        secret_store_root_path=None,
        tags=None,
        tls=None,
        ttl=None,
        username=None,
    ):
        self.after_read_ttl = after_read_ttl if after_read_ttl is not None else None
        '''
         The default time-to-live duration of the password after it's read. Once the ttl has passed, a password will be rotated.
        '''
        self.database = database if database is not None else ''
        '''
         Database is the database to verify credential against.
        '''
        self.hostname = hostname if hostname is not None else ''
        '''
         Hostname is the hostname or IP address of the Postgres server.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Secret Engine.
        '''
        self.key_rotation_interval_days = key_rotation_interval_days if key_rotation_interval_days is not None else 0
        '''
         An interval of public/private key rotation for secret engine in days
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Secret Engine.
        '''
        self.password = password if password is not None else ''
        '''
         Password is the password to connect to the Postgres server.
        '''
        self.policy = policy if policy is not None else None
        '''
         Policy for password creation
        '''
        self.port = port if port is not None else 0
        '''
         Port is the port number of the Postgres server.
        '''
        self.public_key = public_key if public_key is not None else b''
        '''
         Public key linked with a secret engine
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         Backing secret store identifier
        '''
        self.secret_store_root_path = secret_store_root_path if secret_store_root_path is not None else ''
        '''
         Backing Secret Store root path where managed secrets are going to be stored
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.tls = tls if tls is not None else False
        '''
         TLS enables TLS/SSL when connecting to the Postgres server.
        '''
        self.ttl = ttl if ttl is not None else None
        '''
         The default password time-to-live duration. Once the ttl has passed, a password will be rotated the next time it's requested.
        '''
        self.username = username if username is not None else ''
        '''
         Username is the username to connect to the Postgres server.
        '''

    def __repr__(self):
        return '<sdm.PostgresEngine ' + \
            'after_read_ttl: ' + repr(self.after_read_ttl) + ' ' +\
            'database: ' + repr(self.database) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'key_rotation_interval_days: ' + repr(self.key_rotation_interval_days) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'password: ' + repr(self.password) + ' ' +\
            'policy: ' + repr(self.policy) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'public_key: ' + repr(self.public_key) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'secret_store_root_path: ' + repr(self.secret_store_root_path) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'tls: ' + repr(self.tls) + ' ' +\
            'ttl: ' + repr(self.ttl) + ' ' +\
            'username: ' + repr(self.username) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'after_read_ttl': self.after_read_ttl,
            'database': self.database,
            'hostname': self.hostname,
            'id': self.id,
            'key_rotation_interval_days': self.key_rotation_interval_days,
            'name': self.name,
            'password': self.password,
            'policy': self.policy,
            'port': self.port,
            'public_key': self.public_key,
            'secret_store_id': self.secret_store_id,
            'secret_store_root_path': self.secret_store_root_path,
            'tags': self.tags,
            'tls': self.tls,
            'ttl': self.ttl,
            'username': self.username,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            after_read_ttl=d.get('after_read_ttl'),
            database=d.get('database'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            key_rotation_interval_days=d.get('key_rotation_interval_days'),
            name=d.get('name'),
            password=d.get('password'),
            policy=d.get('policy'),
            port=d.get('port'),
            public_key=d.get('public_key'),
            secret_store_id=d.get('secret_store_id'),
            secret_store_root_path=d.get('secret_store_root_path'),
            tags=d.get('tags'),
            tls=d.get('tls'),
            ttl=d.get('ttl'),
            username=d.get('username'),
        )


class Presto:
    __slots__ = [
        'bind_interface',
        'database',
        'egress_filter',
        'healthy',
        'hostname',
        'id',
        'name',
        'password',
        'port',
        'port_override',
        'proxy_cluster_id',
        'secret_store_id',
        'subdomain',
        'tags',
        'tls_required',
        'username',
    ]

    def __init__(
        self,
        bind_interface=None,
        database=None,
        egress_filter=None,
        healthy=None,
        hostname=None,
        id=None,
        name=None,
        password=None,
        port=None,
        port_override=None,
        proxy_cluster_id=None,
        secret_store_id=None,
        subdomain=None,
        tags=None,
        tls_required=None,
        username=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided and may also be set to one of the ResourceIPAllocationMode constants to select between VNM, loopback, or default allocation.
        '''
        self.database = database if database is not None else ''
        '''
         The initial database to connect to. This setting does not by itself prevent switching to another database after connecting.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        '''
         The host to dial to initiate a connection from the egress node to this resource.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.password = password if password is not None else ''
        '''
         The password to authenticate with.
        '''
        self.port = port if port is not None else 0
        '''
         The port to dial to initiate a connection from the egress node to this resource.
        '''
        self.port_override = port_override if port_override is not None else 0
        '''
         The local port used by clients to connect to this resource. It is automatically generated if not provided on create and may be re-generated on update by specifying a value of -1.
        '''
        self.proxy_cluster_id = proxy_cluster_id if proxy_cluster_id is not None else ''
        '''
         ID of the proxy cluster for this resource, if any.
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         DNS subdomain through which this resource may be accessed on clients.  (e.g. "app-prod1" allows the resource to be accessed at "app-prod1.your-org-name.sdm-proxy-domain"). Only applicable to HTTP-based resources or resources using virtual networking mode.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.tls_required = tls_required if tls_required is not None else False
        '''
         If set, TLS must be used to connect to this resource.
        '''
        self.username = username if username is not None else ''
        '''
         The username to authenticate with.
        '''

    def __repr__(self):
        return '<sdm.Presto ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'database: ' + repr(self.database) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'password: ' + repr(self.password) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'proxy_cluster_id: ' + repr(self.proxy_cluster_id) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'tls_required: ' + repr(self.tls_required) + ' ' +\
            'username: ' + repr(self.username) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'database': self.database,
            'egress_filter': self.egress_filter,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'name': self.name,
            'password': self.password,
            'port': self.port,
            'port_override': self.port_override,
            'proxy_cluster_id': self.proxy_cluster_id,
            'secret_store_id': self.secret_store_id,
            'subdomain': self.subdomain,
            'tags': self.tags,
            'tls_required': self.tls_required,
            'username': self.username,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            database=d.get('database'),
            egress_filter=d.get('egress_filter'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            name=d.get('name'),
            password=d.get('password'),
            port=d.get('port'),
            port_override=d.get('port_override'),
            proxy_cluster_id=d.get('proxy_cluster_id'),
            secret_store_id=d.get('secret_store_id'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
            tls_required=d.get('tls_required'),
            username=d.get('username'),
        )


class ProxyCluster:
    '''
         ProxyCluster represents a cluster of StrongDM proxies.
    '''
    __slots__ = [
        'address',
        'id',
        'maintenance_windows',
        'name',
        'tags',
    ]

    def __init__(
        self,
        address=None,
        id=None,
        maintenance_windows=None,
        name=None,
        tags=None,
    ):
        self.address = address if address is not None else ''
        '''
         The public hostname/port tuple at which the proxy cluster will be
         accessible to clients.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Proxy Cluster.
        '''
        self.maintenance_windows = maintenance_windows if maintenance_windows is not None else []
        '''
         Maintenance Windows define when this node is allowed to restart. If a node
         is requested to restart, it will check each window to determine if any of
         them permit it to restart, and if any do, it will. This check is repeated
         per window until the restart is successfully completed.
         
         If not set here, may be set on the command line or via an environment variable
         on the process itself; any server setting will take precedence over local
         settings. This setting is ineffective for nodes below version 38.44.0.
         
         If this setting is not applied via this remote configuration or via local
         configuration, the default setting is used: always allow restarts if serving
         no connections, and allow a restart even if serving connections between 7-8 UTC, any day.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the proxy cluster. Names must
         include only letters, numbers, and hyphens (no spaces, underscores, or
         other special characters). Generated if not provided on create.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''

    def __repr__(self):
        return '<sdm.ProxyCluster ' + \
            'address: ' + repr(self.address) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'maintenance_windows: ' + repr(self.maintenance_windows) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'address': self.address,
            'id': self.id,
            'maintenance_windows': self.maintenance_windows,
            'name': self.name,
            'tags': self.tags,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            address=d.get('address'),
            id=d.get('id'),
            maintenance_windows=d.get('maintenance_windows'),
            name=d.get('name'),
            tags=d.get('tags'),
        )


class ProxyClusterKey:
    '''
         Proxy Cluster Keys are authentication keys for all proxies within a cluster.
     The proxies within a cluster share the same key. One cluster can have
     multiple keys in order to facilitate key rotation.
    '''
    __slots__ = [
        'created_at',
        'id',
        'last_used_at',
        'proxy_cluster_id',
    ]

    def __init__(
        self,
        created_at=None,
        id=None,
        last_used_at=None,
        proxy_cluster_id=None,
    ):
        self.created_at = created_at if created_at is not None else None
        '''
         The timestamp when this key was created.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Relay.
        '''
        self.last_used_at = last_used_at if last_used_at is not None else None
        '''
         The timestamp when this key was last used, if at all.
        '''
        self.proxy_cluster_id = proxy_cluster_id if proxy_cluster_id is not None else ''
        '''
         The ID of the proxy cluster which this key authenticates to.
        '''

    def __repr__(self):
        return '<sdm.ProxyClusterKey ' + \
            'created_at: ' + repr(self.created_at) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'last_used_at: ' + repr(self.last_used_at) + ' ' +\
            'proxy_cluster_id: ' + repr(self.proxy_cluster_id) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'created_at': self.created_at,
            'id': self.id,
            'last_used_at': self.last_used_at,
            'proxy_cluster_id': self.proxy_cluster_id,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            created_at=d.get('created_at'),
            id=d.get('id'),
            last_used_at=d.get('last_used_at'),
            proxy_cluster_id=d.get('proxy_cluster_id'),
        )


class ProxyClusterKeyCreateResponse:
    '''
         ProxyClusterKeyCreateResponse reports how the ProxyClusterKeys were created in the system.
    '''
    __slots__ = [
        'meta',
        'proxy_cluster_key',
        'rate_limit',
        'secret_key',
    ]

    def __init__(
        self,
        meta=None,
        proxy_cluster_key=None,
        rate_limit=None,
        secret_key=None,
    ):
        self.meta = meta if meta is not None else None
        '''
         Reserved for future use.
        '''
        self.proxy_cluster_key = proxy_cluster_key if proxy_cluster_key is not None else None
        '''
         The created ProxyClusterKey.
        '''
        self.rate_limit = rate_limit if rate_limit is not None else None
        '''
         Rate limit information.
        '''
        self.secret_key = secret_key if secret_key is not None else ''
        '''
         The secret key component of this key. It must be saved upon creation
         because it will not be available for retrieval later.
        '''

    def __repr__(self):
        return '<sdm.ProxyClusterKeyCreateResponse ' + \
            'meta: ' + repr(self.meta) + ' ' +\
            'proxy_cluster_key: ' + repr(self.proxy_cluster_key) + ' ' +\
            'rate_limit: ' + repr(self.rate_limit) + ' ' +\
            'secret_key: ' + repr(self.secret_key) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'meta': self.meta,
            'proxy_cluster_key': self.proxy_cluster_key,
            'rate_limit': self.rate_limit,
            'secret_key': self.secret_key,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            meta=d.get('meta'),
            proxy_cluster_key=d.get('proxy_cluster_key'),
            rate_limit=d.get('rate_limit'),
            secret_key=d.get('secret_key'),
        )


class ProxyClusterKeyDeleteResponse:
    '''
         ProxyClusterKeyDeleteResponse returns information about a ProxyClusterKey that was deleted.
    '''
    __slots__ = [
        'meta',
        'rate_limit',
    ]

    def __init__(
        self,
        meta=None,
        rate_limit=None,
    ):
        self.meta = meta if meta is not None else None
        '''
         Reserved for future use.
        '''
        self.rate_limit = rate_limit if rate_limit is not None else None
        '''
         Rate limit information.
        '''

    def __repr__(self):
        return '<sdm.ProxyClusterKeyDeleteResponse ' + \
            'meta: ' + repr(self.meta) + ' ' +\
            'rate_limit: ' + repr(self.rate_limit) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'meta': self.meta,
            'rate_limit': self.rate_limit,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            meta=d.get('meta'),
            rate_limit=d.get('rate_limit'),
        )


class ProxyClusterKeyGetResponse:
    '''
         ProxyClusterKeyGetResponse returns a requested ProxyClusterKey.
    '''
    __slots__ = [
        'meta',
        'proxy_cluster_key',
        'rate_limit',
    ]

    def __init__(
        self,
        meta=None,
        proxy_cluster_key=None,
        rate_limit=None,
    ):
        self.meta = meta if meta is not None else None
        '''
         Reserved for future use.
        '''
        self.proxy_cluster_key = proxy_cluster_key if proxy_cluster_key is not None else None
        '''
         The requested ProxyClusterKey.
        '''
        self.rate_limit = rate_limit if rate_limit is not None else None
        '''
         Rate limit information.
        '''

    def __repr__(self):
        return '<sdm.ProxyClusterKeyGetResponse ' + \
            'meta: ' + repr(self.meta) + ' ' +\
            'proxy_cluster_key: ' + repr(self.proxy_cluster_key) + ' ' +\
            'rate_limit: ' + repr(self.rate_limit) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'meta': self.meta,
            'proxy_cluster_key': self.proxy_cluster_key,
            'rate_limit': self.rate_limit,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            meta=d.get('meta'),
            proxy_cluster_key=d.get('proxy_cluster_key'),
            rate_limit=d.get('rate_limit'),
        )


class Query:
    '''
         A Query is a record of a single client request to a resource, such as a SQL query.
     Longer-running queries including long-running SSH commands and SSH, RDP, or Kubernetes
     interactive sessions will return two Query records with the same identifier, one record
     at the start of the query and a second record upon the completion of the query with
     additional detail.
    '''
    __slots__ = [
        'account_email',
        'account_first_name',
        'account_id',
        'account_last_name',
        'account_tags',
        'authzjson',
        'capture',
        'client_ip',
        'completed_at',
        'duration',
        'egress_node_id',
        'encrypted',
        'id',
        'identity_alias_username',
        'metadata_json',
        'query_body',
        'query_category',
        'query_hash',
        'query_key',
        'record_count',
        'remote_identity_username',
        'replayable',
        'resource_id',
        'resource_name',
        'resource_tags',
        'resource_type',
        'source_ip',
        'target',
        'timestamp',
    ]

    def __init__(
        self,
        account_email=None,
        account_first_name=None,
        account_id=None,
        account_last_name=None,
        account_tags=None,
        authzjson=None,
        capture=None,
        client_ip=None,
        completed_at=None,
        duration=None,
        egress_node_id=None,
        encrypted=None,
        id=None,
        identity_alias_username=None,
        metadata_json=None,
        query_body=None,
        query_category=None,
        query_hash=None,
        query_key=None,
        record_count=None,
        remote_identity_username=None,
        replayable=None,
        resource_id=None,
        resource_name=None,
        resource_tags=None,
        resource_type=None,
        source_ip=None,
        target=None,
        timestamp=None,
    ):
        self.account_email = account_email if account_email is not None else ''
        '''
         The email of the account performing this query, at the time the query was executed.
         If the account email is later changed, that change will not be reflected via this field.
        '''
        self.account_first_name = account_first_name if account_first_name is not None else ''
        '''
         The given name of the account performing this query, at the time the query was executed.
         If the account is later renamed, that change will not be reflected via this field.
        '''
        self.account_id = account_id if account_id is not None else ''
        '''
         Unique identifier of the Account that performed the Query.
        '''
        self.account_last_name = account_last_name if account_last_name is not None else ''
        '''
         The family name of the account performing this query, at the time the query was executed.
         If the account is later renamed, that change will not be reflected via this field.
        '''
        self.account_tags = account_tags if account_tags is not None else _porcelain_zero_value_tags(
        )
        '''
         The tags of the account accessed, at the time the query was executed. If the account
         tags are later changed, that change will not be reflected via this field.
        '''
        self.authzjson = authzjson if authzjson is not None else ''
        '''
         Authorization metadata associated with this query.
        '''
        self.capture = capture if capture is not None else None
        '''
         For queries against SSH, Kubernetes, and RDP resources, this contains additional information
         about the captured query.
        '''
        self.client_ip = client_ip if client_ip is not None else ''
        '''
         The IP address the Query was performed from, as detected at the StrongDM control plane.
        '''
        self.completed_at = completed_at if completed_at is not None else None
        '''
         The time at which the Query was completed.
         Empty if this record indicates the start of a long-running query.
        '''
        self.duration = duration if duration is not None else None
        '''
         The duration of the Query.
        '''
        self.egress_node_id = egress_node_id if egress_node_id is not None else ''
        '''
         The unique ID of the node through which the Resource was accessed.
        '''
        self.encrypted = encrypted if encrypted is not None else False
        '''
         Indicates that the body of the Query is encrypted.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Query.
        '''
        self.identity_alias_username = identity_alias_username if identity_alias_username is not None else ''
        '''
         The username of the IdentityAlias used to access the Resource.
        '''
        self.metadata_json = metadata_json if metadata_json is not None else ''
        '''
         Driver specific metadata associated with this query.
        '''
        self.query_body = query_body if query_body is not None else ''
        '''
         The captured content of the Query.
         For queries against SSH, Kubernetes, and RDP resources, this contains a JSON representation of the QueryCapture.
        '''
        self.query_category = query_category if query_category is not None else ''
        '''
         The general category of Resource against which Query was performed, e.g. "web" or "cloud".
        '''
        self.query_hash = query_hash if query_hash is not None else ''
        '''
         The hash of the body of the Query.
        '''
        self.query_key = query_key if query_key is not None else ''
        '''
         The symmetric key used to encrypt the body of this Query and its replay if replayable.
         If the Query is encrypted, this field contains an encrypted symmetric key in base64 encoding.
         This key must be decrypted with the organization's private key to obtain the symmetric key needed to decrypt the body.
         If the Query is not encrypted, this field is empty.
        '''
        self.record_count = record_count if record_count is not None else 0
        '''
         The number of records returned by the Query, for a database Resource.
        '''
        self.remote_identity_username = remote_identity_username if remote_identity_username is not None else ''
        '''
         The username of the RemoteIdentity used to access the Resource.
        '''
        self.replayable = replayable if replayable is not None else False
        '''
         Indicates that the Query is replayable, e.g. for some SSH or K8s sessions.
        '''
        self.resource_id = resource_id if resource_id is not None else ''
        '''
         Unique identifier of the Resource against which the Query was performed.
        '''
        self.resource_name = resource_name if resource_name is not None else ''
        '''
         The name of the resource accessed, at the time the query was executed. If the resource
         is later renamed, that change will not be reflected via this field.
        '''
        self.resource_tags = resource_tags if resource_tags is not None else _porcelain_zero_value_tags(
        )
        '''
         The tags of the resource accessed, at the time the query was executed. If the resource
         tags are later changed, that change will not be reflected via this field.
        '''
        self.resource_type = resource_type if resource_type is not None else ''
        '''
         The specific type of Resource against which the Query was performed, e.g. "ssh" or "postgres".
        '''
        self.source_ip = source_ip if source_ip is not None else ''
        '''
         The IP address the Query was performed from, as detected at the ingress gateway.
        '''
        self.target = target if target is not None else ''
        '''
         The target destination of the query, in host:port format.
        '''
        self.timestamp = timestamp if timestamp is not None else None
        '''
         The time at which the Query was started.
        '''

    def __repr__(self):
        return '<sdm.Query ' + \
            'account_email: ' + repr(self.account_email) + ' ' +\
            'account_first_name: ' + repr(self.account_first_name) + ' ' +\
            'account_id: ' + repr(self.account_id) + ' ' +\
            'account_last_name: ' + repr(self.account_last_name) + ' ' +\
            'account_tags: ' + repr(self.account_tags) + ' ' +\
            'authzjson: ' + repr(self.authzjson) + ' ' +\
            'capture: ' + repr(self.capture) + ' ' +\
            'client_ip: ' + repr(self.client_ip) + ' ' +\
            'completed_at: ' + repr(self.completed_at) + ' ' +\
            'duration: ' + repr(self.duration) + ' ' +\
            'egress_node_id: ' + repr(self.egress_node_id) + ' ' +\
            'encrypted: ' + repr(self.encrypted) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'identity_alias_username: ' + repr(self.identity_alias_username) + ' ' +\
            'metadata_json: ' + repr(self.metadata_json) + ' ' +\
            'query_body: ' + repr(self.query_body) + ' ' +\
            'query_category: ' + repr(self.query_category) + ' ' +\
            'query_hash: ' + repr(self.query_hash) + ' ' +\
            'query_key: ' + repr(self.query_key) + ' ' +\
            'record_count: ' + repr(self.record_count) + ' ' +\
            'remote_identity_username: ' + repr(self.remote_identity_username) + ' ' +\
            'replayable: ' + repr(self.replayable) + ' ' +\
            'resource_id: ' + repr(self.resource_id) + ' ' +\
            'resource_name: ' + repr(self.resource_name) + ' ' +\
            'resource_tags: ' + repr(self.resource_tags) + ' ' +\
            'resource_type: ' + repr(self.resource_type) + ' ' +\
            'source_ip: ' + repr(self.source_ip) + ' ' +\
            'target: ' + repr(self.target) + ' ' +\
            'timestamp: ' + repr(self.timestamp) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'account_email': self.account_email,
            'account_first_name': self.account_first_name,
            'account_id': self.account_id,
            'account_last_name': self.account_last_name,
            'account_tags': self.account_tags,
            'authzjson': self.authzjson,
            'capture': self.capture,
            'client_ip': self.client_ip,
            'completed_at': self.completed_at,
            'duration': self.duration,
            'egress_node_id': self.egress_node_id,
            'encrypted': self.encrypted,
            'id': self.id,
            'identity_alias_username': self.identity_alias_username,
            'metadata_json': self.metadata_json,
            'query_body': self.query_body,
            'query_category': self.query_category,
            'query_hash': self.query_hash,
            'query_key': self.query_key,
            'record_count': self.record_count,
            'remote_identity_username': self.remote_identity_username,
            'replayable': self.replayable,
            'resource_id': self.resource_id,
            'resource_name': self.resource_name,
            'resource_tags': self.resource_tags,
            'resource_type': self.resource_type,
            'source_ip': self.source_ip,
            'target': self.target,
            'timestamp': self.timestamp,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            account_email=d.get('account_email'),
            account_first_name=d.get('account_first_name'),
            account_id=d.get('account_id'),
            account_last_name=d.get('account_last_name'),
            account_tags=d.get('account_tags'),
            authzjson=d.get('authzjson'),
            capture=d.get('capture'),
            client_ip=d.get('client_ip'),
            completed_at=d.get('completed_at'),
            duration=d.get('duration'),
            egress_node_id=d.get('egress_node_id'),
            encrypted=d.get('encrypted'),
            id=d.get('id'),
            identity_alias_username=d.get('identity_alias_username'),
            metadata_json=d.get('metadata_json'),
            query_body=d.get('query_body'),
            query_category=d.get('query_category'),
            query_hash=d.get('query_hash'),
            query_key=d.get('query_key'),
            record_count=d.get('record_count'),
            remote_identity_username=d.get('remote_identity_username'),
            replayable=d.get('replayable'),
            resource_id=d.get('resource_id'),
            resource_name=d.get('resource_name'),
            resource_tags=d.get('resource_tags'),
            resource_type=d.get('resource_type'),
            source_ip=d.get('source_ip'),
            target=d.get('target'),
            timestamp=d.get('timestamp'),
        )


class QueryCapture:
    '''
         A QueryCapture contains additional information about queries against SSH, Kubernetes, and RDP resources.
    '''
    __slots__ = [
        'client_command',
        'command',
        'container',
        'env',
        'file_name',
        'file_size',
        'height',
        'impersonation_groups',
        'impersonation_user',
        'pod',
        'privilege_groups',
        'request_body',
        'request_method',
        'request_uri',
        'type',
        'width',
    ]

    def __init__(
        self,
        client_command=None,
        command=None,
        container=None,
        env=None,
        file_name=None,
        file_size=None,
        height=None,
        impersonation_groups=None,
        impersonation_user=None,
        pod=None,
        privilege_groups=None,
        request_body=None,
        request_method=None,
        request_uri=None,
        type=None,
        width=None,
    ):
        self.client_command = client_command if client_command is not None else ''
        '''
         The command executed on the client for a Kubernetes session.
        '''
        self.command = command if command is not None else ''
        '''
         The command executed over an SSH or Kubernetes session.
        '''
        self.container = container if container is not None else ''
        '''
         The target container of a Kubernetes operation.
        '''
        self.env = env if env is not None else {}
        '''
         The environment variables for an SSH or Kubernetes session.
        '''
        self.file_name = file_name if file_name is not None else ''
        '''
         The remote file name of an SCP operation.
        '''
        self.file_size = file_size if file_size is not None else 0
        '''
         The file size transferred for an SCP operation.
        '''
        self.height = height if height is not None else 0
        '''
         The height of the terminal or window for SSH, Kubernetes, and RDP interactive sessions.
        '''
        self.impersonation_groups = impersonation_groups if impersonation_groups is not None else []
        '''
         The impersonation groups of a Kubernetes operation.
        '''
        self.impersonation_user = impersonation_user if impersonation_user is not None else ''
        '''
         The impersonation user of a Kubernetes operation.
        '''
        self.pod = pod if pod is not None else ''
        '''
         The target pod of a Kubernetes operation.
        '''
        self.privilege_groups = privilege_groups if privilege_groups is not None else []
        '''
         The additional impersonation groups, as granted by privilege levels, of a Kubernetes operation.
        '''
        self.request_body = request_body if request_body is not None else b''
        '''
         The HTTP request body of a Kubernetes operation.
        '''
        self.request_method = request_method if request_method is not None else ''
        '''
         The HTTP request method of a Kubernetes operation.
        '''
        self.request_uri = request_uri if request_uri is not None else ''
        '''
         The HTTP request URI of a Kubernetes operation.
        '''
        self.type = type if type is not None else ''
        '''
         The CaptureType of this query capture, one of the CaptureType constants.
        '''
        self.width = width if width is not None else 0
        '''
         The width of the terminal or window for SSH, Kubernetes, and RDP interactive sessions.
        '''

    def __repr__(self):
        return '<sdm.QueryCapture ' + \
            'client_command: ' + repr(self.client_command) + ' ' +\
            'command: ' + repr(self.command) + ' ' +\
            'container: ' + repr(self.container) + ' ' +\
            'env: ' + repr(self.env) + ' ' +\
            'file_name: ' + repr(self.file_name) + ' ' +\
            'file_size: ' + repr(self.file_size) + ' ' +\
            'height: ' + repr(self.height) + ' ' +\
            'impersonation_groups: ' + repr(self.impersonation_groups) + ' ' +\
            'impersonation_user: ' + repr(self.impersonation_user) + ' ' +\
            'pod: ' + repr(self.pod) + ' ' +\
            'privilege_groups: ' + repr(self.privilege_groups) + ' ' +\
            'request_body: ' + repr(self.request_body) + ' ' +\
            'request_method: ' + repr(self.request_method) + ' ' +\
            'request_uri: ' + repr(self.request_uri) + ' ' +\
            'type: ' + repr(self.type) + ' ' +\
            'width: ' + repr(self.width) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'client_command': self.client_command,
            'command': self.command,
            'container': self.container,
            'env': self.env,
            'file_name': self.file_name,
            'file_size': self.file_size,
            'height': self.height,
            'impersonation_groups': self.impersonation_groups,
            'impersonation_user': self.impersonation_user,
            'pod': self.pod,
            'privilege_groups': self.privilege_groups,
            'request_body': self.request_body,
            'request_method': self.request_method,
            'request_uri': self.request_uri,
            'type': self.type,
            'width': self.width,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            client_command=d.get('client_command'),
            command=d.get('command'),
            container=d.get('container'),
            env=d.get('env'),
            file_name=d.get('file_name'),
            file_size=d.get('file_size'),
            height=d.get('height'),
            impersonation_groups=d.get('impersonation_groups'),
            impersonation_user=d.get('impersonation_user'),
            pod=d.get('pod'),
            privilege_groups=d.get('privilege_groups'),
            request_body=d.get('request_body'),
            request_method=d.get('request_method'),
            request_uri=d.get('request_uri'),
            type=d.get('type'),
            width=d.get('width'),
        )


class RDP:
    __slots__ = [
        'bind_interface',
        'downgrade_nla_connections',
        'egress_filter',
        'healthy',
        'hostname',
        'id',
        'lock_required',
        'name',
        'password',
        'port',
        'port_override',
        'proxy_cluster_id',
        'secret_store_id',
        'subdomain',
        'tags',
        'username',
    ]

    def __init__(
        self,
        bind_interface=None,
        downgrade_nla_connections=None,
        egress_filter=None,
        healthy=None,
        hostname=None,
        id=None,
        lock_required=None,
        name=None,
        password=None,
        port=None,
        port_override=None,
        proxy_cluster_id=None,
        secret_store_id=None,
        subdomain=None,
        tags=None,
        username=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided and may also be set to one of the ResourceIPAllocationMode constants to select between VNM, loopback, or default allocation.
        '''
        self.downgrade_nla_connections = downgrade_nla_connections if downgrade_nla_connections is not None else False
        '''
         When set, network level authentication will not be used. May resolve unexpected authentication errors to older servers. When set, healthchecks cannot detect if a provided username / password pair is correct.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        '''
         The host to dial to initiate a connection from the egress node to this resource.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.lock_required = lock_required if lock_required is not None else False
        '''
         When set, require a resource lock to access the resource to ensure it can only be used by one user at a time.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.password = password if password is not None else ''
        '''
         The password to authenticate with.
        '''
        self.port = port if port is not None else 0
        '''
         The port to dial to initiate a connection from the egress node to this resource.
        '''
        self.port_override = port_override if port_override is not None else 0
        '''
         The local port used by clients to connect to this resource. It is automatically generated if not provided on create and may be re-generated on update by specifying a value of -1.
        '''
        self.proxy_cluster_id = proxy_cluster_id if proxy_cluster_id is not None else ''
        '''
         ID of the proxy cluster for this resource, if any.
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         DNS subdomain through which this resource may be accessed on clients.  (e.g. "app-prod1" allows the resource to be accessed at "app-prod1.your-org-name.sdm-proxy-domain"). Only applicable to HTTP-based resources or resources using virtual networking mode.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.username = username if username is not None else ''
        '''
         The username to authenticate with.
        '''

    def __repr__(self):
        return '<sdm.RDP ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'downgrade_nla_connections: ' + repr(self.downgrade_nla_connections) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'lock_required: ' + repr(self.lock_required) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'password: ' + repr(self.password) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'proxy_cluster_id: ' + repr(self.proxy_cluster_id) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'username: ' + repr(self.username) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'downgrade_nla_connections': self.downgrade_nla_connections,
            'egress_filter': self.egress_filter,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'lock_required': self.lock_required,
            'name': self.name,
            'password': self.password,
            'port': self.port,
            'port_override': self.port_override,
            'proxy_cluster_id': self.proxy_cluster_id,
            'secret_store_id': self.secret_store_id,
            'subdomain': self.subdomain,
            'tags': self.tags,
            'username': self.username,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            downgrade_nla_connections=d.get('downgrade_nla_connections'),
            egress_filter=d.get('egress_filter'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            lock_required=d.get('lock_required'),
            name=d.get('name'),
            password=d.get('password'),
            port=d.get('port'),
            port_override=d.get('port_override'),
            proxy_cluster_id=d.get('proxy_cluster_id'),
            secret_store_id=d.get('secret_store_id'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
            username=d.get('username'),
        )


class RDPCert:
    __slots__ = [
        'bind_interface',
        'dc_hostnames',
        'egress_filter',
        'healthy',
        'hostname',
        'id',
        'identity_alias_healthcheck_username',
        'identity_set_id',
        'lock_required',
        'name',
        'port',
        'port_override',
        'proxy_cluster_id',
        'secret_store_id',
        'sid',
        'subdomain',
        'tags',
        'username',
    ]

    def __init__(
        self,
        bind_interface=None,
        dc_hostnames=None,
        egress_filter=None,
        healthy=None,
        hostname=None,
        id=None,
        identity_alias_healthcheck_username=None,
        identity_set_id=None,
        lock_required=None,
        name=None,
        port=None,
        port_override=None,
        proxy_cluster_id=None,
        secret_store_id=None,
        sid=None,
        subdomain=None,
        tags=None,
        username=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided and may also be set to one of the ResourceIPAllocationMode constants to select between VNM, loopback, or default allocation.
        '''
        self.dc_hostnames = dc_hostnames if dc_hostnames is not None else ''
        '''
         Comma-separated list of Active Directory Domain Controller hostnames for LDAPS SID resolution. Utilized for strong certificate mapping in full enforcement mode when the identity alias does not specify a SID.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        '''
         The host to dial to initiate a connection from the egress node to this resource.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.identity_alias_healthcheck_username = identity_alias_healthcheck_username if identity_alias_healthcheck_username is not None else ''
        '''
         The username to use for healthchecks, when clients otherwise connect with their own identity alias username.
        '''
        self.identity_set_id = identity_set_id if identity_set_id is not None else ''
        '''
         The ID of the identity set to use for identity connections.
        '''
        self.lock_required = lock_required if lock_required is not None else False
        '''
         When set, require a resource lock to access the resource to ensure it can only be used by one user at a time.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.port = port if port is not None else 0
        '''
         The port to dial to initiate a connection from the egress node to this resource.
        '''
        self.port_override = port_override if port_override is not None else 0
        '''
         The local port used by clients to connect to this resource. It is automatically generated if not provided on create and may be re-generated on update by specifying a value of -1.
        '''
        self.proxy_cluster_id = proxy_cluster_id if proxy_cluster_id is not None else ''
        '''
         ID of the proxy cluster for this resource, if any.
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.sid = sid if sid is not None else ''
        '''
         Windows Security Identifier (SID) of the configured Username, required for strong certificate mapping in full enforcement mode.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         DNS subdomain through which this resource may be accessed on clients.  (e.g. "app-prod1" allows the resource to be accessed at "app-prod1.your-org-name.sdm-proxy-domain"). Only applicable to HTTP-based resources or resources using virtual networking mode.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.username = username if username is not None else ''
        '''
         The username to authenticate with.
        '''

    def __repr__(self):
        return '<sdm.RDPCert ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'dc_hostnames: ' + repr(self.dc_hostnames) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'identity_alias_healthcheck_username: ' + repr(self.identity_alias_healthcheck_username) + ' ' +\
            'identity_set_id: ' + repr(self.identity_set_id) + ' ' +\
            'lock_required: ' + repr(self.lock_required) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'proxy_cluster_id: ' + repr(self.proxy_cluster_id) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'sid: ' + repr(self.sid) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'username: ' + repr(self.username) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'dc_hostnames': self.dc_hostnames,
            'egress_filter': self.egress_filter,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'identity_alias_healthcheck_username':
            self.identity_alias_healthcheck_username,
            'identity_set_id': self.identity_set_id,
            'lock_required': self.lock_required,
            'name': self.name,
            'port': self.port,
            'port_override': self.port_override,
            'proxy_cluster_id': self.proxy_cluster_id,
            'secret_store_id': self.secret_store_id,
            'sid': self.sid,
            'subdomain': self.subdomain,
            'tags': self.tags,
            'username': self.username,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            dc_hostnames=d.get('dc_hostnames'),
            egress_filter=d.get('egress_filter'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            identity_alias_healthcheck_username=d.get(
                'identity_alias_healthcheck_username'),
            identity_set_id=d.get('identity_set_id'),
            lock_required=d.get('lock_required'),
            name=d.get('name'),
            port=d.get('port'),
            port_override=d.get('port_override'),
            proxy_cluster_id=d.get('proxy_cluster_id'),
            secret_store_id=d.get('secret_store_id'),
            sid=d.get('sid'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
            username=d.get('username'),
        )


class RDSPostgresIAM:
    __slots__ = [
        'bind_interface',
        'database',
        'egress_filter',
        'healthy',
        'hostname',
        'id',
        'name',
        'override_database',
        'port',
        'port_override',
        'proxy_cluster_id',
        'region',
        'role_assumption_arn',
        'secret_store_id',
        'subdomain',
        'tags',
        'username',
    ]

    def __init__(
        self,
        bind_interface=None,
        database=None,
        egress_filter=None,
        healthy=None,
        hostname=None,
        id=None,
        name=None,
        override_database=None,
        port=None,
        port_override=None,
        proxy_cluster_id=None,
        region=None,
        role_assumption_arn=None,
        secret_store_id=None,
        subdomain=None,
        tags=None,
        username=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided and may also be set to one of the ResourceIPAllocationMode constants to select between VNM, loopback, or default allocation.
        '''
        self.database = database if database is not None else ''
        '''
         The initial database to connect to. This setting does not by itself prevent switching to another database after connecting.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        '''
         The host to dial to initiate a connection from the egress node to this resource.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.override_database = override_database if override_database is not None else False
        '''
         If set, the database configured cannot be changed by users. This setting is not recommended for most use cases, as some clients will insist their database has changed when it has not, leading to user confusion.
        '''
        self.port = port if port is not None else 0
        '''
         The port to dial to initiate a connection from the egress node to this resource.
        '''
        self.port_override = port_override if port_override is not None else 0
        '''
         The local port used by clients to connect to this resource. It is automatically generated if not provided on create and may be re-generated on update by specifying a value of -1.
        '''
        self.proxy_cluster_id = proxy_cluster_id if proxy_cluster_id is not None else ''
        '''
         ID of the proxy cluster for this resource, if any.
        '''
        self.region = region if region is not None else ''
        '''
         The AWS region to connect to.
        '''
        self.role_assumption_arn = role_assumption_arn if role_assumption_arn is not None else ''
        '''
         If provided, the gateway/relay will try to assume this role instead of the underlying compute's role.
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         DNS subdomain through which this resource may be accessed on clients.  (e.g. "app-prod1" allows the resource to be accessed at "app-prod1.your-org-name.sdm-proxy-domain"). Only applicable to HTTP-based resources or resources using virtual networking mode.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.username = username if username is not None else ''
        '''
         The username to authenticate with.
        '''

    def __repr__(self):
        return '<sdm.RDSPostgresIAM ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'database: ' + repr(self.database) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'override_database: ' + repr(self.override_database) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'proxy_cluster_id: ' + repr(self.proxy_cluster_id) + ' ' +\
            'region: ' + repr(self.region) + ' ' +\
            'role_assumption_arn: ' + repr(self.role_assumption_arn) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'username: ' + repr(self.username) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'database': self.database,
            'egress_filter': self.egress_filter,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'name': self.name,
            'override_database': self.override_database,
            'port': self.port,
            'port_override': self.port_override,
            'proxy_cluster_id': self.proxy_cluster_id,
            'region': self.region,
            'role_assumption_arn': self.role_assumption_arn,
            'secret_store_id': self.secret_store_id,
            'subdomain': self.subdomain,
            'tags': self.tags,
            'username': self.username,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            database=d.get('database'),
            egress_filter=d.get('egress_filter'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            name=d.get('name'),
            override_database=d.get('override_database'),
            port=d.get('port'),
            port_override=d.get('port_override'),
            proxy_cluster_id=d.get('proxy_cluster_id'),
            region=d.get('region'),
            role_assumption_arn=d.get('role_assumption_arn'),
            secret_store_id=d.get('secret_store_id'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
            username=d.get('username'),
        )


class RabbitMQAMQP091:
    __slots__ = [
        'bind_interface',
        'egress_filter',
        'healthy',
        'hostname',
        'id',
        'name',
        'password',
        'port',
        'port_override',
        'proxy_cluster_id',
        'secret_store_id',
        'subdomain',
        'tags',
        'tls_required',
        'username',
    ]

    def __init__(
        self,
        bind_interface=None,
        egress_filter=None,
        healthy=None,
        hostname=None,
        id=None,
        name=None,
        password=None,
        port=None,
        port_override=None,
        proxy_cluster_id=None,
        secret_store_id=None,
        subdomain=None,
        tags=None,
        tls_required=None,
        username=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided and may also be set to one of the ResourceIPAllocationMode constants to select between VNM, loopback, or default allocation.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        '''
         The host to dial to initiate a connection from the egress node to this resource.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.password = password if password is not None else ''
        '''
         The password to authenticate with.
        '''
        self.port = port if port is not None else 0
        '''
         The port to dial to initiate a connection from the egress node to this resource.
        '''
        self.port_override = port_override if port_override is not None else 0
        '''
         The local port used by clients to connect to this resource. It is automatically generated if not provided on create and may be re-generated on update by specifying a value of -1.
        '''
        self.proxy_cluster_id = proxy_cluster_id if proxy_cluster_id is not None else ''
        '''
         ID of the proxy cluster for this resource, if any.
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         DNS subdomain through which this resource may be accessed on clients.  (e.g. "app-prod1" allows the resource to be accessed at "app-prod1.your-org-name.sdm-proxy-domain"). Only applicable to HTTP-based resources or resources using virtual networking mode.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.tls_required = tls_required if tls_required is not None else False
        '''
         If set, TLS must be used to connect to this resource.
        '''
        self.username = username if username is not None else ''
        '''
         The username to authenticate with.
        '''

    def __repr__(self):
        return '<sdm.RabbitMQAMQP091 ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'password: ' + repr(self.password) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'proxy_cluster_id: ' + repr(self.proxy_cluster_id) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'tls_required: ' + repr(self.tls_required) + ' ' +\
            'username: ' + repr(self.username) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'egress_filter': self.egress_filter,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'name': self.name,
            'password': self.password,
            'port': self.port,
            'port_override': self.port_override,
            'proxy_cluster_id': self.proxy_cluster_id,
            'secret_store_id': self.secret_store_id,
            'subdomain': self.subdomain,
            'tags': self.tags,
            'tls_required': self.tls_required,
            'username': self.username,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            egress_filter=d.get('egress_filter'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            name=d.get('name'),
            password=d.get('password'),
            port=d.get('port'),
            port_override=d.get('port_override'),
            proxy_cluster_id=d.get('proxy_cluster_id'),
            secret_store_id=d.get('secret_store_id'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
            tls_required=d.get('tls_required'),
            username=d.get('username'),
        )


class RateLimitMetadata:
    '''
         RateLimitMetadata contains information about remaining requests avaialable
     to the user over some timeframe.
    '''
    __slots__ = [
        'bucket',
        'limit',
        'remaining',
        'reset_at',
    ]

    def __init__(
        self,
        bucket=None,
        limit=None,
        remaining=None,
        reset_at=None,
    ):
        self.bucket = bucket if bucket is not None else ''
        '''
         The bucket this user/token is associated with, which may be shared between
         multiple users/tokens.
        '''
        self.limit = limit if limit is not None else 0
        '''
         How many total requests the user/token is authorized to make before being
         rate limited.
        '''
        self.remaining = remaining if remaining is not None else 0
        '''
         How many remaining requests out of the limit are still avaialable.
        '''
        self.reset_at = reset_at if reset_at is not None else None
        '''
         The time when remaining will be reset to limit.
        '''

    def __repr__(self):
        return '<sdm.RateLimitMetadata ' + \
            'bucket: ' + repr(self.bucket) + ' ' +\
            'limit: ' + repr(self.limit) + ' ' +\
            'remaining: ' + repr(self.remaining) + ' ' +\
            'reset_at: ' + repr(self.reset_at) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bucket': self.bucket,
            'limit': self.limit,
            'remaining': self.remaining,
            'reset_at': self.reset_at,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bucket=d.get('bucket'),
            limit=d.get('limit'),
            remaining=d.get('remaining'),
            reset_at=d.get('reset_at'),
        )


class RawTCP:
    __slots__ = [
        'bind_interface',
        'egress_filter',
        'healthy',
        'hostname',
        'id',
        'name',
        'port',
        'port_override',
        'proxy_cluster_id',
        'secret_store_id',
        'subdomain',
        'tags',
    ]

    def __init__(
        self,
        bind_interface=None,
        egress_filter=None,
        healthy=None,
        hostname=None,
        id=None,
        name=None,
        port=None,
        port_override=None,
        proxy_cluster_id=None,
        secret_store_id=None,
        subdomain=None,
        tags=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided and may also be set to one of the ResourceIPAllocationMode constants to select between VNM, loopback, or default allocation.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        '''
         The host to dial to initiate a connection from the egress node to this resource.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.port = port if port is not None else 0
        '''
         The port to dial to initiate a connection from the egress node to this resource.
        '''
        self.port_override = port_override if port_override is not None else 0
        '''
         The local port used by clients to connect to this resource. It is automatically generated if not provided on create and may be re-generated on update by specifying a value of -1.
        '''
        self.proxy_cluster_id = proxy_cluster_id if proxy_cluster_id is not None else ''
        '''
         ID of the proxy cluster for this resource, if any.
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         DNS subdomain through which this resource may be accessed on clients.  (e.g. "app-prod1" allows the resource to be accessed at "app-prod1.your-org-name.sdm-proxy-domain"). Only applicable to HTTP-based resources or resources using virtual networking mode.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''

    def __repr__(self):
        return '<sdm.RawTCP ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'proxy_cluster_id: ' + repr(self.proxy_cluster_id) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'egress_filter': self.egress_filter,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'name': self.name,
            'port': self.port,
            'port_override': self.port_override,
            'proxy_cluster_id': self.proxy_cluster_id,
            'secret_store_id': self.secret_store_id,
            'subdomain': self.subdomain,
            'tags': self.tags,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            egress_filter=d.get('egress_filter'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            name=d.get('name'),
            port=d.get('port'),
            port_override=d.get('port_override'),
            proxy_cluster_id=d.get('proxy_cluster_id'),
            secret_store_id=d.get('secret_store_id'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
        )


class Redis:
    __slots__ = [
        'bind_interface',
        'egress_filter',
        'healthy',
        'hostname',
        'id',
        'name',
        'password',
        'port',
        'port_override',
        'proxy_cluster_id',
        'secret_store_id',
        'subdomain',
        'tags',
        'tls_required',
        'username',
    ]

    def __init__(
        self,
        bind_interface=None,
        egress_filter=None,
        healthy=None,
        hostname=None,
        id=None,
        name=None,
        password=None,
        port=None,
        port_override=None,
        proxy_cluster_id=None,
        secret_store_id=None,
        subdomain=None,
        tags=None,
        tls_required=None,
        username=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided and may also be set to one of the ResourceIPAllocationMode constants to select between VNM, loopback, or default allocation.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        '''
         The host to dial to initiate a connection from the egress node to this resource.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.password = password if password is not None else ''
        '''
         The password to authenticate with.
        '''
        self.port = port if port is not None else 0
        '''
         The port to dial to initiate a connection from the egress node to this resource.
        '''
        self.port_override = port_override if port_override is not None else 0
        '''
         The local port used by clients to connect to this resource. It is automatically generated if not provided on create and may be re-generated on update by specifying a value of -1.
        '''
        self.proxy_cluster_id = proxy_cluster_id if proxy_cluster_id is not None else ''
        '''
         ID of the proxy cluster for this resource, if any.
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         DNS subdomain through which this resource may be accessed on clients.  (e.g. "app-prod1" allows the resource to be accessed at "app-prod1.your-org-name.sdm-proxy-domain"). Only applicable to HTTP-based resources or resources using virtual networking mode.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.tls_required = tls_required if tls_required is not None else False
        '''
         If set, TLS must be used to connect to this resource.
        '''
        self.username = username if username is not None else ''
        '''
         The username to authenticate with.
        '''

    def __repr__(self):
        return '<sdm.Redis ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'password: ' + repr(self.password) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'proxy_cluster_id: ' + repr(self.proxy_cluster_id) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'tls_required: ' + repr(self.tls_required) + ' ' +\
            'username: ' + repr(self.username) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'egress_filter': self.egress_filter,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'name': self.name,
            'password': self.password,
            'port': self.port,
            'port_override': self.port_override,
            'proxy_cluster_id': self.proxy_cluster_id,
            'secret_store_id': self.secret_store_id,
            'subdomain': self.subdomain,
            'tags': self.tags,
            'tls_required': self.tls_required,
            'username': self.username,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            egress_filter=d.get('egress_filter'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            name=d.get('name'),
            password=d.get('password'),
            port=d.get('port'),
            port_override=d.get('port_override'),
            proxy_cluster_id=d.get('proxy_cluster_id'),
            secret_store_id=d.get('secret_store_id'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
            tls_required=d.get('tls_required'),
            username=d.get('username'),
        )


class RedisCluster:
    __slots__ = [
        'bind_interface',
        'egress_filter',
        'healthy',
        'hostname',
        'id',
        'name',
        'password',
        'port',
        'port_override',
        'proxy_cluster_id',
        'secret_store_id',
        'subdomain',
        'tags',
        'tls_required',
        'username',
    ]

    def __init__(
        self,
        bind_interface=None,
        egress_filter=None,
        healthy=None,
        hostname=None,
        id=None,
        name=None,
        password=None,
        port=None,
        port_override=None,
        proxy_cluster_id=None,
        secret_store_id=None,
        subdomain=None,
        tags=None,
        tls_required=None,
        username=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided and may also be set to one of the ResourceIPAllocationMode constants to select between VNM, loopback, or default allocation.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        '''
         Hostname must contain the hostname/port pairs of all instances in the replica set separated by commas.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.password = password if password is not None else ''
        '''
         The password to authenticate with.
        '''
        self.port = port if port is not None else 0
        '''
         The port to dial to initiate a connection from the egress node to this resource.
        '''
        self.port_override = port_override if port_override is not None else 0
        '''
         The local port used by clients to connect to this resource. It is automatically generated if not provided on create and may be re-generated on update by specifying a value of -1.
        '''
        self.proxy_cluster_id = proxy_cluster_id if proxy_cluster_id is not None else ''
        '''
         ID of the proxy cluster for this resource, if any.
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         DNS subdomain through which this resource may be accessed on clients.  (e.g. "app-prod1" allows the resource to be accessed at "app-prod1.your-org-name.sdm-proxy-domain"). Only applicable to HTTP-based resources or resources using virtual networking mode.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.tls_required = tls_required if tls_required is not None else False
        '''
         If set, TLS must be used to connect to this resource.
        '''
        self.username = username if username is not None else ''
        '''
         The username to authenticate with.
        '''

    def __repr__(self):
        return '<sdm.RedisCluster ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'password: ' + repr(self.password) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'proxy_cluster_id: ' + repr(self.proxy_cluster_id) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'tls_required: ' + repr(self.tls_required) + ' ' +\
            'username: ' + repr(self.username) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'egress_filter': self.egress_filter,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'name': self.name,
            'password': self.password,
            'port': self.port,
            'port_override': self.port_override,
            'proxy_cluster_id': self.proxy_cluster_id,
            'secret_store_id': self.secret_store_id,
            'subdomain': self.subdomain,
            'tags': self.tags,
            'tls_required': self.tls_required,
            'username': self.username,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            egress_filter=d.get('egress_filter'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            name=d.get('name'),
            password=d.get('password'),
            port=d.get('port'),
            port_override=d.get('port_override'),
            proxy_cluster_id=d.get('proxy_cluster_id'),
            secret_store_id=d.get('secret_store_id'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
            tls_required=d.get('tls_required'),
            username=d.get('username'),
        )


class Redshift:
    __slots__ = [
        'bind_interface',
        'database',
        'egress_filter',
        'healthy',
        'hostname',
        'id',
        'name',
        'override_database',
        'password',
        'port',
        'port_override',
        'proxy_cluster_id',
        'secret_store_id',
        'subdomain',
        'tags',
        'username',
    ]

    def __init__(
        self,
        bind_interface=None,
        database=None,
        egress_filter=None,
        healthy=None,
        hostname=None,
        id=None,
        name=None,
        override_database=None,
        password=None,
        port=None,
        port_override=None,
        proxy_cluster_id=None,
        secret_store_id=None,
        subdomain=None,
        tags=None,
        username=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided and may also be set to one of the ResourceIPAllocationMode constants to select between VNM, loopback, or default allocation.
        '''
        self.database = database if database is not None else ''
        '''
         The initial database to connect to. This setting does not by itself prevent switching to another database after connecting.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        '''
         The host to dial to initiate a connection from the egress node to this resource.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.override_database = override_database if override_database is not None else False
        '''
         If set, the database configured cannot be changed by users. This setting is not recommended for most use cases, as some clients will insist their database has changed when it has not, leading to user confusion.
        '''
        self.password = password if password is not None else ''
        '''
         The password to authenticate with.
        '''
        self.port = port if port is not None else 0
        '''
         The port to dial to initiate a connection from the egress node to this resource.
        '''
        self.port_override = port_override if port_override is not None else 0
        '''
         The local port used by clients to connect to this resource. It is automatically generated if not provided on create and may be re-generated on update by specifying a value of -1.
        '''
        self.proxy_cluster_id = proxy_cluster_id if proxy_cluster_id is not None else ''
        '''
         ID of the proxy cluster for this resource, if any.
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         DNS subdomain through which this resource may be accessed on clients.  (e.g. "app-prod1" allows the resource to be accessed at "app-prod1.your-org-name.sdm-proxy-domain"). Only applicable to HTTP-based resources or resources using virtual networking mode.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.username = username if username is not None else ''
        '''
         The username to authenticate with.
        '''

    def __repr__(self):
        return '<sdm.Redshift ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'database: ' + repr(self.database) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'override_database: ' + repr(self.override_database) + ' ' +\
            'password: ' + repr(self.password) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'proxy_cluster_id: ' + repr(self.proxy_cluster_id) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'username: ' + repr(self.username) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'database': self.database,
            'egress_filter': self.egress_filter,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'name': self.name,
            'override_database': self.override_database,
            'password': self.password,
            'port': self.port,
            'port_override': self.port_override,
            'proxy_cluster_id': self.proxy_cluster_id,
            'secret_store_id': self.secret_store_id,
            'subdomain': self.subdomain,
            'tags': self.tags,
            'username': self.username,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            database=d.get('database'),
            egress_filter=d.get('egress_filter'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            name=d.get('name'),
            override_database=d.get('override_database'),
            password=d.get('password'),
            port=d.get('port'),
            port_override=d.get('port_override'),
            proxy_cluster_id=d.get('proxy_cluster_id'),
            secret_store_id=d.get('secret_store_id'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
            username=d.get('username'),
        )


class RedshiftIAM:
    __slots__ = [
        'bind_interface',
        'cluster_id',
        'database',
        'egress_filter',
        'healthy',
        'hostname',
        'id',
        'name',
        'override_database',
        'port',
        'port_override',
        'proxy_cluster_id',
        'region',
        'role_assumption_arn',
        'secret_store_id',
        'subdomain',
        'tags',
    ]

    def __init__(
        self,
        bind_interface=None,
        cluster_id=None,
        database=None,
        egress_filter=None,
        healthy=None,
        hostname=None,
        id=None,
        name=None,
        override_database=None,
        port=None,
        port_override=None,
        proxy_cluster_id=None,
        region=None,
        role_assumption_arn=None,
        secret_store_id=None,
        subdomain=None,
        tags=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided and may also be set to one of the ResourceIPAllocationMode constants to select between VNM, loopback, or default allocation.
        '''
        self.cluster_id = cluster_id if cluster_id is not None else ''
        '''
         Cluster Identified of Redshift cluster
        '''
        self.database = database if database is not None else ''
        '''
         The initial database to connect to. This setting does not by itself prevent switching to another database after connecting.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        '''
         The host to dial to initiate a connection from the egress node to this resource.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.override_database = override_database if override_database is not None else False
        '''
         If set, the database configured cannot be changed by users. This setting is not recommended for most use cases, as some clients will insist their database has changed when it has not, leading to user confusion.
        '''
        self.port = port if port is not None else 0
        '''
         The port to dial to initiate a connection from the egress node to this resource.
        '''
        self.port_override = port_override if port_override is not None else 0
        '''
         The local port used by clients to connect to this resource. It is automatically generated if not provided on create and may be re-generated on update by specifying a value of -1.
        '''
        self.proxy_cluster_id = proxy_cluster_id if proxy_cluster_id is not None else ''
        '''
         ID of the proxy cluster for this resource, if any.
        '''
        self.region = region if region is not None else ''
        '''
         The AWS region to connect to.
        '''
        self.role_assumption_arn = role_assumption_arn if role_assumption_arn is not None else ''
        '''
         If provided, the gateway/relay will try to assume this role instead of the underlying compute's role.
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         DNS subdomain through which this resource may be accessed on clients.  (e.g. "app-prod1" allows the resource to be accessed at "app-prod1.your-org-name.sdm-proxy-domain"). Only applicable to HTTP-based resources or resources using virtual networking mode.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''

    def __repr__(self):
        return '<sdm.RedshiftIAM ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'cluster_id: ' + repr(self.cluster_id) + ' ' +\
            'database: ' + repr(self.database) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'override_database: ' + repr(self.override_database) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'proxy_cluster_id: ' + repr(self.proxy_cluster_id) + ' ' +\
            'region: ' + repr(self.region) + ' ' +\
            'role_assumption_arn: ' + repr(self.role_assumption_arn) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'cluster_id': self.cluster_id,
            'database': self.database,
            'egress_filter': self.egress_filter,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'name': self.name,
            'override_database': self.override_database,
            'port': self.port,
            'port_override': self.port_override,
            'proxy_cluster_id': self.proxy_cluster_id,
            'region': self.region,
            'role_assumption_arn': self.role_assumption_arn,
            'secret_store_id': self.secret_store_id,
            'subdomain': self.subdomain,
            'tags': self.tags,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            cluster_id=d.get('cluster_id'),
            database=d.get('database'),
            egress_filter=d.get('egress_filter'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            name=d.get('name'),
            override_database=d.get('override_database'),
            port=d.get('port'),
            port_override=d.get('port_override'),
            proxy_cluster_id=d.get('proxy_cluster_id'),
            region=d.get('region'),
            role_assumption_arn=d.get('role_assumption_arn'),
            secret_store_id=d.get('secret_store_id'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
        )


class RedshiftServerlessIAM:
    __slots__ = [
        'bind_interface',
        'database',
        'egress_filter',
        'healthy',
        'hostname',
        'id',
        'name',
        'override_database',
        'port',
        'port_override',
        'proxy_cluster_id',
        'region',
        'role_assumption_arn',
        'secret_store_id',
        'subdomain',
        'tags',
        'workgroup',
    ]

    def __init__(
        self,
        bind_interface=None,
        database=None,
        egress_filter=None,
        healthy=None,
        hostname=None,
        id=None,
        name=None,
        override_database=None,
        port=None,
        port_override=None,
        proxy_cluster_id=None,
        region=None,
        role_assumption_arn=None,
        secret_store_id=None,
        subdomain=None,
        tags=None,
        workgroup=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided and may also be set to one of the ResourceIPAllocationMode constants to select between VNM, loopback, or default allocation.
        '''
        self.database = database if database is not None else ''
        '''
         The initial database to connect to. This setting does not by itself prevent switching to another database after connecting.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        '''
         The host to dial to initiate a connection from the egress node to this resource.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.override_database = override_database if override_database is not None else False
        '''
         If set, the database configured cannot be changed by users. This setting is not recommended for most use cases, as some clients will insist their database has changed when it has not, leading to user confusion.
        '''
        self.port = port if port is not None else 0
        '''
         The port to dial to initiate a connection from the egress node to this resource.
        '''
        self.port_override = port_override if port_override is not None else 0
        '''
         The local port used by clients to connect to this resource. It is automatically generated if not provided on create and may be re-generated on update by specifying a value of -1.
        '''
        self.proxy_cluster_id = proxy_cluster_id if proxy_cluster_id is not None else ''
        '''
         ID of the proxy cluster for this resource, if any.
        '''
        self.region = region if region is not None else ''
        '''
         The AWS region to connect to.
        '''
        self.role_assumption_arn = role_assumption_arn if role_assumption_arn is not None else ''
        '''
         If provided, the gateway/relay will try to assume this role instead of the underlying compute's role.
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         DNS subdomain through which this resource may be accessed on clients.  (e.g. "app-prod1" allows the resource to be accessed at "app-prod1.your-org-name.sdm-proxy-domain"). Only applicable to HTTP-based resources or resources using virtual networking mode.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.workgroup = workgroup if workgroup is not None else ''
        '''
         Workgroup name in the serverless Redshift
        '''

    def __repr__(self):
        return '<sdm.RedshiftServerlessIAM ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'database: ' + repr(self.database) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'override_database: ' + repr(self.override_database) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'proxy_cluster_id: ' + repr(self.proxy_cluster_id) + ' ' +\
            'region: ' + repr(self.region) + ' ' +\
            'role_assumption_arn: ' + repr(self.role_assumption_arn) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'workgroup: ' + repr(self.workgroup) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'database': self.database,
            'egress_filter': self.egress_filter,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'name': self.name,
            'override_database': self.override_database,
            'port': self.port,
            'port_override': self.port_override,
            'proxy_cluster_id': self.proxy_cluster_id,
            'region': self.region,
            'role_assumption_arn': self.role_assumption_arn,
            'secret_store_id': self.secret_store_id,
            'subdomain': self.subdomain,
            'tags': self.tags,
            'workgroup': self.workgroup,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            database=d.get('database'),
            egress_filter=d.get('egress_filter'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            name=d.get('name'),
            override_database=d.get('override_database'),
            port=d.get('port'),
            port_override=d.get('port_override'),
            proxy_cluster_id=d.get('proxy_cluster_id'),
            region=d.get('region'),
            role_assumption_arn=d.get('role_assumption_arn'),
            secret_store_id=d.get('secret_store_id'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
            workgroup=d.get('workgroup'),
        )


class Relay:
    '''
         Relay represents a StrongDM CLI installation running in relay mode.
    '''
    __slots__ = [
        'device',
        'gateway_filter',
        'id',
        'location',
        'maintenance_windows',
        'name',
        'state',
        'tags',
        'version',
    ]

    def __init__(
        self,
        device=None,
        gateway_filter=None,
        id=None,
        location=None,
        maintenance_windows=None,
        name=None,
        state=None,
        tags=None,
        version=None,
    ):
        self.device = device if device is not None else ''
        '''
         Device is a read only device name uploaded by the gateway process when
         it comes online.
        '''
        self.gateway_filter = gateway_filter if gateway_filter is not None else ''
        '''
         GatewayFilter can be used to restrict the peering between relays and
         gateways. Deprecated.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Relay.
        '''
        self.location = location if location is not None else ''
        '''
         Location is a read only network location uploaded by the gateway process
         when it comes online.
        '''
        self.maintenance_windows = maintenance_windows if maintenance_windows is not None else []
        '''
         Maintenance Windows define when this node is allowed to restart. If a node
         is requested to restart, it will check each window to determine if any of
         them permit it to restart, and if any do, it will. This check is repeated
         per window until the restart is successfully completed.
         
         If not set here, may be set on the command line or via an environment variable
         on the process itself; any server setting will take precedence over local
         settings. This setting is ineffective for nodes below version 38.44.0.
         
         If this setting is not applied via this remote configuration or via local
         configuration, the default setting is used: always allow restarts if serving
         no connections, and allow a restart even if serving connections between 7-8 UTC, any day.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Relay. Node names must include only letters, numbers, and hyphens (no spaces, underscores, or other special characters). Generated if not provided on create.
        '''
        self.state = state if state is not None else ''
        '''
         The current state of the relay, one of the NodeState constants.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.version = version if version is not None else ''
        '''
         Version is a read only sdm binary version uploaded by the gateway process
         when it comes online.
        '''

    def __repr__(self):
        return '<sdm.Relay ' + \
            'device: ' + repr(self.device) + ' ' +\
            'gateway_filter: ' + repr(self.gateway_filter) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'location: ' + repr(self.location) + ' ' +\
            'maintenance_windows: ' + repr(self.maintenance_windows) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'state: ' + repr(self.state) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'version: ' + repr(self.version) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'device': self.device,
            'gateway_filter': self.gateway_filter,
            'id': self.id,
            'location': self.location,
            'maintenance_windows': self.maintenance_windows,
            'name': self.name,
            'state': self.state,
            'tags': self.tags,
            'version': self.version,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            device=d.get('device'),
            gateway_filter=d.get('gateway_filter'),
            id=d.get('id'),
            location=d.get('location'),
            maintenance_windows=d.get('maintenance_windows'),
            name=d.get('name'),
            state=d.get('state'),
            tags=d.get('tags'),
            version=d.get('version'),
        )


class RemoteIdentity:
    '''
         RemoteIdentities define the username to be used for a specific account
     when connecting to a remote resource using that group.
    '''
    __slots__ = [
        'account_id',
        'id',
        'remote_identity_group_id',
        'username',
    ]

    def __init__(
        self,
        account_id=None,
        id=None,
        remote_identity_group_id=None,
        username=None,
    ):
        self.account_id = account_id if account_id is not None else ''
        '''
         The account for this remote identity.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the RemoteIdentity.
        '''
        self.remote_identity_group_id = remote_identity_group_id if remote_identity_group_id is not None else ''
        '''
         The remote identity group.
        '''
        self.username = username if username is not None else ''
        '''
         The username to be used as the remote identity for this account.
        '''

    def __repr__(self):
        return '<sdm.RemoteIdentity ' + \
            'account_id: ' + repr(self.account_id) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'remote_identity_group_id: ' + repr(self.remote_identity_group_id) + ' ' +\
            'username: ' + repr(self.username) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'account_id': self.account_id,
            'id': self.id,
            'remote_identity_group_id': self.remote_identity_group_id,
            'username': self.username,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            account_id=d.get('account_id'),
            id=d.get('id'),
            remote_identity_group_id=d.get('remote_identity_group_id'),
            username=d.get('username'),
        )


class RemoteIdentityCreateResponse:
    '''
         RemoteIdentityCreateResponse reports how the RemoteIdentities were created in the system.
    '''
    __slots__ = [
        'meta',
        'rate_limit',
        'remote_identity',
    ]

    def __init__(
        self,
        meta=None,
        rate_limit=None,
        remote_identity=None,
    ):
        self.meta = meta if meta is not None else None
        '''
         Reserved for future use.
        '''
        self.rate_limit = rate_limit if rate_limit is not None else None
        '''
         Rate limit information.
        '''
        self.remote_identity = remote_identity if remote_identity is not None else None
        '''
         The created RemoteIdentity.
        '''

    def __repr__(self):
        return '<sdm.RemoteIdentityCreateResponse ' + \
            'meta: ' + repr(self.meta) + ' ' +\
            'rate_limit: ' + repr(self.rate_limit) + ' ' +\
            'remote_identity: ' + repr(self.remote_identity) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'meta': self.meta,
            'rate_limit': self.rate_limit,
            'remote_identity': self.remote_identity,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            meta=d.get('meta'),
            rate_limit=d.get('rate_limit'),
            remote_identity=d.get('remote_identity'),
        )


class RemoteIdentityDeleteResponse:
    '''
         RemoteIdentityDeleteResponse returns information about a RemoteIdentity that was deleted.
    '''
    __slots__ = [
        'meta',
        'rate_limit',
    ]

    def __init__(
        self,
        meta=None,
        rate_limit=None,
    ):
        self.meta = meta if meta is not None else None
        '''
         Reserved for future use.
        '''
        self.rate_limit = rate_limit if rate_limit is not None else None
        '''
         Rate limit information.
        '''

    def __repr__(self):
        return '<sdm.RemoteIdentityDeleteResponse ' + \
            'meta: ' + repr(self.meta) + ' ' +\
            'rate_limit: ' + repr(self.rate_limit) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'meta': self.meta,
            'rate_limit': self.rate_limit,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            meta=d.get('meta'),
            rate_limit=d.get('rate_limit'),
        )


class RemoteIdentityGetResponse:
    '''
         RemoteIdentityGetResponse returns a requested RemoteIdentity.
    '''
    __slots__ = [
        'meta',
        'rate_limit',
        'remote_identity',
    ]

    def __init__(
        self,
        meta=None,
        rate_limit=None,
        remote_identity=None,
    ):
        self.meta = meta if meta is not None else None
        '''
         Reserved for future use.
        '''
        self.rate_limit = rate_limit if rate_limit is not None else None
        '''
         Rate limit information.
        '''
        self.remote_identity = remote_identity if remote_identity is not None else None
        '''
         The requested RemoteIdentity.
        '''

    def __repr__(self):
        return '<sdm.RemoteIdentityGetResponse ' + \
            'meta: ' + repr(self.meta) + ' ' +\
            'rate_limit: ' + repr(self.rate_limit) + ' ' +\
            'remote_identity: ' + repr(self.remote_identity) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'meta': self.meta,
            'rate_limit': self.rate_limit,
            'remote_identity': self.remote_identity,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            meta=d.get('meta'),
            rate_limit=d.get('rate_limit'),
            remote_identity=d.get('remote_identity'),
        )


class RemoteIdentityGroup:
    '''
         A RemoteIdentityGroup defines a group of remote identities.
    '''
    __slots__ = [
        'id',
        'name',
    ]

    def __init__(
        self,
        id=None,
        name=None,
    ):
        self.id = id if id is not None else ''
        '''
         Unique identifier of the RemoteIdentityGroup.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the RemoteIdentityGroup.
        '''

    def __repr__(self):
        return '<sdm.RemoteIdentityGroup ' + \
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'id': self.id,
            'name': self.name,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            id=d.get('id'),
            name=d.get('name'),
        )


class RemoteIdentityGroupGetResponse:
    '''
         RemoteIdentityGroupGetResponse returns a requested RemoteIdentityGroup.
    '''
    __slots__ = [
        'meta',
        'rate_limit',
        'remote_identity_group',
    ]

    def __init__(
        self,
        meta=None,
        rate_limit=None,
        remote_identity_group=None,
    ):
        self.meta = meta if meta is not None else None
        '''
         Reserved for future use.
        '''
        self.rate_limit = rate_limit if rate_limit is not None else None
        '''
         Rate limit information.
        '''
        self.remote_identity_group = remote_identity_group if remote_identity_group is not None else None
        '''
         The requested RemoteIdentityGroup.
        '''

    def __repr__(self):
        return '<sdm.RemoteIdentityGroupGetResponse ' + \
            'meta: ' + repr(self.meta) + ' ' +\
            'rate_limit: ' + repr(self.rate_limit) + ' ' +\
            'remote_identity_group: ' + repr(self.remote_identity_group) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'meta': self.meta,
            'rate_limit': self.rate_limit,
            'remote_identity_group': self.remote_identity_group,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            meta=d.get('meta'),
            rate_limit=d.get('rate_limit'),
            remote_identity_group=d.get('remote_identity_group'),
        )


class RemoteIdentityGroupHistory:
    '''
         RemoteIdentityGroupHistory records the state of a RemoteIdentityGroup at a given point in time,
     where every change (create, update and delete) to a RemoteIdentityGroup produces an
     RemoteIdentityGroupHistory record.
    '''
    __slots__ = [
        'activity_id',
        'deleted_at',
        'remote_identity_group',
        'timestamp',
    ]

    def __init__(
        self,
        activity_id=None,
        deleted_at=None,
        remote_identity_group=None,
        timestamp=None,
    ):
        self.activity_id = activity_id if activity_id is not None else ''
        '''
         The unique identifier of the Activity that produced this change to the RemoteIdentityGroup.
         May be empty for some system-initiated updates.
        '''
        self.deleted_at = deleted_at if deleted_at is not None else None
        '''
         If this RemoteIdentityGroup was deleted, the time it was deleted.
        '''
        self.remote_identity_group = remote_identity_group if remote_identity_group is not None else None
        '''
         The complete RemoteIdentityGroup state at this time.
        '''
        self.timestamp = timestamp if timestamp is not None else None
        '''
         The time at which the RemoteIdentityGroup state was recorded.
        '''

    def __repr__(self):
        return '<sdm.RemoteIdentityGroupHistory ' + \
            'activity_id: ' + repr(self.activity_id) + ' ' +\
            'deleted_at: ' + repr(self.deleted_at) + ' ' +\
            'remote_identity_group: ' + repr(self.remote_identity_group) + ' ' +\
            'timestamp: ' + repr(self.timestamp) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'activity_id': self.activity_id,
            'deleted_at': self.deleted_at,
            'remote_identity_group': self.remote_identity_group,
            'timestamp': self.timestamp,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            activity_id=d.get('activity_id'),
            deleted_at=d.get('deleted_at'),
            remote_identity_group=d.get('remote_identity_group'),
            timestamp=d.get('timestamp'),
        )


class RemoteIdentityHistory:
    '''
         RemoteIdentityHistory records the state of a RemoteIdentity at a given point in time,
     where every change (create, update and delete) to a RemoteIdentity produces an
     RemoteIdentityHistory record.
    '''
    __slots__ = [
        'activity_id',
        'deleted_at',
        'remote_identity',
        'timestamp',
    ]

    def __init__(
        self,
        activity_id=None,
        deleted_at=None,
        remote_identity=None,
        timestamp=None,
    ):
        self.activity_id = activity_id if activity_id is not None else ''
        '''
         The unique identifier of the Activity that produced this change to the RemoteIdentity.
         May be empty for some system-initiated updates.
        '''
        self.deleted_at = deleted_at if deleted_at is not None else None
        '''
         If this RemoteIdentity was deleted, the time it was deleted.
        '''
        self.remote_identity = remote_identity if remote_identity is not None else None
        '''
         The complete RemoteIdentity state at this time.
        '''
        self.timestamp = timestamp if timestamp is not None else None
        '''
         The time at which the RemoteIdentity state was recorded.
        '''

    def __repr__(self):
        return '<sdm.RemoteIdentityHistory ' + \
            'activity_id: ' + repr(self.activity_id) + ' ' +\
            'deleted_at: ' + repr(self.deleted_at) + ' ' +\
            'remote_identity: ' + repr(self.remote_identity) + ' ' +\
            'timestamp: ' + repr(self.timestamp) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'activity_id': self.activity_id,
            'deleted_at': self.deleted_at,
            'remote_identity': self.remote_identity,
            'timestamp': self.timestamp,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            activity_id=d.get('activity_id'),
            deleted_at=d.get('deleted_at'),
            remote_identity=d.get('remote_identity'),
            timestamp=d.get('timestamp'),
        )


class RemoteIdentityUpdateResponse:
    '''
         RemoteIdentityUpdateResponse returns the fields of a RemoteIdentity after it has been updated by
     a RemoteIdentityUpdateRequest.
    '''
    __slots__ = [
        'meta',
        'rate_limit',
        'remote_identity',
    ]

    def __init__(
        self,
        meta=None,
        rate_limit=None,
        remote_identity=None,
    ):
        self.meta = meta if meta is not None else None
        '''
         Reserved for future use.
        '''
        self.rate_limit = rate_limit if rate_limit is not None else None
        '''
         Rate limit information.
        '''
        self.remote_identity = remote_identity if remote_identity is not None else None
        '''
         The updated RemoteIdentity.
        '''

    def __repr__(self):
        return '<sdm.RemoteIdentityUpdateResponse ' + \
            'meta: ' + repr(self.meta) + ' ' +\
            'rate_limit: ' + repr(self.rate_limit) + ' ' +\
            'remote_identity: ' + repr(self.remote_identity) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'meta': self.meta,
            'rate_limit': self.rate_limit,
            'remote_identity': self.remote_identity,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            meta=d.get('meta'),
            rate_limit=d.get('rate_limit'),
            remote_identity=d.get('remote_identity'),
        )


class ReplayChunk:
    '''
         A ReplayChunk represents a single "chunk" of data from the query replay.
    '''
    __slots__ = [
        'data',
        'events',
        'symmetric_key',
    ]

    def __init__(
        self,
        data=None,
        events=None,
        symmetric_key=None,
    ):
        self.data = data if data is not None else b''
        '''
         The raw data of the ReplayChunk. The data is encrypted if the associated Query is encrypted.
        '''
        self.events = events if events is not None else []
        '''
         The list of events of the ReplayChunk. If the Query is encrypted, this field is always empty
         and the events can be obtained by decrypting the data using the QueryKey returned with the Query.
        '''
        self.symmetric_key = symmetric_key if symmetric_key is not None else ''
        '''
         If the data is encrypted, this contains the encrypted symmetric key
        '''

    def __repr__(self):
        return '<sdm.ReplayChunk ' + \
            'data: ' + repr(self.data) + ' ' +\
            'events: ' + repr(self.events) + ' ' +\
            'symmetric_key: ' + repr(self.symmetric_key) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'data': self.data,
            'events': self.events,
            'symmetric_key': self.symmetric_key,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            data=d.get('data'),
            events=d.get('events'),
            symmetric_key=d.get('symmetric_key'),
        )


class ReplayChunkEvent:
    '''
         A ReplayChunkEvent represents a single event within a query replay.
     The timing information included in each ReplayChunkEvent may be used to replay a session in real time.
    '''
    __slots__ = [
        'data',
        'duration',
    ]

    def __init__(
        self,
        data=None,
        duration=None,
    ):
        self.data = data if data is not None else b''
        '''
         The raw data of the ReplayChunkEvent.
        '''
        self.duration = duration if duration is not None else None
        '''
         The time duration over which the data in this ReplayChunkEvent was transferred.
        '''

    def __repr__(self):
        return '<sdm.ReplayChunkEvent ' + \
            'data: ' + repr(self.data) + ' ' +\
            'duration: ' + repr(self.duration) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'data': self.data,
            'duration': self.duration,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            data=d.get('data'),
            duration=d.get('duration'),
        )


class RequestableResource:
    '''
         RequestableResource is a resource that can be requested via an AccessRequestConfig
    '''
    __slots__ = [
        'access',
        'authentication',
        'healthy',
        'id',
        'name',
        'tags',
        'type',
    ]

    def __init__(
        self,
        access=None,
        authentication=None,
        healthy=None,
        id=None,
        name=None,
        tags=None,
        type=None,
    ):
        self.access = access if access is not None else ''
        '''
         The current state of the user's access to the resources
        '''
        self.authentication = authentication if authentication is not None else ''
        '''
         The type of authentication for the resource
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         The health check status of the reasource
        '''
        self.id = id if id is not None else ''
        '''
         The resource id.
        '''
        self.name = name if name is not None else ''
        '''
         The resource name.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Any tags attached to this resource
        '''
        self.type = type if type is not None else ''
        '''
         The resource type
        '''

    def __repr__(self):
        return '<sdm.RequestableResource ' + \
            'access: ' + repr(self.access) + ' ' +\
            'authentication: ' + repr(self.authentication) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'type: ' + repr(self.type) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'access': self.access,
            'authentication': self.authentication,
            'healthy': self.healthy,
            'id': self.id,
            'name': self.name,
            'tags': self.tags,
            'type': self.type,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            access=d.get('access'),
            authentication=d.get('authentication'),
            healthy=d.get('healthy'),
            id=d.get('id'),
            name=d.get('name'),
            tags=d.get('tags'),
            type=d.get('type'),
        )


class ResourceCreateResponse:
    '''
         ResourceCreateResponse reports how the Resources were created in the system.
    '''
    __slots__ = [
        'meta',
        'rate_limit',
        'resource',
    ]

    def __init__(
        self,
        meta=None,
        rate_limit=None,
        resource=None,
    ):
        self.meta = meta if meta is not None else None
        '''
         Reserved for future use.
        '''
        self.rate_limit = rate_limit if rate_limit is not None else None
        '''
         Rate limit information.
        '''
        self.resource = resource if resource is not None else None
        '''
         The created Resource.
        '''

    def __repr__(self):
        return '<sdm.ResourceCreateResponse ' + \
            'meta: ' + repr(self.meta) + ' ' +\
            'rate_limit: ' + repr(self.rate_limit) + ' ' +\
            'resource: ' + repr(self.resource) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'meta': self.meta,
            'rate_limit': self.rate_limit,
            'resource': self.resource,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            meta=d.get('meta'),
            rate_limit=d.get('rate_limit'),
            resource=d.get('resource'),
        )


class ResourceDeleteResponse:
    '''
         ResourceDeleteResponse returns information about a Resource that was deleted.
    '''
    __slots__ = [
        'meta',
        'rate_limit',
    ]

    def __init__(
        self,
        meta=None,
        rate_limit=None,
    ):
        self.meta = meta if meta is not None else None
        '''
         Reserved for future use.
        '''
        self.rate_limit = rate_limit if rate_limit is not None else None
        '''
         Rate limit information.
        '''

    def __repr__(self):
        return '<sdm.ResourceDeleteResponse ' + \
            'meta: ' + repr(self.meta) + ' ' +\
            'rate_limit: ' + repr(self.rate_limit) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'meta': self.meta,
            'rate_limit': self.rate_limit,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            meta=d.get('meta'),
            rate_limit=d.get('rate_limit'),
        )


class ResourceGetResponse:
    '''
         ResourceGetResponse returns a requested Resource.
    '''
    __slots__ = [
        'meta',
        'rate_limit',
        'resource',
    ]

    def __init__(
        self,
        meta=None,
        rate_limit=None,
        resource=None,
    ):
        self.meta = meta if meta is not None else None
        '''
         Reserved for future use.
        '''
        self.rate_limit = rate_limit if rate_limit is not None else None
        '''
         Rate limit information.
        '''
        self.resource = resource if resource is not None else None
        '''
         The requested Resource.
        '''

    def __repr__(self):
        return '<sdm.ResourceGetResponse ' + \
            'meta: ' + repr(self.meta) + ' ' +\
            'rate_limit: ' + repr(self.rate_limit) + ' ' +\
            'resource: ' + repr(self.resource) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'meta': self.meta,
            'rate_limit': self.rate_limit,
            'resource': self.resource,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            meta=d.get('meta'),
            rate_limit=d.get('rate_limit'),
            resource=d.get('resource'),
        )


class ResourceHealthcheckRequest:
    '''
         ResourceHealthcheckRequest specifies requesting a healthcheck for a given resource by ID.
    '''
    __slots__ = [
        'id',
    ]

    def __init__(
        self,
        id=None,
    ):
        self.id = id if id is not None else ''
        '''
         The unique identifier of the Resource to healthcheck.
        '''

    def __repr__(self):
        return '<sdm.ResourceHealthcheckRequest ' + \
            'id: ' + repr(self.id) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'id': self.id,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(id=d.get('id'), )


class ResourceHealthcheckResponse:
    '''
         ResourceHealthcheckResponse reports any metadata concerning a healthcheck response.
     Healthchecks are non blocking, and this contains no non-metadata.
    '''
    __slots__ = [
        'meta',
        'rate_limit',
    ]

    def __init__(
        self,
        meta=None,
        rate_limit=None,
    ):
        self.meta = meta if meta is not None else None
        '''
         Reserved for future use.
        '''
        self.rate_limit = rate_limit if rate_limit is not None else None
        '''
         Rate limit information.
        '''

    def __repr__(self):
        return '<sdm.ResourceHealthcheckResponse ' + \
            'meta: ' + repr(self.meta) + ' ' +\
            'rate_limit: ' + repr(self.rate_limit) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'meta': self.meta,
            'rate_limit': self.rate_limit,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            meta=d.get('meta'),
            rate_limit=d.get('rate_limit'),
        )


class ResourceHistory:
    '''
         ResourceHistory records the state of a Resource at a given point in time,
     where every change (create, update and delete) to a Resource produces an
     ResourceHistory record.
    '''
    __slots__ = [
        'activity_id',
        'deleted_at',
        'resource',
        'timestamp',
    ]

    def __init__(
        self,
        activity_id=None,
        deleted_at=None,
        resource=None,
        timestamp=None,
    ):
        self.activity_id = activity_id if activity_id is not None else ''
        '''
         The unique identifier of the Activity that produced this change to the Resource.
         May be empty for some system-initiated updates.
        '''
        self.deleted_at = deleted_at if deleted_at is not None else None
        '''
         If this Resource was deleted, the time it was deleted.
        '''
        self.resource = resource if resource is not None else None
        '''
         The complete Resource state at this time.
        '''
        self.timestamp = timestamp if timestamp is not None else None
        '''
         The time at which the Resource state was recorded.
        '''

    def __repr__(self):
        return '<sdm.ResourceHistory ' + \
            'activity_id: ' + repr(self.activity_id) + ' ' +\
            'deleted_at: ' + repr(self.deleted_at) + ' ' +\
            'resource: ' + repr(self.resource) + ' ' +\
            'timestamp: ' + repr(self.timestamp) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'activity_id': self.activity_id,
            'deleted_at': self.deleted_at,
            'resource': self.resource,
            'timestamp': self.timestamp,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            activity_id=d.get('activity_id'),
            deleted_at=d.get('deleted_at'),
            resource=d.get('resource'),
            timestamp=d.get('timestamp'),
        )


class ResourceUpdateResponse:
    '''
         ResourceUpdateResponse returns the fields of a Resource after it has been updated by
     a ResourceUpdateRequest.
    '''
    __slots__ = [
        'meta',
        'rate_limit',
        'resource',
    ]

    def __init__(
        self,
        meta=None,
        rate_limit=None,
        resource=None,
    ):
        self.meta = meta if meta is not None else None
        '''
         Reserved for future use.
        '''
        self.rate_limit = rate_limit if rate_limit is not None else None
        '''
         Rate limit information.
        '''
        self.resource = resource if resource is not None else None
        '''
         The updated Resource.
        '''

    def __repr__(self):
        return '<sdm.ResourceUpdateResponse ' + \
            'meta: ' + repr(self.meta) + ' ' +\
            'rate_limit: ' + repr(self.rate_limit) + ' ' +\
            'resource: ' + repr(self.resource) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'meta': self.meta,
            'rate_limit': self.rate_limit,
            'resource': self.resource,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            meta=d.get('meta'),
            rate_limit=d.get('rate_limit'),
            resource=d.get('resource'),
        )


class Role:
    '''
         A Role has a list of access rules which determine which Resources the members
     of the Role have access to. An Account can be a member of multiple Roles via
     AccountAttachments.
    '''
    __slots__ = [
        'access_rules',
        'id',
        'managed_by',
        'name',
        'tags',
    ]

    def __init__(
        self,
        access_rules=None,
        id=None,
        managed_by=None,
        name=None,
        tags=None,
    ):
        self.access_rules = access_rules if access_rules is not None else _porcelain_zero_value_access_rules(
        )
        '''
         AccessRules is a list of access rules defining the resources this Role has access to.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Role.
        '''
        self.managed_by = managed_by if managed_by is not None else ''
        '''
         Managed By is a read only field for what service manages this role, e.g. StrongDM, Okta, Azure.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Role.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''

    def __repr__(self):
        return '<sdm.Role ' + \
            'access_rules: ' + repr(self.access_rules) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'managed_by: ' + repr(self.managed_by) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'access_rules': self.access_rules,
            'id': self.id,
            'managed_by': self.managed_by,
            'name': self.name,
            'tags': self.tags,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            access_rules=d.get('access_rules'),
            id=d.get('id'),
            managed_by=d.get('managed_by'),
            name=d.get('name'),
            tags=d.get('tags'),
        )


class RoleCreateResponse:
    '''
         RoleCreateResponse reports how the Roles were created in the system. It can
     communicate partial successes or failures.
    '''
    __slots__ = [
        'meta',
        'rate_limit',
        'role',
    ]

    def __init__(
        self,
        meta=None,
        rate_limit=None,
        role=None,
    ):
        self.meta = meta if meta is not None else None
        '''
         Reserved for future use.
        '''
        self.rate_limit = rate_limit if rate_limit is not None else None
        '''
         Rate limit information.
        '''
        self.role = role if role is not None else None
        '''
         The created Role.
        '''

    def __repr__(self):
        return '<sdm.RoleCreateResponse ' + \
            'meta: ' + repr(self.meta) + ' ' +\
            'rate_limit: ' + repr(self.rate_limit) + ' ' +\
            'role: ' + repr(self.role) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'meta': self.meta,
            'rate_limit': self.rate_limit,
            'role': self.role,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            meta=d.get('meta'),
            rate_limit=d.get('rate_limit'),
            role=d.get('role'),
        )


class RoleDeleteResponse:
    '''
         RoleDeleteResponse returns information about a Role that was deleted.
    '''
    __slots__ = [
        'meta',
        'rate_limit',
    ]

    def __init__(
        self,
        meta=None,
        rate_limit=None,
    ):
        self.meta = meta if meta is not None else None
        '''
         Reserved for future use.
        '''
        self.rate_limit = rate_limit if rate_limit is not None else None
        '''
         Rate limit information.
        '''

    def __repr__(self):
        return '<sdm.RoleDeleteResponse ' + \
            'meta: ' + repr(self.meta) + ' ' +\
            'rate_limit: ' + repr(self.rate_limit) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'meta': self.meta,
            'rate_limit': self.rate_limit,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            meta=d.get('meta'),
            rate_limit=d.get('rate_limit'),
        )


class RoleGetResponse:
    '''
         RoleGetResponse returns a requested Role.
    '''
    __slots__ = [
        'meta',
        'rate_limit',
        'role',
    ]

    def __init__(
        self,
        meta=None,
        rate_limit=None,
        role=None,
    ):
        self.meta = meta if meta is not None else None
        '''
         Reserved for future use.
        '''
        self.rate_limit = rate_limit if rate_limit is not None else None
        '''
         Rate limit information.
        '''
        self.role = role if role is not None else None
        '''
         The requested Role.
        '''

    def __repr__(self):
        return '<sdm.RoleGetResponse ' + \
            'meta: ' + repr(self.meta) + ' ' +\
            'rate_limit: ' + repr(self.rate_limit) + ' ' +\
            'role: ' + repr(self.role) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'meta': self.meta,
            'rate_limit': self.rate_limit,
            'role': self.role,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            meta=d.get('meta'),
            rate_limit=d.get('rate_limit'),
            role=d.get('role'),
        )


class RoleHistory:
    '''
         RoleHistory records the state of a Role at a given point in time,
     where every change (create, update and delete) to a Role produces an
     RoleHistory record.
    '''
    __slots__ = [
        'activity_id',
        'deleted_at',
        'role',
        'timestamp',
    ]

    def __init__(
        self,
        activity_id=None,
        deleted_at=None,
        role=None,
        timestamp=None,
    ):
        self.activity_id = activity_id if activity_id is not None else ''
        '''
         The unique identifier of the Activity that produced this change to the Role.
         May be empty for some system-initiated updates.
        '''
        self.deleted_at = deleted_at if deleted_at is not None else None
        '''
         If this Role was deleted, the time it was deleted.
        '''
        self.role = role if role is not None else None
        '''
         The complete Role state at this time.
        '''
        self.timestamp = timestamp if timestamp is not None else None
        '''
         The time at which the Role state was recorded.
        '''

    def __repr__(self):
        return '<sdm.RoleHistory ' + \
            'activity_id: ' + repr(self.activity_id) + ' ' +\
            'deleted_at: ' + repr(self.deleted_at) + ' ' +\
            'role: ' + repr(self.role) + ' ' +\
            'timestamp: ' + repr(self.timestamp) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'activity_id': self.activity_id,
            'deleted_at': self.deleted_at,
            'role': self.role,
            'timestamp': self.timestamp,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            activity_id=d.get('activity_id'),
            deleted_at=d.get('deleted_at'),
            role=d.get('role'),
            timestamp=d.get('timestamp'),
        )


class RoleResource:
    '''
         RoleResource represents an individual access grant of a Role to a Resource.
    '''
    __slots__ = [
        'granted_at',
        'resource_id',
        'role_id',
    ]

    def __init__(
        self,
        granted_at=None,
        resource_id=None,
        role_id=None,
    ):
        self.granted_at = granted_at if granted_at is not None else None
        '''
         The most recent time at which access was granted. If access was granted,
         revoked, and granted again, this will reflect the later time.
        '''
        self.resource_id = resource_id if resource_id is not None else ''
        '''
         The unique identifier of the Resource to which access is granted.
        '''
        self.role_id = role_id if role_id is not None else ''
        '''
         The unique identifier of the Role to which access is granted.
        '''

    def __repr__(self):
        return '<sdm.RoleResource ' + \
            'granted_at: ' + repr(self.granted_at)