/* /////////////////////////////////////////////////////////////////////////
 * File:        stlsoft/meta/typefixers.hpp
 *
 * Purpose:     Combined header file for STLSoft's TypeFixer utility components.
 *
 * Created:     24th April 2005
 * Updated:     10th August 2009
 *
 * Home:        http://stlsoft.org/
 *
 * Copyright (c) 2005-2009, Matthew Wilson and Synesis Software
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * - Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.
 * - Redistributions in binary form must reproduce the above copyright notice,
 *   this list of conditions and the following disclaimer in the documentation
 *   and/or other materials provided with the distribution.
 * - Neither the name(s) of Matthew Wilson and Synesis Software nor the names of
 *   any contributors may be used to endorse or promote products derived from
 *   this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * ////////////////////////////////////////////////////////////////////// */


/** \file stlsoft/meta/typefixers.hpp
 *
 * \brief [C++ only] Common include file for all typefixer class templates
 *   (\ref group__library__meta "Template Meta-programming" Library).
 */

#ifndef STLSOFT_INCL_STLSOFT_META_HPP_TYPEFIXERS
#define STLSOFT_INCL_STLSOFT_META_HPP_TYPEFIXERS

#ifndef STLSOFT_DOCUMENTATION_SKIP_SECTION
# define STLSOFT_VER_STLSOFT_META_HPP_TYPEFIXERS_MAJOR      2
# define STLSOFT_VER_STLSOFT_META_HPP_TYPEFIXERS_MINOR      0
# define STLSOFT_VER_STLSOFT_META_HPP_TYPEFIXERS_REVISION   1
# define STLSOFT_VER_STLSOFT_META_HPP_TYPEFIXERS_EDIT       11
#endif /* !STLSOFT_DOCUMENTATION_SKIP_SECTION */

/* /////////////////////////////////////////////////////////////////////////
 * Auto-generation and compatibility
 */

/*
[<[STLSOFT-AUTO:NO-UNITTEST]>]
[Incompatibilies-start]
STLSOFT_COMPILER_IS_MSVC: _MSC_VER < 1310
[Incompatibilies-end]
*/

/* /////////////////////////////////////////////////////////////////////////
 * Includes
 */

#ifndef STLSOFT_INCL_STLSOFT_H_STLSOFT
# include <stlsoft/stlsoft.h>
#endif /* !STLSOFT_INCL_STLSOFT_H_STLSOFT */

#ifndef STLSOFT_INCL_STLSOFT_META_TYPEFIXER_HPP_TYPEFIXER
# include <stlsoft/meta/typefixer/typefixer.hpp>
#endif /* !STLSOFT_INCL_STLSOFT_META_TYPEFIXER_HPP_TYPEFIXER */

#ifndef STLSOFT_INCL_STLSOFT_META_TYPEFIXER_HPP_DIFFERENCE_TYPE
# include <stlsoft/meta/typefixer/difference_type.hpp>
#endif /* !STLSOFT_INCL_STLSOFT_META_TYPEFIXER_HPP_DIFFERENCE_TYPE */

#ifndef STLSOFT_INCL_STLSOFT_META_TYPEFIXER_HPP_ITERATOR
# include <stlsoft/meta/typefixer/iterator.hpp>
#endif /* !STLSOFT_INCL_STLSOFT_META_TYPEFIXER_HPP_ITERATOR */

#ifndef STLSOFT_INCL_STLSOFT_META_TYPEFIXER_HPP_MAPPED_TYPE
# include <stlsoft/meta/typefixer/mapped_type.hpp>
#endif /* !STLSOFT_INCL_STLSOFT_META_TYPEFIXER_HPP_MAPPED_TYPE */

#ifndef STLSOFT_INCL_STLSOFT_META_TYPEFIXER_HPP_POINTER
# include <stlsoft/meta/typefixer/pointer.hpp>
#endif /* !STLSOFT_INCL_STLSOFT_META_TYPEFIXER_HPP_POINTER */

#ifndef STLSOFT_INCL_STLSOFT_META_TYPEFIXER_HPP_POINTER_TYPE
# include <stlsoft/meta/typefixer/pointer_type.hpp>
#endif /* !STLSOFT_INCL_STLSOFT_META_TYPEFIXER_HPP_POINTER_TYPE */

#ifndef STLSOFT_INCL_STLSOFT_META_TYPEFIXER_HPP_REFERENCE
# include <stlsoft/meta/typefixer/reference.hpp>
#endif /* !STLSOFT_INCL_STLSOFT_META_TYPEFIXER_HPP_REFERENCE */

#ifndef STLSOFT_INCL_STLSOFT_META_TYPEFIXER_HPP_REFERENCE_TYPE
# include <stlsoft/meta/typefixer/reference_type.hpp>
#endif /* !STLSOFT_INCL_STLSOFT_META_TYPEFIXER_HPP_REFERENCE_TYPE */

#ifndef STLSOFT_INCL_STLSOFT_META_TYPEFIXER_HPP_REFERENT_TYPE
# include <stlsoft/meta/typefixer/referent_type.hpp>
#endif /* !STLSOFT_INCL_STLSOFT_META_TYPEFIXER_HPP_REFERENT_TYPE */

/* ////////////////////////////////////////////////////////////////////// */

#endif /* !STLSOFT_INCL_STLSOFT_META_HPP_TYPEFIXERS */

/* ///////////////////////////// end of file //////////////////////////// */
