# -*- coding: utf-8 -*-
r"""
Laue Monochromator
------------------

Bending of a single crystal Laue Monochromator
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

Files in ``\examples\withRaycing\03_LaueMono``

This example shows the reflectivity of a bent 200-µm-thick Si111 Laue crystal
at various bending radii and energies. Watch how the band width is growing and
the flux is lowering in going to smaller radii.

+----------------+----------------+----------------+----------------+
|  *E* = 9 keV   |  *E* = 16 keV  |  *E* = 25 keV  |  *E* = 36 keV  |
+================+================+================+================+
|  |E09| |E09Z|  |  |E16| |E16Z|  |  |E25| |E25Z|  |  |E36| |E36Z|  |
+----------------+----------------+----------------+----------------+

.. |E09| image:: _images/BentLaueSCM09keV.swf
   :width: 300
   :height: 205
.. |E09Z| image:: _images/zoomIcon.png
   :width: 20
   :target: _images/BentLaueSCM09keV.swf
.. |E16| image:: _images/BentLaueSCM16keV.swf
   :width: 300
   :height: 205
.. |E16Z| image:: _images/zoomIcon.png
   :width: 20
   :target: _images/BentLaueSCM16keV.swf
.. |E25| image:: _images/BentLaueSCM25keV.swf
   :width: 300
   :height: 205
.. |E25Z| image:: _images/zoomIcon.png
   :width: 20
   :target: _images/BentLaueSCM25keV.swf
.. |E36| image:: _images/BentLaueSCM36keV.swf
   :width: 300
   :height: 205
.. |E36Z| image:: _images/zoomIcon.png
   :width: 20
   :target: _images/BentLaueSCM36keV.swf

Double bent-crystal Laue monochromator (beam cleaner)
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

This example shows the beam images and rocking curves of a bent 200-µm-thick
Si111 double Laue crystal monochromator (similar to the *beam cleaner*
[Karanfil2004]_) at various bending radii and energies.

.. [Karanfil2004] C. Karanfil, D. Chapman, C. U. Segre and G. Bunker, *A device
   for selecting and rejecting X-ray harmonics in synchrotron radiation beams*,
   J. Synchrotron Rad. **11** (2004) 393-8.

Beam images at various detuning angles of the second crystal, *R* = 5 m, *E* ~
9 keV. Watch how the energy band becomes split and the flux goes down in going
away from the parallel positioning (*dθ* = 0).

.. image:: _images/BentLaueDCM09keV.swf
   :width: 300
   :height: 205
.. image:: _images/zoomIcon.png
   :width: 20
   :target: _images/BentLaueDCM09keV.swf

Flux vs. detuning angle of the second crystal (rocking curves)

+------------------+------------------+------------------+------------------+
|   *E* = 9 keV    |   *E* = 16 keV   |  *E* = 25 keV    |   *E* = 36 keV   |
+==================+==================+==================+==================+
|  |rc09| |rc09Z|  |  |rc16| |rc16Z|  |  |rc25| |rc25Z|  |  |rc36| |rc36Z|  |
+------------------+------------------+------------------+------------------+

.. |rc09| image:: _images/BentLaueDCM_rc09keV.swf
   :width: 300
   :height: 205
.. |rc09Z| image:: _images/zoomIcon.png
   :width: 20
   :target: _images/BentLaueDCM_rc09keV.swf
.. |rc16| image:: _images/BentLaueDCM_rc16keV.swf
   :width: 300
   :height: 205
.. |rc16Z| image:: _images/zoomIcon.png
   :width: 20
   :target: _images/BentLaueDCM_rc16keV.swf
.. |rc25| image:: _images/BentLaueDCM_rc25keV.swf
   :width: 300
   :height: 205
.. |rc25Z| image:: _images/zoomIcon.png
   :width: 20
   :target: _images/BentLaueDCM_rc25keV.swf
.. |rc36| image:: _images/BentLaueDCM_rc36keV.swf
   :width: 300
   :height: 205
.. |rc36Z| image:: _images/zoomIcon.png
   :width: 20
   :target: _images/BentLaueDCM_rc36keV.swf
"""
pass
