/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.proactive.extensions.dataspaces.vfs.selector;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import org.apache.commons.vfs2.FileSelectInfo;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.provider.UriParser;
import org.apache.log4j.Logger;
import org.objectweb.proactive.annotation.PublicAPI;
import org.springframework.util.AntPathMatcher;

@PublicAPI
@XmlAccessorType(value=XmlAccessType.FIELD)
public class FileSelector
implements org.apache.commons.vfs2.FileSelector,
Serializable {
    private static final Logger log = Logger.getLogger(FileSelector.class);
    private static final String PREFIX_GLOB_PATTERN = "glob:";
    private static final String PREFIX_REGEX_PATTERN = "regex:";
    private Set<String> includes;
    private Set<String> excludes;
    private final transient FileSystem fileSystem = FileSystems.getDefault();
    private final transient Map<String, PathMatcher> pathMatcherCache;
    private static final long serialVersionUID = 131L;

    public FileSelector() {
        this.includes = new HashSet<String>();
        this.excludes = new HashSet<String>();
        this.pathMatcherCache = new HashMap<String, PathMatcher>();
    }

    public FileSelector(Collection<String> includes, Collection<String> excludes) {
        this();
        this.addAll(this.includes, includes);
        this.addAll(this.excludes, excludes);
    }

    public FileSelector(String[] includes, String[] excludes) {
        this();
        this.addAll(this.includes, includes);
        this.addAll(this.excludes, excludes);
    }

    public FileSelector(String ... includes) {
        this();
        this.addAll(this.includes, includes);
    }

    public void clear() {
        this.includes.clear();
        this.excludes.clear();
    }

    public boolean includeFile(FileSelectInfo fileInfo) throws Exception {
        return this.matches(this.getFilePathRelativeToBaseURI(fileInfo));
    }

    public boolean matches(Path path) throws FileSystemException {
        boolean isDebugEnabled = log.isDebugEnabled();
        Path unescapedPath = Paths.get(UriParser.decode((String)path.toString()), new String[0]);
        if (isDebugEnabled) {
            log.debug((Object)("Checking file '" + unescapedPath + "'"));
        }
        if (this.matches(unescapedPath, this.includes)) {
            if (isDebugEnabled) {
                log.debug((Object)("Path '" + unescapedPath + "' matches an include pattern " + this.includes));
            }
            if (!this.matches(unescapedPath, this.excludes)) {
                if (isDebugEnabled) {
                    log.debug((Object)("Path '" + unescapedPath + "' matches no exclude pattern"));
                    log.debug((Object)("Path '" + unescapedPath + "' selected for copy."));
                }
                return true;
            }
        }
        return false;
    }

    private Path getFilePathRelativeToBaseURI(FileSelectInfo fileSelectInfo) throws FileSystemException {
        String baseURI = fileSelectInfo.getBaseFolder().getURL().toString();
        String fileURI = fileSelectInfo.getFile().getURL().toString();
        return this.fileSystem.getPath(this.getFilePathRelativeToBaseURI(baseURI, fileURI), new String[0]);
    }

    protected String getFilePathRelativeToBaseURI(String baseURI, String fileURI) throws FileSystemException {
        int nbSlashToIgnore = 0;
        for (int i = baseURI.length(); i < fileURI.length() && fileURI.charAt(i) == '/'; ++i) {
            ++nbSlashToIgnore;
        }
        return UriParser.decode((String)fileURI.substring(baseURI.length() + nbSlashToIgnore));
    }

    private boolean matches(Path path, Set<String> patterns) {
        if (patterns.isEmpty()) {
            return false;
        }
        if (patterns.contains(path.toString())) {
            return true;
        }
        for (PathMatcher pattern : this.asPathMatchers(patterns)) {
            if (!pattern.matches(path)) continue;
            return true;
        }
        return false;
    }

    private Set<PathMatcher> asPathMatchers(Collection<String> patterns) {
        HashSet<PathMatcher> result = new HashSet<PathMatcher>(patterns.size());
        for (String pattern : patterns) {
            result.add(this.asPathMatcher(pattern));
        }
        return result;
    }

    private PathMatcher asPathMatcher(String pattern) {
        if (!pattern.startsWith(PREFIX_GLOB_PATTERN) && !pattern.startsWith(PREFIX_REGEX_PATTERN)) {
            pattern = PREFIX_GLOB_PATTERN + pattern;
        }
        if (this.pathMatcherCache.containsKey(pattern)) {
            return this.pathMatcherCache.get(pattern);
        }
        PathMatcher matcher = this.fileSystem.getPathMatcher(pattern);
        this.pathMatcherCache.put(pattern, matcher);
        return matcher;
    }

    private String convertPathForAntPathMatcher(Path path, String targetSeparator) {
        String convertedPath = path.toString().replace("\\", targetSeparator).replace("/", targetSeparator);
        if (convertedPath.startsWith(targetSeparator)) {
            convertedPath = convertedPath.substring(targetSeparator.length());
        }
        return convertedPath;
    }

    public boolean traverseDescendents(FileSelectInfo fileInfo) throws Exception {
        Path path = this.getFilePathRelativeToBaseURI(fileInfo);
        return this.traverseDescendents(path);
    }

    public boolean traverseDescendents(Path path) {
        boolean atLeastOnePatternMatchSoFar = false;
        for (String include : this.includes) {
            if (include.startsWith(PREFIX_GLOB_PATTERN)) {
                include = include.replace(PREFIX_GLOB_PATTERN, "");
            } else if (include.startsWith(PREFIX_REGEX_PATTERN)) {
                return true;
            }
            if (include.contains("[") || include.contains("{")) {
                return true;
            }
            String targetSeparator = include.contains("\\") ? "\\" : "/";
            String convertedPath = this.convertPathForAntPathMatcher(path, targetSeparator);
            AntPathMatcher pathMatcher = new AntPathMatcher();
            pathMatcher.setPathSeparator(targetSeparator);
            pathMatcher.setCaseSensitive(false);
            try {
                atLeastOnePatternMatchSoFar = atLeastOnePatternMatchSoFar || pathMatcher.matchStart(include, convertedPath.toString());
            }
            catch (Exception e) {
                log.debug((Object)("Exception occurred while using AntPathMatcher with the pattern " + include), (Throwable)e);
                atLeastOnePatternMatchSoFar = true;
            }
        }
        return atLeastOnePatternMatchSoFar;
    }

    public void addIncludes(Collection<String> patterns) {
        this.addAll(this.includes, patterns);
    }

    public void addIncludes(String ... patterns) {
        this.addAll(this.includes, patterns);
    }

    public void addExcludes(Collection<String> patterns) {
        this.addAll(this.excludes, patterns);
    }

    public void addExcludes(String ... patterns) {
        this.addAll(this.excludes, patterns);
    }

    public Set<String> getIncludes() {
        return ImmutableSet.copyOf(this.includes);
    }

    public Set<String> getExcludes() {
        return ImmutableSet.copyOf(this.excludes);
    }

    public void setIncludes(Collection<String> patterns) {
        this.includes.clear();
        this.addAll(this.includes, patterns);
    }

    public void setIncludes(String ... patterns) {
        this.includes.clear();
        this.addAll(this.includes, patterns);
    }

    public void setExcludes(Collection<String> patterns) {
        this.excludes.clear();
        this.addAll(this.excludes, patterns);
    }

    public void setExcludes(String ... patterns) {
        this.excludes.clear();
        this.addAll(this.excludes, patterns);
    }

    public void transformIncludes(Function<String, String> function) {
        this.includes = Sets.newHashSet((Iterable)Collections2.transform(this.includes, function));
    }

    public void transformExcludes(Function<String, String> function) {
        this.excludes = Sets.newHashSet((Iterable)Collections2.transform(this.excludes, function));
    }

    private <T> void addAll(Set<T> receivingSet, Collection<T> elementsToAdd) {
        if (elementsToAdd != null && elementsToAdd.size() > 0) {
            receivingSet.addAll(elementsToAdd);
        }
    }

    @SafeVarargs
    private final <T> void addAll(Set<T> receivingSet, T ... elementsToAdd) {
        if (elementsToAdd != null && elementsToAdd.length > 0) {
            Collections.addAll(receivingSet, elementsToAdd);
        }
    }

    public String toString() {
        return "FileSelector{includes=" + this.includes + ", excludes=" + this.excludes + '}';
    }
}

