/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.proactive.core.util.converter;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import org.objectweb.proactive.core.util.converter.MakeDeepCopy;
import org.objectweb.proactive.core.util.converter.SunMarshalOutputStream;

public class ObjectToByteConverter {
    private static byte[] convert(Object o, MakeDeepCopy.ConversionMode conversionMode) throws IOException {
        return ObjectToByteConverter.standardConvert(o, conversionMode);
    }

    private static void writeToStream(ObjectOutputStream objectOutputStream, Object o) throws IOException {
        objectOutputStream.writeObject(o);
        objectOutputStream.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] standardConvert(Object o, MakeDeepCopy.ConversionMode conversionMode) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
        ObjectOutputStream objectOutputStream = null;
        try {
            if (conversionMode == MakeDeepCopy.ConversionMode.MARSHALL) {
                objectOutputStream = new SunMarshalOutputStream(byteArrayOutputStream);
            } else if (conversionMode == MakeDeepCopy.ConversionMode.OBJECT) {
                objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            } else if (conversionMode == MakeDeepCopy.ConversionMode.PAOBJECT) {
                throw new UnsupportedOperationException((Object)((Object)MakeDeepCopy.ConversionMode.PAOBJECT) + " is not supported");
            }
            ObjectToByteConverter.writeToStream(objectOutputStream, o);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            return byArray;
        }
        finally {
            if (objectOutputStream != null) {
                objectOutputStream.close();
            }
            byteArrayOutputStream.close();
        }
    }

    public static class ObjectStream {
        public static byte[] convert(Object o) throws IOException {
            return ObjectToByteConverter.convert(o, MakeDeepCopy.ConversionMode.OBJECT);
        }
    }

    public static class MarshallStream {
        public static byte[] convert(Object o) throws IOException {
            return ObjectToByteConverter.convert(o, MakeDeepCopy.ConversionMode.MARSHALL);
        }
    }
}

