/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.proactive.core.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.objectweb.proactive.core.util.ThreadStore;

public class ThreadStoreImpl
implements ThreadStore,
Serializable {
    private int counter;
    private boolean defaultOpenState;
    private transient boolean open;
    private static final long serialVersionUID = 131L;

    public ThreadStoreImpl() {
        this(true);
    }

    public ThreadStoreImpl(boolean isOpened) {
        this.open = this.defaultOpenState = isOpened;
    }

    @Override
    public int threadCount() {
        return this.counter;
    }

    @Override
    public synchronized void enter() {
        while (!this.open) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        ++this.counter;
    }

    @Override
    public synchronized void exit() {
        --this.counter;
        this.notifyAll();
    }

    @Override
    public synchronized void close() {
        this.open = false;
        while (this.counter != 0 && !this.open) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    @Override
    public synchronized void open() {
        this.open = true;
        this.notifyAll();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.open = this.defaultOpenState;
    }
}

