# -*- coding: utf-8 -*-

"""This code is a part of Yoda extension

.. module:: hydratk.extensions.yoda.translation.en
   :platform: Unix
   :synopsis: English language translation for Yoda extension
.. moduleauthor:: Petr Czaderna <pc@hydratk.org>

"""

language = {
  'name' : 'English',
  'ISO-639-1' : 'en'
}

msg = {
    'yoda_start_test_from'                     : ["Starting tests from directory: {0}"],
    'yoda_test_repo_root_override'             : ["Overriding test_repo_root directory with: {0}"],
    'yoda_invalid_test_base_path'              : ["Invalid test base path: {0}"],
    'yoda_invalid_test_repo_root'              : ["Invalid test repository root directory: {0}"],
    'yoda_added_helpers_dir'                   : ["Added helpers directory {0}"],
    'yoda_helpers_dir_not_exists'              : ["Helpers directory {0} doesn\'t exists, skipping"],
    'yoda_added_lib_dir'                       : ["Added shared library directory {0}"],
    'yoda_lib_dir_not_exists'                  : ["Shared library directory {0} doesn\'t exists, skipping"],    
    'yoda_process_test_sets_total'             : ["Found {0} test sets for processing"],
    'yoda_no_tests_found_in_path'              : ["No tests found in specified path: {0}"],
    'yoda_process_test_set'                    : ["Processing test set: {0}"],
    'yoda_test_run_summary'                    : ["Test Run: test sets: {0}, tests - total: {1}, failed: {2}, passed: {3}"],
    'yoda_test_set_summary'                    : ["Test Set: {0}"],
    'yoda_test_scenario_summary'               : ["Test Scenario: {0}, tests - total: {1}, failed: {2}, passed: {3}"],
    'yoda_test_scenario_prereq_passed'         : ["Pre-requirements passed successfully"],
    'yoda_test_scenario_prereq_failed'         : ["Pre-requirements failed: {0}"],
    'yoda_test_scenario_postreq_passed'        : ["Post-requirements passed successfully"],
    'yoda_test_scenario_postreq_failed'        : ["Post-requirements failed: {0}"],    
    'yoda_test_scenario_events_failed'         : ["There were problems in test scenario events: \n{0}"],
    'yoda_test_case_events_failed'             : ["There were problems in test case events: \n{0}"],
    'yoda_test_condition_events_failed'        : ["There were problems in test condition events: \n{0}"],
    'yoda_test_condition_test_exec_failed'     : ["There were problems in test execution: \n{0}"],
    'yoda_test_condition_validate_exec_failed' : ["There were problems in test validation: \n{0}"],
    'yoda_test_case'                           : ["Test Case: {0}"],
    'yoda_test_condition'                      : ["Test Condition: {0}"],
    'yoda_expected_result'                     : ["Expected Result: {0}"],
    'yoda_actual_result'                       : ["Actual Result: {0}"],
    'yoda_log'                                 : ["Log: {0}"],
    'yoda_parsing_test_scenario'               : ["Parsing Test-Scenario attributes {0}={1}"],
    'yoda_parsing_test_case'                   : ["Parsing Test-Case attributes {0}={1}"],
    'yoda_parsing_test_condition'              : ["Parsing Test-Condition attributes {0}={1}"],
    'yoda_scenario_tag_expected'               : ["Test-Scenario-{0} tag expected"],
    'yoda_wrong_tset_structure'                : ["Wrong test set structure"],
    'yoda_inline_loop_detected'                : ["Inline test execution loop detected on {0}"],
    'yoda_inline_test_exec'                    : ["Inline test execution: {0}"],
    'yoda_running_tset_global'                 : ["Running test set {0} out of the workspace"],
    'yoda_running_tset_repo'                   : ["Running test sets in repository: {0}"],
    'yoda_create_tset_db'                      : ["Creating test set {0} database record"],
    'yoda_create_tset_db_error'                : ["Failed to create test set database record"],
    'yoda_update_tset_db_error'                : ["Failed to update test set database record"],
    'yoda_parsing_container'                   : ["Parsing test container file: {0}"],
    'yoda_processing_container'                : ["Processing test container content: {0}"],
    'yoda_getting_tests'                       : ["Getting all tests from path: {0}"],
    'yoda_filter_parameters'                   : ["Filter parameters:\n\ttest_path: {0}\n\tts_filter: {1}\n\ttca_filter: {2}\n\ttco_filter: {3}"],
    'yoda_unknown_test_path'                   : ["Test path {0} doesn't exists"],
    'yoda_unsupported_extension'               : ["Unsupported file extension: {0} in {1}"],
    'yoda_create_test_run_db_error'            : ["Failed to create test run database record"],
    'yoda_update_test_run_db_error'            : ["Failed to update test run database record"],
    'yoda_create_test_set_db'                  : ["Creating test set {0} database record"],     
    'yoda_create_test_set_db_error'            : ["Failed to create test set database record"],
    'yoda_update_test_set_db_error'            : ["Failed to update test set database record"],
    'yoda_create_test_scenario_db_error'       : ["Failed to create test scenario database record"],
    'yoda_update_test_scenario_db_error'       : ["Failed to update test scenario database record"],
    'yoda_create_test_case_db_error'           : ["Failed to create test case database record"],
    'yoda_update_test_case_db_error'           : ["Failed to update test case database record"],
    'yoda_create_test_condition_db_error'      : ["Failed to create test condition database record"],
    'yoda_update_test_condition_db_error'      : ["Failed to update test condition database record"],    
    'yoda_skipping_test_scenario'              : ["Filter: Skipping test scenario {0}"],
    'yoda_skipping_test_case'                  : ["Filter: Skipping test case {0}"],
    'yoda_skipping_test_condition'             : ["Filter: Skipping test condition {0}"],
    'yoda_simulating_test_scenario'            : ["Simulation: Running Test scenario {0} pre-req"],
    'yoda_simulating_test_scenario_before'     : ["Simulation: Running Test scenario {0} yoda_events_before_start_ts"],
    'yoda_simulating_test_scenario_after'      : ["Simulation: Running Test scenario {0} yoda_events_after_finish_ts"],
    'yoda_simulating_test_scenario_postreq'    : ["Simulation: Running Test scenario {0} post-req"],
    'yoda_simulating_test_case'                : ["Simulation: Running Test case: {0}, Test condition: {1}"],
    'yoda_simulating_test_case_before'         : ["Simulation: Running Test Case {0} yoda_events_before_start_tca"],
    'yoda_simulating_test_case_after'          : ["Simulation: Running Test Case {0} yoda_events_after_finish_tca"],
    'yoda_simulating_test_condition_before'    : ["Simulation: Running Test Condition {0} yoda_events_before_start_tco"],
    'yoda_simulating_test_condition_after'     : ["Simulation: Running Test Condition {0} yoda_events_after_finish_tco"],
    'yoda_simulating_validation'               : ["Simulation: Validating result, Test case: {0}, Test condition: {1}"],      
    'yoda_break_outside'                       : ["You can't use '{0}' outside the {1} section"],
    'yoda_registering_actions'                 : ["Registering {0} actions"],
    'yoda_context_switch'                      : ["Got context switch, active tickets: {0}"],
    'yoda_checking_ticket'                     : ["Checking ticket_id {0}"],
    'yoda_waiting_tickets'                     : ["There're still {0} waiting tickets"],
    'yoda_create_db'                           : ["Create db results dsn: {0}"],
    'yoda_test_results_output_override'        : ["Overriding test results output create settings with: {0}"],
    'yoda_test_results_handler_override'       : ["Overriding test results output handler settings with: {0}"],
    'yoda_test_results_db_override'            : ["Overriding database test results dsn with: {0}"],
    'yoda_test_results_db_init'                : ["Initializing test results database, dsn: {0}"],
    'yoda_test_results_db_check_fail'          : ["Required test results database not available dsn: {0} check failed"],
    'yoda_test_results_db_check_ok'            : ["Test result database dsn: {0} check ok."],
    'yoda_processing_tests'                    : ["Process tests test_simul_mode {0}, run_mode {1}"],
    'yoda_received_break'                      : ["Received break {0}"],
    'yoda_processing_tset'                     : ["Processing test set {0}"],
    'yoda_processing_tset_parallel'            : ["Processing test set {0} in parallel mode"],
    'yoda_got_ticket'                          : ["Got ticket id: {0} for test set: {1}"],
    'yoda_test_results_db_missing'             : ["No test results database"],
    'yoda_db_exists'                           : ["Database already exists dsn:{0}"],
    'yoda_db_created'                          : ["Database created successfully"],
    'yoda_running_action'                      : ["Running action: {0} {1}"], 
    'yoda_getting_action_data'                 : ["Get data action: {0} {1}"],
    'yoda_unknown_handler'                     : ["Unknown handler: {0}"],
    'yoda_create_output_console'               : ["Creating console output"],
    'yoda_create_testdata_db'                  : ["Creating testdata database with dsn: {0}"],
    'yoda_remove_testdata_db'                  : ["Removing testdata database with dsn: {0}"],
    'yoda_testdata_db_exists'                  : ["Database testdata with dsn: {0} already exists"],
    'yoda_testdata_db_created'                 : ["Database testdata created successfully"],
    'yoda_testdata_db_error'                   : ["Error during testdata database creation: {0}"]                  
}
