/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive.web;

import java.io.File;
import java.util.List;
import java.util.Map;
import org.ow2.proactive.core.properties.PACommonProperties;
import org.ow2.proactive.core.properties.PACommonPropertiesHelper;
import org.ow2.proactive.core.properties.PropertyType;
import org.ow2.proactive.utils.PAPropertiesLazyLoader;

public enum WebProperties implements PACommonProperties
{
    REST_HOME("pa.rest.home", PropertyType.STRING),
    WEB_DEPLOY("web.deploy", PropertyType.BOOLEAN, "true"),
    WEB_HTTP_PORT("web.http.port", PropertyType.INTEGER, "8080"),
    WEB_HTTPS("web.https", PropertyType.BOOLEAN, "false"),
    WEB_HTTPS_ALLOW_ANY_CERTIFICATE("web.https.allow_any_certificate", PropertyType.BOOLEAN, "false"),
    WEB_HTTPS_ALLOW_ANY_HOSTNAME("web.https.allow_any_hostname", PropertyType.BOOLEAN, "false"),
    WEB_HTTPS_KEYSTORE("web.https.keystore", PropertyType.STRING, "config/web/keystore"),
    WEB_HTTPS_KEYSTORE_PASSWORD("web.https.keystore.password", PropertyType.STRING, "activeeon"),
    WEB_HTTPS_TRUSTSTORE("web.https.truststore", PropertyType.STRING),
    WEB_HTTPS_TRUSTSTORE_PASSWORD("web.https.truststore.password", PropertyType.STRING),
    WEB_HTTPS_PORT("web.https.port", PropertyType.INTEGER, "8443"),
    WEB_MAX_THREADS("web.max_threads", PropertyType.INTEGER, "100"),
    WEB_REDIRECT_HTTP_TO_HTTPS("web.redirect_http_to_https", PropertyType.BOOLEAN, "false"),
    METADATA_CONTENT_TYPE("content.type", PropertyType.STRING),
    METADATA_FILE_NAME("file.name", PropertyType.STRING),
    METADATA_FILE_EXTENSION("file.extension", PropertyType.STRING),
    RESOURCE_DOWNLOADER_PROXY("resource.downloader.proxy", PropertyType.STRING),
    RESOURCE_DOWNLOADER_PROXY_PORT("resource.downloader.proxy.port", PropertyType.INTEGER),
    RESOURCE_DOWNLOADER_PROXY_SCHEME("resource.downloader.proxy.scheme", PropertyType.STRING),
    WAR_WRAPPER_HTTP_PORT("war.wrapper.target.server.http.port", PropertyType.INTEGER, "9080"),
    WAR_WRAPPER_HTTPS_PORT("war.wrapper.target.server.https.port", PropertyType.INTEGER, "9443"),
    WAR_WRAPPER_HTTPS_ENABLED("war.wrapper.https.enabled", PropertyType.BOOLEAN, "false"),
    WAR_WRAPPER_CONTEXT_ROOT("war.wrapper.context.root", PropertyType.STRING, "/");

    public static final String PA_WEB_PROPERTIES_FILEPATH_PROPERTY_NAME = "pa.portal.configuration.filepath";
    public static final String PA_WEB_PROPERTIES_RELATIVE_FILEPATH = "config/web/settings.ini";
    private static PAPropertiesLazyLoader propertiesLoader;
    private static PACommonPropertiesHelper propertiesHelper;
    private String key;
    private PropertyType type;
    private String defaultValue;

    private WebProperties(String str, PropertyType type, String defaultValue) {
        this.key = str;
        this.type = type;
        this.defaultValue = defaultValue;
    }

    private WebProperties(String str, PropertyType type) {
        this(str, type, null);
    }

    protected static void loadProperties(String filename) {
        propertiesLoader = new PAPropertiesLazyLoader(WebProperties.REST_HOME.key, PA_WEB_PROPERTIES_FILEPATH_PROPERTY_NAME, PA_WEB_PROPERTIES_RELATIVE_FILEPATH, filename);
        propertiesHelper = new PACommonPropertiesHelper(propertiesLoader);
    }

    public static void updateProperties(String filename) {
        propertiesHelper.updateProperties(filename);
    }

    public static Map<String, Object> getPropertiesAsHashMap() {
        return propertiesHelper.getPropertiesAsHashMap();
    }

    public static synchronized void load() {
        propertiesLoader = new PAPropertiesLazyLoader(WebProperties.REST_HOME.key, PA_WEB_PROPERTIES_FILEPATH_PROPERTY_NAME, PA_WEB_PROPERTIES_RELATIVE_FILEPATH);
        propertiesHelper = new PACommonPropertiesHelper(propertiesLoader);
    }

    public static synchronized void storeInSystemProperties() {
        System.setProperties(propertiesLoader.getProperties());
    }

    public static String getAbsolutePath(String userPath) {
        if (new File(userPath).isAbsolute()) {
            return userPath;
        }
        return REST_HOME.getValueAsString() + File.separator + userPath;
    }

    public String getKey() {
        return this.key;
    }

    public void updateProperty(String value) {
        propertiesHelper.updateProperty(this.key, value);
    }

    public boolean isSet() {
        return propertiesHelper.isSet(this.key, this.defaultValue);
    }

    public void unSet() {
        propertiesHelper.unSet(this.key);
    }

    public String getCmdLine() {
        return propertiesHelper.getCmdLine(this.key);
    }

    public int getValueAsInt() {
        return propertiesHelper.getValueAsInt(this.key, this.type, this.defaultValue);
    }

    public long getValueAsLong() {
        return propertiesHelper.getValueAsLong(this.key, this.type, this.defaultValue);
    }

    public String getValueAsString() {
        return propertiesHelper.getValueAsString(this.key, this.defaultValue);
    }

    public String getValueAsStringOrNull() {
        return propertiesHelper.getValueAsStringOrNull(this.key);
    }

    public boolean getValueAsBoolean() {
        return propertiesHelper.getValueAsBoolean(this.key, this.type, this.defaultValue);
    }

    public List<String> getValueAsList(String separator) {
        return propertiesHelper.getValueAsList(this.key, this.type, separator, this.defaultValue);
    }

    public PropertyType getType() {
        return this.type;
    }

    public String toString() {
        return this.getValueAsString();
    }

    public String getConfigurationFilePathPropertyName() {
        return PA_WEB_PROPERTIES_FILEPATH_PROPERTY_NAME;
    }

    public String getConfigurationDefaultRelativeFilePath() {
        return PA_WEB_PROPERTIES_RELATIVE_FILEPATH;
    }

    public void loadPropertiesFromFile(String filename) {
        WebProperties.loadProperties(filename);
    }

    public void reloadConfiguration() {
        WebProperties.load();
    }

    static {
        WebProperties.load();
    }
}

