/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive.scheduler.synchronization;

import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import org.ow2.proactive.scheduler.common.task.TaskId;
import org.ow2.proactive.scheduler.synchronization.CompilationException;
import org.ow2.proactive.scheduler.synchronization.InvalidChannelException;
import org.ow2.proactive.scheduler.synchronization.PredicateActionResult;
import org.ow2.proactive.scheduler.synchronization.Synchronization;
import org.ow2.proactive.scheduler.synchronization.SynchronizationInternal;

public class SynchronizationWrapper
implements Synchronization {
    String originator;
    TaskId taskId;
    SynchronizationInternal internalAPI;
    private static final long serialVersionUID = 810L;

    public SynchronizationWrapper(String originator, TaskId taskId, SynchronizationInternal internalAPI) {
        this.originator = originator;
        this.taskId = taskId;
        this.internalAPI = internalAPI;
    }

    @Override
    public boolean createChannel(String name, boolean isPersistent) throws IOException {
        return this.internalAPI.createChannel(this.originator, this.taskId, name, isPersistent);
    }

    @Override
    public boolean createChannelIfAbsent(String name, boolean isPersistent) throws IOException {
        return this.internalAPI.createChannelIfAbsent(this.originator, this.taskId, name, isPersistent);
    }

    @Override
    public boolean deleteChannel(String name) throws IOException {
        return this.internalAPI.deleteChannel(this.originator, this.taskId, name);
    }

    @Override
    public boolean channelExists(String name) {
        return this.internalAPI.channelExists(this.originator, this.taskId, name);
    }

    @Override
    public int size(String channel) throws InvalidChannelException {
        return this.internalAPI.size(this.originator, this.taskId, channel);
    }

    @Override
    public boolean isEmpty(String channel) throws InvalidChannelException {
        return this.internalAPI.isEmpty(this.originator, this.taskId, channel);
    }

    @Override
    public boolean containsKey(String channel, String key) throws InvalidChannelException {
        return this.internalAPI.containsKey(this.originator, this.taskId, channel, key);
    }

    @Override
    public boolean containsValue(String channel, Serializable value) throws InvalidChannelException {
        return this.internalAPI.containsValue(this.originator, this.taskId, channel, value);
    }

    @Override
    public Serializable get(String channel, String key) throws InvalidChannelException {
        return this.internalAPI.get(this.originator, this.taskId, channel, key);
    }

    @Override
    public Serializable put(String channel, String key, Serializable value) throws InvalidChannelException, IOException {
        return this.internalAPI.put(this.originator, this.taskId, channel, key, value);
    }

    @Override
    public Serializable remove(String channel, String key) throws InvalidChannelException, IOException {
        return this.internalAPI.remove(this.originator, this.taskId, channel, key);
    }

    @Override
    public void putAll(String channel, Map<? extends String, ? extends Serializable> m) throws InvalidChannelException, IOException {
        this.internalAPI.putAll(this.originator, this.taskId, channel, m);
    }

    @Override
    public void clear(String channel) throws InvalidChannelException, IOException {
        this.internalAPI.clear(this.originator, this.taskId, channel);
    }

    @Override
    public Set<String> keySet(String channel) throws InvalidChannelException {
        return this.internalAPI.keySet(this.originator, this.taskId, channel);
    }

    @Override
    public Collection<Serializable> values(String channel) throws InvalidChannelException {
        return this.internalAPI.values(this.originator, this.taskId, channel);
    }

    @Override
    public Set<Map.Entry<String, Serializable>> entrySet(String channel) throws InvalidChannelException {
        return this.internalAPI.entrySet(this.originator, this.taskId, channel);
    }

    @Override
    public Serializable getOrDefault(String channel, String key, Serializable defaultValue) throws InvalidChannelException {
        return this.internalAPI.getOrDefault(this.originator, this.taskId, channel, key, defaultValue);
    }

    @Override
    public void forEach(String channel, String action) throws InvalidChannelException, CompilationException {
        this.internalAPI.forEach(this.originator, this.taskId, channel, action);
    }

    @Override
    public void replaceAll(String channel, String function) throws InvalidChannelException, CompilationException, IOException {
        this.internalAPI.replaceAll(this.originator, this.taskId, channel, function);
    }

    @Override
    public Serializable putIfAbsent(String channel, String key, Serializable value) throws InvalidChannelException, IOException {
        return this.internalAPI.putIfAbsent(this.originator, this.taskId, channel, key, value);
    }

    @Override
    public boolean remove(String channel, String key, Serializable value) throws InvalidChannelException, IOException {
        return this.internalAPI.remove(this.originator, this.taskId, channel, key, value);
    }

    @Override
    public boolean replace(String channel, String key, Serializable oldValue, Serializable newValue) throws InvalidChannelException, IOException {
        return this.internalAPI.replace(this.originator, this.taskId, channel, key, oldValue, newValue);
    }

    @Override
    public Serializable replace(String channel, String key, Serializable value) throws InvalidChannelException, IOException {
        return this.internalAPI.replace(this.originator, this.taskId, channel, key, value);
    }

    @Override
    public Serializable computeIfAbsent(String channel, String key, String mappingFunction) throws InvalidChannelException, CompilationException, IOException {
        return this.internalAPI.computeIfAbsent(this.originator, this.taskId, channel, key, mappingFunction);
    }

    @Override
    public Serializable computeIfPresent(String channel, String key, String remappingFunction) throws InvalidChannelException, CompilationException, IOException {
        return this.internalAPI.computeIfPresent(this.originator, this.taskId, channel, key, remappingFunction);
    }

    @Override
    public Serializable compute(String channel, String key, String remappingFunction) throws InvalidChannelException, CompilationException, IOException {
        return this.internalAPI.compute(this.originator, this.taskId, channel, key, remappingFunction);
    }

    @Override
    public Serializable merge(String channel, String key, Serializable value, String remappingFunction) throws InvalidChannelException, CompilationException, IOException {
        return this.internalAPI.merge(this.originator, this.taskId, channel, key, value, remappingFunction);
    }

    @Override
    public PredicateActionResult conditionalCompute(String channel, String key, String predicate, String thenRemappingFunction) throws InvalidChannelException, CompilationException, IOException {
        return this.internalAPI.conditionalCompute(this.originator, this.taskId, channel, key, predicate, thenRemappingFunction);
    }

    @Override
    public PredicateActionResult conditionalCompute(String channel, String key, String predicate, String thenRemappingFunction, String elseRemappingFunction) throws InvalidChannelException, CompilationException, IOException {
        return this.internalAPI.conditionalCompute(this.originator, this.taskId, channel, key, predicate, thenRemappingFunction, elseRemappingFunction);
    }

    @Override
    public void conditionalReplaceAll(String channel, String predicate, String thenRemappingFunction) throws InvalidChannelException, CompilationException, IOException {
        this.internalAPI.conditionalReplaceAll(this.originator, this.taskId, channel, predicate, thenRemappingFunction);
    }

    @Override
    public void conditionalReplaceAll(String channel, String predicate, String thenRemappingFunction, String elseRemappingFunction) throws InvalidChannelException, CompilationException, IOException {
        this.internalAPI.conditionalReplaceAll(this.originator, this.taskId, channel, predicate, thenRemappingFunction, elseRemappingFunction);
    }

    @Override
    public boolean waitUntil(String channel, String key, String predicate) throws InvalidChannelException, CompilationException {
        return this.internalAPI.waitUntil(this.originator, this.taskId, channel, key, predicate);
    }

    @Override
    public boolean waitUntil(String channel, String key, String predicate, long timeout) throws InvalidChannelException, CompilationException, TimeoutException {
        return this.internalAPI.waitUntil(this.originator, this.taskId, channel, key, predicate, timeout);
    }

    @Override
    public PredicateActionResult waitUntilThen(String channel, String key, String predicate, String thenRemappingFunction) throws InvalidChannelException, CompilationException, IOException {
        return this.internalAPI.waitUntilThen(this.originator, this.taskId, channel, key, predicate, thenRemappingFunction);
    }

    @Override
    public PredicateActionResult waitUntilThen(String channel, String key, String predicate, long timeout, String thenRemappingFunction) throws InvalidChannelException, CompilationException, IOException, TimeoutException {
        return this.internalAPI.waitUntilThen(this.originator, this.taskId, channel, key, predicate, timeout, thenRemappingFunction);
    }
}

