/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive.scheduler.common.task.executable;

import java.io.PrintStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import javax.script.ScriptContext;
import org.objectweb.proactive.annotation.PublicAPI;
import org.ow2.proactive.scheduler.common.task.TaskResult;
import org.ow2.proactive.scheduler.common.task.executable.internal.JavaStandaloneExecutableInitializer;
import org.ow2.proactive.scheduler.common.task.util.SerializationUtil;
import org.ow2.proactive.scheduler.synchronization.Synchronization;
import org.ow2.proactive.scheduler.task.SchedulerVars;
import org.ow2.proactive.scripting.helper.progress.ProgressFile;

@PublicAPI
public abstract class JavaExecutable {
    protected JavaStandaloneExecutableInitializer execInitializer;
    private Map<String, Serializable> propagatedVariables;
    private Map<String, String> metadata;
    private String inputSpace;
    private String outputSpace;
    private String globalSpace;
    private String localSpace;
    private String userSpace;
    private Synchronization synchronizationAPI;

    public void internalInit(JavaStandaloneExecutableInitializer execInitializer, ScriptContext sc) throws Exception {
        this.execInitializer = execInitializer;
        Map<String, Serializable> arguments = this.execInitializer.getArguments(Thread.currentThread().getContextClassLoader());
        Map<String, Serializable> propagatedVariables = SerializationUtil.deserializeVariableMap(execInitializer.getPropagatedVariables());
        this.setVariables(propagatedVariables);
        this.updateVariables(arguments, this.getVariables());
        this.initDataSpaces(sc);
        this.init(arguments);
        this.initMetadata(sc);
        this.initAPIs(sc);
    }

    public void init(Map<String, Serializable> args) throws Exception {
        if (args == null) {
            return;
        }
        Class<?> current = this.getClass();
        while (JavaExecutable.class.isAssignableFrom(current)) {
            for (Map.Entry<String, Serializable> e : args.entrySet()) {
                try {
                    Field f = current.getDeclaredField(e.getKey());
                    f.setAccessible(true);
                    Class<Object> fieldClass = f.getType();
                    Class<Object> valueClass = e.getValue().getClass();
                    if (valueClass.equals(Integer.class) || valueClass.equals(Short.class) || valueClass.equals(Long.class) || valueClass.equals(Byte.class) || valueClass.equals(Boolean.class)) {
                        e.setValue((Serializable)((Object)e.getValue().toString()));
                        valueClass = String.class;
                    }
                    if (String.class.equals(valueClass) && !String.class.equals(fieldClass)) {
                        String valueAsString = (String)((Object)e.getValue());
                        if (fieldClass.equals(Integer.class) || fieldClass.equals(Integer.TYPE)) {
                            f.set(this, Integer.parseInt(valueAsString));
                            continue;
                        }
                        if (fieldClass.equals(Short.class) || fieldClass.equals(Short.TYPE)) {
                            f.set(this, Short.parseShort(valueAsString));
                            continue;
                        }
                        if (fieldClass.equals(Long.class) || fieldClass.equals(Long.TYPE)) {
                            f.set(this, Long.parseLong(valueAsString));
                            continue;
                        }
                        if (fieldClass.equals(Byte.class) || fieldClass.equals(Byte.TYPE)) {
                            f.set(this, Byte.parseByte(valueAsString));
                            continue;
                        }
                        if (!fieldClass.equals(Boolean.class) && !fieldClass.equals(Boolean.TYPE)) continue;
                        f.set(this, Boolean.parseBoolean(valueAsString));
                        continue;
                    }
                    if (!fieldClass.isAssignableFrom(valueClass)) continue;
                    f.set(this, e.getValue());
                }
                catch (Exception exception) {}
            }
            current = current.getSuperclass();
        }
    }

    public void initDataSpaces(ScriptContext sc) {
        this.inputSpace = (String)sc.getAttribute("inputspace");
        this.outputSpace = (String)sc.getAttribute("outputspace");
        this.globalSpace = (String)sc.getAttribute("globalspace");
        this.userSpace = (String)sc.getAttribute("userspace");
        this.localSpace = (String)sc.getAttribute("localspace");
    }

    public void initAPIs(ScriptContext sc) {
        this.synchronizationAPI = (Synchronization)sc.getAttribute("synchronizationapi");
    }

    public void initMetadata(ScriptContext sc) {
        this.metadata = (Map)sc.getAttribute("resultMetadata");
    }

    public List<String> getNodesURL() {
        return this.execInitializer.getNodesURL();
    }

    public final int getIterationIndex() {
        return (Integer)this.getVariables().get(SchedulerVars.PA_TASK_ITERATION.toString());
    }

    public final int getReplicationIndex() {
        return (Integer)this.getVariables().get(SchedulerVars.PA_TASK_REPLICATION.toString());
    }

    protected String getThirdPartyCredential(String key) {
        return this.execInitializer.getThirdPartyCredentials().get(key);
    }

    protected PrintStream getOut() {
        return this.execInitializer.getOutputSink();
    }

    protected PrintStream getErr() {
        return this.execInitializer.getErrorSink();
    }

    private void updateVariables(Map<String, Serializable> old, Map<String, Serializable> updated) {
        for (String k : old.keySet()) {
            if (!updated.containsKey(k)) continue;
            old.put(k, updated.get(k));
        }
    }

    public abstract Serializable execute(TaskResult ... var1) throws Throwable;

    protected final int setProgress(int newValue) throws IllegalArgumentException {
        if (newValue < 0 || newValue > 100) {
            throw new IllegalArgumentException("Progress value must be ranged between 0 and 100");
        }
        String progressFilePath = (String)((Object)this.getVariables().get(SchedulerVars.PA_TASK_PROGRESS_FILE.toString()));
        int previousValue = ProgressFile.getProgress((String)progressFilePath);
        ProgressFile.setProgress((String)progressFilePath, (int)newValue);
        return previousValue;
    }

    public int getProgress() {
        return ProgressFile.getProgress((String)((String)((Object)this.getVariables().get(SchedulerVars.PA_TASK_PROGRESS_FILE.toString()))));
    }

    public Map<String, Serializable> getVariables() {
        return this.propagatedVariables;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public void setVariables(Map<String, Serializable> propagatedVariables) {
        this.propagatedVariables = propagatedVariables;
    }

    public String getInputSpace() {
        return this.inputSpace;
    }

    public String getOutputSpace() {
        return this.outputSpace;
    }

    public String getGlobalSpace() {
        return this.globalSpace;
    }

    public String getLocalSpace() {
        return this.localSpace;
    }

    public String getUserSpace() {
        return this.userSpace;
    }

    public Synchronization getSynchronizationAPI() {
        return this.synchronizationAPI;
    }
}

