/*
 * Decompiled with CFR 0.152.
 */
package jdbm.recman;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.OverlappingFileLockException;
import java.util.ArrayList;
import java.util.Iterator;
import jdbm.helper.LongHashMap;
import jdbm.recman.BlockIo;
import jdbm.recman.TransactionManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class RecordFile {
    final TransactionManager txnMgr;
    private final LongHashMap<BlockIo> free = new LongHashMap();
    private final LongHashMap<BlockIo> inUse = new LongHashMap();
    private final LongHashMap<BlockIo> dirty = new LongHashMap();
    private final LongHashMap<BlockIo> inTxn = new LongHashMap();
    private boolean transactionsDisabled = false;
    static final int DEFAULT_BLOCK_SIZE = 4096;
    final int BLOCK_SIZE;
    private static final long _FILESIZE = 1000000000L;
    private final long MAX_FILE_SIZE;
    final byte[] cleanData;
    private ArrayList<FileChannel> fileChannels = new ArrayList();
    private ArrayList<RandomAccessFile> rafs = new ArrayList();
    private final String fileName;

    RecordFile(String fileName) throws IOException {
        this(fileName, 4096);
    }

    RecordFile(String fileName, int blockSize) throws IOException {
        this.BLOCK_SIZE = blockSize;
        this.MAX_FILE_SIZE = 1000000000L - 1000000000L % (long)this.BLOCK_SIZE;
        this.cleanData = new byte[this.BLOCK_SIZE];
        this.fileName = fileName;
        FileChannel f0 = this.getChannel(0L);
        try {
            f0.tryLock();
        }
        catch (IOException e) {
            throw new IOException("Could not lock DB file: " + fileName, e);
        }
        catch (OverlappingFileLockException e) {
            throw new IOException("Could not lock DB file: " + fileName, e);
        }
        this.txnMgr = new TransactionManager(this);
    }

    FileChannel getChannel(long offset) throws IOException {
        int fileNumber = (int)(offset / this.MAX_FILE_SIZE);
        for (int i = this.fileChannels.size(); i <= fileNumber; ++i) {
            this.fileChannels.add(null);
            this.rafs.add(null);
        }
        FileChannel ret = this.fileChannels.get(fileNumber);
        if (ret == null) {
            String name = this.fileName + "." + fileNumber;
            RandomAccessFile f = new RandomAccessFile(name, "rw");
            this.rafs.set(fileNumber, f);
            ret = f.getChannel();
            this.fileChannels.set(fileNumber, ret);
        }
        return ret;
    }

    String getFileName() {
        return this.fileName;
    }

    void disableTransactions() {
        this.transactionsDisabled = true;
    }

    BlockIo get(long blockid) throws IOException {
        BlockIo node = this.inTxn.get(blockid);
        if (node != null) {
            this.inTxn.remove(blockid);
            this.inUse.put(blockid, node);
            return node;
        }
        node = this.dirty.get(blockid);
        if (node != null) {
            this.dirty.remove(blockid);
            this.inUse.put(blockid, node);
            return node;
        }
        BlockIo cur = this.free.get(blockid);
        if (cur != null) {
            node = cur;
            this.free.remove(blockid);
            this.inUse.put(blockid, node);
            return node;
        }
        if (this.inUse.get(blockid) != null) {
            throw new Error("double get for block " + blockid);
        }
        node = this.getNewNode(blockid);
        long offset = blockid * (long)this.BLOCK_SIZE;
        FileChannel file = this.getChannel(offset);
        this.read(file, offset % this.MAX_FILE_SIZE, node.getData(), this.BLOCK_SIZE);
        this.inUse.put(blockid, node);
        node.setClean();
        return node;
    }

    void release(long blockid, boolean isDirty) throws IOException {
        BlockIo node = this.inUse.get(blockid);
        if (node == null) {
            throw new IOException("bad blockid " + blockid + " on release");
        }
        if (!node.isDirty() && isDirty) {
            node.setDirty();
        }
        this.release(node);
    }

    void release(BlockIo block) {
        long key = block.getBlockId();
        this.inUse.remove(key);
        if (block.isDirty()) {
            this.dirty.put(key, block);
        } else if (!this.transactionsDisabled && block.isInTransaction()) {
            this.inTxn.put(key, block);
        } else {
            this.free.put(block.getBlockId(), block);
        }
    }

    void discard(BlockIo block) {
        long key = block.getBlockId();
        this.inUse.remove(key);
    }

    void commit() throws IOException {
        if (!this.inUse.isEmpty() && this.inUse.size() > 1) {
            this.showList(this.inUse.valuesIterator());
            throw new Error("in use list not empty at commit time (" + this.inUse.size() + ")");
        }
        if (this.dirty.size() == 0) {
            return;
        }
        if (!this.transactionsDisabled) {
            this.txnMgr.start();
        }
        Iterator<BlockIo> i = this.dirty.valuesIterator();
        while (i.hasNext()) {
            BlockIo node = i.next();
            i.remove();
            if (this.transactionsDisabled) {
                long offset = node.getBlockId() * (long)this.BLOCK_SIZE;
                FileChannel file = this.getChannel(offset);
                file.position(offset % this.MAX_FILE_SIZE);
                file.write(ByteBuffer.wrap(node.getData()));
                node.setClean();
                this.free.put(node.getBlockId(), node);
                continue;
            }
            this.txnMgr.add(node);
            this.inTxn.put(node.getBlockId(), node);
        }
        if (!this.transactionsDisabled) {
            this.txnMgr.commit();
        }
    }

    void rollback() throws IOException {
        if (!this.inUse.isEmpty()) {
            this.showList(this.inUse.valuesIterator());
            throw new Error("in use list not empty at rollback time (" + this.inUse.size() + ")");
        }
        this.dirty.clear();
        this.txnMgr.synchronizeLogFromDisk();
        if (!this.inTxn.isEmpty()) {
            this.showList(this.inTxn.valuesIterator());
            throw new Error("in txn list not empty at rollback time (" + this.inTxn.size() + ")");
        }
    }

    void close() throws IOException {
        if (!this.dirty.isEmpty()) {
            this.commit();
        }
        this.txnMgr.shutdown();
        if (!this.inTxn.isEmpty()) {
            this.showList(this.inTxn.valuesIterator());
            throw new Error("In transaction not empty");
        }
        if (!this.dirty.isEmpty()) {
            System.out.println("ERROR: dirty blocks at close time");
            this.showList(this.dirty.valuesIterator());
            throw new Error("Dirty blocks at close time");
        }
        if (!this.inUse.isEmpty()) {
            System.out.println("ERROR: inUse blocks at close time");
            this.showList(this.inUse.valuesIterator());
            throw new Error("inUse blocks at close time");
        }
        for (FileChannel buf : this.fileChannels) {
            if (buf == null) continue;
            buf.close();
        }
        this.fileChannels = null;
        for (RandomAccessFile f : this.rafs) {
            if (f == null) continue;
            f.close();
        }
        this.rafs = null;
    }

    void forceClose() throws IOException {
        this.txnMgr.forceClose();
        for (FileChannel buf : this.fileChannels) {
            if (buf == null) continue;
            buf.close();
        }
        this.fileChannels = null;
        for (RandomAccessFile f : this.rafs) {
            if (f == null) continue;
            f.close();
        }
        this.rafs = null;
    }

    private void showList(Iterator<BlockIo> i) {
        int cnt = 0;
        while (i.hasNext()) {
            System.out.println("elem " + cnt + ": " + i.next());
            ++cnt;
        }
    }

    private BlockIo getNewNode(long blockid) throws IOException {
        BlockIo retval = null;
        if (!this.free.isEmpty()) {
            Iterator<BlockIo> it = this.free.valuesIterator();
            retval = it.next();
            it.remove();
        }
        if (retval == null) {
            retval = new BlockIo(0L, new byte[this.BLOCK_SIZE]);
        }
        retval.setBlockId(blockid);
        retval.setView(null);
        return retval;
    }

    void synch(BlockIo node) throws IOException {
        byte[] data = node.getData();
        if (data != null) {
            long offset = node.getBlockId() * (long)this.BLOCK_SIZE;
            FileChannel file = this.getChannel(offset);
            file.position(offset % this.MAX_FILE_SIZE);
            file.write(ByteBuffer.wrap(data));
        }
    }

    void releaseFromTransaction(BlockIo node, boolean recycle) throws IOException {
        long key = node.getBlockId();
        if (this.inTxn.remove(key) != null && recycle) {
            this.free.put(key, node);
        }
    }

    void sync() throws IOException {
        for (FileChannel file : this.fileChannels) {
            if (file == null) continue;
            file.force(true);
        }
    }

    private void read(FileChannel file, long offset, byte[] buffer, int nBytes) throws IOException {
        file.position(offset);
        int remaining = nBytes;
        int pos = 0;
        while (remaining > 0) {
            ByteBuffer b = ByteBuffer.wrap(buffer, pos, remaining);
            int read = file.read(b);
            while (read != -1 && b.hasRemaining()) {
                read = file.read(b);
            }
            if (read == -1) {
                System.arraycopy(this.cleanData, 0, buffer, pos, remaining);
                break;
            }
            remaining -= read;
            pos += read;
        }
    }
}

