/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive.utils;

import java.security.Policy;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Logger;
import org.objectweb.proactive.utils.SecurityManagerConfigurator;

public class SecurityPolicyLoader {
    private static final Logger logger = Logger.getLogger(SecurityPolicyLoader.class);
    public static ReentrantLock lock = new ReentrantLock();

    public static void configureSecurityManager(String securityFilePath, long refreshPeriod) {
        SecurityManagerConfigurator.configureSecurityManager((String)securityFilePath);
        ScheduledExecutorService scheduledThreadPool = Executors.newScheduledThreadPool(1);
        scheduledThreadPool.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                SecurityPolicyLoader.reloadPolicy();
            }
        }, 0L, refreshPeriod, TimeUnit.SECONDS);
    }

    public static void reloadPolicy() {
        try {
            lock.lockInterruptibly();
            Policy.getPolicy().refresh();
        }
        catch (InterruptedException e) {
            logger.warn((Object)"Load policy thread interrupted", (Throwable)e);
        }
        finally {
            lock.unlock();
        }
    }
}

