/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive.utils;

import org.ow2.proactive.utils.OperatingSystemFamily;

public enum OperatingSystem {
    MAC_OSX("Mac OS X", OperatingSystemFamily.MAC),
    WINDOWS_95("Windows 95", OperatingSystemFamily.WINDOWS),
    WINDOWS_98("Windows 98", OperatingSystemFamily.WINDOWS),
    WINDOWS_ME("Windows Me", OperatingSystemFamily.WINDOWS),
    WINDOWS_NT("Windows NT", OperatingSystemFamily.WINDOWS),
    WINDOWS_2000("Windows 2000", OperatingSystemFamily.WINDOWS),
    WINDOWS_XP("Windows XP", OperatingSystemFamily.WINDOWS),
    WINDOWS_7("Windows 7", OperatingSystemFamily.WINDOWS),
    WINDOWS_10("Windows 10", OperatingSystemFamily.WINDOWS),
    WINDOWS_11("Windows 11", OperatingSystemFamily.WINDOWS),
    WINDOWS_2003("Windows 2003", OperatingSystemFamily.WINDOWS),
    WINDOWS_2008("Windows 2008", OperatingSystemFamily.WINDOWS),
    WINDOWS_2012("Windows Server 2012", OperatingSystemFamily.WINDOWS),
    WINDOWS_2016("Windows Server 2016", OperatingSystemFamily.WINDOWS),
    WINDOWS_2019("Windows Server 2019", OperatingSystemFamily.WINDOWS),
    SUN_OS("SunOS", OperatingSystemFamily.UNIX),
    MPE_IX("MPE/iX", OperatingSystemFamily.UNIX),
    HP_UX("HP-UX", OperatingSystemFamily.UNIX),
    AIX("AIX", OperatingSystemFamily.UNIX),
    OS_390("OS/390", OperatingSystemFamily.UNIX),
    zOS("z/OS", OperatingSystemFamily.UNIX),
    AS_400("OS/400", OperatingSystemFamily.UNIX),
    FREEBSD("FreeBSD", OperatingSystemFamily.UNIX),
    IRIX("Irix", OperatingSystemFamily.UNIX),
    DIGITAL_UNIX("Digital Unix", OperatingSystemFamily.UNIX),
    NETWARE("NetWare", OperatingSystemFamily.UNIX),
    OSF1("OSF1", OperatingSystemFamily.UNIX),
    OPENVMS("OpenVMS", OperatingSystemFamily.DEC_OS),
    WINDOWS_GENERIC("Windows", OperatingSystemFamily.WINDOWS),
    LINUX_OS("Linux", OperatingSystemFamily.LINUX),
    MAC_OS("Mac OS", OperatingSystemFamily.MAC);

    private final String label;
    private final OperatingSystemFamily family;

    private OperatingSystem(String label, OperatingSystemFamily family) {
        this.label = label;
        this.family = family;
    }

    public String getLabel() {
        return this.label;
    }

    public OperatingSystemFamily getFamily() {
        return this.family;
    }

    public static OperatingSystem resolve(String osName) {
        for (OperatingSystem os : OperatingSystem.values()) {
            if (!osName.startsWith(os.label)) continue;
            return os;
        }
        return null;
    }

    public static OperatingSystem resolveOrError(String osName) {
        for (OperatingSystem os : OperatingSystem.values()) {
            if (!osName.startsWith(os.label)) continue;
            return os;
        }
        throw new IllegalArgumentException("Unknown Operating System " + osName);
    }
}

