/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive.resourcemanager.common.event;

import java.util.List;
import java.util.Map;
import org.objectweb.proactive.annotation.PublicAPI;
import org.ow2.proactive.resourcemanager.common.NodeState;
import org.ow2.proactive.resourcemanager.common.event.RMEvent;
import org.ow2.proactive.resourcemanager.common.event.RMEventType;
import org.ow2.proactive.resourcemanager.common.event.RMNodeDescriptor;

@PublicAPI
public final class RMNodeEvent
extends RMEvent {
    private final String nodeUrl;
    private final String nodeSource;
    private final String PADName;
    private final String VnName;
    private final String hostName;
    private final String VMName;
    private final NodeState nodeState;
    private final NodeState previousNodeState;
    private final String nodeProvider;
    private final String nodeOwner;
    private String description;
    private String defaultJMXUrl;
    private String proactiveJMXUrl;
    private final boolean isLocked;
    private final long lockTime;
    private final String nodeLocker;
    private final Map<String, String> usageInfo;
    private final List<String> tokens;
    private final String tenant;
    private static final long serialVersionUID = 142L;

    public RMNodeEvent() {
        this.nodeUrl = null;
        this.nodeSource = null;
        this.PADName = null;
        this.VnName = null;
        this.hostName = null;
        this.VMName = null;
        this.nodeState = null;
        this.previousNodeState = null;
        this.nodeProvider = null;
        this.nodeOwner = null;
        this.description = null;
        this.defaultJMXUrl = null;
        this.proactiveJMXUrl = null;
        this.isLocked = false;
        this.lockTime = -1L;
        this.nodeLocker = null;
        this.usageInfo = null;
        this.tokens = null;
        this.tenant = null;
    }

    public RMNodeEvent(String nodeUrl, long counter) {
        this.nodeUrl = nodeUrl;
        this.counter = counter;
        this.firstCounter = counter;
        this.nodeSource = null;
        this.PADName = null;
        this.VnName = null;
        this.hostName = null;
        this.VMName = null;
        this.nodeState = null;
        this.previousNodeState = null;
        this.nodeProvider = null;
        this.nodeOwner = null;
        this.description = null;
        this.defaultJMXUrl = null;
        this.proactiveJMXUrl = null;
        this.isLocked = false;
        this.lockTime = -1L;
        this.nodeLocker = null;
        this.usageInfo = null;
        this.tokens = null;
        this.tenant = null;
    }

    public RMNodeEvent(String nodeUrl, long counter, RMEventType eventType) {
        super(eventType);
        this.nodeUrl = nodeUrl;
        this.counter = counter;
        this.firstCounter = counter;
        this.nodeSource = null;
        this.PADName = null;
        this.VnName = null;
        this.hostName = null;
        this.VMName = null;
        this.nodeState = null;
        this.previousNodeState = null;
        this.nodeProvider = null;
        this.nodeOwner = null;
        this.description = null;
        this.defaultJMXUrl = null;
        this.proactiveJMXUrl = null;
        this.isLocked = false;
        this.lockTime = -1L;
        this.nodeLocker = null;
        this.usageInfo = null;
        this.tokens = null;
        this.tenant = null;
    }

    public RMNodeEvent(RMNodeDescriptor rmNode) {
        this(rmNode, null, null, null);
    }

    public RMNodeEvent(RMNodeDescriptor rmNode, RMEventType eventType, NodeState previousNodeState, String initiator) {
        super(eventType);
        this.initiator = initiator;
        this.nodeUrl = rmNode.getNodeURL();
        this.nodeSource = rmNode.getNodeSourceName();
        this.PADName = "";
        this.VnName = rmNode.getVNodeName();
        this.hostName = rmNode.getHostName();
        this.VMName = rmNode.getDescriptorVMName();
        this.nodeState = rmNode.getState();
        this.description = rmNode.getNodeInfo();
        this.defaultJMXUrl = rmNode.getDefaultJMXUrl();
        this.proactiveJMXUrl = rmNode.getProactiveJMXUrl();
        if (eventType != RMEventType.NODE_REMOVED) {
            this.timeStamp = rmNode.getStateChangeTime();
        }
        this.previousNodeState = previousNodeState;
        this.nodeProvider = rmNode.getProviderName();
        this.nodeOwner = rmNode.getOwnerName();
        this.isLocked = rmNode.isLocked();
        this.lockTime = rmNode.getLockTime();
        this.nodeLocker = rmNode.getLockedBy();
        this.usageInfo = rmNode.getUsageInfo();
        this.tokens = rmNode.getTokens();
        this.tenant = rmNode.getTenant();
    }

    public RMNodeEvent(RMEventType eventType, NodeState state) {
        super(eventType);
        this.nodeUrl = null;
        this.nodeSource = null;
        this.PADName = null;
        this.VnName = null;
        this.hostName = null;
        this.VMName = null;
        this.previousNodeState = null;
        this.nodeProvider = null;
        this.nodeOwner = null;
        this.description = null;
        this.defaultJMXUrl = null;
        this.proactiveJMXUrl = null;
        this.isLocked = false;
        this.lockTime = -1L;
        this.nodeLocker = null;
        this.nodeState = state;
        this.usageInfo = null;
        this.tokens = null;
        this.tenant = null;
    }

    public RMNodeEvent(RMEventType eventType, NodeState state, NodeState previousState) {
        super(eventType);
        this.nodeUrl = null;
        this.nodeSource = null;
        this.PADName = null;
        this.VnName = null;
        this.hostName = null;
        this.VMName = null;
        this.nodeProvider = null;
        this.nodeOwner = null;
        this.description = null;
        this.defaultJMXUrl = null;
        this.proactiveJMXUrl = null;
        this.isLocked = false;
        this.lockTime = -1L;
        this.nodeLocker = null;
        this.nodeState = state;
        this.previousNodeState = previousState;
        this.usageInfo = null;
        this.tokens = null;
        this.tenant = null;
    }

    @Override
    public String getKey() {
        return this.getNodeUrl();
    }

    public String getTenant() {
        return this.tenant;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getKey() == null ? 0 : this.getKey().hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RMNodeEvent)) {
            return false;
        }
        RMNodeEvent other = (RMNodeEvent)obj;
        return !(this.getKey() == null ? other.getKey() != null : !this.getKey().equals(other.getKey()));
    }

    public String getNodeUrl() {
        return this.nodeUrl;
    }

    public String getNodeSource() {
        return this.nodeSource;
    }

    public String getPADName() {
        return this.PADName;
    }

    public String getVnName() {
        return this.VnName;
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getVMName() {
        return this.VMName;
    }

    public NodeState getNodeState() {
        return this.nodeState;
    }

    public NodeState getPreviousNodeState() {
        return this.previousNodeState;
    }

    public String getNodeProvider() {
        return this.nodeProvider;
    }

    public String getNodeOwner() {
        return this.nodeOwner;
    }

    @Override
    public String toString() {
        return this.nodeUrl + " : " + (Object)((Object)this.getEventType()) + (this.counter > 0L ? " counter: " + this.counter + " " : "") + "[" + (Object)((Object)this.nodeState) + "]";
    }

    public String getNodeInfo() {
        return this.description;
    }

    public String getDefaultJMXUrl() {
        return this.defaultJMXUrl;
    }

    public String getProactiveJMXUrl() {
        return this.proactiveJMXUrl;
    }

    public boolean isLocked() {
        return this.isLocked;
    }

    public long getLockTime() {
        return this.lockTime;
    }

    public String getNodeLocker() {
        return this.nodeLocker;
    }

    public Map<String, String> getUsageInfo() {
        return this.usageInfo;
    }

    public List<String> getTokens() {
        return this.tokens;
    }

    public String getDescription() {
        return this.description;
    }
}

