# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import msrest.serialization


class SubResource(msrest.serialization.Model):
    """Reference to another subresource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SubResource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class AgentPool(SubResource):
    """Agent Pool.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param count: Number of agents (VMs) to host docker containers. Allowed values must be in the
     range of 0 to 1000 (inclusive) for user pools and in the range of 1 to 1000 (inclusive) for
     system pools. The default value is 1.
    :type count: int
    :param vm_size: Size of agent VMs.
    :type vm_size: str
    :param os_disk_size_gb: OS Disk Size in GB to be used to specify the disk size for every
     machine in this master/agent pool. If you specify 0, it will apply the default osDisk size
     according to the vmSize specified.
    :type os_disk_size_gb: int
    :param os_disk_type: OS disk type to be used for machines in a given agent pool. Allowed values
     are 'Ephemeral' and 'Managed'. If unspecified, defaults to 'Ephemeral' when the VM supports
     ephemeral OS and has a cache disk larger than the requested OSDiskSizeGB. Otherwise, defaults
     to 'Managed'. May not be changed after creation. Possible values include: "Managed",
     "Ephemeral".
    :type os_disk_type: str or ~azure.mgmt.containerservice.v2021_05_01.models.OSDiskType
    :param kubelet_disk_type: KubeletDiskType determines the placement of emptyDir volumes,
     container runtime data root, and Kubelet ephemeral storage. Currently allows one value, OS,
     resulting in Kubelet using the OS disk for data. Possible values include: "OS", "Temporary".
    :type kubelet_disk_type: str or ~azure.mgmt.containerservice.v2021_05_01.models.KubeletDiskType
    :param vnet_subnet_id: VNet SubnetID specifies the VNet's subnet identifier for nodes and maybe
     pods.
    :type vnet_subnet_id: str
    :param pod_subnet_id: Pod SubnetID specifies the VNet's subnet identifier for pods.
    :type pod_subnet_id: str
    :param max_pods: Maximum number of pods that can run on a node.
    :type max_pods: int
    :param os_type: OsType to be used to specify os type. Choose from Linux and Windows. Default to
     Linux. Possible values include: "Linux", "Windows". Default value: "Linux".
    :type os_type: str or ~azure.mgmt.containerservice.v2021_05_01.models.OSType
    :param os_sku: OsSKU to be used to specify os sku. Choose from Ubuntu(default) and CBLMariner
     for Linux OSType. Not applicable to Windows OSType. Possible values include: "Ubuntu",
     "CBLMariner".
    :type os_sku: str or ~azure.mgmt.containerservice.v2021_05_01.models.OSSKU
    :param max_count: Maximum number of nodes for auto-scaling.
    :type max_count: int
    :param min_count: Minimum number of nodes for auto-scaling.
    :type min_count: int
    :param enable_auto_scaling: Whether to enable auto-scaler.
    :type enable_auto_scaling: bool
    :param type_properties_type: AgentPoolType represents types of an agent pool. Possible values
     include: "VirtualMachineScaleSets", "AvailabilitySet".
    :type type_properties_type: str or
     ~azure.mgmt.containerservice.v2021_05_01.models.AgentPoolType
    :param mode: AgentPoolMode represents mode of an agent pool. Possible values include: "System",
     "User".
    :type mode: str or ~azure.mgmt.containerservice.v2021_05_01.models.AgentPoolMode
    :param orchestrator_version: Version of orchestrator specified when creating the managed
     cluster.
    :type orchestrator_version: str
    :ivar node_image_version: Version of node image.
    :vartype node_image_version: str
    :param upgrade_settings: Settings for upgrading the agentpool.
    :type upgrade_settings:
     ~azure.mgmt.containerservice.v2021_05_01.models.AgentPoolUpgradeSettings
    :ivar provisioning_state: The current deployment or provisioning state, which only appears in
     the response.
    :vartype provisioning_state: str
    :ivar power_state: Describes whether the Agent Pool is Running or Stopped.
    :vartype power_state: ~azure.mgmt.containerservice.v2021_05_01.models.PowerState
    :param availability_zones: Availability zones for nodes. Must use VirtualMachineScaleSets
     AgentPoolType.
    :type availability_zones: list[str]
    :param enable_node_public_ip: Enable public IP for nodes.
    :type enable_node_public_ip: bool
    :param node_public_ip_prefix_id: Public IP Prefix ID. VM nodes use IPs assigned from this
     Public IP Prefix.
    :type node_public_ip_prefix_id: str
    :param scale_set_priority: ScaleSetPriority to be used to specify virtual machine scale set
     priority. Default to regular. Possible values include: "Spot", "Regular". Default value:
     "Regular".
    :type scale_set_priority: str or
     ~azure.mgmt.containerservice.v2021_05_01.models.ScaleSetPriority
    :param scale_set_eviction_policy: ScaleSetEvictionPolicy to be used to specify eviction policy
     for Spot virtual machine scale set. Default to Delete. Possible values include: "Delete",
     "Deallocate". Default value: "Delete".
    :type scale_set_eviction_policy: str or
     ~azure.mgmt.containerservice.v2021_05_01.models.ScaleSetEvictionPolicy
    :param spot_max_price: SpotMaxPrice to be used to specify the maximum price you are willing to
     pay in US Dollars. Possible values are any decimal value greater than zero or -1 which
     indicates default price to be up-to on-demand.
    :type spot_max_price: float
    :param tags: A set of tags. Agent pool tags to be persisted on the agent pool virtual machine
     scale set.
    :type tags: dict[str, str]
    :param node_labels: Agent pool node labels to be persisted across all nodes in agent pool.
    :type node_labels: dict[str, str]
    :param node_taints: Taints added to new nodes during node pool create and scale. For example,
     key=value:NoSchedule.
    :type node_taints: list[str]
    :param proximity_placement_group_id: The ID for Proximity Placement Group.
    :type proximity_placement_group_id: str
    :param kubelet_config: KubeletConfig specifies the configuration of kubelet on agent nodes.
    :type kubelet_config: ~azure.mgmt.containerservice.v2021_05_01.models.KubeletConfig
    :param linux_os_config: LinuxOSConfig specifies the OS configuration of linux agent nodes.
    :type linux_os_config: ~azure.mgmt.containerservice.v2021_05_01.models.LinuxOSConfig
    :param enable_encryption_at_host: Whether to enable EncryptionAtHost.
    :type enable_encryption_at_host: bool
    :param enable_ultra_ssd: Whether to enable UltraSSD.
    :type enable_ultra_ssd: bool
    :param enable_fips: Whether to use FIPS enabled OS.
    :type enable_fips: bool
    :param gpu_instance_profile: GPUInstanceProfile to be used to specify GPU MIG instance profile
     for supported GPU VM SKU. Supported values are MIG1g, MIG2g, MIG3g, MIG4g and MIG7g. Possible
     values include: "MIG1g", "MIG2g", "MIG3g", "MIG4g", "MIG7g".
    :type gpu_instance_profile: str or
     ~azure.mgmt.containerservice.v2021_05_01.models.GPUInstanceProfile
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'os_disk_size_gb': {'maximum': 2048, 'minimum': 0},
        'node_image_version': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'power_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'count': {'key': 'properties.count', 'type': 'int'},
        'vm_size': {'key': 'properties.vmSize', 'type': 'str'},
        'os_disk_size_gb': {'key': 'properties.osDiskSizeGB', 'type': 'int'},
        'os_disk_type': {'key': 'properties.osDiskType', 'type': 'str'},
        'kubelet_disk_type': {'key': 'properties.kubeletDiskType', 'type': 'str'},
        'vnet_subnet_id': {'key': 'properties.vnetSubnetID', 'type': 'str'},
        'pod_subnet_id': {'key': 'properties.podSubnetID', 'type': 'str'},
        'max_pods': {'key': 'properties.maxPods', 'type': 'int'},
        'os_type': {'key': 'properties.osType', 'type': 'str'},
        'os_sku': {'key': 'properties.osSKU', 'type': 'str'},
        'max_count': {'key': 'properties.maxCount', 'type': 'int'},
        'min_count': {'key': 'properties.minCount', 'type': 'int'},
        'enable_auto_scaling': {'key': 'properties.enableAutoScaling', 'type': 'bool'},
        'type_properties_type': {'key': 'properties.type', 'type': 'str'},
        'mode': {'key': 'properties.mode', 'type': 'str'},
        'orchestrator_version': {'key': 'properties.orchestratorVersion', 'type': 'str'},
        'node_image_version': {'key': 'properties.nodeImageVersion', 'type': 'str'},
        'upgrade_settings': {'key': 'properties.upgradeSettings', 'type': 'AgentPoolUpgradeSettings'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'power_state': {'key': 'properties.powerState', 'type': 'PowerState'},
        'availability_zones': {'key': 'properties.availabilityZones', 'type': '[str]'},
        'enable_node_public_ip': {'key': 'properties.enableNodePublicIP', 'type': 'bool'},
        'node_public_ip_prefix_id': {'key': 'properties.nodePublicIPPrefixID', 'type': 'str'},
        'scale_set_priority': {'key': 'properties.scaleSetPriority', 'type': 'str'},
        'scale_set_eviction_policy': {'key': 'properties.scaleSetEvictionPolicy', 'type': 'str'},
        'spot_max_price': {'key': 'properties.spotMaxPrice', 'type': 'float'},
        'tags': {'key': 'properties.tags', 'type': '{str}'},
        'node_labels': {'key': 'properties.nodeLabels', 'type': '{str}'},
        'node_taints': {'key': 'properties.nodeTaints', 'type': '[str]'},
        'proximity_placement_group_id': {'key': 'properties.proximityPlacementGroupID', 'type': 'str'},
        'kubelet_config': {'key': 'properties.kubeletConfig', 'type': 'KubeletConfig'},
        'linux_os_config': {'key': 'properties.linuxOSConfig', 'type': 'LinuxOSConfig'},
        'enable_encryption_at_host': {'key': 'properties.enableEncryptionAtHost', 'type': 'bool'},
        'enable_ultra_ssd': {'key': 'properties.enableUltraSSD', 'type': 'bool'},
        'enable_fips': {'key': 'properties.enableFIPS', 'type': 'bool'},
        'gpu_instance_profile': {'key': 'properties.gpuInstanceProfile', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AgentPool, self).__init__(**kwargs)
        self.count = kwargs.get('count', None)
        self.vm_size = kwargs.get('vm_size', None)
        self.os_disk_size_gb = kwargs.get('os_disk_size_gb', None)
        self.os_disk_type = kwargs.get('os_disk_type', None)
        self.kubelet_disk_type = kwargs.get('kubelet_disk_type', None)
        self.vnet_subnet_id = kwargs.get('vnet_subnet_id', None)
        self.pod_subnet_id = kwargs.get('pod_subnet_id', None)
        self.max_pods = kwargs.get('max_pods', None)
        self.os_type = kwargs.get('os_type', "Linux")
        self.os_sku = kwargs.get('os_sku', None)
        self.max_count = kwargs.get('max_count', None)
        self.min_count = kwargs.get('min_count', None)
        self.enable_auto_scaling = kwargs.get('enable_auto_scaling', None)
        self.type_properties_type = kwargs.get('type_properties_type', None)
        self.mode = kwargs.get('mode', None)
        self.orchestrator_version = kwargs.get('orchestrator_version', None)
        self.node_image_version = None
        self.upgrade_settings = kwargs.get('upgrade_settings', None)
        self.provisioning_state = None
        self.power_state = None
        self.availability_zones = kwargs.get('availability_zones', None)
        self.enable_node_public_ip = kwargs.get('enable_node_public_ip', None)
        self.node_public_ip_prefix_id = kwargs.get('node_public_ip_prefix_id', None)
        self.scale_set_priority = kwargs.get('scale_set_priority', "Regular")
        self.scale_set_eviction_policy = kwargs.get('scale_set_eviction_policy', "Delete")
        self.spot_max_price = kwargs.get('spot_max_price', -1)
        self.tags = kwargs.get('tags', None)
        self.node_labels = kwargs.get('node_labels', None)
        self.node_taints = kwargs.get('node_taints', None)
        self.proximity_placement_group_id = kwargs.get('proximity_placement_group_id', None)
        self.kubelet_config = kwargs.get('kubelet_config', None)
        self.linux_os_config = kwargs.get('linux_os_config', None)
        self.enable_encryption_at_host = kwargs.get('enable_encryption_at_host', None)
        self.enable_ultra_ssd = kwargs.get('enable_ultra_ssd', None)
        self.enable_fips = kwargs.get('enable_fips', None)
        self.gpu_instance_profile = kwargs.get('gpu_instance_profile', None)


class AgentPoolAvailableVersions(msrest.serialization.Model):
    """The list of available versions for an agent pool.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Id of the agent pool available versions.
    :vartype id: str
    :ivar name: Name of the agent pool available versions.
    :vartype name: str
    :ivar type: Type of the agent pool  available versions.
    :vartype type: str
    :param agent_pool_versions: List of versions available for agent pool.
    :type agent_pool_versions:
     list[~azure.mgmt.containerservice.v2021_05_01.models.AgentPoolAvailableVersionsPropertiesAgentPoolVersionsItem]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'agent_pool_versions': {'key': 'properties.agentPoolVersions', 'type': '[AgentPoolAvailableVersionsPropertiesAgentPoolVersionsItem]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AgentPoolAvailableVersions, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.agent_pool_versions = kwargs.get('agent_pool_versions', None)


class AgentPoolAvailableVersionsPropertiesAgentPoolVersionsItem(msrest.serialization.Model):
    """AgentPoolAvailableVersionsPropertiesAgentPoolVersionsItem.

    :param default: Whether this version is the default agent pool version.
    :type default: bool
    :param kubernetes_version: Kubernetes version (major, minor, patch).
    :type kubernetes_version: str
    :param is_preview: Whether Kubernetes version is currently in preview.
    :type is_preview: bool
    """

    _attribute_map = {
        'default': {'key': 'default', 'type': 'bool'},
        'kubernetes_version': {'key': 'kubernetesVersion', 'type': 'str'},
        'is_preview': {'key': 'isPreview', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AgentPoolAvailableVersionsPropertiesAgentPoolVersionsItem, self).__init__(**kwargs)
        self.default = kwargs.get('default', None)
        self.kubernetes_version = kwargs.get('kubernetes_version', None)
        self.is_preview = kwargs.get('is_preview', None)


class AgentPoolListResult(msrest.serialization.Model):
    """The response from the List Agent Pools operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value: The list of agent pools.
    :type value: list[~azure.mgmt.containerservice.v2021_05_01.models.AgentPool]
    :ivar next_link: The URL to get the next set of agent pool results.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[AgentPool]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AgentPoolListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = None


class AgentPoolUpgradeProfile(msrest.serialization.Model):
    """The list of available upgrades for an agent pool.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Id of the agent pool upgrade profile.
    :vartype id: str
    :ivar name: Name of the agent pool upgrade profile.
    :vartype name: str
    :ivar type: Type of the agent pool upgrade profile.
    :vartype type: str
    :param kubernetes_version: Required. Kubernetes version (major, minor, patch).
    :type kubernetes_version: str
    :param os_type: Required. OsType to be used to specify os type. Choose from Linux and Windows.
     Default to Linux. Possible values include: "Linux", "Windows". Default value: "Linux".
    :type os_type: str or ~azure.mgmt.containerservice.v2021_05_01.models.OSType
    :param upgrades: List of orchestrator types and versions available for upgrade.
    :type upgrades:
     list[~azure.mgmt.containerservice.v2021_05_01.models.AgentPoolUpgradeProfilePropertiesUpgradesItem]
    :param latest_node_image_version: LatestNodeImageVersion is the latest AKS supported node image
     version.
    :type latest_node_image_version: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'kubernetes_version': {'required': True},
        'os_type': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'kubernetes_version': {'key': 'properties.kubernetesVersion', 'type': 'str'},
        'os_type': {'key': 'properties.osType', 'type': 'str'},
        'upgrades': {'key': 'properties.upgrades', 'type': '[AgentPoolUpgradeProfilePropertiesUpgradesItem]'},
        'latest_node_image_version': {'key': 'properties.latestNodeImageVersion', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AgentPoolUpgradeProfile, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.kubernetes_version = kwargs['kubernetes_version']
        self.os_type = kwargs.get('os_type', "Linux")
        self.upgrades = kwargs.get('upgrades', None)
        self.latest_node_image_version = kwargs.get('latest_node_image_version', None)


class AgentPoolUpgradeProfilePropertiesUpgradesItem(msrest.serialization.Model):
    """AgentPoolUpgradeProfilePropertiesUpgradesItem.

    :param kubernetes_version: Kubernetes version (major, minor, patch).
    :type kubernetes_version: str
    :param is_preview: Whether Kubernetes version is currently in preview.
    :type is_preview: bool
    """

    _attribute_map = {
        'kubernetes_version': {'key': 'kubernetesVersion', 'type': 'str'},
        'is_preview': {'key': 'isPreview', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AgentPoolUpgradeProfilePropertiesUpgradesItem, self).__init__(**kwargs)
        self.kubernetes_version = kwargs.get('kubernetes_version', None)
        self.is_preview = kwargs.get('is_preview', None)


class AgentPoolUpgradeSettings(msrest.serialization.Model):
    """Settings for upgrading an agentpool.

    :param max_surge: Count or percentage of additional nodes to be added during upgrade. If empty
     uses AKS default.
    :type max_surge: str
    """

    _attribute_map = {
        'max_surge': {'key': 'maxSurge', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AgentPoolUpgradeSettings, self).__init__(**kwargs)
        self.max_surge = kwargs.get('max_surge', None)


class CloudError(msrest.serialization.Model):
    """An error response from the Container service.

    :param error: Details about the error.
    :type error: ~azure.mgmt.containerservice.v2021_05_01.models.CloudErrorBody
    """

    _attribute_map = {
        'error': {'key': 'error', 'type': 'CloudErrorBody'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CloudError, self).__init__(**kwargs)
        self.error = kwargs.get('error', None)


class CloudErrorBody(msrest.serialization.Model):
    """An error response from the Container service.

    :param code: An identifier for the error. Codes are invariant and are intended to be consumed
     programmatically.
    :type code: str
    :param message: A message describing the error, intended to be suitable for display in a user
     interface.
    :type message: str
    :param target: The target of the particular error. For example, the name of the property in
     error.
    :type target: str
    :param details: A list of additional details about the error.
    :type details: list[~azure.mgmt.containerservice.v2021_05_01.models.CloudErrorBody]
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'details': {'key': 'details', 'type': '[CloudErrorBody]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CloudErrorBody, self).__init__(**kwargs)
        self.code = kwargs.get('code', None)
        self.message = kwargs.get('message', None)
        self.target = kwargs.get('target', None)
        self.details = kwargs.get('details', None)


class Components1Q1Og48SchemasManagedclusterAllof1(msrest.serialization.Model):
    """Components1Q1Og48SchemasManagedclusterAllof1.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param identity: The identity of the managed cluster, if configured.
    :type identity: ~azure.mgmt.containerservice.v2021_05_01.models.ManagedClusterIdentity
    :ivar provisioning_state: The current deployment or provisioning state, which only appears in
     the response.
    :vartype provisioning_state: str
    :ivar power_state: Represents the Power State of the cluster.
    :vartype power_state: ~azure.mgmt.containerservice.v2021_05_01.models.PowerState
    :ivar max_agent_pools: The max number of agent pools for the managed cluster.
    :vartype max_agent_pools: int
    :param kubernetes_version: Version of Kubernetes specified when creating the managed cluster.
    :type kubernetes_version: str
    :param dns_prefix: DNS prefix specified when creating the managed cluster.
    :type dns_prefix: str
    :param fqdn_subdomain: FQDN subdomain specified when creating private cluster with custom
     private dns zone.
    :type fqdn_subdomain: str
    :ivar fqdn: FQDN for the master pool.
    :vartype fqdn: str
    :ivar private_fqdn: FQDN of private cluster.
    :vartype private_fqdn: str
    :ivar azure_portal_fqdn: FQDN for the master pool which used by proxy config.
    :vartype azure_portal_fqdn: str
    :param agent_pool_profiles: Properties of the agent pool.
    :type agent_pool_profiles:
     list[~azure.mgmt.containerservice.v2021_05_01.models.ManagedClusterAgentPoolProfile]
    :param linux_profile: Profile for Linux VMs in the container service cluster.
    :type linux_profile:
     ~azure.mgmt.containerservice.v2021_05_01.models.ContainerServiceLinuxProfile
    :param windows_profile: Profile for Windows VMs in the container service cluster.
    :type windows_profile:
     ~azure.mgmt.containerservice.v2021_05_01.models.ManagedClusterWindowsProfile
    :param service_principal_profile: Information about a service principal identity for the
     cluster to use for manipulating Azure APIs.
    :type service_principal_profile:
     ~azure.mgmt.containerservice.v2021_05_01.models.ManagedClusterServicePrincipalProfile
    :param addon_profiles: Profile of managed cluster add-on.
    :type addon_profiles: dict[str,
     ~azure.mgmt.containerservice.v2021_05_01.models.ManagedClusterAddonProfile]
    :param pod_identity_profile: Profile of managed cluster pod identity.
    :type pod_identity_profile:
     ~azure.mgmt.containerservice.v2021_05_01.models.ManagedClusterPodIdentityProfile
    :param node_resource_group: Name of the resource group containing agent pool nodes.
    :type node_resource_group: str
    :param enable_rbac: Whether to enable Kubernetes Role-Based Access Control.
    :type enable_rbac: bool
    :param enable_pod_security_policy: (DEPRECATING) Whether to enable Kubernetes pod security
     policy (preview). This feature is set for removal on October 15th, 2020. Learn more at
     aka.ms/aks/azpodpolicy.
    :type enable_pod_security_policy: bool
    :param network_profile: Profile of network configuration.
    :type network_profile:
     ~azure.mgmt.containerservice.v2021_05_01.models.ContainerServiceNetworkProfile
    :param aad_profile: Profile of Azure Active Directory configuration.
    :type aad_profile: ~azure.mgmt.containerservice.v2021_05_01.models.ManagedClusterAADProfile
    :param auto_upgrade_profile: Profile of auto upgrade configuration.
    :type auto_upgrade_profile:
     ~azure.mgmt.containerservice.v2021_05_01.models.ManagedClusterAutoUpgradeProfile
    :param auto_scaler_profile: Parameters to be applied to the cluster-autoscaler when enabled.
    :type auto_scaler_profile:
     ~azure.mgmt.containerservice.v2021_05_01.models.ManagedClusterPropertiesAutoScalerProfile
    :param api_server_access_profile: Access profile for managed cluster API server.
    :type api_server_access_profile:
     ~azure.mgmt.containerservice.v2021_05_01.models.ManagedClusterAPIServerAccessProfile
    :param disk_encryption_set_id: ResourceId of the disk encryption set to use for enabling
     encryption at rest.
    :type disk_encryption_set_id: str
    :param identity_profile: Identities associated with the cluster.
    :type identity_profile: dict[str,
     ~azure.mgmt.containerservice.v2021_05_01.models.ComponentsQit0EtSchemasManagedclusterpropertiesPropertiesIdentityprofileAdditionalproperties]
    :param private_link_resources: Private link resources associated with the cluster.
    :type private_link_resources:
     list[~azure.mgmt.containerservice.v2021_05_01.models.PrivateLinkResource]
    :param disable_local_accounts: If set to true, getting static credential will be disabled for
     this cluster. Expected to only be used for AAD clusters.
    :type disable_local_accounts: bool
    :param http_proxy_config: Configurations for provisioning the cluster with HTTP proxy servers.
    :type http_proxy_config:
     ~azure.mgmt.containerservice.v2021_05_01.models.ManagedClusterHTTPProxyConfig
    """

    _validation = {
        'provisioning_state': {'readonly': True},
        'power_state': {'readonly': True},
        'max_agent_pools': {'readonly': True},
        'fqdn': {'readonly': True},
        'private_fqdn': {'readonly': True},
        'azure_portal_fqdn': {'readonly': True},
    }

    _attribute_map = {
        'identity': {'key': 'identity', 'type': 'ManagedClusterIdentity'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'power_state': {'key': 'properties.powerState', 'type': 'PowerState'},
        'max_agent_pools': {'key': 'properties.maxAgentPools', 'type': 'int'},
        'kubernetes_version': {'key': 'properties.kubernetesVersion', 'type': 'str'},
        'dns_prefix': {'key': 'properties.dnsPrefix', 'type': 'str'},
        'fqdn_subdomain': {'key': 'properties.fqdnSubdomain', 'type': 'str'},
        'fqdn': {'key': 'properties.fqdn', 'type': 'str'},
        'private_fqdn': {'key': 'properties.privateFQDN', 'type': 'str'},
        'azure_portal_fqdn': {'key': 'properties.azurePortalFQDN', 'type': 'str'},
        'agent_pool_profiles': {'key': 'properties.agentPoolProfiles', 'type': '[ManagedClusterAgentPoolProfile]'},
        'linux_profile': {'key': 'properties.linuxProfile', 'type': 'ContainerServiceLinuxProfile'},
        'windows_profile': {'key': 'properties.windowsProfile', 'type': 'ManagedClusterWindowsProfile'},
        'service_principal_profile': {'key': 'properties.servicePrincipalProfile', 'type': 'ManagedClusterServicePrincipalProfile'},
        'addon_profiles': {'key': 'properties.addonProfiles', 'type': '{ManagedClusterAddonProfile}'},
        'pod_identity_profile': {'key': 'properties.podIdentityProfile', 'type': 'ManagedClusterPodIdentityProfile'},
        'node_resource_group': {'key': 'properties.nodeResourceGroup', 'type': 'str'},
        'enable_rbac': {'key': 'properties.enableRBAC', 'type': 'bool'},
        'enable_pod_security_policy': {'key': 'properties.enablePodSecurityPolicy', 'type': 'bool'},
        'network_profile': {'key': 'properties.networkProfile', 'type': 'ContainerServiceNetworkProfile'},
        'aad_profile': {'key': 'properties.aadProfile', 'type': 'ManagedClusterAADProfile'},
        'auto_upgrade_profile': {'key': 'properties.autoUpgradeProfile', 'type': 'ManagedClusterAutoUpgradeProfile'},
        'auto_scaler_profile': {'key': 'properties.autoScalerProfile', 'type': 'ManagedClusterPropertiesAutoScalerProfile'},
        'api_server_access_profile': {'key': 'properties.apiServerAccessProfile', 'type': 'ManagedClusterAPIServerAccessProfile'},
        'disk_encryption_set_id': {'key': 'properties.diskEncryptionSetID', 'type': 'str'},
        'identity_profile': {'key': 'properties.identityProfile', 'type': '{ComponentsQit0EtSchemasManagedclusterpropertiesPropertiesIdentityprofileAdditionalproperties}'},
        'private_link_resources': {'key': 'properties.privateLinkResources', 'type': '[PrivateLinkResource]'},
        'disable_local_accounts': {'key': 'properties.disableLocalAccounts', 'type': 'bool'},
        'http_proxy_config': {'key': 'properties.httpProxyConfig', 'type': 'ManagedClusterHTTPProxyConfig'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Components1Q1Og48SchemasManagedclusterAllof1, self).__init__(**kwargs)
        self.identity = kwargs.get('identity', None)
        self.provisioning_state = None
        self.power_state = None
        self.max_agent_pools = None
        self.kubernetes_version = kwargs.get('kubernetes_version', None)
        self.dns_prefix = kwargs.get('dns_prefix', None)
        self.fqdn_subdomain = kwargs.get('fqdn_subdomain', None)
        self.fqdn = None
        self.private_fqdn = None
        self.azure_portal_fqdn = None
        self.agent_pool_profiles = kwargs.get('agent_pool_profiles', None)
        self.linux_profile = kwargs.get('linux_profile', None)
        self.windows_profile = kwargs.get('windows_profile', None)
        self.service_principal_profile = kwargs.get('service_principal_profile', None)
        self.addon_profiles = kwargs.get('addon_profiles', None)
        self.pod_identity_profile = kwargs.get('pod_identity_profile', None)
        self.node_resource_group = kwargs.get('node_resource_group', None)
        self.enable_rbac = kwargs.get('enable_rbac', None)
        self.enable_pod_security_policy = kwargs.get('enable_pod_security_policy', None)
        self.network_profile = kwargs.get('network_profile', None)
        self.aad_profile = kwargs.get('aad_profile', None)
        self.auto_upgrade_profile = kwargs.get('auto_upgrade_profile', None)
        self.auto_scaler_profile = kwargs.get('auto_scaler_profile', None)
        self.api_server_access_profile = kwargs.get('api_server_access_profile', None)
        self.disk_encryption_set_id = kwargs.get('disk_encryption_set_id', None)
        self.identity_profile = kwargs.get('identity_profile', None)
        self.private_link_resources = kwargs.get('private_link_resources', None)
        self.disable_local_accounts = kwargs.get('disable_local_accounts', None)
        self.http_proxy_config = kwargs.get('http_proxy_config', None)


class Components1Umhcm8SchemasManagedclusteridentityPropertiesUserassignedidentitiesAdditionalproperties(msrest.serialization.Model):
    """Components1Umhcm8SchemasManagedclusteridentityPropertiesUserassignedidentitiesAdditionalproperties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The principal id of user assigned identity.
    :vartype principal_id: str
    :ivar client_id: The client id of user assigned identity.
    :vartype client_id: str
    """

    _validation = {
        'principal_id': {'readonly': True},
        'client_id': {'readonly': True},
    }

    _attribute_map = {
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'client_id': {'key': 'clientId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Components1Umhcm8SchemasManagedclusteridentityPropertiesUserassignedidentitiesAdditionalproperties, self).__init__(**kwargs)
        self.principal_id = None
        self.client_id = None


class UserAssignedIdentity(msrest.serialization.Model):
    """UserAssignedIdentity.

    :param resource_id: The resource id of the user assigned identity.
    :type resource_id: str
    :param client_id: The client id of the user assigned identity.
    :type client_id: str
    :param object_id: The object id of the user assigned identity.
    :type object_id: str
    """

    _attribute_map = {
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'client_id': {'key': 'clientId', 'type': 'str'},
        'object_id': {'key': 'objectId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(UserAssignedIdentity, self).__init__(**kwargs)
        self.resource_id = kwargs.get('resource_id', None)
        self.client_id = kwargs.get('client_id', None)
        self.object_id = kwargs.get('object_id', None)


class ComponentsQit0EtSchemasManagedclusterpropertiesPropertiesIdentityprofileAdditionalproperties(UserAssignedIdentity):
    """ComponentsQit0EtSchemasManagedclusterpropertiesPropertiesIdentityprofileAdditionalproperties.

    :param resource_id: The resource id of the user assigned identity.
    :type resource_id: str
    :param client_id: The client id of the user assigned identity.
    :type client_id: str
    :param object_id: The object id of the user assigned identity.
    :type object_id: str
    """

    _attribute_map = {
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'client_id': {'key': 'clientId', 'type': 'str'},
        'object_id': {'key': 'objectId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ComponentsQit0EtSchemasManagedclusterpropertiesPropertiesIdentityprofileAdditionalproperties, self).__init__(**kwargs)


class ContainerServiceDiagnosticsProfile(msrest.serialization.Model):
    """Profile for diagnostics on the container service cluster.

    All required parameters must be populated in order to send to Azure.

    :param vm_diagnostics: Required. Profile for diagnostics on the container service VMs.
    :type vm_diagnostics:
     ~azure.mgmt.containerservice.v2021_05_01.models.ContainerServiceVMDiagnostics
    """

    _validation = {
        'vm_diagnostics': {'required': True},
    }

    _attribute_map = {
        'vm_diagnostics': {'key': 'vmDiagnostics', 'type': 'ContainerServiceVMDiagnostics'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ContainerServiceDiagnosticsProfile, self).__init__(**kwargs)
        self.vm_diagnostics = kwargs['vm_diagnostics']


class ContainerServiceLinuxProfile(msrest.serialization.Model):
    """Profile for Linux VMs in the container service cluster.

    All required parameters must be populated in order to send to Azure.

    :param admin_username: Required. The administrator username to use for Linux VMs.
    :type admin_username: str
    :param ssh: Required. SSH configuration for Linux-based VMs running on Azure.
    :type ssh: ~azure.mgmt.containerservice.v2021_05_01.models.ContainerServiceSshConfiguration
    """

    _validation = {
        'admin_username': {'required': True, 'pattern': r'^[A-Za-z][-A-Za-z0-9_]*$'},
        'ssh': {'required': True},
    }

    _attribute_map = {
        'admin_username': {'key': 'adminUsername', 'type': 'str'},
        'ssh': {'key': 'ssh', 'type': 'ContainerServiceSshConfiguration'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ContainerServiceLinuxProfile, self).__init__(**kwargs)
        self.admin_username = kwargs['admin_username']
        self.ssh = kwargs['ssh']


class ContainerServiceMasterProfile(msrest.serialization.Model):
    """Profile for the container service master.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param count: Number of masters (VMs) in the container service cluster. Allowed values are 1,
     3, and 5. The default value is 1. Possible values include: 1, 3, 5. Default value: "1".
    :type count: str or ~azure.mgmt.containerservice.v2021_05_01.models.Count
    :param dns_prefix: Required. DNS prefix to be used to create the FQDN for the master pool.
    :type dns_prefix: str
    :param vm_size: Required. Size of agent VMs. Possible values include: "Standard_A1",
     "Standard_A10", "Standard_A11", "Standard_A1_v2", "Standard_A2", "Standard_A2_v2",
     "Standard_A2m_v2", "Standard_A3", "Standard_A4", "Standard_A4_v2", "Standard_A4m_v2",
     "Standard_A5", "Standard_A6", "Standard_A7", "Standard_A8", "Standard_A8_v2",
     "Standard_A8m_v2", "Standard_A9", "Standard_B2ms", "Standard_B2s", "Standard_B4ms",
     "Standard_B8ms", "Standard_D1", "Standard_D11", "Standard_D11_v2", "Standard_D11_v2_Promo",
     "Standard_D12", "Standard_D12_v2", "Standard_D12_v2_Promo", "Standard_D13", "Standard_D13_v2",
     "Standard_D13_v2_Promo", "Standard_D14", "Standard_D14_v2", "Standard_D14_v2_Promo",
     "Standard_D15_v2", "Standard_D16_v3", "Standard_D16s_v3", "Standard_D1_v2", "Standard_D2",
     "Standard_D2_v2", "Standard_D2_v2_Promo", "Standard_D2_v3", "Standard_D2s_v3", "Standard_D3",
     "Standard_D32_v3", "Standard_D32s_v3", "Standard_D3_v2", "Standard_D3_v2_Promo", "Standard_D4",
     "Standard_D4_v2", "Standard_D4_v2_Promo", "Standard_D4_v3", "Standard_D4s_v3",
     "Standard_D5_v2", "Standard_D5_v2_Promo", "Standard_D64_v3", "Standard_D64s_v3",
     "Standard_D8_v3", "Standard_D8s_v3", "Standard_DS1", "Standard_DS11", "Standard_DS11_v2",
     "Standard_DS11_v2_Promo", "Standard_DS12", "Standard_DS12_v2", "Standard_DS12_v2_Promo",
     "Standard_DS13", "Standard_DS13-2_v2", "Standard_DS13-4_v2", "Standard_DS13_v2",
     "Standard_DS13_v2_Promo", "Standard_DS14", "Standard_DS14-4_v2", "Standard_DS14-8_v2",
     "Standard_DS14_v2", "Standard_DS14_v2_Promo", "Standard_DS15_v2", "Standard_DS1_v2",
     "Standard_DS2", "Standard_DS2_v2", "Standard_DS2_v2_Promo", "Standard_DS3", "Standard_DS3_v2",
     "Standard_DS3_v2_Promo", "Standard_DS4", "Standard_DS4_v2", "Standard_DS4_v2_Promo",
     "Standard_DS5_v2", "Standard_DS5_v2_Promo", "Standard_E16_v3", "Standard_E16s_v3",
     "Standard_E2_v3", "Standard_E2s_v3", "Standard_E32-16s_v3", "Standard_E32-8s_v3",
     "Standard_E32_v3", "Standard_E32s_v3", "Standard_E4_v3", "Standard_E4s_v3",
     "Standard_E64-16s_v3", "Standard_E64-32s_v3", "Standard_E64_v3", "Standard_E64s_v3",
     "Standard_E8_v3", "Standard_E8s_v3", "Standard_F1", "Standard_F16", "Standard_F16s",
     "Standard_F16s_v2", "Standard_F1s", "Standard_F2", "Standard_F2s", "Standard_F2s_v2",
     "Standard_F32s_v2", "Standard_F4", "Standard_F4s", "Standard_F4s_v2", "Standard_F64s_v2",
     "Standard_F72s_v2", "Standard_F8", "Standard_F8s", "Standard_F8s_v2", "Standard_G1",
     "Standard_G2", "Standard_G3", "Standard_G4", "Standard_G5", "Standard_GS1", "Standard_GS2",
     "Standard_GS3", "Standard_GS4", "Standard_GS4-4", "Standard_GS4-8", "Standard_GS5",
     "Standard_GS5-16", "Standard_GS5-8", "Standard_H16", "Standard_H16m", "Standard_H16mr",
     "Standard_H16r", "Standard_H8", "Standard_H8m", "Standard_L16s", "Standard_L32s",
     "Standard_L4s", "Standard_L8s", "Standard_M128-32ms", "Standard_M128-64ms", "Standard_M128ms",
     "Standard_M128s", "Standard_M64-16ms", "Standard_M64-32ms", "Standard_M64ms", "Standard_M64s",
     "Standard_NC12", "Standard_NC12s_v2", "Standard_NC12s_v3", "Standard_NC24", "Standard_NC24r",
     "Standard_NC24rs_v2", "Standard_NC24rs_v3", "Standard_NC24s_v2", "Standard_NC24s_v3",
     "Standard_NC6", "Standard_NC6s_v2", "Standard_NC6s_v3", "Standard_ND12s", "Standard_ND24rs",
     "Standard_ND24s", "Standard_ND6s", "Standard_NV12", "Standard_NV24", "Standard_NV6".
    :type vm_size: str or
     ~azure.mgmt.containerservice.v2021_05_01.models.ContainerServiceVMSizeTypes
    :param os_disk_size_gb: OS Disk Size in GB to be used to specify the disk size for every
     machine in this master/agent pool. If you specify 0, it will apply the default osDisk size
     according to the vmSize specified.
    :type os_disk_size_gb: int
    :param vnet_subnet_id: VNet SubnetID specifies the VNet's subnet identifier.
    :type vnet_subnet_id: str
    :param first_consecutive_static_ip: FirstConsecutiveStaticIP used to specify the first static
     ip of masters.
    :type first_consecutive_static_ip: str
    :param storage_profile: Storage profile specifies what kind of storage used. Choose from
     StorageAccount and ManagedDisks. Leave it empty, we will choose for you based on the
     orchestrator choice. Possible values include: "StorageAccount", "ManagedDisks".
    :type storage_profile: str or
     ~azure.mgmt.containerservice.v2021_05_01.models.ContainerServiceStorageProfileTypes
    :ivar fqdn: FQDN for the master pool.
    :vartype fqdn: str
    """

    _validation = {
        'dns_prefix': {'required': True},
        'vm_size': {'required': True},
        'os_disk_size_gb': {'maximum': 2048, 'minimum': 0},
        'fqdn': {'readonly': True},
    }

    _attribute_map = {
        'count': {'key': 'count', 'type': 'int'},
        'dns_prefix': {'key': 'dnsPrefix', 'type': 'str'},
        'vm_size': {'key': 'vmSize', 'type': 'str'},
        'os_disk_size_gb': {'key': 'osDiskSizeGB', 'type': 'int'},
        'vnet_subnet_id': {'key': 'vnetSubnetID', 'type': 'str'},
        'first_consecutive_static_ip': {'key': 'firstConsecutiveStaticIP', 'type': 'str'},
        'storage_profile': {'key': 'storageProfile', 'type': 'str'},
        'fqdn': {'key': 'fqdn', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ContainerServiceMasterProfile, self).__init__(**kwargs)
        self.count = kwargs.get('count', "1")
        self.dns_prefix = kwargs['dns_prefix']
        self.vm_size = kwargs['vm_size']
        self.os_disk_size_gb = kwargs.get('os_disk_size_gb', None)
        self.vnet_subnet_id = kwargs.get('vnet_subnet_id', None)
        self.first_consecutive_static_ip = kwargs.get('first_consecutive_static_ip', "10.240.255.5")
        self.storage_profile = kwargs.get('storage_profile', None)
        self.fqdn = None


class ContainerServiceNetworkProfile(msrest.serialization.Model):
    """Profile of network configuration.

    :param network_plugin: Network plugin used for building Kubernetes network. Possible values
     include: "azure", "kubenet". Default value: "kubenet".
    :type network_plugin: str or ~azure.mgmt.containerservice.v2021_05_01.models.NetworkPlugin
    :param network_policy: Network policy used for building Kubernetes network. Possible values
     include: "calico", "azure".
    :type network_policy: str or ~azure.mgmt.containerservice.v2021_05_01.models.NetworkPolicy
    :param network_mode: Network mode used for building Kubernetes network. Possible values
     include: "transparent", "bridge".
    :type network_mode: str or ~azure.mgmt.containerservice.v2021_05_01.models.NetworkMode
    :param pod_cidr: A CIDR notation IP range from which to assign pod IPs when kubenet is used.
    :type pod_cidr: str
    :param service_cidr: A CIDR notation IP range from which to assign service cluster IPs. It must
     not overlap with any Subnet IP ranges.
    :type service_cidr: str
    :param dns_service_ip: An IP address assigned to the Kubernetes DNS service. It must be within
     the Kubernetes service address range specified in serviceCidr.
    :type dns_service_ip: str
    :param docker_bridge_cidr: A CIDR notation IP range assigned to the Docker bridge network. It
     must not overlap with any Subnet IP ranges or the Kubernetes service address range.
    :type docker_bridge_cidr: str
    :param outbound_type: The outbound (egress) routing method. Possible values include:
     "loadBalancer", "userDefinedRouting". Default value: "loadBalancer".
    :type outbound_type: str or ~azure.mgmt.containerservice.v2021_05_01.models.OutboundType
    :param load_balancer_sku: The load balancer sku for the managed cluster. Possible values
     include: "standard", "basic".
    :type load_balancer_sku: str or ~azure.mgmt.containerservice.v2021_05_01.models.LoadBalancerSku
    :param load_balancer_profile: Profile of the cluster load balancer.
    :type load_balancer_profile:
     ~azure.mgmt.containerservice.v2021_05_01.models.ManagedClusterLoadBalancerProfile
    """

    _validation = {
        'pod_cidr': {'pattern': r'^([0-9]{1,3}\.){3}[0-9]{1,3}(\/([0-9]|[1-2][0-9]|3[0-2]))?$'},
        'service_cidr': {'pattern': r'^([0-9]{1,3}\.){3}[0-9]{1,3}(\/([0-9]|[1-2][0-9]|3[0-2]))?$'},
        'dns_service_ip': {'pattern': r'^(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$'},
        'docker_bridge_cidr': {'pattern': r'^([0-9]{1,3}\.){3}[0-9]{1,3}(\/([0-9]|[1-2][0-9]|3[0-2]))?$'},
    }

    _attribute_map = {
        'network_plugin': {'key': 'networkPlugin', 'type': 'str'},
        'network_policy': {'key': 'networkPolicy', 'type': 'str'},
        'network_mode': {'key': 'networkMode', 'type': 'str'},
        'pod_cidr': {'key': 'podCidr', 'type': 'str'},
        'service_cidr': {'key': 'serviceCidr', 'type': 'str'},
        'dns_service_ip': {'key': 'dnsServiceIP', 'type': 'str'},
        'docker_bridge_cidr': {'key': 'dockerBridgeCidr', 'type': 'str'},
        'outbound_type': {'key': 'outboundType', 'type': 'str'},
        'load_balancer_sku': {'key': 'loadBalancerSku', 'type': 'str'},
        'load_balancer_profile': {'key': 'loadBalancerProfile', 'type': 'ManagedClusterLoadBalancerProfile'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ContainerServiceNetworkProfile, self).__init__(**kwargs)
        self.network_plugin = kwargs.get('network_plugin', "kubenet")
        self.network_policy = kwargs.get('network_policy', None)
        self.network_mode = kwargs.get('network_mode', None)
        self.pod_cidr = kwargs.get('pod_cidr', "10.244.0.0/16")
        self.service_cidr = kwargs.get('service_cidr', "10.0.0.0/16")
        self.dns_service_ip = kwargs.get('dns_service_ip', "10.0.0.10")
        self.docker_bridge_cidr = kwargs.get('docker_bridge_cidr', "172.17.0.1/16")
        self.outbound_type = kwargs.get('outbound_type', "loadBalancer")
        self.load_balancer_sku = kwargs.get('load_balancer_sku', None)
        self.load_balancer_profile = kwargs.get('load_balancer_profile', None)


class ContainerServiceSshConfiguration(msrest.serialization.Model):
    """SSH configuration for Linux-based VMs running on Azure.

    All required parameters must be populated in order to send to Azure.

    :param public_keys: Required. The list of SSH public keys used to authenticate with Linux-based
     VMs. Only expect one key specified.
    :type public_keys:
     list[~azure.mgmt.containerservice.v2021_05_01.models.ContainerServiceSshPublicKey]
    """

    _validation = {
        'public_keys': {'required': True},
    }

    _attribute_map = {
        'public_keys': {'key': 'publicKeys', 'type': '[ContainerServiceSshPublicKey]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ContainerServiceSshConfiguration, self).__init__(**kwargs)
        self.public_keys = kwargs['public_keys']


class ContainerServiceSshPublicKey(msrest.serialization.Model):
    """Contains information about SSH certificate public key data.

    All required parameters must be populated in order to send to Azure.

    :param key_data: Required. Certificate public key used to authenticate with VMs through SSH.
     The certificate must be in PEM format with or without headers.
    :type key_data: str
    """

    _validation = {
        'key_data': {'required': True},
    }

    _attribute_map = {
        'key_data': {'key': 'keyData', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ContainerServiceSshPublicKey, self).__init__(**kwargs)
        self.key_data = kwargs['key_data']


class ContainerServiceVMDiagnostics(msrest.serialization.Model):
    """Profile for diagnostics on the container service VMs.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param enabled: Required. Whether the VM diagnostic agent is provisioned on the VM.
    :type enabled: bool
    :ivar storage_uri: The URI of the storage account where diagnostics are stored.
    :vartype storage_uri: str
    """

    _validation = {
        'enabled': {'required': True},
        'storage_uri': {'readonly': True},
    }

    _attribute_map = {
        'enabled': {'key': 'enabled', 'type': 'bool'},
        'storage_uri': {'key': 'storageUri', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ContainerServiceVMDiagnostics, self).__init__(**kwargs)
        self.enabled = kwargs['enabled']
        self.storage_uri = None


class CredentialResult(msrest.serialization.Model):
    """The credential result response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of the credential.
    :vartype name: str
    :ivar value: Base64-encoded Kubernetes configuration file.
    :vartype value: bytearray
    """

    _validation = {
        'name': {'readonly': True},
        'value': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'value': {'key': 'value', 'type': 'bytearray'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CredentialResult, self).__init__(**kwargs)
        self.name = None
        self.value = None


class CredentialResults(msrest.serialization.Model):
    """The list of credential result response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar kubeconfigs: Base64-encoded Kubernetes configuration file.
    :vartype kubeconfigs: list[~azure.mgmt.containerservice.v2021_05_01.models.CredentialResult]
    """

    _validation = {
        'kubeconfigs': {'readonly': True},
    }

    _attribute_map = {
        'kubeconfigs': {'key': 'kubeconfigs', 'type': '[CredentialResult]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CredentialResults, self).__init__(**kwargs)
        self.kubeconfigs = None


class EndpointDependency(msrest.serialization.Model):
    """A domain name that AKS agent nodes are reaching at.

    :param domain_name: The domain name of the dependency.
    :type domain_name: str
    :param endpoint_details: The Ports and Protocols used when connecting to domainName.
    :type endpoint_details: list[~azure.mgmt.containerservice.v2021_05_01.models.EndpointDetail]
    """

    _attribute_map = {
        'domain_name': {'key': 'domainName', 'type': 'str'},
        'endpoint_details': {'key': 'endpointDetails', 'type': '[EndpointDetail]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(EndpointDependency, self).__init__(**kwargs)
        self.domain_name = kwargs.get('domain_name', None)
        self.endpoint_details = kwargs.get('endpoint_details', None)


class EndpointDetail(msrest.serialization.Model):
    """connect information from the AKS agent nodes to a single endpoint.

    :param ip_address: An IP Address that Domain Name currently resolves to.
    :type ip_address: str
    :param port: The port an endpoint is connected to.
    :type port: int
    :param protocol: The protocol used for connection.
    :type protocol: str
    :param description: Description of the detail.
    :type description: str
    """

    _attribute_map = {
        'ip_address': {'key': 'ipAddress', 'type': 'str'},
        'port': {'key': 'port', 'type': 'int'},
        'protocol': {'key': 'protocol', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(EndpointDetail, self).__init__(**kwargs)
        self.ip_address = kwargs.get('ip_address', None)
        self.port = kwargs.get('port', None)
        self.protocol = kwargs.get('protocol', None)
        self.description = kwargs.get('description', None)


class ExtendedLocation(msrest.serialization.Model):
    """The complex type of the extended location.

    :param name: The name of the extended location.
    :type name: str
    :param type: The type of the extended location. Possible values include: "EdgeZone".
    :type type: str or ~azure.mgmt.containerservice.v2021_05_01.models.ExtendedLocationTypes
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ExtendedLocation, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.type = kwargs.get('type', None)


class KubeletConfig(msrest.serialization.Model):
    """Kubelet configurations of agent nodes.

    :param cpu_manager_policy: CPU Manager policy to use.
    :type cpu_manager_policy: str
    :param cpu_cfs_quota: Enable CPU CFS quota enforcement for containers that specify CPU limits.
    :type cpu_cfs_quota: bool
    :param cpu_cfs_quota_period: Sets CPU CFS quota period value.
    :type cpu_cfs_quota_period: str
    :param image_gc_high_threshold: The percent of disk usage after which image garbage collection
     is always run.
    :type image_gc_high_threshold: int
    :param image_gc_low_threshold: The percent of disk usage before which image garbage collection
     is never run.
    :type image_gc_low_threshold: int
    :param topology_manager_policy: Topology Manager policy to use.
    :type topology_manager_policy: str
    :param allowed_unsafe_sysctls: Allowlist of unsafe sysctls or unsafe sysctl patterns (ending in
     ``*``\ ).
    :type allowed_unsafe_sysctls: list[str]
    :param fail_swap_on: If set to true it will make the Kubelet fail to start if swap is enabled
     on the node.
    :type fail_swap_on: bool
    :param container_log_max_size_mb: The maximum size (e.g. 10Mi) of container log file before it
     is rotated.
    :type container_log_max_size_mb: int
    :param container_log_max_files: The maximum number of container log files that can be present
     for a container. The number must be ≥ 2.
    :type container_log_max_files: int
    :param pod_max_pids: The maximum number of processes per pod.
    :type pod_max_pids: int
    """

    _validation = {
        'container_log_max_files': {'minimum': 2},
    }

    _attribute_map = {
        'cpu_manager_policy': {'key': 'cpuManagerPolicy', 'type': 'str'},
        'cpu_cfs_quota': {'key': 'cpuCfsQuota', 'type': 'bool'},
        'cpu_cfs_quota_period': {'key': 'cpuCfsQuotaPeriod', 'type': 'str'},
        'image_gc_high_threshold': {'key': 'imageGcHighThreshold', 'type': 'int'},
        'image_gc_low_threshold': {'key': 'imageGcLowThreshold', 'type': 'int'},
        'topology_manager_policy': {'key': 'topologyManagerPolicy', 'type': 'str'},
        'allowed_unsafe_sysctls': {'key': 'allowedUnsafeSysctls', 'type': '[str]'},
        'fail_swap_on': {'key': 'failSwapOn', 'type': 'bool'},
        'container_log_max_size_mb': {'key': 'containerLogMaxSizeMB', 'type': 'int'},
        'container_log_max_files': {'key': 'containerLogMaxFiles', 'type': 'int'},
        'pod_max_pids': {'key': 'podMaxPids', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(KubeletConfig, self).__init__(**kwargs)
        self.cpu_manager_policy = kwargs.get('cpu_manager_policy', None)
        self.cpu_cfs_quota = kwargs.get('cpu_cfs_quota', None)
        self.cpu_cfs_quota_period = kwargs.get('cpu_cfs_quota_period', None)
        self.image_gc_high_threshold = kwargs.get('image_gc_high_threshold', None)
        self.image_gc_low_threshold = kwargs.get('image_gc_low_threshold', None)
        self.topology_manager_policy = kwargs.get('topology_manager_policy', None)
        self.allowed_unsafe_sysctls = kwargs.get('allowed_unsafe_sysctls', None)
        self.fail_swap_on = kwargs.get('fail_swap_on', None)
        self.container_log_max_size_mb = kwargs.get('container_log_max_size_mb', None)
        self.container_log_max_files = kwargs.get('container_log_max_files', None)
        self.pod_max_pids = kwargs.get('pod_max_pids', None)


class LinuxOSConfig(msrest.serialization.Model):
    """OS configurations of Linux agent nodes.

    :param sysctls: Sysctl settings for Linux agent nodes.
    :type sysctls: ~azure.mgmt.containerservice.v2021_05_01.models.SysctlConfig
    :param transparent_huge_page_enabled: Transparent Huge Page enabled configuration.
    :type transparent_huge_page_enabled: str
    :param transparent_huge_page_defrag: Transparent Huge Page defrag configuration.
    :type transparent_huge_page_defrag: str
    :param swap_file_size_mb: SwapFileSizeMB specifies size in MB of a swap file will be created on
     each node.
    :type swap_file_size_mb: int
    """

    _attribute_map = {
        'sysctls': {'key': 'sysctls', 'type': 'SysctlConfig'},
        'transparent_huge_page_enabled': {'key': 'transparentHugePageEnabled', 'type': 'str'},
        'transparent_huge_page_defrag': {'key': 'transparentHugePageDefrag', 'type': 'str'},
        'swap_file_size_mb': {'key': 'swapFileSizeMB', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(LinuxOSConfig, self).__init__(**kwargs)
        self.sysctls = kwargs.get('sysctls', None)
        self.transparent_huge_page_enabled = kwargs.get('transparent_huge_page_enabled', None)
        self.transparent_huge_page_defrag = kwargs.get('transparent_huge_page_defrag', None)
        self.swap_file_size_mb = kwargs.get('swap_file_size_mb', None)


class MaintenanceConfiguration(SubResource):
    """maintenance configuration.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar system_data: The system meta data relating to this resource.
    :vartype system_data: ~azure.mgmt.containerservice.v2021_05_01.models.SystemData
    :param time_in_week: Weekday time slots allowed to upgrade.
    :type time_in_week: list[~azure.mgmt.containerservice.v2021_05_01.models.TimeInWeek]
    :param not_allowed_time: Time slots on which upgrade is not allowed.
    :type not_allowed_time: list[~azure.mgmt.containerservice.v2021_05_01.models.TimeSpan]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'time_in_week': {'key': 'properties.timeInWeek', 'type': '[TimeInWeek]'},
        'not_allowed_time': {'key': 'properties.notAllowedTime', 'type': '[TimeSpan]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MaintenanceConfiguration, self).__init__(**kwargs)
        self.system_data = None
        self.time_in_week = kwargs.get('time_in_week', None)
        self.not_allowed_time = kwargs.get('not_allowed_time', None)


class MaintenanceConfigurationListResult(msrest.serialization.Model):
    """The response from the List maintenance configurations operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value: The list of maintenance configurations.
    :type value: list[~azure.mgmt.containerservice.v2021_05_01.models.MaintenanceConfiguration]
    :ivar next_link: The URL to get the next set of maintenance configuration results.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[MaintenanceConfiguration]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MaintenanceConfigurationListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = None


class Resource(msrest.serialization.Model):
    """The Resource model definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Required. Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = kwargs['location']
        self.tags = kwargs.get('tags', None)


class ManagedCluster(Resource, Components1Q1Og48SchemasManagedclusterAllof1):
    """Managed cluster.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param identity: The identity of the managed cluster, if configured.
    :type identity: ~azure.mgmt.containerservice.v2021_05_01.models.ManagedClusterIdentity
    :ivar provisioning_state: The current deployment or provisioning state, which only appears in
     the response.
    :vartype provisioning_state: str
    :ivar power_state: Represents the Power State of the cluster.
    :vartype power_state: ~azure.mgmt.containerservice.v2021_05_01.models.PowerState
    :ivar max_agent_pools: The max number of agent pools for the managed cluster.
    :vartype max_agent_pools: int
    :param kubernetes_version: Version of Kubernetes specified when creating the managed cluster.
    :type kubernetes_version: str
    :param dns_prefix: DNS prefix specified when creating the managed cluster.
    :type dns_prefix: str
    :param fqdn_subdomain: FQDN subdomain specified when creating private cluster with custom
     private dns zone.
    :type fqdn_subdomain: str
    :ivar fqdn: FQDN for the master pool.
    :vartype fqdn: str
    :ivar private_fqdn: FQDN of private cluster.
    :vartype private_fqdn: str
    :ivar azure_portal_fqdn: FQDN for the master pool which used by proxy config.
    :vartype azure_portal_fqdn: str
    :param agent_pool_profiles: Properties of the agent pool.
    :type agent_pool_profiles:
     list[~azure.mgmt.containerservice.v2021_05_01.models.ManagedClusterAgentPoolProfile]
    :param linux_profile: Profile for Linux VMs in the container service cluster.
    :type linux_profile:
     ~azure.mgmt.containerservice.v2021_05_01.models.ContainerServiceLinuxProfile
    :param windows_profile: Profile for Windows VMs in the container service cluster.
    :type windows_profile:
     ~azure.mgmt.containerservice.v2021_05_01.models.ManagedClusterWindowsProfile
    :param service_principal_profile: Information about a service principal identity for the
     cluster to use for manipulating Azure APIs.
    :type service_principal_profile:
     ~azure.mgmt.containerservice.v2021_05_01.models.ManagedClusterServicePrincipalProfile
    :param addon_profiles: Profile of managed cluster add-on.
    :type addon_profiles: dict[str,
     ~azure.mgmt.containerservice.v2021_05_01.models.ManagedClusterAddonProfile]
    :param pod_identity_profile: Profile of managed cluster pod identity.
    :type pod_identity_profile:
     ~azure.mgmt.containerservice.v2021_05_01.models.ManagedClusterPodIdentityProfile
    :param node_resource_group: Name of the resource group containing agent pool nodes.
    :type node_resource_group: str
    :param enable_rbac: Whether to enable Kubernetes Role-Based Access Control.
    :type enable_rbac: bool
    :param enable_pod_security_policy: (DEPRECATING) Whether to enable Kubernetes pod security
     policy (preview). This feature is set for removal on October 15th, 2020. Learn more at
     aka.ms/aks/azpodpolicy.
    :type enable_pod_security_policy: bool
    :param network_profile: Profile of network configuration.
    :type network_profile:
     ~azure.mgmt.containerservice.v2021_05_01.models.ContainerServiceNetworkProfile
    :param aad_profile: Profile of Azure Active Directory configuration.
    :type aad_profile: ~azure.mgmt.containerservice.v2021_05_01.models.ManagedClusterAADProfile
    :param auto_upgrade_profile: Profile of auto upgrade configuration.
    :type auto_upgrade_profile:
     ~azure.mgmt.containerservice.v2021_05_01.models.ManagedClusterAutoUpgradeProfile
    :param auto_scaler_profile: Parameters to be applied to the cluster-autoscaler when enabled.
    :type auto_scaler_profile:
     ~azure.mgmt.containerservice.v2021_05_01.models.ManagedClusterPropertiesAutoScalerProfile
    :param api_server_access_profile: Access profile for managed cluster API server.
    :type api_server_access_profile:
     ~azure.mgmt.containerservice.v2021_05_01.models.ManagedClusterAPIServerAccessProfile
    :param disk_encryption_set_id: ResourceId of the disk encryption set to use for enabling
     encryption at rest.
    :type disk_encryption_set_id: str
    :param identity_profile: Identities associated with the cluster.
    :type identity_profile: dict[str,
     ~azure.mgmt.containerservice.v2021_05_01.models.ComponentsQit0EtSchemasManagedclusterpropertiesPropertiesIdentityprofileAdditionalproperties]
    :param private_link_resources: Private link resources associated with the cluster.
    :type private_link_resources:
     list[~azure.mgmt.containerservice.v2021_05_01.models.PrivateLinkResource]
    :param disable_local_accounts: If set to true, getting static credential will be disabled for
     this cluster. Expected to only be used for AAD clusters.
    :type disable_local_accounts: bool
    :param http_proxy_config: Configurations for provisioning the cluster with HTTP proxy servers.
    :type http_proxy_config:
     ~azure.mgmt.containerservice.v2021_05_01.models.ManagedClusterHTTPProxyConfig
    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Required. Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param sku: The managed cluster SKU.
    :type sku: ~azure.mgmt.containerservice.v2021_05_01.models.ManagedClusterSKU
    :param extended_location: The extended location of the Virtual Machine.
    :type extended_location: ~azure.mgmt.containerservice.v2021_05_01.models.ExtendedLocation
    """

    _validation = {
        'provisioning_state': {'readonly': True},
        'power_state': {'readonly': True},
        'max_agent_pools': {'readonly': True},
        'fqdn': {'readonly': True},
        'private_fqdn': {'readonly': True},
        'azure_portal_fqdn': {'readonly': True},
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'identity': {'key': 'identity', 'type': 'ManagedClusterIdentity'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'power_state': {'key': 'properties.powerState', 'type': 'PowerState'},
        'max_agent_pools': {'key': 'properties.maxAgentPools', 'type': 'int'},
        'kubernetes_version': {'key': 'properties.kubernetesVersion', 'type': 'str'},
        'dns_prefix': {'key': 'properties.dnsPrefix', 'type': 'str'},
        'fqdn_subdomain': {'key': 'properties.fqdnSubdomain', 'type': 'str'},
        'fqdn': {'key': 'properties.fqdn', 'type': 'str'},
        'private_fqdn': {'key': 'properties.privateFQDN', 'type': 'str'},
        'azure_portal_fqdn': {'key': 'properties.azurePortalFQDN', 'type': 'str'},
        'agent_pool_profiles': {'key': 'properties.agentPoolProfiles', 'type': '[ManagedClusterAgentPoolProfile]'},
        'linux_profile': {'key': 'properties.linuxProfile', 'type': 'ContainerServiceLinuxProfile'},
        'windows_profile': {'key': 'properties.windowsProfile', 'type': 'ManagedClusterWindowsProfile'},
        'service_principal_profile': {'key': 'properties.servicePrincipalProfile', 'type': 'ManagedClusterServicePrincipalProfile'},
        'addon_profiles': {'key': 'properties.addonProfiles', 'type': '{ManagedClusterAddonProfile}'},
        'pod_identity_profile': {'key': 'properties.podIdentityProfile', 'type': 'ManagedClusterPodIdentityProfile'},
        'node_resource_group': {'key': 'properties.nodeResourceGroup', 'type': 'str'},
        'enable_rbac': {'key': 'properties.enableRBAC', 'type': 'bool'},
        'enable_pod_security_policy': {'key': 'properties.enablePodSecurityPolicy', 'type': 'bool'},
        'network_profile': {'key': 'properties.networkProfile', 'type': 'ContainerServiceNetworkProfile'},
        'aad_profile': {'key': 'properties.aadProfile', 'type': 'ManagedClusterAADProfile'},
        'auto_upgrade_profile': {'key': 'properties.autoUpgradeProfile', 'type': 'ManagedClusterAutoUpgradeProfile'},
        'auto_scaler_profile': {'key': 'properties.autoScalerProfile', 'type': 'ManagedClusterPropertiesAutoScalerProfile'},
        'api_server_access_profile': {'key': 'properties.apiServerAccessProfile', 'type': 'ManagedClusterAPIServerAccessProfile'},
        'disk_encryption_set_id': {'key': 'properties.diskEncryptionSetID', 'type': 'str'},
        'identity_profile': {'key': 'properties.identityProfile', 'type': '{ComponentsQit0EtSchemasManagedclusterpropertiesPropertiesIdentityprofileAdditionalproperties}'},
        'private_link_resources': {'key': 'properties.privateLinkResources', 'type': '[PrivateLinkResource]'},
        'disable_local_accounts': {'key': 'properties.disableLocalAccounts', 'type': 'bool'},
        'http_proxy_config': {'key': 'properties.httpProxyConfig', 'type': 'ManagedClusterHTTPProxyConfig'},
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'sku': {'key': 'sku', 'type': 'ManagedClusterSKU'},
        'extended_location': {'key': 'extendedLocation', 'type': 'ExtendedLocation'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ManagedCluster, self).__init__(**kwargs)
        self.identity = kwargs.get('identity', None)
        self.provisioning_state = None
        self.power_state = None
        self.max_agent_pools = None
        self.kubernetes_version = kwargs.get('kubernetes_version', None)
        self.dns_prefix = kwargs.get('dns_prefix', None)
        self.fqdn_subdomain = kwargs.get('fqdn_subdomain', None)
        self.fqdn = None
        self.private_fqdn = None
        self.azure_portal_fqdn = None
        self.agent_pool_profiles = kwargs.get('agent_pool_profiles', None)
        self.linux_profile = kwargs.get('linux_profile', None)
        self.windows_profile = kwargs.get('windows_profile', None)
        self.service_principal_profile = kwargs.get('service_principal_profile', None)
        self.addon_profiles = kwargs.get('addon_profiles', None)
        self.pod_identity_profile = kwargs.get('pod_identity_profile', None)
        self.node_resource_group = kwargs.get('node_resource_group', None)
        self.enable_rbac = kwargs.get('enable_rbac', None)
        self.enable_pod_security_policy = kwargs.get('enable_pod_security_policy', None)
        self.network_profile = kwargs.get('network_profile', None)
        self.aad_profile = kwargs.get('aad_profile', None)
        self.auto_upgrade_profile = kwargs.get('auto_upgrade_profile', None)
        self.auto_scaler_profile = kwargs.get('auto_scaler_profile', None)
        self.api_server_access_profile = kwargs.get('api_server_access_profile', None)
        self.disk_encryption_set_id = kwargs.get('disk_encryption_set_id', None)
        self.identity_profile = kwargs.get('identity_profile', None)
        self.private_link_resources = kwargs.get('private_link_resources', None)
        self.disable_local_accounts = kwargs.get('disable_local_accounts', None)
        self.http_proxy_config = kwargs.get('http_proxy_config', None)
        self.sku = kwargs.get('sku', None)
        self.extended_location = kwargs.get('extended_location', None)
        self.id = None
        self.name = None
        self.type = None
        self.location = kwargs['location']
        self.tags = kwargs.get('tags', None)
        self.sku = kwargs.get('sku', None)
        self.extended_location = kwargs.get('extended_location', None)


class ManagedClusterAADProfile(msrest.serialization.Model):
    """AADProfile specifies attributes for Azure Active Directory integration.

    :param managed: Whether to enable managed AAD.
    :type managed: bool
    :param enable_azure_rbac: Whether to enable Azure RBAC for Kubernetes authorization.
    :type enable_azure_rbac: bool
    :param admin_group_object_i_ds: AAD group object IDs that will have admin role of the cluster.
    :type admin_group_object_i_ds: list[str]
    :param client_app_id: The client AAD application ID.
    :type client_app_id: str
    :param server_app_id: The server AAD application ID.
    :type server_app_id: str
    :param server_app_secret: The server AAD application secret.
    :type server_app_secret: str
    :param tenant_id: The AAD tenant ID to use for authentication. If not specified, will use the
     tenant of the deployment subscription.
    :type tenant_id: str
    """

    _attribute_map = {
        'managed': {'key': 'managed', 'type': 'bool'},
        'enable_azure_rbac': {'key': 'enableAzureRBAC', 'type': 'bool'},
        'admin_group_object_i_ds': {'key': 'adminGroupObjectIDs', 'type': '[str]'},
        'client_app_id': {'key': 'clientAppID', 'type': 'str'},
        'server_app_id': {'key': 'serverAppID', 'type': 'str'},
        'server_app_secret': {'key': 'serverAppSecret', 'type': 'str'},
        'tenant_id': {'key': 'tenantID', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ManagedClusterAADProfile, self).__init__(**kwargs)
        self.managed = kwargs.get('managed', None)
        self.enable_azure_rbac = kwargs.get('enable_azure_rbac', None)
        self.admin_group_object_i_ds = kwargs.get('admin_group_object_i_ds', None)
        self.client_app_id = kwargs.get('client_app_id', None)
        self.server_app_id = kwargs.get('server_app_id', None)
        self.server_app_secret = kwargs.get('server_app_secret', None)
        self.tenant_id = kwargs.get('tenant_id', None)


class ManagedClusterAccessProfile(Resource):
    """Managed cluster Access Profile.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Required. Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param kube_config: Base64-encoded Kubernetes configuration file.
    :type kube_config: bytearray
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'kube_config': {'key': 'properties.kubeConfig', 'type': 'bytearray'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ManagedClusterAccessProfile, self).__init__(**kwargs)
        self.kube_config = kwargs.get('kube_config', None)


class ManagedClusterAddonProfile(msrest.serialization.Model):
    """A Kubernetes add-on profile for a managed cluster.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param enabled: Required. Whether the add-on is enabled or not.
    :type enabled: bool
    :param config: Key-value pairs for configuring an add-on.
    :type config: dict[str, str]
    :ivar identity: Information of user assigned identity used by this add-on.
    :vartype identity:
     ~azure.mgmt.containerservice.v2021_05_01.models.ManagedClusterAddonProfileIdentity
    """

    _validation = {
        'enabled': {'required': True},
        'identity': {'readonly': True},
    }

    _attribute_map = {
        'enabled': {'key': 'enabled', 'type': 'bool'},
        'config': {'key': 'config', 'type': '{str}'},
        'identity': {'key': 'identity', 'type': 'ManagedClusterAddonProfileIdentity'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ManagedClusterAddonProfile, self).__init__(**kwargs)
        self.enabled = kwargs['enabled']
        self.config = kwargs.get('config', None)
        self.identity = None


class ManagedClusterAddonProfileIdentity(UserAssignedIdentity):
    """Information of user assigned identity used by this add-on.

    :param resource_id: The resource id of the user assigned identity.
    :type resource_id: str
    :param client_id: The client id of the user assigned identity.
    :type client_id: str
    :param object_id: The object id of the user assigned identity.
    :type object_id: str
    """

    _attribute_map = {
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'client_id': {'key': 'clientId', 'type': 'str'},
        'object_id': {'key': 'objectId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ManagedClusterAddonProfileIdentity, self).__init__(**kwargs)


class ManagedClusterAgentPoolProfileProperties(msrest.serialization.Model):
    """Properties for the container service agent pool profile.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param count: Number of agents (VMs) to host docker containers. Allowed values must be in the
     range of 0 to 1000 (inclusive) for user pools and in the range of 1 to 1000 (inclusive) for
     system pools. The default value is 1.
    :type count: int
    :param vm_size: Size of agent VMs.
    :type vm_size: str
    :param os_disk_size_gb: OS Disk Size in GB to be used to specify the disk size for every
     machine in this master/agent pool. If you specify 0, it will apply the default osDisk size
     according to the vmSize specified.
    :type os_disk_size_gb: int
    :param os_disk_type: OS disk type to be used for machines in a given agent pool. Allowed values
     are 'Ephemeral' and 'Managed'. If unspecified, defaults to 'Ephemeral' when the VM supports
     ephemeral OS and has a cache disk larger than the requested OSDiskSizeGB. Otherwise, defaults
     to 'Managed'. May not be changed after creation. Possible values include: "Managed",
     "Ephemeral".
    :type os_disk_type: str or ~azure.mgmt.containerservice.v2021_05_01.models.OSDiskType
    :param kubelet_disk_type: KubeletDiskType determines the placement of emptyDir volumes,
     container runtime data root, and Kubelet ephemeral storage. Currently allows one value, OS,
     resulting in Kubelet using the OS disk for data. Possible values include: "OS", "Temporary".
    :type kubelet_disk_type: str or ~azure.mgmt.containerservice.v2021_05_01.models.KubeletDiskType
    :param vnet_subnet_id: VNet SubnetID specifies the VNet's subnet identifier for nodes and maybe
     pods.
    :type vnet_subnet_id: str
    :param pod_subnet_id: Pod SubnetID specifies the VNet's subnet identifier for pods.
    :type pod_subnet_id: str
    :param max_pods: Maximum number of pods that can run on a node.
    :type max_pods: int
    :param os_type: OsType to be used to specify os type. Choose from Linux and Windows. Default to
     Linux. Possible values include: "Linux", "Windows". Default value: "Linux".
    :type os_type: str or ~azure.mgmt.containerservice.v2021_05_01.models.OSType
    :param os_sku: OsSKU to be used to specify os sku. Choose from Ubuntu(default) and CBLMariner
     for Linux OSType. Not applicable to Windows OSType. Possible values include: "Ubuntu",
     "CBLMariner".
    :type os_sku: str or ~azure.mgmt.containerservice.v2021_05_01.models.OSSKU
    :param max_count: Maximum number of nodes for auto-scaling.
    :type max_count: int
    :param min_count: Minimum number of nodes for auto-scaling.
    :type min_count: int
    :param enable_auto_scaling: Whether to enable auto-scaler.
    :type enable_auto_scaling: bool
    :param type: AgentPoolType represents types of an agent pool. Possible values include:
     "VirtualMachineScaleSets", "AvailabilitySet".
    :type type: str or ~azure.mgmt.containerservice.v2021_05_01.models.AgentPoolType
    :param mode: AgentPoolMode represents mode of an agent pool. Possible values include: "System",
     "User".
    :type mode: str or ~azure.mgmt.containerservice.v2021_05_01.models.AgentPoolMode
    :param orchestrator_version: Version of orchestrator specified when creating the managed
     cluster.
    :type orchestrator_version: str
    :ivar node_image_version: Version of node image.
    :vartype node_image_version: str
    :param upgrade_settings: Settings for upgrading the agentpool.
    :type upgrade_settings:
     ~azure.mgmt.containerservice.v2021_05_01.models.AgentPoolUpgradeSettings
    :ivar provisioning_state: The current deployment or provisioning state, which only appears in
     the response.
    :vartype provisioning_state: str
    :ivar power_state: Describes whether the Agent Pool is Running or Stopped.
    :vartype power_state: ~azure.mgmt.containerservice.v2021_05_01.models.PowerState
    :param availability_zones: Availability zones for nodes. Must use VirtualMachineScaleSets
     AgentPoolType.
    :type availability_zones: list[str]
    :param enable_node_public_ip: Enable public IP for nodes.
    :type enable_node_public_ip: bool
    :param node_public_ip_prefix_id: Public IP Prefix ID. VM nodes use IPs assigned from this
     Public IP Prefix.
    :type node_public_ip_prefix_id: str
    :param scale_set_priority: ScaleSetPriority to be used to specify virtual machine scale set
     priority. Default to regular. Possible values include: "Spot", "Regular". Default value:
     "Regular".
    :type scale_set_priority: str or
     ~azure.mgmt.containerservice.v2021_05_01.models.ScaleSetPriority
    :param scale_set_eviction_policy: ScaleSetEvictionPolicy to be used to specify eviction policy
     for Spot virtual machine scale set. Default to Delete. Possible values include: "Delete",
     "Deallocate". Default value: "Delete".
    :type scale_set_eviction_policy: str or
     ~azure.mgmt.containerservice.v2021_05_01.models.ScaleSetEvictionPolicy
    :param spot_max_price: SpotMaxPrice to be used to specify the maximum price you are willing to
     pay in US Dollars. Possible values are any decimal value greater than zero or -1 which
     indicates default price to be up-to on-demand.
    :type spot_max_price: float
    :param tags: A set of tags. Agent pool tags to be persisted on the agent pool virtual machine
     scale set.
    :type tags: dict[str, str]
    :param node_labels: Agent pool node labels to be persisted across all nodes in agent pool.
    :type node_labels: dict[str, str]
    :param node_taints: Taints added to new nodes during node pool create and scale. For example,
     key=value:NoSchedule.
    :type node_taints: list[str]
    :param proximity_placement_group_id: The ID for Proximity Placement Group.
    :type proximity_placement_group_id: str
    :param kubelet_config: KubeletConfig specifies the configuration of kubelet on agent nodes.
    :type kubelet_config: ~azure.mgmt.containerservice.v2021_05_01.models.KubeletConfig
    :param linux_os_config: LinuxOSConfig specifies the OS configuration of linux agent nodes.
    :type linux_os_config: ~azure.mgmt.containerservice.v2021_05_01.models.LinuxOSConfig
    :param enable_encryption_at_host: Whether to enable EncryptionAtHost.
    :type enable_encryption_at_host: bool
    :param enable_ultra_ssd: Whether to enable UltraSSD.
    :type enable_ultra_ssd: bool
    :param enable_fips: Whether to use FIPS enabled OS.
    :type enable_fips: bool
    :param gpu_instance_profile: GPUInstanceProfile to be used to specify GPU MIG instance profile
     for supported GPU VM SKU. Supported values are MIG1g, MIG2g, MIG3g, MIG4g and MIG7g. Possible
     values include: "MIG1g", "MIG2g", "MIG3g", "MIG4g", "MIG7g".
    :type gpu_instance_profile: str or
     ~azure.mgmt.containerservice.v2021_05_01.models.GPUInstanceProfile
    """

    _validation = {
        'os_disk_size_gb': {'maximum': 2048, 'minimum': 0},
        'node_image_version': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'power_state': {'readonly': True},
    }

    _attribute_map = {
        'count': {'key': 'count', 'type': 'int'},
        'vm_size': {'key': 'vmSize', 'type': 'str'},
        'os_disk_size_gb': {'key': 'osDiskSizeGB', 'type': 'int'},
        'os_disk_type': {'key': 'osDiskType', 'type': 'str'},
        'kubelet_disk_type': {'key': 'kubeletDiskType', 'type': 'str'},
        'vnet_subnet_id': {'key': 'vnetSubnetID', 'type': 'str'},
        'pod_subnet_id': {'key': 'podSubnetID', 'type': 'str'},
        'max_pods': {'key': 'maxPods', 'type': 'int'},
        'os_type': {'key': 'osType', 'type': 'str'},
        'os_sku': {'key': 'osSKU', 'type': 'str'},
        'max_count': {'key': 'maxCount', 'type': 'int'},
        'min_count': {'key': 'minCount', 'type': 'int'},
        'enable_auto_scaling': {'key': 'enableAutoScaling', 'type': 'bool'},
        'type': {'key': 'type', 'type': 'str'},
        'mode': {'key': 'mode', 'type': 'str'},
        'orchestrator_version': {'key': 'orchestratorVersion', 'type': 'str'},
        'node_image_version': {'key': 'nodeImageVersion', 'type': 'str'},
        'upgrade_settings': {'key': 'upgradeSettings', 'type': 'AgentPoolUpgradeSettings'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'power_state': {'key': 'powerState', 'type': 'PowerState'},
        'availability_zones': {'key': 'availabilityZones', 'type': '[str]'},
        'enable_node_public_ip': {'key': 'enableNodePublicIP', 'type': 'bool'},
        'node_public_ip_prefix_id': {'key': 'nodePublicIPPrefixID', 'type': 'str'},
        'scale_set_priority': {'key': 'scaleSetPriority', 'type': 'str'},
        'scale_set_eviction_policy': {'key': 'scaleSetEvictionPolicy', 'type': 'str'},
        'spot_max_price': {'key': 'spotMaxPrice', 'type': 'float'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'node_labels': {'key': 'nodeLabels', 'type': '{str}'},
        'node_taints': {'key': 'nodeTaints', 'type': '[str]'},
        'proximity_placement_group_id': {'key': 'proximityPlacementGroupID', 'type': 'str'},
        'kubelet_config': {'key': 'kubeletConfig', 'type': 'KubeletConfig'},
        'linux_os_config': {'key': 'linuxOSConfig', 'type': 'LinuxOSConfig'},
        'enable_encryption_at_host': {'key': 'enableEncryptionAtHost', 'type': 'bool'},
        'enable_ultra_ssd': {'key': 'enableUltraSSD', 'type': 'bool'},
        'enable_fips': {'key': 'enableFIPS', 'type': 'bool'},
        'gpu_instance_profile': {'key': 'gpuInstanceProfile', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ManagedClusterAgentPoolProfileProperties, self).__init__(**kwargs)
        self.count = kwargs.get('count', None)
        self.vm_size = kwargs.get('vm_size', None)
        self.os_disk_size_gb = kwargs.get('os_disk_size_gb', None)
        self.os_disk_type = kwargs.get('os_disk_type', None)
        self.kubelet_disk_type = kwargs.get('kubelet_disk_type', None)
        self.vnet_subnet_id = kwargs.get('vnet_subnet_id', None)
        self.pod_subnet_id = kwargs.get('pod_subnet_id', None)
        self.max_pods = kwargs.get('max_pods', None)
        self.os_type = kwargs.get('os_type', "Linux")
        self.os_sku = kwargs.get('os_sku', None)
        self.max_count = kwargs.get('max_count', None)
        self.min_count = kwargs.get('min_count', None)
        self.enable_auto_scaling = kwargs.get('enable_auto_scaling', None)
        self.type = kwargs.get('type', None)
        self.mode = kwargs.get('mode', None)
        self.orchestrator_version = kwargs.get('orchestrator_version', None)
        self.node_image_version = None
        self.upgrade_settings = kwargs.get('upgrade_settings', None)
        self.provisioning_state = None
        self.power_state = None
        self.availability_zones = kwargs.get('availability_zones', None)
        self.enable_node_public_ip = kwargs.get('enable_node_public_ip', None)
        self.node_public_ip_prefix_id = kwargs.get('node_public_ip_prefix_id', None)
        self.scale_set_priority = kwargs.get('scale_set_priority', "Regular")
        self.scale_set_eviction_policy = kwargs.get('scale_set_eviction_policy', "Delete")
        self.spot_max_price = kwargs.get('spot_max_price', -1)
        self.tags = kwargs.get('tags', None)
        self.node_labels = kwargs.get('node_labels', None)
        self.node_taints = kwargs.get('node_taints', None)
        self.proximity_placement_group_id = kwargs.get('proximity_placement_group_id', None)
        self.kubelet_config = kwargs.get('kubelet_config', None)
        self.linux_os_config = kwargs.get('linux_os_config', None)
        self.enable_encryption_at_host = kwargs.get('enable_encryption_at_host', None)
        self.enable_ultra_ssd = kwargs.get('enable_ultra_ssd', None)
        self.enable_fips = kwargs.get('enable_fips', None)
        self.gpu_instance_profile = kwargs.get('gpu_instance_profile', None)


class ManagedClusterAgentPoolProfile(ManagedClusterAgentPoolProfileProperties):
    """Profile for the container service agent pool.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param count: Number of agents (VMs) to host docker containers. Allowed values must be in the
     range of 0 to 1000 (inclusive) for user pools and in the range of 1 to 1000 (inclusive) for
     system pools. The default value is 1.
    :type count: int
    :param vm_size: Size of agent VMs.
    :type vm_size: str
    :param os_disk_size_gb: OS Disk Size in GB to be used to specify the disk size for every
     machine in this master/agent pool. If you specify 0, it will apply the default osDisk size
     according to the vmSize specified.
    :type os_disk_size_gb: int
    :param os_disk_type: OS disk type to be used for machines in a given agent pool. Allowed values
     are 'Ephemeral' and 'Managed'. If unspecified, defaults to 'Ephemeral' when the VM supports
     ephemeral OS and has a cache disk larger than the requested OSDiskSizeGB. Otherwise, defaults
     to 'Managed'. May not be changed after creation. Possible values include: "Managed",
     "Ephemeral".
    :type os_disk_type: str or ~azure.mgmt.containerservice.v2021_05_01.models.OSDiskType
    :param kubelet_disk_type: KubeletDiskType determines the placement of emptyDir volumes,
     container runtime data root, and Kubelet ephemeral storage. Currently allows one value, OS,
     resulting in Kubelet using the OS disk for data. Possible values include: "OS", "Temporary".
    :type kubelet_disk_type: str or ~azure.mgmt.containerservice.v2021_05_01.models.KubeletDiskType
    :param vnet_subnet_id: VNet SubnetID specifies the VNet's subnet identifier for nodes and maybe
     pods.
    :type vnet_subnet_id: str
    :param pod_subnet_id: Pod SubnetID specifies the VNet's subnet identifier for pods.
    :type pod_subnet_id: str
    :param max_pods: Maximum number of pods that can run on a node.
    :type max_pods: int
    :param os_type: OsType to be used to specify os type. Choose from Linux and Windows. Default to
     Linux. Possible values include: "Linux", "Windows". Default value: "Linux".
    :type os_type: str or ~azure.mgmt.containerservice.v2021_05_01.models.OSType
    :param os_sku: OsSKU to be used to specify os sku. Choose from Ubuntu(default) and CBLMariner
     for Linux OSType. Not applicable to Windows OSType. Possible values include: "Ubuntu",
     "CBLMariner".
    :type os_sku: str or ~azure.mgmt.containerservice.v2021_05_01.models.OSSKU
    :param max_count: Maximum number of nodes for auto-scaling.
    :type max_count: int
    :param min_count: Minimum number of nodes for auto-scaling.
    :type min_count: int
    :param enable_auto_scaling: Whether to enable auto-scaler.
    :type enable_auto_scaling: bool
    :param type: AgentPoolType represents types of an agent pool. Possible values include:
     "VirtualMachineScaleSets", "AvailabilitySet".
    :type type: str or ~azure.mgmt.containerservice.v2021_05_01.models.AgentPoolType
    :param mode: AgentPoolMode represents mode of an agent pool. Possible values include: "System",
     "User".
    :type mode: str or ~azure.mgmt.containerservice.v2021_05_01.models.AgentPoolMode
    :param orchestrator_version: Version of orchestrator specified when creating the managed
     cluster.
    :type orchestrator_version: str
    :ivar node_image_version: Version of node image.
    :vartype node_image_version: str
    :param upgrade_settings: Settings for upgrading the agentpool.
    :type upgrade_settings:
     ~azure.mgmt.containerservice.v2021_05_01.models.AgentPoolUpgradeSettings
    :ivar provisioning_state: The current deployment or provisioning state, which only appears in
     the response.
    :vartype provisioning_state: str
    :ivar power_state: Describes whether the Agent Pool is Running or Stopped.
    :vartype power_state: ~azure.mgmt.containerservice.v2021_05_01.models.PowerState
    :param availability_zones: Availability zones for nodes. Must use VirtualMachineScaleSets
     AgentPoolType.
    :type availability_zones: list[str]
    :param enable_node_public_ip: Enable public IP for nodes.
    :type enable_node_public_ip: bool
    :param node_public_ip_prefix_id: Public IP Prefix ID. VM nodes use IPs assigned from this
     Public IP Prefix.
    :type node_public_ip_prefix_id: str
    :param scale_set_priority: ScaleSetPriority to be used to specify virtual machine scale set
     priority. Default to regular. Possible values include: "Spot", "Regular". Default value:
     "Regular".
    :type scale_set_priority: str or
     ~azure.mgmt.containerservice.v2021_05_01.models.ScaleSetPriority
    :param scale_set_eviction_policy: ScaleSetEvictionPolicy to be used to specify eviction policy
     for Spot virtual machine scale set. Default to Delete. Possible values include: "Delete",
     "Deallocate". Default value: "Delete".
    :type scale_set_eviction_policy: str or
     ~azure.mgmt.containerservice.v2021_05_01.models.ScaleSetEvictionPolicy
    :param spot_max_price: SpotMaxPrice to be used to specify the maximum price you are willing to
     pay in US Dollars. Possible values are any decimal value greater than zero or -1 which
     indicates default price to be up-to on-demand.
    :type spot_max_price: float
    :param tags: A set of tags. Agent pool tags to be persisted on the agent pool virtual machine
     scale set.
    :type tags: dict[str, str]
    :param node_labels: Agent pool node labels to be persisted across all nodes in agent pool.
    :type node_labels: dict[str, str]
    :param node_taints: Taints added to new nodes during node pool create and scale. For example,
     key=value:NoSchedule.
    :type node_taints: list[str]
    :param proximity_placement_group_id: The ID for Proximity Placement Group.
    :type proximity_placement_group_id: str
    :param kubelet_config: KubeletConfig specifies the configuration of kubelet on agent nodes.
    :type kubelet_config: ~azure.mgmt.containerservice.v2021_05_01.models.KubeletConfig
    :param linux_os_config: LinuxOSConfig specifies the OS configuration of linux agent nodes.
    :type linux_os_config: ~azure.mgmt.containerservice.v2021_05_01.models.LinuxOSConfig
    :param enable_encryption_at_host: Whether to enable EncryptionAtHost.
    :type enable_encryption_at_host: bool
    :param enable_ultra_ssd: Whether to enable UltraSSD.
    :type enable_ultra_ssd: bool
    :param enable_fips: Whether to use FIPS enabled OS.
    :type enable_fips: bool
    :param gpu_instance_profile: GPUInstanceProfile to be used to specify GPU MIG instance profile
     for supported GPU VM SKU. Supported values are MIG1g, MIG2g, MIG3g, MIG4g and MIG7g. Possible
     values include: "MIG1g", "MIG2g", "MIG3g", "MIG4g", "MIG7g".
    :type gpu_instance_profile: str or
     ~azure.mgmt.containerservice.v2021_05_01.models.GPUInstanceProfile
    :param name: Required. Unique name of the agent pool profile in the context of the subscription
     and resource group.
    :type name: str
    """

    _validation = {
        'os_disk_size_gb': {'maximum': 2048, 'minimum': 0},
        'node_image_version': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'power_state': {'readonly': True},
        'name': {'required': True, 'pattern': r'^[a-z][a-z0-9]{0,11}$'},
    }

    _attribute_map = {
        'count': {'key': 'count', 'type': 'int'},
        'vm_size': {'key': 'vmSize', 'type': 'str'},
        'os_disk_size_gb': {'key': 'osDiskSizeGB', 'type': 'int'},
        'os_disk_type': {'key': 'osDiskType', 'type': 'str'},
        'kubelet_disk_type': {'key': 'kubeletDiskType', 'type': 'str'},
        'vnet_subnet_id': {'key': 'vnetSubnetID', 'type': 'str'},
        'pod_subnet_id': {'key': 'podSubnetID', 'type': 'str'},
        'max_pods': {'key': 'maxPods', 'type': 'int'},
        'os_type': {'key': 'osType', 'type': 'str'},
        'os_sku': {'key': 'osSKU', 'type': 'str'},
        'max_count': {'key': 'maxCount', 'type': 'int'},
        'min_count': {'key': 'minCount', 'type': 'int'},
        'enable_auto_scaling': {'key': 'enableAutoScaling', 'type': 'bool'},
        'type': {'key': 'type', 'type': 'str'},
        'mode': {'key': 'mode', 'type': 'str'},
        'orchestrator_version': {'key': 'orchestratorVersion', 'type': 'str'},
        'node_image_version': {'key': 'nodeImageVersion', 'type': 'str'},
        'upgrade_settings': {'key': 'upgradeSettings', 'type': 'AgentPoolUpgradeSettings'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'power_state': {'key': 'powerState', 'type': 'PowerState'},
        'availability_zones': {'key': 'availabilityZones', 'type': '[str]'},
        'enable_node_public_ip': {'key': 'enableNodePublicIP', 'type': 'bool'},
        'node_public_ip_prefix_id': {'key': 'nodePublicIPPrefixID', 'type': 'str'},
        'scale_set_priority': {'key': 'scaleSetPriority', 'type': 'str'},
        'scale_set_eviction_policy': {'key': 'scaleSetEvictionPolicy', 'type': 'str'},
        'spot_max_price': {'key': 'spotMaxPrice', 'type': 'float'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'node_labels': {'key': 'nodeLabels', 'type': '{str}'},
        'node_taints': {'key': 'nodeTaints', 'type': '[str]'},
        'proximity_placement_group_id': {'key': 'proximityPlacementGroupID', 'type': 'str'},
        'kubelet_config': {'key': 'kubeletConfig', 'type': 'KubeletConfig'},
        'linux_os_config': {'key': 'linuxOSConfig', 'type': 'LinuxOSConfig'},
        'enable_encryption_at_host': {'key': 'enableEncryptionAtHost', 'type': 'bool'},
        'enable_ultra_ssd': {'key': 'enableUltraSSD', 'type': 'bool'},
        'enable_fips': {'key': 'enableFIPS', 'type': 'bool'},
        'gpu_instance_profile': {'key': 'gpuInstanceProfile', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ManagedClusterAgentPoolProfile, self).__init__(**kwargs)
        self.name = kwargs['name']


class ManagedClusterAPIServerAccessProfile(msrest.serialization.Model):
    """Access profile for managed cluster API server.

    :param authorized_ip_ranges: Authorized IP Ranges to kubernetes API server.
    :type authorized_ip_ranges: list[str]
    :param enable_private_cluster: Whether to create the cluster as a private cluster or not.
    :type enable_private_cluster: bool
    :param private_dns_zone: Private dns zone mode for private cluster.
    :type private_dns_zone: str
    :param enable_private_cluster_public_fqdn: Whether to create additional public FQDN for private
     cluster or not.
    :type enable_private_cluster_public_fqdn: bool
    """

    _attribute_map = {
        'authorized_ip_ranges': {'key': 'authorizedIPRanges', 'type': '[str]'},
        'enable_private_cluster': {'key': 'enablePrivateCluster', 'type': 'bool'},
        'private_dns_zone': {'key': 'privateDNSZone', 'type': 'str'},
        'enable_private_cluster_public_fqdn': {'key': 'enablePrivateClusterPublicFQDN', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ManagedClusterAPIServerAccessProfile, self).__init__(**kwargs)
        self.authorized_ip_ranges = kwargs.get('authorized_ip_ranges', None)
        self.enable_private_cluster = kwargs.get('enable_private_cluster', None)
        self.private_dns_zone = kwargs.get('private_dns_zone', None)
        self.enable_private_cluster_public_fqdn = kwargs.get('enable_private_cluster_public_fqdn', None)


class ManagedClusterAutoUpgradeProfile(msrest.serialization.Model):
    """Auto upgrade profile for a managed cluster.

    :param upgrade_channel: upgrade channel for auto upgrade. Possible values include: "rapid",
     "stable", "patch", "node-image", "none".
    :type upgrade_channel: str or ~azure.mgmt.containerservice.v2021_05_01.models.UpgradeChannel
    """

    _attribute_map = {
        'upgrade_channel': {'key': 'upgradeChannel', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ManagedClusterAutoUpgradeProfile, self).__init__(**kwargs)
        self.upgrade_channel = kwargs.get('upgrade_channel', None)


class ManagedClusterHTTPProxyConfig(msrest.serialization.Model):
    """Configurations for provisioning the cluster with HTTP proxy servers.

    :param http_proxy: HTTP proxy server endpoint to use.
    :type http_proxy: str
    :param https_proxy: HTTPS proxy server endpoint to use.
    :type https_proxy: str
    :param no_proxy: Endpoints that should not go through proxy.
    :type no_proxy: list[str]
    :param trusted_ca: Alternative CA cert to use for connecting to proxy servers.
    :type trusted_ca: str
    """

    _attribute_map = {
        'http_proxy': {'key': 'httpProxy', 'type': 'str'},
        'https_proxy': {'key': 'httpsProxy', 'type': 'str'},
        'no_proxy': {'key': 'noProxy', 'type': '[str]'},
        'trusted_ca': {'key': 'trustedCa', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ManagedClusterHTTPProxyConfig, self).__init__(**kwargs)
        self.http_proxy = kwargs.get('http_proxy', None)
        self.https_proxy = kwargs.get('https_proxy', None)
        self.no_proxy = kwargs.get('no_proxy', None)
        self.trusted_ca = kwargs.get('trusted_ca', None)


class ManagedClusterIdentity(msrest.serialization.Model):
    """Identity for the managed cluster.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The principal id of the system assigned identity which is used by master
     components.
    :vartype principal_id: str
    :ivar tenant_id: The tenant id of the system assigned identity which is used by master
     components.
    :vartype tenant_id: str
    :param type: The type of identity used for the managed cluster. Type 'SystemAssigned' will use
     an implicitly created identity in master components and an auto-created user assigned identity
     in MC_ resource group in agent nodes. Type 'None' will not use MSI for the managed cluster,
     service principal will be used instead. Possible values include: "SystemAssigned",
     "UserAssigned", "None".
    :type type: str or ~azure.mgmt.containerservice.v2021_05_01.models.ResourceIdentityType
    :param user_assigned_identities: The user identity associated with the managed cluster. This
     identity will be used in control plane and only one user assigned identity is allowed. The user
     identity dictionary key references will be ARM resource ids in the form:
     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
    :type user_assigned_identities: dict[str,
     ~azure.mgmt.containerservice.v2021_05_01.models.Components1Umhcm8SchemasManagedclusteridentityPropertiesUserassignedidentitiesAdditionalproperties]
    """

    _validation = {
        'principal_id': {'readonly': True},
        'tenant_id': {'readonly': True},
    }

    _attribute_map = {
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'user_assigned_identities': {'key': 'userAssignedIdentities', 'type': '{Components1Umhcm8SchemasManagedclusteridentityPropertiesUserassignedidentitiesAdditionalproperties}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ManagedClusterIdentity, self).__init__(**kwargs)
        self.principal_id = None
        self.tenant_id = None
        self.type = kwargs.get('type', None)
        self.user_assigned_identities = kwargs.get('user_assigned_identities', None)


class ManagedClusterListResult(msrest.serialization.Model):
    """The response from the List Managed Clusters operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value: The list of managed clusters.
    :type value: list[~azure.mgmt.containerservice.v2021_05_01.models.ManagedCluster]
    :ivar next_link: The URL to get the next set of managed cluster results.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ManagedCluster]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ManagedClusterListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = None


class ManagedClusterLoadBalancerProfile(msrest.serialization.Model):
    """Profile of the managed cluster load balancer.

    :param managed_outbound_i_ps: Desired managed outbound IPs for the cluster load balancer.
    :type managed_outbound_i_ps:
     ~azure.mgmt.containerservice.v2021_05_01.models.ManagedClusterLoadBalancerProfileManagedOutboundIPs
    :param outbound_ip_prefixes: Desired outbound IP Prefix resources for the cluster load
     balancer.
    :type outbound_ip_prefixes:
     ~azure.mgmt.containerservice.v2021_05_01.models.ManagedClusterLoadBalancerProfileOutboundIPPrefixes
    :param outbound_i_ps: Desired outbound IP resources for the cluster load balancer.
    :type outbound_i_ps:
     ~azure.mgmt.containerservice.v2021_05_01.models.ManagedClusterLoadBalancerProfileOutboundIPs
    :param effective_outbound_i_ps: The effective outbound IP resources of the cluster load
     balancer.
    :type effective_outbound_i_ps:
     list[~azure.mgmt.containerservice.v2021_05_01.models.ResourceReference]
    :param allocated_outbound_ports: Desired number of allocated SNAT ports per VM. Allowed values
     must be in the range of 0 to 64000 (inclusive). The default value is 0 which results in Azure
     dynamically allocating ports.
    :type allocated_outbound_ports: int
    :param idle_timeout_in_minutes: Desired outbound flow idle timeout in minutes. Allowed values
     must be in the range of 4 to 120 (inclusive). The default value is 30 minutes.
    :type idle_timeout_in_minutes: int
    """

    _validation = {
        'allocated_outbound_ports': {'maximum': 64000, 'minimum': 0},
        'idle_timeout_in_minutes': {'maximum': 120, 'minimum': 4},
    }

    _attribute_map = {
        'managed_outbound_i_ps': {'key': 'managedOutboundIPs', 'type': 'ManagedClusterLoadBalancerProfileManagedOutboundIPs'},
        'outbound_ip_prefixes': {'key': 'outboundIPPrefixes', 'type': 'ManagedClusterLoadBalancerProfileOutboundIPPrefixes'},
        'outbound_i_ps': {'key': 'outboundIPs', 'type': 'ManagedClusterLoadBalancerProfileOutboundIPs'},
        'effective_outbound_i_ps': {'key': 'effectiveOutboundIPs', 'type': '[ResourceReference]'},
        'allocated_outbound_ports': {'key': 'allocatedOutboundPorts', 'type': 'int'},
        'idle_timeout_in_minutes': {'key': 'idleTimeoutInMinutes', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ManagedClusterLoadBalancerProfile, self).__init__(**kwargs)
        self.managed_outbound_i_ps = kwargs.get('managed_outbound_i_ps', None)
        self.outbound_ip_prefixes = kwargs.get('outbound_ip_prefixes', None)
        self.outbound_i_ps = kwargs.get('outbound_i_ps', None)
        self.effective_outbound_i_ps = kwargs.get('effective_outbound_i_ps', None)
        self.allocated_outbound_ports = kwargs.get('allocated_outbound_ports', 0)
        self.idle_timeout_in_minutes = kwargs.get('idle_timeout_in_minutes', 30)


class ManagedClusterLoadBalancerProfileManagedOutboundIPs(msrest.serialization.Model):
    """Desired managed outbound IPs for the cluster load balancer.

    :param count: Desired number of outbound IP created/managed by Azure for the cluster load
     balancer. Allowed values must be in the range of 1 to 100 (inclusive). The default value is 1.
    :type count: int
    """

    _validation = {
        'count': {'maximum': 100, 'minimum': 1},
    }

    _attribute_map = {
        'count': {'key': 'count', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ManagedClusterLoadBalancerProfileManagedOutboundIPs, self).__init__(**kwargs)
        self.count = kwargs.get('count', 1)


class ManagedClusterLoadBalancerProfileOutboundIPPrefixes(msrest.serialization.Model):
    """Desired outbound IP Prefix resources for the cluster load balancer.

    :param public_ip_prefixes: A list of public IP prefix resources.
    :type public_ip_prefixes:
     list[~azure.mgmt.containerservice.v2021_05_01.models.ResourceReference]
    """

    _attribute_map = {
        'public_ip_prefixes': {'key': 'publicIPPrefixes', 'type': '[ResourceReference]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ManagedClusterLoadBalancerProfileOutboundIPPrefixes, self).__init__(**kwargs)
        self.public_ip_prefixes = kwargs.get('public_ip_prefixes', None)


class ManagedClusterLoadBalancerProfileOutboundIPs(msrest.serialization.Model):
    """Desired outbound IP resources for the cluster load balancer.

    :param public_i_ps: A list of public IP resources.
    :type public_i_ps: list[~azure.mgmt.containerservice.v2021_05_01.models.ResourceReference]
    """

    _attribute_map = {
        'public_i_ps': {'key': 'publicIPs', 'type': '[ResourceReference]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ManagedClusterLoadBalancerProfileOutboundIPs, self).__init__(**kwargs)
        self.public_i_ps = kwargs.get('public_i_ps', None)


class ManagedClusterPodIdentity(msrest.serialization.Model):
    """ManagedClusterPodIdentity.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. Name of the pod identity.
    :type name: str
    :param namespace: Required. Namespace of the pod identity.
    :type namespace: str
    :param binding_selector: Binding selector to use for the AzureIdentityBinding resource.
    :type binding_selector: str
    :param identity: Required. Information of the user assigned identity.
    :type identity: ~azure.mgmt.containerservice.v2021_05_01.models.UserAssignedIdentity
    :ivar provisioning_state: The current provisioning state of the pod identity. Possible values
     include: "Assigned", "Updating", "Deleting", "Failed".
    :vartype provisioning_state: str or
     ~azure.mgmt.containerservice.v2021_05_01.models.ManagedClusterPodIdentityProvisioningState
    :ivar provisioning_info:
    :vartype provisioning_info:
     ~azure.mgmt.containerservice.v2021_05_01.models.ManagedClusterPodIdentityProvisioningInfo
    """

    _validation = {
        'name': {'required': True},
        'namespace': {'required': True},
        'identity': {'required': True},
        'provisioning_state': {'readonly': True},
        'provisioning_info': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'namespace': {'key': 'namespace', 'type': 'str'},
        'binding_selector': {'key': 'bindingSelector', 'type': 'str'},
        'identity': {'key': 'identity', 'type': 'UserAssignedIdentity'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'provisioning_info': {'key': 'provisioningInfo', 'type': 'ManagedClusterPodIdentityProvisioningInfo'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ManagedClusterPodIdentity, self).__init__(**kwargs)
        self.name = kwargs['name']
        self.namespace = kwargs['namespace']
        self.binding_selector = kwargs.get('binding_selector', None)
        self.identity = kwargs['identity']
        self.provisioning_state = None
        self.provisioning_info = None


class ManagedClusterPodIdentityException(msrest.serialization.Model):
    """ManagedClusterPodIdentityException.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. Name of the pod identity exception.
    :type name: str
    :param namespace: Required. Namespace of the pod identity exception.
    :type namespace: str
    :param pod_labels: Required. Pod labels to match.
    :type pod_labels: dict[str, str]
    """

    _validation = {
        'name': {'required': True},
        'namespace': {'required': True},
        'pod_labels': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'namespace': {'key': 'namespace', 'type': 'str'},
        'pod_labels': {'key': 'podLabels', 'type': '{str}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ManagedClusterPodIdentityException, self).__init__(**kwargs)
        self.name = kwargs['name']
        self.namespace = kwargs['namespace']
        self.pod_labels = kwargs['pod_labels']


class ManagedClusterPodIdentityProfile(msrest.serialization.Model):
    """ManagedClusterPodIdentityProfile.

    :param enabled: Whether the pod identity addon is enabled.
    :type enabled: bool
    :param allow_network_plugin_kubenet: Customer consent for enabling AAD pod identity addon in
     cluster using Kubenet network plugin.
    :type allow_network_plugin_kubenet: bool
    :param user_assigned_identities: User assigned pod identity settings.
    :type user_assigned_identities:
     list[~azure.mgmt.containerservice.v2021_05_01.models.ManagedClusterPodIdentity]
    :param user_assigned_identity_exceptions: User assigned pod identity exception settings.
    :type user_assigned_identity_exceptions:
     list[~azure.mgmt.containerservice.v2021_05_01.models.ManagedClusterPodIdentityException]
    """

    _attribute_map = {
        'enabled': {'key': 'enabled', 'type': 'bool'},
        'allow_network_plugin_kubenet': {'key': 'allowNetworkPluginKubenet', 'type': 'bool'},
        'user_assigned_identities': {'key': 'userAssignedIdentities', 'type': '[ManagedClusterPodIdentity]'},
        'user_assigned_identity_exceptions': {'key': 'userAssignedIdentityExceptions', 'type': '[ManagedClusterPodIdentityException]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ManagedClusterPodIdentityProfile, self).__init__(**kwargs)
        self.enabled = kwargs.get('enabled', None)
        self.allow_network_plugin_kubenet = kwargs.get('allow_network_plugin_kubenet', None)
        self.user_assigned_identities = kwargs.get('user_assigned_identities', None)
        self.user_assigned_identity_exceptions = kwargs.get('user_assigned_identity_exceptions', None)


class ManagedClusterPodIdentityProvisioningInfo(msrest.serialization.Model):
    """ManagedClusterPodIdentityProvisioningInfo.

    :param error: Pod identity assignment error (if any).
    :type error: ~azure.mgmt.containerservice.v2021_05_01.models.CloudError
    """

    _attribute_map = {
        'error': {'key': 'error', 'type': 'CloudError'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ManagedClusterPodIdentityProvisioningInfo, self).__init__(**kwargs)
        self.error = kwargs.get('error', None)


class ManagedClusterPoolUpgradeProfile(msrest.serialization.Model):
    """The list of available upgrade versions.

    All required parameters must be populated in order to send to Azure.

    :param kubernetes_version: Required. Kubernetes version (major, minor, patch).
    :type kubernetes_version: str
    :param name: Pool name.
    :type name: str
    :param os_type: Required. OsType to be used to specify os type. Choose from Linux and Windows.
     Default to Linux. Possible values include: "Linux", "Windows". Default value: "Linux".
    :type os_type: str or ~azure.mgmt.containerservice.v2021_05_01.models.OSType
    :param upgrades: List of orchestrator types and versions available for upgrade.
    :type upgrades:
     list[~azure.mgmt.containerservice.v2021_05_01.models.ManagedClusterPoolUpgradeProfileUpgradesItem]
    """

    _validation = {
        'kubernetes_version': {'required': True},
        'os_type': {'required': True},
    }

    _attribute_map = {
        'kubernetes_version': {'key': 'kubernetesVersion', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'os_type': {'key': 'osType', 'type': 'str'},
        'upgrades': {'key': 'upgrades', 'type': '[ManagedClusterPoolUpgradeProfileUpgradesItem]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ManagedClusterPoolUpgradeProfile, self).__init__(**kwargs)
        self.kubernetes_version = kwargs['kubernetes_version']
        self.name = kwargs.get('name', None)
        self.os_type = kwargs.get('os_type', "Linux")
        self.upgrades = kwargs.get('upgrades', None)


class ManagedClusterPoolUpgradeProfileUpgradesItem(msrest.serialization.Model):
    """ManagedClusterPoolUpgradeProfileUpgradesItem.

    :param kubernetes_version: Kubernetes version (major, minor, patch).
    :type kubernetes_version: str
    :param is_preview: Whether Kubernetes version is currently in preview.
    :type is_preview: bool
    """

    _attribute_map = {
        'kubernetes_version': {'key': 'kubernetesVersion', 'type': 'str'},
        'is_preview': {'key': 'isPreview', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ManagedClusterPoolUpgradeProfileUpgradesItem, self).__init__(**kwargs)
        self.kubernetes_version = kwargs.get('kubernetes_version', None)
        self.is_preview = kwargs.get('is_preview', None)


class ManagedClusterPropertiesAutoScalerProfile(msrest.serialization.Model):
    """Parameters to be applied to the cluster-autoscaler when enabled.

    :param balance_similar_node_groups:
    :type balance_similar_node_groups: str
    :param expander:  Possible values include: "least-waste", "most-pods", "priority", "random".
    :type expander: str or ~azure.mgmt.containerservice.v2021_05_01.models.Expander
    :param max_empty_bulk_delete:
    :type max_empty_bulk_delete: str
    :param max_graceful_termination_sec:
    :type max_graceful_termination_sec: str
    :param max_node_provision_time:
    :type max_node_provision_time: str
    :param max_total_unready_percentage:
    :type max_total_unready_percentage: str
    :param new_pod_scale_up_delay:
    :type new_pod_scale_up_delay: str
    :param ok_total_unready_count:
    :type ok_total_unready_count: str
    :param scan_interval:
    :type scan_interval: str
    :param scale_down_delay_after_add:
    :type scale_down_delay_after_add: str
    :param scale_down_delay_after_delete:
    :type scale_down_delay_after_delete: str
    :param scale_down_delay_after_failure:
    :type scale_down_delay_after_failure: str
    :param scale_down_unneeded_time:
    :type scale_down_unneeded_time: str
    :param scale_down_unready_time:
    :type scale_down_unready_time: str
    :param scale_down_utilization_threshold:
    :type scale_down_utilization_threshold: str
    :param skip_nodes_with_local_storage:
    :type skip_nodes_with_local_storage: str
    :param skip_nodes_with_system_pods:
    :type skip_nodes_with_system_pods: str
    """

    _attribute_map = {
        'balance_similar_node_groups': {'key': 'balance-similar-node-groups', 'type': 'str'},
        'expander': {'key': 'expander', 'type': 'str'},
        'max_empty_bulk_delete': {'key': 'max-empty-bulk-delete', 'type': 'str'},
        'max_graceful_termination_sec': {'key': 'max-graceful-termination-sec', 'type': 'str'},
        'max_node_provision_time': {'key': 'max-node-provision-time', 'type': 'str'},
        'max_total_unready_percentage': {'key': 'max-total-unready-percentage', 'type': 'str'},
        'new_pod_scale_up_delay': {'key': 'new-pod-scale-up-delay', 'type': 'str'},
        'ok_total_unready_count': {'key': 'ok-total-unready-count', 'type': 'str'},
        'scan_interval': {'key': 'scan-interval', 'type': 'str'},
        'scale_down_delay_after_add': {'key': 'scale-down-delay-after-add', 'type': 'str'},
        'scale_down_delay_after_delete': {'key': 'scale-down-delay-after-delete', 'type': 'str'},
        'scale_down_delay_after_failure': {'key': 'scale-down-delay-after-failure', 'type': 'str'},
        'scale_down_unneeded_time': {'key': 'scale-down-unneeded-time', 'type': 'str'},
        'scale_down_unready_time': {'key': 'scale-down-unready-time', 'type': 'str'},
        'scale_down_utilization_threshold': {'key': 'scale-down-utilization-threshold', 'type': 'str'},
        'skip_nodes_with_local_storage': {'key': 'skip-nodes-with-local-storage', 'type': 'str'},
        'skip_nodes_with_system_pods': {'key': 'skip-nodes-with-system-pods', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ManagedClusterPropertiesAutoScalerProfile, self).__init__(**kwargs)
        self.balance_similar_node_groups = kwargs.get('balance_similar_node_groups', None)
        self.expander = kwargs.get('expander', None)
        self.max_empty_bulk_delete = kwargs.get('max_empty_bulk_delete', None)
        self.max_graceful_termination_sec = kwargs.get('max_graceful_termination_sec', None)
        self.max_node_provision_time = kwargs.get('max_node_provision_time', None)
        self.max_total_unready_percentage = kwargs.get('max_total_unready_percentage', None)
        self.new_pod_scale_up_delay = kwargs.get('new_pod_scale_up_delay', None)
        self.ok_total_unready_count = kwargs.get('ok_total_unready_count', None)
        self.scan_interval = kwargs.get('scan_interval', None)
        self.scale_down_delay_after_add = kwargs.get('scale_down_delay_after_add', None)
        self.scale_down_delay_after_delete = kwargs.get('scale_down_delay_after_delete', None)
        self.scale_down_delay_after_failure = kwargs.get('scale_down_delay_after_failure', None)
        self.scale_down_unneeded_time = kwargs.get('scale_down_unneeded_time', None)
        self.scale_down_unready_time = kwargs.get('scale_down_unready_time', None)
        self.scale_down_utilization_threshold = kwargs.get('scale_down_utilization_threshold', None)
        self.skip_nodes_with_local_storage = kwargs.get('skip_nodes_with_local_storage', None)
        self.skip_nodes_with_system_pods = kwargs.get('skip_nodes_with_system_pods', None)


class ManagedClusterServicePrincipalProfile(msrest.serialization.Model):
    """Information about a service principal identity for the cluster to use for manipulating Azure APIs.

    All required parameters must be populated in order to send to Azure.

    :param client_id: Required. The ID for the service principal.
    :type client_id: str
    :param secret: The secret password associated with the service principal in plain text.
    :type secret: str
    """

    _validation = {
        'client_id': {'required': True},
    }

    _attribute_map = {
        'client_id': {'key': 'clientId', 'type': 'str'},
        'secret': {'key': 'secret', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ManagedClusterServicePrincipalProfile, self).__init__(**kwargs)
        self.client_id = kwargs['client_id']
        self.secret = kwargs.get('secret', None)


class ManagedClusterSKU(msrest.serialization.Model):
    """ManagedClusterSKU.

    :param name: Name of a managed cluster SKU. Possible values include: "Basic".
    :type name: str or ~azure.mgmt.containerservice.v2021_05_01.models.ManagedClusterSKUName
    :param tier: Tier of a managed cluster SKU. Possible values include: "Paid", "Free".
    :type tier: str or ~azure.mgmt.containerservice.v2021_05_01.models.ManagedClusterSKUTier
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'tier': {'key': 'tier', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ManagedClusterSKU, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.tier = kwargs.get('tier', None)


class ManagedClusterUpgradeProfile(msrest.serialization.Model):
    """The list of available upgrades for compute pools.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Id of upgrade profile.
    :vartype id: str
    :ivar name: Name of upgrade profile.
    :vartype name: str
    :ivar type: Type of upgrade profile.
    :vartype type: str
    :param control_plane_profile: Required. The list of available upgrade versions for the control
     plane.
    :type control_plane_profile:
     ~azure.mgmt.containerservice.v2021_05_01.models.ManagedClusterPoolUpgradeProfile
    :param agent_pool_profiles: Required. The list of available upgrade versions for agent pools.
    :type agent_pool_profiles:
     list[~azure.mgmt.containerservice.v2021_05_01.models.ManagedClusterPoolUpgradeProfile]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'control_plane_profile': {'required': True},
        'agent_pool_profiles': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'control_plane_profile': {'key': 'properties.controlPlaneProfile', 'type': 'ManagedClusterPoolUpgradeProfile'},
        'agent_pool_profiles': {'key': 'properties.agentPoolProfiles', 'type': '[ManagedClusterPoolUpgradeProfile]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ManagedClusterUpgradeProfile, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.control_plane_profile = kwargs['control_plane_profile']
        self.agent_pool_profiles = kwargs['agent_pool_profiles']


class ManagedClusterWindowsProfile(msrest.serialization.Model):
    """Profile for Windows VMs in the container service cluster.

    All required parameters must be populated in order to send to Azure.

    :param admin_username: Required. Specifies the name of the administrator account.
     :code:`<br>`:code:`<br>` **restriction:** Cannot end in "." :code:`<br>`:code:`<br>`
     **Disallowed values:** "administrator", "admin", "user", "user1", "test", "user2", "test1",
     "user3", "admin1", "1", "123", "a", "actuser", "adm", "admin2", "aspnet", "backup", "console",
     "david", "guest", "john", "owner", "root", "server", "sql", "support", "support_388945a0",
     "sys", "test2", "test3", "user4", "user5". :code:`<br>`:code:`<br>` **Minimum-length:** 1
     character :code:`<br>`:code:`<br>` **Max-length:** 20 characters.
    :type admin_username: str
    :param admin_password: Specifies the password of the administrator account.
     :code:`<br>`:code:`<br>` **Minimum-length:** 8 characters :code:`<br>`:code:`<br>`
     **Max-length:** 123 characters :code:`<br>`:code:`<br>` **Complexity requirements:** 3 out of 4
     conditions below need to be fulfilled :code:`<br>` Has lower characters :code:`<br>`Has upper
     characters :code:`<br>` Has a digit :code:`<br>` Has a special character (Regex match [\W_])
     :code:`<br>`:code:`<br>` **Disallowed values:** "abc@123", "P@$$w0rd", "P@ssw0rd",
     "P@ssword123", "Pa$$word", "pass@word1", "Password!", "Password1", "Password22", "iloveyou!".
    :type admin_password: str
    :param license_type: The licenseType to use for Windows VMs. Windows_Server is used to enable
     Azure Hybrid User Benefits for Windows VMs. Possible values include: "None", "Windows_Server".
    :type license_type: str or ~azure.mgmt.containerservice.v2021_05_01.models.LicenseType
    :param enable_csi_proxy: Whether to enable CSI proxy.
    :type enable_csi_proxy: bool
    """

    _validation = {
        'admin_username': {'required': True},
    }

    _attribute_map = {
        'admin_username': {'key': 'adminUsername', 'type': 'str'},
        'admin_password': {'key': 'adminPassword', 'type': 'str'},
        'license_type': {'key': 'licenseType', 'type': 'str'},
        'enable_csi_proxy': {'key': 'enableCSIProxy', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ManagedClusterWindowsProfile, self).__init__(**kwargs)
        self.admin_username = kwargs['admin_username']
        self.admin_password = kwargs.get('admin_password', None)
        self.license_type = kwargs.get('license_type', None)
        self.enable_csi_proxy = kwargs.get('enable_csi_proxy', None)


class OperationListResult(msrest.serialization.Model):
    """The List Compute Operation operation response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of compute operations.
    :vartype value: list[~azure.mgmt.containerservice.v2021_05_01.models.OperationValue]
    """

    _validation = {
        'value': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[OperationValue]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationListResult, self).__init__(**kwargs)
        self.value = None


class OperationValue(msrest.serialization.Model):
    """Describes the properties of a Compute Operation value.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar origin: The origin of the compute operation.
    :vartype origin: str
    :ivar name: The name of the compute operation.
    :vartype name: str
    :ivar operation: The display name of the compute operation.
    :vartype operation: str
    :ivar resource: The display name of the resource the operation applies to.
    :vartype resource: str
    :ivar description: The description of the operation.
    :vartype description: str
    :ivar provider: The resource provider for the operation.
    :vartype provider: str
    """

    _validation = {
        'origin': {'readonly': True},
        'name': {'readonly': True},
        'operation': {'readonly': True},
        'resource': {'readonly': True},
        'description': {'readonly': True},
        'provider': {'readonly': True},
    }

    _attribute_map = {
        'origin': {'key': 'origin', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'operation': {'key': 'display.operation', 'type': 'str'},
        'resource': {'key': 'display.resource', 'type': 'str'},
        'description': {'key': 'display.description', 'type': 'str'},
        'provider': {'key': 'display.provider', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationValue, self).__init__(**kwargs)
        self.origin = None
        self.name = None
        self.operation = None
        self.resource = None
        self.description = None
        self.provider = None


class OSOptionProfile(msrest.serialization.Model):
    """The OS option profile.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Id of the OS option profile.
    :vartype id: str
    :ivar name: Name of the OS option profile.
    :vartype name: str
    :ivar type: Type of the OS option profile.
    :vartype type: str
    :param os_option_property_list: Required. The list of OS option properties.
    :type os_option_property_list:
     list[~azure.mgmt.containerservice.v2021_05_01.models.OSOptionProperty]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'os_option_property_list': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'os_option_property_list': {'key': 'properties.osOptionPropertyList', 'type': '[OSOptionProperty]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OSOptionProfile, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.os_option_property_list = kwargs['os_option_property_list']


class OSOptionProperty(msrest.serialization.Model):
    """OS option property.

    All required parameters must be populated in order to send to Azure.

    :param os_type: Required. OS type.
    :type os_type: str
    :param enable_fips_image: Required. Whether FIPS image is enabled.
    :type enable_fips_image: bool
    """

    _validation = {
        'os_type': {'required': True},
        'enable_fips_image': {'required': True},
    }

    _attribute_map = {
        'os_type': {'key': 'os-type', 'type': 'str'},
        'enable_fips_image': {'key': 'enable-fips-image', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OSOptionProperty, self).__init__(**kwargs)
        self.os_type = kwargs['os_type']
        self.enable_fips_image = kwargs['enable_fips_image']


class OutboundEnvironmentEndpoint(msrest.serialization.Model):
    """Egress endpoints which AKS agent nodes connect to for common purpose.

    :param category: The category of endpoints accessed by the AKS agent node, e.g.
     azure-resource-management, apiserver, etc.
    :type category: str
    :param endpoints: The endpoints that AKS agent nodes connect to.
    :type endpoints: list[~azure.mgmt.containerservice.v2021_05_01.models.EndpointDependency]
    """

    _attribute_map = {
        'category': {'key': 'category', 'type': 'str'},
        'endpoints': {'key': 'endpoints', 'type': '[EndpointDependency]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OutboundEnvironmentEndpoint, self).__init__(**kwargs)
        self.category = kwargs.get('category', None)
        self.endpoints = kwargs.get('endpoints', None)


class OutboundEnvironmentEndpointCollection(msrest.serialization.Model):
    """Collection of OutboundEnvironmentEndpoint.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Collection of resources.
    :type value: list[~azure.mgmt.containerservice.v2021_05_01.models.OutboundEnvironmentEndpoint]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[OutboundEnvironmentEndpoint]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OutboundEnvironmentEndpointCollection, self).__init__(**kwargs)
        self.value = kwargs['value']
        self.next_link = None


class PowerState(msrest.serialization.Model):
    """Describes the Power State of the cluster.

    :param code: Tells whether the cluster is Running or Stopped. Possible values include:
     "Running", "Stopped".
    :type code: str or ~azure.mgmt.containerservice.v2021_05_01.models.Code
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PowerState, self).__init__(**kwargs)
        self.code = kwargs.get('code', None)


class PrivateEndpoint(msrest.serialization.Model):
    """Private endpoint which a connection belongs to.

    :param id: The resource Id for private endpoint.
    :type id: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PrivateEndpoint, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)


class PrivateEndpointConnection(msrest.serialization.Model):
    """A private endpoint connection.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The ID of the private endpoint connection.
    :vartype id: str
    :ivar name: The name of the private endpoint connection.
    :vartype name: str
    :ivar type: The resource type.
    :vartype type: str
    :ivar provisioning_state: The current provisioning state. Possible values include: "Succeeded",
     "Creating", "Deleting", "Failed".
    :vartype provisioning_state: str or
     ~azure.mgmt.containerservice.v2021_05_01.models.PrivateEndpointConnectionProvisioningState
    :param private_endpoint: The resource of private endpoint.
    :type private_endpoint: ~azure.mgmt.containerservice.v2021_05_01.models.PrivateEndpoint
    :param private_link_service_connection_state: A collection of information about the state of
     the connection between service consumer and provider.
    :type private_link_service_connection_state:
     ~azure.mgmt.containerservice.v2021_05_01.models.PrivateLinkServiceConnectionState
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'private_endpoint': {'key': 'properties.privateEndpoint', 'type': 'PrivateEndpoint'},
        'private_link_service_connection_state': {'key': 'properties.privateLinkServiceConnectionState', 'type': 'PrivateLinkServiceConnectionState'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PrivateEndpointConnection, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.provisioning_state = None
        self.private_endpoint = kwargs.get('private_endpoint', None)
        self.private_link_service_connection_state = kwargs.get('private_link_service_connection_state', None)


class PrivateEndpointConnectionListResult(msrest.serialization.Model):
    """A list of private endpoint connections.

    :param value: The collection value.
    :type value: list[~azure.mgmt.containerservice.v2021_05_01.models.PrivateEndpointConnection]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[PrivateEndpointConnection]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PrivateEndpointConnectionListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)


class PrivateLinkResource(msrest.serialization.Model):
    """A private link resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: The ID of the private link resource.
    :type id: str
    :param name: The name of the private link resource.
    :type name: str
    :param type: The resource type.
    :type type: str
    :param group_id: The group ID of the resource.
    :type group_id: str
    :param required_members: RequiredMembers of the resource.
    :type required_members: list[str]
    :ivar private_link_service_id: The private link service ID of the resource, this field is
     exposed only to NRP internally.
    :vartype private_link_service_id: str
    """

    _validation = {
        'private_link_service_id': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'group_id': {'key': 'groupId', 'type': 'str'},
        'required_members': {'key': 'requiredMembers', 'type': '[str]'},
        'private_link_service_id': {'key': 'privateLinkServiceID', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PrivateLinkResource, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.name = kwargs.get('name', None)
        self.type = kwargs.get('type', None)
        self.group_id = kwargs.get('group_id', None)
        self.required_members = kwargs.get('required_members', None)
        self.private_link_service_id = None


class PrivateLinkResourcesListResult(msrest.serialization.Model):
    """A list of private link resources.

    :param value: The collection value.
    :type value: list[~azure.mgmt.containerservice.v2021_05_01.models.PrivateLinkResource]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[PrivateLinkResource]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PrivateLinkResourcesListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)


class PrivateLinkServiceConnectionState(msrest.serialization.Model):
    """The state of a private link service connection.

    :param status: The private link service connection status. Possible values include: "Pending",
     "Approved", "Rejected", "Disconnected".
    :type status: str or ~azure.mgmt.containerservice.v2021_05_01.models.ConnectionStatus
    :param description: The private link service connection description.
    :type description: str
    """

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PrivateLinkServiceConnectionState, self).__init__(**kwargs)
        self.status = kwargs.get('status', None)
        self.description = kwargs.get('description', None)


class ResourceReference(msrest.serialization.Model):
    """A reference to an Azure resource.

    :param id: The fully qualified Azure resource id.
    :type id: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ResourceReference, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)


class RunCommandRequest(msrest.serialization.Model):
    """run command request.

    All required parameters must be populated in order to send to Azure.

    :param command: Required. command to run.
    :type command: str
    :param context: base64 encoded zip file, contains files required by the command.
    :type context: str
    :param cluster_token: AuthToken issued for AKS AAD Server App.
    :type cluster_token: str
    """

    _validation = {
        'command': {'required': True},
    }

    _attribute_map = {
        'command': {'key': 'command', 'type': 'str'},
        'context': {'key': 'context', 'type': 'str'},
        'cluster_token': {'key': 'clusterToken', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RunCommandRequest, self).__init__(**kwargs)
        self.command = kwargs['command']
        self.context = kwargs.get('context', None)
        self.cluster_token = kwargs.get('cluster_token', None)


class RunCommandResult(msrest.serialization.Model):
    """run command result.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: command id.
    :vartype id: str
    :ivar provisioning_state: provisioning State.
    :vartype provisioning_state: str
    :ivar exit_code: exit code of the command.
    :vartype exit_code: int
    :ivar started_at: time when the command started.
    :vartype started_at: ~datetime.datetime
    :ivar finished_at: time when the command finished.
    :vartype finished_at: ~datetime.datetime
    :ivar logs: command output.
    :vartype logs: str
    :ivar reason: explain why provisioningState is set to failed (if so).
    :vartype reason: str
    """

    _validation = {
        'id': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'exit_code': {'readonly': True},
        'started_at': {'readonly': True},
        'finished_at': {'readonly': True},
        'logs': {'readonly': True},
        'reason': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'exit_code': {'key': 'properties.exitCode', 'type': 'int'},
        'started_at': {'key': 'properties.startedAt', 'type': 'iso-8601'},
        'finished_at': {'key': 'properties.finishedAt', 'type': 'iso-8601'},
        'logs': {'key': 'properties.logs', 'type': 'str'},
        'reason': {'key': 'properties.reason', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RunCommandResult, self).__init__(**kwargs)
        self.id = None
        self.provisioning_state = None
        self.exit_code = None
        self.started_at = None
        self.finished_at = None
        self.logs = None
        self.reason = None


class SysctlConfig(msrest.serialization.Model):
    """Sysctl settings for Linux agent nodes.

    :param net_core_somaxconn: Sysctl setting net.core.somaxconn.
    :type net_core_somaxconn: int
    :param net_core_netdev_max_backlog: Sysctl setting net.core.netdev_max_backlog.
    :type net_core_netdev_max_backlog: int
    :param net_core_rmem_default: Sysctl setting net.core.rmem_default.
    :type net_core_rmem_default: int
    :param net_core_rmem_max: Sysctl setting net.core.rmem_max.
    :type net_core_rmem_max: int
    :param net_core_wmem_default: Sysctl setting net.core.wmem_default.
    :type net_core_wmem_default: int
    :param net_core_wmem_max: Sysctl setting net.core.wmem_max.
    :type net_core_wmem_max: int
    :param net_core_optmem_max: Sysctl setting net.core.optmem_max.
    :type net_core_optmem_max: int
    :param net_ipv4_tcp_max_syn_backlog: Sysctl setting net.ipv4.tcp_max_syn_backlog.
    :type net_ipv4_tcp_max_syn_backlog: int
    :param net_ipv4_tcp_max_tw_buckets: Sysctl setting net.ipv4.tcp_max_tw_buckets.
    :type net_ipv4_tcp_max_tw_buckets: int
    :param net_ipv4_tcp_fin_timeout: Sysctl setting net.ipv4.tcp_fin_timeout.
    :type net_ipv4_tcp_fin_timeout: int
    :param net_ipv4_tcp_keepalive_time: Sysctl setting net.ipv4.tcp_keepalive_time.
    :type net_ipv4_tcp_keepalive_time: int
    :param net_ipv4_tcp_keepalive_probes: Sysctl setting net.ipv4.tcp_keepalive_probes.
    :type net_ipv4_tcp_keepalive_probes: int
    :param net_ipv4_tcpkeepalive_intvl: Sysctl setting net.ipv4.tcp_keepalive_intvl.
    :type net_ipv4_tcpkeepalive_intvl: int
    :param net_ipv4_tcp_tw_reuse: Sysctl setting net.ipv4.tcp_tw_reuse.
    :type net_ipv4_tcp_tw_reuse: bool
    :param net_ipv4_ip_local_port_range: Sysctl setting net.ipv4.ip_local_port_range.
    :type net_ipv4_ip_local_port_range: str
    :param net_ipv4_neigh_default_gc_thresh1: Sysctl setting net.ipv4.neigh.default.gc_thresh1.
    :type net_ipv4_neigh_default_gc_thresh1: int
    :param net_ipv4_neigh_default_gc_thresh2: Sysctl setting net.ipv4.neigh.default.gc_thresh2.
    :type net_ipv4_neigh_default_gc_thresh2: int
    :param net_ipv4_neigh_default_gc_thresh3: Sysctl setting net.ipv4.neigh.default.gc_thresh3.
    :type net_ipv4_neigh_default_gc_thresh3: int
    :param net_netfilter_nf_conntrack_max: Sysctl setting net.netfilter.nf_conntrack_max.
    :type net_netfilter_nf_conntrack_max: int
    :param net_netfilter_nf_conntrack_buckets: Sysctl setting net.netfilter.nf_conntrack_buckets.
    :type net_netfilter_nf_conntrack_buckets: int
    :param fs_inotify_max_user_watches: Sysctl setting fs.inotify.max_user_watches.
    :type fs_inotify_max_user_watches: int
    :param fs_file_max: Sysctl setting fs.file-max.
    :type fs_file_max: int
    :param fs_aio_max_nr: Sysctl setting fs.aio-max-nr.
    :type fs_aio_max_nr: int
    :param fs_nr_open: Sysctl setting fs.nr_open.
    :type fs_nr_open: int
    :param kernel_threads_max: Sysctl setting kernel.threads-max.
    :type kernel_threads_max: int
    :param vm_max_map_count: Sysctl setting vm.max_map_count.
    :type vm_max_map_count: int
    :param vm_swappiness: Sysctl setting vm.swappiness.
    :type vm_swappiness: int
    :param vm_vfs_cache_pressure: Sysctl setting vm.vfs_cache_pressure.
    :type vm_vfs_cache_pressure: int
    """

    _attribute_map = {
        'net_core_somaxconn': {'key': 'netCoreSomaxconn', 'type': 'int'},
        'net_core_netdev_max_backlog': {'key': 'netCoreNetdevMaxBacklog', 'type': 'int'},
        'net_core_rmem_default': {'key': 'netCoreRmemDefault', 'type': 'int'},
        'net_core_rmem_max': {'key': 'netCoreRmemMax', 'type': 'int'},
        'net_core_wmem_default': {'key': 'netCoreWmemDefault', 'type': 'int'},
        'net_core_wmem_max': {'key': 'netCoreWmemMax', 'type': 'int'},
        'net_core_optmem_max': {'key': 'netCoreOptmemMax', 'type': 'int'},
        'net_ipv4_tcp_max_syn_backlog': {'key': 'netIpv4TcpMaxSynBacklog', 'type': 'int'},
        'net_ipv4_tcp_max_tw_buckets': {'key': 'netIpv4TcpMaxTwBuckets', 'type': 'int'},
        'net_ipv4_tcp_fin_timeout': {'key': 'netIpv4TcpFinTimeout', 'type': 'int'},
        'net_ipv4_tcp_keepalive_time': {'key': 'netIpv4TcpKeepaliveTime', 'type': 'int'},
        'net_ipv4_tcp_keepalive_probes': {'key': 'netIpv4TcpKeepaliveProbes', 'type': 'int'},
        'net_ipv4_tcpkeepalive_intvl': {'key': 'netIpv4TcpkeepaliveIntvl', 'type': 'int'},
        'net_ipv4_tcp_tw_reuse': {'key': 'netIpv4TcpTwReuse', 'type': 'bool'},
        'net_ipv4_ip_local_port_range': {'key': 'netIpv4IpLocalPortRange', 'type': 'str'},
        'net_ipv4_neigh_default_gc_thresh1': {'key': 'netIpv4NeighDefaultGcThresh1', 'type': 'int'},
        'net_ipv4_neigh_default_gc_thresh2': {'key': 'netIpv4NeighDefaultGcThresh2', 'type': 'int'},
        'net_ipv4_neigh_default_gc_thresh3': {'key': 'netIpv4NeighDefaultGcThresh3', 'type': 'int'},
        'net_netfilter_nf_conntrack_max': {'key': 'netNetfilterNfConntrackMax', 'type': 'int'},
        'net_netfilter_nf_conntrack_buckets': {'key': 'netNetfilterNfConntrackBuckets', 'type': 'int'},
        'fs_inotify_max_user_watches': {'key': 'fsInotifyMaxUserWatches', 'type': 'int'},
        'fs_file_max': {'key': 'fsFileMax', 'type': 'int'},
        'fs_aio_max_nr': {'key': 'fsAioMaxNr', 'type': 'int'},
        'fs_nr_open': {'key': 'fsNrOpen', 'type': 'int'},
        'kernel_threads_max': {'key': 'kernelThreadsMax', 'type': 'int'},
        'vm_max_map_count': {'key': 'vmMaxMapCount', 'type': 'int'},
        'vm_swappiness': {'key': 'vmSwappiness', 'type': 'int'},
        'vm_vfs_cache_pressure': {'key': 'vmVfsCachePressure', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SysctlConfig, self).__init__(**kwargs)
        self.net_core_somaxconn = kwargs.get('net_core_somaxconn', None)
        self.net_core_netdev_max_backlog = kwargs.get('net_core_netdev_max_backlog', None)
        self.net_core_rmem_default = kwargs.get('net_core_rmem_default', None)
        self.net_core_rmem_max = kwargs.get('net_core_rmem_max', None)
        self.net_core_wmem_default = kwargs.get('net_core_wmem_default', None)
        self.net_core_wmem_max = kwargs.get('net_core_wmem_max', None)
        self.net_core_optmem_max = kwargs.get('net_core_optmem_max', None)
        self.net_ipv4_tcp_max_syn_backlog = kwargs.get('net_ipv4_tcp_max_syn_backlog', None)
        self.net_ipv4_tcp_max_tw_buckets = kwargs.get('net_ipv4_tcp_max_tw_buckets', None)
        self.net_ipv4_tcp_fin_timeout = kwargs.get('net_ipv4_tcp_fin_timeout', None)
        self.net_ipv4_tcp_keepalive_time = kwargs.get('net_ipv4_tcp_keepalive_time', None)
        self.net_ipv4_tcp_keepalive_probes = kwargs.get('net_ipv4_tcp_keepalive_probes', None)
        self.net_ipv4_tcpkeepalive_intvl = kwargs.get('net_ipv4_tcpkeepalive_intvl', None)
        self.net_ipv4_tcp_tw_reuse = kwargs.get('net_ipv4_tcp_tw_reuse', None)
        self.net_ipv4_ip_local_port_range = kwargs.get('net_ipv4_ip_local_port_range', None)
        self.net_ipv4_neigh_default_gc_thresh1 = kwargs.get('net_ipv4_neigh_default_gc_thresh1', None)
        self.net_ipv4_neigh_default_gc_thresh2 = kwargs.get('net_ipv4_neigh_default_gc_thresh2', None)
        self.net_ipv4_neigh_default_gc_thresh3 = kwargs.get('net_ipv4_neigh_default_gc_thresh3', None)
        self.net_netfilter_nf_conntrack_max = kwargs.get('net_netfilter_nf_conntrack_max', None)
        self.net_netfilter_nf_conntrack_buckets = kwargs.get('net_netfilter_nf_conntrack_buckets', None)
        self.fs_inotify_max_user_watches = kwargs.get('fs_inotify_max_user_watches', None)
        self.fs_file_max = kwargs.get('fs_file_max', None)
        self.fs_aio_max_nr = kwargs.get('fs_aio_max_nr', None)
        self.fs_nr_open = kwargs.get('fs_nr_open', None)
        self.kernel_threads_max = kwargs.get('kernel_threads_max', None)
        self.vm_max_map_count = kwargs.get('vm_max_map_count', None)
        self.vm_swappiness = kwargs.get('vm_swappiness', None)
        self.vm_vfs_cache_pressure = kwargs.get('vm_vfs_cache_pressure', None)


class SystemData(msrest.serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :param created_by: The identity that created the resource.
    :type created_by: str
    :param created_by_type: The type of identity that created the resource. Possible values
     include: "User", "Application", "ManagedIdentity", "Key".
    :type created_by_type: str or ~azure.mgmt.containerservice.v2021_05_01.models.CreatedByType
    :param created_at: The timestamp of resource creation (UTC).
    :type created_at: ~datetime.datetime
    :param last_modified_by: The identity that last modified the resource.
    :type last_modified_by: str
    :param last_modified_by_type: The type of identity that last modified the resource. Possible
     values include: "User", "Application", "ManagedIdentity", "Key".
    :type last_modified_by_type: str or
     ~azure.mgmt.containerservice.v2021_05_01.models.CreatedByType
    :param last_modified_at: The type of identity that last modified the resource.
    :type last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        'created_by': {'key': 'createdBy', 'type': 'str'},
        'created_by_type': {'key': 'createdByType', 'type': 'str'},
        'created_at': {'key': 'createdAt', 'type': 'iso-8601'},
        'last_modified_by': {'key': 'lastModifiedBy', 'type': 'str'},
        'last_modified_by_type': {'key': 'lastModifiedByType', 'type': 'str'},
        'last_modified_at': {'key': 'lastModifiedAt', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SystemData, self).__init__(**kwargs)
        self.created_by = kwargs.get('created_by', None)
        self.created_by_type = kwargs.get('created_by_type', None)
        self.created_at = kwargs.get('created_at', None)
        self.last_modified_by = kwargs.get('last_modified_by', None)
        self.last_modified_by_type = kwargs.get('last_modified_by_type', None)
        self.last_modified_at = kwargs.get('last_modified_at', None)


class TagsObject(msrest.serialization.Model):
    """Tags object for patch operations.

    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TagsObject, self).__init__(**kwargs)
        self.tags = kwargs.get('tags', None)


class TimeInWeek(msrest.serialization.Model):
    """Time in a week.

    :param day: A day in a week. Possible values include: "Sunday", "Monday", "Tuesday",
     "Wednesday", "Thursday", "Friday", "Saturday".
    :type day: str or ~azure.mgmt.containerservice.v2021_05_01.models.WeekDay
    :param hour_slots: hour slots in a day.
    :type hour_slots: list[int]
    """

    _attribute_map = {
        'day': {'key': 'day', 'type': 'str'},
        'hour_slots': {'key': 'hourSlots', 'type': '[int]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TimeInWeek, self).__init__(**kwargs)
        self.day = kwargs.get('day', None)
        self.hour_slots = kwargs.get('hour_slots', None)


class TimeSpan(msrest.serialization.Model):
    """The time span with start and end properties.

    :param start: The start of a time span.
    :type start: ~datetime.datetime
    :param end: The end of a time span.
    :type end: ~datetime.datetime
    """

    _attribute_map = {
        'start': {'key': 'start', 'type': 'iso-8601'},
        'end': {'key': 'end', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TimeSpan, self).__init__(**kwargs)
        self.start = kwargs.get('start', None)
        self.end = kwargs.get('end', None)
