# Copyright (c) 2014, The MITRE Corporation. All rights reserved.
# See LICENSE.txt for complete terms.

import unittest

from cybox.test import EntityTestCase

from stix.exploit_target import ExploitTarget


class ExploitTargetTests(EntityTestCase, unittest.TestCase):
    klass = ExploitTarget
    _full_dict = {
        'id': 'example:ExploitTarget-1',
        #idref omitted since it should not have both an ID and an IDREF.
        'timestamp': "2014-04-01T03:17:45",
        'version': '1.1',
        'title': "ExploitTarget 1",
        'description': "This is a long description about an ExploitTarget",
        'short_description': "an ExploitTarget",
        'vulnerabilities': [
            {
                'is_known': False,
                'is_publicly_acknowledged': True,
                'title': "CVE-2012-0158",
                'description': "Vulnerability Description",
                'short_description': "MSCOMCTL.OCX Memory Corruption",
                'cve_id': "CVE-2012-0158",
                'osvdb_id': 81125,
                'source': "NIST",
                'cvss_score': {
                    # These are all fictional and may not be valid
                    'overall_score': "9.3",
                    'base_score': "8.3",
                    'base_vector': "(AV:N/AC:L/Au:N/C:N/I:N/A:P)",
                    'temporal_score': "7.7",
                    'temporal_vector': "(E:U/RL:T/RC:C)",
                    'environmental_score': "2.0",
                    'environmental_vector': "(CPD:ND/TD:ND)",
                },
                'discovered_datetime': {
                    'value': '2010-02-21T00:00:00',
                    'precision': 'day',
                },
                'published_datetime': {
                    'value': '2010-03-01T00:00:00',
                    'precision': 'month',
                },
                'affected_software': {
                    'scope': 'exclusive',
                    'affected_software': [
                        {
                            'observable': {
                                'title': "Observable for some software"
                            },
                            'confidence': {'value': {'value': "Medium", 'xsi:type':'stixVocabs:HighMediumLowVocab-1.0'}}
                        }
                    ]
                },
                # TODO: add support.
                #'references': ["https://web.nvd.nist.gov/"]
            },
        ],
        'weaknesses': [
            {
                'description': "Deadlock",
                'cwe_id': "CWE-833",
            }
        ],
        'configuration': [
            {
                'description': "The 'Games' features should be configured"
                               "correctly.",
                'short_description': "Games feature",
                'cce_id': "CCE-18880-5",
            }
        ],
        'potential_coas': {
            'scope': 'inclusive',
            'coas': [
                {
                    'course_of_action': {
                        'id': 'example:coa-1',
                        'version': '1.1',
                        'timestamp': "2014-03-20T04:35:12",
                        'stage': {'value': 'Remedy', 'xsi:type': 'stixVocabs:COAStageVocab-1.0'},
                        'cost': {
                            "value": {'value': 'High', 'xsi:type': 'stixVocabs:HighMediumLowVocab-1.0'},
                        },
                    }
                }
            ]
        },
        'information_source': {
            'description': "Mr. Evil's enemy",
            'identity': {
                'name': "Ms. Good",
            },
        },
        'handling': [
            {
                'marking_structures': [
                    {
                        'marking_model_name': 'TLP',
                        'color': "RED",
                        'xsi:type': "tlpMarking:TLPMarkingStructureType",
                    }
                ]
            }
        ],
        'related_exploit_targets': {
            'scope': 'inclusive',
            'related_exploit_targets': [
                {
                    'exploit_target': {
                        'id': 'example:ExploitTarget-2',
                        'version': '1.1',
                        'title': "ExploitTarget 2",
                    }
                }
            ]
        },
        'related_packages': {
            'packages': [
                {'idref': "example:Package-AB", 'relationship': "Parent"},
                {'idref': "example:Package-CD", 'relationship': "Child"}
            ]
        }
    }

if __name__ == "__main__":
    unittest.main()
