# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft and contributors.  All rights reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .resource import Resource


class User(Resource):
    """
    Represents user crendentials used for publishing activity

    :param str id: Resource Id
    :param str name: Resource Name
    :param str location: Resource Location
    :param str type: Resource type
    :param dict tags: Resource tags
    :param str user_name: Username (internal)
    :param str publishing_user_name: Username used for publishing
    :param str publishing_password: Password used for publishing
    """

    _required = []

    _attribute_map = {
        'user_name': {'key': 'properties.name', 'type': 'str', 'flatten': True},
        'publishing_user_name': {'key': 'properties.publishingUserName', 'type': 'str', 'flatten': True},
        'publishing_password': {'key': 'properties.publishingPassword', 'type': 'str', 'flatten': True},
    }

    def __init__(self, location, id=None, name=None, type=None, tags=None, user_name=None, publishing_user_name=None, publishing_password=None):
        super(User, self).__init__(id=id, name=name, location=location, type=type, tags=tags)
        self.user_name = user_name
        self.publishing_user_name = publishing_user_name
        self.publishing_password = publishing_password
