# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft and contributors.  All rights reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .resource import Resource


class SlotConfigNamesResource(Resource):
    """
    Slot Config names azure resource

    :param str id: Resource Id
    :param str name: Resource Name
    :param str location: Resource Location
    :param str type: Resource type
    :param dict tags: Resource tags
    :param list connection_string_names: List of connection string names
    :param list app_setting_names: List of application settings names
    """

    _required = []

    _attribute_map = {
        'connection_string_names': {'key': 'properties.connectionStringNames', 'type': '[str]', 'flatten': True},
        'app_setting_names': {'key': 'properties.appSettingNames', 'type': '[str]', 'flatten': True},
    }

    def __init__(self, location, id=None, name=None, type=None, tags=None, connection_string_names=None, app_setting_names=None):
        super(SlotConfigNamesResource, self).__init__(id=id, name=name, location=location, type=type, tags=tags)
        self.connection_string_names = connection_string_names
        self.app_setting_names = app_setting_names
