# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft and contributors.  All rights reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class SlotConfigNames(Model):
    """
    Class containing names for connection strings and application settings to
    be marked as sticky to the slot
    and not moved during swap operation
    This is valid for all deployment slots under the site

    :param list connection_string_names: List of connection string names
    :param list app_setting_names: List of application settings names
    """

    _required = []

    _attribute_map = {
        'connection_string_names': {'key': 'connectionStringNames', 'type': '[str]'},
        'app_setting_names': {'key': 'appSettingNames', 'type': '[str]'},
    }

    def __init__(self, connection_string_names=None, app_setting_names=None):
        self.connection_string_names = connection_string_names
        self.app_setting_names = app_setting_names
