# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft and contributors.  All rights reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .resource import Resource


class ServerFarmWithRichSku(Resource):
    """
    App Service Plan Model

    :param str id: Resource Id
    :param str name: Resource Name
    :param str location: Resource Location
    :param str type: Resource type
    :param dict tags: Resource tags
    :param SkuDescription sku:
    :param str server_farm_with_rich_sku_name: Name for the App Service Plan
    :param str status: App Service Plan Status. Possible values include:
     'Ready', 'Pending'
    :param str subscription: App Service Plan Subscription
    :param str admin_site_name: App Service Plan administration site
    :param HostingEnvironmentProfile hosting_environment_profile:
     Specification for the hosting environment (App Service Environment) to
     use for the App Service Plan
    :param int maximum_number_of_workers: Maximum number of instances that
     can be assigned to this App Service Plan
    :param str geo_region: Geographical location for the App Service Plan
    :param bool per_site_scaling: If True apps assigned to this App Service
     Plan can be scaled independently
     If False apps assigned to this App Service Plan will scale to
     all instances of the plan
    :param int number_of_sites: Number of web apps assigned to this App
     Service Plan
    :param str resource_group: Resource group of the serverfarm
    """

    _required = []

    _attribute_map = {
        'sku': {'key': 'sku', 'type': 'SkuDescription'},
        'server_farm_with_rich_sku_name': {'key': 'properties.name', 'type': 'str', 'flatten': True},
        'status': {'key': 'properties.status', 'type': 'StatusOptions', 'flatten': True},
        'subscription': {'key': 'properties.subscription', 'type': 'str', 'flatten': True},
        'admin_site_name': {'key': 'properties.adminSiteName', 'type': 'str', 'flatten': True},
        'hosting_environment_profile': {'key': 'properties.hostingEnvironmentProfile', 'type': 'HostingEnvironmentProfile', 'flatten': True},
        'maximum_number_of_workers': {'key': 'properties.maximumNumberOfWorkers', 'type': 'int', 'flatten': True},
        'geo_region': {'key': 'properties.geoRegion', 'type': 'str', 'flatten': True},
        'per_site_scaling': {'key': 'properties.perSiteScaling', 'type': 'bool', 'flatten': True},
        'number_of_sites': {'key': 'properties.numberOfSites', 'type': 'int', 'flatten': True},
        'resource_group': {'key': 'properties.resourceGroup', 'type': 'str', 'flatten': True},
    }

    def __init__(self, location, id=None, name=None, type=None, tags=None, sku=None, server_farm_with_rich_sku_name=None, status=None, subscription=None, admin_site_name=None, hosting_environment_profile=None, maximum_number_of_workers=None, geo_region=None, per_site_scaling=None, number_of_sites=None, resource_group=None):
        super(ServerFarmWithRichSku, self).__init__(id=id, name=name, location=location, type=type, tags=tags)
        self.sku = sku
        self.server_farm_with_rich_sku_name = server_farm_with_rich_sku_name
        self.status = status
        self.subscription = subscription
        self.admin_site_name = admin_site_name
        self.hosting_environment_profile = hosting_environment_profile
        self.maximum_number_of_workers = maximum_number_of_workers
        self.geo_region = geo_region
        self.per_site_scaling = per_site_scaling
        self.number_of_sites = number_of_sites
        self.resource_group = resource_group
